package Geo::Coordinates::British_Maps;
use base qw(Exporter);
use strict;
use warnings;
our $VERSION = '2.09';
our @EXPORT_OK = qw(%maps %name_for_map_series);
our %maps;
our %name_for_map_series = ( 
  A => 'OS Landranger', 
  B => 'OS Explorer',
  C => 'OS One-Inch 7th series',
  H => 'Harvey British Mountain Map',
  J => 'Harvey Super Walker',
);
$maps{"A:1"} = { bbox => [[429000, 1179000], [469000, 1219000]], polygon => [[429000,1179000],[469000,1179000],[469000,1219000],[429000,1219000],[429000,1179000]] };
$maps{"A:2"} = { bbox => [[433000, 1156000], [473000, 1196000]], polygon => [[433000,1156000],[473000,1156000],[473000,1196000],[433000,1196000],[433000,1156000]] };
$maps{"A:3"} = { bbox => [[414000, 1147000], [454000, 1187000]], polygon => [[414000,1147000],[454000,1147000],[454000,1187000],[414000,1187000],[414000,1147000]] };
$maps{"A:3 Inset"} = { bbox => [[409000, 1161000], [416000, 1167000]], polygon => [[409000,1161000],[416000,1161000],[416000,1167000],[409000,1167000],[409000,1161000]] };
$maps{"A:4"} = { bbox => [[420000, 1107000], [460000, 1147000]], polygon => [[420000,1107000],[460000,1107000],[460000,1147000],[420000,1147000],[420000,1107000]] };
$maps{"A:4 Inset A"} = { bbox => [[392000, 1135000], [400000, 1143000]], polygon => [[392000,1135000],[400000,1135000],[400000,1143000],[392000,1143000],[392000,1135000]] };
$maps{"A:4 Inset B"} = { bbox => [[417000, 1068000], [425000, 1076000]], polygon => [[417000,1068000],[425000,1068000],[425000,1076000],[417000,1076000],[417000,1068000]] };
$maps{"A:5"} = { bbox => [[340000, 1020000], [380000, 1060000]], polygon => [[340000,1020000],[380000,1020000],[380000,1060000],[340000,1060000],[340000,1020000]] };
$maps{"A:5 Inset"} = { bbox => [[366000, 1015000], [369000, 1018000]], polygon => [[366000,1015000],[369000,1015000],[369000,1018000],[366000,1018000],[366000,1015000]] };
$maps{"A:6"} = { bbox => [[321000, 996000], [361000, 1036000]], polygon => [[321000,996000],[361000,996000],[361000,1036000],[321000,1036000],[321000,996000]] };
$maps{"A:6 Inset A"} = { bbox => [[261000, 1023000], [264000, 1025000]], polygon => [[261000,1023000],[264000,1023000],[264000,1025000],[261000,1025000],[261000,1023000]] };
$maps{"A:6 Inset B"} = { bbox => [[255000, 1017000], [258000, 1019000]], polygon => [[255000,1017000],[258000,1017000],[258000,1019000],[255000,1019000],[255000,1017000]] };
$maps{"A:7"} = { bbox => [[315000, 970000], [355000, 1010000]], polygon => [[315000,970000],[355000,970000],[355000,1010000],[315000,1010000],[315000,970000]] };
$maps{"A:8"} = { bbox => [[117000, 926000], [157000, 967000]], polygon => [[117000,926000],[157000,926000],[157000,966000],[153000,966000],[153000,967000],[151000,967000],[151000,966000],[117000,966000],[117000,926000]] };
$maps{"A:8 Inset A"} = { bbox => [[179000, 1030000], [184000, 1035000]], polygon => [[179000,1030000],[184000,1030000],[184000,1035000],[179000,1035000],[179000,1030000]] };
$maps{"A:8 Inset B"} = { bbox => [[159000, 1028000], [164000, 1033000]], polygon => [[159000,1028000],[164000,1028000],[164000,1033000],[159000,1033000],[159000,1028000]] };
$maps{"A:9"} = { bbox => [[212000, 940000], [252000, 980000]], polygon => [[212000,940000],[252000,940000],[252000,980000],[212000,980000],[212000,940000]] };
$maps{"A:10"} = { bbox => [[252000, 940000], [292000, 980000]], polygon => [[252000,940000],[292000,940000],[292000,980000],[252000,980000],[252000,940000]] };
$maps{"A:11"} = { bbox => [[292000, 929000], [332000, 969000]], polygon => [[292000,929000],[332000,929000],[332000,969000],[292000,969000],[292000,929000]] };
$maps{"A:12"} = { bbox => [[300000, 939000], [340000, 979000]], polygon => [[300000,939000],[340000,939000],[340000,979000],[300000,979000],[300000,939000]] };
$maps{"A:13"} = { bbox => [[95000, 903000], [135000, 943000]], polygon => [[95000,903000],[135000,903000],[135000,943000],[95000,943000],[95000,903000]] };
$maps{"A:13 Inset A"} = { bbox => [[68000, 945000], [74000, 947000]], polygon => [[68000,945000],[74000,945000],[74000,947000],[68000,947000],[68000,945000]] };
$maps{"A:13 Inset B"} = { bbox => [[87000, 910000], [89000, 912000]], polygon => [[87000,910000],[89000,910000],[89000,912000],[87000,912000],[87000,910000]] };
$maps{"A:14"} = { bbox => [[105000, 886000], [145000, 926000]], polygon => [[105000,886000],[145000,886000],[145000,926000],[105000,926000],[105000,886000]] };
$maps{"A:15"} = { bbox => [[196000, 900000], [236000, 940000]], polygon => [[196000,900000],[236000,900000],[236000,940000],[196000,940000],[196000,900000]] };
$maps{"A:15 Inset"} = { bbox => [[190000, 901000], [194000, 906000]], polygon => [[190000,901000],[194000,901000],[194000,906000],[190000,906000],[190000,901000]] };
$maps{"A:16"} = { bbox => [[236000, 900000], [276000, 940000]], polygon => [[236000,900000],[276000,900000],[276000,940000],[236000,940000],[236000,900000]] };
$maps{"A:17"} = { bbox => [[276000, 900000], [316000, 940000]], polygon => [[276000,900000],[316000,900000],[316000,940000],[276000,940000],[276000,900000]] };
$maps{"A:18"} = { bbox => [[69000, 863000], [109000, 903000]], polygon => [[69000,863000],[109000,863000],[109000,903000],[69000,903000],[69000,863000]] };
$maps{"A:18 Inset A"} = { bbox => [[5000, 896000], [17000, 907000]], polygon => [[5000,896000],[17000,896000],[17000,907000],[5000,907000],[5000,896000]] };
$maps{"A:18 Inset B"} = { bbox => [[64000, 866000], [70000, 872000]], polygon => [[64000,866000],[70000,866000],[70000,872000],[64000,872000],[64000,866000]] };
$maps{"A:18 Inset C"} = { bbox => [[59000, 880000], [63000, 883000]], polygon => [[59000,880000],[63000,880000],[63000,883000],[59000,883000],[59000,880000]] };
$maps{"A:19"} = { bbox => [[172000, 860000], [214000, 900300]], polygon => [[174000,860000],[214000,860000],[214000,900000],[210300,900000],[210000,900300],[208500,900300],[208150,900000],[174000,900000],[174000,892300],[172000,892000],[172000,866000],[174000,866000],[174000,860000]] };
$maps{"A:20"} = { bbox => [[214000, 860000], [254000, 900000]], polygon => [[214000,860000],[254000,860000],[254000,900000],[214000,900000],[214000,860000]] };
$maps{"A:21"} = { bbox => [[254000, 860000], [294000, 900000]], polygon => [[254000,860000],[294000,860000],[294000,900000],[254000,900000],[254000,860000]] };
$maps{"A:22"} = { bbox => [[57000, 823000], [97000, 863000]], polygon => [[57000,823000],[97000,823000],[97000,863000],[57000,863000],[57000,823000]] };
$maps{"A:22 Inset"} = { bbox => [[56000, 863000], [59000, 866000]], polygon => [[56000,863000],[59000,863000],[59000,866000],[56000,866000],[56000,863000]] };
$maps{"A:23"} = { bbox => [[112500, 835400], [153000, 877000]], polygon => [[113000,836000],[128000,836000],[129000,835400],[132000,835400],[133000,836000],[153000,836000],[153000,876000],[145000,876000],[145000,877000],[139000,877000],[139000,876000],[113000,876000],[113000,851000],[112500,850000],[112500,847000],[113000,846000],[113000,836000]] };
$maps{"A:23 Inset"} = { bbox => [[135000, 876000], [145000, 882000]], polygon => [[135000,876000],[145000,876000],[145000,882000],[135000,882000],[135000,876000]] };
$maps{"A:24"} = { bbox => [[150000, 830000], [190000, 870000]], polygon => [[150000,830000],[190000,830000],[190000,870000],[150000,870000],[150000,830000]] };
$maps{"A:25"} = { bbox => [[190000, 820000], [230000, 860000]], polygon => [[190000,820000],[230000,820000],[230000,860000],[190000,860000],[190000,820000]] };
$maps{"A:26"} = { bbox => [[230000, 820000], [270000, 860000]], polygon => [[230000,820000],[270000,820000],[270000,860000],[230000,860000],[230000,820000]] };
$maps{"A:27"} = { bbox => [[270000, 830000], [310000, 870000]], polygon => [[270000,830000],[310000,830000],[310000,870000],[270000,870000],[270000,830000]] };
$maps{"A:28"} = { bbox => [[310000, 833000], [350000, 873000]], polygon => [[310000,833000],[350000,833000],[350000,873000],[310000,873000],[310000,833000]] };
$maps{"A:29"} = { bbox => [[345000, 830000], [385000, 870000]], polygon => [[345000,830000],[385000,830000],[385000,870000],[345000,870000],[345000,830000]] };
$maps{"A:30"} = { bbox => [[377000, 830000], [417000, 870000]], polygon => [[377000,830000],[417000,830000],[417000,870000],[377000,870000],[377000,830000]] };
$maps{"A:31"} = { bbox => [[50000, 783000], [90000, 823000]], polygon => [[50000,783000],[90000,783000],[90000,823000],[50000,823000],[50000,783000]] };
$maps{"A:31 Inset"} = { bbox => [[53000, 778000], [59000, 786000]], polygon => [[53000,778000],[59000,778000],[59000,786000],[53000,786000],[53000,778000]] };
$maps{"A:32"} = { bbox => [[130000, 799000], [170800, 840000]], polygon => [[130000,800000],[156000,800000],[156000,799000],[158000,799000],[158000,800000],[170000,800000],[170000,832000],[170800,834000],[170000,836000],[170000,840000],[130000,840000],[130000,800000]] };
$maps{"A:33"} = { bbox => [[170000, 790000], [210000, 830000]], polygon => [[170000,790000],[210000,790000],[210000,830000],[170000,830000],[170000,790000]] };
$maps{"A:34"} = { bbox => [[210000, 780000], [250000, 820000]], polygon => [[210000,780000],[250000,780000],[250000,820000],[210000,820000],[210000,780000]] };
$maps{"A:35"} = { bbox => [[250000, 790000], [290000, 830000]], polygon => [[250000,790000],[290000,790000],[290000,830000],[250000,830000],[250000,790000]] };
$maps{"A:36"} = { bbox => [[285000, 793000], [325000, 833000]], polygon => [[285000,793000],[325000,793000],[325000,833000],[285000,833000],[285000,793000]] };
$maps{"A:37"} = { bbox => [[325000, 793000], [365000, 833000]], polygon => [[325000,793000],[365000,793000],[365000,833000],[325000,833000],[325000,793000]] };
$maps{"A:38"} = { bbox => [[365000, 790000], [405000, 830000]], polygon => [[365000,790000],[405000,790000],[405000,830000],[365000,830000],[365000,790000]] };
$maps{"A:39"} = { bbox => [[120000, 770000], [160000, 810000]], polygon => [[120000,770000],[160000,770000],[160000,810000],[120000,810000],[120000,770000]] };
$maps{"A:39 Inset"} = { bbox => [[114000, 795000], [118000, 798000]], polygon => [[114000,795000],[118000,795000],[118000,798000],[114000,798000],[114000,795000]] };
$maps{"A:40"} = { bbox => [[160000, 760000], [200000, 800000]], polygon => [[160000,760000],[200000,760000],[200000,800000],[160000,800000],[160000,760000]] };
$maps{"A:41"} = { bbox => [[200000, 750000], [240000, 790000]], polygon => [[200000,750000],[240000,750000],[240000,790000],[200000,790000],[200000,750000]] };
$maps{"A:42"} = { bbox => [[240000, 750000], [280000, 790000]], polygon => [[240000,750000],[280000,750000],[280000,790000],[240000,790000],[240000,750000]] };
$maps{"A:43"} = { bbox => [[280000, 760000], [320000, 800000]], polygon => [[280000,760000],[320000,760000],[320000,800000],[280000,800000],[280000,760000]] };
$maps{"A:44"} = { bbox => [[320000, 760000], [360000, 800000]], polygon => [[320000,760000],[360000,760000],[360000,800000],[320000,800000],[320000,760000]] };
$maps{"A:45"} = { bbox => [[360000, 760000], [400000, 800000]], polygon => [[360000,760000],[400000,760000],[400000,800000],[360000,800000],[360000,760000]] };
$maps{"A:46"} = { bbox => [[91100, 733000], [133300, 773000]], polygon => [[92000,733000],[132000,733000],[132000,734000],[133300,735000],[133000,736000],[132000,736500],[132000,773000],[92000,773000],[92000,749500],[91900,749000],[91100,748000],[92000,747000],[92000,733000]] };
$maps{"A:47"} = { bbox => [[120000, 733000], [160000, 773000]], polygon => [[120000,733000],[160000,733000],[160000,773000],[120000,773000],[120000,733000]] };
$maps{"A:48"} = { bbox => [[120000, 710000], [160000, 750000]], polygon => [[120000,710000],[160000,710000],[160000,750000],[120000,750000],[120000,710000]] };
$maps{"A:49"} = { bbox => [[160000, 719200], [200000, 760000]], polygon => [[160000,720000],[162750,719200],[164000,720000],[200000,720000],[200000,760000],[160000,760000],[160000,720000]] };
$maps{"A:50"} = { bbox => [[200000, 710000], [240000, 750000]], polygon => [[200000,710000],[240000,710000],[240000,750000],[200000,750000],[200000,710000]] };
$maps{"A:51"} = { bbox => [[240000, 720000], [280000, 760000]], polygon => [[240000,720000],[280000,720000],[280000,760000],[240000,760000],[240000,720000]] };
$maps{"A:52"} = { bbox => [[270000, 720000], [310000, 760000]], polygon => [[270000,720000],[310000,720000],[310000,760000],[270000,760000],[270000,720000]] };
$maps{"A:53"} = { bbox => [[294000, 720000], [334000, 760000]], polygon => [[294000,720000],[334000,720000],[334000,760000],[294000,760000],[294000,720000]] };
$maps{"A:54"} = { bbox => [[334000, 720000], [374000, 760000]], polygon => [[334000,720000],[374000,720000],[374000,760000],[334000,760000],[334000,720000]] };
$maps{"A:55"} = { bbox => [[163000, 680000], [204000, 720600]], polygon => [[164000,680000],[204000,680000],[204000,720000],[178000,720000],[176000,720600],[174000,720600],[172700,720000],[164000,720000],[164000,711000],[163000,711000],[163000,708000],[164000,708000],[164000,680000]] };
$maps{"A:56"} = { bbox => [[204000, 682000], [244000, 722000]], polygon => [[204000,682000],[244000,682000],[244000,722000],[204000,722000],[204000,682000]] };
$maps{"A:57"} = { bbox => [[244000, 682000], [284000, 722000]], polygon => [[244000,682000],[284000,682000],[284000,722000],[244000,722000],[244000,682000]] };
$maps{"A:58"} = { bbox => [[284000, 690000], [324000, 730000]], polygon => [[284000,690000],[324000,690000],[324000,730000],[284000,730000],[284000,690000]] };
$maps{"A:59"} = { bbox => [[324000, 690000], [364000, 731000]], polygon => [[324000,690000],[364000,690000],[364000,730000],[341000,730000],[341000,731000],[339000,731000],[339000,730000],[324000,730000],[324000,690000]] };
$maps{"A:59 Inset"} = { bbox => [[363000, 698000], [367000, 701000]], polygon => [[363000,698000],[367000,698000],[367000,701000],[363000,701000],[363000,698000]] };
$maps{"A:60"} = { bbox => [[110000, 640000], [150000, 680000]], polygon => [[110000,640000],[150000,640000],[150000,680000],[110000,680000],[110000,640000]] };
$maps{"A:61"} = { bbox => [[131000, 662000], [171000, 702000]], polygon => [[131000,662000],[171000,662000],[171000,702000],[131000,702000],[131000,662000]] };
$maps{"A:62"} = { bbox => [[160000, 640000], [200000, 680000]], polygon => [[160000,640000],[200000,640000],[200000,680000],[160000,680000],[160000,640000]] };
$maps{"A:63"} = { bbox => [[200000, 642000], [240000, 682000]], polygon => [[200000,642000],[240000,642000],[240000,682000],[200000,682000],[200000,642000]] };
$maps{"A:64"} = { bbox => [[240000, 645000], [280000, 685000]], polygon => [[240000,645000],[280000,645000],[280000,685000],[240000,685000],[240000,645000]] };
$maps{"A:65"} = { bbox => [[280000, 650000], [320000, 690000]], polygon => [[280000,650000],[320000,650000],[320000,690000],[280000,690000],[280000,650000]] };
$maps{"A:66"} = { bbox => [[316000, 650000], [356000, 690000]], polygon => [[316000,650000],[356000,650000],[356000,690000],[316000,690000],[316000,650000]] };
$maps{"A:67"} = { bbox => [[356000, 650000], [396000, 690000]], polygon => [[356000,650000],[396000,650000],[396000,690000],[356000,690000],[356000,650000]] };
$maps{"A:68"} = { bbox => [[157000, 600000], [197000, 640000]], polygon => [[157000,600000],[197000,600000],[197000,640000],[157000,640000],[157000,600000]] };
$maps{"A:69"} = { bbox => [[175000, 613000], [216000, 653200]], polygon => [[175000,613000],[215000,613000],[215000,650000],[216000,650000],[216000,653200],[215000,653200],[214000,653000],[175000,653000],[175000,613000]] };
$maps{"A:70"} = { bbox => [[215000, 605000], [255000, 645000]], polygon => [[215000,605000],[255000,605000],[255000,645000],[215000,645000],[215000,605000]] };
$maps{"A:71"} = { bbox => [[255000, 605000], [295000, 645000]], polygon => [[255000,605000],[295000,605000],[295000,645000],[255000,645000],[255000,605000]] };
$maps{"A:72"} = { bbox => [[280000, 620000], [320000, 660000]], polygon => [[280000,620000],[320000,620000],[320000,660000],[280000,660000],[280000,620000]] };
$maps{"A:73"} = { bbox => [[320000, 620000], [360000, 660000]], polygon => [[320000,620000],[360000,620000],[360000,660000],[320000,660000],[320000,620000]] };
$maps{"A:74"} = { bbox => [[357000, 620000], [397000, 660000]], polygon => [[357000,620000],[397000,620000],[397000,660000],[357000,660000],[357000,620000]] };
$maps{"A:75"} = { bbox => [[390000, 620000], [430000, 660000]], polygon => [[390000,620000],[430000,620000],[430000,660000],[390000,660000],[390000,620000]] };
$maps{"A:76"} = { bbox => [[195000, 570000], [235000, 610000]], polygon => [[195000,570000],[235000,570000],[235000,610000],[195000,610000],[195000,570000]] };
$maps{"A:77"} = { bbox => [[235000, 570000], [275000, 610000]], polygon => [[235000,570000],[275000,570000],[275000,610000],[235000,610000],[235000,570000]] };
$maps{"A:78"} = { bbox => [[275000, 580000], [315000, 620000]], polygon => [[275000,580000],[315000,580000],[315000,620000],[275000,620000],[275000,580000]] };
$maps{"A:79"} = { bbox => [[315000, 580000], [355000, 620000]], polygon => [[315000,580000],[355000,580000],[355000,620000],[315000,620000],[315000,580000]] };
$maps{"A:80"} = { bbox => [[355000, 580000], [395000, 620000]], polygon => [[355000,580000],[395000,580000],[395000,620000],[355000,620000],[355000,580000]] };
$maps{"A:81"} = { bbox => [[395000, 580000], [435000, 620000]], polygon => [[395000,580000],[435000,580000],[435000,620000],[395000,620000],[395000,580000]] };
$maps{"A:82"} = { bbox => [[195000, 530000], [235000, 570000]], polygon => [[195000,530000],[235000,530000],[235000,570000],[195000,570000],[195000,530000]] };
$maps{"A:83"} = { bbox => [[235000, 530000], [275000, 570000]], polygon => [[235000,530000],[275000,530000],[275000,570000],[235000,570000],[235000,530000]] };
$maps{"A:84"} = { bbox => [[265000, 540000], [305000, 580000]], polygon => [[265000,540000],[305000,540000],[305000,580000],[265000,580000],[265000,540000]] };
$maps{"A:85"} = { bbox => [[305000, 540000], [345000, 580000]], polygon => [[305000,540000],[345000,540000],[345000,580000],[305000,580000],[305000,540000]] };
$maps{"A:86"} = { bbox => [[345000, 540000], [385000, 580000]], polygon => [[345000,540000],[385000,540000],[385000,580000],[345000,580000],[345000,540000]] };
$maps{"A:87"} = { bbox => [[367000, 540000], [407000, 580000]], polygon => [[367000,540000],[407000,540000],[407000,580000],[367000,580000],[367000,540000]] };
$maps{"A:88"} = { bbox => [[407000, 540000], [447000, 580000]], polygon => [[407000,540000],[447000,540000],[447000,580000],[407000,580000],[407000,540000]] };
$maps{"A:89"} = { bbox => [[290000, 500000], [330000, 540000]], polygon => [[290000,500000],[330000,500000],[330000,540000],[290000,540000],[290000,500000]] };
$maps{"A:90"} = { bbox => [[317000, 500000], [357000, 540000]], polygon => [[317000,500000],[357000,500000],[357000,540000],[317000,540000],[317000,500000]] };
$maps{"A:91"} = { bbox => [[357000, 500000], [397000, 540000]], polygon => [[357000,500000],[397000,500000],[397000,540000],[357000,540000],[357000,500000]] };
$maps{"A:92"} = { bbox => [[380000, 500000], [420000, 540000]], polygon => [[380000,500000],[420000,500000],[420000,540000],[380000,540000],[380000,500000]] };
$maps{"A:93"} = { bbox => [[420000, 500000], [460000, 540000]], polygon => [[420000,500000],[460000,500000],[460000,540000],[420000,540000],[420000,500000]] };
$maps{"A:94"} = { bbox => [[460000, 485000], [500000, 526000]], polygon => [[460000,485000],[500000,485000],[500000,525000],[462000,525000],[462000,526000],[460000,526000],[460000,485000]] };
$maps{"A:95"} = { bbox => [[213000, 465000], [253000, 505000]], polygon => [[213000,465000],[253000,465000],[253000,505000],[213000,505000],[213000,465000]] };
$maps{"A:96"} = { bbox => [[303000, 460000], [343000, 500000]], polygon => [[303000,460000],[343000,460000],[343000,500000],[303000,500000],[303000,460000]] };
$maps{"A:97"} = { bbox => [[326000, 460000], [366000, 500000]], polygon => [[326000,460000],[366000,460000],[366000,500000],[326000,500000],[326000,460000]] };
$maps{"A:98"} = { bbox => [[366000, 460000], [406000, 500000]], polygon => [[366000,460000],[406000,460000],[406000,500000],[366000,500000],[366000,460000]] };
$maps{"A:99"} = { bbox => [[406000, 460000], [446000, 500000]], polygon => [[406000,460000],[446000,460000],[446000,500000],[406000,500000],[406000,460000]] };
$maps{"A:100"} = { bbox => [[446000, 460000], [486000, 500000]], polygon => [[446000,460000],[486000,460000],[486000,500000],[446000,500000],[446000,460000]] };
$maps{"A:101"} = { bbox => [[486000, 460000], [526000, 500000]], polygon => [[486000,460000],[526000,460000],[526000,500000],[486000,500000],[486000,460000]] };
$maps{"A:102"} = { bbox => [[326000, 420000], [366000, 460000]], polygon => [[326000,420000],[366000,420000],[366000,460000],[326000,460000],[326000,420000]] };
$maps{"A:103"} = { bbox => [[360000, 420000], [400000, 460000]], polygon => [[360000,420000],[400000,420000],[400000,460000],[360000,460000],[360000,420000]] };
$maps{"A:104"} = { bbox => [[400000, 420000], [440000, 460000]], polygon => [[400000,420000],[440000,420000],[440000,460000],[400000,460000],[400000,420000]] };
$maps{"A:105"} = { bbox => [[440000, 420000], [480000, 460000]], polygon => [[440000,420000],[480000,420000],[480000,460000],[440000,460000],[440000,420000]] };
$maps{"A:106"} = { bbox => [[463000, 420000], [503000, 460000]], polygon => [[463000,420000],[503000,420000],[503000,460000],[463000,460000],[463000,420000]] };
$maps{"A:107"} = { bbox => [[500000, 420000], [540000, 460000]], polygon => [[500000,420000],[540000,420000],[540000,460000],[500000,460000],[500000,420000]] };
$maps{"A:108"} = { bbox => [[320000, 380000], [360000, 420000]], polygon => [[320000,380000],[360000,380000],[360000,420000],[320000,420000],[320000,380000]] };
$maps{"A:108 Inset"} = { bbox => [[317000, 385000], [321000, 392000]], polygon => [[317000,385000],[321000,385000],[321000,392000],[317000,392000],[317000,385000]] };
$maps{"A:109"} = { bbox => [[360000, 380000], [400000, 420000]], polygon => [[360000,380000],[400000,380000],[400000,420000],[360000,420000],[360000,380000]] };
$maps{"A:110"} = { bbox => [[400000, 380000], [440000, 420000]], polygon => [[400000,380000],[440000,380000],[440000,420000],[400000,420000],[400000,380000]] };
$maps{"A:111"} = { bbox => [[430000, 380000], [470000, 420000]], polygon => [[430000,380000],[470000,380000],[470000,420000],[430000,420000],[430000,380000]] };
$maps{"A:112"} = { bbox => [[470000, 385000], [510000, 425000]], polygon => [[470000,385000],[510000,385000],[510000,425000],[470000,425000],[470000,385000]] };
$maps{"A:113"} = { bbox => [[510000, 386000], [550000, 426000]], polygon => [[510000,386000],[550000,386000],[550000,426000],[510000,426000],[510000,386000]] };
$maps{"A:114"} = { bbox => [[220000, 360000], [260000, 400000]], polygon => [[220000,360000],[260000,360000],[260000,400000],[220000,400000],[220000,360000]] };
$maps{"A:114 Inset"} = { bbox => [[260000, 376000], [266000, 383000]], polygon => [[260000,376000],[266000,376000],[266000,383000],[260000,383000],[260000,376000]] };
$maps{"A:115"} = { bbox => [[240000, 345000], [280000, 385000]], polygon => [[240000,345000],[280000,345000],[280000,385000],[240000,385000],[240000,345000]] };
$maps{"A:116"} = { bbox => [[280000, 345000], [320000, 386000]], polygon => [[280000,345000],[320000,345000],[320000,385000],[313000,385000],[313000,386000],[310000,386000],[310000,385000],[280000,385000],[280000,345000]] };
$maps{"A:117"} = { bbox => [[320000, 340000], [360000, 380000]], polygon => [[320000,340000],[360000,340000],[360000,380000],[320000,380000],[320000,340000]] };
$maps{"A:118"} = { bbox => [[360000, 340000], [400000, 380000]], polygon => [[360000,340000],[400000,340000],[400000,380000],[360000,380000],[360000,340000]] };
$maps{"A:119"} = { bbox => [[400000, 340000], [440000, 380000]], polygon => [[400000,340000],[440000,340000],[440000,380000],[400000,380000],[400000,340000]] };
$maps{"A:120"} = { bbox => [[440000, 350000], [480000, 390000]], polygon => [[440000,350000],[480000,350000],[480000,390000],[440000,390000],[440000,350000]] };
$maps{"A:121"} = { bbox => [[478000, 350000], [518000, 390000]], polygon => [[478000,350000],[518000,350000],[518000,390000],[478000,390000],[478000,350000]] };
$maps{"A:122"} = { bbox => [[518000, 350000], [558000, 390000]], polygon => [[518000,350000],[558000,350000],[558000,390000],[518000,390000],[518000,350000]] };
$maps{"A:123"} = { bbox => [[210000, 320000], [250000, 360000]], polygon => [[210000,320000],[250000,320000],[250000,360000],[210000,360000],[210000,320000]] };
$maps{"A:124"} = { bbox => [[250000, 305000], [290000, 345000]], polygon => [[250000,305000],[290000,305000],[290000,345000],[250000,345000],[250000,305000]] };
$maps{"A:125"} = { bbox => [[280000, 305000], [320000, 345000]], polygon => [[280000,305000],[320000,305000],[320000,345000],[280000,345000],[280000,305000]] };
$maps{"A:126"} = { bbox => [[320000, 300000], [360000, 340000]], polygon => [[320000,300000],[360000,300000],[360000,340000],[320000,340000],[320000,300000]] };
$maps{"A:127"} = { bbox => [[360000, 300000], [400000, 340000]], polygon => [[360000,300000],[400000,300000],[400000,340000],[360000,340000],[360000,300000]] };
$maps{"A:128"} = { bbox => [[400000, 308000], [440000, 348000]], polygon => [[400000,308000],[440000,308000],[440000,348000],[400000,348000],[400000,308000]] };
$maps{"A:129"} = { bbox => [[440000, 310000], [480000, 350000]], polygon => [[440000,310000],[480000,310000],[480000,350000],[440000,350000],[440000,310000]] };
$maps{"A:130"} = { bbox => [[480000, 310000], [520000, 350000]], polygon => [[480000,310000],[520000,310000],[520000,350000],[480000,350000],[480000,310000]] };
$maps{"A:131"} = { bbox => [[520000, 310000], [560000, 350000]], polygon => [[520000,310000],[560000,310000],[560000,350000],[520000,350000],[520000,310000]] };
$maps{"A:132"} = { bbox => [[560000, 310000], [600000, 350000]], polygon => [[560000,310000],[600000,310000],[600000,350000],[560000,350000],[560000,310000]] };
$maps{"A:133"} = { bbox => [[600000, 310000], [640000, 350000]], polygon => [[600000,310000],[640000,310000],[640000,350000],[600000,350000],[600000,310000]] };
$maps{"A:134"} = { bbox => [[617000, 290000], [657000, 330000]], polygon => [[617000,290000],[657000,290000],[657000,330000],[617000,330000],[617000,290000]] };
$maps{"A:135"} = { bbox => [[250000, 265000], [290000, 305000]], polygon => [[250000,265000],[290000,265000],[290000,305000],[250000,305000],[250000,265000]] };
$maps{"A:136"} = { bbox => [[280000, 265000], [320000, 305000]], polygon => [[280000,265000],[320000,265000],[320000,305000],[280000,305000],[280000,265000]] };
$maps{"A:137"} = { bbox => [[320000, 260000], [360000, 300000]], polygon => [[320000,260000],[360000,260000],[360000,300000],[320000,300000],[320000,260000]] };
$maps{"A:138"} = { bbox => [[345000, 260000], [385000, 300000]], polygon => [[345000,260000],[385000,260000],[385000,300000],[345000,300000],[345000,260000]] };
$maps{"A:139"} = { bbox => [[385000, 268000], [425000, 308000]], polygon => [[385000,268000],[425000,268000],[425000,308000],[385000,308000],[385000,268000]] };
$maps{"A:140"} = { bbox => [[425000, 270000], [465000, 310000]], polygon => [[425000,270000],[465000,270000],[465000,310000],[425000,310000],[425000,270000]] };
$maps{"A:141"} = { bbox => [[465000, 270000], [505000, 310000]], polygon => [[465000,270000],[505000,270000],[505000,310000],[465000,310000],[465000,270000]] };
$maps{"A:142"} = { bbox => [[504000, 274000], [544000, 314000]], polygon => [[504000,274000],[544000,274000],[544000,314000],[504000,314000],[504000,274000]] };
$maps{"A:143"} = { bbox => [[537000, 274000], [577000, 314000]], polygon => [[537000,274000],[577000,274000],[577000,314000],[537000,314000],[537000,274000]] };
$maps{"A:144"} = { bbox => [[577000, 270000], [617000, 310000]], polygon => [[577000,270000],[617000,270000],[617000,310000],[577000,310000],[577000,270000]] };
$maps{"A:145"} = { bbox => [[200000, 220000], [240000, 261000]], polygon => [[200000,220000],[240000,220000],[240000,260000],[239000,260000],[239000,261000],[238000,261000],[238000,260000],[200000,260000],[200000,220000]] };
$maps{"A:146"} = { bbox => [[240000, 225000], [280000, 265000]], polygon => [[240000,225000],[280000,225000],[280000,265000],[240000,265000],[240000,225000]] };
$maps{"A:147"} = { bbox => [[270000, 240000], [310000, 280000]], polygon => [[270000,240000],[310000,240000],[310000,280000],[270000,280000],[270000,240000]] };
$maps{"A:148"} = { bbox => [[310000, 240000], [350000, 280000]], polygon => [[310000,240000],[350000,240000],[350000,280000],[310000,280000],[310000,240000]] };
$maps{"A:149"} = { bbox => [[333000, 228000], [373000, 268000]], polygon => [[333000,228000],[373000,228000],[373000,268000],[333000,268000],[333000,228000]] };
$maps{"A:150"} = { bbox => [[373000, 228000], [413000, 268000]], polygon => [[373000,228000],[413000,228000],[413000,268000],[373000,268000],[373000,228000]] };
$maps{"A:151"} = { bbox => [[413000, 230000], [453000, 270000]], polygon => [[413000,230000],[453000,230000],[453000,270000],[413000,270000],[413000,230000]] };
$maps{"A:152"} = { bbox => [[453000, 230000], [493000, 270000]], polygon => [[453000,230000],[493000,230000],[493000,270000],[453000,270000],[453000,230000]] };
$maps{"A:153"} = { bbox => [[493000, 234000], [533000, 274000]], polygon => [[493000,234000],[533000,234000],[533000,274000],[493000,274000],[493000,234000]] };
$maps{"A:154"} = { bbox => [[533000, 234000], [573000, 274000]], polygon => [[533000,234000],[573000,234000],[573000,274000],[533000,274000],[533000,234000]] };
$maps{"A:155"} = { bbox => [[573000, 234000], [613000, 274000]], polygon => [[573000,234000],[613000,234000],[613000,274000],[573000,274000],[573000,234000]] };
$maps{"A:156"} = { bbox => [[613000, 250000], [654000, 291000]], polygon => [[613000,250000],[653000,250000],[653000,282000],[654000,282000],[654000,290000],[643000,290000],[643000,291000],[642000,291000],[642000,290000],[613000,290000],[613000,250000]] };
$maps{"A:157"} = { bbox => [[165000, 201000], [205000, 242000]], polygon => [[165000,201000],[205000,201000],[205000,241000],[202000,241000],[202000,242000],[200000,242000],[200000,241000],[190000,241000],[190000,242000],[188000,242000],[188000,241000],[165000,241000],[165000,201000]] };
$maps{"A:157 Inset A"} = { bbox => [[158000, 208000], [161000, 210000]], polygon => [[158000,208000],[161000,208000],[161000,210000],[158000,210000],[158000,208000]] };
$maps{"A:157 Inset B"} = { bbox => [[145000, 208000], [148000, 210000]], polygon => [[145000,208000],[148000,208000],[148000,210000],[145000,210000],[145000,208000]] };
$maps{"A:158"} = { bbox => [[188000, 190000], [229000, 230000]], polygon => [[189000,190000],[229000,190000],[229000,230000],[189000,230000],[189000,203000],[188000,203000],[188000,195000],[189000,195000],[189000,190000]] };
$maps{"A:159"} = { bbox => [[229000, 184000], [269000, 225000]], polygon => [[229000,185000],[246000,185000],[246000,184000],[248000,184000],[248000,185000],[269000,185000],[269000,225000],[229000,225000],[229000,185000]] };
$maps{"A:160"} = { bbox => [[269000, 205000], [309000, 245000]], polygon => [[269000,205000],[309000,205000],[309000,245000],[269000,245000],[269000,205000]] };
$maps{"A:161"} = { bbox => [[309000, 205000], [349000, 245000]], polygon => [[309000,205000],[349000,205000],[349000,245000],[309000,245000],[309000,205000]] };
$maps{"A:162"} = { bbox => [[349000, 186900], [389000, 228000]], polygon => [[349000,188000],[349000,186900],[351300,186900],[353500,188000],[389000,188000],[389000,228000],[349000,228000],[349000,188000]] };
$maps{"A:163"} = { bbox => [[388800, 190000], [429000, 230000]], polygon => [[389000,190000],[429000,190000],[429000,230000],[389000,230000],[389000,193600],[388800,193300],[389000,193100],[389000,190000]] };
$maps{"A:164"} = { bbox => [[429000, 189300], [469000, 230000]], polygon => [[429000,190000],[451000,190000],[451100,189700],[452700,189300],[454700,190000],[469000,190000],[469000,230000],[429000,230000],[429000,190000]] };
$maps{"A:165"} = { bbox => [[460000, 195000], [500000, 235000]], polygon => [[460000,195000],[500000,195000],[500000,235000],[460000,235000],[460000,195000]] };
$maps{"A:166"} = { bbox => [[500000, 194000], [540000, 234000]], polygon => [[500000,194000],[540000,194000],[540000,234000],[500000,234000],[500000,194000]] };
$maps{"A:167"} = { bbox => [[540000, 194000], [580000, 234000]], polygon => [[540000,194000],[580000,194000],[580000,234000],[540000,234000],[540000,194000]] };
$maps{"A:168"} = { bbox => [[580000, 194000], [620000, 234000]], polygon => [[580000,194000],[620000,194000],[620000,234000],[580000,234000],[580000,194000]] };
$maps{"A:169"} = { bbox => [[607000, 210000], [647000, 250000]], polygon => [[607000,210000],[647000,210000],[647000,250000],[607000,250000],[607000,210000]] };
$maps{"A:170"} = { bbox => [[269000, 165000], [309000, 205000]], polygon => [[269000,165000],[309000,165000],[309000,205000],[269000,205000],[269000,165000]] };
$maps{"A:171"} = { bbox => [[309000, 165000], [349000, 205000]], polygon => [[309000,165000],[349000,165000],[349000,205000],[309000,205000],[309000,165000]] };
$maps{"A:172"} = { bbox => [[338500, 154300], [380000, 195000]], polygon => [[340000,155000],[364500,155000],[367000,154300],[369000,154300],[370000,155000],[380000,155000],[380000,195000],[340000,195000],[340000,173000],[338500,171600],[338500,170500],[340000,169400],[340000,155000]] };
$maps{"A:173"} = { bbox => [[380000, 155000], [420000, 195000]], polygon => [[380000,155000],[420000,155000],[420000,195000],[380000,195000],[380000,155000]] };
$maps{"A:174"} = { bbox => [[420000, 155000], [460000, 195000]], polygon => [[420000,155000],[460000,155000],[460000,195000],[420000,195000],[420000,155000]] };
$maps{"A:175"} = { bbox => [[460000, 155000], [500000, 195000]], polygon => [[460000,155000],[500000,155000],[500000,195000],[460000,195000],[460000,155000]] };
$maps{"A:176"} = { bbox => [[495000, 160000], [535000, 200000]], polygon => [[495000,160000],[535000,160000],[535000,200000],[495000,200000],[495000,160000]] };
$maps{"A:177"} = { bbox => [[530000, 160000], [570000, 200000]], polygon => [[530000,160000],[570000,160000],[570000,200000],[530000,200000],[530000,160000]] };
$maps{"A:178"} = { bbox => [[565000, 155000], [605000, 196000]], polygon => [[565000,155000],[605000,155000],[605000,196000],[603000,196000],[603000,195000],[595000,195000],[595000,196000],[593000,196000],[593000,195000],[565000,195000],[565000,155000]] };
$maps{"A:179"} = { bbox => [[603000, 133000], [643000, 173000]], polygon => [[603000,133000],[643000,133000],[643000,173000],[603000,173000],[603000,133000]] };
$maps{"A:180"} = { bbox => [[240000, 112000], [280000, 152000]], polygon => [[240000,112000],[280000,112000],[280000,152000],[240000,152000],[240000,112000]] };
$maps{"A:180 Inset"} = { bbox => [[212000, 143000], [215000, 149000]], polygon => [[212000,143000],[215000,143000],[215000,149000],[212000,149000],[212000,143000]] };
$maps{"A:181"} = { bbox => [[280000, 112000], [320000, 152000]], polygon => [[280000,112000],[320000,112000],[320000,152000],[280000,152000],[280000,112000]] };
$maps{"A:182"} = { bbox => [[320000, 130000], [360000, 170800]], polygon => [[320000,130000],[360000,130000],[360000,170000],[339600,170000],[339350,170500],[338800,170800],[337000,170000],[320000,170000],[320000,130000]] };
$maps{"A:183"} = { bbox => [[349000, 115000], [389000, 155500]], polygon => [[349000,115000],[389000,115000],[389000,155000],[371000,155000],[370000,155500],[366000,155500],[364000,155000],[349000,155000],[349000,115000]] };
$maps{"A:184"} = { bbox => [[389000, 115000], [429000, 155000]], polygon => [[389000,115000],[429000,115000],[429000,155000],[389000,155000],[389000,115000]] };
$maps{"A:185"} = { bbox => [[429000, 116000], [469000, 156000]], polygon => [[429000,116000],[469000,116000],[469000,156000],[429000,156000],[429000,116000]] };
$maps{"A:186"} = { bbox => [[465000, 125000], [505000, 165000]], polygon => [[465000,125000],[505000,125000],[505000,165000],[465000,165000],[465000,125000]] };
$maps{"A:187"} = { bbox => [[505000, 125000], [545000, 165000]], polygon => [[505000,125000],[545000,125000],[545000,165000],[505000,165000],[505000,125000]] };
$maps{"A:188"} = { bbox => [[545000, 125000], [585000, 165000]], polygon => [[545000,125000],[585000,125000],[585000,165000],[545000,165000],[545000,125000]] };
$maps{"A:189"} = { bbox => [[585000, 115000], [625000, 155000]], polygon => [[585000,115000],[625000,115000],[625000,155000],[585000,155000],[585000,115000]] };
$maps{"A:190"} = { bbox => [[207000, 87000], [247000, 128000]], polygon => [[207000,87000],[247000,87000],[247000,127000],[228000,127000],[228000,128000],[222000,128000],[222000,127000],[207000,127000],[207000,87000]] };
$maps{"A:191"} = { bbox => [[247000, 72000], [287000, 112000]], polygon => [[247000,72000],[287000,72000],[287000,112000],[247000,112000],[247000,72000]] };
$maps{"A:192"} = { bbox => [[287000, 72000], [327000, 112000]], polygon => [[287000,72000],[327000,72000],[327000,112000],[287000,112000],[287000,72000]] };
$maps{"A:193"} = { bbox => [[310000, 88500], [350000, 130000]], polygon => [[310000,90000],[323000,90000],[323500,89500],[325000,89500],[328000,89000],[330000,89500],[331000,89500],[331600,90000],[346000,90000],[348600,88500],[349300,88500],[350000,89000],[350000,130000],[310000,130000],[310000,90000]] };
$maps{"A:194"} = { bbox => [[349000, 75000], [389000, 115000]], polygon => [[349000,75000],[389000,75000],[389000,115000],[349000,115000],[349000,75000]] };
$maps{"A:194 Inset"} = { bbox => [[366000, 68000], [371000, 75000]], polygon => [[366000,68000],[371000,68000],[371000,75000],[366000,75000],[366000,68000]] };
$maps{"A:195"} = { bbox => [[389000, 75000], [429400, 115000]], polygon => [[389000,75000],[429000,75000],[429000,84000],[429400,85000],[429000,86000],[429000,115000],[389000,115000],[389000,75000]] };
$maps{"A:196"} = { bbox => [[428300, 74800], [469000, 116000]], polygon => [[429000,76000],[447300,76000],[449700,74800],[451000,74800],[455300,76000],[469000,76000],[469000,116000],[429000,116000],[429000,86000],[428300,85000],[429000,84000],[429000,76000]] };
$maps{"A:197"} = { bbox => [[469000, 90000], [509000, 130000]], polygon => [[469000,90000],[509000,90000],[509000,130000],[469000,130000],[469000,90000]] };
$maps{"A:198"} = { bbox => [[509000, 97000], [549000, 137000]], polygon => [[509000,97000],[549000,97000],[549000,137000],[509000,137000],[509000,97000]] };
$maps{"A:199"} = { bbox => [[549000, 94000], [589000, 134000]], polygon => [[549000,94000],[589000,94000],[589000,134000],[549000,134000],[549000,94000]] };
$maps{"A:200"} = { bbox => [[175000, 49000], [215000, 90000]], polygon => [[175000,50000],[209000,50000],[209000,49000],[211000,49000],[211000,50000],[215000,50000],[215000,90000],[175000,90000],[175000,50000]] };
$maps{"A:201"} = { bbox => [[215000, 45500], [255000, 87000]], polygon => [[215000,47000],[251500,47000],[254000,45500],[255000,45500],[255000,87000],[215000,87000],[215000,47000]] };
$maps{"A:201 Inset"} = { bbox => [[238000, 32000], [240000, 34000]], polygon => [[238000,32000],[240000,32000],[240000,34000],[238000,34000],[238000,32000]] };
$maps{"A:202"} = { bbox => [[255000, 32000], [296000, 72800]], polygon => [[255000,32000],[295000,32000],[295000,72000],[295000,62350],[296000,63000],[296000,64000],[295000,64500],[295000,72000],[294800,72000],[293800,72800],[289700,72700],[287000,72000],[255000,72000],[255000,32000]] };
$maps{"A:203"} = { bbox => [[132000, 11000], [172000, 51000]], polygon => [[132000,11000],[172000,11000],[172000,51000],[132000,51000],[132000,11000]] };
$maps{"A:203 Inset A"} = { bbox => [[80000, 5000], [96000, 18250]], polygon => [[80000,5000],[96000,5000],[96000,18250],[86150,18250],[80000,9200],[80000,5000]] };
$maps{"A:203 Inset B"} = { bbox => [[169000, 50000], [176000, 55000]], polygon => [[169000,50000],[176000,50000],[176000,55000],[169000,55000],[169000,50000]] };
$maps{"A:203 Inset C"} = { bbox => [[126000, 11000], [128000, 13000]], polygon => [[126000,11000],[128000,11000],[128000,13000],[126000,13000],[126000,11000]] };
$maps{"A:204"} = { bbox => [[172000, 14000], [214000, 55000]], polygon => [[172000,14000],[212000,14000],[212000,50000],[214000,50000],[214000,53000],[212000,53000],[212000,54000],[177000,54000],[176000,55000],[175000,55000],[173600,54000],[172000,54000],[172000,14000]] };
$maps{"B:101"} = { bbox => [[80000, 3000], [97000, 19000]], polygon => [[80000,3000],[94000,3000],[94000,13000],[97000,13000],[97000,19000],[84000,19000],[84000,10000],[80000,10000],[80000,3000]] };
$maps{"B:102"} = { bbox => [[131000, 21200], [161000, 43900]], polygon => [[131000,21500],[136000,21500],[136200,21200],[137600,21200],[137800,21500],[161000,21500],[161000,43500],[159800,43500],[159600,43900],[157500,43900],[157300,43500],[141000,43500],[141000,37500],[131000,37500],[131000,21500]] };
$maps{"B:103"} = { bbox => [[161000, 10000], [183000, 37000]], polygon => [[161000,10000],[183000,10000],[183000,37000],[161000,37000],[161000,10000]] };
$maps{"B:104"} = { bbox => [[161000, 33300], [183000, 64000]], polygon => [[161000,34000],[180300,34000],[180400,33300],[182400,33300],[182500,34000],[183000,34000],[183000,64000],[167000,64000],[167000,53000],[161000,53000],[161000,34000]] };
$maps{"B:105"} = { bbox => [[175000, 30000], [205000, 52000]], polygon => [[175000,30000],[195000,30000],[195000,36000],[205000,36000],[205000,52000],[175000,52000],[175000,30000]] };
$maps{"B:106"} = { bbox => [[179400, 52000], [202500, 82000]], polygon => [[180500,52000],[202500,52000],[202500,82000],[187000,82000],[187000,77000],[183000,77000],[183000,65000],[180500,65000],[180500,63300],[179400,63300],[180000,61600],[180500,60800],[180500,52000]] };
$maps{"B:107"} = { bbox => [[200000, 47700], [230000, 68000]], polygon => [[200000,48000],[203300,48000],[203400,47700],[204200,47700],[204300,48000],[230000,48000],[230000,68000],[200000,68000],[200000,48000]] };
$maps{"B:108"} = { bbox => [[230000, 48000], [252250, 78000]], polygon => [[230000,50000],[240000,50000],[240000,48000],[252250,48000],[252250,58000],[250000,58000],[250000,78000],[230000,78000],[230000,50000]] };
$maps{"B:109"} = { bbox => [[202500, 63500], [230000, 86000]], polygon => [[202500,64000],[223100,64000],[223400,63500],[226100,63500],[226500,64000],[230000,64000],[230000,86000],[202500,86000],[202500,64000]] };
$maps{"B:110"} = { bbox => [[278000, 60000], [300000, 90000]], polygon => [[278000,60000],[296500,60000],[296500,76000],[300000,76000],[300000,90000],[278000,90000],[278000,60000]] };
$maps{"B:111"} = { bbox => [[202000, 86000], [232000, 108000]], polygon => [[202000,86000],[232000,86000],[232000,108000],[212000,108000],[212000,102000],[202000,102000],[202000,86000]] };
$maps{"B:111 Inset"} = { bbox => [[201000, 81000], [206000, 87000]], polygon => [[201000,81000],[206000,81000],[206000,87000],[201000,87000],[201000,81000]] };
$maps{"B:112"} = { bbox => [[228500, 78000], [251000, 108000]], polygon => [[228500,78000],[250500,78000],[250500,83300],[251000,84000],[251000,85000],[250500,85400],[250500,108000],[231500,108000],[231500,86000],[228500,86000],[228500,78000]] };
$maps{"B:113"} = { bbox => [[250000, 90000], [280000, 110000]], polygon => [[250000,90000],[280000,90000],[280000,110000],[250000,110000],[250000,90000]] };
$maps{"B:114S"} = { bbox => [[280000, 87000], [300000, 107000]], polygon => [[280000,87000],[300000,87000],[300000,107000],[280000,107000],[280000,87000]] };
$maps{"B:114N"} = { bbox => [[280000, 107000], [300000, 130000]], polygon => [[280000,107000],[300000,107000],[300000,130000],[280000,130000],[280000,107000]] };
$maps{"B:115"} = { bbox => [[298400, 79300], [321000, 110000]], polygon => [[299000,80000],[299900,80000],[301000,79300],[304100,79300],[304400,80000],[311000,80000],[311000,86000],[321000,86000],[321000,110000],[299000,110000],[299000,94000],[298600,93500],[299000,92700],[299000,85900],[298400,85500],[298400,84000],[299000,83500],[299000,80000]] };
$maps{"B:116"} = { bbox => [[321000, 87800], [349000, 110000]], polygon => [[321000,88000],[322000,87800],[322900,87800],[323000,88000],[335000,88000],[335000,91000],[341000,91000],[341000,88000],[349000,88000],[349000,110000],[321000,110000],[321000,88000]] };
$maps{"B:117W"} = { bbox => [[347000, 90000], [370000, 110000]], polygon => [[347000,90000],[370000,90000],[370000,110000],[347000,110000],[347000,90000]] };
$maps{"B:117E"} = { bbox => [[370000, 90000], [390000, 110000]], polygon => [[370000,90000],[390000,90000],[390000,110000],[370000,110000],[370000,90000]] };
$maps{"B:118N"} = { bbox => [[383000, 110000], [406000, 130000]], polygon => [[383000,110000],[406000,110000],[406000,130000],[383000,130000],[383000,110000]] };
$maps{"B:118S"} = { bbox => [[386000, 89600], [406000, 110000]], polygon => [[386000,90000],[398000,90000],[400000,89600],[401000,89600],[403000,90000],[406000,90000],[406000,110000],[386000,110000],[386000,90000]] };
$maps{"B:119"} = { bbox => [[447600, 97000], [470000, 125000]], polygon => [[448000,99000],[456000,99000],[456000,97000],[470000,97000],[470000,125000],[448000,125000],[448000,101700],[447600,101700],[447600,101300],[448000,101100],[448000,99000]] };
$maps{"B:120"} = { bbox => [[468000, 92000], [490000, 122000]], polygon => [[468000,97000],[477000,97000],[483000,93000],[483000,92000],[490000,92000],[490000,122000],[468000,122000],[468000,97000]] };
$maps{"B:121"} = { bbox => [[490000, 97600], [517000, 120000]], polygon => [[490000,98000],[490000,97600],[494200,97600],[494200,98000],[517000,98000],[517000,120000],[490000,120000],[490000,98000]] };
$maps{"B:122"} = { bbox => [[517000, 99000], [547000, 121000]], polygon => [[517000,102000],[537000,102000],[537000,99000],[547000,99000],[547000,121000],[517000,121000],[517000,102000]] };
$maps{"B:123"} = { bbox => [[542700, 95000], [565000, 122000]], polygon => [[543000,95000],[565000,95000],[565000,122000],[543000,122000],[543000,106000],[542700,106000],[542700,103400],[543000,103400],[543000,95000]] };
$maps{"B:124"} = { bbox => [[561000, 102000], [591000, 124000]], polygon => [[561000,102000],[581000,102000],[581000,108000],[591000,108000],[591000,124000],[561000,124000],[561000,102000]] };
$maps{"B:125"} = { bbox => [[580000, 115000], [610400, 135000]], polygon => [[580000,115000],[610000,115000],[610000,128100],[610400,128699],[610400,129699],[610000,130000],[610000,135000],[580000,135000],[580000,115000]] };
$maps{"B:126"} = { bbox => [[219300, 108000], [250000, 128000]], polygon => [[220000,108000],[250000,108000],[250000,128000],[220000,128000],[220000,116900],[219300,116000],[219300,112300],[219600,111500],[219600,108000],[220000,108000]] };
$maps{"B:127"} = { bbox => [[249400, 110000], [280000, 130000]], polygon => [[250000,110000],[280000,110000],[280000,130000],[250000,130000],[250000,120000],[249400,119500],[249400,118500],[250000,118000],[250000,110000]] };
$maps{"B:128E"} = { bbox => [[320000, 110000], [340000, 130000]], polygon => [[320000,110000],[340000,110000],[340000,130000],[320000,130000],[320000,110000]] };
$maps{"B:128W"} = { bbox => [[300000, 107000], [320000, 130000]], polygon => [[300000,107000],[320000,107000],[320000,130000],[300000,130000],[300000,107000]] };
$maps{"B:129W"} = { bbox => [[340000, 110000], [360000, 130000]], polygon => [[340000,110000],[360000,110000],[360000,130000],[340000,130000],[340000,110000]] };
$maps{"B:129E"} = { bbox => [[360000, 110000], [383000, 130000]], polygon => [[360000,110000],[383000,110000],[383000,130000],[360000,130000],[360000,110000]] };
$maps{"B:130S"} = { bbox => [[400000, 120000], [420000, 140000]], polygon => [[400000,120000],[420000,120000],[420000,140000],[400000,140000],[400000,120000]] };
$maps{"B:130N"} = { bbox => [[397000, 140000], [420000, 160000]], polygon => [[397000,140000],[420000,140000],[420000,160000],[397000,160000],[397000,140000]] };
$maps{"B:131S"} = { bbox => [[420000, 120000], [440000, 140000]], polygon => [[420000,120000],[440000,120000],[440000,140000],[420000,140000],[420000,120000]] };
$maps{"B:131N"} = { bbox => [[420000, 140000], [440000, 160000]], polygon => [[420000,140000],[440000,140000],[440000,160000],[420000,160000],[420000,140000]] };
$maps{"B:132"} = { bbox => [[440000, 120000], [470000, 140000]], polygon => [[440000,120000],[470000,120000],[470000,140000],[440000,140000],[440000,120000]] };
$maps{"B:133"} = { bbox => [[470000, 120000], [500000, 140000]], polygon => [[470000,120000],[500000,120000],[500000,140000],[470000,140000],[470000,120000]] };
$maps{"B:134"} = { bbox => [[500000, 120000], [530000, 140000]], polygon => [[500000,120000],[530000,120000],[530000,140000],[500000,140000],[500000,120000]] };
$maps{"B:135"} = { bbox => [[530000, 120000], [560000, 140000]], polygon => [[530000,120000],[560000,120000],[560000,140000],[530000,140000],[530000,120000]] };
$maps{"B:136"} = { bbox => [[557700, 122000], [580000, 150000]], polygon => [[558000,122000],[563000,122000],[563000,123000],[580000,123000],[580000,150000],[558000,150000],[558000,140900],[557700,139300],[558000,137300],[558000,122000]] };
$maps{"B:137"} = { bbox => [[580000, 135000], [610000, 155000]], polygon => [[580000,135000],[610000,135000],[610000,155000],[580000,155000],[580000,135000]] };
$maps{"B:138"} = { bbox => [[609000, 129000], [639000, 151000]], polygon => [[609000,129000],[616000,129000],[616000,132000],[639000,132000],[639000,151000],[609000,151000],[609000,129000]] };
$maps{"B:139"} = { bbox => [[238000, 120000], [260000, 150000]], polygon => [[238000,120000],[260000,120000],[260000,150000],[249000,150000],[249000,148000],[243000,148000],[243000,143000],[241000,143000],[241000,137500],[238000,137500],[238000,120000]] };
$maps{"B:139 Inset"} = { bbox => [[212500, 143000], [215000, 148500]], polygon => [[212500,143000],[215000,143000],[215000,148500],[212500,148500],[212500,143000]] };
$maps{"B:140"} = { bbox => [[310000, 128000], [340000, 150000]], polygon => [[310000,128000],[340000,128000],[340000,150000],[330000,150000],[330000,147000],[329200,147000],[329000,147300],[328000,147300],[327800,147000],[310000,147000],[310000,128000]] };
$maps{"B:141"} = { bbox => [[340000, 130000], [360000, 160000]], polygon => [[340000,130000],[360000,130000],[360000,160000],[340000,160000],[340000,130000]] };
$maps{"B:142"} = { bbox => [[360000, 130000], [380000, 160000]], polygon => [[360000,130000],[380000,130000],[380000,160000],[360000,160000],[360000,130000]] };
$maps{"B:143"} = { bbox => [[380000, 130000], [400000, 160000]], polygon => [[380000,130000],[400000,130000],[400000,160000],[380000,160000],[380000,130000]] };
$maps{"B:144E"} = { bbox => [[460000, 137000], [480000, 160000]], polygon => [[460000,137000],[480000,137000],[480000,160000],[460000,160000],[460000,137000]] };
$maps{"B:144W"} = { bbox => [[440000, 140000], [460000, 160000]], polygon => [[440000,140000],[460000,140000],[460000,160000],[440000,160000],[440000,140000]] };
$maps{"B:145"} = { bbox => [[480000, 140000], [510000, 160000]], polygon => [[480000,140000],[510000,140000],[510000,160000],[480000,160000],[480000,140000]] };
$maps{"B:146"} = { bbox => [[510000, 140000], [540000, 160000]], polygon => [[510000,140000],[540000,140000],[540000,160000],[510000,160000],[510000,140000]] };
$maps{"B:147"} = { bbox => [[540000, 138000], [562000, 165000]], polygon => [[540000,138000],[562000,138000],[562000,165000],[540000,165000],[540000,138000]] };
$maps{"B:148"} = { bbox => [[560000, 150000], [590000, 170000]], polygon => [[560000,150000],[590000,150000],[590000,170000],[560000,170000],[560000,150000]] };
$maps{"B:149"} = { bbox => [[588000, 150000], [610000, 177000]], polygon => [[588000,150000],[610000,150000],[610000,177000],[588000,177000],[588000,150000]] };
$maps{"B:150"} = { bbox => [[610000, 151000], [640400, 173000]], polygon => [[610000,151000],[640000,151000],[640000,166750],[640400,167500],[640400,170300],[640000,171000],[640000,173000],[633000,173000],[633000,171000],[628000,171000],[628000,170000],[610000,170000],[610000,151000]] };
$maps{"B:151W"} = { bbox => [[278000, 166000], [301000, 186000]], polygon => [[278000,172500],[288500,172500],[288500,166000],[301000,166000],[301000,186000],[278000,186000],[278000,172500]] };
$maps{"B:151E"} = { bbox => [[301000, 165200], [324000, 186000]], polygon => [[301000,166000],[302000,165200],[307000,165200],[308000,166000],[310000,166000],[310000,165800],[311300,165800],[311300,166000],[324000,166000],[324000,186000],[301000,186000],[301000,166000]] };
$maps{"B:152"} = { bbox => [[320000, 176000], [342000, 206000]], polygon => [[320000,176000],[329500,176000],[329500,181000],[342000,181000],[342000,206000],[320000,206000],[320000,176000]] };
$maps{"B:153"} = { bbox => [[320000, 143000], [342000, 173000]], polygon => [[320000,143000],[342000,143000],[342000,173000],[330000,173000],[330000,167000],[320000,167000],[320000,143000]] };
$maps{"B:154"} = { bbox => [[340000, 160000], [360000, 190000]], polygon => [[340000,160000],[360000,160000],[360000,190000],[340000,190000],[340000,160000]] };
$maps{"B:155"} = { bbox => [[352400, 160000], [380000, 182000]], polygon => [[353000,160000],[380000,160000],[380000,182000],[353000,182000],[353000,176800],[352400,176000],[353000,175000],[353000,160000]] };
$maps{"B:156"} = { bbox => [[380000, 153000], [400000, 183000]], polygon => [[380000,153000],[400000,153000],[400000,183000],[380000,183000],[380000,153000]] };
$maps{"B:157"} = { bbox => [[399400, 159600], [430000, 180000]], polygon => [[400000,160000],[415700,160000],[415700,159600],[417300,159600],[417300,160000],[430000,160000],[430000,180000],[400000,180000],[400000,172700],[399400,172300],[399400,170400],[400000,170000],[400000,162000],[399700,162000],[399700,161000],[400000,160900],[400000,160000]] };
$maps{"B:158"} = { bbox => [[428000, 160000], [458000, 180000]], polygon => [[428000,160000],[458000,160000],[458000,180000],[428000,180000],[428000,160000]] };
$maps{"B:159"} = { bbox => [[455000, 160000], [485000, 180000]], polygon => [[455000,160000],[485000,160000],[485000,180000],[455000,180000],[455000,160000]] };
$maps{"B:160"} = { bbox => [[480000, 160000], [510000, 180000]], polygon => [[480000,160000],[510000,160000],[510000,180000],[480000,180000],[480000,160000]] };
$maps{"B:161"} = { bbox => [[510000, 160000], [540000, 180000]], polygon => [[510000,160000],[540000,160000],[540000,180000],[510000,180000],[510000,160000]] };
$maps{"B:162"} = { bbox => [[536000, 165000], [566000, 185000]], polygon => [[536000,165000],[566000,165000],[566000,185000],[536000,185000],[536000,165000]] };
$maps{"B:163"} = { bbox => [[563000, 162000], [590450, 184000]], polygon => [[563000,162000],[590000,162000],[590000,175700],[590450,177000],[590400,177500],[590300,177900],[590000,178400],[590000,184000],[563000,184000],[563000,162000]] };
$maps{"B:164"} = { bbox => [[235000, 184000], [265000, 204000]], polygon => [[235000,184000],[265000,184000],[265000,204000],[235000,204000],[235000,184000]] };
$maps{"B:165"} = { bbox => [[260000, 181000], [282000, 211000]], polygon => [[260000,186000],[273000,186000],[273000,181000],[282000,181000],[282000,211000],[260000,211000],[260000,186000]] };
$maps{"B:166E"} = { bbox => [[301000, 186000], [321000, 209000]], polygon => [[301000,186000],[321000,186000],[321000,209000],[301000,209000],[301000,186000]] };
$maps{"B:166W"} = { bbox => [[281000, 186000], [301000, 206000]], polygon => [[281000,186000],[301000,186000],[301000,206000],[281000,206000],[281000,186000]] };
$maps{"B:167"} = { bbox => [[353000, 181000], [380000, 203000]], polygon => [[353000,181000],[380000,181000],[380000,203000],[353000,203000],[353000,181000]] };
$maps{"B:168"} = { bbox => [[378000, 180000], [400000, 207000]], polygon => [[378000,180000],[400000,180000],[400000,207000],[378000,207000],[378000,180000]] };
$maps{"B:169"} = { bbox => [[400000, 175000], [420000, 205000]], polygon => [[400000,175000],[420000,175000],[420000,205000],[400000,205000],[400000,175000]] };
$maps{"B:170E"} = { bbox => [[442000, 180000], [462000, 200000]], polygon => [[442000,180000],[462000,180000],[462000,200000],[442000,200000],[442000,180000]] };
$maps{"B:170W"} = { bbox => [[419000, 180000], [442000, 200000]], polygon => [[419000,180000],[442000,180000],[442000,200000],[419000,200000],[419000,180000]] };
$maps{"B:171"} = { bbox => [[459000, 173680], [481000, 201000]], polygon => [[459000,174000],[470000,174000],[472000,173680],[474000,173680],[476000,174000],[481000,174000],[481000,201000],[459000,201000],[459000,174000]] };
$maps{"B:172"} = { bbox => [[480000, 180000], [510000, 200000]], polygon => [[480000,180000],[510000,180000],[510000,200000],[480000,200000],[480000,180000]] };
$maps{"B:173"} = { bbox => [[510000, 178000], [537000, 200000]], polygon => [[510000,178000],[537000,178000],[537000,200000],[510000,200000],[510000,178000]] };
$maps{"B:174"} = { bbox => [[530000, 185000], [550000, 215000]], polygon => [[530000,185000],[550000,185000],[550000,215000],[530000,215000],[530000,185000]] };
$maps{"B:175E"} = { bbox => [[570000, 180000], [593000, 200000]], polygon => [[570000,180000],[593000,180000],[593000,200000],[570000,200000],[570000,180000]] };
$maps{"B:175W"} = { bbox => [[550000, 180000], [570000, 200000]], polygon => [[550000,180000],[570000,180000],[570000,200000],[550000,200000],[550000,180000]] };
$maps{"B:176"} = { bbox => [[584000, 183000], [606000, 211000]], polygon => [[584000,184000],[587000,184000],[588000,183600],[588700,183000],[589200,183000],[589900,184000],[592400,184000],[592800,183800],[593800,183800],[593950,184000],[606000,184000],[606000,211000],[584000,211000],[584000,184000]] };
$maps{"B:177"} = { bbox => [[216000, 204000], [246000, 224000]], polygon => [[216000,204000],[246000,204000],[246000,224000],[216000,224000],[216000,204000]] };
$maps{"B:178"} = { bbox => [[237000, 198000], [267000, 218000]], polygon => [[237000,198000],[267000,198000],[267000,218000],[237000,218000],[237000,198000]] };
$maps{"B:179"} = { bbox => [[378000, 203000], [400000, 230000]], polygon => [[378000,203000],[400000,203000],[400000,230000],[378000,230000],[378000,203000]] };
$maps{"B:180E"} = { bbox => [[449000, 200000], [472200, 220000]], polygon => [[449000,200000],[472000,200000],[472000,204500],[472200,205000],[472200,206000],[472000,206400],[472000,220000],[449000,220000],[449000,200000]] };
$maps{"B:180W"} = { bbox => [[429500, 200000], [449500, 220000]], polygon => [[429500,200000],[449500,200000],[449500,220000],[429500,220000],[429500,200000]] };
$maps{"B:181"} = { bbox => [[472000, 200000], [502000, 220000]], polygon => [[472000,200000],[502000,200000],[502000,220000],[472000,220000],[472000,200000]] };
$maps{"B:182"} = { bbox => [[500000, 200000], [530000, 220000]], polygon => [[500000,200000],[530000,200000],[530000,220000],[500000,220000],[500000,200000]] };
$maps{"B:183E"} = { bbox => [[567000, 200000], [590000, 220000]], polygon => [[567000,200000],[590000,200000],[590000,220000],[567000,220000],[567000,200000]] };
$maps{"B:183W"} = { bbox => [[550000, 200000], [570000, 220000]], polygon => [[550000,200000],[570000,200000],[570000,220000],[550000,220000],[550000,200000]] };
$maps{"B:184W"} = { bbox => [[590000, 210000], [610000, 230000]], polygon => [[590000,210000],[610000,210000],[610000,230000],[590000,230000],[590000,210000]] };
$maps{"B:184E"} = { bbox => [[607000, 211000], [627000, 234000]], polygon => [[607000,211000],[627000,211000],[627000,234000],[607000,234000],[607000,211000]] };
$maps{"B:185"} = { bbox => [[220000, 223000], [247000, 245000]], polygon => [[220000,223000],[247000,223000],[247000,245000],[220000,245000],[220000,223000]] };
$maps{"B:186"} = { bbox => [[246000, 218000], [268000, 245000]], polygon => [[246000,218000],[268000,218000],[268000,245000],[246000,245000],[246000,218000]] };
$maps{"B:187S"} = { bbox => [[267000, 232000], [290000, 252000]], polygon => [[267000,232000],[290000,232000],[290000,252000],[267000,252000],[267000,232000]] };
$maps{"B:187N"} = { bbox => [[270000, 248000], [290000, 268000]], polygon => [[270000,248000],[290000,248000],[290000,268000],[270000,268000],[270000,248000]] };
$maps{"B:188"} = { bbox => [[290000, 233000], [320000, 253000]], polygon => [[290000,233000],[320000,233000],[320000,253000],[290000,253000],[290000,233000]] };
$maps{"B:189"} = { bbox => [[340000, 220000], [370000, 242000]], polygon => [[340000,220000],[364000,220000],[364000,227200],[364400,227600],[364400,228000],[364000,228450],[364000,230000],[370000,230000],[370000,242000],[340000,242000],[340000,220000]] };
$maps{"B:190"} = { bbox => [[370000, 230000], [400000, 250000]], polygon => [[370000,230000],[400000,230000],[400000,250000],[370000,250000],[370000,230000]] };
$maps{"B:191W"} = { bbox => [[428000, 220000], [448000, 243000]], polygon => [[428000,220000],[448000,220000],[448000,243000],[428000,243000],[428000,220000]] };
$maps{"B:191E"} = { bbox => [[444000, 220000], [464000, 240000]], polygon => [[444000,220000],[464000,220000],[464000,240000],[444000,240000],[444000,220000]] };
$maps{"B:192E"} = { bbox => [[480000, 220000], [500000, 243000]], polygon => [[480000,220000],[500000,220000],[500000,243000],[480000,243000],[480000,220000]] };
$maps{"B:192W"} = { bbox => [[460000, 220000], [480000, 240000]], polygon => [[460000,220000],[480000,220000],[480000,240000],[460000,240000],[460000,220000]] };
$maps{"B:193"} = { bbox => [[500000, 220000], [530000, 240000]], polygon => [[500000,220000],[530000,220000],[530000,240000],[500000,240000],[500000,220000]] };
$maps{"B:194"} = { bbox => [[530000, 210000], [550800, 240000]], polygon => [[530000,210000],[550000,210000],[550000,220000],[550500,220250],[550800,221800],[550450,222700],[550000,223400],[550000,240000],[530000,240000],[530000,210000]] };
$maps{"B:195W"} = { bbox => [[547000, 220000], [570000, 240000]], polygon => [[547000,220000],[570000,220000],[570000,240000],[547000,240000],[547000,220000]] };
$maps{"B:195E"} = { bbox => [[570000, 220000], [590000, 240000]], polygon => [[570000,220000],[590000,220000],[590000,240000],[570000,240000],[570000,220000]] };
$maps{"B:196"} = { bbox => [[580000, 230000], [610000, 250000]], polygon => [[580000,230000],[610000,230000],[610000,250000],[580000,250000],[580000,230000]] };
$maps{"B:197"} = { bbox => [[609380, 229000], [640000, 251000]], polygon => [[610000,229000],[630500,229000],[630500,234000],[635000,234000],[635000,237000],[640000,237000],[640000,251000],[610000,251000],[610000,232900],[609600,232500],[609380,231000],[609580,230700],[610000,230850],[610000,229000]] };
$maps{"B:198W"} = { bbox => [[213000, 240000], [233000, 260000]], polygon => [[213000,240000],[233000,240000],[233000,260000],[213000,260000],[213000,240000]] };
$maps{"B:198E"} = { bbox => [[231000, 245000], [251700, 268000]], polygon => [[231000,245000],[251000,245000],[251000,267200],[251300,267400],[251700,268000],[231000,268000],[231000,245000]] };
$maps{"B:199"} = { bbox => [[248000, 243000], [270000, 270000]], polygon => [[248000,243000],[270000,243000],[270000,270000],[248000,270000],[248000,243000]] };
$maps{"B:200W"} = { bbox => [[280000, 253000], [300000, 273000]], polygon => [[280000,253000],[300000,253000],[300000,273000],[280000,273000],[280000,253000]] };
$maps{"B:200E"} = { bbox => [[300000, 250000], [320000, 273000]], polygon => [[300000,250000],[320000,250000],[320000,273000],[300000,273000],[300000,250000]] };
$maps{"B:201N"} = { bbox => [[320000, 260000], [340000, 283000]], polygon => [[320000,260000],[340000,260000],[340000,283000],[320000,283000],[320000,260000]] };
$maps{"B:201S"} = { bbox => [[320000, 240000], [340000, 260000]], polygon => [[320000,240000],[340000,240000],[340000,260000],[320000,260000],[320000,240000]] };
$maps{"B:202"} = { bbox => [[340000, 240000], [370000, 260000]], polygon => [[340000,240000],[370000,240000],[370000,260000],[340000,260000],[340000,240000]] };
$maps{"B:203"} = { bbox => [[340000, 260000], [370000, 280000]], polygon => [[340000,260000],[370000,260000],[370000,280000],[340000,280000],[340000,260000]] };
$maps{"B:204"} = { bbox => [[370000, 250000], [400000, 270000]], polygon => [[370000,250000],[400000,250000],[400000,270000],[370000,270000],[370000,250000]] };
$maps{"B:205"} = { bbox => [[400000, 240000], [430000, 260000]], polygon => [[400000,240000],[430000,240000],[430000,260000],[400000,260000],[400000,240000]] };
$maps{"B:206"} = { bbox => [[430000, 240000], [460000, 260000]], polygon => [[430000,240000],[460000,240000],[460000,260000],[430000,260000],[430000,240000]] };
$maps{"B:207E"} = { bbox => [[473000, 240000], [493000, 263000]], polygon => [[473000,240000],[493000,240000],[493000,263000],[473000,263000],[473000,240000]] };
$maps{"B:207W"} = { bbox => [[455000, 240000], [475000, 260000]], polygon => [[455000,240000],[475000,240000],[475000,260000],[455000,260000],[455000,240000]] };
$maps{"B:208W"} = { bbox => [[493000, 240000], [513000, 260000]], polygon => [[493000,240000],[513000,240000],[513000,260000],[493000,260000],[493000,240000]] };
$maps{"B:208E"} = { bbox => [[513000, 240000], [533000, 263000]], polygon => [[513000,240000],[533000,240000],[533000,263000],[513000,263000],[513000,240000]] };
$maps{"B:209"} = { bbox => [[533000, 240000], [560000, 262400]], polygon => [[533000,240000],[560000,240000],[560000,262000],[548200,262000],[547200,262400],[546800,262400],[545300,262000],[533000,262000],[533000,240000]] };
$maps{"B:210"} = { bbox => [[560000, 240000], [580000, 270000]], polygon => [[560000,240000],[580000,240000],[580000,270000],[560000,270000],[560000,240000]] };
$maps{"B:211W"} = { bbox => [[580000, 250000], [600000, 270000]], polygon => [[580000,250000],[600000,250000],[600000,270000],[580000,270000],[580000,250000]] };
$maps{"B:211E"} = { bbox => [[600000, 250000], [623000, 270000]], polygon => [[600000,250000],[623000,250000],[623000,270000],[600000,270000],[600000,250000]] };
$maps{"B:212"} = { bbox => [[621000, 246000], [648000, 268000]], polygon => [[621000,246000],[648000,246000],[648000,268000],[621000,268000],[621000,246000]] };
$maps{"B:213"} = { bbox => [[251000, 268000], [281000, 290000]], polygon => [[251000,268000],[281000,268000],[281000,290000],[257000,290000],[257000,280000],[251000,280000],[251000,268000]] };
$maps{"B:214E"} = { bbox => [[300000, 270000], [320000, 293000]], polygon => [[300000,270000],[320000,270000],[320000,293000],[300000,293000],[300000,270000]] };
$maps{"B:214W"} = { bbox => [[280000, 273000], [300000, 293000]], polygon => [[280000,273000],[300000,273000],[300000,293000],[280000,293000],[280000,273000]] };
$maps{"B:215W"} = { bbox => [[274580, 290000], [298000, 310000]], polygon => [[275000,290000],[298000,290000],[298000,310000],[275000,310000],[275000,301620],[274580,301520],[274580,300500],[275000,300500],[275000,290000]] };
$maps{"B:215E"} = { bbox => [[298000, 290000], [318000, 310000]], polygon => [[298000,290000],[318000,290000],[318000,310000],[298000,310000],[298000,290000]] };
$maps{"B:216"} = { bbox => [[318000, 283000], [340000, 310000]], polygon => [[318000,283000],[340000,283000],[340000,310000],[318000,310000],[318000,283000]] };
$maps{"B:217"} = { bbox => [[335000, 280000], [365000, 300350]], polygon => [[335000,280000],[365000,280000],[365000,300000],[363500,300000],[363500,300350],[363050,300310],[361950,300310],[361500,300100],[361500,300000],[335000,300000],[335000,280000]] };
$maps{"B:218"} = { bbox => [[365000, 270000], [385000, 300000]], polygon => [[365000,270000],[385000,270000],[385000,300000],[365000,300000],[365000,270000]] };
$maps{"B:219N"} = { bbox => [[380000, 287000], [400000, 307000]], polygon => [[380000,287000],[400000,287000],[400000,307000],[380000,307000],[380000,287000]] };
$maps{"B:219S"} = { bbox => [[380000, 270000], [400000, 293000]], polygon => [[380000,270000],[400000,270000],[400000,293000],[380000,293000],[380000,270000]] };
$maps{"B:220N"} = { bbox => [[400000, 280000], [420250, 303000]], polygon => [[400000,280000],[420000,280000],[420000,282000],[420220,282400],[420250,282900],[420250,283250],[420000,284000],[420000,303000],[400000,303000],[400000,280000]] };
$maps{"B:220S"} = { bbox => [[399580, 260000], [420000, 280000]], polygon => [[400000,260000],[420000,260000],[420000,280000],[400000,280000],[400000,276500],[399580,275920],[399580,274600],[400000,274000],[400000,260000]] };
$maps{"B:221"} = { bbox => [[420000, 260000], [440000, 290000]], polygon => [[420000,260000],[440000,260000],[440000,290000],[420000,290000],[420000,260000]] };
$maps{"B:222"} = { bbox => [[440000, 260000], [460400, 290000]], polygon => [[440000,260000],[460000,260000],[460000,265000],[460400,265500],[460400,266000],[460200,266300],[460000,266500],[460000,290000],[440000,290000],[440000,260000]] };
$maps{"B:223S"} = { bbox => [[460000, 256000], [483000, 276000]], polygon => [[460000,256000],[483000,256000],[483000,276000],[460000,276000],[460000,256000]] };
$maps{"B:223N"} = { bbox => [[460000, 274000], [480000, 294000]], polygon => [[460000,274000],[480000,274000],[480000,294000],[460000,294000],[460000,274000]] };
$maps{"B:224N"} = { bbox => [[480000, 280000], [503000, 300000]], polygon => [[480000,280000],[503000,280000],[503000,300000],[492000,300000],[492000,295000],[480000,295000],[480000,280000]] };
$maps{"B:224S"} = { bbox => [[480000, 260000], [503000, 280000]], polygon => [[480000,260000],[503000,260000],[503000,280000],[480000,280000],[480000,260000]] };
$maps{"B:225W"} = { bbox => [[503000, 260000], [526000, 280000]], polygon => [[503000,260000],[526000,260000],[526000,280000],[503000,280000],[503000,260000]] };
$maps{"B:225E"} = { bbox => [[526000, 260000], [546000, 280000]], polygon => [[526000,260000],[546000,260000],[546000,280000],[526000,280000],[526000,260000]] };
$maps{"B:226"} = { bbox => [[546000, 262000], [576000, 282200]], polygon => [[546000,262000],[576000,262000],[576000,282000],[555200,282000],[555200,282060],[554650,282200],[554450,282000],[546000,282000],[546000,262000]] };
$maps{"B:227W"} = { bbox => [[503000, 280000], [523000, 303000]], polygon => [[503000,280000],[523000,280000],[523000,303000],[503000,303000],[503000,280000]] };
$maps{"B:227E"} = { bbox => [[523000, 280000], [543000, 300000]], polygon => [[523000,280000],[543000,280000],[543000,300000],[523000,300000],[523000,280000]] };
$maps{"B:228W"} = { bbox => [[538550, 279300], [556000, 303000]], polygon => [[539000,280000],[552000,280000],[552600,279350],[554350,279300],[555000,280000],[556000,280000],[556000,303000],[539000,303000],[539000,287400],[538800,287250],[538800,286800],[538550,285800],[538550,284900],[539000,284700],[539000,280000]] };
$maps{"B:228E"} = { bbox => [[555000, 280000], [575000, 303000]], polygon => [[555000,280000],[575000,280000],[575000,303000],[555000,303000],[555000,280000]] };
$maps{"B:229"} = { bbox => [[575000, 270000], [595000, 300000]], polygon => [[575000,270000],[595000,270000],[595000,300000],[575000,300000],[575000,270000]] };
$maps{"B:230E"} = { bbox => [[610000, 267000], [630000, 290000]], polygon => [[610000,267000],[630000,267000],[630000,290000],[610000,290000],[610000,267000]] };
$maps{"B:230W"} = { bbox => [[590000, 270000], [610000, 290000]], polygon => [[590000,270000],[610000,270000],[610000,290000],[590000,290000],[590000,270000]] };
$maps{"B:231"} = { bbox => [[627000, 268000], [654000, 290400]], polygon => [[627000,268000],[654000,268000],[654000,290000],[634500,290000],[633300,290400],[632800,290000],[627000,290000],[627000,268000]] };
$maps{"B:232"} = { bbox => [[411050, 289000], [441500, 311500]], polygon => [[411500,299000],[417500,299000],[417500,289000],[441500,289000],[441500,311000],[412600,311000],[412330,311450],[412200,311450],[412000,311500],[411800,311500],[411600,311450],[411050,311450],[411050,308000],[411500,308000],[411500,299000]] };
$maps{"B:233W"} = { bbox => [[441500, 287000], [461500, 310000]], polygon => [[441500,287000],[461500,287000],[461500,310000],[441500,310000],[441500,287000]] };
$maps{"B:233E"} = { bbox => [[461500, 289650], [482000, 310000]], polygon => [[461500,290000],[468000,290000],[468500,289650],[470500,289650],[471000,290000],[481500,290000],[481500,299400],[481850,300000],[482000,300500],[482000,301350],[481500,302300],[481500,310000],[461500,310000],[461500,290000]] };
$maps{"B:234"} = { bbox => [[480000, 295000], [510000, 315000]], polygon => [[480000,295000],[510000,295000],[510000,315000],[480000,315000],[480000,295000]] };
$maps{"B:235W"} = { bbox => [[510000, 297000], [530000, 320000]], polygon => [[510000,297000],[530000,297000],[530000,320000],[510000,320000],[510000,297000]] };
$maps{"B:235E"} = { bbox => [[530000, 300000], [550000, 320000]], polygon => [[530000,300000],[550000,300000],[550000,320000],[530000,320000],[530000,300000]] };
$maps{"B:236W"} = { bbox => [[550000, 300000], [570000, 323000]], polygon => [[550000,300000],[570000,300000],[570000,323000],[550000,323000],[550000,300000]] };
$maps{"B:236E"} = { bbox => [[570000, 300000], [590000, 320000]], polygon => [[570000,300000],[590000,300000],[590000,320000],[570000,320000],[570000,300000]] };
$maps{"B:237E"} = { bbox => [[609000, 290000], [629000, 313000]], polygon => [[609000,290000],[629000,290000],[629000,313000],[609000,313000],[609000,290000]] };
$maps{"B:237W"} = { bbox => [[589000, 290000], [609000, 310000]], polygon => [[589000,290000],[609000,290000],[609000,310000],[589000,310000],[589000,290000]] };
$maps{"B:238W"} = { bbox => [[580000, 310000], [600000, 330000]], polygon => [[580000,310000],[600000,310000],[600000,330000],[580000,330000],[580000,310000]] };
$maps{"B:238E"} = { bbox => [[600000, 310000], [623000, 330000]], polygon => [[600000,310000],[623000,310000],[623000,330000],[600000,330000],[600000,310000]] };
$maps{"B:239"} = { bbox => [[294000, 306000], [321750, 328000]], polygon => [[294000,306000],[321000,306000],[321000,307000],[321150,307000],[321750,307500],[321750,307900],[321200,308500],[321000,308600],[321000,328000],[294000,328000],[294000,306000]] };
$maps{"B:240"} = { bbox => [[320000, 310000], [340450, 340000]], polygon => [[320000,310000],[340000,310000],[340000,333900],[340450,334200],[340450,335500],[340000,335950],[340000,340000],[320000,340000],[320000,310000]] };
$maps{"B:241S"} = { bbox => [[340000, 300000], [360000, 320000]], polygon => [[340000,300000],[360000,300000],[360000,320000],[340000,320000],[340000,300000]] };
$maps{"B:241N"} = { bbox => [[340000, 317000], [360000, 340000]], polygon => [[340000,317000],[360000,317000],[360000,340000],[340000,340000],[340000,317000]] };
$maps{"B:242"} = { bbox => [[360000, 300000], [390000, 320000]], polygon => [[360000,300000],[390000,300000],[390000,320000],[360000,320000],[360000,300000]] };
$maps{"B:243"} = { bbox => [[360000, 320000], [390000, 340000]], polygon => [[360000,320000],[390000,320000],[390000,340000],[360000,340000],[360000,320000]] };
$maps{"B:244"} = { bbox => [[390000, 303000], [412000, 330000]], polygon => [[390000,303000],[412000,303000],[412000,330000],[390000,330000],[390000,303000]] };
$maps{"B:245W"} = { bbox => [[411000, 310000], [431000, 330000]], polygon => [[411000,310000],[431000,310000],[431000,330000],[411000,330000],[411000,310000]] };
$maps{"B:245E"} = { bbox => [[431000, 307000], [451000, 330000]], polygon => [[431000,307000],[451000,307000],[451000,330000],[431000,330000],[431000,307000]] };
$maps{"B:246"} = { bbox => [[450000, 309450], [480000, 330000]], polygon => [[450000,310000],[451400,310000],[451700,309700],[452000,309600],[452500,309550],[453000,309450],[453200,309450],[453850,309900],[454150,310000],[480000,310000],[480000,330000],[450000,330000],[450000,310000]] };
$maps{"B:247"} = { bbox => [[480000, 315000], [500000, 345000]], polygon => [[480000,315000],[500000,315000],[500000,345000],[480000,345000],[480000,315000]] };
$maps{"B:248"} = { bbox => [[500000, 315000], [520000, 345000]], polygon => [[500000,315000],[520000,315000],[520000,345000],[500000,345000],[500000,315000]] };
$maps{"B:249W"} = { bbox => [[520000, 320000], [540000, 340000]], polygon => [[520000,320000],[540000,320000],[540000,340000],[520000,340000],[520000,320000]] };
$maps{"B:249E"} = { bbox => [[540000, 320000], [563000, 340000]], polygon => [[540000,320000],[563000,320000],[563000,340000],[540000,340000],[540000,320000]] };
$maps{"B:250"} = { bbox => [[559550, 317000], [582000, 347000]], polygon => [[560000,317000],[582000,317000],[582000,347000],[565000,347000],[565000,335000],[560000,335000],[560000,326100],[559700,325600],[559700,325600],[559700,325000],[559550,324850],[559550,324900],[560000,323900],[560000,317000]] };
$maps{"B:251"} = { bbox => [[581000, 328000], [611000, 348000]], polygon => [[581000,328000],[611000,328000],[611000,348000],[581000,348000],[581000,328000]] };
$maps{"B:252"} = { bbox => [[610000, 323000], [640000, 345000]], polygon => [[610000,323000],[640000,323000],[640000,339000],[630000,339000],[630000,345000],[610000,345000],[610000,323000]] };
$maps{"B:253"} = { bbox => [[213000, 323000], [240000, 345000]], polygon => [[213000,323000],[240000,323000],[240000,345000],[213000,345000],[213000,323000]] };
$maps{"B:253 Inset"} = { bbox => [[210000, 320000], [213000, 323500]], polygon => [[210000,320000],[213000,320000],[213000,323500],[210000,323500],[210000,320000]] };
$maps{"B:254"} = { bbox => [[234600, 334000], [257400, 361200]], polygon => [[235000,334000],[257000,334000],[257000,337750],[257300,338000],[257400,338400],[257400,338600],[257300,338650],[257000,339100],[257000,361000],[244400,361000],[244300,361200],[243600,361200],[243500,361000],[235000,361000],[235000,346000],[234600,345500],[234600,344800],[234700,344500],[235000,344080],[235000,334000]] };
$maps{"B:255"} = { bbox => [[298000, 325000], [328700, 347000]], polygon => [[298000,325000],[314000,325000],[314000,328000],[322000,328000],[322000,331000],[328000,331000],[328000,336300],[328700,337000],[328700,341300],[328000,342000],[328000,347000],[298000,347000],[298000,325000]] };
$maps{"B:256"} = { bbox => [[307000, 337000], [337000, 359000]], polygon => [[307000,342000],[319000,342000],[319000,337000],[337000,337000],[337000,359000],[307000,359000],[307000,342000]] };
$maps{"B:257E"} = { bbox => [[357000, 340000], [380000, 360000]], polygon => [[357000,340000],[380000,340000],[380000,360000],[357000,360000],[357000,340000]] };
$maps{"B:257W"} = { bbox => [[337000, 340000], [357000, 360450]], polygon => [[337000,340000],[357000,340000],[357000,360000],[349450,360000],[349100,360450],[347050,360450],[346750,360000],[337000,360000],[337000,340000]] };
$maps{"B:258"} = { bbox => [[380000, 330000], [400000, 360000]], polygon => [[380000,330000],[400000,330000],[400000,360000],[380000,360000],[380000,330000]] };
$maps{"B:259E"} = { bbox => [[420000, 330000], [443000, 350000]], polygon => [[420000,330000],[443000,330000],[443000,350000],[420000,350000],[420000,330000]] };
$maps{"B:259W"} = { bbox => [[400000, 330000], [420000, 350000]], polygon => [[400000,330000],[420000,330000],[420000,350000],[400000,350000],[400000,330000]] };
$maps{"B:260W"} = { bbox => [[440000, 330000], [463000, 350000]], polygon => [[440000,330000],[463000,330000],[463000,350000],[440000,350000],[440000,330000]] };
$maps{"B:260E"} = { bbox => [[463000, 329200], [483000, 350000]], polygon => [[463000,330000],[468200,330000],[468600,329350],[470500,329350],[471000,329200],[471700,329450],[472500,329400],[473000,329500],[473400,330000],[483000,330000],[483000,350000],[463000,350000],[463000,330000]] };
$maps{"B:261E"} = { bbox => [[530000, 340000], [553000, 360000]], polygon => [[530000,340000],[553000,340000],[553000,360000],[530000,360000],[530000,340000]] };
$maps{"B:261W"} = { bbox => [[510000, 340000], [530000, 360000]], polygon => [[510000,340000],[530000,340000],[530000,360000],[510000,360000],[510000,340000]] };
$maps{"B:262"} = { bbox => [[220000, 366000], [242000, 396000]], polygon => [[220000,371000],[232000,371000],[232000,366000],[242000,366000],[242000,396000],[220000,396000],[220000,371000]] };
$maps{"B:263S"} = { bbox => [[235800, 360000], [259000, 380000]], polygon => [[236000,360000],[259000,360000],[259000,380000],[236000,380000],[236000,366000],[235800,365800],[235800,365700],[236000,365400],[236000,360000]] };
$maps{"B:263N"} = { bbox => [[242000, 375000], [265700, 395000]], polygon => [[242000,375000],[265000,375000],[265000,381800],[265700,382450],[265700,382550],[265000,382500],[265000,389000],[255000,389000],[255000,395000],[242000,395000],[242000,375000]] };
$maps{"B:264N"} = { bbox => [[290000, 365000], [310000, 385000]], polygon => [[290000,365000],[310000,365000],[310000,385000],[290000,385000],[290000,365000]] };
$maps{"B:264S"} = { bbox => [[290000, 345000], [313000, 365000]], polygon => [[290000,345000],[313000,345000],[313000,365000],[290000,365000],[290000,345000]] };
$maps{"B:265"} = { bbox => [[305000, 355000], [325000, 385850]], polygon => [[305000,355000],[325000,355000],[325000,385000],[314000,385000],[312800,385850],[310500,385850],[307700,385000],[305000,385000],[305000,355000]] };
$maps{"B:266N"} = { bbox => [[318000, 376000], [339000, 396000]], polygon => [[319000,376000],[339000,376000],[339000,396000],[319000,396000],[319000,389500],[318000,388300],[318200,387500],[318300,387000],[319000,385900],[319000,376000]] };
$maps{"B:266S"} = { bbox => [[325000, 359000], [348000, 379500]], polygon => [[325000,359000],[348000,359000],[348000,379000],[340000,379000],[339500,379400],[339000,379500],[338500,379300],[338000,379000],[325000,379000],[325000,359000]] };
$maps{"B:267"} = { bbox => [[348000, 360000], [375000, 382000]], polygon => [[348000,360000],[375000,360000],[375000,382000],[348000,382000],[348000,360000]] };
$maps{"B:268N"} = { bbox => [[373550, 373000], [397450, 390450]], polygon => [[374000,373000],[397000,373000],[397000,379000],[397400,379500],[397450,379800],[397450,381400],[397000,382000],[397000,390000],[396800,390200],[396500,390450],[394200,390450],[393800,390000],[374000,390000],[374000,382100],[373550,381500],[373550,380800],[374000,380100],[374000,373000]] };
$maps{"B:268S"} = { bbox => [[374000, 354000], [397000, 374000]], polygon => [[374000,354000],[397000,354000],[397000,374000],[374000,374000],[374000,354000]] };
$maps{"B:269"} = { bbox => [[432000, 350000], [452000, 380000]], polygon => [[432000,350000],[452000,350000],[452000,380000],[432000,380000],[432000,350000]] };
$maps{"B:270"} = { bbox => [[450000, 350000], [470000, 380000]], polygon => [[450000,350000],[470000,350000],[470000,380000],[450000,380000],[450000,350000]] };
$maps{"B:271S"} = { bbox => [[469200, 345000], [490000, 365000]], polygon => [[470000,345000],[490000,345000],[490000,365000],[470000,365000],[470000,355650],[469370,355000],[469200,354500],[469200,354000],[469250,353500],[469550,353000],[470000,352600],[470000,345000]] };
$maps{"B:271N"} = { bbox => [[470000, 365000], [490000, 388000]], polygon => [[470000,365000],[490000,365000],[490000,388000],[470000,388000],[470000,365000]] };
$maps{"B:272N"} = { bbox => [[490000, 365000], [510000, 388000]], polygon => [[490000,365000],[510000,365000],[510000,388000],[490000,388000],[490000,365000]] };
$maps{"B:272S"} = { bbox => [[490000, 344550], [510000, 365000]], polygon => [[490000,345000],[505000,345000],[505500,344600],[506000,344550],[507000,344550],[507500,344700],[508000,345000],[510000,345000],[510000,365000],[490000,365000],[490000,345000]] };
$maps{"B:273"} = { bbox => [[510000, 360000], [540650, 380000]], polygon => [[510000,360000],[540000,360000],[540000,365200],[540600,365700],[540650,366000],[540350,366650],[540000,366900],[540000,380000],[510000,380000],[510000,360000]] };
$maps{"B:274"} = { bbox => [[538000, 353000], [558000, 383000]], polygon => [[538000,353000],[558000,353000],[558000,383000],[538000,383000],[538000,353000]] };
$maps{"B:275"} = { bbox => [[329000, 379000], [359000, 401000]], polygon => [[329000,395000],[332000,395000],[332000,384000],[335000,384000],[335000,379000],[359000,379000],[359000,401000],[329000,401000],[329000,395000]] };
$maps{"B:276"} = { bbox => [[355000, 382000], [375400, 412000]], polygon => [[355000,382000],[375000,382000],[375000,398450],[375200,398800],[375300,399000],[375400,399200],[375000,399500],[375000,412000],[355000,412000],[355000,382000]] };
$maps{"B:277"} = { bbox => [[374500, 388000], [397000, 415450]], polygon => [[375000,388000],[397000,388000],[397000,415000],[394500,415000],[394100,415450],[393200,415450],[393000,415200],[392900,415000],[375000,415000],[375000,407000],[374700,406500],[374550,406100],[374600,406000],[375000,405000],[375000,401200],[374500,400500],[374500,399700],[374700,399000],[374800,398500],[375000,398180],[375000,388000]] };
$maps{"B:278S"} = { bbox => [[427000, 380000], [447000, 400000]], polygon => [[427000,380000],[447000,380000],[447000,400000],[427000,400000],[427000,380000]] };
$maps{"B:278N"} = { bbox => [[426600, 400000], [450000, 420000]], polygon => [[427000,400000],[450000,400000],[450000,420000],[427000,420000],[427000,403000],[426600,402500],[426600,402200],[427000,401750],[427000,400000]] };
$maps{"B:279N"} = { bbox => [[450000, 400000], [470000, 420000]], polygon => [[450000,400000],[470000,400000],[470000,420000],[450000,420000],[450000,400000]] };
$maps{"B:279S"} = { bbox => [[447000, 380000], [470000, 400000]], polygon => [[447000,380000],[470000,380000],[470000,400000],[447000,400000],[447000,380000]] };
$maps{"B:280"} = { bbox => [[470000, 388000], [492000, 415000]], polygon => [[470000,388000],[492000,388000],[492000,415000],[470000,415000],[470000,388000]] };
$maps{"B:281N"} = { bbox => [[487000, 406000], [510000, 426000]], polygon => [[487000,406000],[510000,406000],[510000,426000],[487000,426000],[487000,406000]] };
$maps{"B:281S"} = { bbox => [[490000, 388000], [510000, 408000]], polygon => [[490000,388000],[510000,388000],[510000,408000],[490000,408000],[490000,388000]] };
$maps{"B:282"} = { bbox => [[510000, 380000], [537000, 402000]], polygon => [[510000,380000],[537000,380000],[537000,402000],[510000,402000],[510000,380000]] };
$maps{"B:283"} = { bbox => [[532000, 378000], [554000, 408000]], polygon => [[532000,378000],[554000,378000],[554000,402000],[544000,402000],[544000,408000],[532000,408000],[532000,378000]] };
$maps{"B:284"} = { bbox => [[510000, 396000], [532600, 426000]], polygon => [[510000,396000],[532000,396000],[532000,405900],[532300,406000],[532600,406350],[532600,406900],[532000,407500],[532000,420000],[522000,420000],[522000,426000],[510000,426000],[510000,396000]] };
$maps{"B:285W"} = { bbox => [[324000, 400000], [344000, 423000]], polygon => [[324000,400000],[344000,400000],[344000,423000],[324000,423000],[324000,400000]] };
$maps{"B:285E"} = { bbox => [[344000, 400000], [364000, 423000]], polygon => [[344000,400000],[359000,400000],[359000,412000],[364000,412000],[364000,423000],[344000,423000],[344000,400000]] };
$maps{"B:286"} = { bbox => [[330000, 421000], [360000, 441000]], polygon => [[330000,421000],[360000,421000],[360000,441000],[330000,441000],[330000,421000]] };
$maps{"B:287"} = { bbox => [[357750, 410000], [380500, 440000]], polygon => [[357750,410000],[380500,410000],[380500,413500],[380000,413900],[380000,440000],[360000,440000],[360000,419000],[357750,419000],[357750,410000]] };
$maps{"B:288N"} = { bbox => [[408000, 419000], [428000, 442000]], polygon => [[408000,419000],[428000,419000],[428000,442000],[408000,442000],[408000,419000]] };
$maps{"B:288S"} = { bbox => [[408000, 404000], [428000, 424000]], polygon => [[408000,404000],[428000,404000],[428000,424000],[408000,424000],[408000,404000]] };
$maps{"B:289S"} = { bbox => [[425000, 420000], [448000, 440000]], polygon => [[425000,420000],[448000,420000],[448000,440000],[425000,440000],[425000,420000]] };
$maps{"B:289N"} = { bbox => [[428000, 440000], [448000, 460000]], polygon => [[428000,440000],[448000,440000],[448000,460000],[428000,460000],[428000,440000]] };
$maps{"B:290N"} = { bbox => [[447300, 440000], [471000, 460000]], polygon => [[448000,440000],[471000,440000],[471000,460000],[448000,460000],[448000,444300],[447750,444000],[447550,443600],[447350,443000],[447300,442500],[447350,442000],[447500,441500],[447750,441000],[448000,440700],[448000,440000]] };
$maps{"B:290S"} = { bbox => [[448000, 420000], [468000, 440000]], polygon => [[448000,420000],[468000,420000],[468000,440000],[448000,440000],[448000,420000]] };
$maps{"B:291"} = { bbox => [[467000, 415000], [489000, 442000]], polygon => [[467000,415000],[489000,415000],[489000,442000],[467000,442000],[467000,415000]] };
$maps{"B:292"} = { bbox => [[519000, 415000], [541000, 445000]], polygon => [[519000,415000],[541000,415000],[541000,441000],[526000,441000],[526000,445000],[519000,445000],[519000,415000]] };
$maps{"B:292 Inset"} = { bbox => [[537000, 409000], [542500, 419000]], polygon => [[537000,409000],[542500,409000],[542500,419000],[537000,419000],[537000,409000]] };
$maps{"B:293"} = { bbox => [[489000, 424000], [519450, 444000]], polygon => [[489000,424000],[519000,424000],[519000,427500],[519450,427900],[519450,429000],[519200,429300],[519000,429500],[519000,430000],[519350,430100],[519200,431000],[519000,431200],[519000,444000],[489000,444000],[489000,424000]] };
$maps{"B:294"} = { bbox => [[470000, 440000], [500000, 460000]], polygon => [[470000,440000],[500000,440000],[500000,460000],[470000,460000],[470000,440000]] };
$maps{"B:295"} = { bbox => [[500000, 444000], [522450, 471000]], polygon => [[500000,444000],[522000,444000],[522000,444500],[522200,444500],[522450,444900],[522450,445500],[522000,446100],[522000,471000],[500000,471000],[500000,444000]] };
$maps{"B:296"} = { bbox => [[330000, 440000], [350000, 470000]], polygon => [[330000,440000],[350000,440000],[350000,470000],[330000,470000],[330000,440000]] };
$maps{"B:297"} = { bbox => [[405000, 440000], [435000, 460000]], polygon => [[405000,440000],[435000,440000],[435000,460000],[405000,460000],[405000,440000]] };
$maps{"B:298"} = { bbox => [[405000, 458000], [432200, 480000]], polygon => [[405000,458000],[432000,458000],[432000,470400],[432200,470500],[432000,470700],[432000,480000],[405000,480000],[405000,458000]] };
$maps{"B:299"} = { bbox => [[427000, 460000], [457000, 480000]], polygon => [[427000,460000],[457000,460000],[457000,480000],[427000,480000],[427000,460000]] };
$maps{"B:300W"} = { bbox => [[457000, 460000], [477000, 480000]], polygon => [[457000,460000],[477000,460000],[477000,480000],[457000,480000],[457000,460000]] };
$maps{"B:300E"} = { bbox => [[477000, 460000], [500000, 480000]], polygon => [[477000,460000],[500000,460000],[500000,480000],[477000,480000],[477000,460000]] };
$maps{"B:301"} = { bbox => [[500000, 465000], [522000, 495000]], polygon => [[500000,465000],[522000,465000],[522000,489000],[512000,489000],[512000,495000],[500000,495000],[500000,465000]] };
$maps{"B:301 Inset"} = { bbox => [[520000, 468000], [526000, 475000]], polygon => [[520000,468000],[526000,468000],[526000,475000],[520000,475000],[520000,468000]] };
$maps{"B:302"} = { bbox => [[414000, 480000], [444200, 500000]], polygon => [[414000,480000],[444000,480000],[444000,480900],[444200,481100],[444100,482200],[444000,482600],[444000,500000],[414000,500000],[414000,480000]] };
$maps{"B:303"} = { bbox => [[292000, 503500], [314000, 533500]], polygon => [[292000,503500],[314000,503500],[314000,533500],[297000,533500],[297000,521000],[292000,521000],[292000,503500]] };
$maps{"B:304E"} = { bbox => [[424000, 498000], [444000, 521000]], polygon => [[424000,498000],[444000,498000],[444000,521000],[424000,521000],[424000,498000]] };
$maps{"B:304W"} = { bbox => [[408000, 498000], [425000, 521000]], polygon => [[408000,498000],[425000,498000],[425000,521000],[408000,521000],[408000,498000]] };
$maps{"B:305"} = { bbox => [[410000, 520000], [440000, 540000]], polygon => [[410000,520000],[440000,520000],[440000,540000],[410000,540000],[410000,520000]] };
$maps{"B:306"} = { bbox => [[440000, 516000], [470000, 538000]], polygon => [[440000,516000],[470000,516000],[470000,532000],[460000,532000],[460000,538000],[440000,538000],[440000,516000]] };
$maps{"B:307"} = { bbox => [[390000, 537600], [420000, 560000]], polygon => [[390000,538000],[390800,538000],[391300,537700],[392000,537700],[393000,537600],[393500,537690],[394000,538000],[420000,538000],[420000,560000],[396000,560000],[396000,551000],[395000,550000],[390000,550000],[390000,538000]] };
$maps{"B:308"} = { bbox => [[418000, 538000], [448000, 560000]], polygon => [[418000,538000],[448000,538000],[448000,544000],[445000,544000],[445000,551000],[443000,551000],[443000,560000],[418000,560000],[418000,538000]] };
$maps{"B:309N"} = { bbox => [[195500, 552000], [215500, 575000]], polygon => [[195500,552000],[215500,552000],[215500,575000],[195500,575000],[195500,552000]] };
$maps{"B:309S"} = { bbox => [[200000, 530000], [220000, 553000]], polygon => [[200000,542000],[206000,542000],[206000,530000],[220000,530000],[220000,553000],[200000,553000],[200000,542000]] };
$maps{"B:309 Inset"} = { bbox => [[225000, 533000], [227000, 535000]], polygon => [[225000,533000],[227000,533000],[227000,535000],[225000,535000],[225000,533000]] };
$maps{"B:310"} = { bbox => [[215500, 548000], [235500, 578000]], polygon => [[215500,548000],[235500,548000],[235500,578000],[215500,578000],[215500,548000]] };
$maps{"B:311"} = { bbox => [[228000, 533000], [250000, 565000]], polygon => [[228000,544500],[233000,544500],[233000,533000],[250000,533000],[250000,565000],[228000,565000],[228000,544500]] };
$maps{"B:312"} = { bbox => [[250000, 542850], [280420, 563400]], polygon => [[250000,543000],[265650,543000],[265800,542850],[266100,543000],[280000,543000],[280000,547000],[280420,547800],[280420,548200],[280000,549000],[280000,563000],[277700,563000],[277000,563350],[276500,563400],[276000,563350],[275500,563300],[275000,563000],[250000,563000],[250000,543000]] };
$maps{"B:313"} = { bbox => [[280000, 547150], [300000, 578000]], polygon => [[280000,548000],[280000,547150],[280700,548000],[300000,548000],[300000,578000],[280000,578000],[280000,548000]] };
$maps{"B:314"} = { bbox => [[300000, 547000], [330000, 567000]], polygon => [[300000,547000],[330000,547000],[330000,567000],[300000,567000],[300000,547000]] };
$maps{"B:315"} = { bbox => [[329500, 550000], [359500, 570000]], polygon => [[329500,550000],[359500,550000],[359500,570000],[329500,570000],[329500,550000]] };
$maps{"B:316E"} = { bbox => [[419000, 560000], [442000, 580000]], polygon => [[419000,560000],[442000,560000],[442000,580000],[419000,580000],[419000,560000]] };
$maps{"B:316W"} = { bbox => [[400000, 560000], [420000, 580000]], polygon => [[400000,560000],[420000,560000],[420000,580000],[400000,580000],[400000,560000]] };
$maps{"B:317"} = { bbox => [[204000, 575000], [234000, 597000]], polygon => [[204000,575000],[234000,575000],[234000,597000],[209000,597000],[209000,586800],[207900,585000],[204000,585000],[204000,575000]] };
$maps{"B:317 Inset"} = { bbox => [[201000, 598500], [203500, 601000]], polygon => [[201000,598500],[203500,598500],[203500,601000],[201000,601000],[201000,598500]] };
$maps{"B:318"} = { bbox => [[232500, 578000], [262500, 600000]], polygon => [[232500,578000],[262500,578000],[262500,590000],[256500,590000],[256500,600000],[232500,600000],[232500,578000]] };
$maps{"B:319"} = { bbox => [[234750, 562000], [265670, 582000]], polygon => [[235250,562000],[265250,562000],[265250,569000],[265500,569200],[265400,570000],[265370,570350],[265670,571000],[265670,572000],[265500,572500],[265450,572000],[265260,573400],[265250,582000],[235250,582000],[235250,577500],[234750,576800],[235250,575500],[235250,562000]] };
$maps{"B:320"} = { bbox => [[261000, 561600], [281000, 592000]], polygon => [[261000,562000],[275600,562000],[276000,561800],[276300,561600],[276800,561600],[277200,562000],[281000,562000],[281000,592000],[261000,592000],[261000,562000]] };
$maps{"B:321"} = { bbox => [[278000, 573000], [300000, 600000]], polygon => [[278000,573000],[300000,573000],[300000,600000],[278000,600000],[278000,573000]] };
$maps{"B:322S"} = { bbox => [[300000, 564000], [323000, 584000]], polygon => [[300000,564000],[323000,564000],[323000,584000],[300000,584000],[300000,564000]] };
$maps{"B:322N"} = { bbox => [[300000, 584000], [320000, 604000]], polygon => [[300000,584000],[320000,584000],[320000,604000],[300000,604000],[300000,584000]] };
$maps{"B:323N"} = { bbox => [[318000, 584000], [341000, 604000]], polygon => [[318000,584000],[341000,584000],[341000,604000],[318000,604000],[318000,584000]] };
$maps{"B:323S"} = { bbox => [[321000, 563700], [341000, 584000]], polygon => [[321000,564000],[325900,564000],[326500,563700],[326700,563700],[327000,564000],[341000,564000],[341000,584000],[321000,584000],[321000,564000]] };
$maps{"B:324"} = { bbox => [[338000, 570000], [358000, 600000]], polygon => [[338000,570000],[358000,570000],[358000,600000],[338000,600000],[338000,570000]] };
$maps{"B:325"} = { bbox => [[406000, 580000], [433200, 602000]], polygon => [[406000,580000],[433000,580000],[433000,580500],[433200,580750],[433000,581000],[433000,602000],[406000,602000],[406000,580000]] };
$maps{"B:326N"} = { bbox => [[225000, 614000], [248000, 634000]], polygon => [[225000,614000],[248000,614000],[248000,634000],[230000,634000],[230000,622000],[225000,622000],[225000,614000]] };
$maps{"B:326S"} = { bbox => [[217000, 596000], [240000, 616000]], polygon => [[217000,596000],[240000,596000],[240000,616000],[217000,616000],[217000,596000]] };
$maps{"B:327"} = { bbox => [[240000, 600000], [260000, 630000]], polygon => [[240000,600000],[260000,600000],[260000,630000],[240000,630000],[240000,600000]] };
$maps{"B:328N"} = { bbox => [[259000, 610000], [279000, 630000]], polygon => [[259000,610000],[279000,610000],[279000,630000],[259000,630000],[259000,610000]] };
$maps{"B:328S"} = { bbox => [[256000, 590000], [279000, 610000]], polygon => [[256000,590000],[279000,590000],[279000,610000],[256000,610000],[256000,590000]] };
$maps{"B:329"} = { bbox => [[277600, 597000], [300000, 624000]], polygon => [[278000,597000],[300000,597000],[300000,624000],[278000,624000],[278000,610750],[277750,610500],[277600,610000],[277800,609600],[278000,609000],[278000,597000]] };
$maps{"B:330"} = { bbox => [[300000, 604000], [330000, 624000]], polygon => [[300000,604000],[330000,604000],[330000,624000],[300000,624000],[300000,604000]] };
$maps{"B:331"} = { bbox => [[330000, 600000], [360000, 620000]], polygon => [[330000,600000],[360000,600000],[360000,620000],[330000,620000],[330000,600000]] };
$maps{"B:332"} = { bbox => [[402000, 601050], [432000, 624000]], polygon => [[402000,602000],[404000,602000],[404500,601500],[405000,601200],[405500,601050],[406500,601050],[407000,601240],[407500,601550],[408000,602000],[432000,602000],[432000,607000],[429000,607000],[429000,616000],[427000,616000],[427000,624000],[402000,624000],[402000,602000]] };
$maps{"B:333"} = { bbox => [[226000, 629000], [248000, 659000]], polygon => [[226000,629000],[248000,629000],[248000,659000],[232000,659000],[232000,649000],[226000,649000],[226000,629000]] };
$maps{"B:334"} = { bbox => [[248000, 629000], [270000, 656000]], polygon => [[248000,629000],[270000,629000],[270000,656000],[248000,656000],[248000,629000]] };
$maps{"B:335"} = { bbox => [[269000, 624000], [299000, 646000]], polygon => [[269000,630000],[279000,630000],[279000,624000],[299000,624000],[299000,646000],[269000,646000],[269000,630000]] };
$maps{"B:336"} = { bbox => [[298000, 622000], [320000, 649000]], polygon => [[298000,622000],[320000,622000],[320000,649000],[298000,649000],[298000,622000]] };
$maps{"B:337"} = { bbox => [[320000, 620000], [340000, 650000]], polygon => [[320000,620000],[340000,620000],[340000,650000],[320000,650000],[320000,620000]] };
$maps{"B:338"} = { bbox => [[340000, 620000], [362000, 650000]], polygon => [[340000,620000],[362000,620000],[362000,636000],[359000,636000],[359000,639000],[357000,639000],[357000,650000],[340000,650000],[340000,620000]] };
$maps{"B:339W"} = { bbox => [[357000, 630000], [377000, 650000]], polygon => [[357000,630000],[377000,630000],[377000,650000],[357000,650000],[357000,630000]] };
$maps{"B:339E"} = { bbox => [[377000, 630000], [400000, 650000]], polygon => [[377000,630000],[400000,630000],[400000,650000],[377000,650000],[377000,630000]] };
$maps{"B:340"} = { bbox => [[398500, 624000], [426000, 646000]], polygon => [[399000,624000],[426000,624000],[426000,646000],[399000,646000],[399000,628900],[398500,628500],[398500,627700],[399000,627150],[399000,624000]] };
$maps{"B:340 Inset"} = { bbox => [[400000, 645000], [407000, 650000]], polygon => [[400000,645000],[407000,645000],[407000,650000],[400000,650000],[400000,645000]] };
$maps{"B:341N"} = { bbox => [[218000, 658000], [241000, 678300]], polygon => [[218000,658000],[241000,658000],[241000,678000],[226500,678000],[226000,678300],[225200,678300],[225100,678000],[224500,678000],[224400,678300],[224100,678300],[223900,678000],[218000,678000],[218000,658000]] };
$maps{"B:341S"} = { bbox => [[213000, 640000], [237000, 660000]], polygon => [[214000,640000],[232000,640000],[232000,652000],[237000,652000],[237000,660000],[214000,660000],[214000,652300],[213000,651500],[213000,651000],[214000,650200],[214000,640000]] };
$maps{"B:342"} = { bbox => [[241000, 655000], [271000, 675000]], polygon => [[241000,655000],[271000,655000],[271000,675000],[241000,675000],[241000,655000]] };
$maps{"B:343"} = { bbox => [[270000, 646000], [300000, 666000]], polygon => [[270000,646000],[300000,646000],[300000,666000],[270000,666000],[270000,646000]] };
$maps{"B:344"} = { bbox => [[300000, 648000], [330000, 668000]], polygon => [[300000,648000],[330000,648000],[330000,668000],[300000,668000],[300000,648000]] };
$maps{"B:345W"} = { bbox => [[329000, 650000], [349000, 670000]], polygon => [[329000,650000],[349000,650000],[349000,670000],[329000,670000],[329000,650000]] };
$maps{"B:345E"} = { bbox => [[349000, 650000], [372000, 670000]], polygon => [[349000,650000],[372000,650000],[372000,670000],[349000,670000],[349000,650000]] };
$maps{"B:346"} = { bbox => [[372000, 650000], [402000, 672200]], polygon => [[372000,650000],[402000,650000],[402000,659000],[399000,659000],[399000,665500],[394500,665500],[394500,672000],[378900,672000],[378600,672200],[378300,672000],[372000,672000],[372000,650000]] };
$maps{"B:347"} = { bbox => [[220500, 673000], [251200, 695000]], polygon => [[221000,679000],[231000,679000],[231000,673000],[251000,673000],[251000,680600],[251200,680700],[251200,681300],[251000,681700],[251000,695000],[221000,695000],[221000,689500],[220500,688800],[220500,687600],[221000,687000],[221000,679000]] };
$maps{"B:348"} = { bbox => [[250000, 674300], [280000, 695000]], polygon => [[250000,675000],[254000,675000],[254800,674300],[255500,674300],[256900,675000],[280000,675000],[280000,695000],[250000,695000],[250000,675000]] };
$maps{"B:349W"} = { bbox => [[270000, 665000], [290000, 688000]], polygon => [[270000,665000],[290000,665000],[290000,688000],[270000,688000],[270000,665000]] };
$maps{"B:349E"} = { bbox => [[288000, 665000], [308000, 688000]], polygon => [[288000,665000],[308000,665000],[308000,683000],[296000,683000],[296000,688000],[288000,688000],[288000,665000]] };
$maps{"B:350"} = { bbox => [[307000, 666000], [337000, 686000]], polygon => [[307000,666000],[337000,666000],[337000,686000],[307000,686000],[307000,666000]] };
$maps{"B:351E"} = { bbox => [[355000, 668000], [378200, 688000]], polygon => [[355000,668000],[378000,668000],[378000,671900],[378200,672000],[378200,672400],[378000,672700],[378000,683000],[366000,683000],[366000,688000],[355000,688000],[355000,668000]] };
$maps{"B:351W"} = { bbox => [[332000, 668000], [355000, 688000]], polygon => [[332000,668000],[355000,668000],[355000,688000],[332000,688000],[332000,668000]] };
$maps{"B:352"} = { bbox => [[126000, 639700], [148000, 667000]], polygon => [[126000,640000],[130500,640000],[131000,639700],[131400,640000],[148000,640000],[148000,667000],[126000,667000],[126000,640000]] };
$maps{"B:353E"} = { bbox => [[125000, 661000], [145000, 681000]], polygon => [[125000,661000],[145000,661000],[145000,681000],[125000,681000],[125000,661000]] };
$maps{"B:353W"} = { bbox => [[115000, 651000], [135000, 672000]], polygon => [[115000,651000],[135000,651000],[135000,672000],[115000,672000],[115000,651000]] };
$maps{"B:354"} = { bbox => [[130000, 675000], [152000, 702000]], polygon => [[130000,675000],[152000,675000],[152000,702000],[130000,702000],[130000,675000]] };
$maps{"B:355S"} = { bbox => [[142000, 662000], [162000, 682000]], polygon => [[142000,662000],[162000,662000],[162000,682000],[142000,682000],[142000,662000]] };
$maps{"B:355N"} = { bbox => [[150100, 682000], [173900, 702000]], polygon => [[150500,682000],[173500,682000],[173500,698600],[173900,699200],[173900,699700],[173500,700000],[173500,702000],[150500,702000],[150500,684800],[150200,684300],[150100,683300],[150100,682600],[150500,682500],[150500,682000]] };
$maps{"B:355 Inset"} = { bbox => [[167000, 700000], [173000, 707000]], polygon => [[167000,700000],[173000,700000],[173000,707000],[167000,707000],[167000,700000]] };
$maps{"B:356N"} = { bbox => [[163000, 625000], [183000, 645000]], polygon => [[163000,625000],[183000,625000],[183000,645000],[163000,645000],[163000,625000]] };
$maps{"B:356S"} = { bbox => [[158000, 603000], [178000, 626000]], polygon => [[158000,603000],[178000,603000],[178000,626000],[158000,626000],[158000,603000]] };
$maps{"B:357N"} = { bbox => [[170000, 653000], [193000, 673000]], polygon => [[170000,653000],[193000,653000],[193000,673000],[170000,673000],[170000,653000]] };
$maps{"B:357S"} = { bbox => [[162000, 643000], [185000, 660000]], polygon => [[162000,643000],[185000,643000],[185000,660000],[162000,660000],[162000,643000]] };
$maps{"B:358N"} = { bbox => [[172000, 687000], [198000, 707000]], polygon => [[172000,687000],[198000,687000],[198000,707000],[172000,707000],[172000,687000]] };
$maps{"B:358S"} = { bbox => [[166000, 671000], [192000, 691000]], polygon => [[166000,671000],[187000,671000],[187000,683000],[192000,683000],[192000,691000],[166000,691000],[166000,671000]] };
$maps{"B:359"} = { bbox => [[170100, 705000], [192500, 735500]], polygon => [[170500,705500],[173500,705500],[174400,705000],[174600,705000],[175400,705500],[186500,705500],[186500,715500],[192500,715500],[192500,735500],[179500,735500],[179500,729000],[170500,729000],[170500,715200],[170100,715100],[170100,714900],[170500,714700],[170500,705500]] };
$maps{"B:359 Inset"} = { bbox => [[163000, 707500], [171000, 713000]], polygon => [[163000,707500],[171000,707500],[171000,713000],[163000,713000],[163000,707500]] };
$maps{"B:360N"} = { bbox => [[192500, 712000], [218500, 729000]], polygon => [[192500,712000],[218500,712000],[218500,729000],[192500,729000],[192500,712000]] };
$maps{"B:360S"} = { bbox => [[185000, 696000], [211000, 716000]], polygon => [[185000,696000],[211000,696000],[211000,716000],[185000,716000],[185000,696000]] };
$maps{"B:361N"} = { bbox => [[186000, 633000], [206000, 653000]], polygon => [[186000,633000],[206000,633000],[206000,653000],[186000,653000],[186000,633000]] };
$maps{"B:361S"} = { bbox => [[186000, 618000], [209000, 638000]], polygon => [[186000,618000],[209000,618000],[209000,638000],[186000,638000],[186000,618000]] };
$maps{"B:362S"} = { bbox => [[192000, 651500], [212000, 675000]], polygon => [[192000,657000],[204000,657000],[204000,652000],[209000,652000],[209500,651500],[210200,651500],[210600,652000],[212000,652000],[212000,675000],[192000,675000],[192000,657000]] };
$maps{"B:362N"} = { bbox => [[190000, 675000], [210000, 698900]], polygon => [[190000,675000],[210000,675000],[210000,698000],[206500,698000],[205850,698650],[205400,698900],[203500,698900],[202800,698400],[202400,698400],[201500,698000],[190000,698000],[190000,675000]] };
$maps{"B:362 Inset"} = { bbox => [[190000, 669000], [194000, 675000]], polygon => [[190000,669000],[194000,669000],[194000,675000],[190000,675000],[190000,669000]] };
$maps{"B:363S"} = { bbox => [[205000, 667000], [225000, 690000]], polygon => [[205000,667000],[219000,667000],[219000,677000],[225000,677000],[225000,690000],[205000,690000],[205000,667000]] };
$maps{"B:363N"} = { bbox => [[204720, 690000], [225000, 713000]], polygon => [[205000,690000],[225000,690000],[225000,713000],[205000,713000],[205000,699000],[204720,698550],[204720,697100],[205000,696700],[205000,690000]] };
$maps{"B:364S"} = { bbox => [[218500, 693000], [241500, 713000]], polygon => [[218500,703000],[224500,703000],[224500,693000],[241500,693000],[241500,713000],[218500,713000],[218500,703000]] };
$maps{"B:364N"} = { bbox => [[218500, 712000], [241500, 732000]], polygon => [[218500,712000],[241500,712000],[241500,732000],[218500,732000],[218500,712000]] };
$maps{"B:365S"} = { bbox => [[241500, 693000], [265350, 713000]], polygon => [[241500,693000],[264500,693000],[264500,694000],[265000,694000],[265350,694500],[264500,695000],[265000,695500],[264500,695600],[264500,713000],[241500,713000],[241500,693000]] };
$maps{"B:365N"} = { bbox => [[241500, 713000], [264500, 730000]], polygon => [[241500,713000],[264500,713000],[264500,730000],[241500,730000],[241500,713000]] };
$maps{"B:366W"} = { bbox => [[263000, 687000], [283000, 710000]], polygon => [[263000,693000],[273000,693000],[273000,687000],[283000,687000],[283000,710000],[263000,710000],[263000,693000]] };
$maps{"B:366E"} = { bbox => [[280000, 687000], [300000, 710000]], polygon => [[280000,687000],[300000,687000],[300000,710000],[280000,710000],[280000,687000]] };
$maps{"B:367W"} = { bbox => [[293000, 680000], [316000, 700000]], polygon => [[293000,680000],[316000,680000],[316000,700000],[299000,700000],[299000,690000],[293000,690000],[293000,680000]] };
$maps{"B:367E"} = { bbox => [[316000, 682000], [339000, 702000]], polygon => [[316000,682000],[339000,682000],[339000,702000],[316000,702000],[316000,682000]] };
$maps{"B:367 Inset"} = { bbox => [[338000, 700000], [343000, 704000]], polygon => [[338000,700000],[343000,700000],[343000,704000],[338000,704000],[338000,700000]] };
$maps{"B:368W"} = { bbox => [[261500, 708000], [281500, 731000]], polygon => [[261500,708000],[281500,708000],[281500,731000],[261500,731000],[261500,708000]] };
$maps{"B:368E"} = { bbox => [[281000, 708000], [298000, 731000]], polygon => [[281000,708000],[298000,708000],[298000,731000],[281000,731000],[281000,708000]] };
$maps{"B:369"} = { bbox => [[298000, 698000], [315000, 728000]], polygon => [[298000,698000],[315000,698000],[315000,728000],[298000,728000],[298000,698000]] };
$maps{"B:370"} = { bbox => [[315000, 700000], [345000, 722000]], polygon => [[315000,700000],[345000,700000],[345000,716000],[335000,716000],[335000,722000],[315000,722000],[315000,700000]] };
$maps{"B:371S"} = { bbox => [[342000, 699000], [365000, 719000]], polygon => [[342000,699000],[365000,699000],[365000,719000],[342000,719000],[342000,699000]] };
$maps{"B:371N"} = { bbox => [[330000, 713000], [353000, 730000]], polygon => [[330000,713000],[353000,713000],[353000,730000],[330000,730000],[330000,713000]] };
$maps{"B:371 Inset"} = { bbox => [[364500, 698500], [366500, 700500]], polygon => [[364500,698500],[366500,698500],[366500,700500],[364500,700500],[364500,698500]] };
$maps{"B:372E"} = { bbox => [[108000, 747000], [131000, 767000]], polygon => [[108000,747000],[131000,747000],[131000,767000],[108000,767000],[108000,747000]] };
$maps{"B:372W"} = { bbox => [[90000, 735000], [110000, 755000]], polygon => [[90000,735000],[110000,735000],[110000,755000],[90000,755000],[90000,735000]] };
$maps{"B:373"} = { bbox => [[123500, 711000], [154700, 733000]], polygon => [[124000,711000],[144000,711000],[144000,717000],[154000,717000],[154000,728200],[154550,728450],[154700,729300],[154000,729600],[154000,733000],[124000,733000],[124000,726400],[123800,726300],[123800,726200],[124000,726000],[124000,720300],[123700,719500],[123700,719000],[124000,718500],[124000,714400],[123500,714200],[123500,713800],[124000,713500],[124000,711000]] };
$maps{"B:373 Inset"} = { bbox => [[131000, 734000], [134000, 737000]], polygon => [[131000,734000],[134000,734000],[134000,737000],[131000,737000],[131000,734000]] };
$maps{"B:374E"} = { bbox => [[140000, 737000], [160000, 760000]], polygon => [[140000,737000],[160000,737000],[160000,760000],[140000,760000],[140000,737000]] };
$maps{"B:374W"} = { bbox => [[123000, 734000], [143000, 757000]], polygon => [[123000,734000],[143000,734000],[143000,757000],[129000,757000],[129000,747000],[123000,747000],[123000,734000]] };
$maps{"B:375E"} = { bbox => [[156000, 719300], [176000, 743700]], polygon => [[156000,720000],[161000,720000],[162000,719600],[162500,719300],[163300,719300],[164000,720000],[176000,720000],[176000,743000],[163600,743000],[162400,743700],[159800,743700],[159000,743000],[156000,743000],[156000,720000]] };
$maps{"B:375W"} = { bbox => [[140000, 720000], [160000, 743000]], polygon => [[140000,726000],[150000,726000],[150000,720000],[160000,720000],[160000,743000],[140000,743000],[140000,726000]] };
$maps{"B:376"} = { bbox => [[178600, 728000], [201000, 758000]], polygon => [[179000,728000],[201000,728000],[201000,758000],[185000,758000],[185000,748000],[179000,748000],[179000,739500],[178600,739000],[178600,738800],[179000,738300],[179000,728000]] };
$maps{"B:376 Inset"} = { bbox => [[177000, 734000], [179500, 737500]], polygon => [[177000,734000],[179500,734000],[179500,737500],[177000,737500],[177000,734000]] };
$maps{"B:377W"} = { bbox => [[199000, 725000], [219000, 745000]], polygon => [[199000,725000],[219000,725000],[219000,745000],[199000,745000],[199000,725000]] };
$maps{"B:377E"} = { bbox => [[219000, 725000], [239000, 748000]], polygon => [[219000,725000],[239000,725000],[239000,748000],[219000,748000],[219000,725000]] };
$maps{"B:378W"} = { bbox => [[237000, 730000], [257500, 750000]], polygon => [[237000,730000],[257000,730000],[257000,732200],[257500,732600],[257500,733800],[257100,734400],[257000,734400],[257000,750000],[237000,750000],[237000,730000]] };
$maps{"B:378E"} = { bbox => [[256880, 730000], [277520, 753000]], polygon => [[257000,730000],[277000,730000],[277000,744400],[277500,745000],[277520,745200],[277500,745500],[277300,745770],[277000,746000],[277000,753000],[257000,753000],[257000,734400],[256880,734200],[257000,733900],[257000,730000]] };
$maps{"B:379W"} = { bbox => [[276000, 727000], [296000, 750000]], polygon => [[276000,727000],[296000,727000],[296000,750000],[276000,750000],[276000,727000]] };
$maps{"B:379E"} = { bbox => [[296000, 727000], [313000, 750000]], polygon => [[296000,727000],[313000,727000],[313000,750000],[296000,750000],[296000,727000]] };
$maps{"B:380W"} = { bbox => [[313000, 719000], [333000, 739000]], polygon => [[313000,719000],[333000,719000],[333000,739000],[313000,739000],[313000,719000]] };
$maps{"B:380E"} = { bbox => [[327000, 727000], [350000, 747000]], polygon => [[327000,727000],[350000,727000],[350000,747000],[327000,747000],[327000,727000]] };
$maps{"B:381"} = { bbox => [[313000, 739000], [343000, 761000]], polygon => [[313000,739000],[331000,739000],[331000,744000],[343000,744000],[343000,761000],[313000,761000],[313000,739000]] };
$maps{"B:382S"} = { bbox => [[350000, 730000], [370900, 753000]], polygon => [[350000,730000],[370000,730000],[370000,746500],[370900,748000],[370500,748800],[370000,749100],[370000,753000],[350000,753000],[350000,730000]] };
$maps{"B:382N"} = { bbox => [[362000, 750000], [382700, 773000]], polygon => [[362000,750000],[376000,750000],[376000,760000],[382000,760000],[382000,769100],[382600,769700],[382700,770000],[382700,770200],[382000,771000],[382000,773000],[362000,773000],[362000,750000]] };
$maps{"B:383W"} = { bbox => [[154000, 741800], [177000, 763100]], polygon => [[154000,742500],[169000,742500],[169100,742300],[169300,742300],[169400,742500],[170000,742500],[171000,742000],[172000,741800],[172600,742500],[177000,742500],[177000,762500],[172000,762500],[171000,763000],[170800,763100],[170600,763000],[170100,762500],[154000,762500],[154000,742500]] };
$maps{"B:383E"} = { bbox => [[172000, 739800], [195000, 760500]], polygon => [[172000,740500],[172200,740500],[173000,740000],[173300,739800],[174000,740300],[174500,740500],[185000,740500],[185000,746500],[195000,746500],[195000,760500],[172000,760500],[172000,740500]] };
$maps{"B:384"} = { bbox => [[199000, 745000], [229000, 767330]], polygon => [[199000,745000],[229000,745000],[229000,764000],[209000,764000],[209000,767000],[205300,767000],[205200,767250],[205100,767330],[204800,767330],[204600,767200],[204550,767000],[199000,767000],[199000,745000]] };
$maps{"B:385W"} = { bbox => [[228000, 748000], [245000, 771000]], polygon => [[228000,748000],[245000,748000],[245000,771000],[228000,771000],[228000,748000]] };
$maps{"B:385E"} = { bbox => [[243000, 750000], [263000, 773000]], polygon => [[243000,750000],[263000,750000],[263000,773000],[243000,773000],[243000,750000]] };
$maps{"B:386E"} = { bbox => [[280000, 748000], [300000, 768000]], polygon => [[280000,748000],[300000,748000],[300000,768000],[280000,768000],[280000,748000]] };
$maps{"B:386W"} = { bbox => [[260000, 748000], [280000, 771000]], polygon => [[260000,748000],[280000,748000],[280000,771000],[260000,771000],[260000,748000]] };
$maps{"B:387N"} = { bbox => [[300000, 769000], [320000, 792000]], polygon => [[300000,769000],[320000,769000],[320000,792000],[300000,792000],[300000,769000]] };
$maps{"B:387S"} = { bbox => [[300000, 750000], [320000, 770000]], polygon => [[300000,750000],[320000,750000],[320000,770000],[300000,770000],[300000,750000]] };
$maps{"B:388N"} = { bbox => [[317000, 777000], [340000, 797000]], polygon => [[317000,777000],[340000,777000],[340000,797000],[317000,797000],[317000,777000]] };
$maps{"B:388S"} = { bbox => [[317000, 761000], [340000, 778000]], polygon => [[317000,761000],[340000,761000],[340000,778000],[317000,778000],[317000,761000]] };
$maps{"B:389"} = { bbox => [[340000, 747000], [362000, 777000]], polygon => [[340000,747000],[352000,747000],[352000,753000],[362000,753000],[362000,777000],[340000,777000],[340000,747000]] };
$maps{"B:390W"} = { bbox => [[141000, 760000], [161000, 783000]], polygon => [[141000,760000],[161000,760000],[161000,777000],[151000,777000],[151000,783000],[141000,783000],[141000,760000]] };
$maps{"B:390E"} = { bbox => [[160000, 759700], [180000, 783000]], polygon => [[160000,760000],[160600,760000],[160800,759700],[161200,759700],[161500,760000],[180000,760000],[180000,783000],[160000,783000],[160000,760000]] };
$maps{"B:390 Inset"} = { bbox => [[138500, 778000], [143500, 782000]], polygon => [[138500,778000],[143500,778000],[143500,782000],[138500,782000],[138500,778000]] };
$maps{"B:391"} = { bbox => [[180000, 759000], [210000, 781450]], polygon => [[180000,759000],[204000,759000],[204000,769000],[210000,769000],[210000,781000],[191600,781000],[191200,781400],[190900,781450],[190000,781450],[189300,781000],[180000,781000],[180000,759000]] };
$maps{"B:392"} = { bbox => [[205000, 761000], [235000, 783000]], polygon => [[205000,761000],[229000,761000],[229000,771000],[235000,771000],[235000,783000],[205000,783000],[205000,761000]] };
$maps{"B:393"} = { bbox => [[234000, 767800], [264800, 790000]], polygon => [[234000,768000],[249800,768000],[249800,767900],[249900,767800],[250800,767800],[251000,768000],[264000,768000],[264000,771500],[264800,772200],[264800,773500],[264000,774400],[264000,790000],[244000,790000],[244000,784000],[234000,784000],[234000,768000]] };
$maps{"B:394W"} = { bbox => [[262600, 767000], [280000, 790000]], polygon => [[263000,767000],[280000,767000],[280000,790000],[263000,790000],[263000,780500],[262650,779550],[262600,777000],[263000,775800],[263000,767000]] };
$maps{"B:394E"} = { bbox => [[280000, 767000], [300000, 790000]], polygon => [[280000,767000],[300000,767000],[300000,790000],[280000,790000],[280000,767000]] };
$maps{"B:395"} = { bbox => [[340000, 775000], [362000, 802000]], polygon => [[340000,775000],[362000,775000],[362000,802000],[340000,802000],[340000,775000]] };
$maps{"B:396"} = { bbox => [[362000, 770000], [392000, 792000]], polygon => [[362000,770000],[386000,770000],[386000,774500],[389000,774500],[389000,787000],[392000,787000],[392000,792000],[362000,792000],[362000,770000]] };
$maps{"B:397"} = { bbox => [[128000, 777000], [150000, 807000]], polygon => [[128000,777000],[150000,777000],[150000,793000],[144000,793000],[144000,807000],[128000,807000],[128000,777000]] };
$maps{"B:397 Inset A"} = { bbox => [[119500, 800000], [129500, 807000]], polygon => [[119500,800000],[121000,800000],[121000,803000],[129500,803000],[129500,807000],[119500,807000],[119500,800000]] };
$maps{"B:397 Inset B"} = { bbox => [[114500, 795000], [116500, 797000]], polygon => [[114500,795000],[116500,795000],[116500,797000],[114500,797000],[114500,795000]] };
$maps{"B:398W"} = { bbox => [[160000, 779000], [180000, 802000]], polygon => [[160000,779000],[180000,779000],[180000,802000],[166000,802000],[166000,792000],[160000,792000],[160000,779000]] };
$maps{"B:398E"} = { bbox => [[180000, 779000], [200000, 802000]], polygon => [[180000,779000],[200000,779000],[200000,802000],[180000,802000],[180000,779000]] };
$maps{"B:399"} = { bbox => [[198000, 773500], [220000, 803500]], polygon => [[198000,777500],[205500,777500],[207500,776500],[207500,773500],[215000,773500],[215000,779000],[220000,779000],[220000,803500],[198000,803500],[198000,777500]] };
$maps{"B:400"} = { bbox => [[217000, 781000], [239000, 811000]], polygon => [[217000,781000],[239000,781000],[239000,811000],[228000,811000],[228000,808500],[225000,808500],[225000,804000],[217000,804000],[217000,781000]] };
$maps{"B:401"} = { bbox => [[237000, 780000], [259000, 810000]], polygon => [[237000,780000],[249000,780000],[249000,786000],[259000,786000],[259000,810000],[237000,810000],[237000,780000]] };
$maps{"B:402"} = { bbox => [[258000, 788000], [285000, 810000]], polygon => [[258000,788000],[285000,788000],[285000,810000],[258000,810000],[258000,788000]] };
$maps{"B:403N"} = { bbox => [[284000, 806000], [307000, 823000]], polygon => [[284000,806000],[307000,806000],[307000,823000],[284000,823000],[284000,806000]] };
$maps{"B:403S"} = { bbox => [[284000, 786700], [307000, 807000]], polygon => [[284000,787000],[299300,787000],[300000,786700],[300700,786700],[300850,787000],[307000,787000],[307000,807000],[284000,807000],[284000,787000]] };
$maps{"B:404S"} = { bbox => [[303000, 788000], [326000, 808000]], polygon => [[303000,788000],[326000,788000],[326000,808000],[303000,808000],[303000,788000]] };
$maps{"B:404N"} = { bbox => [[303000, 805000], [326000, 822000]], polygon => [[303000,805000],[326000,805000],[326000,822000],[303000,822000],[303000,805000]] };
$maps{"B:405E"} = { bbox => [[346000, 796000], [366000, 819000]], polygon => [[346000,796000],[366000,796000],[366000,819000],[346000,819000],[346000,796000]] };
$maps{"B:405W"} = { bbox => [[326000, 795200], [346000, 816000]], polygon => [[326000,796000],[335800,796000],[336000,795600],[336500,795200],[337000,795200],[337200,795300],[337700,796000],[346000,796000],[346000,816000],[326000,816000],[326000,796000]] };
$maps{"B:406E"} = { bbox => [[378000, 791000], [398000, 814000]], polygon => [[378000,791000],[398000,791000],[398000,814000],[378000,814000],[378000,791000]] };
$maps{"B:406W"} = { bbox => [[361000, 791000], [378000, 814000]], polygon => [[361000,791000],[378000,791000],[378000,814000],[361000,814000],[361000,791000]] };
$maps{"B:407"} = { bbox => [[112000, 836000], [134000, 867300]], polygon => [[112000,836500],[124000,836500],[124000,836000],[125300,836000],[125600,836500],[134000,836500],[134000,866500],[124700,866500],[124500,866900],[124000,866900],[123900,867300],[122900,866500],[120000,866500],[120000,858000],[112000,858000],[112000,836500]] };
$maps{"B:408"} = { bbox => [[131000, 850000], [153000, 880000]], polygon => [[131000,850000],[153000,850000],[153000,870000],[149000,870000],[149000,873000],[147000,873000],[147000,875000],[145000,875000],[145000,880000],[131000,880000],[131000,850000]] };
$maps{"B:408 Inset"} = { bbox => [[135000, 879000], [140000, 882000]], polygon => [[135000,879000],[140000,879000],[140000,882000],[135000,882000],[135000,879000]] };
$maps{"B:409"} = { bbox => [[147000, 832000], [169000, 862300]], polygon => [[147000,832000],[169000,832000],[169000,850000],[164000,850000],[164000,862000],[163500,862000],[163300,862300],[162700,862300],[162400,862000],[147000,862000],[147000,832000]] };
$maps{"B:409 Inset A"} = { bbox => [[157500, 827000], [166500, 833700]], polygon => [[159000,827000],[166500,827000],[166500,833700],[157500,833700],[157500,829000],[159000,827000]] };
$maps{"B:409 Inset B"} = { bbox => [[161000, 860000], [164000, 863500]], polygon => [[161000,860000],[164000,860000],[164000,863500],[161000,863500],[161000,860000]] };
$maps{"B:410"} = { bbox => [[127000, 830000], [157000, 850000]], polygon => [[127000,830000],[157000,830000],[157000,850000],[127000,850000],[127000,830000]] };
$maps{"B:411"} = { bbox => [[130900, 810900], [162300, 833400]], polygon => [[131500,822000],[135000,822000],[135000,817000],[138000,817000],[138000,815000],[142000,815000],[142000,811000],[152100,811000],[152300,810900],[152400,810900],[152500,811000],[161500,811000],[161500,820000],[162300,821200],[162300,823800],[161500,825000],[161500,833000],[160800,833000],[160700,833200],[160000,833300],[159300,833400],[158800,833000],[131500,833000],[131500,831000],[130900,830000],[131300,829000],[131500,828000],[131500,822000]] };
$maps{"B:412"} = { bbox => [[155000, 799000], [177000, 829300]], polygon => [[155000,799000],[167000,799000],[167000,805000],[173000,805000],[173000,815000],[177000,815000],[177000,829000],[158200,829000],[158000,829300],[157200,829300],[157000,829000],[155000,829000],[155000,799000]] };
$maps{"B:412 Inset"} = { bbox => [[177000, 817000], [180500, 826000]], polygon => [[177000,817000],[180000,817000],[180000,823500],[180500,824000],[180500,824400],[180000,825000],[180000,826000],[177000,826000],[177000,817000]] };
$maps{"B:413N"} = { bbox => [[174000, 814000], [197000, 831000]], polygon => [[174000,814000],[197000,814000],[197000,831000],[174000,831000],[174000,814000]] };
$maps{"B:413S"} = { bbox => [[169700, 797000], [193000, 817000]], polygon => [[170000,797000],[193000,797000],[193000,817000],[170000,817000],[170000,804500],[169700,803600],[169700,802500],[170000,801500],[170000,797000]] };
$maps{"B:414S"} = { bbox => [[193000, 800000], [216000, 817000]], polygon => [[193000,800000],[216000,800000],[216000,817000],[193000,817000],[193000,800000]] };
$maps{"B:414N"} = { bbox => [[193000, 813000], [216000, 833000]], polygon => [[193000,813000],[216000,813000],[216000,833000],[193000,833000],[193000,813000]] };
$maps{"B:415"} = { bbox => [[215000, 803500], [237000, 833950]], polygon => [[215000,803500],[225000,803500],[225000,808500],[237000,808500],[237000,833500],[231200,833500],[230800,833900],[230500,833950],[229000,833950],[228100,833500],[227600,833500],[227000,833800],[226600,833800],[226100,833500],[215000,833500],[215000,803500]] };
$maps{"B:416N"} = { bbox => [[254000, 830000], [277000, 850000]], polygon => [[254000,830000],[274000,830000],[274000,842000],[277000,842000],[277000,850000],[264000,850000],[264000,847000],[254000,847000],[254000,830000]] };
$maps{"B:416S"} = { bbox => [[237000, 808000], [257000, 831000]], polygon => [[237000,808000],[257000,808000],[257000,831000],[237000,831000],[237000,808000]] };
$maps{"B:417"} = { bbox => [[257000, 810000], [284000, 832000]], polygon => [[257000,810000],[284000,810000],[284000,832000],[257000,832000],[257000,810000]] };
$maps{"B:418"} = { bbox => [[274000, 822000], [304000, 842000]], polygon => [[274000,822000],[304000,822000],[304000,842000],[274000,842000],[274000,822000]] };
$maps{"B:419S"} = { bbox => [[299000, 819000], [322000, 839000]], polygon => [[299000,819000],[322000,819000],[322000,839000],[299000,839000],[299000,819000]] };
$maps{"B:419N"} = { bbox => [[300000, 835000], [323000, 852000]], polygon => [[300000,835000],[323000,835000],[323000,852000],[300000,852000],[300000,835000]] };
$maps{"B:420E"} = { bbox => [[345000, 816000], [368550, 833000]], polygon => [[345000,816000],[368000,816000],[368000,821600],[368400,822000],[368550,822200],[368550,822700],[368400,823000],[368000,823400],[368000,833000],[345000,833000],[345000,816000]] };
$maps{"B:420W"} = { bbox => [[321500, 813000], [345000, 833000]], polygon => [[322000,813000],[345000,813000],[345000,833000],[322000,833000],[322000,826200],[321500,825500],[322000,824900],[322000,813000]] };
$maps{"B:421E"} = { bbox => [[386000, 811000], [406250, 834000]], polygon => [[386000,811000],[400000,811000],[400000,821000],[406000,821000],[406000,830700],[406250,830800],[406250,831100],[406000,831300],[406000,834000],[386000,834000],[386000,811000]] };
$maps{"B:421W"} = { bbox => [[366000, 811000], [386000, 834000]], polygon => [[366000,811000],[386000,811000],[386000,834000],[366000,834000],[366000,811000]] };
$maps{"B:422"} = { bbox => [[273000, 840000], [300000, 862550]], polygon => [[273000,840000],[300000,840000],[300000,862000],[297600,862000],[297000,862400],[296600,862550],[296000,862300],[295700,862000],[273000,862000],[273000,840000]] };
$maps{"B:423"} = { bbox => [[296000, 851000], [326000, 873000]], polygon => [[296000,851000],[326000,851000],[326000,873000],[306000,873000],[306000,867000],[296000,867000],[296000,851000]] };
$maps{"B:424N"} = { bbox => [[325000, 850000], [345000, 870000]], polygon => [[325000,850000],[345000,850000],[345000,870000],[325000,870000],[325000,850000]] };
$maps{"B:424S"} = { bbox => [[322000, 833000], [345000, 853000]], polygon => [[322000,833000],[345000,833000],[345000,853000],[322000,853000],[322000,833000]] };
$maps{"B:425S"} = { bbox => [[345000, 833000], [368000, 850000]], polygon => [[345000,833000],[368000,833000],[368000,850000],[345000,850000],[345000,833000]] };
$maps{"B:425N"} = { bbox => [[345000, 850000], [368000, 870000]], polygon => [[345000,850000],[368000,850000],[368000,870000],[345000,870000],[345000,850000]] };
$maps{"B:426N"} = { bbox => [[367600, 848000], [391000, 868000]], polygon => [[368000,848000],[391000,848000],[391000,868000],[368000,868000],[368000,865000],[367600,864400],[367600,863600],[368000,863000],[368000,848000]] };
$maps{"B:426S"} = { bbox => [[368000, 831000], [391000, 848000]], polygon => [[368000,831000],[391000,831000],[391000,848000],[368000,848000],[368000,831000]] };
$maps{"B:427S"} = { bbox => [[391000, 831000], [414500, 848000]], polygon => [[391000,831000],[414000,831000],[414000,843000],[414100,843200],[414000,843400],[414000,845200],[414500,845700],[414500,846300],[414000,846900],[414000,848000],[391000,848000],[391000,831000]] };
$maps{"B:427N"} = { bbox => [[391000, 848000], [414000, 868000]], polygon => [[391000,848000],[414000,848000],[414000,868000],[391000,868000],[391000,848000]] };
$maps{"B:428S"} = { bbox => [[168000, 827000], [191000, 847000]], polygon => [[168000,827000],[191000,827000],[191000,847000],[168000,847000],[168000,827000]] };
$maps{"B:428N"} = { bbox => [[167700, 845000], [191000, 865200]], polygon => [[168000,845000],[191000,845000],[191000,859000],[181000,859000],[181000,865000],[173300,865000],[173100,865200],[172900,865000],[168000,865000],[168000,850000],[167700,849200],[168000,848500],[168000,845000]] };
$maps{"B:429"} = { bbox => [[190000, 830000], [213000, 857000]], polygon => [[190000,830000],[212000,830000],[212000,839000],[213000,839500],[213000,840500],[212000,841000],[212000,857000],[190000,857000],[190000,830000]] };
$maps{"B:430"} = { bbox => [[210000, 830000], [232000, 857000]], polygon => [[210000,830000],[232000,830000],[232000,857000],[210000,857000],[210000,830000]] };
$maps{"B:431"} = { bbox => [[232000, 828450], [254000, 856000]], polygon => [[232000,829000],[251000,829000],[252000,828700],[253000,828500],[253300,828450],[254000,829000],[254000,856000],[232000,856000],[232000,829000]] };
$maps{"B:432"} = { bbox => [[252000, 846000], [282000, 868000]], polygon => [[252000,846000],[272000,846000],[272000,852000],[282000,852000],[282000,868000],[252000,868000],[252000,846000]] };
$maps{"B:433"} = { bbox => [[172000, 853950], [203300, 877100]], polygon => [[172500,865000],[175500,865000],[175500,860000],[178000,860000],[178000,856500],[185000,856500],[185000,854500],[187500,854500],[188000,854000],[188750,853950],[189000,853960],[189500,854100],[190000,854500],[202500,854500],[202500,860000],[203100,861000],[203300,862000],[203200,863000],[203000,863550],[202500,864000],[202500,876500],[181000,876500],[180750,877100],[179900,877100],[179500,876500],[172500,876500],[172500,869000],[172000,868500],[172000,867500],[172500,867000],[172500,865000]] };
$maps{"B:434"} = { bbox => [[172000, 870000], [194000, 900000]], polygon => [[172000,870000],[194000,870000],[194000,900000],[182000,900000],[182000,894000],[172000,894000],[172000,870000]] };
$maps{"B:435N"} = { bbox => [[193000, 876000], [213000, 899650]], polygon => [[193000,876000],[213000,876000],[213000,899000],[202100,899000],[201800,899650],[200800,899650],[200000,899200],[199900,899000],[193000,899000],[193000,876000]] };
$maps{"B:435S"} = { bbox => [[200000, 857000], [217000, 880000]], polygon => [[200000,857000],[217000,857000],[217000,880000],[200000,880000],[200000,857000]] };
$maps{"B:436N"} = { bbox => [[212000, 876000], [232000, 896000]], polygon => [[212000,876000],[232000,876000],[232000,896000],[212000,896000],[212000,876000]] };
$maps{"B:436S"} = { bbox => [[215000, 857000], [235000, 880000]], polygon => [[215000,857000],[235000,857000],[235000,880000],[215000,880000],[215000,857000]] };
$maps{"B:437S"} = { bbox => [[232000, 855650], [255550, 876000]], polygon => [[232000,856000],[245200,856000],[245500,855650],[247000,855650],[247400,856000],[255000,856000],[255000,857500],[255300,858200],[255500,859100],[255550,859400],[255500,860000],[255000,860800],[255000,876000],[232000,876000],[232000,856000]] };
$maps{"B:437N"} = { bbox => [[232000, 876000], [255000, 893000]], polygon => [[232000,876000],[255000,876000],[255000,893000],[232000,893000],[232000,876000]] };
$maps{"B:438W"} = { bbox => [[255000, 867550], [275350, 891700]], polygon => [[255000,868000],[262200,868000],[262500,867700],[262900,867550],[263100,867550],[263800,868000],[275000,868000],[275000,884000],[275150,884200],[275150,884400],[275000,884600],[275000,889000],[275350,889250],[275350,889750],[275000,890000],[275000,891000],[261500,891000],[261200,891700],[260899,891700],[260000,891000],[255000,891000],[255000,868000]] };
$maps{"B:438E"} = { bbox => [[274500, 868000], [295500, 891000]], polygon => [[274500,868000],[286000,868000],[286000,874000],[288900,876000],[294500,876000],[294500,885000],[295000,886000],[295300,887000],[295500,888000],[295000,888700],[294500,889000],[294500,891000],[274500,891000],[274500,868000]] };
$maps{"B:439E"} = { bbox => [[209000, 893300], [230000, 917350]], polygon => [[210000,894000],[211200,894000],[213000,893300],[213800,893600],[214500,894000],[230000,894000],[230000,917000],[227300,917000],[227000,917260],[226800,917350],[226400,917350],[226000,917000],[210000,917000],[210000,898400],[209000,897600],[209000,897300],[210000,896500],[210000,894000]] };
$maps{"B:439W"} = { bbox => [[190000, 898500], [210500, 923000]], polygon => [[190000,899000],[208500,899000],[209000,898500],[210000,898500],[210200,898800],[210000,899000],[210000,899200],[210500,899900],[210000,900400],[210000,922000],[209900,922600],[209800,922800],[209500,923000],[209000,922700],[207700,922000],[206300,922000],[206000,922300],[204700,922300],[203900,922000],[195000,922000],[195000,910000],[190000,910000],[190000,899000]] };
$maps{"B:440S"} = { bbox => [[230000, 890600], [250000, 914000]], polygon => [[230000,891000],[246150,891000],[246900,890600],[247900,891000],[250000,891000],[250000,914000],[230000,914000],[230000,891000]] };
$maps{"B:440N"} = { bbox => [[233000, 912000], [250000, 935000]], polygon => [[233000,912000],[250000,912000],[250000,935000],[233000,935000],[233000,912000]] };
$maps{"B:441E"} = { bbox => [[272000, 889200], [295000, 910000]], polygon => [[272000,890000],[278250,890000],[279500,889200],[280500,889200],[281000,889350],[281500,889600],[281800,890000],[285000,890000],[285000,896000],[295000,896000],[295000,910000],[272000,910000],[272000,890000]] };
$maps{"B:441W"} = { bbox => [[249000, 890000], [272000, 910000]], polygon => [[249000,890000],[272000,890000],[272000,910000],[249000,910000],[249000,890000]] };
$maps{"B:442E"} = { bbox => [[220000, 913000], [237000, 936000]], polygon => [[220000,913000],[237000,913000],[237000,936000],[220000,936000],[220000,913000]] };
$maps{"B:442W"} = { bbox => [[200000, 913000], [220000, 936000]], polygon => [[200000,913000],[220000,913000],[220000,936000],[200000,936000],[200000,913000]] };
$maps{"B:443"} = { bbox => [[250000, 908000], [272000, 935000]], polygon => [[250000,908000],[272000,908000],[272000,935000],[250000,935000],[250000,908000]] };
$maps{"B:444E"} = { bbox => [[294000, 909400], [317500, 930000]], polygon => [[294000,910000],[294400,910000],[295000,909600],[296100,909400],[297500,910000],[307000,910000],[307000,916000],[317000,916000],[317000,929100],[317300,929300],[317500,930000],[294000,930000],[294000,910000]] };
$maps{"B:444W"} = { bbox => [[271000, 910000], [294000, 930000]], polygon => [[271000,910000],[294000,910000],[294000,930000],[271000,930000],[271000,910000]] };
$maps{"B:445"} = { bbox => [[211800, 930500], [239000, 952500]], polygon => [[212000,930500],[239000,930500],[239000,952500],[212000,952500],[212000,938200],[211800,938000],[211800,937500],[212000,937400],[212000,930500]] };
$maps{"B:446"} = { bbox => [[216000, 952050], [246000, 975200]], polygon => [[216000,952500],[217800,952500],[218200,952300],[219000,952300],[219600,952500],[224700,952500],[224900,952100],[225400,952050],[225550,952100],[226200,952500],[246000,952500],[246000,971000],[241000,971000],[241000,974400],[226800,974500],[226000,975200],[225200,975200],[224800,974500],[223000,974500],[223000,968000],[216000,968000],[216000,952500]] };
$maps{"B:447N"} = { bbox => [[242000, 950000], [262000, 970000]], polygon => [[242000,950000],[262000,950000],[262000,970000],[242000,970000],[242000,950000]] };
$maps{"B:447S"} = { bbox => [[239000, 932500], [262000, 952500]], polygon => [[239000,932500],[262000,932500],[262000,952500],[239000,952500],[239000,932500]] };
$maps{"B:448N"} = { bbox => [[258000, 950000], [281000, 970000]], polygon => [[258000,950000],[281000,950000],[281000,970000],[279000,970000],[279000,967000],[258000,967000],[258000,950000]] };
$maps{"B:448S"} = { bbox => [[258000, 930000], [281000, 950000]], polygon => [[258000,930000],[281000,930000],[281000,950000],[258000,950000],[258000,930000]] };
$maps{"B:449N"} = { bbox => [[280000, 950000], [300000, 970000]], polygon => [[280000,950000],[300000,950000],[300000,970000],[280000,970000],[280000,950000]] };
$maps{"B:449S"} = { bbox => [[280000, 930000], [303000, 950000]], polygon => [[280000,930000],[303000,930000],[303000,950000],[280000,950000],[280000,930000]] };
$maps{"B:450E"} = { bbox => [[319000, 932550], [339150, 956000]], polygon => [[319000,933000],[319200,932750],[319500,932750],[319900,932550],[320400,932550],[321600,933000],[330000,933000],[330000,936000],[333000,936000],[333000,940000],[336000,940000],[336000,944000],[339000,944000],[339000,954000],[339150,954200],[339150,954800],[339000,955000],[339000,956000],[319000,956000],[319000,933000]] };
$maps{"B:450W"} = { bbox => [[300000, 929100], [320000, 953000]], polygon => [[300000,930000],[314300,930000],[314500,929800],[315000,929600],[315200,929300],[315600,929100],[317100,929100],[317800,930000],[320000,930000],[320000,953000],[300000,953000],[300000,930000]] };
$maps{"B:451W"} = { bbox => [[300000, 952000], [320000, 972000]], polygon => [[300000,952000],[320000,952000],[320000,972000],[300000,972000],[300000,952000]] };
$maps{"B:451E"} = { bbox => [[318000, 956000], [341000, 977000]], polygon => [[318000,956000],[341000,956000],[341000,976000],[322000,976000],[321000,977000],[320000,977000],[319000,976500],[318300,976000],[318000,976000],[318000,956000]] };
$maps{"B:451 Inset"} = { bbox => [[333500, 975500], [336500, 979000]], polygon => [[333500,975500],[336500,975500],[336500,979000],[333500,979000],[333500,975500]] };
$maps{"B:452N"} = { bbox => [[60300, 793000], [81300, 816000]], polygon => [[61000,793000],[81000,793000],[81000,811800],[81300,812800],[81000,813050],[81000,816000],[61000,816000],[61000,797800],[60500,796600],[60300,796400],[60500,796100],[61000,796000],[61000,793000]] };
$maps{"B:452S"} = { bbox => [[53000, 779000], [73000, 799000]], polygon => [[53000,779000],[73000,779000],[73000,799000],[53000,799000],[53000,779000]] };
$maps{"B:452 Inset"} = { bbox => [[82500, 810500], [84000, 812000]], polygon => [[82500,810500],[84000,810500],[84000,812000],[82500,812000],[82500,810500]] };
$maps{"B:453S"} = { bbox => [[70000, 812500], [90000, 836000]], polygon => [[70000,813000],[82300,813000],[82700,812500],[83700,812500],[83900,813000],[85000,813000],[85000,825000],[90000,825000],[90000,836000],[70000,836000],[70000,813000]] };
$maps{"B:453N"} = { bbox => [[73000, 835500], [93000, 858500]], polygon => [[73000,835500],[93000,835500],[93000,858500],[73000,858500],[73000,835500]] };
$maps{"B:453 Inset"} = { bbox => [[77500, 807000], [81500, 813000]], polygon => [[77500,807000],[81500,807000],[81500,813000],[77500,813000],[77500,807000]] };
$maps{"B:454W"} = { bbox => [[62500, 857400], [82500, 878400]], polygon => [[62500,858000],[77300,858000],[78000,857400],[78700,857500],[79300,857500],[79820,858000],[82500,858000],[82500,878400],[81400,878400],[81000,878000],[62500,878000],[62500,858000]] };
$maps{"B:454E"} = { bbox => [[82000, 858200], [102900, 881500]], polygon => [[82000,858500],[85000,858500],[87000,858350],[89000,858200],[91800,858200],[92000,858500],[102000,858500],[102000,878000],[102500,879000],[102900,880700],[102000,881500],[82000,881500],[82000,858500]] };
$maps{"B:454 Inset A"} = { bbox => [[57000, 860000], [65300, 865000]], polygon => [[57000,860000],[65300,860000],[65300,863250],[64000,864000],[60000,864000],[60000,865000],[57000,865000],[57000,860000]] };
$maps{"B:454 Inset B"} = { bbox => [[88000, 879000], [95000, 884000]], polygon => [[88000,879000],[95000,879000],[95000,884000],[90000,884000],[88000,881000],[88000,879000]] };
$maps{"B:454 Inset C"} = { bbox => [[84000, 880000], [87200, 884500]], polygon => [[84000,880000],[87000,880000],[87000,883100],[87200,883200],[87000,883800],[87000,884500],[85000,884500],[84000,883000],[84000,880000]] };
$maps{"B:454 Inset D"} = { bbox => [[59000, 880000], [62000, 883000]], polygon => [[59000,880000],[62000,880000],[62000,883000],[59000,883000],[59000,880000]] };
$maps{"B:455"} = { bbox => [[95000, 881350], [125000, 903700]], polygon => [[95000,881500],[103750,881500],[104400,881350],[104950,881500],[119000,881500],[119000,891500],[125000,891500],[125000,903500],[104000,903500],[103700,903700],[103300,903700],[103000,903500],[95000,903500],[95000,881500]] };
$maps{"B:455 Inset A"} = { bbox => [[86500, 886000], [91500, 892000]], polygon => [[86500,886000],[91500,886000],[91500,892000],[86500,892000],[86500,886000]] };
$maps{"B:455 Inset B"} = { bbox => [[93000, 893500], [96000, 895000]], polygon => [[93000,893500],[96000,893500],[96000,895000],[93000,895000],[93000,893500]] };
$maps{"B:456"} = { bbox => [[94700, 900000], [125000, 920000]], polygon => [[95000,900000],[125000,900000],[125000,920000],[95000,920000],[95000,916500],[94700,916300],[94900,916000],[95000,914950],[95000,900000]] };
$maps{"B:456 Inset"} = { bbox => [[86500, 910500], [89500, 912500]], polygon => [[86500,910500],[89500,910500],[89500,912500],[86500,912500],[86500,910500]] };
$maps{"B:457"} = { bbox => [[122500, 896000], [144500, 926000]], polygon => [[122500,900000],[137500,900000],[137500,896000],[144500,896000],[144500,926000],[122500,926000],[122500,900000]] };
$maps{"B:458"} = { bbox => [[97000, 919000], [124000, 941000]], polygon => [[97000,919000],[124000,919000],[124000,941000],[97000,941000],[97000,919000]] };
$maps{"B:458 Inset"} = { bbox => [[110800, 940000], [115500, 944200]], polygon => [[110800,940000],[115500,940000],[115500,944200],[110800,944200],[110800,940000]] };
$maps{"B:459W"} = { bbox => [[116000, 924000], [139000, 944000]], polygon => [[116000,924000],[139000,924000],[139000,944000],[116000,944000],[116000,924000]] };
$maps{"B:459E"} = { bbox => [[138000, 924000], [158000, 944000]], polygon => [[138000,924000],[158000,924000],[158000,944000],[138000,944000],[138000,924000]] };
$maps{"B:460W"} = { bbox => [[117000, 940000], [137000, 960000]], polygon => [[117000,940000],[137000,940000],[137000,960000],[117000,960000],[117000,940000]] };
$maps{"B:460E"} = { bbox => [[137000, 944000], [157000, 967000]], polygon => [[137000,944000],[157000,944000],[157000,967000],[137000,967000],[137000,944000]] };
$maps{"B:460 Inset A"} = { bbox => [[5000, 896000], [14000, 903000]], polygon => [[5000,896000],[14000,896000],[14000,903000],[5000,903000],[5000,896000]] };
$maps{"B:460 Inset B"} = { bbox => [[68500, 944500], [74500, 947500]], polygon => [[68500,944500],[74500,944500],[74500,947500],[68500,947500],[68500,944500]] };
$maps{"B:460 Inset C"} = { bbox => [[14000, 904000], [17000, 907000]], polygon => [[14000,904000],[17000,904000],[17000,907000],[14000,907000],[14000,904000]] };
$maps{"B:460 Inset D"} = { bbox => [[179500, 1031000], [182500, 1034000]], polygon => [[179500,1031000],[182500,1031000],[182500,1034000],[179500,1034000],[179500,1031000]] };
$maps{"B:460 Inset E"} = { bbox => [[161000, 1029500], [163000, 1031500]], polygon => [[161000,1029500],[163000,1029500],[163000,1031500],[161000,1031500],[161000,1029500]] };
$maps{"B:461N"} = { bbox => [[342000, 1000000], [362000, 1023300]], polygon => [[342000,1000000],[362000,1000000],[362000,1023000],[346000,1023000],[345700,1023300],[344500,1023300],[344300,1023000],[342000,1023000],[342000,1000000]] };
$maps{"B:461S"} = { bbox => [[334000, 976500], [354000, 1000000]], polygon => [[334000,977000],[346100,977000],[346900,976500],[347400,976500],[348200,977000],[349000,977000],[349000,989000],[354000,989000],[354000,1000000],[334000,1000000],[334000,977000]] };
$maps{"B:462"} = { bbox => [[317000, 987500], [344000, 1009500]], polygon => [[317000,987500],[344000,987500],[344000,1009500],[317000,1009500],[317000,987500]] };
$maps{"B:462 Inset A"} = { bbox => [[255000, 1017500], [257000, 1018500]], polygon => [[255000,1017500],[257000,1017500],[257000,1018500],[255000,1018500],[255000,1017500]] };
$maps{"B:462 Inset B"} = { bbox => [[261000, 1024000], [263000, 1025000]], polygon => [[261000,1024000],[263000,1024000],[263000,1025000],[261000,1025000],[261000,1024000]] };
$maps{"B:463"} = { bbox => [[321500, 1002900], [343500, 1030599]], polygon => [[321500,1003000],[331000,1003000],[331500,1002900],[332000,1003000],[343500,1003000],[343500,1030000],[332100,1030000],[331800,1030599],[329000,1030599],[328800,1030000],[321500,1030000],[321500,1003000]] };
$maps{"B:464"} = { bbox => [[335400, 1025000], [357500, 1056000]], polygon => [[335500,1026000],[340000,1026000],[343000,1025000],[345000,1025000],[346000,1026000],[357500,1026000],[357500,1044000],[352000,1044000],[352000,1056000],[335500,1056000],[335500,1030000],[335400,1029000],[335500,1028500],[335500,1026000]] };
$maps{"B:465N"} = { bbox => [[359500, 1033099], [379500, 1057200]], polygon => [[359500,1033500],[360100,1033500],[360400,1033099],[360900,1033099],[361000,1033500],[379500,1033500],[379500,1056500],[378700,1056500],[378500,1057000],[378000,1057200],[377500,1057000],[377400,1056500],[369500,1056500],[369500,1050500],[359500,1050500],[359500,1033500]] };
$maps{"B:465S"} = { bbox => [[350000, 1018000], [370000, 1041000]], polygon => [[350000,1018000],[370000,1018000],[370000,1041000],[350000,1041000],[350000,1018000]] };
$maps{"B:465 Inset"} = { bbox => [[366000, 1015000], [369000, 1018000]], polygon => [[366000,1015000],[369000,1015000],[369000,1018000],[366000,1018000],[366000,1015000]] };
$maps{"B:466N"} = { bbox => [[433000, 1126000], [456000, 1146000]], polygon => [[433000,1126000],[456000,1126000],[456000,1146000],[433000,1146000],[433000,1126000]] };
$maps{"B:466S"} = { bbox => [[428000, 1107000], [448000, 1127000]], polygon => [[428000,1107000],[448000,1107000],[448000,1127000],[428000,1127000],[428000,1107000]] };
$maps{"B:466 Inset"} = { bbox => [[419000, 1068500], [423000, 1074500]], polygon => [[419000,1068500],[423000,1068500],[423000,1074500],[419000,1074500],[419000,1068500]] };
$maps{"B:467E"} = { bbox => [[433000, 1140000], [453000, 1160000]], polygon => [[433000,1140000],[453000,1140000],[453000,1160000],[433000,1160000],[433000,1140000]] };
$maps{"B:467W"} = { bbox => [[413500, 1140000], [433500, 1163000]], polygon => [[413500,1140000],[433500,1140000],[433500,1163000],[413500,1163000],[413500,1140000]] };
$maps{"B:467 Inset"} = { bbox => [[393000, 1136000], [398500, 1142000]], polygon => [[393000,1136000],[398500,1136000],[398500,1142000],[393000,1142000],[393000,1136000]] };
$maps{"B:468"} = { bbox => [[440000, 1158000], [470700, 1180000]], polygon => [[440000,1158000],[470000,1158000],[470000,1171200],[470700,1172000],[470000,1172300],[470000,1174000],[460000,1174000],[460000,1180000],[440000,1180000],[440000,1158000]] };
$maps{"B:469N"} = { bbox => [[420000, 1177700], [443200, 1198200]], polygon => [[420000,1177700],[443000,1177700],[443000,1180800],[443200,1181000],[443200,1181400],[443000,1181500],[443000,1197700],[438000,1197700],[437600,1198200],[437300,1198200],[437300,1197700],[426000,1197700],[426000,1187700],[420000,1187700],[420000,1177700]] };
$maps{"B:469S"} = { bbox => [[420000, 1160000], [443000, 1180000]], polygon => [[420000,1160000],[443000,1160000],[443000,1180000],[420000,1180000],[420000,1160000]] };
$maps{"B:469 Inset"} = { bbox => [[409000, 1164500], [411000, 1166000]], polygon => [[409000,1164500],[411000,1164500],[411000,1166000],[409000,1166000],[409000,1164500]] };
$maps{"B:470N"} = { bbox => [[447000, 1197000], [468000, 1220500]], polygon => [[447000,1197000],[467000,1197000],[467000,1215000],[468000,1215300],[468000,1215800],[467000,1216200],[467000,1216900],[467500,1217100],[467400,1217700],[467000,1217900],[467000,1220000],[461800,1220000],[461500,1220500],[461100,1220500],[460700,1220000],[453000,1220000],[453000,1210000],[447000,1210000],[447000,1197000]] };
$maps{"B:470S"} = { bbox => [[443000, 1177000], [463000, 1200000]], polygon => [[443000,1177000],[456000,1177000],[456000,1186000],[463000,1186000],[463000,1200000],[443000,1200000],[443000,1177000]] };
$maps{"B:470 Inset"} = { bbox => [[462000, 1187000], [468000, 1195000]], polygon => [[462000,1187000],[468000,1187000],[468000,1195000],[462000,1195000],[462000,1187000]] };
$maps{"B:OL1E"} = { bbox => [[410000, 380000], [432400, 410000]], polygon => [[410000,380000],[432000,380000],[432000,405000],[432400,405000],[432400,406600],[432000,407000],[432000,410000],[410000,410000],[410000,380000]] };
$maps{"B:OL1W"} = { bbox => [[393000, 380000], [415000, 410000]], polygon => [[393000,380000],[415000,380000],[415000,410000],[396000,410000],[396000,390000],[393000,390000],[393000,380000]] };
$maps{"B:OL2E"} = { bbox => [[380000, 450000], [410000, 472650]], polygon => [[380000,457000],[389000,457000],[389000,450000],[410000,450000],[410000,472000],[397550,472000],[397520,472450],[397300,472600],[397000,472650],[396650,472450],[396600,472000],[380000,472000],[380000,457000]] };
$maps{"B:OL2W"} = { bbox => [[358000, 467500], [388000, 490000]], polygon => [[358000,468000],[372750,468000],[373000,467800],[373350,467650],[373800,468000],[375550,468000],[376050,467500],[376500,467500],[376670,467620],[377500,468000],[388000,468000],[388000,490000],[358000,490000],[358000,468000]] };
$maps{"B:OL3"} = { bbox => [[447600, 97000], [470000, 125000]], polygon => [[448000,99000],[456000,99000],[456000,97000],[470000,97000],[470000,125000],[448000,125000],[448000,101700],[447600,101700],[447600,101300],[448000,101100],[448000,99000]] };
$maps{"B:OL4S"} = { bbox => [[301000, 509000], [331000, 531000]], polygon => [[301000,509000],[331000,509000],[331000,531000],[301000,531000],[301000,509000]] };
$maps{"B:OL4N"} = { bbox => [[301000, 530000], [331000, 550000]], polygon => [[301000,530000],[331000,530000],[331000,550000],[301000,550000],[301000,530000]] };
$maps{"B:OL5S"} = { bbox => [[330000, 509000], [360000, 531000]], polygon => [[330000,509000],[360000,509000],[360000,531000],[330000,531000],[330000,509000]] };
$maps{"B:OL5N"} = { bbox => [[330000, 530000], [360000, 550000]], polygon => [[330000,530000],[360000,530000],[360000,550000],[330000,550000],[330000,530000]] };
$maps{"B:OL6N"} = { bbox => [[301000, 489000], [331000, 511000]], polygon => [[301000,489000],[331000,489000],[331000,511000],[301000,511000],[301000,489000]] };
$maps{"B:OL6S"} = { bbox => [[307000, 461000], [329000, 491000]], polygon => [[307500,473000],[313000,473000],[313000,461000],[329000,461000],[329000,491000],[307300,491000],[307100,490000],[307000,489900],[307000,489000],[307500,487850],[307500,473000]] };
$maps{"B:OL7N"} = { bbox => [[330000, 489000], [360000, 511000]], polygon => [[330000,489000],[360000,489000],[360000,511000],[330000,511000],[330000,489000]] };
$maps{"B:OL7S"} = { bbox => [[329000, 470000], [359000, 490000]], polygon => [[329000,470000],[359000,470000],[359000,490000],[329000,490000],[329000,470000]] };
$maps{"B:OL8"} = { bbox => [[468000, 92000], [490000, 122000]], polygon => [[468000,97000],[477000,97000],[483000,93000],[483000,92000],[490000,92000],[490000,122000],[468000,122000],[468000,97000]] };
$maps{"B:OL9W"} = { bbox => [[250000, 129580], [280000, 151350]], polygon => [[250000,130000],[278350,130000],[278700,129800],[279200,129580],[280000,129580],[280000,130000],[280000,151000],[275950,151000],[275400,151350],[274800,151000],[274000,151000],[274000,150000],[272900,150000],[272400,150200],[271400,150250],[270800,150200],[270400,150000],[264000,150000],[264000,149000],[250000,149000],[250000,130000]] };
$maps{"B:OL9E"} = { bbox => [[280000, 127000], [310000, 149750]], polygon => [[280000,127500],[290550,127500],[291300,127000],[296950,127000],[297800,127500],[310000,127500],[310000,149500],[281500,149500],[281000,149650],[280000,149750],[280000,127500]] };
$maps{"B:OL10"} = { bbox => [[490000, 97600], [517000, 120000]], polygon => [[490000,98000],[490000,97600],[494200,97600],[494200,98000],[517000,98000],[517000,120000],[490000,120000],[490000,98000]] };
$maps{"B:OL11"} = { bbox => [[517000, 99000], [547000, 121000]], polygon => [[517000,102000],[537000,102000],[537000,99000],[547000,99000],[547000,121000],[517000,121000],[517000,102000]] };
$maps{"B:OL12E"} = { bbox => [[289000, 204000], [311000, 234000]], polygon => [[289000,204000],[311000,204000],[311000,234000],[289000,234000],[289000,204000]] };
$maps{"B:OL12W"} = { bbox => [[266350, 206000], [289000, 236000]], polygon => [[267000,211000],[280000,211000],[280000,206000],[289000,206000],[289000,236000],[267000,236000],[267000,220000],[266450,219400],[266350,219100],[266450,218550],[267000,218050],[267000,211000]] };
$maps{"B:OL13S"} = { bbox => [[310000, 205000], [340000, 225000]], polygon => [[310000,205000],[340000,205000],[340000,225000],[310000,225000],[310000,205000]] };
$maps{"B:OL13N"} = { bbox => [[310000, 223000], [340000, 245000]], polygon => [[310000,223000],[340000,223000],[340000,245000],[310000,245000],[310000,223000]] };
$maps{"B:OL14W"} = { bbox => [[340000, 189345], [360780, 220000]], polygon => [[340000,190000],[354300,190000],[355150,189350],[355900,189350],[356250,189345],[358050,190000],[360000,190000],[360000,196150],[360780,196640],[360780,200070],[360000,200800],[360000,216750],[360400,217400],[360400,217800],[360000,218050],[360000,220000],[340000,220000],[340000,190000]] };
$maps{"B:OL14E"} = { bbox => [[356000, 199310], [378000, 230000]], polygon => [[356000,200000],[358350,200000],[358880,199310],[362150,199310],[362550,200000],[378000,200000],[378000,230000],[356000,230000],[356000,200000]] };
$maps{"B:OL15E"} = { bbox => [[376000, 73000], [406800, 95850]], polygon => [[376000,73000],[406000,73000],[406000,89000],[406800,89600],[406800,91700],[406000,92000],[406000,95000],[395900,95000],[395600,95300],[395000,95400],[394900,95500],[394800,95850],[394500,95850],[394000,95700],[393750,95600],[393750,95000],[385400,95000],[385300,95400],[383300,95400],[382500,95000],[376000,95000],[376000,73000]] };
$maps{"B:OL15W"} = { bbox => [[345300, 73000], [376000, 95000]], polygon => [[346000,85000],[351000,85000],[351000,73000],[376000,73000],[376000,95000],[346000,95000],[346000,94300],[345500,94000],[345300,93500],[345500,93000],[345900,92050],[346000,92000],[346000,85000]] };
$maps{"B:OL15 Inset"} = { bbox => [[366000, 68000], [371000, 75000]], polygon => [[366000,68000],[371000,68000],[371000,75000],[366000,75000],[366000,68000]] };
$maps{"B:OL16E"} = { bbox => [[380000, 600000], [402530, 630000]], polygon => [[380000,600000],[402000,600000],[402000,614100],[402300,615300],[402530,615900],[402250,616450],[402000,617000],[402000,630000],[380000,630000],[380000,600000]] };
$maps{"B:OL16W"} = { bbox => [[360000, 600000], [380000, 630000]], polygon => [[360000,600000],[380000,600000],[380000,630000],[360000,630000],[360000,600000]] };
$maps{"B:OL17W"} = { bbox => [[247000, 345000], [269000, 375750]], polygon => [[247000,345000],[269000,345000],[269000,375000],[268850,375450],[268650,375650],[268300,375750],[267600,375750],[267350,375250],[266800,375000],[247000,375000],[247000,345000]] };
$maps{"B:OL17E"} = { bbox => [[267500, 355000], [290000, 385000]], polygon => [[268000,355000],[290000,355000],[290000,380000],[285000,380000],[285000,385000],[273000,385000],[273000,378000],[268000,378000],[268000,376000],[267500,376000],[267500,375500],[267700,375100],[268000,375000],[268000,355000]] };
$maps{"B:OL18W"} = { bbox => [[254000, 315300], [276000, 346400]], polygon => [[254000,316000],[260200,316000],[260700,315500],[261000,315450],[261500,315300],[262000,315350],[262500,315450],[263000,315750],[263200,316000],[276000,316000],[276000,346000],[270800,346000],[270500,346300],[270000,346400],[269500,346300],[269000,346000],[254000,346000],[254000,316000]] };
$maps{"B:OL18E"} = { bbox => [[269000, 333000], [299000, 355000]], polygon => [[269000,345500],[274500,345500],[274500,333000],[299000,333000],[299000,355000],[269000,355000],[269000,345500]] };
$maps{"B:OL19S"} = { bbox => [[360000, 490000], [390000, 510000]], polygon => [[360000,490000],[390000,490000],[390000,510000],[360000,510000],[360000,490000]] };
$maps{"B:OL19N"} = { bbox => [[360000, 508000], [390000, 530000]], polygon => [[360000,508000],[390000,508000],[390000,530000],[360000,530000],[360000,508000]] };
$maps{"B:OL20E"} = { bbox => [[270000, 34800], [292000, 65000]], polygon => [[270000,35000],[276900,35000],[277200,34800],[277550,35000],[284000,35000],[284000,45000],[292000,45000],[292000,65000],[270000,65000],[270000,35000]] };
$maps{"B:OL20W"} = { bbox => [[248000, 36000], [270000, 66000]], polygon => [[248000,42000],[258000,42000],[258000,36000],[270000,36000],[270000,66000],[248000,66000],[248000,42000]] };
$maps{"B:OL20 Inset"} = { bbox => [[287500, 48250], [294900, 57500]], polygon => [[287500,48500],[287500,48250],[288000,48250],[288400,48350],[288450,48500],[294500,48500],[294500,55650],[294900,56700],[294500,56850],[294500,57500],[287500,57500],[287500,48500]] };
$maps{"B:OL21S"} = { bbox => [[380000, 410000], [410000, 432000]], polygon => [[380000,415000],[392000,415000],[392000,410000],[410000,410000],[410000,432000],[380000,432000],[380000,415000]] };
$maps{"B:OL21N"} = { bbox => [[378000, 429000], [408000, 451420]], polygon => [[378000,429000],[408000,429000],[408000,451000],[401600,451000],[401600,451420],[396900,451420],[396850,451000],[378000,451000],[378000,429000]] };
$maps{"B:OL22E"} = { bbox => [[428000, 89500], [450000, 120000]], polygon => [[428000,90000],[430500,90000],[431400,89500],[438000,89500],[438000,92000],[448000,98000],[450000,98000],[450000,120000],[428000,120000],[428000,90000]] };
$maps{"B:OL22W"} = { bbox => [[406000, 89700], [428000, 120000]], polygon => [[406000,90000],[406500,90000],[406700,89700],[407200,89700],[407500,90000],[428000,90000],[428000,120000],[406000,120000],[406000,90000]] };
$maps{"B:OL23W"} = { bbox => [[256000, 290000], [278000, 320000]], polygon => [[256000,290000],[278000,290000],[278000,320000],[256000,320000],[256000,290000]] };
$maps{"B:OL23E"} = { bbox => [[276000, 309000], [298000, 336700]], polygon => [[276000,309000],[298000,309000],[298000,336000],[293600,336000],[292800,336700],[291900,336700],[291200,336000],[276000,336000],[276000,309000]] };
$maps{"B:OL24W"} = { bbox => [[393000, 350000], [415000, 380110]], polygon => [[393000,350000],[415000,350000],[415000,380000],[404520,380000],[404370,380110],[403250,380110],[403130,380000],[393000,380000],[393000,350000]] };
$maps{"B:OL24E"} = { bbox => [[415000, 349750], [435250, 380000]], polygon => [[415000,350000],[424450,350000],[424550,349850],[424800,349750],[425050,349750],[425750,349900],[425380,350000],[435000,350000],[435000,352900],[435200,353200],[435250,353700],[435250,354200],[435000,354600],[435000,380000],[415000,380000],[415000,350000]] };
$maps{"B:OL25"} = { bbox => [[542700, 95000], [565000, 122000]], polygon => [[543000,95000],[565000,95000],[565000,122000],[543000,122000],[543000,106000],[542700,106000],[542700,103400],[543000,103400],[543000,95000]] };
$maps{"B:OL26N"} = { bbox => [[441600, 500000], [472000, 522400]], polygon => [[442000,500000],[472000,500000],[472000,522000],[469850,522000],[469500,522250],[469300,522300],[468500,522400],[467600,522400],[467400,522000],[457000,522000],[457000,520000],[450000,520000],[450000,516000],[442000,516000],[442000,514400],[441700,514000],[441600,513500],[441700,513000],[441730,512500],[441800,512000],[442000,511500],[442000,500000]] };
$maps{"B:OL26S"} = { bbox => [[443550, 478000], [474000, 500000]], polygon => [[444000,478000],[474000,478000],[474000,500000],[444000,500000],[444000,496000],[443550,494700],[443550,494300],[444000,493500],[444000,478000]] };
$maps{"B:OL27N"} = { bbox => [[470000, 499000], [500000, 521000]], polygon => [[470000,499000],[500000,499000],[500000,515000],[490000,515000],[490000,521000],[470000,521000],[470000,499000]] };
$maps{"B:OL27S"} = { bbox => [[474000, 479000], [504450, 501000]], polygon => [[474000,479000],[504000,479000],[504000,485500],[504200,486000],[504450,486350],[504450,489600],[504000,489900],[504000,501000],[474000,501000],[474000,479000]] };
$maps{"B:OL28N"} = { bbox => [[250000, 74000], [280950, 96000]], polygon => [[250500,74000],[280500,74000],[280500,78000],[280950,78100],[280950,78900],[280500,79200],[280500,87650],[280750,88000],[280800,88300],[280800,88500],[280500,88850],[280500,96000],[250500,96000],[250500,85100],[250100,84500],[250100,78000],[250000,78000],[250000,76850],[250000,74000],[250500,74000]] };
$maps{"B:OL28S"} = { bbox => [[248000, 55000], [278000, 77000]], polygon => [[248000,61000],[258000,61000],[258000,55000],[278000,55000],[278000,77000],[248000,77000],[248000,61000]] };
$maps{"B:OL29E"} = { bbox => [[445000, 75000], [467000, 105000]], polygon => [[445000,75000],[467000,75000],[467000,105000],[445000,105000],[445000,75000]] };
$maps{"B:OL29W"} = { bbox => [[428800, 75000], [451000, 105000]], polygon => [[429000,81000],[439000,81000],[439000,75000],[451000,75000],[451000,105000],[429000,105000],[429000,85000],[428800,84800],[429000,84600],[429000,81000]] };
$maps{"B:OL30S"} = { bbox => [[384000, 470000], [414000, 492000]], polygon => [[384000,470000],[414000,470000],[414000,492000],[414000,492000],[384000,492000],[384000,470000]] };
$maps{"B:OL30N"} = { bbox => [[384000, 492000], [414000, 514000]], polygon => [[384000,492000],[414000,492000],[414000,514000],[395000,514000],[395000,510000],[389000,510000],[389000,506000],[384000,506000],[384000,492000]] };
$maps{"B:OL31E"} = { bbox => [[390000, 510000], [410000, 540000]], polygon => [[390000,510000],[410000,510000],[410000,540000],[390000,540000],[390000,510000]] };
$maps{"B:OL31W"} = { bbox => [[360000, 528000], [390000, 550000]], polygon => [[360000,528000],[390000,528000],[390000,550000],[360000,550000],[360000,528000]] };
$maps{"B:OL32"} = { bbox => [[440000, 120000], [470000, 140000]], polygon => [[440000,120000],[470000,120000],[470000,140000],[440000,140000],[440000,120000]] };
$maps{"B:OL33"} = { bbox => [[470000, 120000], [500000, 140000]], polygon => [[470000,120000],[500000,120000],[500000,140000],[470000,140000],[470000,120000]] };
$maps{"B:OL34"} = { bbox => [[500000, 120000], [530000, 140000]], polygon => [[500000,120000],[530000,120000],[530000,140000],[500000,140000],[500000,120000]] };
$maps{"B:OL35W"} = { bbox => [[169000, 220000], [199000, 242000]], polygon => [[169000,220000],[199000,220000],[199000,242000],[169000,242000],[169000,220000]] };
$maps{"B:OL35E"} = { bbox => [[198000, 222000], [220000, 252330]], polygon => [[198000,222000],[220000,222000],[220000,252330],[219220,252330],[219000,252000],[208000,252000],[208000,246000],[198000,246000],[198000,222000]] };
$maps{"B:OL35 Inset"} = { bbox => [[165000, 221000], [171000, 229000]], polygon => [[165000,221000],[171000,221000],[171000,229000],[165000,229000],[165000,221000]] };
$maps{"B:OL36W"} = { bbox => [[175200, 192600], [198000, 223750]], polygon => [[176000,193000],[195300,193000],[196000,192600],[197600,192600],[198000,193000],[198000,223000],[185550,223000],[185100,223450],[184500,223500],[183600,223750],[181600,223750],[181000,223400],[180500,223000],[176000,223000],[176000,209800],[175200,209500],[175200,208500],[176000,207850],[176000,193000]] };
$maps{"B:OL36E"} = { bbox => [[198000, 193000], [220000, 223000]], polygon => [[198000,193000],[215000,193000],[215000,196250],[215250,196650],[215000,197050],[215000,203050],[215200,203200],[215000,203350],[215000,205000],[220000,205000],[220000,223000],[198000,223000],[198000,193000]] };
$maps{"B:OL36 Inset A"} = { bbox => [[171000, 204000], [176000, 211000]], polygon => [[171000,204000],[176000,204000],[176000,211000],[171000,211000],[171000,204000]] };
$maps{"B:OL36 Inset B"} = { bbox => [[146000, 208000], [148000, 209000]], polygon => [[146000,208000],[148000,208000],[148000,209000],[146000,209000],[146000,208000]] };
$maps{"B:OL36 Inset C"} = { bbox => [[159000, 209000], [161000, 210000]], polygon => [[159000,209000],[161000,209000],[161000,210000],[159000,210000],[159000,209000]] };
$maps{"B:OL37S"} = { bbox => [[205000, 667000], [225000, 690000]], polygon => [[205000,667000],[219000,667000],[219000,677000],[225000,677000],[225000,690000],[205000,690000],[205000,667000]] };
$maps{"B:OL37N"} = { bbox => [[204720, 690000], [225000, 713000]], polygon => [[205000,690000],[225000,690000],[225000,713000],[205000,713000],[205000,699000],[204720,698550],[204720,697100],[205000,696700],[205000,690000]] };
$maps{"B:OL38"} = { bbox => [[220500, 673000], [251200, 695000]], polygon => [[221000,679000],[231000,679000],[231000,673000],[251000,673000],[251000,680600],[251200,680700],[251200,681300],[251000,681700],[251000,695000],[221000,695000],[221000,689500],[220500,688800],[220500,687600],[221000,687000],[221000,679000]] };
$maps{"B:OL39S"} = { bbox => [[218500, 693000], [241500, 713000]], polygon => [[218500,703000],[224500,703000],[224500,693000],[241500,693000],[241500,713000],[218500,713000],[218500,703000]] };
$maps{"B:OL39N"} = { bbox => [[218500, 712000], [241500, 732000]], polygon => [[218500,712000],[241500,712000],[241500,732000],[218500,732000],[218500,712000]] };
$maps{"B:OL40N"} = { bbox => [[622400, 307570], [653650, 330000]], polygon => [[622850,308000],[623350,308000],[623550,307800],[624150,307570],[624650,307570],[625100,307700],[625450,308000],[653000,308000],[653000,308150],[653300,308750],[653650,309600],[653500,310700],[653000,311950],[653000,320000],[651000,320000],[642500,328500],[642500,330000],[623000,330000],[623000,310000],[622520,309300],[622400,308700],[622450,308350],[622850,308000]] };
$maps{"B:OL40S"} = { bbox => [[624580, 288000], [655700, 310000]], polygon => [[625000,288000],[655000,288000],[655000,292400],[655350,292600],[655700,293700],[655350,294900],[655000,296200],[655000,310000],[625000,310000],[625000,308390],[624800,308000],[624580,307450],[624580,306600],[625000,306000],[625000,288000]] };
$maps{"B:OL41W"} = { bbox => [[346550, 440000], [369000, 470000]], polygon => [[347000,440000],[369000,440000],[369000,470000],[347000,470000],[347000,466900],[346550,466450],[346550,464500],[347000,464000],[347000,460800],[346750,460450],[346750,460400],[347000,460200],[347000,440000]] };
$maps{"B:OL41E"} = { bbox => [[369000, 438000], [389450, 468000]], polygon => [[369000,438000],[389000,438000],[389000,439250],[389450,440450],[389450,441550],[389000,442050],[389000,468000],[369000,468000],[369000,438000]] };
$maps{"B:OL42W"} = { bbox => [[350000, 580000], [380000, 600420]], polygon => [[350000,580000],[380000,580000],[380000,600000],[379000,600000],[378550,600420],[378300,600420],[378100,600330],[376600,600330],[376400,600250],[376000,600000],[350000,600000],[350000,580000]] };
$maps{"B:OL42E"} = { bbox => [[380000, 580000], [410000, 602350]], polygon => [[380000,580000],[410000,580000],[410000,602000],[406850,602000],[406450,602350],[405400,602220],[405150,602000],[380000,602000],[380000,580000]] };
$maps{"B:OL43W"} = { bbox => [[358000, 550000], [380000, 580000]], polygon => [[358000,550000],[380000,550000],[380000,580000],[358000,580000],[358000,550000]] };
$maps{"B:OL43E"} = { bbox => [[380000, 550000], [400000, 580000]], polygon => [[380000,550000],[400000,550000],[400000,580000],[380000,580000],[380000,550000]] };
$maps{"B:OL44"} = { bbox => [[278000, 60000], [300000, 90000]], polygon => [[278000,60000],[296500,60000],[296500,76000],[300000,76000],[300000,90000],[278000,90000],[278000,60000]] };
$maps{"B:OL45S"} = { bbox => [[400000, 200000], [430370, 220000]], polygon => [[400000,200000],[430000,200000],[430000,218300],[430370,218720],[430000,219200],[430000,220000],[400000,220000],[400000,200000]] };
$maps{"B:OL45N"} = { bbox => [[400000, 219700], [430000, 242000]], polygon => [[400000,220000],[417000,220000],[417190,219820],[417700,219700],[418500,219850],[418500,220000],[430000,220000],[430000,242000],[400000,242000],[400000,220000]] };
$maps{"B:OL46S"} = { bbox => [[241500, 693000], [265350, 713000]], polygon => [[241500,693000],[264500,693000],[264500,694000],[265000,694000],[265350,694500],[264500,695000],[265000,695500],[264500,695600],[264500,713000],[241500,713000],[241500,693000]] };
$maps{"B:OL46N"} = { bbox => [[241500, 713000], [264500, 730000]], polygon => [[241500,713000],[264500,713000],[264500,730000],[241500,730000],[241500,713000]] };
$maps{"B:OL47W"} = { bbox => [[261500, 708000], [281500, 731000]], polygon => [[261500,708000],[281500,708000],[281500,731000],[261500,731000],[261500,708000]] };
$maps{"B:OL47E"} = { bbox => [[281000, 708000], [298000, 731000]], polygon => [[281000,708000],[298000,708000],[298000,731000],[281000,731000],[281000,708000]] };
$maps{"B:OL48W"} = { bbox => [[237000, 730000], [257500, 750000]], polygon => [[237000,730000],[257000,730000],[257000,732200],[257500,732600],[257500,733800],[257100,734400],[257000,734400],[257000,750000],[237000,750000],[237000,730000]] };
$maps{"B:OL48E"} = { bbox => [[256880, 730000], [277520, 753000]], polygon => [[257000,730000],[277000,730000],[277000,744400],[277500,745000],[277520,745200],[277500,745500],[277300,745770],[277000,746000],[277000,753000],[257000,753000],[257000,734400],[256880,734200],[257000,733900],[257000,730000]] };
$maps{"B:OL49E"} = { bbox => [[280000, 748000], [300000, 768000]], polygon => [[280000,748000],[300000,748000],[300000,768000],[280000,768000],[280000,748000]] };
$maps{"B:OL49W"} = { bbox => [[260000, 748000], [280000, 771000]], polygon => [[260000,748000],[280000,748000],[280000,771000],[260000,771000],[260000,748000]] };
$maps{"B:OL50"} = { bbox => [[234000, 767800], [264800, 790000]], polygon => [[234000,768000],[249800,768000],[249800,767900],[249900,767800],[250800,767800],[251000,768000],[264000,768000],[264000,771500],[264800,772200],[264800,773500],[264000,774400],[264000,790000],[244000,790000],[244000,784000],[234000,784000],[234000,768000]] };
$maps{"B:OL51W"} = { bbox => [[262600, 767000], [280000, 790000]], polygon => [[263000,767000],[280000,767000],[280000,790000],[263000,790000],[263000,780500],[262650,779550],[262600,777000],[263000,775800],[263000,767000]] };
$maps{"B:OL51E"} = { bbox => [[280000, 767000], [300000, 790000]], polygon => [[280000,767000],[300000,767000],[300000,790000],[280000,790000],[280000,767000]] };
$maps{"B:OL52N"} = { bbox => [[300000, 769000], [320000, 792000]], polygon => [[300000,769000],[320000,769000],[320000,792000],[300000,792000],[300000,769000]] };
$maps{"B:OL52S"} = { bbox => [[300000, 750000], [320000, 770000]], polygon => [[300000,750000],[320000,750000],[320000,770000],[300000,770000],[300000,750000]] };
$maps{"B:OL53N"} = { bbox => [[317000, 777000], [340000, 797000]], polygon => [[317000,777000],[340000,777000],[340000,797000],[317000,797000],[317000,777000]] };
$maps{"B:OL53S"} = { bbox => [[317000, 761000], [340000, 778000]], polygon => [[317000,761000],[340000,761000],[340000,778000],[317000,778000],[317000,761000]] };
$maps{"B:OL54"} = { bbox => [[340000, 775000], [362000, 802000]], polygon => [[340000,775000],[362000,775000],[362000,802000],[340000,802000],[340000,775000]] };
$maps{"B:OL55"} = { bbox => [[237000, 780000], [259000, 810000]], polygon => [[237000,780000],[249000,780000],[249000,786000],[259000,786000],[259000,810000],[237000,810000],[237000,780000]] };
$maps{"B:OL56"} = { bbox => [[258000, 788000], [285000, 810000]], polygon => [[258000,788000],[285000,788000],[285000,810000],[258000,810000],[258000,788000]] };
$maps{"B:OL57N"} = { bbox => [[284000, 806000], [307000, 823000]], polygon => [[284000,806000],[307000,806000],[307000,823000],[284000,823000],[284000,806000]] };
$maps{"B:OL57S"} = { bbox => [[284000, 786700], [307000, 807000]], polygon => [[284000,787000],[299300,787000],[300000,786700],[300700,786700],[300850,787000],[307000,787000],[307000,807000],[284000,807000],[284000,787000]] };
$maps{"B:OL58S"} = { bbox => [[303000, 788000], [326000, 808000]], polygon => [[303000,788000],[326000,788000],[326000,808000],[303000,808000],[303000,788000]] };
$maps{"B:OL58N"} = { bbox => [[303000, 805000], [326000, 822000]], polygon => [[303000,805000],[326000,805000],[326000,822000],[303000,822000],[303000,805000]] };
$maps{"B:OL59E"} = { bbox => [[346000, 796000], [366000, 819000]], polygon => [[346000,796000],[366000,796000],[366000,819000],[346000,819000],[346000,796000]] };
$maps{"B:OL59W"} = { bbox => [[326000, 795200], [346000, 816000]], polygon => [[326000,796000],[335800,796000],[336000,795600],[336500,795200],[337000,795200],[337200,795300],[337700,796000],[346000,796000],[346000,816000],[326000,816000],[326000,796000]] };
$maps{"B:OL60"} = { bbox => [[274000, 822000], [304000, 842000]], polygon => [[274000,822000],[304000,822000],[304000,842000],[274000,842000],[274000,822000]] };
$maps{"B:OL61S"} = { bbox => [[299000, 819000], [322000, 839000]], polygon => [[299000,819000],[322000,819000],[322000,839000],[299000,839000],[299000,819000]] };
$maps{"B:OL61N"} = { bbox => [[300000, 835000], [323000, 852000]], polygon => [[300000,835000],[323000,835000],[323000,852000],[300000,852000],[300000,835000]] };
$maps{"B:OL62E"} = { bbox => [[345000, 816000], [368550, 833000]], polygon => [[345000,816000],[368000,816000],[368000,821600],[368400,822000],[368550,822200],[368550,822700],[368400,823000],[368000,823400],[368000,833000],[345000,833000],[345000,816000]] };
$maps{"B:OL62W"} = { bbox => [[321500, 813000], [345000, 833000]], polygon => [[322000,813000],[345000,813000],[345000,833000],[322000,833000],[322000,826200],[321500,825500],[322000,824900],[322000,813000]] };
$maps{"C:1"} = { bbox => [[430000, 1175000], [470000, 1220000]], polygon => [[430000,1175000],[470000,1175000],[470000,1220000],[430000,1220000],[430000,1175000]] };
$maps{"C:2"} = { bbox => [[410000, 1145000], [450000, 1190000]], polygon => [[410000,1145000],[450000,1145000],[450000,1190000],[410000,1190000],[410000,1145000]] };
$maps{"C:3"} = { bbox => [[430000, 1130000], [470000, 1175000]], polygon => [[430000,1130000],[470000,1130000],[470000,1175000],[430000,1175000],[430000,1130000]] };
$maps{"C:4"} = { bbox => [[420000, 1105000], [460000, 1150000]], polygon => [[420000,1105000],[460000,1105000],[460000,1150000],[420000,1150000],[420000,1105000]] };
$maps{"C:4 Inset A"} = { bbox => [[392000, 1135000], [400000, 1143000]], polygon => [[392000,1135000],[400000,1135000],[400000,1143000],[392000,1143000],[392000,1135000]] };
$maps{"C:4 Inset B"} = { bbox => [[417000, 1068000], [425000, 1076000]], polygon => [[417000,1068000],[425000,1068000],[425000,1076000],[417000,1076000],[417000,1068000]] };
$maps{"C:5"} = { bbox => [[339000, 1015000], [379000, 1060000]], polygon => [[339000,1015000],[379000,1015000],[379000,1060000],[339000,1060000],[339000,1015000]] };
$maps{"C:6"} = { bbox => [[321000, 995000], [361000, 1040000]], polygon => [[321000,995000],[361000,995000],[361000,1040000],[321000,1040000],[321000,995000]] };
$maps{"C:7"} = { bbox => [[310000, 961000], [350000, 1006000]], polygon => [[310000,961000],[350000,961000],[350000,1006000],[310000,1006000],[310000,961000]] };
$maps{"C:8"} = { bbox => [[118000, 925000], [158000, 970000]], polygon => [[118000,925000],[158000,925000],[158000,970000],[118000,970000],[118000,925000]] };
$maps{"C:8 Inset A"} = { bbox => [[159000, 1028000], [164000, 1033000]], polygon => [[159000,1028000],[164000,1028000],[164000,1033000],[159000,1033000],[159000,1028000]] };
$maps{"C:8 Inset B"} = { bbox => [[179000, 1030000], [184000, 1035000]], polygon => [[179000,1030000],[184000,1030000],[184000,1035000],[179000,1035000],[179000,1030000]] };
$maps{"C:9"} = { bbox => [[210000, 935000], [250000, 980000]], polygon => [[210000,935000],[250000,935000],[250000,980000],[210000,980000],[210000,935000]] };
$maps{"C:10"} = { bbox => [[250000, 935000], [290000, 980000]], polygon => [[250000,935000],[290000,935000],[290000,980000],[250000,980000],[250000,935000]] };
$maps{"C:11"} = { bbox => [[290000, 935000], [330000, 980000]], polygon => [[290000,935000],[330000,935000],[330000,980000],[290000,980000],[290000,935000]] };
$maps{"C:12"} = { bbox => [[90000, 900000], [130000, 945000]], polygon => [[90000,900000],[130000,900000],[130000,945000],[90000,945000],[90000,900000]] };
$maps{"C:12 Inset A"} = { bbox => [[67000, 944000], [76000, 948000]], polygon => [[67000,944000],[76000,944000],[76000,948000],[67000,948000],[67000,944000]] };
$maps{"C:12 Inset B"} = { bbox => [[86000, 910000], [90000, 913000]], polygon => [[86000,910000],[90000,910000],[90000,913000],[86000,913000],[86000,910000]] };
$maps{"C:13"} = { bbox => [[195000, 900000], [235000, 945000]], polygon => [[195000,900000],[235000,900000],[235000,945000],[195000,945000],[195000,900000]] };
$maps{"C:14"} = { bbox => [[235000, 900000], [275000, 945000]], polygon => [[235000,900000],[275000,900000],[275000,945000],[235000,945000],[235000,900000]] };
$maps{"C:15"} = { bbox => [[265000, 900000], [305000, 945000]], polygon => [[265000,900000],[305000,900000],[305000,945000],[265000,945000],[265000,900000]] };
$maps{"C:16"} = { bbox => [[300000, 916000], [340000, 961000]], polygon => [[300000,916000],[340000,916000],[340000,961000],[300000,961000],[300000,916000]] };
$maps{"C:17"} = { bbox => [[65000, 858000], [105000, 903000]], polygon => [[65000,858000],[105000,858000],[105000,903000],[65000,903000],[65000,858000]] };
$maps{"C:17 Inset A"} = { bbox => [[5000, 896000], [17000, 907000]], polygon => [[5000,896000],[17000,896000],[17000,907000],[5000,907000],[5000,896000]] };
$maps{"C:17 Inset B"} = { bbox => [[59000, 880000], [64000, 884000]], polygon => [[59000,880000],[64000,880000],[64000,884000],[59000,884000],[59000,880000]] };
$maps{"C:18"} = { bbox => [[105000, 880000], [145000, 925000]], polygon => [[105000,880000],[145000,880000],[145000,925000],[105000,925000],[105000,880000]] };
$maps{"C:19"} = { bbox => [[170000, 865000], [210000, 910000]], polygon => [[170000,865000],[210000,865000],[210000,910000],[170000,910000],[170000,865000]] };
$maps{"C:20"} = { bbox => [[195000, 865000], [235000, 910000]], polygon => [[195000,865000],[235000,865000],[235000,910000],[195000,910000],[195000,865000]] };
$maps{"C:21"} = { bbox => [[235000, 865000], [275000, 910000]], polygon => [[235000,865000],[275000,865000],[275000,910000],[235000,910000],[235000,865000]] };
$maps{"C:22"} = { bbox => [[260000, 865000], [300000, 910000]], polygon => [[260000,865000],[300000,865000],[300000,910000],[260000,910000],[260000,865000]] };
$maps{"C:23"} = { bbox => [[55000, 820000], [95000, 865000]], polygon => [[55000,820000],[95000,820000],[95000,865000],[55000,865000],[55000,820000]] };
$maps{"C:24"} = { bbox => [[113000, 835000], [153000, 880000]], polygon => [[113000,835000],[153000,835000],[153000,880000],[113000,880000],[113000,835000]] };
$maps{"C:25"} = { bbox => [[140000, 820000], [180000, 865000]], polygon => [[140000,820000],[180000,820000],[180000,865000],[140000,865000],[140000,820000]] };
$maps{"C:26"} = { bbox => [[175000, 820000], [215000, 865000]], polygon => [[175000,820000],[215000,820000],[215000,865000],[175000,865000],[175000,820000]] };
$maps{"C:27"} = { bbox => [[215000, 820000], [255000, 865000]], polygon => [[215000,820000],[255000,820000],[255000,865000],[215000,865000],[215000,820000]] };
$maps{"C:28"} = { bbox => [[255000, 820000], [295000, 865000]], polygon => [[255000,820000],[295000,820000],[295000,865000],[255000,865000],[255000,820000]] };
$maps{"C:29"} = { bbox => [[295000, 830000], [335000, 875000]], polygon => [[295000,830000],[335000,830000],[335000,875000],[295000,875000],[295000,830000]] };
$maps{"C:30"} = { bbox => [[335000, 830000], [375000, 875000]], polygon => [[335000,830000],[375000,830000],[375000,875000],[335000,875000],[335000,830000]] };
$maps{"C:31"} = { bbox => [[375000, 830000], [415000, 875000]], polygon => [[375000,830000],[415000,830000],[415000,875000],[375000,875000],[375000,830000]] };
$maps{"C:32"} = { bbox => [[50000, 775000], [90000, 820000]], polygon => [[50000,775000],[90000,775000],[90000,820000],[50000,820000],[50000,775000]] };
$maps{"C:33"} = { bbox => [[113000, 790000], [153000, 835000]], polygon => [[113000,790000],[153000,790000],[153000,835000],[113000,835000],[113000,790000]] };
$maps{"C:34"} = { bbox => [[135000, 775000], [175000, 820000]], polygon => [[135000,775000],[175000,775000],[175000,820000],[135000,820000],[135000,775000]] };
$maps{"C:35"} = { bbox => [[175000, 775000], [215000, 820000]], polygon => [[175000,775000],[215000,775000],[215000,820000],[175000,820000],[175000,775000]] };
$maps{"C:36"} = { bbox => [[215000, 775000], [255000, 820000]], polygon => [[215000,775000],[255000,775000],[255000,820000],[215000,820000],[215000,775000]] };
$maps{"C:37"} = { bbox => [[255000, 775000], [295000, 820000]], polygon => [[255000,775000],[295000,775000],[295000,820000],[255000,820000],[255000,775000]] };
$maps{"C:38"} = { bbox => [[295000, 790000], [335000, 835000]], polygon => [[295000,790000],[335000,790000],[335000,835000],[295000,835000],[295000,790000]] };
$maps{"C:39"} = { bbox => [[325000, 790000], [365000, 835000]], polygon => [[325000,790000],[365000,790000],[365000,835000],[325000,835000],[325000,790000]] };
$maps{"C:40"} = { bbox => [[365000, 790000], [405000, 835000]], polygon => [[365000,790000],[405000,790000],[405000,835000],[365000,835000],[365000,790000]] };
$maps{"C:41"} = { bbox => [[295000, 770000], [335000, 815000]], polygon => [[295000,770000],[335000,770000],[335000,815000],[295000,815000],[295000,770000]] };
$maps{"C:42"} = { bbox => [[325000, 770000], [365000, 815000]], polygon => [[325000,770000],[365000,770000],[365000,815000],[325000,815000],[325000,770000]] };
$maps{"C:43"} = { bbox => [[355000, 750000], [395000, 795000]], polygon => [[355000,750000],[395000,750000],[395000,795000],[355000,795000],[355000,750000]] };
$maps{"C:44"} = { bbox => [[93000, 730000], [133000, 775000]], polygon => [[93000,730000],[133000,730000],[133000,775000],[93000,775000],[93000,730000]] };
$maps{"C:45"} = { bbox => [[133000, 730000], [173000, 775000]], polygon => [[133000,730000],[173000,730000],[173000,775000],[133000,775000],[133000,730000]] };
$maps{"C:46"} = { bbox => [[173000, 730000], [213000, 775000]], polygon => [[173000,730000],[213000,730000],[213000,775000],[173000,775000],[173000,730000]] };
$maps{"C:47"} = { bbox => [[213000, 730000], [253000, 775000]], polygon => [[213000,730000],[253000,730000],[253000,775000],[213000,775000],[213000,730000]] };
$maps{"C:48"} = { bbox => [[253000, 730000], [293000, 775000]], polygon => [[253000,730000],[293000,730000],[293000,775000],[253000,775000],[253000,730000]] };
$maps{"C:49"} = { bbox => [[293000, 730000], [333000, 775000]], polygon => [[293000,730000],[333000,730000],[333000,775000],[293000,775000],[293000,730000]] };
$maps{"C:50"} = { bbox => [[333000, 725000], [373000, 770000]], polygon => [[333000,725000],[373000,725000],[373000,770000],[333000,770000],[333000,725000]] };
$maps{"C:51"} = { bbox => [[125000, 685000], [165000, 730000]], polygon => [[125000,685000],[165000,685000],[165000,730000],[125000,730000],[125000,685000]] };
$maps{"C:52"} = { bbox => [[165000, 685000], [205000, 730000]], polygon => [[165000,685000],[205000,685000],[205000,730000],[165000,730000],[165000,685000]] };
$maps{"C:53"} = { bbox => [[205000, 685000], [245000, 730000]], polygon => [[205000,685000],[245000,685000],[245000,730000],[205000,730000],[205000,685000]] };
$maps{"C:54"} = { bbox => [[245000, 685000], [285000, 730000]], polygon => [[245000,685000],[285000,685000],[285000,730000],[245000,730000],[245000,685000]] };
$maps{"C:55"} = { bbox => [[285000, 685000], [325000, 730000]], polygon => [[285000,685000],[325000,685000],[325000,730000],[285000,730000],[285000,685000]] };
$maps{"C:56"} = { bbox => [[325000, 685000], [365000, 730000]], polygon => [[325000,685000],[365000,685000],[365000,730000],[325000,730000],[325000,685000]] };
$maps{"C:57"} = { bbox => [[115000, 640000], [155000, 685000]], polygon => [[115000,640000],[155000,640000],[155000,685000],[115000,685000],[115000,640000]] };
$maps{"C:58"} = { bbox => [[155000, 640000], [195000, 685000]], polygon => [[155000,640000],[195000,640000],[195000,685000],[155000,685000],[155000,640000]] };
$maps{"C:59"} = { bbox => [[195000, 640000], [235000, 685000]], polygon => [[195000,640000],[235000,640000],[235000,685000],[195000,685000],[195000,640000]] };
$maps{"C:60"} = { bbox => [[230000, 640000], [270000, 685000]], polygon => [[230000,640000],[270000,640000],[270000,685000],[230000,685000],[230000,640000]] };
$maps{"C:61"} = { bbox => [[270000, 640000], [310000, 685000]], polygon => [[270000,640000],[310000,640000],[310000,685000],[270000,685000],[270000,640000]] };
$maps{"C:62"} = { bbox => [[310000, 640000], [350000, 685000]], polygon => [[310000,640000],[350000,640000],[350000,685000],[310000,685000],[310000,640000]] };
$maps{"C:63"} = { bbox => [[350000, 640000], [390000, 685000]], polygon => [[350000,640000],[390000,640000],[390000,685000],[350000,685000],[350000,640000]] };
$maps{"C:64"} = { bbox => [[375000, 630000], [415000, 675000]], polygon => [[375000,630000],[415000,630000],[415000,675000],[375000,675000],[375000,630000]] };
$maps{"C:65"} = { bbox => [[155000, 600000], [195000, 645000]], polygon => [[155000,600000],[195000,600000],[195000,645000],[155000,645000],[155000,600000]] };
$maps{"C:66"} = { bbox => [[180000, 615000], [220000, 660000]], polygon => [[180000,615000],[220000,615000],[220000,660000],[180000,660000],[180000,615000]] };
$maps{"C:67"} = { bbox => [[230000, 595000], [270000, 640000]], polygon => [[230000,595000],[270000,595000],[270000,640000],[230000,640000],[230000,595000]] };
$maps{"C:68"} = { bbox => [[270000, 595000], [310000, 640000]], polygon => [[270000,595000],[310000,595000],[310000,640000],[270000,640000],[270000,595000]] };
$maps{"C:69"} = { bbox => [[310000, 595000], [350000, 640000]], polygon => [[310000,595000],[350000,595000],[350000,640000],[310000,640000],[310000,595000]] };
$maps{"C:70"} = { bbox => [[350000, 595000], [390000, 640000]], polygon => [[350000,595000],[390000,595000],[390000,640000],[350000,640000],[350000,595000]] };
$maps{"C:71"} = { bbox => [[390000, 595000], [430000, 640000]], polygon => [[390000,595000],[430000,595000],[430000,640000],[390000,640000],[390000,595000]] };
$maps{"C:72"} = { bbox => [[195000, 575000], [235000, 620000]], polygon => [[195000,575000],[235000,575000],[235000,620000],[195000,620000],[195000,575000]] };
$maps{"C:73"} = { bbox => [[230000, 550000], [270000, 595000]], polygon => [[230000,550000],[270000,550000],[270000,595000],[230000,595000],[230000,550000]] };
$maps{"C:74"} = { bbox => [[270000, 550000], [310000, 595000]], polygon => [[270000,550000],[310000,550000],[310000,595000],[270000,595000],[270000,550000]] };
$maps{"C:75"} = { bbox => [[293000, 550000], [333000, 595000]], polygon => [[293000,550000],[333000,550000],[333000,595000],[293000,595000],[293000,550000]] };
$maps{"C:76"} = { bbox => [[333000, 550000], [373000, 595000]], polygon => [[333000,550000],[373000,550000],[373000,595000],[333000,595000],[333000,550000]] };
$maps{"C:77"} = { bbox => [[373000, 550000], [413000, 595000]], polygon => [[373000,550000],[413000,550000],[413000,595000],[373000,595000],[373000,550000]] };
$maps{"C:78"} = { bbox => [[403000, 550000], [443000, 595000]], polygon => [[403000,550000],[443000,550000],[443000,595000],[403000,595000],[403000,550000]] };
$maps{"C:79"} = { bbox => [[195000, 530000], [235000, 575000]], polygon => [[195000,530000],[235000,530000],[235000,575000],[195000,575000],[195000,530000]] };
$maps{"C:80"} = { bbox => [[230000, 530000], [270000, 575000]], polygon => [[230000,530000],[270000,530000],[270000,575000],[230000,575000],[230000,530000]] };
$maps{"C:81"} = { bbox => [[270000, 530000], [310000, 575000]], polygon => [[270000,530000],[310000,530000],[310000,575000],[270000,575000],[270000,530000]] };
$maps{"C:82"} = { bbox => [[293000, 505000], [333000, 550000]], polygon => [[293000,505000],[333000,505000],[333000,550000],[293000,550000],[293000,505000]] };
$maps{"C:83"} = { bbox => [[333000, 505000], [373000, 550000]], polygon => [[333000,505000],[373000,505000],[373000,550000],[333000,550000],[333000,505000]] };
$maps{"C:84"} = { bbox => [[373000, 505000], [413000, 550000]], polygon => [[373000,505000],[413000,505000],[413000,550000],[373000,550000],[373000,505000]] };
$maps{"C:85"} = { bbox => [[413000, 505000], [453000, 550000]], polygon => [[413000,505000],[453000,505000],[453000,550000],[413000,550000],[413000,505000]] };
$maps{"C:86"} = { bbox => [[453000, 485000], [493000, 530000]], polygon => [[453000,485000],[493000,485000],[493000,530000],[453000,530000],[453000,485000]] };
$maps{"C:87"} = { bbox => [[212000, 462000], [252000, 507000]], polygon => [[212000,462000],[252000,462000],[252000,507000],[212000,507000],[212000,462000]] };
$maps{"C:88"} = { bbox => [[300000, 460000], [340000, 505000]], polygon => [[300000,460000],[340000,460000],[340000,505000],[300000,505000],[300000,460000]] };
$maps{"C:89"} = { bbox => [[330000, 460000], [370000, 505000]], polygon => [[330000,460000],[370000,460000],[370000,505000],[330000,505000],[330000,460000]] };
$maps{"C:90"} = { bbox => [[370000, 460000], [410000, 505000]], polygon => [[370000,460000],[410000,460000],[410000,505000],[370000,505000],[370000,460000]] };
$maps{"C:91"} = { bbox => [[410000, 460000], [450000, 505000]], polygon => [[410000,460000],[450000,460000],[450000,505000],[410000,505000],[410000,460000]] };
$maps{"C:92"} = { bbox => [[450000, 460000], [490000, 505000]], polygon => [[450000,460000],[490000,460000],[490000,505000],[450000,505000],[450000,460000]] };
$maps{"C:93"} = { bbox => [[487000, 465000], [527000, 510000]], polygon => [[487000,465000],[527000,465000],[527000,510000],[487000,510000],[487000,465000]] };
$maps{"C:94"} = { bbox => [[330000, 420000], [370000, 465000]], polygon => [[330000,420000],[370000,420000],[370000,465000],[330000,465000],[330000,420000]] };
$maps{"C:95"} = { bbox => [[360000, 415000], [400000, 460000]], polygon => [[360000,415000],[400000,415000],[400000,460000],[360000,460000],[360000,415000]] };
$maps{"C:96"} = { bbox => [[400000, 415000], [440000, 460000]], polygon => [[400000,415000],[440000,415000],[440000,460000],[400000,460000],[400000,415000]] };
$maps{"C:97"} = { bbox => [[440000, 420000], [480000, 465000]], polygon => [[440000,420000],[480000,420000],[480000,465000],[440000,465000],[440000,420000]] };
$maps{"C:98"} = { bbox => [[460000, 420000], [500000, 465000]], polygon => [[460000,420000],[500000,420000],[500000,465000],[460000,465000],[460000,420000]] };
$maps{"C:99"} = { bbox => [[500000, 420000], [540000, 465000]], polygon => [[500000,420000],[540000,420000],[540000,465000],[500000,465000],[500000,420000]] };
$maps{"C:100"} = { bbox => [[320000, 375000], [360000, 420000]], polygon => [[320000,375000],[360000,375000],[360000,420000],[320000,420000],[320000,375000]] };
$maps{"C:101"} = { bbox => [[360000, 375000], [400000, 420000]], polygon => [[360000,375000],[400000,375000],[400000,420000],[360000,420000],[360000,375000]] };
$maps{"C:102"} = { bbox => [[400000, 385000], [440000, 430000]], polygon => [[400000,385000],[440000,385000],[440000,430000],[400000,430000],[400000,385000]] };
$maps{"C:103"} = { bbox => [[435000, 375000], [475000, 420000]], polygon => [[435000,375000],[475000,375000],[475000,420000],[435000,420000],[435000,375000]] };
$maps{"C:104"} = { bbox => [[475000, 375000], [515000, 420000]], polygon => [[475000,375000],[515000,375000],[515000,420000],[475000,420000],[475000,375000]] };
$maps{"C:105"} = { bbox => [[515000, 375000], [555000, 420000]], polygon => [[515000,375000],[555000,375000],[555000,420000],[515000,420000],[515000,375000]] };
$maps{"C:106"} = { bbox => [[221000, 353000], [261000, 398000]], polygon => [[221000,353000],[261000,353000],[261000,398000],[221000,398000],[221000,353000]] };
$maps{"C:106 Inset"} = { bbox => [[261000, 361000], [266000, 383000]], polygon => [[261000,361000],[266000,361000],[266000,383000],[261000,383000],[261000,361000]] };
$maps{"C:107"} = { bbox => [[248000, 340000], [288000, 385000]], polygon => [[248000,340000],[288000,340000],[288000,385000],[248000,385000],[248000,340000]] };
$maps{"C:108"} = { bbox => [[288000, 340000], [328000, 385000]], polygon => [[288000,340000],[328000,340000],[328000,385000],[288000,385000],[288000,340000]] };
$maps{"C:109"} = { bbox => [[320000, 345000], [360000, 390000]], polygon => [[320000,345000],[360000,345000],[360000,390000],[320000,390000],[320000,345000]] };
$maps{"C:110"} = { bbox => [[360000, 330000], [400000, 375000]], polygon => [[360000,330000],[400000,330000],[400000,375000],[360000,375000],[360000,330000]] };
$maps{"C:111"} = { bbox => [[400000, 345000], [440000, 390000]], polygon => [[400000,345000],[440000,345000],[440000,390000],[400000,390000],[400000,345000]] };
$maps{"C:112"} = { bbox => [[440000, 330000], [480000, 375000]], polygon => [[440000,330000],[480000,330000],[480000,375000],[440000,375000],[440000,330000]] };
$maps{"C:113"} = { bbox => [[480000, 330000], [520000, 375000]], polygon => [[480000,330000],[520000,330000],[520000,375000],[480000,375000],[480000,330000]] };
$maps{"C:114"} = { bbox => [[520000, 330000], [560000, 375000]], polygon => [[520000,330000],[560000,330000],[560000,375000],[520000,375000],[520000,330000]] };
$maps{"C:115"} = { bbox => [[210000, 320000], [250000, 365000]], polygon => [[210000,320000],[250000,320000],[250000,365000],[210000,365000],[210000,320000]] };
$maps{"C:116"} = { bbox => [[248000, 308000], [288000, 353000]], polygon => [[248000,308000],[288000,308000],[288000,353000],[248000,353000],[248000,308000]] };
$maps{"C:117"} = { bbox => [[288000, 300000], [328000, 345000]], polygon => [[288000,300000],[328000,300000],[328000,345000],[288000,345000],[288000,300000]] };
$maps{"C:118"} = { bbox => [[328000, 300000], [368000, 345000]], polygon => [[328000,300000],[368000,300000],[368000,345000],[328000,345000],[328000,300000]] };
$maps{"C:119"} = { bbox => [[360000, 300000], [400000, 345000]], polygon => [[360000,300000],[400000,300000],[400000,345000],[360000,345000],[360000,300000]] };
$maps{"C:120"} = { bbox => [[400000, 300000], [440000, 345000]], polygon => [[400000,300000],[440000,300000],[440000,345000],[400000,345000],[400000,300000]] };
$maps{"C:121"} = { bbox => [[428000, 300000], [468000, 345000]], polygon => [[428000,300000],[468000,300000],[468000,345000],[428000,345000],[428000,300000]] };
$maps{"C:122"} = { bbox => [[455000, 300000], [495000, 345000]], polygon => [[455000,300000],[495000,300000],[495000,345000],[455000,345000],[455000,300000]] };
$maps{"C:123"} = { bbox => [[495000, 300000], [535000, 345000]], polygon => [[495000,300000],[535000,300000],[535000,345000],[495000,345000],[495000,300000]] };
$maps{"C:124"} = { bbox => [[535000, 300000], [575000, 345000]], polygon => [[535000,300000],[575000,300000],[575000,345000],[535000,345000],[535000,300000]] };
$maps{"C:125"} = { bbox => [[575000, 302000], [615000, 347000]], polygon => [[575000,302000],[615000,302000],[615000,347000],[575000,347000],[575000,302000]] };
$maps{"C:126"} = { bbox => [[615000, 302000], [655000, 347000]], polygon => [[615000,302000],[655000,302000],[655000,347000],[615000,347000],[615000,302000]] };
$maps{"C:127"} = { bbox => [[248000, 263000], [288000, 308000]], polygon => [[248000,263000],[288000,263000],[288000,308000],[248000,308000],[248000,263000]] };
$maps{"C:128"} = { bbox => [[288000, 255000], [328000, 300000]], polygon => [[288000,255000],[328000,255000],[328000,300000],[288000,300000],[288000,255000]] };
$maps{"C:129"} = { bbox => [[328000, 255000], [368000, 300000]], polygon => [[328000,255000],[368000,255000],[368000,300000],[328000,300000],[328000,255000]] };
$maps{"C:130"} = { bbox => [[360000, 255000], [400000, 300000]], polygon => [[360000,255000],[400000,255000],[400000,300000],[360000,300000],[360000,255000]] };
$maps{"C:131"} = { bbox => [[388000, 255000], [428000, 300000]], polygon => [[388000,255000],[428000,255000],[428000,300000],[388000,300000],[388000,255000]] };
$maps{"C:132"} = { bbox => [[428000, 255000], [468000, 300000]], polygon => [[428000,255000],[468000,255000],[468000,300000],[428000,300000],[428000,255000]] };
$maps{"C:133"} = { bbox => [[455000, 255000], [495000, 300000]], polygon => [[455000,255000],[495000,255000],[495000,300000],[455000,300000],[455000,255000]] };
$maps{"C:134"} = { bbox => [[495000, 255000], [535000, 300000]], polygon => [[495000,255000],[535000,255000],[535000,300000],[495000,300000],[495000,255000]] };
$maps{"C:135"} = { bbox => [[535000, 255000], [575000, 300000]], polygon => [[535000,255000],[575000,255000],[575000,300000],[535000,300000],[535000,255000]] };
$maps{"C:136"} = { bbox => [[575000, 257000], [615000, 302000]], polygon => [[575000,257000],[615000,257000],[615000,302000],[575000,302000],[575000,257000]] };
$maps{"C:137"} = { bbox => [[615000, 257000], [656000, 302000]], polygon => [[615000,257000],[655000,257000],[655000,292000],[656000,292000],[656000,297000],[655000,297000],[655000,302000],[615000,302000],[615000,257000]] };
$maps{"C:138"} = { bbox => [[165000, 205000], [208000, 250000]], polygon => [[168000,205000],[208000,205000],[208000,250000],[168000,250000],[168000,229000],[165000,229000],[165000,222000],[168000,222000],[168000,205000]] };
$maps{"C:139"} = { bbox => [[208000, 218000], [248000, 264000]], polygon => [[208000,218000],[248000,218000],[248000,264000],[208000,264000],[208000,218000]] };
$maps{"C:140"} = { bbox => [[248000, 218000], [288000, 263000]], polygon => [[248000,218000],[288000,218000],[288000,263000],[248000,263000],[248000,218000]] };
$maps{"C:141"} = { bbox => [[288000, 210000], [328000, 255000]], polygon => [[288000,210000],[328000,210000],[328000,255000],[288000,255000],[288000,210000]] };
$maps{"C:142"} = { bbox => [[328000, 210000], [368000, 255000]], polygon => [[328000,210000],[368000,210000],[368000,255000],[328000,255000],[328000,210000]] };
$maps{"C:143"} = { bbox => [[360000, 210000], [400000, 255000]], polygon => [[360000,210000],[400000,210000],[400000,255000],[360000,255000],[360000,210000]] };
$maps{"C:144"} = { bbox => [[388000, 210000], [428000, 255000]], polygon => [[388000,210000],[428000,210000],[428000,255000],[388000,255000],[388000,210000]] };
$maps{"C:145"} = { bbox => [[428000, 210000], [468000, 255000]], polygon => [[428000,210000],[468000,210000],[468000,255000],[428000,255000],[428000,210000]] };
$maps{"C:146"} = { bbox => [[455000, 210000], [495000, 255000]], polygon => [[455000,210000],[495000,210000],[495000,255000],[455000,255000],[455000,210000]] };
$maps{"C:147"} = { bbox => [[495000, 210000], [535000, 255000]], polygon => [[495000,210000],[535000,210000],[535000,255000],[495000,255000],[495000,210000]] };
$maps{"C:148"} = { bbox => [[535000, 210000], [575000, 255000]], polygon => [[535000,210000],[575000,210000],[575000,255000],[535000,255000],[535000,210000]] };
$maps{"C:149"} = { bbox => [[570000, 212000], [610000, 257000]], polygon => [[570000,212000],[610000,212000],[610000,257000],[570000,257000],[570000,212000]] };
$maps{"C:150"} = { bbox => [[610000, 212000], [650000, 257000]], polygon => [[610000,212000],[650000,212000],[650000,257000],[610000,257000],[610000,212000]] };
$maps{"C:151"} = { bbox => [[165000, 190000], [208000, 235000]], polygon => [[168000,190000],[208000,190000],[208000,235000],[168000,235000],[168000,229000],[165000,229000],[165000,222000],[168000,222000],[168000,190000]] };
$maps{"C:151 Inset"} = { bbox => [[146000, 206000], [161000, 210000]], polygon => [[146000,206000],[161000,206000],[161000,210000],[146000,210000],[146000,206000]] };
$maps{"C:152"} = { bbox => [[208000, 180000], [248000, 225000]], polygon => [[208000,180000],[248000,180000],[248000,225000],[208000,225000],[208000,180000]] };
$maps{"C:153"} = { bbox => [[248000, 173000], [288000, 218000]], polygon => [[248000,173000],[288000,173000],[288000,218000],[248000,218000],[248000,173000]] };
$maps{"C:154"} = { bbox => [[288000, 165000], [328000, 210000]], polygon => [[288000,165000],[328000,165000],[328000,210000],[288000,210000],[288000,165000]] };
$maps{"C:155"} = { bbox => [[328000, 165000], [368000, 210000]], polygon => [[328000,165000],[368000,165000],[368000,210000],[328000,210000],[328000,165000]] };
$maps{"C:156"} = { bbox => [[353000, 165000], [393000, 210000]], polygon => [[353000,165000],[393000,165000],[393000,210000],[353000,210000],[353000,165000]] };
$maps{"C:157"} = { bbox => [[388000, 165000], [428000, 210000]], polygon => [[388000,165000],[428000,165000],[428000,210000],[388000,210000],[388000,165000]] };
$maps{"C:158"} = { bbox => [[428000, 165000], [468000, 210000]], polygon => [[428000,165000],[468000,165000],[468000,210000],[428000,210000],[428000,165000]] };
$maps{"C:159"} = { bbox => [[463000, 173000], [503000, 218000]], polygon => [[463000,173000],[503000,173000],[503000,218000],[463000,218000],[463000,173000]] };
$maps{"C:160"} = { bbox => [[495000, 180000], [535000, 225000]], polygon => [[495000,180000],[535000,180000],[535000,225000],[495000,225000],[495000,180000]] };
$maps{"C:161"} = { bbox => [[535000, 170000], [575000, 215000]], polygon => [[535000,170000],[575000,170000],[575000,215000],[535000,215000],[535000,170000]] };
$maps{"C:162"} = { bbox => [[570000, 180000], [610000, 225000]], polygon => [[570000,180000],[610000,180000],[610000,225000],[570000,225000],[570000,180000]] };
$maps{"C:163"} = { bbox => [[240000, 110000], [280000, 155000]], polygon => [[240000,110000],[280000,110000],[280000,155000],[240000,155000],[240000,110000]] };
$maps{"C:163 Inset"} = { bbox => [[212000, 143000], [216000, 149000]], polygon => [[212000,143000],[216000,143000],[216000,149000],[212000,149000],[212000,143000]] };
$maps{"C:164"} = { bbox => [[280000, 110000], [320000, 155000]], polygon => [[280000,110000],[320000,110000],[320000,155000],[280000,155000],[280000,110000]] };
$maps{"C:165"} = { bbox => [[320000, 130000], [360000, 175000]], polygon => [[320000,130000],[360000,130000],[360000,175000],[320000,175000],[320000,130000]] };
$maps{"C:166"} = { bbox => [[353000, 120000], [393000, 165000]], polygon => [[353000,120000],[393000,120000],[393000,165000],[353000,165000],[353000,120000]] };
$maps{"C:167"} = { bbox => [[388000, 120000], [428000, 165000]], polygon => [[388000,120000],[428000,120000],[428000,165000],[388000,165000],[388000,120000]] };
$maps{"C:168"} = { bbox => [[428000, 120000], [468000, 165000]], polygon => [[428000,120000],[468000,120000],[468000,165000],[428000,165000],[428000,120000]] };
$maps{"C:169"} = { bbox => [[463000, 128000], [505000, 173000]], polygon => [[463000,128000],[505000,128000],[505000,173000],[463000,173000],[463000,128000]] };
$maps{"C:170"} = { bbox => [[495000, 135000], [535000, 180000]], polygon => [[495000,135000],[535000,135000],[535000,180000],[495000,180000],[495000,135000]] };
$maps{"C:171"} = { bbox => [[535000, 135000], [575000, 180000]], polygon => [[535000,135000],[575000,135000],[575000,180000],[535000,180000],[535000,135000]] };
$maps{"C:172"} = { bbox => [[570000, 135000], [610000, 180000]], polygon => [[570000,135000],[610000,135000],[610000,180000],[570000,180000],[570000,135000]] };
$maps{"C:173"} = { bbox => [[602000, 128000], [642000, 173000]], polygon => [[602000,128000],[642000,128000],[642000,173000],[602000,173000],[602000,128000]] };
$maps{"C:174"} = { bbox => [[200000, 80000], [240000, 125000]], polygon => [[200000,80000],[240000,80000],[240000,125000],[200000,125000],[200000,80000]] };
$maps{"C:175"} = { bbox => [[240000, 70000], [280000, 115000]], polygon => [[240000,70000],[280000,70000],[280000,115000],[240000,115000],[240000,70000]] };
$maps{"C:176"} = { bbox => [[280000, 70000], [320000, 115000]], polygon => [[280000,70000],[320000,70000],[320000,115000],[280000,115000],[280000,70000]] };
$maps{"C:177"} = { bbox => [[320000, 85000], [360000, 130000]], polygon => [[320000,85000],[360000,85000],[360000,130000],[320000,130000],[320000,85000]] };
$maps{"C:178"} = { bbox => [[353000, 68000], [393000, 120000]], polygon => [[353000,75000],[366500,75000],[367000,74000],[367000,68000],[371000,68000],[371000,75000],[393000,75000],[393000,120000],[353000,120000],[353000,75000]] };
$maps{"C:179"} = { bbox => [[388000, 75000], [428000, 120000]], polygon => [[388000,75000],[428000,75000],[428000,120000],[388000,120000],[388000,75000]] };
$maps{"C:180"} = { bbox => [[428000, 75000], [468000, 120000]], polygon => [[428000,75000],[468000,75000],[468000,120000],[428000,120000],[428000,75000]] };
$maps{"C:181"} = { bbox => [[462000, 90000], [503000, 135000]], polygon => [[463000,90000],[503000,90000],[503000,135000],[463000,135000],[463000,102000],[462000,102000],[462000,98500],[463000,98500],[463000,90000]] };
$maps{"C:182"} = { bbox => [[495000, 99000], [535000, 145000]], polygon => [[495000,99000],[496000,99000],[499500,100000],[535000,100000],[535000,145000],[495000,145000],[495000,99000]] };
$maps{"C:183"} = { bbox => [[535000, 93000], [575000, 138000]], polygon => [[535000,93000],[575000,93000],[575000,138000],[535000,138000],[535000,93000]] };
$maps{"C:184"} = { bbox => [[570000, 105000], [610000, 150000]], polygon => [[570000,105000],[610000,105000],[610000,150000],[570000,150000],[570000,105000]] };
$maps{"C:185"} = { bbox => [[170000, 50000], [210000, 95000]], polygon => [[170000,50000],[210000,50000],[210000,95000],[170000,95000],[170000,50000]] };
$maps{"C:186"} = { bbox => [[200000, 45000], [240000, 90000]], polygon => [[200000,45000],[240000,45000],[240000,90000],[200000,90000],[200000,45000]] };
$maps{"C:187"} = { bbox => [[240000, 35000], [280000, 80000]], polygon => [[240000,35000],[280000,35000],[280000,80000],[240000,80000],[240000,35000]] };
$maps{"C:188"} = { bbox => [[260000, 35000], [300000, 80000]], polygon => [[260000,35000],[300000,35000],[300000,80000],[260000,80000],[260000,35000]] };
$maps{"C:189"} = { bbox => [[130000, 10000], [170000, 55000]], polygon => [[130000,10000],[170000,10000],[170000,55000],[130000,55000],[130000,10000]] };
$maps{"C:189 Inset"} = { bbox => [[80000, 5000], [97000, 18500]], polygon => [[80000,5000],[97000,5000],[97000,18500],[85500,18500],[80000,10000],[80000,5000]] };
$maps{"C:190"} = { bbox => [[170000, 10000], [210000, 55000]], polygon => [[170000,10000],[210000,10000],[210000,55000],[170000,55000],[170000,10000]] };
1;
