use 5.012;
use warnings;
use Test::More;
use Test::Deep;
use Panda::XS;

plan skip_all => 'rebuild Makefile.pl with TEST_FULL=1 CPP11X=1 to enable threads tests' unless Panda::XS::Test->can('i8');
plan skip_all => 'threaded perl required to run these tests' unless eval "use threads; use threads::shared; 1;";

my ($obj, $thr);
my @thres : shared;

# 1) object has CLONE_SKIP (not support threads)
$obj = Panda::XS::Test::MixBase->new(123);
is($obj->val, 123);
$thr = threads->create(\&thr_mybase);
$thr->join;
is($obj->val, 123);
cmp_deeply(\@thres, ['SCALAR', undef, undef], "XS MixBase must self-destroy");
is(Panda::XS::Test::dcnt(), 0, 'MixBase must not exist in thread');
undef $obj;
is(Panda::XS::Test::dcnt(), 1, 'MixBase has been destroyed in parent');
Panda::XS::Test::dcnt(0);

# 2) object is thread-unsafe, clones itself on thread creation
{
    package Panda::XS::Test::MyChild;
    our @ISA = 'Panda::XS::Test::MyBase';
}
$obj = Panda::XS::Test::MyChild->new(234, 345);
cmp_deeply([$obj->val, $obj->val2], [234, 345]);
@thres = ();
$thr = threads->create(\&thr_mychild);
$thr->join;
cmp_deeply([$obj->val, $obj->val2], [234, 345], 'Parent thread MyChild object not changed');
cmp_deeply(\@thres, ['Panda::XS::Test::MyChild', 100, 200], 'Child thread MyChild object works and changed');
is(Panda::XS::Test::dcnt(), 2, 'MyChild has been destroyed in thread');
undef $obj;
is(Panda::XS::Test::dcnt(), 4, 'MyChild has been destroyed in parent also');
Panda::XS::Test::dcnt(0);

# 3) object is thread-safe, increments refcnt on thread creation
$obj = Panda::XS::Test::MyThreadSafe->new(12);
is($obj->val, 12);
@thres = ();
$thr = threads->create(\&thr_mythread_safe);
$thr->join;
is($obj->val, 100, 'Parent thread MyThreadSafe object changed');
cmp_deeply(\@thres, ['Panda::XS::Test::MyThreadSafe', 100], 'Child thread MyChild object works and same');
is(Panda::XS::Test::dcnt(), 0, 'MyThreadSafe has not been destroyed in thread');
undef $obj;
is(Panda::XS::Test::dcnt(), 1, 'MyThreadSafe has been destroyed in parent');

done_testing();

sub thr_mybase {
    @thres = (ref($obj), $$obj, scalar eval { $obj->val; 1 });
}

sub thr_mychild {
    $obj->val(100);
    $obj->val2(200);
    @thres = (ref($obj), $obj->val, $obj->val2);
}

sub thr_mythread_safe {
    $obj->val(100);
    @thres = (ref($obj), $obj->val);
}