use 5.012;
use warnings;
use strict;

use Cwd;
use ExtUtils::MakeMaker;
use File::Find;

WriteMakefile
(
  PL_FILES => {},
  EXE_FILES => [],
  NAME => 'Devel::Examine::Subs',
  MIN_PERL_VERSION => '5.012',
  LICENSE => 'perl',
  INSTALLDIRS => 'site',
  VERSION_FROM => 'lib/Devel/Examine/Subs.pm',
  META_MERGE => {
        'meta-spec' => { version => 2 },
        resources   => {
            repository => {
                type => 'git',
                url => 'https://github.com/stevieb9/devel-examine-subs.git',
                web => 'https://github.com/stevieb9/devel-examine-subs',
            },
        },
    },
    CONFIGURE_REQUIRES => {
        'Cwd' => 0,
        'File::Find' => 0,
        'ExtUtils::MakeMaker' => 0,
    },
    BUILD_REQUIRES => {
        'Test::More' => 0,
        'Test::Trap' => 0,
    },

  PREREQ_PM => {
                   'Carp' => 0,
                   'Data::Compare' => 0,
                   'Data::Dumper' => 0,
                   'File::Basename' => 0,
                   'File::Edit::Portable' => '0.08',
                   'File::Find' => 0,
                   'PPI' => 0,
                   'Symbol' => 0,
                 }
);

__END__
if ($^O eq 'MSWin32'){

    print "\nPreparing unit tests for MSWin32 platform...\n\n";

    my @files;

    find({wanted => sub {
            push @files, $File::Find::name if -f;
        },
        no_chdir => 1,
      }, getcwd() . '/t'
    );

    for (@files){

        open my $fh, '<', $_ or die $!;
        my @file = <$fh>;
        close $fh or die $!;

        open my $wfh, '>', $_ or die $!;

        for (@file){
            s/\n/\r\n/g;
            print $wfh $_;
        }
        close $wfh or die $!;
    }
}
