package Padre::Wx::Menu::Perl;

# Fully encapsulated Run menu

use 5.008;
use strict;
use warnings;
use Params::Util       ();
use Padre::Wx          ();
use Padre::Wx::Submenu ();

our $VERSION = '0.22';
our @ISA     = 'Padre::Wx::Submenu';





#####################################################################
# Padre::Wx::Submenu Methods

sub new {
	my $class = shift;
	my $main  = shift;

	# Create the empty menu as normal
	my $self = $class->SUPER::new(@_);

	# Perl-Specific Searches
	Wx::Event::EVT_MENU( $main,
		$self->Append( -1, Wx::gettext("Find Unmatched Brace") ),
		sub {
			my $doc = Padre::Documents->current;
			return unless Params::Util::_INSTANCE($doc, 'Padre::Document::Perl');
			$doc->find_unmatched_brace;
		},
	);

	Wx::Event::EVT_MENU( $main,
		$self->Append( -1, Wx::gettext("Find variable declaration") ),
		sub {
			my $doc = Padre::Documents->current;
			return unless Params::Util::_INSTANCE($doc, 'Padre::Document::Perl');
			$doc->find_variable_declaration;
		},
	);

	if ( Padre->ide->config->{experimental} ) {
		Wx::Event::EVT_MENU( $main,
			$self->Append( -1, Wx::gettext("Lexically replace variable") ),
			sub {
				my $doc = Padre::Documents->current;
				return unless Params::Util::_INSTANCE($doc, 'Padre::Document::Perl');
				my $dialog = Padre::Wx::History::TextDialog->new(
					$_[0],
					Wx::gettext("Replacement"),
					Wx::gettext("Replacement"),
					'$foo',
				);
				if ( $dialog->ShowModal == Wx::wxID_CANCEL ) {
					return;
				}
				my $replacement = $dialog->GetValue;
				$dialog->Destroy;
				return unless defined $replacement;

				$doc->lexical_variable_replacement($replacement);
			},
		);
	}

	return $self;
}

1;
