
=head1 NAME

Chronicle::Plugin::Version - Make the chronicle version available to templates

=head1 DESCRIPTION

This module makes the C<release> variable available to chronicle templates.

This can be used in templates like so:

=for example begin

    Generated by Chronicle <!-- tmpl_var name='release' -->

=for example end

=cut

=head1 AUTHOR

Steve Kemp <steve@steve.org.uk>

=cut

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2014 Steve Kemp <steve@steve.org.uk>.

This library is free software. You can modify and or distribute it under
the same terms as Perl itself.

=cut

package Chronicle::Plugin::Version;

use strict;
use warnings;


=begin doc

Update the global variables with a reference to our release version.

=end doc

=cut

sub on_initiate
{
    my ( $self, %args ) = (@_);

    my $dbh    = $args{ 'dbh' };
    my $config = $args{ 'config' };

    $Chronicle::GLOBAL_TEMPLATE_VARS{ "release" } = $Chronicle::VERSION;
}


1;
