package Date::Manip::TZ::aulord00;
# Copyright (c) 2008-2011 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Mon Mar  7 10:30:33 EST 2011
#    Data version: tzdata2011b
#    Code version: tzcode2011b

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::aulord00 - Support for the Australia/Lord_Howe time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.22';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,10,36,20],'+10:36:20',[10,36,20],
          'LMT',0,[1895,1,31,13,23,39],[1895,1,31,23,59,59],
          '0001010200:00:00','0001010210:36:20','1895013113:23:39','1895013123:59:59' ],
     ],
   1895 =>
     [
        [ [1895,1,31,13,23,40],[1895,1,31,23,23,40],'+10:00:00',[10,0,0],
          'EST',0,[1981,2,28,13,59,59],[1981,2,28,23,59,59],
          '1895013113:23:40','1895013123:23:40','1981022813:59:59','1981022823:59:59' ],
     ],
   1981 =>
     [
        [ [1981,2,28,14,0,0],[1981,3,1,0,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1981,10,24,15,29,59],[1981,10,25,1,59,59],
          '1981022814:00:00','1981030100:30:00','1981102415:29:59','1981102501:59:59' ],
        [ [1981,10,24,15,30,0],[1981,10,25,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1982,3,6,14,29,59],[1982,3,7,1,59,59],
          '1981102415:30:00','1981102503:00:00','1982030614:29:59','1982030701:59:59' ],
     ],
   1982 =>
     [
        [ [1982,3,6,14,30,0],[1982,3,7,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1982,10,30,15,29,59],[1982,10,31,1,59,59],
          '1982030614:30:00','1982030701:00:00','1982103015:29:59','1982103101:59:59' ],
        [ [1982,10,30,15,30,0],[1982,10,31,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1983,3,5,14,29,59],[1983,3,6,1,59,59],
          '1982103015:30:00','1982103103:00:00','1983030514:29:59','1983030601:59:59' ],
     ],
   1983 =>
     [
        [ [1983,3,5,14,30,0],[1983,3,6,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1983,10,29,15,29,59],[1983,10,30,1,59,59],
          '1983030514:30:00','1983030601:00:00','1983102915:29:59','1983103001:59:59' ],
        [ [1983,10,29,15,30,0],[1983,10,30,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1984,3,3,14,29,59],[1984,3,4,1,59,59],
          '1983102915:30:00','1983103003:00:00','1984030314:29:59','1984030401:59:59' ],
     ],
   1984 =>
     [
        [ [1984,3,3,14,30,0],[1984,3,4,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1984,10,27,15,29,59],[1984,10,28,1,59,59],
          '1984030314:30:00','1984030401:00:00','1984102715:29:59','1984102801:59:59' ],
        [ [1984,10,27,15,30,0],[1984,10,28,3,0,0],'+11:30:00',[11,30,0],
          'LHST',1,[1985,3,2,14,29,59],[1985,3,3,1,59,59],
          '1984102715:30:00','1984102803:00:00','1985030214:29:59','1985030301:59:59' ],
     ],
   1985 =>
     [
        [ [1985,3,2,14,30,0],[1985,3,3,1,0,0],'+10:30:00',[10,30,0],
          'LHST',0,[1985,10,26,15,29,59],[1985,10,27,1,59,59],
          '1985030214:30:00','1985030301:00:00','1985102615:29:59','1985102701:59:59' ],
        [ [1985,10,26,15,30,0],[1985,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1986,3,15,14,59,59],[1986,3,16,1,59,59],
          '1985102615:30:00','1985102702:30:00','1986031514:59:59','1986031601:59:59' ],
     ],
   1986 =>
     [
        [ [1986,3,15,15,0,0],[1986,3,16,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1986,10,18,15,29,59],[1986,10,19,1,59,59],
          '1986031515:00:00','1986031601:30:00','1986101815:29:59','1986101901:59:59' ],
        [ [1986,10,18,15,30,0],[1986,10,19,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1987,3,14,14,59,59],[1987,3,15,1,59,59],
          '1986101815:30:00','1986101902:30:00','1987031414:59:59','1987031501:59:59' ],
     ],
   1987 =>
     [
        [ [1987,3,14,15,0,0],[1987,3,15,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1987,10,24,15,29,59],[1987,10,25,1,59,59],
          '1987031415:00:00','1987031501:30:00','1987102415:29:59','1987102501:59:59' ],
        [ [1987,10,24,15,30,0],[1987,10,25,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1988,3,19,14,59,59],[1988,3,20,1,59,59],
          '1987102415:30:00','1987102502:30:00','1988031914:59:59','1988032001:59:59' ],
     ],
   1988 =>
     [
        [ [1988,3,19,15,0,0],[1988,3,20,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1988,10,29,15,29,59],[1988,10,30,1,59,59],
          '1988031915:00:00','1988032001:30:00','1988102915:29:59','1988103001:59:59' ],
        [ [1988,10,29,15,30,0],[1988,10,30,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1989,3,18,14,59,59],[1989,3,19,1,59,59],
          '1988102915:30:00','1988103002:30:00','1989031814:59:59','1989031901:59:59' ],
     ],
   1989 =>
     [
        [ [1989,3,18,15,0,0],[1989,3,19,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1989,10,28,15,29,59],[1989,10,29,1,59,59],
          '1989031815:00:00','1989031901:30:00','1989102815:29:59','1989102901:59:59' ],
        [ [1989,10,28,15,30,0],[1989,10,29,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1990,3,3,14,59,59],[1990,3,4,1,59,59],
          '1989102815:30:00','1989102902:30:00','1990030314:59:59','1990030401:59:59' ],
     ],
   1990 =>
     [
        [ [1990,3,3,15,0,0],[1990,3,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1990,10,27,15,29,59],[1990,10,28,1,59,59],
          '1990030315:00:00','1990030401:30:00','1990102715:29:59','1990102801:59:59' ],
        [ [1990,10,27,15,30,0],[1990,10,28,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1991,3,2,14,59,59],[1991,3,3,1,59,59],
          '1990102715:30:00','1990102802:30:00','1991030214:59:59','1991030301:59:59' ],
     ],
   1991 =>
     [
        [ [1991,3,2,15,0,0],[1991,3,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1991,10,26,15,29,59],[1991,10,27,1,59,59],
          '1991030215:00:00','1991030301:30:00','1991102615:29:59','1991102701:59:59' ],
        [ [1991,10,26,15,30,0],[1991,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1992,2,29,14,59,59],[1992,3,1,1,59,59],
          '1991102615:30:00','1991102702:30:00','1992022914:59:59','1992030101:59:59' ],
     ],
   1992 =>
     [
        [ [1992,2,29,15,0,0],[1992,3,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1992,10,24,15,29,59],[1992,10,25,1,59,59],
          '1992022915:00:00','1992030101:30:00','1992102415:29:59','1992102501:59:59' ],
        [ [1992,10,24,15,30,0],[1992,10,25,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1993,3,6,14,59,59],[1993,3,7,1,59,59],
          '1992102415:30:00','1992102502:30:00','1993030614:59:59','1993030701:59:59' ],
     ],
   1993 =>
     [
        [ [1993,3,6,15,0,0],[1993,3,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1993,10,30,15,29,59],[1993,10,31,1,59,59],
          '1993030615:00:00','1993030701:30:00','1993103015:29:59','1993103101:59:59' ],
        [ [1993,10,30,15,30,0],[1993,10,31,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1994,3,5,14,59,59],[1994,3,6,1,59,59],
          '1993103015:30:00','1993103102:30:00','1994030514:59:59','1994030601:59:59' ],
     ],
   1994 =>
     [
        [ [1994,3,5,15,0,0],[1994,3,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1994,10,29,15,29,59],[1994,10,30,1,59,59],
          '1994030515:00:00','1994030601:30:00','1994102915:29:59','1994103001:59:59' ],
        [ [1994,10,29,15,30,0],[1994,10,30,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1995,3,4,14,59,59],[1995,3,5,1,59,59],
          '1994102915:30:00','1994103002:30:00','1995030414:59:59','1995030501:59:59' ],
     ],
   1995 =>
     [
        [ [1995,3,4,15,0,0],[1995,3,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1995,10,28,15,29,59],[1995,10,29,1,59,59],
          '1995030415:00:00','1995030501:30:00','1995102815:29:59','1995102901:59:59' ],
        [ [1995,10,28,15,30,0],[1995,10,29,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1996,3,30,14,59,59],[1996,3,31,1,59,59],
          '1995102815:30:00','1995102902:30:00','1996033014:59:59','1996033101:59:59' ],
     ],
   1996 =>
     [
        [ [1996,3,30,15,0,0],[1996,3,31,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1996,10,26,15,29,59],[1996,10,27,1,59,59],
          '1996033015:00:00','1996033101:30:00','1996102615:29:59','1996102701:59:59' ],
        [ [1996,10,26,15,30,0],[1996,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1997,3,29,14,59,59],[1997,3,30,1,59,59],
          '1996102615:30:00','1996102702:30:00','1997032914:59:59','1997033001:59:59' ],
     ],
   1997 =>
     [
        [ [1997,3,29,15,0,0],[1997,3,30,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1997,10,25,15,29,59],[1997,10,26,1,59,59],
          '1997032915:00:00','1997033001:30:00','1997102515:29:59','1997102601:59:59' ],
        [ [1997,10,25,15,30,0],[1997,10,26,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1998,3,28,14,59,59],[1998,3,29,1,59,59],
          '1997102515:30:00','1997102602:30:00','1998032814:59:59','1998032901:59:59' ],
     ],
   1998 =>
     [
        [ [1998,3,28,15,0,0],[1998,3,29,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1998,10,24,15,29,59],[1998,10,25,1,59,59],
          '1998032815:00:00','1998032901:30:00','1998102415:29:59','1998102501:59:59' ],
        [ [1998,10,24,15,30,0],[1998,10,25,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[1999,3,27,14,59,59],[1999,3,28,1,59,59],
          '1998102415:30:00','1998102502:30:00','1999032714:59:59','1999032801:59:59' ],
     ],
   1999 =>
     [
        [ [1999,3,27,15,0,0],[1999,3,28,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[1999,10,30,15,29,59],[1999,10,31,1,59,59],
          '1999032715:00:00','1999032801:30:00','1999103015:29:59','1999103101:59:59' ],
        [ [1999,10,30,15,30,0],[1999,10,31,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2000,3,25,14,59,59],[2000,3,26,1,59,59],
          '1999103015:30:00','1999103102:30:00','2000032514:59:59','2000032601:59:59' ],
     ],
   2000 =>
     [
        [ [2000,3,25,15,0,0],[2000,3,26,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2000,8,26,15,29,59],[2000,8,27,1,59,59],
          '2000032515:00:00','2000032601:30:00','2000082615:29:59','2000082701:59:59' ],
        [ [2000,8,26,15,30,0],[2000,8,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2001,3,24,14,59,59],[2001,3,25,1,59,59],
          '2000082615:30:00','2000082702:30:00','2001032414:59:59','2001032501:59:59' ],
     ],
   2001 =>
     [
        [ [2001,3,24,15,0,0],[2001,3,25,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2001,10,27,15,29,59],[2001,10,28,1,59,59],
          '2001032415:00:00','2001032501:30:00','2001102715:29:59','2001102801:59:59' ],
        [ [2001,10,27,15,30,0],[2001,10,28,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2002,3,30,14,59,59],[2002,3,31,1,59,59],
          '2001102715:30:00','2001102802:30:00','2002033014:59:59','2002033101:59:59' ],
     ],
   2002 =>
     [
        [ [2002,3,30,15,0,0],[2002,3,31,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2002,10,26,15,29,59],[2002,10,27,1,59,59],
          '2002033015:00:00','2002033101:30:00','2002102615:29:59','2002102701:59:59' ],
        [ [2002,10,26,15,30,0],[2002,10,27,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2003,3,29,14,59,59],[2003,3,30,1,59,59],
          '2002102615:30:00','2002102702:30:00','2003032914:59:59','2003033001:59:59' ],
     ],
   2003 =>
     [
        [ [2003,3,29,15,0,0],[2003,3,30,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2003,10,25,15,29,59],[2003,10,26,1,59,59],
          '2003032915:00:00','2003033001:30:00','2003102515:29:59','2003102601:59:59' ],
        [ [2003,10,25,15,30,0],[2003,10,26,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2004,3,27,14,59,59],[2004,3,28,1,59,59],
          '2003102515:30:00','2003102602:30:00','2004032714:59:59','2004032801:59:59' ],
     ],
   2004 =>
     [
        [ [2004,3,27,15,0,0],[2004,3,28,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2004,10,30,15,29,59],[2004,10,31,1,59,59],
          '2004032715:00:00','2004032801:30:00','2004103015:29:59','2004103101:59:59' ],
        [ [2004,10,30,15,30,0],[2004,10,31,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2005,3,26,14,59,59],[2005,3,27,1,59,59],
          '2004103015:30:00','2004103102:30:00','2005032614:59:59','2005032701:59:59' ],
     ],
   2005 =>
     [
        [ [2005,3,26,15,0,0],[2005,3,27,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2005,10,29,15,29,59],[2005,10,30,1,59,59],
          '2005032615:00:00','2005032701:30:00','2005102915:29:59','2005103001:59:59' ],
        [ [2005,10,29,15,30,0],[2005,10,30,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2006,4,1,14,59,59],[2006,4,2,1,59,59],
          '2005102915:30:00','2005103002:30:00','2006040114:59:59','2006040201:59:59' ],
     ],
   2006 =>
     [
        [ [2006,4,1,15,0,0],[2006,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2006,10,28,15,29,59],[2006,10,29,1,59,59],
          '2006040115:00:00','2006040201:30:00','2006102815:29:59','2006102901:59:59' ],
        [ [2006,10,28,15,30,0],[2006,10,29,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2007,3,24,14,59,59],[2007,3,25,1,59,59],
          '2006102815:30:00','2006102902:30:00','2007032414:59:59','2007032501:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,24,15,0,0],[2007,3,25,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2007,10,27,15,29,59],[2007,10,28,1,59,59],
          '2007032415:00:00','2007032501:30:00','2007102715:29:59','2007102801:59:59' ],
        [ [2007,10,27,15,30,0],[2007,10,28,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2008,4,5,14,59,59],[2008,4,6,1,59,59],
          '2007102715:30:00','2007102802:30:00','2008040514:59:59','2008040601:59:59' ],
     ],
   2008 =>
     [
        [ [2008,4,5,15,0,0],[2008,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2008,10,4,15,29,59],[2008,10,5,1,59,59],
          '2008040515:00:00','2008040601:30:00','2008100415:29:59','2008100501:59:59' ],
        [ [2008,10,4,15,30,0],[2008,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2009,4,4,14,59,59],[2009,4,5,1,59,59],
          '2008100415:30:00','2008100502:30:00','2009040414:59:59','2009040501:59:59' ],
     ],
   2009 =>
     [
        [ [2009,4,4,15,0,0],[2009,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2009,10,3,15,29,59],[2009,10,4,1,59,59],
          '2009040415:00:00','2009040501:30:00','2009100315:29:59','2009100401:59:59' ],
        [ [2009,10,3,15,30,0],[2009,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2010,4,3,14,59,59],[2010,4,4,1,59,59],
          '2009100315:30:00','2009100402:30:00','2010040314:59:59','2010040401:59:59' ],
     ],
   2010 =>
     [
        [ [2010,4,3,15,0,0],[2010,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2010,10,2,15,29,59],[2010,10,3,1,59,59],
          '2010040315:00:00','2010040401:30:00','2010100215:29:59','2010100301:59:59' ],
        [ [2010,10,2,15,30,0],[2010,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2011,4,2,14,59,59],[2011,4,3,1,59,59],
          '2010100215:30:00','2010100302:30:00','2011040214:59:59','2011040301:59:59' ],
     ],
   2011 =>
     [
        [ [2011,4,2,15,0,0],[2011,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2011,10,1,15,29,59],[2011,10,2,1,59,59],
          '2011040215:00:00','2011040301:30:00','2011100115:29:59','2011100201:59:59' ],
        [ [2011,10,1,15,30,0],[2011,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2012,3,31,14,59,59],[2012,4,1,1,59,59],
          '2011100115:30:00','2011100202:30:00','2012033114:59:59','2012040101:59:59' ],
     ],
   2012 =>
     [
        [ [2012,3,31,15,0,0],[2012,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2012,10,6,15,29,59],[2012,10,7,1,59,59],
          '2012033115:00:00','2012040101:30:00','2012100615:29:59','2012100701:59:59' ],
        [ [2012,10,6,15,30,0],[2012,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2013,4,6,14,59,59],[2013,4,7,1,59,59],
          '2012100615:30:00','2012100702:30:00','2013040614:59:59','2013040701:59:59' ],
     ],
   2013 =>
     [
        [ [2013,4,6,15,0,0],[2013,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2013,10,5,15,29,59],[2013,10,6,1,59,59],
          '2013040615:00:00','2013040701:30:00','2013100515:29:59','2013100601:59:59' ],
        [ [2013,10,5,15,30,0],[2013,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2014,4,5,14,59,59],[2014,4,6,1,59,59],
          '2013100515:30:00','2013100602:30:00','2014040514:59:59','2014040601:59:59' ],
     ],
   2014 =>
     [
        [ [2014,4,5,15,0,0],[2014,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2014,10,4,15,29,59],[2014,10,5,1,59,59],
          '2014040515:00:00','2014040601:30:00','2014100415:29:59','2014100501:59:59' ],
        [ [2014,10,4,15,30,0],[2014,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2015,4,4,14,59,59],[2015,4,5,1,59,59],
          '2014100415:30:00','2014100502:30:00','2015040414:59:59','2015040501:59:59' ],
     ],
   2015 =>
     [
        [ [2015,4,4,15,0,0],[2015,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2015,10,3,15,29,59],[2015,10,4,1,59,59],
          '2015040415:00:00','2015040501:30:00','2015100315:29:59','2015100401:59:59' ],
        [ [2015,10,3,15,30,0],[2015,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2016,4,2,14,59,59],[2016,4,3,1,59,59],
          '2015100315:30:00','2015100402:30:00','2016040214:59:59','2016040301:59:59' ],
     ],
   2016 =>
     [
        [ [2016,4,2,15,0,0],[2016,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2016,10,1,15,29,59],[2016,10,2,1,59,59],
          '2016040215:00:00','2016040301:30:00','2016100115:29:59','2016100201:59:59' ],
        [ [2016,10,1,15,30,0],[2016,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2017,4,1,14,59,59],[2017,4,2,1,59,59],
          '2016100115:30:00','2016100202:30:00','2017040114:59:59','2017040201:59:59' ],
     ],
   2017 =>
     [
        [ [2017,4,1,15,0,0],[2017,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2017,9,30,15,29,59],[2017,10,1,1,59,59],
          '2017040115:00:00','2017040201:30:00','2017093015:29:59','2017100101:59:59' ],
        [ [2017,9,30,15,30,0],[2017,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2018,3,31,14,59,59],[2018,4,1,1,59,59],
          '2017093015:30:00','2017100102:30:00','2018033114:59:59','2018040101:59:59' ],
     ],
   2018 =>
     [
        [ [2018,3,31,15,0,0],[2018,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2018,10,6,15,29,59],[2018,10,7,1,59,59],
          '2018033115:00:00','2018040101:30:00','2018100615:29:59','2018100701:59:59' ],
        [ [2018,10,6,15,30,0],[2018,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2019,4,6,14,59,59],[2019,4,7,1,59,59],
          '2018100615:30:00','2018100702:30:00','2019040614:59:59','2019040701:59:59' ],
     ],
   2019 =>
     [
        [ [2019,4,6,15,0,0],[2019,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2019,10,5,15,29,59],[2019,10,6,1,59,59],
          '2019040615:00:00','2019040701:30:00','2019100515:29:59','2019100601:59:59' ],
        [ [2019,10,5,15,30,0],[2019,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2020,4,4,14,59,59],[2020,4,5,1,59,59],
          '2019100515:30:00','2019100602:30:00','2020040414:59:59','2020040501:59:59' ],
     ],
   2020 =>
     [
        [ [2020,4,4,15,0,0],[2020,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2020,10,3,15,29,59],[2020,10,4,1,59,59],
          '2020040415:00:00','2020040501:30:00','2020100315:29:59','2020100401:59:59' ],
        [ [2020,10,3,15,30,0],[2020,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2021,4,3,14,59,59],[2021,4,4,1,59,59],
          '2020100315:30:00','2020100402:30:00','2021040314:59:59','2021040401:59:59' ],
     ],
   2021 =>
     [
        [ [2021,4,3,15,0,0],[2021,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2021,10,2,15,29,59],[2021,10,3,1,59,59],
          '2021040315:00:00','2021040401:30:00','2021100215:29:59','2021100301:59:59' ],
        [ [2021,10,2,15,30,0],[2021,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2022,4,2,14,59,59],[2022,4,3,1,59,59],
          '2021100215:30:00','2021100302:30:00','2022040214:59:59','2022040301:59:59' ],
     ],
   2022 =>
     [
        [ [2022,4,2,15,0,0],[2022,4,3,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2022,10,1,15,29,59],[2022,10,2,1,59,59],
          '2022040215:00:00','2022040301:30:00','2022100115:29:59','2022100201:59:59' ],
        [ [2022,10,1,15,30,0],[2022,10,2,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2023,4,1,14,59,59],[2023,4,2,1,59,59],
          '2022100115:30:00','2022100202:30:00','2023040114:59:59','2023040201:59:59' ],
     ],
   2023 =>
     [
        [ [2023,4,1,15,0,0],[2023,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2023,9,30,15,29,59],[2023,10,1,1,59,59],
          '2023040115:00:00','2023040201:30:00','2023093015:29:59','2023100101:59:59' ],
        [ [2023,9,30,15,30,0],[2023,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2024,4,6,14,59,59],[2024,4,7,1,59,59],
          '2023093015:30:00','2023100102:30:00','2024040614:59:59','2024040701:59:59' ],
     ],
   2024 =>
     [
        [ [2024,4,6,15,0,0],[2024,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2024,10,5,15,29,59],[2024,10,6,1,59,59],
          '2024040615:00:00','2024040701:30:00','2024100515:29:59','2024100601:59:59' ],
        [ [2024,10,5,15,30,0],[2024,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2025,4,5,14,59,59],[2025,4,6,1,59,59],
          '2024100515:30:00','2024100602:30:00','2025040514:59:59','2025040601:59:59' ],
     ],
   2025 =>
     [
        [ [2025,4,5,15,0,0],[2025,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2025,10,4,15,29,59],[2025,10,5,1,59,59],
          '2025040515:00:00','2025040601:30:00','2025100415:29:59','2025100501:59:59' ],
        [ [2025,10,4,15,30,0],[2025,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2026,4,4,14,59,59],[2026,4,5,1,59,59],
          '2025100415:30:00','2025100502:30:00','2026040414:59:59','2026040501:59:59' ],
     ],
   2026 =>
     [
        [ [2026,4,4,15,0,0],[2026,4,5,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2026,10,3,15,29,59],[2026,10,4,1,59,59],
          '2026040415:00:00','2026040501:30:00','2026100315:29:59','2026100401:59:59' ],
        [ [2026,10,3,15,30,0],[2026,10,4,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2027,4,3,14,59,59],[2027,4,4,1,59,59],
          '2026100315:30:00','2026100402:30:00','2027040314:59:59','2027040401:59:59' ],
     ],
   2027 =>
     [
        [ [2027,4,3,15,0,0],[2027,4,4,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2027,10,2,15,29,59],[2027,10,3,1,59,59],
          '2027040315:00:00','2027040401:30:00','2027100215:29:59','2027100301:59:59' ],
        [ [2027,10,2,15,30,0],[2027,10,3,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2028,4,1,14,59,59],[2028,4,2,1,59,59],
          '2027100215:30:00','2027100302:30:00','2028040114:59:59','2028040201:59:59' ],
     ],
   2028 =>
     [
        [ [2028,4,1,15,0,0],[2028,4,2,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2028,9,30,15,29,59],[2028,10,1,1,59,59],
          '2028040115:00:00','2028040201:30:00','2028093015:29:59','2028100101:59:59' ],
        [ [2028,9,30,15,30,0],[2028,10,1,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2029,3,31,14,59,59],[2029,4,1,1,59,59],
          '2028093015:30:00','2028100102:30:00','2029033114:59:59','2029040101:59:59' ],
     ],
   2029 =>
     [
        [ [2029,3,31,15,0,0],[2029,4,1,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2029,10,6,15,29,59],[2029,10,7,1,59,59],
          '2029033115:00:00','2029040101:30:00','2029100615:29:59','2029100701:59:59' ],
        [ [2029,10,6,15,30,0],[2029,10,7,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2030,4,6,14,59,59],[2030,4,7,1,59,59],
          '2029100615:30:00','2029100702:30:00','2030040614:59:59','2030040701:59:59' ],
     ],
   2030 =>
     [
        [ [2030,4,6,15,0,0],[2030,4,7,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2030,10,5,15,29,59],[2030,10,6,1,59,59],
          '2030040615:00:00','2030040701:30:00','2030100515:29:59','2030100601:59:59' ],
        [ [2030,10,5,15,30,0],[2030,10,6,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2031,4,5,14,59,59],[2031,4,6,1,59,59],
          '2030100515:30:00','2030100602:30:00','2031040514:59:59','2031040601:59:59' ],
     ],
   2031 =>
     [
        [ [2031,4,5,15,0,0],[2031,4,6,1,30,0],'+10:30:00',[10,30,0],
          'LHST',0,[2031,10,4,15,29,59],[2031,10,5,1,59,59],
          '2031040515:00:00','2031040601:30:00','2031100415:29:59','2031100501:59:59' ],
        [ [2031,10,4,15,30,0],[2031,10,5,2,30,0],'+11:00:00',[11,0,0],
          'LHST',1,[2032,4,3,14,59,59],[2032,4,4,1,59,59],
          '2031100415:30:00','2031100502:30:00','2032040314:59:59','2032040401:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+11:00:00',
                'stdoff' => '+10:30:00',
               },
   'rules'  => {
                '04' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '0',
                         'abb'     => 'LHST',
                        },
                '10' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'LHST',
                        },
               },
);

1;
