use strict;
use Test::More tests => 1458;
use RTF::Tokenizer;

my $DEBUG  = 0;
my @tokens = (
    [ 'group',   '1',                       '' ],
    [ 'control', 'stylesheet',              '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', 'ql',                      '' ],
    [ 'control', 'li',                      '0' ],
    [ 'control', 'ri',                      '0' ],
    [ 'control', 'widctlpar',               '' ],
    [ 'control', 'aspalpha',                '' ],
    [ 'control', 'aspnum',                  '' ],
    [ 'control', 'faauto',                  '' ],
    [ 'control', 'adjustright',             '' ],
    [ 'control', 'rin',                     '0' ],
    [ 'control', 'lin',                     '0' ],
    [ 'control', 'itap',                    '0' ],
    [ 'control', 'fs',                      '24' ],
    [ 'control', 'lang',                    '1033' ],
    [ 'control', 'langfe',                  '1033' ],
    [ 'control', 'cgrid',                   '' ],
    [ 'control', 'langnp',                  '1033' ],
    [ 'control', 'langfenp',                '1033' ],
    [ 'control', 'snext',                   '0' ],
    [ 'text',    'Normal;',                 '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'cs',                      '10' ],
    [ 'control', 'additive',                '' ],
    [ 'control', 'ssemihidden',             '' ],
    [ 'text',    'Default Paragraph Font;', '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '11' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'trftsWidthB',             '3' ],
    [ 'control', 'trpaddl',                 '108' ],
    [ 'control', 'trpaddr',                 '108' ],
    [ 'control', 'trpaddfl',                '3' ],
    [ 'control', 'trpaddft',                '3' ],
    [ 'control', 'trpaddfb',                '3' ],
    [ 'control', 'trpaddfr',                '3' ],
    [ 'control', 'tscellwidthfts',          '0' ],
    [ 'control', 'tsvertalt',               '' ],
    [ 'control', 'tsbrdrt',                 '' ],
    [ 'control', 'tsbrdrl',                 '' ],
    [ 'control', 'tsbrdrb',                 '' ],
    [ 'control', 'tsbrdrr',                 '' ],
    [ 'control', 'tsbrdrdgl',               '' ],
    [ 'control', 'tsbrdrdgr',               '' ],
    [ 'control', 'tsbrdrh',                 '' ],
    [ 'control', 'tsbrdrv',                 '' ],
    [ 'control', 'ql',                      '' ],
    [ 'control', 'li',                      '0' ],
    [ 'control', 'ri',                      '0' ],
    [ 'control', 'widctlpar',               '' ],
    [ 'control', 'aspalpha',                '' ],
    [ 'control', 'aspnum',                  '' ],
    [ 'control', 'faauto',                  '' ],
    [ 'control', 'adjustright',             '' ],
    [ 'control', 'rin',                     '0' ],
    [ 'control', 'lin',                     '0' ],
    [ 'control', 'itap',                    '0' ],
    [ 'control', 'fs',                      '20' ],
    [ 'control', 'lang',                    '1024' ],
    [ 'control', 'langfe',                  '1024' ],
    [ 'control', 'cgrid',                   '' ],
    [ 'control', 'langnp',                  '1024' ],
    [ 'control', 'langfenp',                '1024' ],
    [ 'control', 'snext',                   '11' ],
    [ 'control', 'ssemihidden',             '' ],
    [ 'text',    'Normal Table;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '15' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'trbrdrt',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrl',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrb',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrr',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrh',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrv',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trftsWidthB',             '3' ],
    [ 'control', 'trpaddl',                 '108' ],
    [ 'control', 'trpaddr',                 '108' ],
    [ 'control', 'trpaddfl',                '3' ],
    [ 'control', 'trpaddft',                '3' ],
    [ 'control', 'trpaddfb',                '3' ],
    [ 'control', 'trpaddfr',                '3' ],
    [ 'control', 'tscellwidthfts',          '0' ],
    [ 'control', 'tsvertalt',               '' ],
    [ 'control', 'tsbrdrt',                 '' ],
    [ 'control', 'tsbrdrl',                 '' ],
    [ 'control', 'tsbrdrb',                 '' ],
    [ 'control', 'tsbrdrr',                 '' ],
    [ 'control', 'tsbrdrdgl',               '' ],
    [ 'control', 'tsbrdrdgr',               '' ],
    [ 'control', 'tsbrdrh',                 '' ],
    [ 'control', 'tsbrdrv',                 '' ],
    [ 'control', 'ql',                      '' ],
    [ 'control', 'li',                      '0' ],
    [ 'control', 'ri',                      '0' ],
    [ 'control', 'widctlpar',               '' ],
    [ 'control', 'aspalpha',                '' ],
    [ 'control', 'aspnum',                  '' ],
    [ 'control', 'faauto',                  '' ],
    [ 'control', 'adjustright',             '' ],
    [ 'control', 'rin',                     '0' ],
    [ 'control', 'lin',                     '0' ],
    [ 'control', 'itap',                    '0' ],
    [ 'control', 'fs',                      '20' ],
    [ 'control', 'lang',                    '1024' ],
    [ 'control', 'langfe',                  '1024' ],
    [ 'control', 'cgrid',                   '' ],
    [ 'control', 'langnp',                  '1024' ],
    [ 'control', 'langfenp',                '1024' ],
    [ 'control', 'sbasedon',                '11' ],
    [ 'control', 'snext',                   '15' ],
    [ 'control', 'styrsid',                 '353782' ],
    [ 'text',    'Table Grid;',             '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '16' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'trbrdrt',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '15' ],
    [ 'control', 'brdrcf',                  '1' ],
    [ 'control', 'trbrdrl',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '15' ],
    [ 'control', 'brdrcf',                  '1' ],
    [ 'control', 'trbrdrb',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '15' ],
    [ 'control', 'brdrcf',                  '1' ],
    [ 'control', 'trbrdrr',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '15' ],
    [ 'control', 'brdrcf',                  '1' ],
    [ 'control', 'trbrdrv',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '15' ],
    [ 'control', 'brdrcf',                  '1' ],
    [ 'control', 'trftsWidthB',             '3' ],
    [ 'control', 'trpaddl',                 '108' ],
    [ 'control', 'trpaddr',                 '108' ],
    [ 'control', 'trpaddfl',                '3' ],
    [ 'control', 'trpaddft',                '3' ],
    [ 'control', 'trpaddfb',                '3' ],
    [ 'control', 'trpaddfr',                '3' ],
    [ 'control', 'tscbandsh',               '1' ],
    [ 'control', 'tscellwidthfts',          '0' ],
    [ 'control', 'tsvertalt',               '' ],
    [ 'control', 'tsbrdrt',                 '' ],
    [ 'control', 'tsbrdrl',                 '' ],
    [ 'control', 'tsbrdrb',                 '' ],
    [ 'control', 'tsbrdrr',                 '' ],
    [ 'control', 'tsbrdrdgl',               '' ],
    [ 'control', 'tsbrdrdgr',               '' ],
    [ 'control', 'tsbrdrh',                 '' ],
    [ 'control', 'tsbrdrv',                 '' ],
    [ 'control', 'ql',                      '' ],
    [ 'control', 'li',                      '0' ],
    [ 'control', 'ri',                      '0' ],
    [ 'control', 'widctlpar',               '' ],
    [ 'control', 'aspalpha',                '' ],
    [ 'control', 'aspnum',                  '' ],
    [ 'control', 'faauto',                  '' ],
    [ 'control', 'adjustright',             '' ],
    [ 'control', 'rin',                     '0' ],
    [ 'control', 'lin',                     '0' ],
    [ 'control', 'itap',                    '0' ],
    [ 'control', 'fs',                      '20' ],
    [ 'control', 'lang',                    '1024' ],
    [ 'control', 'langfe',                  '1024' ],
    [ 'control', 'cgrid',                   '' ],
    [ 'control', 'langnp',                  '1024' ],
    [ 'control', 'langfenp',                '1024' ],
    [ 'control', 'sbasedon',                '11' ],
    [ 'control', 'snext',                   '16' ],
    [ 'control', 'styrsid',                 '353782' ],
    [ 'text',    'Table List 8;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '16' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'tscellcfpat',             '7' ],
    [ 'control', 'tscellcbpat',             '8' ],
    [ 'control', 'tscellpct',               '10000' ],
    [ 'control', 'tsbrdrb',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '15' ],
    [ 'control', 'brdrcf',                  '1' ],
    [ 'control', 'tsbrdrdgl',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'tsbrdrdgr',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'b',                       '' ],
    [ 'control', 'i',                       '' ],
    [ 'control', 'tscfirstrow',             '' ],
    [ 'text',    'Table List 8;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '16' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'tsbrdrt',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '15' ],
    [ 'control', 'brdrcf',                  '1' ],
    [ 'control', 'tsbrdrdgl',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'tsbrdrdgr',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'b',                       '' ],
    [ 'control', 'tsclastrow',              '' ],
    [ 'text',    'Table List 8;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '16' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'tsbrdrdgl',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'tsbrdrdgr',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'b',                       '' ],
    [ 'control', 'tscfirstcol',             '' ],
    [ 'text',    'Table List 8;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '16' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'tsbrdrdgl',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'tsbrdrdgr',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'b',                       '' ],
    [ 'control', 'tsclastcol',              '' ],
    [ 'text',    'Table List 8;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '16' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'tscellcfpat',             '7' ],
    [ 'control', 'tscellcbpat',             '8' ],
    [ 'control', 'tscellpct',               '2500' ],
    [ 'control', 'tsbrdrdgl',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'tsbrdrdgr',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'cf',                      '0' ],
    [ 'control', 'tscbandhorzodd',          '' ],
    [ 'text',    'Table List 8;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '16' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'tscellcfpat',             '6' ],
    [ 'control', 'tscellcbpat',             '8' ],
    [ 'control', 'tscellpct',               '5000' ],
    [ 'control', 'tsbrdrdgl',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'tsbrdrdgr',               '' ],
    [ 'control', 'brdrnil',                 '' ],
    [ 'control', 'tscbandhorzeven',         '' ],
    [ 'text',    'Table List 8;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '17' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'trbrdrt',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrl',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrb',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrr',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrh',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrv',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trftsWidthB',             '3' ],
    [ 'control', 'trpaddl',                 '108' ],
    [ 'control', 'trpaddr',                 '108' ],
    [ 'control', 'trpaddfl',                '3' ],
    [ 'control', 'trpaddft',                '3' ],
    [ 'control', 'trpaddfb',                '3' ],
    [ 'control', 'trpaddfr',                '3' ],
    [ 'control', 'tscbandsh',               '1' ],
    [ 'control', 'tscellwidthfts',          '0' ],
    [ 'control', 'tsvertalc',               '' ],
    [ 'control', 'tsbrdrt',                 '' ],
    [ 'control', 'tsbrdrl',                 '' ],
    [ 'control', 'tsbrdrb',                 '' ],
    [ 'control', 'tsbrdrr',                 '' ],
    [ 'control', 'tsbrdrdgl',               '' ],
    [ 'control', 'tsbrdrdgr',               '' ],
    [ 'control', 'tsbrdrh',                 '' ],
    [ 'control', 'tsbrdrv',                 '' ],
    [ 'control', 'qr',                      '' ],
    [ 'control', 'li',                      '0' ],
    [ 'control', 'ri',                      '0' ],
    [ 'control', 'widctlpar',               '' ],
    [ 'control', 'aspalpha',                '' ],
    [ 'control', 'aspnum',                  '' ],
    [ 'control', 'faauto',                  '' ],
    [ 'control', 'adjustright',             '' ],
    [ 'control', 'rin',                     '0' ],
    [ 'control', 'lin',                     '0' ],
    [ 'control', 'itap',                    '0' ],
    [ 'control', 'fs',                      '20' ],
    [ 'control', 'lang',                    '1024' ],
    [ 'control', 'langfe',                  '1024' ],
    [ 'control', 'cgrid',                   '' ],
    [ 'control', 'langnp',                  '1024' ],
    [ 'control', 'langfenp',                '1024' ],
    [ 'control', 'sbasedon',                '15' ],
    [ 'control', 'snext',                   '17' ],
    [ 'control', 'styrsid',                 '353782' ],
    [ 'text',    'Table Style1;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '17' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'tsvertalc',               '' ],
    [ 'control', 'tscellcfpat',             '0' ],
    [ 'control', 'tscellcbpat',             '17' ],
    [ 'control', 'tscellpct',               '0' ],
    [ 'control', 'qc',                      '' ],
    [ 'control', 'f',                       '36' ],
    [ 'control', 'fs',                      '22' ],
    [ 'control', 'tscfirstrow',             '' ],
    [ 'text',    'Table Style1;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '17' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'tsvertalt',               '' ],
    [ 'control', 'qr',                      '' ],
    [ 'control', 'tsclastrow',              '' ],
    [ 'text',    'Table Style1;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '17' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'ql',                      '' ],
    [ 'control', 'f',                       '36' ],
    [ 'control', 'fs',                      '18' ],
    [ 'control', 'tscfirstcol',             '' ],
    [ 'text',    'Table Style1;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '17' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'tscellcfpat',             '0' ],
    [ 'control', 'tscellcbpat',             '18' ],
    [ 'control', 'tscellpct',               '0' ],
    [ 'control', 'tscbandhorzodd',          '' ],
    [ 'text',    'Table Style1;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '17' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'b',                       '' ],
    [ 'control', 'f',                       '36' ],
    [ 'control', 'fs',                      '20' ],
    [ 'control', 'tscsecell',               '' ],
    [ 'text',    'Table Style1;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '18' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'trbrdrt',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrl',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrb',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrr',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrh',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trbrdrv',                 '' ],
    [ 'control', 'brdrs',                   '' ],
    [ 'control', 'brdrw',                   '10' ],
    [ 'control', 'trftsWidthB',             '3' ],
    [ 'control', 'trpaddl',                 '108' ],
    [ 'control', 'trpaddr',                 '108' ],
    [ 'control', 'trpaddfl',                '3' ],
    [ 'control', 'trpaddft',                '3' ],
    [ 'control', 'trpaddfb',                '3' ],
    [ 'control', 'trpaddfr',                '3' ],
    [ 'control', 'tscbandsh',               '1' ],
    [ 'control', 'tscellwidthfts',          '0' ],
    [ 'control', 'tsvertalt',               '' ],
    [ 'control', 'tsbrdrt',                 '' ],
    [ 'control', 'tsbrdrl',                 '' ],
    [ 'control', 'tsbrdrb',                 '' ],
    [ 'control', 'tsbrdrr',                 '' ],
    [ 'control', 'tsbrdrdgl',               '' ],
    [ 'control', 'tsbrdrdgr',               '' ],
    [ 'control', 'tsbrdrh',                 '' ],
    [ 'control', 'tsbrdrv',                 '' ],
    [ 'control', 'ql',                      '' ],
    [ 'control', 'li',                      '0' ],
    [ 'control', 'ri',                      '0' ],
    [ 'control', 'widctlpar',               '' ],
    [ 'control', 'aspalpha',                '' ],
    [ 'control', 'aspnum',                  '' ],
    [ 'control', 'faauto',                  '' ],
    [ 'control', 'adjustright',             '' ],
    [ 'control', 'rin',                     '0' ],
    [ 'control', 'lin',                     '0' ],
    [ 'control', 'itap',                    '0' ],
    [ 'control', 'fs',                      '20' ],
    [ 'control', 'lang',                    '1024' ],
    [ 'control', 'langfe',                  '1024' ],
    [ 'control', 'cgrid',                   '' ],
    [ 'control', 'langnp',                  '1024' ],
    [ 'control', 'langfenp',                '1024' ],
    [ 'control', 'sbasedon',                '15' ],
    [ 'control', 'snext',                   '18' ],
    [ 'control', 'styrsid',                 '353782' ],
    [ 'text',    'Table Style2;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '18' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'tscellcfpat',             '0' ],
    [ 'control', 'tscellcbpat',             '17' ],
    [ 'control', 'tscellpct',               '0' ],
    [ 'control', 'b',                       '' ],
    [ 'control', 'tscfirstrow',             '' ],
    [ 'text',    'Table Style2;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '1',                       '' ],
    [ 'control', '*',                       '' ],
    [ 'control', 'ts',                      '18' ],
    [ 'control', 'tsrowd',                  '' ],
    [ 'control', 'tscellcfpat',             '0' ],
    [ 'control', 'tscellcbpat',             '18' ],
    [ 'control', 'tscellpct',               '0' ],
    [ 'control', 'tscbandhorzeven',         '' ],
    [ 'text',    'Table Style2;',           '' ],
    [ 'group',   '0',                       '' ],
    [ 'group',   '0',                       '' ],
    [ 'eof',     '1',                       '0' ], );

my $tokenizer = RTF::Tokenizer->new();

# Reading from DATA with read_file() causes all kinds of oddness
$tokenizer->read_string( join '', <DATA> );

if ($DEBUG) {
    while (1) {
        my ( $type, $argument, $param ) = $tokenizer->get_token();
        print "['$type', '$argument', '$param'],\n";
        exit if $type eq 'eof';
    }
} else {

    for (@tokens) {

        my ( $ret_type, $ret_argument, $ret_parameter ) = @{$_};
        my ( $type, $argument, $param ) = $tokenizer->get_token();

        is( $type,     $ret_type,      "Correctly found '$type'" );
        is( $argument, $ret_argument,  "Correctly found '$argument'" );
        is( $param,    $ret_parameter, "Correctly found '$param'" );

    }

}

__DATA__
{\stylesheet{\ql \li0\ri0\widctlpar\aspalpha\aspnum\faauto\adjustright\rin0\lin0\itap0 \fs24\lang1033\langfe1033\cgrid\langnp1033\langfenp1033 \snext0 Normal;}{\*\cs10 \additive \ssemihidden Default Paragraph Font;}{\*\ts11\tsrowd\trftsWidthB3\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscellwidthfts0\tsvertalt\tsbrdrt\tsbrdrl\tsbrdrb\tsbrdrr\tsbrdrdgl\tsbrdrdgr\tsbrdrh\tsbrdrv \ql \li0\ri0\widctlpar\aspalpha\aspnum\faauto\adjustright\rin0\lin0\itap0 \fs20\lang1024\langfe1024\cgrid\langnp1024\langfenp1024 \snext11 \ssemihidden Normal Table;}{\*\ts15\tsrowd\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidthB3\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscellwidthfts0\tsvertalt\tsbrdrt\tsbrdrl\tsbrdrb\tsbrdrr\tsbrdrdgl\tsbrdrdgr\tsbrdrh\tsbrdrv \ql \li0\ri0\widctlpar\aspalpha\aspnum\faauto\adjustright\rin0\lin0\itap0 \fs20\lang1024\langfe1024\cgrid\langnp1024\langfenp1024 \sbasedon11 \snext15 \styrsid353782 Table Grid;}{\*\ts16\tsrowd\trbrdrt\brdrs\brdrw15\brdrcf1 \trbrdrl\brdrs\brdrw15\brdrcf1 \trbrdrb\brdrs\brdrw15\brdrcf1 \trbrdrr\brdrs\brdrw15\brdrcf1 \trbrdrv\brdrs\brdrw15\brdrcf1 \trftsWidthB3\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tscellwidthfts0\tsvertalt\tsbrdrt\tsbrdrl\tsbrdrb\tsbrdrr\tsbrdrdgl\tsbrdrdgr\tsbrdrh\tsbrdrv \ql \li0\ri0\widctlpar\aspalpha\aspnum\faauto\adjustright\rin0\lin0\itap0 \fs20\lang1024\langfe1024\cgrid\langnp1024\langfenp1024 \sbasedon11 \snext16 \styrsid353782 Table List 8;}{\*\ts16\tsrowd\tscellcfpat7\tscellcbpat8\tscellpct10000\tsbrdrb\brdrs\brdrw15\brdrcf1 \tsbrdrdgl\brdrnil\tsbrdrdgr\brdrnil \b\i \tscfirstrow Table List 8;}{\*\ts16\tsrowd\tsbrdrt\brdrs\brdrw15\brdrcf1 \tsbrdrdgl\brdrnil\tsbrdrdgr\brdrnil \b \tsclastrow Table List 8;}{\*\ts16\tsrowd\tsbrdrdgl\brdrnil\tsbrdrdgr\brdrnil \b \tscfirstcol Table List 8;}{\*\ts16\tsrowd\tsbrdrdgl\brdrnil\tsbrdrdgr\brdrnil \b \tsclastcol Table List 8;}{\*\ts16\tsrowd\tscellcfpat7\tscellcbpat8\tscellpct2500\tsbrdrdgl\brdrnil\tsbrdrdgr\brdrnil \cf0 \tscbandhorzodd Table List 8;}{\*\ts16\tsrowd\tscellcfpat6\tscellcbpat8\tscellpct5000\tsbrdrdgl\brdrnil\tsbrdrdgr\brdrnil \tscbandhorzeven Table List 8;}{\*\ts17\tsrowd\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidthB3\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tscellwidthfts0\tsvertalc\tsbrdrt\tsbrdrl\tsbrdrb\tsbrdrr\tsbrdrdgl\tsbrdrdgr\tsbrdrh\tsbrdrv \qr \li0\ri0\widctlpar\aspalpha\aspnum\faauto\adjustright\rin0\lin0\itap0 \fs20\lang1024\langfe1024\cgrid\langnp1024\langfenp1024 \sbasedon15 \snext17 \styrsid353782 Table Style1;}{\*\ts17\tsrowd\tsvertalc\tscellcfpat0\tscellcbpat17\tscellpct0 \qc \f36\fs22 \tscfirstrow Table Style1;}{\*\ts17\tsrowd\tsvertalt \qr \tsclastrow Table Style1;}{\*\ts17\tsrowd \ql \f36\fs18 \tscfirstcol Table Style1;}{\*\ts17\tsrowd\tscellcfpat0\tscellcbpat18\tscellpct0 \tscbandhorzodd Table Style1;}{\*\ts17\tsrowd \b\f36\fs20 \tscsecell Table Style1;}{\*\ts18\tsrowd\trbrdrt\brdrs\brdrw10 \trbrdrl\brdrs\brdrw10 \trbrdrb\brdrs\brdrw10 \trbrdrr\brdrs\brdrw10 \trbrdrh\brdrs\brdrw10 \trbrdrv\brdrs\brdrw10 \trftsWidthB3\trpaddl108\trpaddr108\trpaddfl3\trpaddft3\trpaddfb3\trpaddfr3\tscbandsh1\tscellwidthfts0\tsvertalt\tsbrdrt\tsbrdrl\tsbrdrb\tsbrdrr\tsbrdrdgl\tsbrdrdgr\tsbrdrh\tsbrdrv \ql \li0\ri0\widctlpar\aspalpha\aspnum\faauto\adjustright\rin0\lin0\itap0 \fs20\lang1024\langfe1024\cgrid\langnp1024\langfenp1024 \sbasedon15 \snext18 \styrsid353782 Table Style2;}{\*\ts18\tsrowd\tscellcfpat0\tscellcbpat17\tscellpct0 \b \tscfirstrow Table Style2;}{\*\ts18\tsrowd\tscellcfpat0\tscellcbpat18\tscellpct0 \tscbandhorzeven Table Style2;}}
