use v5.26;
use strict;
use warnings;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
    NAME             => 'Blockchain::Ethereum::ABI',
    AUTHOR           => q{Reginaldo Costa <refeco@cpan.org>},
    VERSION_FROM     => 'lib/Blockchain/Ethereum/ABI.pm',
    ABSTRACT_FROM    => 'lib/Blockchain/Ethereum/ABI.pm',
    LICENSE          => 'mit',
    MIN_PERL_VERSION => 'v5.26',
    META_MERGE       => {
        'meta-spec' => {version => 2},
        resources   => {
            repository => {
                type => 'git',
                url  => 'https://github.com/refeco/perl-ABI.git',
                web  => 'https://github.com/refeco/perl-ABI',
            },
        },
    },
    CONFIGURE_REQUIRES => {
        'ExtUtils::MakeMaker' => '0',
    },
    TEST_REQUIRES => {
        'Test::Fatal' => '0.016',
    },
    PREREQ_PM => {
        'Object::Pad'    => '0.79',
        'Digest::Keccak' => '0.05',
    },
    dist => {
        COMPRESS => 'gzip -9f',
        SUFFIX   => 'gz',
    },
    clean => {FILES => 'Blockchain-Ethereum-ABI-*'},
);

WriteMakefile(%WriteMakefileArgs);
