#!/usr/bin/env perl

use strict;
use warnings;
use lib 'lib';
# Check if blib directories exist and add them to @INC if found
BEGIN {
   if (-d 'blib/lib') {
       unshift @INC, 'blib/lib';
   }
   if (-d 'blib/arch') {
       unshift @INC, 'blib/arch';
   }
}

use FASTX::Reader::XS;

my $file = $ARGV[0] || 't/test.fa';

my $parser = FASTX::Reader::XS->new($file);

my $seq_count = 0;
my $total_length = 0;

while (my $seq = $parser->next_seq()) {
    $seq_count++;
    $total_length += $seq->len;
}

print "Number of sequences: $seq_count\n";
print "Total length: $total_length\n";
