
use strict;
use warnings;

use 5.010000;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Yet Another RESTful-Archive Service",
  "AUTHOR" => "Graham Ollis <plicease\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Capture::Tiny" => 0,
    "Mojo::JSON" => 0,
    "Mojo::Loader" => 0,
    "Mojo::Server::Daemon" => 0,
    "Test::Clustericious::Cluster" => "0.08",
    "Test::Clustericious::Log" => 0,
    "Test::More" => 0,
    "YAML::XS" => 0
  },
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Yars",
  "EXE_FILES" => [
    "bin/yars",
    "bin/yars_disk_scan",
    "bin/yars_fast_balance",
    "bin/yars_generate_diskmap"
  ],
  "LICENSE" => "perl",
  "NAME" => "Yars",
  "PREREQ_PM" => {
    "Clustericious" => "0.9925",
    "Clustericious::Commands" => 0,
    "Clustericious::Config" => "0.21",
    "Clustericious::Log" => "0.11",
    "Digest::file" => 0,
    "Fcntl" => 0,
    "File::Find::Rule" => 0,
    "File::HomeDir" => "0.91",
    "File::Path" => 0,
    "Filesys::Df" => 0,
    "Getopt::Long" => 0,
    "Hash::MoreUtils" => 0,
    "JSON::XS" => 0,
    "List::MoreUtils" => 0,
    "Log::Log4perl" => 0,
    "Log::Log4perl::CommandLine" => 0,
    "Mojolicious" => "3.86",
    "Number::Bytes::Human" => "0.09",
    "Pod::Usage" => 0,
    "Smart::Comments" => 0,
    "Try::Tiny" => 0,
    "Yars::Client" => "0.90"
  },
  "VERSION" => "0.90_01",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



