#!/usr/bin/perl

use strict;

use Test::More tests => 15;

use Tickit::Test;

my ( $term, $rootwin ) = mk_term_and_window;

my $win = $rootwin->make_sub( 3, 10, 4, 20 );

my $root_exposed;
$rootwin->set_on_expose( sub { $root_exposed++ } );

my $win_exposed;
my @exposed_rects;
$win->set_on_expose( sub { shift; push @exposed_rects, $_[0]; $win_exposed++ } );

$rootwin->expose;

ok( !$win_exposed, 'on_expose not yet invoked' );

flush_tickit;

is( $root_exposed, 1, '$root expose count 1 after $rootwin->expose' );
is( $win_exposed,  1, '$win expose count 1 after $rootwin->expose' );

is_deeply( \@exposed_rects,
   [ Tickit::Rect->new( top => 0, left => 0, lines => 4, cols => 20 ) ],
   'Exposed regions after $rootwin->expose'
);

undef @exposed_rects;

$win->expose;

flush_tickit;

is( $root_exposed, 1, '$root expose count 1 after $win->expose' );
is( $win_exposed, 2, '$win expose count 2 after $win->expose' );

is_deeply( \@exposed_rects,
   [ Tickit::Rect->new( top => 0, left => 0, lines => 4, cols => 20 ) ],
   'Exposed regions after $win->expose'
);

undef @exposed_rects;

$rootwin->expose;
$win->expose;

flush_tickit;

is( $root_exposed, 2, '$root expose count 2 after root-then-win' );
is( $win_exposed, 3, '$win expose count 3 after root-then-win' );

$win->expose;
$rootwin->expose;

flush_tickit;

is( $root_exposed, 3, '$root expose count 3 after win-then-root' );
is( $win_exposed, 4, '$win expose count 4 after win-then-root' );

$win->hide;
$win->show;

flush_tickit;

is( $root_exposed, 3, '$root expose count 3 after hide+show' );
is( $win_exposed, 5, '$win expose count 5 after hide+show' );

undef @exposed_rects;

$win->expose( Tickit::Rect->new( top => 0, left => 0, lines => 1, cols => 20 ) );
$win->expose( Tickit::Rect->new( top => 2, left => 0, lines => 1, cols => 20 ) );

flush_tickit;

is( $win_exposed, 7, '$win expose count 7 after expose two regions' );

is_deeply( \@exposed_rects,
   [ Tickit::Rect->new( top => 0, left => 0, lines => 1, cols => 20 ),
     Tickit::Rect->new( top => 2, left => 0, lines => 1, cols => 20 ) ],
   'Exposed regions after expose two regions'
);
