package Bencher::Scenario::PerinciSubValidateArgs::Overhead;

our $DATE = '2016-05-24'; # DATE
our $VERSION = '0.003'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Measure validation overhead',
    participants => [
        {
            name => 'none',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'manual',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'manual+dsah',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'DZPRV',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingDZPRV::foo(a1=><a1>, a2=><a2>)',
            include_by_default => 0,
        },
        {
            name => 'DZPRW',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingDZPRW::foo_dzprw(a1=><a1>, a2=><a2>)',
            include_by_default => 0,
        },
        {
            name => 'PSW',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSW::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'PSV',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'Type::Tiny',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingTypeTiny::foo(a1=><a1>, a2=><a2>)',
        },
    ],
    datasets => [
        {args => {a1=>1, a2=>[1]}},
    ],
};

1;
# ABSTRACT: Measure validation overhead

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PerinciSubValidateArgs::Overhead - Measure validation overhead

=head1 VERSION

This document describes version 0.003 of Bencher::Scenario::PerinciSubValidateArgs::Overhead (from Perl distribution Bencher-Scenarios-PerinciSubValidateArgs), released on 2016-05-24.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PerinciSubValidateArgs::Overhead

To run module startup overhead benchmark:

 % bencher --module-startup -m PerinciSubValidateArgs::Overhead

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSW>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingTypeTiny>

=head1 BENCHMARK PARTICIPANTS

=over

=item * none (perl_code)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate::foo(a1=><a1>, a2=><a2>)



=item * manual (perl_code)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually::foo(a1=><a1>, a2=><a2>)



=item * manual+dsah (perl_code)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah::foo(a1=><a1>, a2=><a2>)



=item * DZPRV (perl_code) (not included by default)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSW::foo(a1=><a1>, a2=><a2>)



=item * DZPRW (perl_code) (not included by default)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV::foo(a1=><a1>, a2=><a2>)



=item * PSW (perl_code)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingTypeTiny::foo(a1=><a1>, a2=><a2>)



=item * PSV (perl_code)

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV>::foo



=item * Type::Tiny (perl_code)

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingTypeTiny>::foo



=back

=head1 BENCHMARK DATASETS

=over

=item * {a1=>1,a2=>[1]}

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PerinciSubValidateArgs::Overhead >>):

 +-------------+-----------+-----------+------------+---------+---------+
 | participant | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +-------------+-----------+-----------+------------+---------+---------+
 | PSV         | 5.5e+04   | 18        | 1          | 2.7e-08 | 20      |
 | PSW         | 7.59e+04  | 13.2      | 1.37       | 6.5e-09 | 21      |
 | manual+dsah | 1.17e+05  | 8.57      | 2.1        | 3.3e-09 | 20      |
 | Type::Tiny  | 1.3e+05   | 7.7       | 2.3        | 1.3e-08 | 21      |
 | manual      | 2.5e+05   | 4         | 4.5        | 5e-09   | 20      |
 | none        | 2.02e+06  | 0.496     | 36.4       | 1.7e-10 | 29      |
 +-------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m PerinciSubValidateArgs::Overhead --module-startup >>):

 +----------------------------------------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                                                          | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +----------------------------------------------------------------------+-----------+------------------------+------------+---------+---------+
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSW      | 78        | 73.6                   | 1          | 0.00038 | 20      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah | 69        | 64.6                   | 1.1        | 0.0003  | 21      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingTypeTiny | 47        | 42.6                   | 1.7        | 0.00011 | 22      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV      | 13        | 8.6                    | 6          | 8.6e-05 | 20      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually      | 8.2       | 3.8                    | 9.6        | 5.6e-05 | 21      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate            | 7.8       | 3.4                    | 10         | 2.4e-05 | 20      |
 | perl -e1 (baseline)                                                  | 4.4       | 0                      | 18         | 3.1e-05 | 21      |
 +----------------------------------------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARK NOTES

The Type::Tiny, Data::Sah, Perinci::Sub::ValidateArgs participants (except
C<none>, obviously) all should be in the same order of magnitude because both
L<Data::Sah> and L<Type::Tiny> work by generating Perl code validator and then
compiling (C<eval()>) them then execute the compiled result. The differences are
in the details: how the generated Perl code is structured, what the code for the
type checks are (e.g. checking for number can be done with a regex or
L<Scalar::Util>'s C<looks_like_number()> or L<Scalar::Util::Numeric>, and so
on).

Perinci::Sub::Wrapper (PSW) and Dist::Zilla::Plugin::Rinci::Wrap is slower
because it does more.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PerinciSubValidateArgs>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PerinciSubValidateArgs>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PerinciSubValidateArgs>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
