package Bencher::Scenario::Perinci::Sub::Normalize;

our $DATE = '2015-12-23'; # DATE
our $VERSION = '0.02'; # VERSION

our $scenario = {
    summary => 'Benchmark normalizing Rinci function metadata',
    participants => [
        {
            fcall_template => 'Perinci::Sub::Normalize::normalize_function_metadata(<meta>)'
        },
    ],
    datasets => [

        {
            name    => 'minimal',
            summary => 'Only contains v=>1.1',
            args    => {
                meta => {
                    v => 1.1,
                },
            },
        },

        {
            name => '0args',
            args => {
                meta => {
                    v => 1.1,
                    summary => 'Some summary',
                    description => <<'_',

Some description. Some description. Some description. Some description. Some
description. Some description. Some description. Some description. Some
description.

_
                    args => {},
                },
            },
        },

        {
            name => '1arg',
            args => {
                meta => {
                    v => 1.1,
                    summary => 'Some summary',
                    description => <<'_',

Some description. Some description. Some description. Some description. Some
description. Some description. Some description. Some description. Some
description.

_
                    args => {
                        arg1 => {
                            summary => 'Some summary',
                            schema => 'str*',
                            req => 1,
                            pos => 0,
                        },
                    },
                },
            },
        },

        {
            name => 'typical',
            summary => '5 arguments',
            args => {
                meta => {
                    v => 1.1,
                    summary => 'Some summary',
                    description => <<'_',

Some description. Some description. Some description. Some description. Some
description. Some description. Some description. Some description. Some
description.

_
                    args => {
                        arg1 => {
                            summary => 'Some summary',
                            schema => 'str*',
                            req => 1,
                            pos => 0,
                        },
                        arg2 => {
                            summary => 'Some summary',
                            schema => ['array*' => of => 'str*', min_len=>1],
                            req => 1,
                            pos => 1,
                            greedy => 1,
                        },
                        arg3 => {
                            summary => 'Some summary',
                            schema => ['int*', min=>1, max=>100],
                            req => 1,
                        },
                        arg4 => {
                            summary => 'Some summary',
                            schema => [bool => is=>1],
                            cmdline_aliases => {f=>{is_flag=>1}},
                        },
                        arg5 => {
                            summary => 'Some summary',
                            schema => 'hash*',
                        },
                    },
                },
            },
        },

    ],
};

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Perinci::Sub::Normalize

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::Perinci::Sub::Normalize (from Perl distribution Bencher-Scenarios-Perinci), released on 2015-12-23.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Perinci>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Perinci>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Perinci>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BENCHMARKED MODULES

L<Perinci::Sub::Normalize>

=cut
