package Bencher::Scenario::PERLANCAR::state;

our $DATE = '2016-03-23'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark overhead of state (vs my) variables in a tight subroutine',
    description => <<'_',

Each variable declaration is not free.

_
    participants => [
        {
            name=>'baseline_0',
            code_template=>' ',
            #include_by_default => 0,
        },
        {
            name=>'1_state',
            code_template=>'state $s1 = 1',
        },
        {
            name=>'2_state',
            code_template=>'state $s1 = 1; state $s2 = 1',
        },
        {
            name=>'5_state',
            code_template=>'state $s1 = 1; state $s2 = 1; state $s3 = 1; state $s4 = 1; state $s5 = 1; ',
        },
        {
            name=>'10_state',
            code_template=>'state $s1=1; state $s2=1; state $s3=1; state $s4=1; state $s5=1; state $s6=1; state $s7=1; state $s8=1; state $s9=1; state $s10=1; ',
        },

        {
            name=>'5_state_do',
            code_template=>'state $s1 = do{1}; state $s2 = do{1}; state $s3 = do{1}; state $s4 = do{1}; state $s5 = do{1}; ',
            include_by_default => 0,
            summary => "The use of do{} doesn't affect the timing because they are evaluated once",
        },

        {
            name=>'1_my',
            code_template=>'my $s1 = 1',
        },
        {
            name=>'2_my',
            code_template=>'my $s1 = 1; my $s2 = 1',
        },
        {
            name=>'5_my',
            code_template=>'my $s1 = 1; my $s2 = 1; my $s3 = 1; my $s4 = 1; my $s5 = 1; ',
        },
        {
            name=>'10_my',
            code_template=>'my $s1=1; my $s2=1; my $s3=1; my $s4=1; my $s5=1; my $s6=1; my $s7=1; my $s8=1; my $s9=1; my $s10=1; ',
        },
    ],
};

1;
# ABSTRACT: Benchmark overhead of state (vs my) variables in a tight subroutine

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCAR::state - Benchmark overhead of state (vs my) variables in a tight subroutine

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::PERLANCAR::state (from Perl distribution Bencher-Scenarios-PERLANCAR), released on 2016-03-23.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCAR::state

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * baseline_0 (perl_code)

Code template:

  



=item * 1_state (perl_code)

Code template:

 state $s1 = 1



=item * 2_state (perl_code)

Code template:

 state $s1 = 1; state $s2 = 1



=item * 5_state (perl_code)

Code template:

 state $s1 = 1; state $s2 = 1; state $s3 = 1; state $s4 = 1; state $s5 = 1; 



=item * 10_state (perl_code)

Code template:

 state $s1=1; state $s2=1; state $s3=1; state $s4=1; state $s5=1; state $s6=1; state $s7=1; state $s8=1; state $s9=1; state $s10=1; 



=item * 5_state_do (perl_code) (not included by default)

Code template:

 my $s1 = 1



=item * 1_my (perl_code)

Code template:

 my $s1 = 1; my $s2 = 1



=item * 2_my (perl_code)

Code template:

 my $s1 = 1; my $s2 = 1; my $s3 = 1; my $s4 = 1; my $s5 = 1; 



=item * 5_my (perl_code)

Code template:

 my $s1=1; my $s2=1; my $s3=1; my $s4=1; my $s5=1; my $s6=1; my $s7=1; my $s8=1; my $s9=1; my $s10=1; 



=item * 10_my (perl_code)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCAR::state >>):

 +-------------+-----------+-----------+------------+---------+---------+
 | participant | rate (/s) | time (ns) | vs_slowest | errors  | samples |
 +-------------+-----------+-----------+------------+---------+---------+
 | 10_my       | 3e+06     | 330       | 1          | 8.3e-10 | 20      |
 | 5_my        | 5.49e+06  | 182       | 1.84       | 9e-11   | 27      |
 | 10_state    | 8.22e+06  | 122       | 2.75       | 1.1e-10 | 20      |
 | 2_my        | 1.2e+07   | 83        | 4          | 1e-10   | 23      |
 | 5_state     | 1.5e+07   | 68        | 4.9        | 2.7e-10 | 20      |
 | 2_state     | 2.6e+07   | 38        | 8.8        | 4.8e-11 | 24      |
 | 1_my        | 2.96e+07  | 33.7      | 9.92       | 1.2e-11 | 20      |
 | 1_state     | 8e+07     | 10        | 3e+01      | 2e-10   | 21      |
 | baseline_0  | 9e+08     | 1         | 3e+02      | 1.1e-10 | 20      |
 +-------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Each variable declaration is not free.


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCAR>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCAR>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCAR>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
