package Bencher::Scenario::LogGer::Startup;

our $DATE = '2017-08-01'; # DATE
our $VERSION = '0.011'; # VERSION

use 5.010001;
use strict;
use warnings;

use File::Temp qw(tempfile);

my ($fh, $fname) = tempfile();

our $scenario = {
    summary => 'Measure startup overhead of Log::ger vs other logging libraries',
    modules => {
        'Log::ger' => {version=>'0.019'},
        'Log::ger::App' => {version=>'0.002'},
        'Log::ger::Output' => {version=>'0.005'},
        'Log::ger::Layout::Pattern' => {version=>'0'},
    },
    participants => [
        {name=>"baseline", perl_cmdline => ["-e1"]},

        {name=>"use Log::ger ()", module=>'Log::ger', perl_cmdline => ["-mLog::ger", "-e1"]},

        {name=>"use Log::ger" , module=>'Log::ger', perl_cmdline => ["-MLog::ger", "-e1"]},
        {name=>"use Log::ger + get_logger()" , module=>'Log::ger', perl_cmdline => ["-mLog::ger", "-e", '$log = Log::ger->get_logger()']},
        {name=>"use Log::ger + use LGP:OptAway", module=>'Log::ger::Plugin::OptAway', perl_cmdline => ["-MLog::ger::Plugin::OptAway", "-MLog::ger", "-e1"]},
        {name=>"use Log::ger + use LGO:Screen", module=>'Log::ger::Output::Screen', perl_cmdline => ["-MLog::ger", "-MLog::ger::Output=Screen", "-e1"]},
        {name=>"use Log::ger + use LGO:File", module=>'Log::ger::Output::File', perl_cmdline => ["-e", qq(use Log::ger::Output File => (path=>'$fname'); use Log::ger)]},
        {name=>"use Log::ger + use LGO:Composite (0 outputs)", module=>'Log::ger::Output::Composite', perl_cmdline => ["-e", qq(use Log::ger::Output Composite; use Log::ger)]},
        {name=>"use Log::ger + use LGO:Composite (2 outputs)", module=>'Log::ger::Output::Composite', perl_cmdline => ["-e", qq(use Log::ger::Output Composite => (outputs=>{Screen=>{}, File=>{conf=>{path=>'$fname'}}}); use Log::ger)]},
        {name=>"use Log::ger + use LGO:Composite (2 outputs + pattern layouts)", module=>'Log::ger::Output::Composite', perl_cmdline => ["-e", qq(use Log::ger::Output Composite => (outputs=>{Screen=>{layout=>[Pattern=>{format=>"[%d] %m"}]}, File=>{conf=>{path=>'$fname'}, layout=>[Pattern=>{format=>"[%d] [%P] %m"}]}}); use Log::ger)]},
        {name=>"use Log::ger::Like::LogAny" , module=>'Log::ger::Like::LogAny', perl_cmdline => ["-MLog::ger::Like::LogAny", "-e1"]},
        {name=>"use Log::ger::Like::Log4perl" , module=>'Log::ger::Like::Log4perl', perl_cmdline => ["-MLog::ger::Like::Log4perl", "-e1"]},
        {name=>"use Log::ger::App" , module=>'Log::ger::App', perl_cmdline => ["-MLog::ger::App", "-e1"]},

        {name=>"use Log::Any" , module=>'Log::Any', perl_cmdline => ["-MLog::Any", "-e1"]},
        {name=>"use Log::Any + use LGA:Screen" , module=>'Log::Any::Adapter::Screen', perl_cmdline => ["-MLog::Any", "-MLog::Any::Adapter=Screen", "-e1"]},

        {name=>"use Log::Log4perl ()", module=>'Log::Log4perl', perl_cmdline => ["-mLog::Log4perl", '-e1']},
        {name=>"use Log::Log4perl + easy_init", module=>'Log::Log4perl', perl_cmdline => ["-MLog::Log4perl=:easy", '-e', 'Log::Log4perl->easy_init']},

        {name=>"use Log::Log4perl::Tiny ()", module=>'Log::Log4perl::Tiny', perl_cmdline => ["-mLog::Log4perl::Tiny", '-e1']},
        {name=>"use Log::Log4perl::Tiny :easy", module=>'Log::Log4perl::Tiny', perl_cmdline => ["-MLog::Log4perl::Tiny=:easy", '-e', 'Log::Log4perl->easy_init']},
    ],
};

1;
# ABSTRACT: Measure startup overhead of Log::ger vs other logging libraries

# TODO: move to Overhead

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::LogGer::Startup - Measure startup overhead of Log::ger vs other logging libraries

=head1 VERSION

This document describes version 0.011 of Bencher::Scenario::LogGer::Startup (from Perl distribution Bencher-Scenarios-LogGer), released on 2017-08-01.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m LogGer::Startup

To run module startup overhead benchmark:

 % bencher --module-startup -m LogGer::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Log::Any> 1.049

L<Log::Any::Adapter::Screen> 0.13

L<Log::Log4perl> 1.49

L<Log::Log4perl::Tiny> 1.4.0

L<Log::ger> 0.020

L<Log::ger::App> 0.003

L<Log::ger::Layout::Pattern> 0.001

L<Log::ger::Like::Log4perl> 0.001

L<Log::ger::Like::LogAny> 0.003

L<Log::ger::Output> 0.020

L<Log::ger::Output::Composite> 0.007

L<Log::ger::Output::File> 0.002

L<Log::ger::Output::Screen> 0.005

L<Log::ger::Plugin::OptAway> 0.004

=head1 BENCHMARK PARTICIPANTS

=over

=item * baseline (command)



=item * use Log::ger () (command)

L<Log::ger>



=item * use Log::ger (command)

L<Log::ger>



=item * use Log::ger + get_logger() (command)

L<Log::ger>



=item * use Log::ger + use LGP:OptAway (command)

L<Log::ger::Plugin::OptAway>



=item * use Log::ger + use LGO:Screen (command)

L<Log::ger::Output::Screen>



=item * use Log::ger + use LGO:File (command)

L<Log::ger::Output::File>



=item * use Log::ger + use LGO:Composite (0 outputs) (command)

L<Log::ger::Output::Composite>



=item * use Log::ger + use LGO:Composite (2 outputs) (command)

L<Log::ger::Output::Composite>



=item * use Log::ger + use LGO:Composite (2 outputs + pattern layouts) (command)

L<Log::ger::Output::Composite>



=item * use Log::ger::Like::LogAny (command)

L<Log::ger::Like::LogAny>



=item * use Log::ger::Like::Log4perl (command)

L<Log::ger::Like::Log4perl>



=item * use Log::ger::App (command)

L<Log::ger::App>



=item * use Log::Any (command)

L<Log::Any>



=item * use Log::Any + use LGA:Screen (command)

L<Log::Any::Adapter::Screen>



=item * use Log::Log4perl () (command)

L<Log::Log4perl>



=item * use Log::Log4perl + easy_init (command)

L<Log::Log4perl>



=item * use Log::Log4perl::Tiny () (command)

L<Log::Log4perl::Tiny>



=item * use Log::Log4perl::Tiny :easy (command)

L<Log::Log4perl::Tiny>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.26.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with C<< bencher -m LogGer::Startup --include-path archive/Log-Any-0.15/lib --include-path archive/Log-Any-1.00/lib --multimodver Log::Any >>:

 #table1#
 +----------------------------------------------------------------+--------+-----------+-----------+------------+----------+---------+
 | participant                                                    | modver | rate (/s) | time (ms) | vs_slowest |  errors  | samples |
 +----------------------------------------------------------------+--------+-----------+-----------+------------+----------+---------+
 | use Log::Log4perl + easy_init                                  |        |        27 |      38   |        1   | 6.5e-05  |      21 |
 | use Log::Log4perl ()                                           |        |        27 |      37   |        1   |   0.0001 |      20 |
 | use Log::ger + use LGO:Composite (2 outputs + pattern layouts) |        |        52 |      19   |        1.9 | 4.7e-05  |      20 |
 | use Log::Log4perl::Tiny :easy                                  |        |        54 |      19   |        2   | 5.2e-05  |      20 |
 | use Log::Log4perl::Tiny ()                                     |        |        54 |      19   |        2   | 6.5e-05  |      20 |
 | use Log::Any                                                   | 1.00   |        61 |      16   |        2.3 |   6e-05  |      21 |
 | use Log::ger + use LGO:Composite (2 outputs)                   |        |        68 |      15   |        2.5 | 3.7e-05  |      20 |
 | use Log::ger + use LGO:Composite (0 outputs)                   |        |        73 |      14   |        2.7 | 3.7e-05  |      20 |
 | use Log::Any + use LGA:Screen                                  |        |        79 |      13   |        3   | 4.1e-05  |      20 |
 | use Log::ger::Like::Log4perl                                   |        |        80 |      13   |        3   | 3.7e-05  |      21 |
 | use Log::ger::App                                              |        |        81 |      12   |        3   | 2.8e-05  |      20 |
 | use Log::Any                                                   | 1.049  |        95 |      11   |        3.6 | 1.5e-05  |      20 |
 | use Log::ger + use LGO:Screen                                  |        |       110 |       9.4 |        4   | 1.7e-05  |      20 |
 | use Log::ger + use LGO:File                                    |        |       110 |       9.1 |        4.1 | 4.3e-05  |      20 |
 | use Log::ger + use LGP:OptAway                                 |        |       200 |       5   |        7.6 | 1.8e-05  |      20 |
 | use Log::Any                                                   | 0.15   |       210 |       4.7 |        8   | 2.5e-05  |      20 |
 | use Log::ger ()                                                |        |       400 |       2.5 |       15   | 1.5e-05  |      20 |
 | use Log::ger + get_logger()                                    |        |       400 |       2.5 |       15   | 1.2e-05  |      20 |
 | use Log::ger                                                   |        |       400 |       2.5 |       15   | 1.4e-05  |      20 |
 | use Log::ger::Like::LogAny                                     |        |       520 |       1.9 |       19   | 1.7e-05  |      20 |
 | baseline                                                       |        |       570 |       1.7 |       22   | 1.4e-05  |      20 |
 +----------------------------------------------------------------+--------+-----------+-----------+------------+----------+---------+


Benchmark with C<< bencher -m LogGer::Startup --include-participant-pattern 'Log::ger|baseline' --include-path archive/Log-ger-0.005/lib --include-path archive/Log-ger-0.006/lib --include-path archive/Log-ger-0.007/lib --include-path archive/Log-ger-0.008/lib --include-path archive/Log-ger-0.009/lib --include-path archive/Log-ger-0.010/lib --include-path archive/Log-ger-0.011/lib --include-path archive/Log-ger-0.012/lib --include-path archive/Log-ger-0.016/lib --multimodver Log::ger >>:

 #table2#
 +----------------------------------------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                                                    | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +----------------------------------------------------------------+--------+-----------+-----------+------------+---------+---------+
 | use Log::ger + use LGO:Composite (2 outputs + pattern layouts) |        |        51 |      19   |        1   | 7.6e-05 |      20 |
 | use Log::ger + use LGO:Composite (2 outputs)                   |        |        69 |      15   |        1.3 | 4.3e-05 |      20 |
 | use Log::ger + use LGO:Composite (0 outputs)                   |        |        74 |      13   |        1.4 |   3e-05 |      21 |
 | use Log::ger::Like::Log4perl                                   |        |        80 |      13   |        1.5 | 3.5e-05 |      21 |
 | use Log::ger::App                                              |        |        80 |      12   |        1.6 |   2e-05 |      20 |
 | use Log::ger + use LGO:Screen                                  |        |       110 |       9.2 |        2.1 | 2.2e-05 |      21 |
 | use Log::ger + use LGO:File                                    |        |       110 |       9.1 |        2.1 | 2.9e-05 |      20 |
 | use Log::ger + use LGP:OptAway                                 |        |       210 |       4.9 |        4   | 3.1e-05 |      21 |
 | use Log::ger + get_logger()                                    | 0.012  |       250 |       4   |        4.8 | 6.7e-06 |      20 |
 | use Log::ger + get_logger()                                    | 0.011  |       250 |       4   |        4.9 | 2.3e-05 |      20 |
 | use Log::ger ()                                                | 0.011  |       250 |       3.9 |        4.9 | 2.8e-05 |      20 |
 | use Log::ger                                                   | 0.012  |       260 |       3.9 |        5   | 1.9e-05 |      20 |
 | use Log::ger                                                   | 0.011  |       260 |       3.8 |        5   | 1.9e-05 |      20 |
 | use Log::ger ()                                                | 0.012  |       270 |       3.7 |        5.3 | 1.1e-05 |      20 |
 | use Log::ger + get_logger()                                    | 0.010  |       300 |       4   |        5   |   4e-05 |      20 |
 | use Log::ger + get_logger()                                    | 0.009  |       300 |       3   |        6   | 3.7e-05 |      21 |
 | use Log::ger + get_logger()                                    | 0.006  |       300 |       3.4 |        5.8 | 1.6e-05 |      20 |
 | use Log::ger + get_logger()                                    | 0.008  |       300 |       3.3 |        5.8 | 2.6e-05 |      21 |
 | use Log::ger                                                   | 0.006  |       310 |       3.2 |        6   | 1.7e-05 |      20 |
 | use Log::ger + get_logger()                                    | 0.007  |       310 |       3.2 |        6   | 1.4e-05 |      20 |
 | use Log::ger + get_logger()                                    | 0.005  |       320 |       3.2 |        6.1 |   2e-05 |      20 |
 | use Log::ger                                                   | 0.007  |       320 |       3.2 |        6.2 | 1.8e-05 |      20 |
 | use Log::ger                                                   | 0.005  |       320 |       3.2 |        6.2 | 2.2e-05 |      20 |
 | use Log::ger ()                                                | 0.008  |       320 |       3.1 |        6.2 | 2.7e-05 |      20 |
 | use Log::ger                                                   | 0.009  |       320 |       3.1 |        6.2 | 2.1e-05 |      20 |
 | use Log::ger                                                   | 0.010  |       320 |       3.1 |        6.2 | 1.3e-05 |      20 |
 | use Log::ger                                                   | 0.008  |       320 |       3.1 |        6.2 | 2.3e-05 |      20 |
 | use Log::ger ()                                                | 0.009  |       320 |       3.1 |        6.2 | 1.2e-05 |      21 |
 | use Log::ger ()                                                | 0.007  |       320 |       3.1 |        6.3 | 2.7e-05 |      20 |
 | use Log::ger ()                                                | 0.010  |       330 |       3   |        6.4 | 1.6e-05 |      20 |
 | use Log::ger ()                                                | 0.005  |       330 |       3   |        6.4 |   2e-05 |      20 |
 | use Log::ger ()                                                | 0.006  |       330 |       3   |        6.5 | 1.2e-05 |      21 |
 | use Log::ger ()                                                | 0.016  |       400 |       3   |        8   | 2.5e-05 |      20 |
 | use Log::ger                                                   | 0.020  |       400 |       2.5 |        7.9 | 2.1e-05 |      20 |
 | use Log::ger + get_logger()                                    | 0.020  |       410 |       2.5 |        7.9 | 1.9e-05 |      21 |
 | use Log::ger ()                                                | 0.020  |       410 |       2.4 |        8   | 1.6e-05 |      20 |
 | use Log::ger                                                   | 0.016  |       420 |       2.4 |        8.1 | 1.5e-05 |      20 |
 | use Log::ger + get_logger()                                    | 0.016  |       420 |       2.4 |        8.2 | 1.5e-05 |      20 |
 | use Log::ger::Like::LogAny                                     |        |       540 |       1.8 |       11   | 8.5e-06 |      20 |
 | baseline                                                       |        |       630 |       1.6 |       12   | 1.5e-05 |      20 |
 +----------------------------------------------------------------+--------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m LogGer::Startup --module-startup >>):

 #table3#
 +-----------------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+-----------+---------+
 | participant                 | proc_private_dirty_size (MB) | proc_rss_size (MB) | proc_size (MB) | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors   | samples |
 +-----------------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+-----------+---------+
 | Log::Log4perl               | 0.81                         | 4.2                | 20             |      40   |     34.4               |        1   |   0.00011 |      20 |
 | Log::Log4perl::Tiny         | 0.62                         | 4.1                | 20             |      22   |     16.4               |        1.8 | 6.7e-05   |      21 |
 | Log::ger::Like::Log4perl    | 0.91                         | 4.3                | 20             |      16   |     10.4               |        2.4 | 2.6e-05   |      20 |
 | Log::Any::Adapter::Screen   | 0.57                         | 4                  | 20             |      16   |     10.4               |        2.4 | 4.5e-05   |      20 |
 | Log::ger::App               | 0.91                         | 4.3                | 20             |      16   |     10.4               |        2.4 |   4e-05   |      20 |
 | Log::Any                    | 0.91                         | 4.4                | 20             |      15   |      9.4               |        2.7 | 4.5e-05   |      20 |
 | Log::ger::Output::Screen    | 0.62                         | 4.1                | 20             |      12   |      6.4               |        3.3 | 2.3e-05   |      20 |
 | Log::ger::Output::Composite | 1.3                          | 4.7                | 20             |       9.2 |      3.6               |        4.3 | 2.7e-05   |      20 |
 | Log::ger::Output::File      | 0.82                         | 4.2                | 20             |       8.6 |      3                 |        4.6 | 5.2e-05   |      20 |
 | Log::ger::Plugin::OptAway   | 0.63                         | 4                  | 20             |       8.3 |      2.7               |        4.8 |   2e-05   |      21 |
 | Log::ger                    | 0.63                         | 4                  | 20             |       6.7 |      1.1               |        5.9 | 3.8e-05   |      20 |
 | Log::ger::Like::LogAny      | 0.82                         | 4.2                | 20             |       6.2 |      0.600000000000001 |        6.4 | 3.2e-05   |      20 |
 | perl -e1 (baseline)         | 0.56                         | 4                  | 20             |       5.6 |      0                 |        7.1 | 2.7e-05   |      20 |
 +-----------------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+-----------+---------+


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-LogGer>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-LogGer>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-LogGer>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
