package Bencher::Scenario::DataSahParams::Startup;

our $DATE = '2016-05-26'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark startup of Data::Sah::Params',
    participants => [
        {
            name => 'perl',
            perl_cmdline => ["-e1"],
        },
        {
            name => 'load_dsp',
            summary => 'Load Data::Sah::Params',
            perl_cmdline => ["-MData::Sah::Params=compile", "-e1"],
        },
        {
            name => 'load_tp',
            summary => 'Load Type::Params',
            perl_cmdline => ["-MType::Params=compile", "-e1"],
        },
    ],
};

1;
# ABSTRACT: Benchmark startup of Data::Sah::Params

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSahParams::Startup - Benchmark startup of Data::Sah::Params

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::DataSahParams::Startup (from Perl distribution Bencher-Scenarios-DataSahParams), released on 2016-05-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSahParams::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * perl (command)



=item * load_dsp (command)

Load Data::Sah::Params.



=item * load_tp (command)

Load Type::Params.



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m DataSahParams::Startup >>):

 +-------------+-----------+-----------+------------+---------+---------+
 | participant | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +-------------+-----------+-----------+------------+---------+---------+
 | load_tp     | 25.5      | 39.3      | 1          | 2.6e-05 | 20      |
 | load_dsp    | 1.3e+02   | 7.7       | 5.1        | 4.4e-05 | 20      |
 | perl        | 237       | 4.21      | 9.32       | 4.1e-06 | 20      |
 +-------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSahParams>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-DataSahParams>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSahParams>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
