package Bencher::Scenario::ArraySet::intersect;

our $DATE = '2016-09-15'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark intersect operation',
    participants => [
        {
            fcall_template => 'Array::Set::set_intersect(<set1>, <set2>)',
        },
        {
            module => 'Set::Object',
            function => 'intersection',
            code_template => 'my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->intersection($set2);', # $res->as_string
        },
    ],
    datasets => [
        { name => '1_1'  , args => { set1=>[1], set2=>[1] } },

        { name => '10_1' , args => { set1=>[1..10], set2=>[1] } },
        { name => '10_5' , args => { set1=>[1..10], set2=>[1..5] } },
        { name => '10_10', args => { set1=>[1..10], set2=>[1..10] } },

        { name => '100_1'  , args => { set1=>[1..100], set2=>[1] } },
        { name => '100_10' , args => { set1=>[1..100], set2=>[1..10] } },
        { name => '100_100', args => { set1=>[1..100], set2=>[1..100] } },

        { name => '1000_1'   , args => { set1=>[1..1000], set2=>[1] } },
        { name => '1000_10'  , args => { set1=>[1..1000], set2=>[1..10] } },
        { name => '1000_100' , args => { set1=>[1..1000], set2=>[1..100] } },
        { name => '1000_1000', args => { set1=>[1..1000], set2=>[1..1000] } },
    ],
};

1;
# ABSTRACT: Benchmark intersect operation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ArraySet::intersect - Benchmark intersect operation

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::ArraySet::intersect (from Perl distribution Bencher-Scenarios-ArraySet), released on 2016-09-15.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ArraySet::intersect

To run module startup overhead benchmark:

 % bencher --module-startup -m ArraySet::intersect

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Array::Set> 0.03

L<Set::Object> 1.35

=head1 BENCHMARK PARTICIPANTS

=over

=item * Array::Set::set_intersect (perl_code)

Function call template:

 Array::Set::set_intersect(<set1>, <set2>)



=item * Set::Object::intersection (perl_code)

Code template:

 my $set1 = Set::Object->new; $set1->insert(@{<set1>}); my $set2 = Set::Object->new; $set2->insert(@{<set2>}); my $res = $set1->intersection($set2);



=back

=head1 BENCHMARK DATASETS

=over

=item * 1_1

=item * 10_1

=item * 10_5

=item * 10_10

=item * 100_1

=item * 100_10

=item * 100_100

=item * 1000_1

=item * 1000_10

=item * 1000_100

=item * 1000_1000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with C<< bencher -m ArraySet::intersect --include-path archive/Array-Set-0.02/lib --include-path archive/Array-Set-0.03/lib --multimodver Array::Set >>:

 #table1#
 {dataset=>"1000_1"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |       278 |     3.6   |        1   | 2.5e-06 |      20 |
 | Set::Object::intersection |        |      1100 |     0.92  |        3.9 |   2e-06 |      20 |
 | Array::Set::set_intersect | 0.03   |      5020 |     0.199 |       18.1 | 5.3e-08 |      20 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"1000_10"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |       275 |     3.64  |        1   | 2.6e-06 |      21 |
 | Set::Object::intersection |        |      1100 |     0.94  |        3.9 |   2e-06 |      20 |
 | Array::Set::set_intersect | 0.03   |      4880 |     0.205 |       17.8 | 5.3e-08 |      20 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"1000_100"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |       248 |     4.02  |        1   | 2.1e-06 |      20 |
 | Set::Object::intersection |        |      1000 |     0.96  |        4.2 | 1.8e-06 |      21 |
 | Array::Set::set_intersect | 0.03   |      3870 |     0.258 |       15.6 | 2.1e-07 |      20 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table4#
 {dataset=>"1000_1000"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |       125 |     7.98  |        1   | 5.4e-06 |      20 |
 | Set::Object::intersection |        |       870 |     1.2   |        6.9 | 2.7e-06 |      20 |
 | Array::Set::set_intersect | 0.03   |      1300 |     0.772 |       10.3 | 4.5e-07 |      23 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table5#
 {dataset=>"100_1"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |      2650 |     377   |        1   | 2.7e-07 |      20 |
 | Set::Object::intersection |        |     11000 |      95   |        4   | 9.9e-08 |      23 |
 | Array::Set::set_intersect | 0.03   |     49500 |      20.2 |       18.7 | 6.4e-09 |      22 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table6#
 {dataset=>"100_10"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |      2400 |     420   |        1   | 4.3e-07 |      20 |
 | Set::Object::intersection |        |     10000 |      98   |        4.2 | 1.1e-07 |      20 |
 | Array::Set::set_intersect | 0.03   |     39600 |      25.3 |       16.5 | 1.1e-08 |      30 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table7#
 {dataset=>"100_100"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |      1240 |       805 |        1   | 2.1e-07 |      20 |
 | Set::Object::intersection |        |      8500 |       120 |        6.9 | 2.7e-07 |      20 |
 | Array::Set::set_intersect | 0.03   |     14100 |        71 |       11.3 | 2.7e-08 |      20 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table8#
 {dataset=>"10_1"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |     19000 |  52       |     1      | 9.2e-08 |      27 |
 | Set::Object::intersection |        |     63100 |  15.8     |     3.25   | 6.7e-09 |      20 |
 | Array::Set::set_intersect | 0.03   |    203163 |   4.92215 |    10.4702 |   0     |      20 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table9#
 {dataset=>"10_10"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |     11000 |   90.7    |     1      | 2.5e-08 |      22 |
 | Set::Object::intersection |        |     58000 |   17      |     5.2    | 2.7e-08 |      20 |
 | Array::Set::set_intersect | 0.03   |    104130 |    9.6033 |     9.4447 | 5.8e-11 |      28 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table10#
 {dataset=>"10_5"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |     15000 |      69   |       1    | 1.1e-07 |      20 |
 | Set::Object::intersection |        |     61000 |      16   |       4.2  | 3.3e-08 |      20 |
 | Array::Set::set_intersect | 0.03   |    141000 |       7.1 |       9.71 | 3.3e-09 |      20 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+

 #table11#
 {dataset=>"1_1"}
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant               | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+
 | Array::Set::set_intersect | 0.02   |     58000 |      17   |        1   | 2.7e-08 |      20 |
 | Set::Object::intersection |        |    140000 |       7.2 |        2.4 |   1e-08 |      20 |
 | Array::Set::set_intersect | 0.03   |    300000 |       3.4 |        5.1 | 6.7e-09 |      20 |
 +---------------------------+--------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ArraySet::intersect --module-startup >>):

 #table12#
 +---------------------+-----------+------------------------+------------+----------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors  | samples |
 +---------------------+-----------+------------------------+------------+----------+---------+
 | Set::Object         |        20 |                     14 |        1   |   0.0002 |      20 |
 | Array::Set          |        14 |                      8 |        1.4 | 5.5e-05  |      20 |
 | perl -e1 (baseline) |         6 |                      0 |        3.3 | 5.8e-05  |      20 |
 +---------------------+-----------+------------------------+------------+----------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-ArraySet>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-ArraySet>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-ArraySet>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
