package Bencher::Scenario::Accessors::Get;

our $DATE = '2016-06-26'; # DATE
our $VERSION = '0.08'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark attribute read/get',
    modules => {
    },
    participants => [
        (map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "state \$o = do { my \$o = ${_}->new; \$o->attr1(42); \$o }; \$o->attr1",
            };
        } grep { !$classes->{$_}{immutable} } keys %$classes),

        # also compare with raw hash & array access
        {
            name => 'raw hash access',
            module => 'Perl::Examples::Accessors::Hash',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Hash->new; \$o->attr1(42); \$o }; \$o->{attr1}",
        },
        {
            name => 'raw array access',
            module => 'Perl::Examples::Accessors::Array',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Array->new; \$o->attr1(42); \$o }; \$o->[0]",
        },
    ],
};

1;
# ABSTRACT: Benchmark attribute read/get

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Get - Benchmark attribute read/get

=head1 VERSION

This document describes version 0.08 of Bencher::Scenario::Accessors::Get (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-06-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Get

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Get

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.06

L<Perl::Examples::Accessors::ClassAccessor> 0.06

L<Perl::Examples::Accessors::ClassAccessorArray> 0.06

L<Perl::Examples::Accessors::ClassInsideOut> 0.06

L<Perl::Examples::Accessors::ClassXSAccessor> 0.06

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.06

L<Perl::Examples::Accessors::Hash> 0.06

L<Perl::Examples::Accessors::Mo> 0.06

L<Perl::Examples::Accessors::MojoBase> 0.06

L<Perl::Examples::Accessors::Moo> 0.06

L<Perl::Examples::Accessors::Moose> 0.06

L<Perl::Examples::Accessors::Mouse> 0.06

L<Perl::Examples::Accessors::ObjectSimple> 0.06

L<Perl::Examples::Accessors::SimpleAccessor> 0.06

=head1 BENCHMARK PARTICIPANTS

=over

=item * Mo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mo->new; $o->attr1(42); $o }; $o->attr1



=item * Class::XSAccessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * Class::InsideOut (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassInsideOut->new; $o->attr1(42); $o }; $o->attr1



=item * Simple::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::SimpleAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * Mouse (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mouse->new; $o->attr1(42); $o }; $o->attr1



=item * Class::XSAccessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessorArray->new; $o->attr1(42); $o }; $o->attr1



=item * Moose (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moose->new; $o->attr1(42); $o }; $o->attr1



=item * no generator (hash-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * Mojo::Base (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::MojoBase->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Accessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessorArray->new; $o->attr1(42); $o }; $o->attr1



=item * Moo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moo->new; $o->attr1(42); $o }; $o->attr1



=item * no generator (array-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o->attr1(42); $o }; $o->attr1



=item * Object::Simple (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectSimple->new; $o->attr1(42); $o }; $o->attr1



=item * raw hash access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o->attr1(42); $o }; $o->{attr1}



=item * raw array access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o->attr1(42); $o }; $o->[0]



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Get >>):

 +----------------------------+-----------+-----------+------------+---------+---------+
 | participant                | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +----------------------------+-----------+-----------+------------+---------+---------+
 | Class::Accessor            |   2320000 |     431   |       1    |   2e-10 |      23 |
 | Class::InsideOut           |   3640000 |     275   |       1.57 | 1.4e-10 |      20 |
 | Simple::Accessor           |   3800000 |     270   |       1.6  | 4.9e-10 |      24 |
 | no generator (hash-based)  |   5400000 |     180   |       2.3  | 4.2e-10 |      20 |
 | Mo                         |   5400000 |     180   |       2.3  | 9.4e-10 |      20 |
 | no generator (array-based) |   5500000 |     180   |       2.4  | 4.2e-10 |      20 |
 | Mojo::Base                 |   5600000 |     180   |       2.4  | 3.1e-10 |      20 |
 | Object::Simple             |   6010000 |     166.4 |       2.59 |   1e-11 |      20 |
 | Moose                      |   6810000 |     147   |       2.93 | 4.5e-11 |      22 |
 | Class::Accessor::Array     |   6960000 |     144   |       3    | 4.6e-11 |      20 |
 | Mouse                      |  13200000 |      75.8 |       5.68 | 1.1e-11 |      20 |
 | Class::XSAccessor          |  13300000 |      75.2 |       5.73 | 6.5e-11 |      21 |
 | Moo                        |  14000000 |      71   |       6.1  | 1.6e-10 |      20 |
 | Class::XSAccessor::Array   |  20000000 |      50   |       8.6  | 2.3e-10 |      20 |
 | raw hash access            |  27000000 |      36   |      12    | 1.5e-10 |      20 |
 | raw array access           |  39000000 |      25   |      17    | 2.1e-10 |      20 |
 +----------------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
