package Bencher::Scenario::Accessors::Get;

our $DATE = '2016-04-14'; # DATE
our $VERSION = '0.06'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark attribute read/get',
    modules => {
    },
    participants => [
        (map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "state \$o = do { my \$o = ${_}->new; \$o->attr1(42); \$o }; \$o->attr1",
            };
        } grep { !$classes->{$_}{immutable} } keys %$classes),

        # also compare with raw hash & array access
        {
            name => 'raw hash access',
            module => 'Perl::Examples::Accessors::Hash',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Hash->new; \$o->attr1(42); \$o }; \$o->{attr1}",
        },
        {
            name => 'raw array access',
            module => 'Perl::Examples::Accessors::Array',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Array->new; \$o->attr1(42); \$o }; \$o->[0]",
        },
    ],
};

1;
# ABSTRACT: Benchmark attribute read/get

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Get - Benchmark attribute read/get

=head1 VERSION

This document describes version 0.06 of Bencher::Scenario::Accessors::Get (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-04-14.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Get

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Get

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.05

L<Perl::Examples::Accessors::ClassAccessor> 0.05

L<Perl::Examples::Accessors::ClassAccessorArray> 0.05

L<Perl::Examples::Accessors::ClassInsideOut> 0.05

L<Perl::Examples::Accessors::ClassXSAccessor> 0.05

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.05

L<Perl::Examples::Accessors::Hash> 0.05

L<Perl::Examples::Accessors::Mo> 0.05

L<Perl::Examples::Accessors::MojoBase> 0.05

L<Perl::Examples::Accessors::Moo> 0.05

L<Perl::Examples::Accessors::Moose> 0.05

L<Perl::Examples::Accessors::Mouse> 0.05

L<Perl::Examples::Accessors::ObjectSimple> 0.05

=head1 BENCHMARK PARTICIPANTS

=over

=item * Mouse (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mouse->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Accessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessorArray->new; $o->attr1(42); $o }; $o->attr1



=item * Mojo::Base (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::MojoBase->new; $o->attr1(42); $o }; $o->attr1



=item * Class::XSAccessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * Moo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moo->new; $o->attr1(42); $o }; $o->attr1



=item * no generator (array-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o->attr1(42); $o }; $o->attr1



=item * Mo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mo->new; $o->attr1(42); $o }; $o->attr1



=item * Moose (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moose->new; $o->attr1(42); $o }; $o->attr1



=item * Class::XSAccessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessorArray->new; $o->attr1(42); $o }; $o->attr1



=item * no generator (hash-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o->attr1(42); $o }; $o->attr1



=item * Class::InsideOut (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassInsideOut->new; $o->attr1(42); $o }; $o->attr1



=item * Object::Simple (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectSimple->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * raw hash access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o->attr1(42); $o }; $o->{attr1}



=item * raw array access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o->attr1(42); $o }; $o->[0]



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Get >>):

 +----------------------------+-------------+-----------+------------+---------+---------+
 | participant                | rate (/s)   | time (ns) | vs_slowest | errors  | samples |
 +----------------------------+-------------+-----------+------------+---------+---------+
 | Class::Accessor            | 2.36532e+06 | 422.776   | 1          | 0       | 21      |
 | Class::InsideOut           | 3.7e+06     | 2.7e+02   | 1.5        | 3.3e-10 | 31      |
 | Mojo::Base                 | 5.54943e+06 | 180.199   | 2.34617    | 0       | 20      |
 | no generator (hash-based)  | 5.6e+06     | 1.8e+02   | 2.4        | 3e-10   | 21      |
 | Mo                         | 5.91e+06    | 169       | 2.5        | 1e-10   | 20      |
 | no generator (array-based) | 5.9e+06     | 1.7e+02   | 2.5        | 4.2e-10 | 20      |
 | Object::Simple             | 6.07934e+06 | 164.492   | 2.5702     | 0       | 20      |
 | Moose                      | 6.78218e+06 | 147.445   | 2.86734    | 0       | 22      |
 | Class::Accessor::Array     | 7.39237e+06 | 135.275   | 3.12532    | 0       | 20      |
 | Mouse                      | 1.35e+07    | 74.1      | 5.71       | 1.1e-11 | 33      |
 | Moo                        | 1.7e+07     | 59        | 7.2        | 1.5e-10 | 23      |
 | Class::XSAccessor          | 1.82681e+07 | 54.7401   | 7.72333    | 0       | 28      |
 | Class::XSAccessor::Array   | 2.20255e+07 | 45.402    | 9.31184    | 0       | 20      |
 | raw hash access            | 3.06869e+07 | 32.5872   | 12.9737    | 0       | 31      |
 | raw array access           | 4.78931e+07 | 20.8798   | 20.2481    | 0       | 22      |
 +----------------------------+-------------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
