package Bencher::Scenario::Exporters;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.04'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark some popular Exporter modules',

    module_startup => 1,

    participants => [
        {module=>'Exporter'},
        {module=>'Exporter::Tiny'},
        {module=>'Exporter::Tidy'},
        {module=>'Exporter::Rinci'},
        {module=>'Sub::Exporter'},
    ],
};

1;
# ABSTRACT: Benchmark some popular Exporter modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Exporters

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::Exporters (from Perl distribution Bencher-Scenario-Exporters), released on 2016-01-05.

=head1 SYNOPSIS

=head1 BENCHMARKED MODULES

L<Exporter> 5.72

L<Exporter::Tiny> 0.042

L<Exporter::Tidy> 0.08

L<Exporter::Rinci> 0.01

L<Sub::Exporter> 0.987

=head1 BENCHMARK PARTICIPANTS

=over

=item * Exporter (perl_code)

L<Exporter>



=item * Exporter::Tiny (perl_code)

L<Exporter::Tiny>



=item * Exporter::Tidy (perl_code)

L<Exporter::Tidy>



=item * Exporter::Rinci (perl_code)

L<Exporter::Rinci>



=item * Sub::Exporter (perl_code)

L<Sub::Exporter>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+---------------------+--------+-------------------+---------+---------+
 | seq | name                | time   | mod_overhead_time | errors  | samples |
 +-----+---------------------+--------+-------------------+---------+---------+
 | 5   | Sub::Exporter       | 20ms   | 16ms              | 0.00014 | 20      |
 | 2   | Exporter::Tiny      | 8.6ms  | 4.2ms             | 4.6e-05 | 20      |
 | 4   | Exporter::Rinci     | 5.7ms  | 1.2ms             | 2.8e-05 | 20      |
 | 1   | Exporter            | 5.12ms | 0.674ms           | 1.3e-05 | 20      |
 | 3   | Exporter::Tidy      | 5.04ms | 0.593ms           | 1.5e-05 | 20      |
 | 0   | perl -e1 (baseline) | 4.4ms  | 0ms               | 2.7e-05 | 20      |
 +-----+---------------------+--------+-------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-Exporters>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-StartupExporters>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-Exporters>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
