package Bencher::Scenario::Exporters;

our $DATE = '2015-12-23'; # DATE
our $VERSION = '0.03'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark some popular Exporter modules',

    module_startup => 1,

    participants => [
        {module=>'Exporter'},
        {module=>'Exporter::Tiny'},
        {module=>'Exporter::Tidy'},
        {module=>'Exporter::Rinci'},
        {module=>'Sub::Exporter'},
    ],
};

1;
# ABSTRACT: Benchmark some popular Exporter modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Exporters

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::Exporters (from Perl distribution Bencher-Scenario-Exporters), released on 2015-12-23.

=head1 SYNOPSIS

=head1 BENCHMARKED MODULES

L<Exporter>

L<Exporter::Tiny>

L<Exporter::Tidy>

L<Exporter::Rinci>

L<Sub::Exporter>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-Exporters>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-StartupExporters>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-Exporters>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
