use strict;
use Module::Build;

my %arguments = (
    create_makefile_pl => 'passthrough',
    license            => 'perl',
    module_name        => 'Class::DBI::Sweet',
    requires           => {
        'Class::DBI'    => 0.96,
        'Data::Page'    => 0,
        'DBI'           => 0,
        'List::Util'    => 0,
        'SQL::Abstract' => 0,
        'DBD::SQLite'   => 1.08
    },
    create_makefile_pl => 'passthrough',
    create_readme      => 1,
    test_files         => [ glob('t/*.t'), glob('t/*/*.t') ]
);

if ( $^O eq 'MSWin32' ) {
    $arguments{requires}->{'Win32API::GUID'} = 0;
}
else {
    $arguments{requires}->{'Data::UUID'} = 0;
}

Module::Build->new(%arguments)->create_build_script;
