#!/usr/bin/perl -w

=head1 NAME

example-check - Reads the "O" array and the corresponding methods

=cut

use strict;
use lib qw{./lib ../lib};
use Net::GPSD;

my ($host,$port)=split(q{:}, shift()||'');
$host||=q{localhost};
$port||=q{2947};

my $gps=Net::GPSD->new(host=>$host, port=>$port) || die("Error: Cannot connect to the gpsd server");

while (1) {
  my $p=$gps->get();
  if ($p->fix) {
    print "--", join("|", map {defined $_?$_:''}
                     $p->tag,
                     $p->time,
                     $p->errortime,
                     $p->lat,
                     $p->lon,
                     $p->alt,
                     $p->errorhorizontal,
                     $p->errorvertical,
                     $p->heading,
                     $p->speed,
                     $p->climb,
                     $p->errorheading,
                     $p->errorspeed,
                     $p->errorclimb,
                     $p->mode),
                     "\n";
    print "O=", join("|", map {defined $_?$_:''} @{$p->{'O'}}),"\n";
  }
  sleep 1;
}
