
use strict;
use warnings;



use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'All the stuff I install with a fresh perl',
  'AUTHOR' => 'Pedro Melo <melo@cpan.org>',
  'BUILD_REQUIRES' => {},
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'Task-BeLike-MELO',
  'EXE_FILES' => [],
  'LICENSE' => 'artistic_2',
  'NAME' => 'Task::BeLike::MELO',
  'PREREQ_PM' => {
    'Algorithm::C3' => '0.08',
    'AnyEvent' => '5.34',
    'AnyEvent::AIO' => '1.1',
    'AnyEvent::Gearman' => '0.09',
    'AnyEvent::HTTP' => '2.12',
    'AnyEvent::HTTPD' => '0.92',
    'AnyEvent::Redis' => '0.23',
    'AnyEvent::Twitter::Stream' => '0.21',
    'AnyEvent::WebService::Notifo' => '0.001',
    'AnyEvent::XMPP' => '0.51',
    'AnyMQ' => '0.33',
    'App::Ack' => '1.94',
    'App::BashComplete' => '0.001',
    'App::Genpass' => '2.01',
    'App::HTTPThis' => '0.002',
    'App::Nopaste' => '0.28',
    'App::Notifo' => '0.001',
    'App::Uni' => '6',
    'App::Whiff' => '0.002',
    'App::cpanminus' => '1.4008',
    'App::cpanoutdated' => '0.16',
    'App::pod2pdf' => '0.42',
    'Archive::Tar' => '1.76',
    'Archive::Zip' => '1.30',
    'Async::Hooks' => '0.05',
    'Authen::Simple::Passwd' => '0.6',
    'CGI::Emulate::PSGI' => '0.12',
    'CGI::Fast' => '1.08',
    'CHI' => '0.48',
    'CPAN' => '1.9600',
    'CPAN::Mini' => '1.111007',
    'CPAN::Mini::Webserver' => '0.51',
    'CPAN::Reporter' => '1.1902',
    'CPAN::SQLite' => '0.201',
    'CSS::Minifier' => '0.01',
    'Cache::CacheFactory' => '1.10',
    'Carp::Always' => '0.09',
    'Catalyst::Action::RenderView' => '0.16',
    'Catalyst::Controller::REST' => '0.90',
    'Catalyst::Devel' => '1.33',
    'Catalyst::Engine::PSGI' => '0.13',
    'Catalyst::Log::Log4perl' => '1.04',
    'Catalyst::Plugin::Authentication' => '0.10017',
    'Catalyst::Plugin::Session' => '0.32',
    'Catalyst::Plugin::Session::State::Cookie' => '0.17',
    'Catalyst::Plugin::Session::Store::FastMmap' => '0.14',
    'Catalyst::Plugin::StackTrace' => '0.11',
    'Catalyst::Plugin::Unicode' => '0.93',
    'Catalyst::Runtime' => '5.80032',
    'Catalyst::View::TT' => '0.36',
    'Catalyst::View::Tenjin' => '0.050001',
    'Class::C3' => '0.23',
    'Class::C3::XS' => '0.13',
    'Class::MOP' => '2.0010',
    'Class::XSAccessor' => '1.11',
    'Clipboard' => '0.13',
    'Compress::Raw::Bzip2' => '2.036',
    'Compress::Raw::Zlib' => '2.036',
    'Compress::Zlib' => '2.036',
    'Config::Any' => '0.21',
    'Config::GitLike' => '1.05',
    'Coro' => '5.372',
    'Crypt::Eksblowfish::Bcrypt' => '0.009',
    'Crypt::SSLeay' => '0.58',
    'DBD::SQLite' => '1.33',
    'DBD::mysql' => '4.019',
    'DBI' => '1.616',
    'DBICx::DataDictionary' => '0.002',
    'DBICx::Indexing' => '0.002',
    'DBICx::Shortcuts' => '0.007',
    'DBIx::Class' => '0.08192',
    'DBIx::Class::Candy' => '0.002000',
    'DBIx::Class::DeploymentHandler' => '0.001005',
    'DBIx::Class::EncodedColumn' => '0.00011',
    'DBIx::Class::Helpers' => '2.007000',
    'DBIx::Class::InflateColumn::Currency' => '0.02005',
    'DBIx::Class::InflateColumn::URI' => '0.01002',
    'DBIx::Class::Schema::Loader' => '0.07010',
    'DBIx::Class::TimeStamp' => '0.14',
    'DBIx::Connector' => '0.45',
    'Data::Dump' => '1.19',
    'Data::Dumper' => '2.131',
    'Data::ObjectDriver' => '0.09',
    'Date::Manip' => '6.24',
    'Date::Tiny' => '1.04',
    'DateTime' => '0.70',
    'DateTime::Format::DateParse' => '0.05',
    'DateTime::Format::Excel' => '0.31',
    'DateTime::Format::MySQL' => '0.04',
    'DateTime::Format::SQLite' => '0.11',
    'Devel::BeginLift' => '0.001003',
    'Devel::Cover' => '0.78',
    'Devel::Cycle' => '1.11',
    'Devel::LeakGuard::Object' => '0.06',
    'Devel::NYTProf' => '4.06',
    'Devel::REPL' => '1.003012',
    'Devel::StackTrace' => '1.27',
    'Devel::StackTrace::WithLexicals' => '0.10',
    'Devel::TraceUse' => '2.05',
    'Digest::SHA' => '5.62',
    'Digest::SHA1' => '2.13',
    'Dist::Zilla' => '4.200007',
    'Dist::Zilla::App::Command::cover' => '1.101000',
    'Dist::Zilla::Plugin::CheckChangeLog' => '0.01',
    'Dist::Zilla::Plugin::CompileTests' => '1.110930',
    'Dist::Zilla::Plugin::EOLTests' => '0.02',
    'Dist::Zilla::Plugin::Git' => '1.111590',
    'Dist::Zilla::Plugin::Git::NextVersion' => '1.111590',
    'Dist::Zilla::Plugin::InstallGuide' => '1.101461',
    'Dist::Zilla::Plugin::LatestPrereqs' => '0.4',
    'Dist::Zilla::Plugin::NoTabsTests' => '0.01',
    'Dist::Zilla::Plugin::PodPurler' => '0.093400',
    'Dist::Zilla::Plugin::PodWeaver' => '3.101641',
    'Dist::Zilla::PluginBundle::Git' => '1.111590',
    'EV' => '4.03',
    'Email::Abstract' => '3.004',
    'Email::Simple' => '2.100',
    'ExtUtils::CBuilder' => '0.280202',
    'ExtUtils::MakeMaker' => '6.56',
    'FCGI' => '0.73',
    'FCGI::Client' => '0.06',
    'FCGI::ProcManager' => '0.19',
    'File::ChangeNotify' => '0.20',
    'File::HomeDir' => '0.97',
    'File::HomeDir::PathClass' => '1.101611',
    'File::MMagic' => '1.27',
    'File::Spec' => '3.33',
    'File::Temp' => '0.22',
    'File::Which' => '1.09',
    'GD' => '2.46',
    'Gearman::Client' => '1.11',
    'Gearman::Worker' => '0',
    'Getopt::Long' => '2.38',
    'Github::Import' => '0.07',
    'Graph::Easy' => '0.70',
    'GraphViz' => '2.04',
    'Guard' => '1.021',
    'HTML::Mason' => '1.45',
    'HTML::Template::Expr' => '0.07',
    'HTML::Template::JIT' => '0.05',
    'HTML::Template::Pro' => '0.9504',
    'HTTP::Headers' => '6.00',
    'HTTP::Parser' => '0.06',
    'HTTP::Parser::XS' => '0.14',
    'HTTP::Tiny' => '0.012',
    'IO::AIO' => '3.9',
    'IO::All' => '0.41',
    'IO::Compress::Base' => '2.036',
    'IO::Handle::Util' => '0.01',
    'IO::Socket::SSL' => '1.44',
    'IO::Uncompress::Gunzip' => '2.036',
    'IO::Zlib' => '1.10',
    'Image::Size' => '3.230',
    'JSON::XS' => '2.3',
    'KiokuDB' => '0.51',
    'KiokuDB::Backend::DBI' => '1.20',
    'KiokuDB::Backend::Redis' => '0.02',
    'LWP::Protocol::https' => '6.02',
    'LWP::Simple' => '6.00',
    'Log::Any' => '0.12',
    'Log::Any::Adapter' => '0.03',
    'Log::Any::Adapter::Log4perl' => '0.06',
    'Log::Log4perl' => '1.33',
    'MIME::Base64' => '3.09',
    'MIME::Entity' => '5.502',
    'MIME::Lite' => '3.027',
    'MIME::Parser' => '5.502',
    'MIME::WordDecoder' => '0',
    'Mac::Carbon' => '0.82',
    'Mac::FSEvents' => '0.04',
    'Mac::Glue' => '1.30',
    'Mac::Growl' => '0.67',
    'Mail::Address' => '2.08',
    'Mail::IMAPClient' => '3.28',
    'Markapl' => '0.13',
    'Method::Signatures' => '20100730',
    'Modern::Perl' => '1.03',
    'Module::Build' => '0.3800',
    'Module::CoreList' => '2.51',
    'Module::Info' => '0.32',
    'Module::Install' => '1.01',
    'Module::Install::AuthorTests' => '0.002',
    'Module::Install::AutoManifest' => '0.003',
    'Module::Install::ProvidesClass' => '1.000000',
    'Module::Install::ReadmeFromPod' => '0.12',
    'Module::Install::Repository' => '0.06',
    'Module::Install::XSUtil' => '0.37',
    'Module::Which' => '0.0207',
    'Mojo' => '0',
    'Moose' => '2.0010',
    'MooseX::Aliases' => '0.10',
    'MooseX::AttributeHelpers' => '0.23',
    'MooseX::ConfigFromFile' => '0.03',
    'MooseX::Declare' => '0.34',
    'MooseX::Getopt' => '0.37',
    'MooseX::Has::Sugar' => '0.05070419',
    'MooseX::LazyRequire' => '0.07',
    'MooseX::Method::Signatures' => '0.36',
    'MooseX::MethodAttributes' => '0.25',
    'MooseX::MultiMethods' => '0.10',
    'MooseX::Role::WithOverloading' => '0.09',
    'MooseX::StrictConstructor' => '0.16',
    'MooseX::Traits' => '0.11',
    'MooseX::Types' => '0.27',
    'MooseX::Types::DateTime' => '0.05',
    'Mozilla::CA' => '20110409',
    'NTS::Template' => '2.1',
    'Net::Bonjour' => '0.96',
    'Net::Cmd' => '2.29',
    'Net::DNS' => '0.66',
    'Net::FTP' => '2.77',
    'Net::Rendezvous' => '0.92',
    'Net::Rendezvous::Publish::Backend::Apple' => '0.02',
    'Net::SMTP' => '2.31',
    'Net::SMTP::TLS' => '0.12',
    'Object::Event' => '1.22',
    'POE' => '1.311',
    'POE::XS::Queue::Array' => '0.006',
    'PPI' => '1.215',
    'PPI::HTML' => '1.08',
    'Package::Stash' => '0.29',
    'Package::Stash::XS' => '0.22',
    'Parallel::Prefork' => '0.11',
    'Params::Coerce' => '0.14',
    'Parse::CPAN::Meta' => '1.4401',
    'Parse::RecDescent' => '1.965001',
    'Path::Class' => '0.24',
    'Perl::Critic' => '1.116',
    'Perl::Tidy' => '20101217',
    'Plack::Middleware::Debug' => '0.12',
    'Plack::Middleware::Debug::DBIC::QueryLog' => '0.06',
    'Plack::Middleware::Debug::DBIProfile' => '0.102',
    'Plack::Server::AnyEvent' => '0.04',
    'Plack::Server::ReverseHTTP' => '0.03',
    'Pod::Coverage::TrustPod' => '0.100000',
    'Pod::Elemental' => '0.102360',
    'Pod::POM::Web' => '1.17',
    'Pod::PseudoPod' => '0.16',
    'Redis' => '1.904',
    'Scalar::Util' => '1.23',
    'Server::Starter' => '0.11',
    'Spreadsheet::ParseExcel' => '0.59',
    'Spreadsheet::WriteExcel' => '2.37',
    'String::CRC32' => '1.4',
    'String::FriendlyID' => '0.018',
    'TAP::Formatter::HTML' => '0.09',
    'TAP::Formatter::TextMate' => '0.1',
    'Task::Kensho' => '0.31',
    'Task::Moose' => '0.03',
    'Task::Plack' => '0.25',
    'Template' => '2.22',
    'Template::Alloy' => '1.016',
    'Template::Declare' => '0.45',
    'Template::Parser::CET' => '0.05',
    'Template::Sandbox' => '1.04',
    'Template::Tiny' => '1.12',
    'Tenjin' => '0.070001',
    'Term::ProgressBar' => '2.09',
    'Term::ReadKey' => '2.30',
    'Term::ReadLine::Gnu' => '1.20',
    'Term::ReadLine::Perl' => '1.0303',
    'Test::Base' => '0.60',
    'Test::CPAN::Meta' => '0.18',
    'Test::Compile' => '0.13',
    'Test::Continuous' => '0.70',
    'Test::Deep' => '0.108',
    'Test::Exception' => '0.31',
    'Test::Fatal' => '0.006',
    'Test::Harness' => '3.23',
    'Test::Inline::Extract' => '2.212',
    'Test::Kit' => '0.101',
    'Test::More' => '0.98',
    'Test::Output' => '1.01',
    'Test::Reporter' => '1.57',
    'Test::Reporter::Transport::Metabase' => '1.999008',
    'Test::TCP' => '1.13',
    'Test::WWW::Mechanize::Catalyst' => '0.53',
    'Text::Autoformat' => '1.669002',
    'Text::ClearSilver' => '0.010005004',
    'Text::Glob' => '0.09',
    'Text::Markdown' => '1.000031',
    'Text::MicroMason' => '2.13',
    'Text::MultiMarkdown' => '1.000034',
    'Text::ParseWords' => '3.27',
    'Text::Template::Simple' => '0.83',
    'Text::Textile' => '2.12',
    'Text::Tmpl' => '0.33',
    'Text::Unaccent' => '1.08',
    'Text::Wrap' => '2009.0305',
    'Text::Xslate' => '1.3000',
    'TextMate::JumpTo' => '0.07',
    'Throwable::X' => '0.006',
    'Tie::IxHash' => '1.22',
    'Time::ParseDate' => '2011.0517',
    'Time::y2038' => '20100403',
    'TryCatch' => '1.003000',
    'Twiggy' => '0.1010',
    'URI' => '1.58',
    'URI::Escape' => '3.30',
    'URI::Find' => '20100505',
    'Unicode::String' => '2.09',
    'Unicode::Stringprep' => '1.103',
    'Web::Scraper' => '0.34',
    'XML::Feed' => '0.43',
    'XML::LibXML' => '1.73',
    'XML::Parser::Expat' => '2.41',
    'XML::XPath' => '1.13',
    'XS::Assert' => '0.002',
    'YAML' => '0.73',
    'aliased' => '0.30',
    'autodie' => '2.10',
    'local::lib' => '1.008004',
    'namespace::autoclean' => '0.12',
    'namespace::clean' => '0.20',
    'version' => '0.91'
  },
  'VERSION' => '0.006',
  'test' => {
    'TESTS' => ''
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



