
use strict;
use warnings;



use ExtUtils::MakeMaker 6.31;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'All the stuff I install with a fresh perl',
  'AUTHOR' => 'Pedro Melo <melo@cpan.org>',
  'BUILD_REQUIRES' => {},
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.31'
  },
  'DISTNAME' => 'Task-BeLike-MELO',
  'EXE_FILES' => [],
  'LICENSE' => 'artistic_2',
  'NAME' => 'Task::BeLike::MELO',
  'PREREQ_PM' => {
    'Algorithm::C3' => '0.08',
    'AnyEvent' => '5.271',
    'AnyEvent::AIO' => '1.1',
    'AnyEvent::Gearman' => '0.08',
    'AnyEvent::HTTP' => '1.46',
    'AnyEvent::HTTPD' => '0.84',
    'AnyEvent::Redis' => '0.12',
    'AnyEvent::Twitter::Stream' => '0.16',
    'AnyEvent::XMPP' => '0.51',
    'AnyMQ' => '0.31',
    'App::Ack' => '1.92',
    'App::BashComplete' => '0.001',
    'App::Genpass' => '1.01',
    'App::HTTPThis' => '0.002',
    'App::Nopaste' => '0.22',
    'App::SD' => '0.74',
    'App::cpanminus' => '1.0012',
    'App::cpanoutdated' => '0.11',
    'App::perlbrew' => '0.10',
    'Archive::Tar' => '1.68',
    'Archive::Zip' => '1.30',
    'Async::Hooks' => '0.05',
    'Authen::Simple::Passwd' => '0.6',
    'CGI::Emulate::PSGI' => '0.10',
    'CGI::Fast' => '1.08',
    'CHI' => '0.36',
    'CPAN' => '1.9402',
    'CPAN::Mini' => '1.100630',
    'CPAN::Mini::Webserver' => '0.45',
    'CPAN::Reporter' => '1.1800',
    'CPAN::SQLite' => '0.199',
    'CSS::Minifier' => '0.01',
    'Cache::CacheFactory' => '1.10',
    'Carp::Always' => '0.09',
    'Catalyst::Devel' => '1.28',
    'Catalyst::Engine::PSGI' => '0.11',
    'Catalyst::Plugin::Authentication' => '0.10016',
    'Catalyst::Plugin::Dumper' => '0.00005',
    'Catalyst::Plugin::Session' => '0.30',
    'Catalyst::Plugin::Session::State::Cookie' => '0.17',
    'Catalyst::Plugin::Session::Store::FastMmap' => '0.13',
    'Catalyst::Plugin::StackTrace' => '0.11',
    'Catalyst::Plugin::Unicode' => '0.93',
    'Catalyst::Runtime' => '5.80027',
    'Catalyst::View::TT' => '0.35',
    'Catalyst::View::Tenjin' => '0.042',
    'Class::C3' => '0.23',
    'Class::C3::XS' => '0.13',
    'Class::MOP' => '1.07',
    'Class::XSAccessor' => '1.07',
    'Clipboard' => '0.09',
    'Compress::Raw::Bzip2' => '2.030',
    'Compress::Raw::Zlib' => '2.030',
    'Compress::Zlib' => '2.030',
    'Config::Any' => '0.20',
    'Coro' => '5.23',
    'Crypt::Eksblowfish::Bcrypt' => '0.008',
    'DBD::SQLite' => '1.29',
    'DBD::mysql' => '4.017',
    'DBI' => '1.613',
    'DBICx::DataDictionary' => '0.002',
    'DBICx::Indexing' => '0.002',
    'DBICx::Shortcuts' => '0.007',
    'DBIx::Class' => '0.08123',
    'DBIx::Class::Candy' => '0.001004',
    'DBIx::Class::DeploymentHandler' => '0.001004',
    'DBIx::Class::EncodedColumn' => '0.00010',
    'DBIx::Class::Helpers' => '2.004000',
    'DBIx::Class::InflateColumn::Currency' => '0.02005',
    'DBIx::Class::InflateColumn::URI' => '0.01002',
    'DBIx::Class::Schema::Loader' => '0.07001',
    'DBIx::Connector' => '0.35',
    'Data::Dump' => '1.17',
    'Data::Dumper' => '2.126',
    'Data::ObjectDriver' => '0.07',
    'Date::Manip' => '6.11',
    'Date::Tiny' => '1.04',
    'DateTime' => '0.61',
    'DateTime::Format::DateParse' => '0.05',
    'DateTime::Format::Excel' => '0.30',
    'DateTime::Format::MySQL' => '0.04',
    'Devel::BeginLift' => '0.001003',
    'Devel::Cover' => '0.70',
    'Devel::Cycle' => '1.11',
    'Devel::LeakGuard::Object' => '0.06',
    'Devel::NYTProf' => '4.04',
    'Devel::REPL' => '1.003011',
    'Devel::StackTrace' => '1.25',
    'Devel::StackTrace::WithLexicals' => '0.06',
    'Devel::TraceUse' => '2.02',
    'Digest::SHA' => '5.48',
    'Digest::SHA1' => '2.13',
    'Dist::Zilla' => '4.102340',
    'Dist::Zilla::App::Command::cover' => '1.101000',
    'Dist::Zilla::Plugin::BumpVersionFromGit' => '0.007',
    'Dist::Zilla::Plugin::CheckChangeLog' => '0.01',
    'Dist::Zilla::Plugin::CompileTests' => '1.101800',
    'Dist::Zilla::Plugin::EOLTests' => '0.02',
    'Dist::Zilla::Plugin::Git' => '1.102430',
    'Dist::Zilla::Plugin::InstallGuide' => '1.101461',
    'Dist::Zilla::Plugin::LatestPrereqs' => '0.3',
    'Dist::Zilla::Plugin::NoTabsTests' => '0.01',
    'Dist::Zilla::Plugin::PodPurler' => '0.093400',
    'Dist::Zilla::Plugin::PodWeaver' => '3.101640',
    'Dist::Zilla::PluginBundle::Git' => '1.102430',
    'EV' => '3.9',
    'Email::Abstract' => '3.002',
    'Email::Simple' => '2.100',
    'ExtUtils::CBuilder' => '0.2703',
    'ExtUtils::MakeMaker' => '6.56',
    'FCGI' => '0.71',
    'FCGI::Client' => '0.05',
    'FCGI::ProcManager' => '0.19',
    'File::ChangeNotify' => '0.16',
    'File::HomeDir' => '0.91',
    'File::HomeDir::PathClass' => '1.101611',
    'File::Spec' => '3.31',
    'File::Temp' => '0.22',
    'File::Which' => '1.09',
    'GD' => '2.45',
    'Getopt::Long' => '2.38',
    'Github::Import' => '0.06',
    'GraphViz' => '2.04',
    'Guard' => '1.021',
    'HTML::Mason' => '1.45',
    'HTML::Template::Compiled' => '0.94',
    'HTML::Template::Expr' => '0.07',
    'HTML::Template::JIT' => '0.05',
    'HTML::Template::Pro' => '0.9503',
    'HTTP::Headers' => '5.835',
    'HTTP::Parser' => '0.05',
    'HTTP::Parser::XS' => '0.09',
    'IO::AIO' => '3.65',
    'IO::All' => '0.41',
    'IO::Compress::Base' => '2.030',
    'IO::Handle::Util' => '0.01',
    'IO::Uncompress::Gunzip' => '2.030',
    'IO::Zlib' => '1.10',
    'JSON::XS' => '2.3',
    'KiokuDB' => '0.49',
    'KiokuDB::Backend::DBI' => '1.15',
    'KiokuDB::Backend::Redis' => '0.02',
    'LWP::Simple' => '5.835',
    'Log::Dispatch::DesktopNotification' => '0.01',
    'Log::Log4perl' => '1.30',
    'MIME::Entity' => '5.428',
    'MIME::Lite' => '3.027',
    'MIME::Parser' => '5.428',
    'MIME::WordDecoder' => '0',
    'Mac::Carbon' => '0.82',
    'Mac::FSEvents' => '0.04',
    'Mac::Glue' => '1.30',
    'Mac::Growl' => '0.67',
    'Mail::Address' => '2.06',
    'Mail::IMAPClient' => '3.25',
    'Markapl' => '0.11',
    'Method::Signatures' => '20100730',
    'Modern::Perl' => '1.03',
    'Module::Build' => '0.3607',
    'Module::CoreList' => '2.38',
    'Module::Info' => '0.32',
    'Module::Install' => '1.00',
    'Module::Install::AuthorTests' => '0.002',
    'Module::Install::AutoManifest' => '0.003',
    'Module::Install::ProvidesClass' => '1.000000',
    'Module::Install::ReadmeFromPod' => '0.10',
    'Module::Install::Repository' => '0.06',
    'Module::Install::XSUtil' => '0.27',
    'Mojo' => '0.999929',
    'Moose' => '1.12',
    'MooseX::Aliases' => '0.08',
    'MooseX::AttributeHelpers' => '0.23',
    'MooseX::ConfigFromFile' => '0.02',
    'MooseX::Declare' => '0.34',
    'MooseX::Getopt' => '0.33',
    'MooseX::Has::Sugar' => '0.05046611',
    'MooseX::LazyRequire' => '0.06',
    'MooseX::Method::Signatures' => '0.36',
    'MooseX::MethodAttributes' => '0.24',
    'MooseX::MultiMethods' => '0.10',
    'MooseX::Role::WithOverloading' => '0.08',
    'MooseX::StrictConstructor' => '0.11',
    'MooseX::Traits' => '0.11',
    'MooseX::Types' => '0.23',
    'MooseX::Types::DateTime' => '0.05',
    'NTS::Template' => '2.1',
    'Net::Bonjour' => '0.96',
    'Net::Cmd' => '2.29',
    'Net::DNS' => '0.66',
    'Net::FTP' => '2.77',
    'Net::Rendezvous' => '0.92',
    'Net::Rendezvous::Publish::Backend::Apple' => '0.02',
    'Net::SMTP' => '2.31',
    'Net::SMTP::TLS' => '0.12',
    'Object::Event' => '1.21',
    'POE' => '1.293',
    'POE::XS::Queue::Array' => '0.006',
    'PPI' => '1.213',
    'PPI::HTML' => '1.08',
    'Parallel::Prefork' => '0.08',
    'Params::Coerce' => '0.14',
    'Parse::CPAN::Meta' => '1.40',
    'Parse::RecDescent' => '1.965001',
    'Path::Class' => '0.21',
    'Perl::Critic' => '1.109',
    'Perl::Tidy' => '20090616',
    'Plack::Middleware::Debug' => '0.10',
    'Plack::Server::AnyEvent' => '0.04',
    'Plack::Server::ReverseHTTP' => '0.03',
    'Pod::Coverage::TrustPod' => '0.092830',
    'Pod::POM::Web' => '1.14',
    'Redis' => '1.2001',
    'Scalar::Util' => '1.23',
    'Server::Starter' => '0.07',
    'Sphinx::Search' => '0.22',
    'Spreadsheet::ParseExcel' => '0.57',
    'Spreadsheet::WriteExcel' => '2.37',
    'String::CRC32' => '1.4',
    'String::FriendlyID' => '0.018',
    'TAP::Formatter::HTML' => '0.09',
    'Task::Plack' => '0.25',
    'Template' => '2.22',
    'Template::Alloy' => '1.013',
    'Template::Declare' => '0.43',
    'Template::Parser::CET' => '0.05',
    'Template::Sandbox' => '1.04',
    'Template::Tiny' => '0.11',
    'Tenjin' => '0.062',
    'Term::ReadKey' => '2.30',
    'Term::ReadLine::Gnu' => '1.20',
    'Term::ReadLine::Perl' => '1.0303',
    'Test::Base' => '0.59',
    'Test::CPAN::Meta' => '0.17',
    'Test::Compile' => '0.13',
    'Test::Continuous' => '0.69',
    'Test::Deep' => '0.106',
    'Test::Exception' => '0.29',
    'Test::Harness' => '3.22',
    'Test::Inline::Extract' => '2.211',
    'Test::More' => '0.96',
    'Test::Output' => '0.16',
    'Test::Reporter' => '1.57',
    'Test::Reporter::Transport::Metabase' => '1.999008',
    'Test::TCP' => '1.04',
    'Test::WWW::Mechanize::Catalyst' => '0.52',
    'Text::Autoformat' => '1.669002',
    'Text::ClearSilver' => '0.010005004',
    'Text::Glob' => '0.08',
    'Text::Markdown' => '1.000031',
    'Text::MicroMason' => '2.12',
    'Text::MultiMarkdown' => '1.000033',
    'Text::ParseWords' => '3.27',
    'Text::Template::Simple' => '0.82',
    'Text::Textile' => '2.12',
    'Text::Tmpl' => '0.33',
    'Text::Unaccent' => '1.08',
    'Text::Wrap' => '2009.0305',
    'Text::Xslate' => '0.2003',
    'TextMate::JumpTo' => '0.07',
    'Tie::IxHash' => '1.22',
    'Time::ParseDate' => '2006.0814',
    'Time::y2038' => '20100403',
    'TryCatch' => '1.002000',
    'Twiggy' => '0.1006',
    'URI' => '1.55',
    'URI::Escape' => '3.30',
    'URI::Find' => '20100505',
    'Unicode::String' => '2.09',
    'Unicode::Stringprep' => '1.103',
    'Web::Scraper' => '0.32',
    'XML::Feed' => '0.43',
    'XML::LibXML' => '1.70',
    'XML::Parser::Expat' => '2.36',
    'XML::XPath' => '1.13',
    'XS::Assert' => '0.002',
    'YAML' => '0.72',
    'aliased' => '0.30',
    'autodie' => '2.10',
    'local::lib' => '1.006007',
    'namespace::autoclean' => '0.11',
    'namespace::clean' => '0.18',
    'version' => '0.82'
  },
  'VERSION' => '0.002',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



