#########################################################################################
# Package        HiPi::Interface::MonoOLED::Font::Serif11
# Description  : Monochrome OLED Font
# License      : This is free software; you can redistribute it and/or modify it under
#                the same terms as the Perl 5 programming language system itself.
#########################################################################################

package HiPi::Interface::MonoOLED::Font::Serif11;

#########################################################################################

use utf8;
use strict;
use warnings;
use parent qw( HiPi::Interface::MonoOLED::Font);

our $VERSION ='0.70';

my $gap_width = 0;
my $char_height = 11;
my $line_spacing = 1;
my $name = 'Serif 11';
my $space_width = 3;
 
my $symbols = {
    '33' => {    # '!'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x00, ##    
            0xC0, ##  00
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '34' => {    # '"'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0xA0, ##  0 0
            0xA0, ##  0 0
            0xA0, ##  0 0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '35' => {    # '#'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x24, ##    0  0 
            0x28, ##    0 0  
            0xFE, ##  0000000
            0x48, ##   0  0  
            0xFC, ##  000000 
            0x50, ##   0 0   
            0x50, ##   0 0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '36' => {    # '$'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x20, ##    0  
            0x70, ##   000 
            0xA8, ##  0 0 0
            0xE0, ##  000  
            0x38, ##    000
            0xA8, ##  0 0 0
            0xF8, ##  00000
            0x20, ##    0  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '37' => {    # '%'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xE2, 0x00, ##  000   0  
            0xA4, 0x00, ##  0 0  0   
            0xA8, 0x00, ##  0 0 0    
            0x4B, 0x00, ##   0  0 00 
            0x14, 0x80, ##     0 0  0
            0x24, 0x80, ##    0  0  0
            0x03, 0x00, ##        00 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '38' => {    # '&'
        'width'    => 8, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x38, ##    000   
            0x48, ##   0  0   
            0x60, ##   00     
            0x77, ##   000 000
            0x9A, ##  0  00 0 
            0x8C, ##  0   00  
            0x7E, ##   000000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '39' => {    # '''
        'width'    => 1, 
        'xoffset'  => 1, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '40' => {    # '('
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 4, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x40, ##   0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '41' => {    # ')'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 4, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0 
            0x80, ##  0 
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x80, ##  0 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '42' => {    # '*'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x20, ##    0  
            0xF8, ##  00000
            0x70, ##   000 
            0xA8, ##  0 0 0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '43' => {    # '+'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x10, ##     0   
            0x10, ##     0   
            0x10, ##     0   
            0xFE, ##  0000000
            0x10, ##     0   
            0x10, ##     0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '44' => {    # ','
        'width'    => 2, 
        'xoffset'  => 0, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x40, ##   0
            0x40, ##   0
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '45' => {    # '-'
        'width'    => 3, 
        'xoffset'  => 0, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '46' => {    # '.'
        'width'    => 1, 
        'xoffset'  => 1, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '47' => {    # '/'
        'width'    => 3, 
        'xoffset'  => 0, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x40, ##   0 
            0x40, ##   0 
            0x80, ##  0  
            0x80, ##  0  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '48' => {    # '0'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x70, ##   000 
            0x88, ##  0   0
            0x88, ##  0   0
            0x88, ##  0   0
            0x88, ##  0   0
            0x88, ##  0   0
            0x70, ##   000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '49' => {    # '1'
        'width'    => 3, 
        'xoffset'  => 2, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '50' => {    # '2'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0xE0, ##  000 
            0x10, ##     0
            0x10, ##     0
            0x20, ##    0 
            0x40, ##   0  
            0x80, ##  0   
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '51' => {    # '3'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xF0, ##  0000 
            0x88, ##  0   0
            0x08, ##      0
            0x30, ##    00 
            0x08, ##      0
            0x88, ##  0   0
            0xF0, ##  0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '52' => {    # '4'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x10, ##     0 
            0x30, ##    00 
            0x50, ##   0 0 
            0x90, ##  0  0 
            0xF8, ##  00000
            0x10, ##     0 
            0x10, ##     0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '53' => {    # '5'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0xE0, ##  000 
            0x80, ##  0   
            0xE0, ##  000 
            0x10, ##     0
            0x10, ##     0
            0x10, ##     0
            0xE0, ##  000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '54' => {    # '6'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x78, ##   0000
            0x80, ##  0    
            0xB0, ##  0 00 
            0xC8, ##  00  0
            0x88, ##  0   0
            0x88, ##  0   0
            0x70, ##   000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '55' => {    # '7'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xF8, ##  00000
            0x88, ##  0   0
            0x10, ##     0 
            0x10, ##     0 
            0x20, ##    0  
            0x20, ##    0  
            0x40, ##   0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '56' => {    # '8'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x70, ##   000 
            0x88, ##  0   0
            0x88, ##  0   0
            0x70, ##   000 
            0xC8, ##  00  0
            0x88, ##  0   0
            0x70, ##   000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '57' => {    # '9'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x70, ##   000 
            0x88, ##  0   0
            0x88, ##  0   0
            0x88, ##  0   0
            0x78, ##   0000
            0x08, ##      0
            0xF0, ##  0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '58' => {    # ':'
        'width'    => 1, 
        'xoffset'  => 1, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x80, ##  0
            0x00, ##   
            0x00, ##   
            0x80, ##  0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '59' => {    # ';'
        'width'    => 2, 
        'xoffset'  => 0, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x40, ##   0
            0x00, ##    
            0x00, ##    
            0x40, ##   0
            0x40, ##   0
            0x80, ##  0 
            0x00, ##  
        ], 
    }, 
    '60' => {    # '<'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x0C, ##      00 
            0x70, ##   000   
            0xE0, ##  000    
            0x1C, ##     000 
            0x02, ##        0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '61' => {    # '='
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xFC, ##  000000
            0x00, ##        
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '62' => {    # '>'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000    
            0x1C, ##     000 
            0x0C, ##      00 
            0x70, ##   000   
            0x80, ##  0      
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '63' => {    # '?'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0xE0, ##  000 
            0x10, ##     0
            0x10, ##     0
            0x60, ##   00 
            0x40, ##   0  
            0x00, ##      
            0x40, ##   0  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '64' => {    # '@'
        'width'    => 9, 
        'xoffset'  => 1, 
        'xadvance' => 11, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x1C, 0x00, ##     000   
            0x63, 0x00, ##   00   00 
            0x98, 0x80, ##  0  00   0
            0xA6, 0x80, ##  0 0  00 0
            0xA2, 0x80, ##  0 0   0 0
            0xA2, 0x80, ##  0 0   0 0
            0x5F, 0x00, ##   0 00000 
            0x40, 0x00, ##   0       
            0x3C, 0x00, ##    0000   
            0x00, 0x00, ##  
        ], 
    }, 
    '65' => {    # 'A'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x10, ##     0   
            0x28, ##    0 0  
            0x28, ##    0 0  
            0x48, ##   0  0  
            0x7C, ##   00000 
            0x44, ##   0   0 
            0x86, ##  0    00
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '66' => {    # 'B'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xF8, ##  00000 
            0x44, ##   0   0
            0x44, ##   0   0
            0x78, ##   0000 
            0x44, ##   0   0
            0x44, ##   0   0
            0x78, ##   0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '67' => {    # 'C'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x3C, ##    0000 
            0xC2, ##  00    0
            0x80, ##  0      
            0x80, ##  0      
            0x80, ##  0      
            0xC2, ##  00    0
            0x3C, ##    0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '68' => {    # 'D'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0xF8, ##  00000  
            0x44, ##   0   0 
            0x42, ##   0    0
            0x42, ##   0    0
            0x42, ##   0    0
            0x44, ##   0   0 
            0x78, ##   0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '69' => {    # 'E'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xFC, ##  000000
            0x44, ##   0   0
            0x48, ##   0  0 
            0x78, ##   0000 
            0x40, ##   0    
            0x44, ##   0   0
            0x7C, ##   00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '70' => {    # 'F'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xFC, ##  000000
            0x44, ##   0   0
            0x48, ##   0  0 
            0x78, ##   0000 
            0x40, ##   0    
            0x40, ##   0    
            0x40, ##   0    
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '71' => {    # 'G'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x3E, ##    00000
            0x42, ##   0    0
            0x80, ##  0      
            0x8E, ##  0   000
            0x82, ##  0     0
            0x42, ##   0    0
            0x3C, ##    0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '72' => {    # 'H'
        'width'    => 8, 
        'xoffset'  => 0, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0xE7, ##  000  000
            0x42, ##   0    0 
            0x42, ##   0    0 
            0x7E, ##   000000 
            0x42, ##   0    0 
            0x42, ##   0    0 
            0x42, ##   0    0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '73' => {    # 'I'
        'width'    => 3, 
        'xoffset'  => 0, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0xE0, ##  000
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '74' => {    # 'J'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 4, 
        'bitmap'   => [ 
            0x00, ##  
            0x70, ##   000
            0x20, ##    0 
            0x20, ##    0 
            0x20, ##    0 
            0x20, ##    0 
            0x20, ##    0 
            0x20, ##    0 
            0x20, ##    0 
            0xC0, ##  00  
            0x00, ##  
        ], 
    }, 
    '75' => {    # 'K'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xEE, ##  000 000
            0x48, ##   0  0  
            0x50, ##   0 0   
            0x60, ##   00    
            0x50, ##   0 0   
            0x48, ##   0  0  
            0x44, ##   0   0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '76' => {    # 'L'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xE0, ##  000   
            0x40, ##   0    
            0x40, ##   0    
            0x40, ##   0    
            0x40, ##   0    
            0x44, ##   0   0
            0x7C, ##   00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '77' => {    # 'M'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xE1, 0x80, ##  000    00
            0x63, 0x00, ##   00   00 
            0x55, 0x00, ##   0 0 0 0 
            0x55, 0x00, ##   0 0 0 0 
            0x59, 0x00, ##   0 00  0 
            0x49, 0x00, ##   0  0  0 
            0x41, 0x00, ##   0     0 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '78' => {    # 'N'
        'width'    => 8, 
        'xoffset'  => 0, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0xE7, ##  000  000
            0x62, ##   00   0 
            0x52, ##   0 0  0 
            0x4A, ##   0  0 0 
            0x4A, ##   0  0 0 
            0x46, ##   0   00 
            0x42, ##   0    0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '79' => {    # 'O'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x38, ##    000  
            0xC4, ##  00   0 
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0xC4, ##  00   0 
            0x38, ##    000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '80' => {    # 'P'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xF8, ##  00000 
            0x44, ##   0   0
            0x44, ##   0   0
            0x78, ##   0000 
            0x40, ##   0    
            0x40, ##   0    
            0x40, ##   0    
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '81' => {    # 'Q'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x38, ##    000  
            0xC4, ##  00   0 
            0x82, ##  0     0
            0x82, ##  0     0
            0x82, ##  0     0
            0xC4, ##  00   0 
            0x38, ##    000  
            0x0C, ##      00 
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '82' => {    # 'R'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xF8, ##  00000  
            0x44, ##   0   0 
            0x44, ##   0   0 
            0x78, ##   0000  
            0x48, ##   0  0  
            0x44, ##   0   0 
            0x44, ##   0   0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '83' => {    # 'S'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x78, ##   0000
            0x88, ##  0   0
            0x80, ##  0    
            0x70, ##   000 
            0x08, ##      0
            0x88, ##  0   0
            0xF0, ##  0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '84' => {    # 'T'
        'width'    => 7, 
        'xoffset'  => 1, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0xFE, ##  0000000
            0x92, ##  0  0  0
            0x10, ##     0   
            0x10, ##     0   
            0x10, ##     0   
            0x10, ##     0   
            0x10, ##     0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '85' => {    # 'U'
        'width'    => 8, 
        'xoffset'  => 0, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0xE7, ##  000  000
            0x42, ##   0    0 
            0x42, ##   0    0 
            0x42, ##   0    0 
            0x42, ##   0    0 
            0x42, ##   0    0 
            0x3C, ##    0000  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '86' => {    # 'V'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xE6, ##  000  00
            0x44, ##   0   0 
            0x64, ##   00  0 
            0x28, ##    0 0  
            0x28, ##    0 0  
            0x18, ##     00  
            0x10, ##     0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '87' => {    # 'W'
        'width'    => 10, 
        'xoffset'  => 0, 
        'xadvance' => 10, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0xE4, 0xC0, ##  000  0  00
            0x44, 0x80, ##   0   0  0 
            0x4A, 0x80, ##   0  0 0 0 
            0x2A, 0x80, ##    0 0 0 0 
            0x33, 0x00, ##    00  00  
            0x33, 0x00, ##    00  00  
            0x11, 0x00, ##     0   0  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '88' => {    # 'X'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xEE, ##  000 000
            0x28, ##    0 0  
            0x38, ##    000  
            0x10, ##     0   
            0x28, ##    0 0  
            0x4C, ##   0  00 
            0x44, ##   0   0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '89' => {    # 'Y'
        'width'    => 7, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xE6, ##  000  00
            0x64, ##   00  0 
            0x28, ##    0 0  
            0x10, ##     0   
            0x10, ##     0   
            0x10, ##     0   
            0x10, ##     0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '90' => {    # 'Z'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0xFC, ##  000000
            0x88, ##  0   0 
            0x10, ##     0  
            0x30, ##    00  
            0x20, ##    0   
            0x40, ##   0    
            0xFC, ##  000000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '91' => {    # '['
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 4, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0x80, ##  0 
            0xC0, ##  00
            0x00, ##  
        ], 
    }, 
    '92' => {    # '\'
        'width'    => 3, 
        'xoffset'  => 0, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0  
            0x80, ##  0  
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x20, ##    0
            0x20, ##    0
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '93' => {    # ']'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 4, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0x40, ##   0
            0xC0, ##  00
            0x00, ##  
        ], 
    }, 
    '94' => {    # '^'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x10, ##     0  
            0x38, ##    000 
            0x44, ##   0   0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '95' => {    # '_'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
        ], 
    }, 
    '96' => {    # '`'
        'width'    => 2, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x80, ##  0 
            0x40, ##   0
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '97' => {    # 'a'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE0, ##  000  
            0x90, ##  0  0 
            0x70, ##   000 
            0x90, ##  0  0 
            0xF0, ##  0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '98' => {    # 'b'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0    
            0x40, ##   0    
            0x78, ##   0000 
            0x44, ##   0   0
            0x44, ##   0   0
            0x44, ##   0   0
            0x78, ##   0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '99' => {    # 'c'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000 
            0x80, ##  0    
            0x80, ##  0    
            0x88, ##  0   0
            0x70, ##   000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '100' => {    # 'd'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x08, ##      0 
            0x08, ##      0 
            0x78, ##   0000 
            0x88, ##  0   0 
            0x88, ##  0   0 
            0x88, ##  0   0 
            0x78, ##   0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '101' => {    # 'e'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000 
            0x88, ##  0   0
            0xF8, ##  00000
            0x80, ##  0    
            0x70, ##   000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '102' => {    # 'f'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 4, 
        'bitmap'   => [ 
            0x00, ##  
            0x70, ##   000
            0x40, ##   0  
            0xE0, ##  000 
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '103' => {    # 'g'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000
            0x88, ##  0   0 
            0x88, ##  0   0 
            0x88, ##  0   0 
            0x78, ##   0000 
            0x08, ##      0 
            0xF0, ##  0000  
            0x00, ##  
        ], 
    }, 
    '104' => {    # 'h'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0    
            0x40, ##   0    
            0x78, ##   0000 
            0x48, ##   0  0 
            0x48, ##   0  0 
            0x48, ##   0  0 
            0x48, ##   0  0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '105' => {    # 'i'
        'width'    => 3, 
        'xoffset'  => 0, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0 
            0x00, ##     
            0xC0, ##  00 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '106' => {    # 'j'
        'width'    => 3, 
        'xoffset'  => -1, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x20, ##    0
            0x00, ##     
            0x60, ##   00
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0x20, ##    0
            0xE0, ##  000
            0x00, ##  
        ], 
    }, 
    '107' => {    # 'k'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0    
            0x40, ##   0    
            0x5C, ##   0 000
            0x50, ##   0 0  
            0x70, ##   000  
            0x58, ##   0 00 
            0x48, ##   0  0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '108' => {    # 'l'
        'width'    => 3, 
        'xoffset'  => 0, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x40, ##   0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '109' => {    # 'm'
        'width'    => 9, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0xFF, 0x00, ##  00000000 
            0x49, 0x00, ##   0  0  0 
            0x49, 0x00, ##   0  0  0 
            0x49, 0x00, ##   0  0  0 
            0x49, 0x00, ##   0  0  0 
            0x00, 0x00, ##  
            0x00, 0x00, ##  
            0x00, 0x00, ##  
        ], 
    }, 
    '110' => {    # 'n'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000 
            0x48, ##   0  0 
            0x48, ##   0  0 
            0x48, ##   0  0 
            0x48, ##   0  0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '111' => {    # 'o'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x70, ##   000 
            0x88, ##  0   0
            0x88, ##  0   0
            0x88, ##  0   0
            0x70, ##   000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '112' => {    # 'p'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000 
            0x44, ##   0   0
            0x44, ##   0   0
            0x44, ##   0   0
            0x78, ##   0000 
            0x40, ##   0    
            0x40, ##   0    
            0x00, ##  
        ], 
    }, 
    '113' => {    # 'q'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x7C, ##   00000
            0x88, ##  0   0 
            0x88, ##  0   0 
            0x88, ##  0   0 
            0x78, ##   0000 
            0x08, ##      0 
            0x08, ##      0 
            0x00, ##  
        ], 
    }, 
    '114' => {    # 'r'
        'width'    => 5, 
        'xoffset'  => 0, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF8, ##  00000
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x40, ##   0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '115' => {    # 's'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000
            0x80, ##  0   
            0x60, ##   00 
            0x90, ##  0  0
            0xF0, ##  0000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '116' => {    # 't'
        'width'    => 4, 
        'xoffset'  => 0, 
        'xadvance' => 4, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0  
            0x40, ##   0  
            0xF0, ##  0000
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x70, ##   000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '117' => {    # 'u'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xD8, ##  00 00 
            0x48, ##   0  0 
            0x48, ##   0  0 
            0x48, ##   0  0 
            0x78, ##   0000 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '118' => {    # 'v'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xCC, ##  00  00
            0x48, ##   0  0 
            0x50, ##   0 0  
            0x30, ##    00  
            0x20, ##    0   
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '119' => {    # 'w'
        'width'    => 8, 
        'xoffset'  => 0, 
        'xadvance' => 9, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xE9, ##  000 0  0
            0x49, ##   0  0  0
            0x56, ##   0 0 00 
            0x36, ##    00 00 
            0x24, ##    0  0  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '120' => {    # 'x'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xD8, ##  00 00 
            0x30, ##    00  
            0x20, ##    0   
            0x50, ##   0 0  
            0x48, ##   0  0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '121' => {    # 'y'
        'width'    => 6, 
        'xoffset'  => 0, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xCC, ##  00  00
            0x48, ##   0  0 
            0x50, ##   0 0  
            0x30, ##    00  
            0x20, ##    0   
            0x20, ##    0   
            0xC0, ##  00    
            0x00, ##  
        ], 
    }, 
    '122' => {    # 'z'
        'width'    => 5, 
        'xoffset'  => 1, 
        'xadvance' => 6, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0xF0, ##  0000 
            0x30, ##    00 
            0x20, ##    0  
            0x40, ##   0   
            0xF8, ##  00000
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '123' => {    # '{'
        'width'    => 4, 
        'xoffset'  => 1, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0x30, ##    00
            0x20, ##    0 
            0x20, ##    0 
            0x20, ##    0 
            0xC0, ##  00  
            0x20, ##    0 
            0x20, ##    0 
            0x20, ##    0 
            0x10, ##     0
            0x00, ##  
        ], 
    }, 
    '124' => {    # '|'
        'width'    => 1, 
        'xoffset'  => 1, 
        'xadvance' => 3, 
        'bitmap'   => [ 
            0x00, ##  
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x80, ##  0
            0x00, ##  
        ], 
    }, 
    '125' => {    # '}'
        'width'    => 4, 
        'xoffset'  => 2, 
        'xadvance' => 7, 
        'bitmap'   => [ 
            0x00, ##  
            0xC0, ##  00  
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x30, ##    00
            0x40, ##   0  
            0x40, ##   0  
            0x40, ##   0  
            0x80, ##  0   
            0x00, ##  
        ], 
    }, 
    '126' => {    # '~'
        'width'    => 6, 
        'xoffset'  => 1, 
        'xadvance' => 8, 
        'bitmap'   => [ 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x60, ##   00   
            0x9C, ##  0  000
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
    '176' => {    # '°'
        'width'    => 3, 
        'xoffset'  => 1, 
        'xadvance' => 5, 
        'bitmap'   => [ 
            0x00, ##  
            0x40, ##   0 
            0xA0, ##  0 0
            0x40, ##   0 
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
            0x00, ##  
        ], 
    }, 
};
 
my $kerning = {
    '33' => { },  # !
    '34' => { },  # "
    '35' => { },  # #
    '36' => { },  # $
    '37' => { },  # %
    '38' => { },  # &
    '39' => { },  # '
    '40' => { },  # (
    '41' => { },  # )
    '42' => { },  # *
    '43' => { },  # +
    '44' => { },  # ,
    '45' => { },  # -
    '46' => { },  # .
    '47' => { },  # /
    '48' => { },  # 0
    '49' => { },  # 1
    '50' => { },  # 2
    '51' => { },  # 3
    '52' => { },  # 4
    '53' => { },  # 5
    '54' => { },  # 6
    '55' => { },  # 7
    '56' => { },  # 8
    '57' => { },  # 9
    '58' => { },  # :
    '59' => { },  # ;
    '60' => { },  # <
    '61' => { },  # =
    '62' => { },  # >
    '63' => { },  # ?
    '64' => { },  # @
    '65' => { },  # A
    '66' => { },  # B
    '67' => { },  # C
    '68' => { },  # D
    '69' => { },  # E
    '70' => { '44' => -1, '46' => -1, },  # F
    '71' => { },  # G
    '72' => { },  # H
    '73' => { },  # I
    '74' => { },  # J
    '75' => { },  # K
    '76' => { },  # L
    '77' => { },  # M
    '78' => { },  # N
    '79' => { },  # O
    '80' => { '44' => -1, '46' => -1, },  # P
    '81' => { },  # Q
    '82' => { },  # R
    '83' => { },  # S
    '84' => { '44' => -1, '45' => -1, '46' => -1, },  # T
    '85' => { },  # U
    '86' => { '44' => -1, '46' => -1, },  # V
    '87' => { '44' => -1, '46' => -1, },  # W
    '88' => { },  # X
    '89' => { '44' => -1, '46' => -1, },  # Y
    '90' => { },  # Z
    '91' => { },  # [
    '92' => { },  # \
    '93' => { },  # ]
    '94' => { },  # ^
    '95' => { },  # _
    '96' => { },  # `
    '97' => { },  # a
    '98' => { },  # b
    '99' => { },  # c
    '100' => { },  # d
    '101' => { },  # e
    '102' => { },  # f
    '103' => { },  # g
    '104' => { },  # h
    '105' => { },  # i
    '106' => { },  # j
    '107' => { },  # k
    '108' => { },  # l
    '109' => { },  # m
    '110' => { },  # n
    '111' => { },  # o
    '112' => { },  # p
    '113' => { },  # q
    '114' => { },  # r
    '115' => { },  # s
    '116' => { },  # t
    '117' => { },  # u
    '118' => { },  # v
    '119' => { },  # w
    '120' => { },  # x
    '121' => { '44' => -1, '46' => -1, },  # y
    '122' => { },  # z
    '123' => { },  # {
    '124' => { },  # |
    '125' => { },  # }
    '126' => { },  # ~
    '176' => { },  # °
};


sub new {
    my($class) = @_;
    
    my $self = $class->SUPER::new(
        name        => $name,
        char_height => $char_height,
        space_width => $space_width,
        gap_width   => $gap_width,
        symbols     => $symbols,
        kerning     => $kerning,
        line_spacing => $line_spacing,
        class       => 'hipi_2',
    );
    
    return $self;
}

1;

__END__
