#########################################################################################
# Description:  Installer for Wx
# Created       Sat Feb 23 17:21:10 2013
# svn id        $Id: installwx.pl 21 2016-03-04 18:47:17Z Mark Dootson $
# Copyright:    Copyright (c) 2013 Mark Dootson
# Licence:      This work is free software; you can redistribute it and/or modify it 
#               under the terms of the GNU General Public License as published by the 
#               Free Software Foundation; either version 3 of the License, or any later 
#               version.
#########################################################################################

use strict;
use warnings;
use Config;
use PAR::Dist;
use UNIVERSAL::require;

our $archname  = $Config{archname};
our $instarchpath = $Config{sitearchexp};

our $rooturl   = 'http://raspberrypi.znix.com/hipifiles';

my $perlversion = $^V;
$perlversion =~ s/^v//;


#---------------------------------------
# Install Alien::wxWidgets
#---------------------------------------


log_info( qq(Installing Alien::wxWidgets\n) );

{
    install_par(qq($rooturl/Alien-wxWidgets-0.67-$archname-$perlversion.par));
    my $alien = 'Alien::wxWidgets';
    $alien->require;
    $alien->load;
    my $moduleprefix = $alien->prefix();
    my @modulepaths = split(/[\\\/]/, $moduleprefix);
    
    pop @modulepaths; # version
    pop @modulepaths; # wxWidgets
    pop @modulepaths; # Alien
    
    $moduleprefix = join('/', @modulepaths);
    
    my $targetfile = qq($moduleprefix/Alien/wxWidgets/makelinks);
    system(qq($^X $targetfile));
    
}

#---------------------------------------
# Install Wx
#---------------------------------------

log_info( qq(Installing Wx\n) );

{
    install_par(qq($rooturl/Wx-0.9928-$archname-$perlversion.par));
}

#---------------------------------------
# Install Wx::Demo
#---------------------------------------

log_info( qq(Installing Wx::Demo\n) );

{
    install_par(qq($rooturl/Wx-Demo-0.22-$archname-$perlversion.par));
}

#---------------------------------------
# Install Wx::GLCanvas
#---------------------------------------

log_info( qq(Installing Wx::GLCanvas\n) );

{
    install_par(qq($rooturl/Wx-GLCanvas-0.09-$archname-$perlversion.par));
}

#---------------------------------------
# Install Wx::PdfDocument
#---------------------------------------

log_info( qq(Installing Wx::PdfDocument\n) ); 
{
    install_par(qq($rooturl/Wx-PdfDocument-0.20-$archname-$perlversion.par));
    my $targetfile = qq($instarchpath/Wx/PdfDocument/makelinks);
    system(qq($^X $targetfile));
    
}

#---------------------------------------
# Install Wx::Perl::ProcessStream
#---------------------------------------

log_info( qq(Installing Wx::Perl::ProcessStream\n) ); 

{
    install_par(qq($rooturl/Wx-Perl-ProcessStream-0.32-$archname-$perlversion.par));
    
}


log_info(qq(wxPerl dependency Installation Complete\n));

sub log_info { print @_; }

1;
