use v6;
use lib 't';

use Test;
use Test-support;
use MongoDB;
use MongoDB::Client;
use MongoDB::Server;

use BSON::Document;

#------------------------------------------------------------------------------
drop-send-to('mongodb');
#my $handle = 'MongoDB.mlog'.IO.open( :mode<wo>, :create, :truncate);
#modify-send-to( 'mongodb', :level(MongoDB::MdbLoglevels::Trace), :to($handle));
drop-send-to('screen');
#modify-send-to( 'screen', :level(MongoDB::MdbLoglevels::Debug));
info-message("Test start");

my MongoDB::Test-support $ts .= new;

my @serverkeys = $ts.serverkeys.sort;

my Int $p1 = $ts.server-control.get-port-number(@serverkeys[0]);
my Int $p2 = $ts.server-control.get-port-number(@serverkeys[1]);
my MongoDB::Client $client;
my MongoDB::Server $server;

#------------------------------------------------------------------------------
subtest 'Unknown server', {

  my Str $server-name = 'non-existent-server.with-unknown.domain:65535';
  my @options = <serverSelectionTimeoutMS=500 heartbeatFrequencyMS=300>;

  $client .= new(:uri("mongodb://$server-name/?" ~ @options.join('&')));
  isa-ok $client, MongoDB::Client;

  $server = $client.select-server;
  nok $server.defined, 'No servers selected';
  is $client.server-status($server-name), SS-Unknown,
     "Status of server is $client.server-status($server-name)";
  is $client.topology, TT-Unknown, "Topology $client.topology()";
  $client.cleanup;

  $server-name = "localhost:65535";
  $client .= new(:uri("mongodb://$server-name/?" ~ @options.join('&')));
  $server = $client.select-server;
  nok $server.defined, 'No servers selected';
  is $client.server-status($server-name), SS-Unknown,
     "Status of server is $client.server-status($server-name)";
  is $client.topology, TT-Unknown, "Topology $client.topology()";
  $client.cleanup;
}

#------------------------------------------------------------------------------
subtest "Standalone server, localhost", {

  my Str $server-name = "localhost:$p1";
  my @options = <serverSelectionTimeoutMS=5000 heartbeatFrequencyMS=300>;

  $client .= new(:uri("mongodb://$server-name/?" ~  ~ @options.join('&')));

  # do select server before server status test because selection waits
  $server = $client.select-server;
  ok $server.defined, "Server $server.name() selected";

  is $client.server-status($server-name), SS-Standalone,
     "Status of server $server.name() is $client.server-status($server-name)";

  is $client.topology, TT-Single, "Topology $client.topology()";
  $client.cleanup;
}

#`{{
#------------------------------------------------------------------------------
# Cannot test ipv6 with expressVPN turned on
subtest "Standalone server, ipv6", {

  # Try it with ipv6
  my Str $server-name = "[::1]:$p1";
  my @options = <serverSelectionTimeoutMS=5000 heartbeatFrequencyMS=300>;

  $client .= new(:uri("mongodb://$server-name/?" ~  ~ @options.join('&')));

  # do select server before server status test because selection waits
  $server = $client.select-server;
  ok $server.defined, "Server $server.name() selected";

  is $client.server-status($server-name), SS-Standalone,
     "Status of server $server.name() is $client.server-status($server-name)";

  is $client.topology, TT-Single, "Topology $client.topology()";
  $client.cleanup;
}
}}

#------------------------------------------------------------------------------
subtest "Two equal standalone servers", {

  my Str $server-name1 = "localhost:$p1";
  my Str $server-name2 = "localhost:$p2";
  my @options = <serverSelectionTimeoutMS=5000 heartbeatFrequencyMS=500>;

  $client .= new(
    :uri("mongodb://$server-name1,$server-name2/?" ~  ~ @options.join('&'))
  );

  sleep 0.7;
  $server = $client.select-server;
  nok $server.defined, 'No servers selected';

  is $client.server-status($server-name1), SS-Standalone,
     "Server $server-name1 is $client.server-status($server-name1)";

  is $client.server-status($server-name2), SS-Standalone,
     "Server $server-name2 is $client.server-status($server-name2)";

  is $client.topology, TT-Unknown, "Topology $client.topology()";
  $client.cleanup;
}

#------------------------------------------------------------------------------
# Cleanup
info-message("Test $?FILE end");
done-testing();
