#!/usr/bin/env perl6
#
use v6;

BEGIN {
  @*INC.unshift('/home/marcel/Languages/Perl6/Projects/Semi-xml/lib');
  @*INC.unshift('/home/marcel/Languages/Perl6/Projects/Topicmap/lib');
}

use TMap::TopicMapConstruct;
use TMap::TopicMap;
use XML;


# Allow switches after positionals. Pinched from the panda program. Now it is
# possible to make the sxml file executable with the path of this program.
#
@*ARGS = @*ARGS.grep(/^ '-'/), @*ARGS.grep(/^ <-[-]>/);

#-------------------------------------------------------------------------------
#
sub MAIN ( Str $topicmap-fn where $topicmap-fn.IO ~~ :r,
           Bool :$read-xml,
           Str :$dump-xml,
           Str :$search
         ) {

  # Load the topicmap from file $topicmap-fn. Then check the item identifier.
  #
  my TMap::TopicMap $topicmap;

  # Read xml if --read-xml is used
  #
  if $read-xml.defined {
    my XML::Document $xml-doc .= load($topicmap-fn);
    my $xml-topicmap = $xml-doc.root.cloneNode;
    $xml-topicmap does TMap::TopicMapConstruct;
    $xml-topicmap does TMap::Reifiable;
    $xml-topicmap does TMap::TopicMap;
    $xml-topicmap.set-filename($topicmap-fn);
    $xml-topicmap.check-item-identifiers;

    $topicmap = $xml-topicmap;
  }

  # Read semi-xml without the option above
  #
  else {
    $topicmap = TMap::TopicMap.load-topicmap($topicmap-fn);
  }

  $topicmap.initialize($topicmap-fn);

  # Export topicmap if --dump-xml=<fn> is used.
  #
  $topicmap.export-xml($dump-xml) if ?$dump-xml;


  if 0 {
    for $topicmap.nodes -> $node {
      if $node ~~ XML::Element {
        say "  ", $node.name;
        for $node.attribs.kv -> $k, $v {
          say "    $k = $v";
        }

        for $node.nodes -> $n2lvl {
          if $n2lvl ~~ XML::Element {
            say "    ", $n2lvl.name;
            for $n2lvl.attribs.kv -> $k, $v {
              say "      $k = $v";
            }
          }          
        }
      }
    }
  }

#say $topicmap.Str;
}


