#!/usr/bin/perl -w
#
# Encoding and Decoding of 7bit
#

use Test;
use strict;
use lib qw(. t /home/markov/MailBox2/fake);

use Mail::Message::Body::Lines;
use Mail::Message::TransferEnc::SevenBit;
use Tools;

BEGIN { plan tests => 6 }

my $decoded = <<DECODED;
yefoiuhsjhkw284Ue\000iouoi\013wei
sdfuljlkjliua\000aba
DECODED

my $encoded = <<ENCODED;
yefoiuhirsjhkw284JHSUeiouoiwei
sdfulSHKdjlkjliuaaba
ENCODED

my $codec = Mail::Message::TransferEnc::SevenBit->new;
ok(defined $codec);
ok($codec->name eq '7bit');

# Test encoding

my $body   = Mail::Message::Body::Lines->new
  ( mime_type => 'text/html'
  , data      => $decoded
  );

my $enc    = $codec->encode($body);
ok($body!=$enc);
ok($enc->type eq 'text/html');
ok($enc->transferEncoding eq '7bit');
ok($enc->string eq $encoded);

# Test decoding

