package SVG::Rasterize::Specification::Animation;
use strict;
use warnings;

use Params::Validate qw(:types);

use SVG::Rasterize::Regexes qw(:attributes);

# $Id$

=head1 NAME

C<SVG::Rasterize::Specification::Animation> - specification for class Animation

=head1 VERSION

Version 0.003004

=cut

our $VERSION = '0.003004';

our %CHILDREN = ('animate'          => {'desc'     => 1,
                                        'metadata' => 1,
                                        'title'    => 1},
                 'animateColor'     => {'desc'     => 1,
                                        'metadata' => 1,
                                        'title'    => 1},
                 'animateMotion'    => {'desc'     => 1,
                                        'metadata' => 1,
                                        'mpath'    => 1,
                                        'title'    => 1},
                 'animateTransform' => {'desc'     => 1,
                                        'metadata' => 1,
                                        'title'    => 1},
                 'set'              => {'desc'     => 1,
                                        'metadata' => 1,
                                        'title'    => 1});

our %ATTR_VAL = ('animate'          => {'accumulate'                => {'default'  => 'none',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:none|sum)$/},
                                        'additive'                  => {'default'  => 'replace',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:replace|sum)$/},
                                        'attributeName'             => {'optional' => 0,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'attributeType'             => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'begin'                     => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'by'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'calcMode'                  => {'default'  => 'linear',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:discrete|linear|paced|spline)$/},
                                        'dur'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'end'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'externalResourcesRequired' => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:false|true)$/},
                                        'fill'                      => {'default'  => 'remove',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:remove|freeze)$/},
                                        'from'                      => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'id'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'keySplines'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'keyTimes'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'max'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'min'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onbegin'                   => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onend'                     => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onload'                    => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onrepeat'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'repeatCount'               => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'repeatDur'                 => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'requiredExtensions'        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'requiredFeatures'          => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'restart'                   => {'default'  => 'always',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:always|never|whenNotActive)$/},
                                        'systemLanguage'            => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'to'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'values'                    => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:actuate'             => {'default'  => 'onLoad',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:onLoad)$/},
                                        'xlink:arcrole'             => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:href'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:role'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:show'                => {'default'  => 'other',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:other)$/},
                                        'xlink:title'               => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:type'                => {'default'  => 'simple',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:simple)$/},
                                        'xml:base'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xml:lang'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xml:space'                 => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:default|preserve)$/},
                                        'xmlns:xlink'               => {'default'  => 'http://www.w3.org/1999/xlink',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//}},
                 'animateColor'     => {'accumulate'                => {'default'  => 'none',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:none|sum)$/},
                                        'additive'                  => {'default'  => 'replace',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:replace|sum)$/},
                                        'attributeName'             => {'optional' => 0,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'attributeType'             => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'begin'                     => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'by'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'calcMode'                  => {'default'  => 'linear',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:discrete|linear|paced|spline)$/},
                                        'dur'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'end'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'externalResourcesRequired' => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:false|true)$/},
                                        'fill'                      => {'default'  => 'remove',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:remove|freeze)$/},
                                        'from'                      => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'id'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'keySplines'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'keyTimes'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'max'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'min'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onbegin'                   => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onend'                     => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onload'                    => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onrepeat'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'repeatCount'               => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'repeatDur'                 => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'requiredExtensions'        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'requiredFeatures'          => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'restart'                   => {'default'  => 'always',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:always|never|whenNotActive)$/},
                                        'systemLanguage'            => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'to'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'values'                    => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:actuate'             => {'default'  => 'onLoad',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:onLoad)$/},
                                        'xlink:arcrole'             => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:href'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:role'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:show'                => {'default'  => 'other',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:other)$/},
                                        'xlink:title'               => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:type'                => {'default'  => 'simple',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:simple)$/},
                                        'xml:base'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xml:lang'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xml:space'                 => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:default|preserve)$/},
                                        'xmlns:xlink'               => {'default'  => 'http://www.w3.org/1999/xlink',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//}},
                 'animateMotion'    => {'accumulate'                => {'default'  => 'none',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:none|sum)$/},
                                        'additive'                  => {'default'  => 'replace',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:replace|sum)$/},
                                        'begin'                     => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'by'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'calcMode'                  => {'default'  => 'paced',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:discrete|linear|paced|spline)$/},
                                        'dur'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'end'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'externalResourcesRequired' => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:false|true)$/},
                                        'fill'                      => {'default'  => 'remove',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:remove|freeze)$/},
                                        'from'                      => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'id'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'keyPoints'                 => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'keySplines'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'keyTimes'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'max'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'min'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onbegin'                   => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onend'                     => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onload'                    => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onrepeat'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'origin'                    => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'path'                      => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'repeatCount'               => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'repeatDur'                 => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'requiredExtensions'        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'requiredFeatures'          => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'restart'                   => {'default'  => 'always',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:always|never|whenNotActive)$/},
                                        'rotate'                    => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'systemLanguage'            => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'to'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'values'                    => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:actuate'             => {'default'  => 'onLoad',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:onLoad)$/},
                                        'xlink:arcrole'             => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:href'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:role'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:show'                => {'default'  => 'other',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:other)$/},
                                        'xlink:title'               => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:type'                => {'default'  => 'simple',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:simple)$/},
                                        'xml:base'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xml:lang'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xml:space'                 => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:default|preserve)$/},
                                        'xmlns:xlink'               => {'default'  => 'http://www.w3.org/1999/xlink',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//}},
                 'animateTransform' => {'accumulate'                => {'default'  => 'none',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:none|sum)$/},
                                        'additive'                  => {'default'  => 'replace',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:replace|sum)$/},
                                        'attributeName'             => {'optional' => 0,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'attributeType'             => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'begin'                     => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'by'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'calcMode'                  => {'default'  => 'linear',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:discrete|linear|paced|spline)$/},
                                        'dur'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'end'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'externalResourcesRequired' => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:false|true)$/},
                                        'fill'                      => {'default'  => 'remove',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:remove|freeze)$/},
                                        'from'                      => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'id'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'keySplines'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'keyTimes'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'max'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'min'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onbegin'                   => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onend'                     => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onload'                    => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onrepeat'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'repeatCount'               => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'repeatDur'                 => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'requiredExtensions'        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'requiredFeatures'          => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'restart'                   => {'default'  => 'always',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:always|never|whenNotActive)$/},
                                        'systemLanguage'            => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'to'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'type'                      => {'default'  => 'translate',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:translate|scale|rotate|skewX|skewY)$/},
                                        'values'                    => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:actuate'             => {'default'  => 'onLoad',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:onLoad)$/},
                                        'xlink:arcrole'             => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:href'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:role'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:show'                => {'default'  => 'other',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:other)$/},
                                        'xlink:title'               => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:type'                => {'default'  => 'simple',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:simple)$/},
                                        'xml:base'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xml:lang'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xml:space'                 => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:default|preserve)$/},
                                        'xmlns:xlink'               => {'default'  => 'http://www.w3.org/1999/xlink',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//}},
                 'set'              => {'attributeName'             => {'optional' => 0,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'attributeType'             => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'begin'                     => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'dur'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'end'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'externalResourcesRequired' => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:false|true)$/},
                                        'fill'                      => {'default'  => 'remove',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:remove|freeze)$/},
                                        'id'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'max'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'min'                       => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onbegin'                   => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onend'                     => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onload'                    => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'onrepeat'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'repeatCount'               => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'repeatDur'                 => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'requiredExtensions'        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'requiredFeatures'          => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'restart'                   => {'default'  => 'always',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:always|never|whenNotActive)$/},
                                        'systemLanguage'            => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'to'                        => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:actuate'             => {'default'  => 'onLoad',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:onLoad)$/},
                                        'xlink:arcrole'             => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:href'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:role'                => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:show'                => {'default'  => 'other',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:other)$/},
                                        'xlink:title'               => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xlink:type'                => {'default'  => 'simple',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:simple)$/},
                                        'xml:base'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xml:lang'                  => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//},
                                        'xml:space'                 => {'optional' => 1,
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr/^(?:default|preserve)$/},
                                        'xmlns:xlink'               => {'default'  => 'http://www.w3.org/1999/xlink',
                                                                        'type'     => SCALAR,
                                                                        'regex'    => qr//}});

our %ATTR_HINTS = ('animate'          => {},
                   'animateColor'     => {},
                   'animateMotion'    => {},
                   'animateTransform' => {},
                   'set'              => {});

1;


__END__

=pod

=head1 DESCRIPTION

This file was automatically generated using the SVG DTD available
under
L<http://www.w3.org/Graphics/SVG/1.1/DTD/svg11-flat-20030114.dtd>.

See L<SVG::Rasterize::Specification|SVG::Rasterize::Specification>
for more details.


=head1 AUTHOR

Lutz Gehlen, C<< <perl at lutzgehlen.de> >>


=head1 LICENSE AND COPYRIGHT

Copyright 2010 Lutz Gehlen.

This program is free software; you can redistribute it and/or modify
it under the terms of either: the GNU General Public License as
published by the Free Software Foundation; or the Artistic License.

See http://dev.perl.org/licenses/ for more information.

=cut
