# This -*- perl -*- script writes the Makefile for libwww-perl

#
# MANIFEST file generated by
#
# find * -follow -type f -print > MANIFEST
#
# Makefile.PL was hand made
#
# swig -perl5 -shadow uri.i
#

require 5.004;
use strict;

$::VERSION = '2.01';

sub config_lib {
  system("cd urilib ; ./configure --with-pic ; make all")
}

use ExtUtils::MakeMaker;
WriteMakefile(
	'VERSION' => $::VERSION,
	'CONFIGURE' => \&config_lib,
	'NAME'	 => 'uri',
	'LIBS'   => ["-Lurilib -luri"],
	'INC'	 => '-Iurilib',
	'OBJECT' => 'uri_wrap.o'
);

package MY;

sub postamble
{
  return <<EOF
clean realclean test ::
	\$(MAKE) -C urilib \$@

pack : clean realclean
	cd .. ; gtar -zchvf uri-$::VERSION.tar.gz uri-$::VERSION
EOF
}
