package # hide from PAUSE
App::YTDL::GetData;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( get_yt_list_info get_vimeo_list_info get_new_video_url get_download_info );

use JSON                qw( decode_json );
use LWP::UserAgent      qw();
use Term::ANSIScreen    qw( :screen );
use Try::Tiny           qw( try catch );

use if $^O eq 'MSWin32', 'Win32::Console::ANSI';

use App::YTDL::DataExtract qw( json_to_hash );
use App::YTDL::Helper      qw( uni_capture HIDE_CURSOR SHOW_CURSOR );



sub get_yt_list_info {
    my ( $opt, $url ) = @_;
    my $show_progress = 1;
    my $ua = LWP::UserAgent->new(
        agent         => $opt->{useragent},
        timeout       => $opt->{timeout},
        show_progress => $show_progress
    );
    my $tmp;
    my $count = 0;

    RETRY: while ( 1 ) {
        my $ok = 1;
        try {
            $count++;
            my $res = $ua->get( $url );
            die $res->status_line, ': ', $url if ! $res->is_success;
            my $json = $res->decoded_content;
            $tmp = decode_json( $json );
            die $url . ' - error fetching youtube list info!' if ! defined $tmp || ! %$tmp;
        }
        catch {
            say "$count/$opt->{retries}  $_"; #
            return if $count == $opt->{retries};
            $ok = 0;
            sleep $opt->{retries} * 3;
        };
        return $tmp if $ok;
    }
}


#sub get_vimeo_list_info {
#    my ( $opt, $url ) = @_;
#    my $show_progress = 1;
#    my $ua = LWP::UserAgent->new(
#        agent         => $opt->{useragent},
#        timeout       => $opt->{timeout},
#        show_progress => $show_progress
#    );
#    my $tmp;
#    my $next;
#    my $count = 0;
#
#    RETRY: while ( 1 ) {
#        my $ok = 1;
#        try {
#            $count++;
#            my $res = $ua->get( $url );
#            die $res->status_line, ': ', $url if ! $res->is_success;
#            my $decoded_content = $res->decoded_content;
#            my @video_ids = $decoded_content =~ /id="clip_(\d+?)"/g;
#            $next = $decoded_content =~ /<a.+?rel="next"/;
#            for my $video_id ( @video_ids ) {
#                my $url = sprintf 'https://vimeo.com/%d', $video_id;
#                my $res = $ua->get( $url );
#                die $res->status_line, ': ', $url if ! $res->is_success;
#                my $html = $res->decoded_content;
#                my $json;
#                if ( $html =~ m{<script type="application\/ld\+json">((?:(?!<script).)+?)<\/script>}si ) {
#                    $json = $1;
#                    die $url . ' - error fetching vimeo channel info!' if ! $json;
#                }
#                else {
#                    die $url . ' - error fetching vimeo channel info!';
#                }
#                $json =~ s/^\s+|\s+\z//g;
#                $json =~ s/^\[|\]\z//g;
#                push @{$tmp}, decode_json( $json );
#            }
#        }
#        catch {
#            say "$count/$opt->{retries}  $_"; #
#            return if $count == $opt->{retries};
#            $ok = 0;
#            sleep $opt->{retries} * 3;
#        };
#        return $tmp, $next if $ok;
#    }
#}

sub get_vimeo_list_info {
    my ( $opt, $url ) = @_;
    my $ua = LWP::UserAgent->new(
        agent         => $opt->{useragent},
        timeout       => $opt->{timeout},
        show_progress => 1
    );
    eval { require Mojo::DOM } or die $@;
    my $tmp = [];
    my $next;
    my $count = 0;

    RETRY: while ( 1 ) {
        my $ok = 1;
        try {
            $count++;
            my $res = $ua->get( $url );
            die $res->status_line, ': ', $url if ! $res->is_success;
            my $decoded_content = $res->decoded_content;
            my $dom = Mojo::DOM->new( $decoded_content );
            my $uploader = $dom->at( 'a[class="user"]' )->text;
            $dom->find( 'div[id="browse_content"] > ol > li[id][data-position]' )
                ->each(
                    sub {
                        my $video_id = $_->attr( 'id' );
                        my $title    = $_->at( 'a' )->attr( 'title' );
                        my $datetime = $_->at( 'time' )->attr( 'datetime' );
                        $video_id =~ s/clip_//;
                        push @$tmp, { video_id => $video_id, title => $title, published => $datetime, uploader => $uploader };
                    }
                );
            $next = $dom->at( 'a[rel="next"]' ) ? 1 : 0;
        }
        catch {
            say "$count/$opt->{retries}  $_";
            return if $count == $opt->{retries};
            $ok = 0;
            sleep $opt->{retries} * 3;
        };
        return $tmp, $next if $ok;
    }
}


sub get_new_video_url {
    my ( $opt, $info, $ex, $video_id, $fmt ) = @_;
    my @cmd = ( $opt->{youtube_dl} );
    push @cmd, '--user-agent', $opt->{useragent}    if defined $opt->{useragent};
    push @cmd, '--netrc'                            if $opt->{use_netrc};
    push @cmd, '--socket-timeout', $opt->{timeout};
    push @cmd, '--format', $fmt, '--get-url', '--', $video_id;
    my $video_url;
    try {
        $video_url = uni_capture( @cmd );
        die $video_id . ' - could not get new video url!' if ! $video_url;
    }
    catch {
        say $_;
        $video_url = undef;
    };
    return $video_url;
}


sub get_download_info {
    my ( $opt, $url, $message ) = @_;
    my @cmd = ( $opt->{youtube_dl} );
    push @cmd, '--user-agent', $opt->{useragent}    if defined $opt->{useragent};
    push @cmd, '--netrc'                            if $opt->{use_netrc};
    push @cmd, '--socket-timeout', $opt->{timeout};
    push @cmd, '--youtube-skip-dash-manifest';
    push @cmd, '--dump-json', '--', $url;
    my $json_all;
    my $count = 0;

    RETRY: while ( 1 ) {
        my $ok = 1;
        try {
            $count++;
            print HIDE_CURSOR;
            print $message . '...';
            $json_all = uni_capture( @cmd );
            print "\r", clline;
            print $message . "done.\n";
            print SHOW_CURSOR;
            die $url . ' - no JSON!' if ! $json_all;
        }
        catch {
            say "$count/$opt->{retries}  $url: $_"; #
            if ( $count == $opt->{retries} ) {
                push @{$opt->{error_get_download_infos}}, $url; # $ex
                return;
            }
            $ok = 0;
            print SHOW_CURSOR;
            sleep $opt->{retries} * 3;
        };
        last RETRY if $ok;
    }
    $opt->{up}++;
    my $tmp = json_to_hash( $opt, $json_all );
    return $tmp
}




1;


__END__
