package # hide from PAUSE
App::YTDL::Get_Data;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( get_yt_download_info_as_h_ref get_new_video_url get_download_info_as_json );

use IPC::System::Simple qw( capture );
use JSON                qw( decode_json );
use LWP::UserAgent      qw();
use Term::ANSIScreen    qw( :screen );
use Try::Tiny           qw( try catch );

use if $^O eq 'MSWin32', 'Win32::Console::ANSI';

use App::YTDL::Helper qw( HIDE_CURSOR SHOW_CURSOR );



sub get_yt_download_info_as_h_ref {
    my ( $opt, $url ) = @_;
    my $show_progress = 1;
    my $ua = LWP::UserAgent->new(
        agent         => $opt->{useragent},
        timeout       => $opt->{timeout},
        show_progress => $show_progress
    );
    my $h_ref;
    my $count = 1;
    RETRY: while ( 1 ) {
        my $not_ok;
        try {
            my $res = $ua->get( $url );
            die $res->status_line, ': ', $url if ! $res->is_success;
            my $json = $res->decoded_content;
            $h_ref = decode_json( $json );
        }
        catch {
            if ( $count > $opt->{retries} ) {
                return;
            }
            say "$count/$opt->{retries}  $_";
            $count++;
            $not_ok = 1;
            sleep $opt->{retries} * 3;
        };
        next RETRY if $not_ok;
        return $h_ref;
    }
}


sub get_new_video_url {
    my ( $opt, $info, $ex, $video_id, $fmt ) = @_;
    my @cmd = ( $opt->{youtube_dl} );
    push @cmd, '--user-agent', $opt->{useragent} if defined $opt->{useragent};
    push @cmd, '--socket-timeout', $opt->{timeout};
    #push @cmd, '-v';
    push @cmd, '--format', $fmt, '--get-url', '--', $video_id;
    my $video_url;
    try {
        $video_url = capture( @cmd );
    }
    catch {
        say $_;
        $video_url = undef;
    };
    return $video_url;
}


sub get_download_info_as_json {
    my ( $opt, $video_id, $message ) = @_;
    my @cmd = ( $opt->{youtube_dl} );
    push @cmd, '--user-agent', $opt->{useragent} if defined $opt->{useragent};
    push @cmd, '--socket-timeout', $opt->{timeout};
    push @cmd, '--youtube-skip-dash-manifest';
    #push @cmd, '-v';
    push @cmd, '--dump-json', '--', $video_id;
    my $json;
    my $count = 1;

    RETRY: while ( 1 ) {
        my $not_ok;
        try {
            print HIDE_CURSOR;
            print $message . '...';
            $json = capture( @cmd );
            print "\r", clline;
            print $message . "done.\n";
            print SHOW_CURSOR;
            die if ! $json;
        }
        catch {
            say "$count/$opt->{retries}  $video_id: $_";
            $count++;
            $not_ok = 1;
            print SHOW_CURSOR;
            sleep $opt->{retries} * 3;
        };
        if ( $count > $opt->{retries} ) {
            push @{$opt->{error_get_download_infos}}, $video_id; # $ex
            return;
        }
        if ( $not_ok ) {
            next RETRY;
        }
        last;
    }
    $opt->{up}++;
    return $json;
}




1;


__END__
