package # hide from PAUSE
App::YTDL::Choose_Videos;

use warnings;
use strict;
use 5.010000;

use Exporter qw( import );
our @EXPORT_OK = qw( choose_videos set_sort_videolist );

use List::MoreUtils        qw( any none );
use Term::Choose           qw( choose );
use Term::ReadLine::Simple qw();



sub _my_sort {
    my ( $opt, $h_ref, $a, $b ) = @_;
    my $item = $opt->{list_sort_item};
    my @s = $opt->{list_sort_order} eq 'Asc'
                ? ( $h_ref->{$a}{$item}, $h_ref->{$b}{$item} )
                : ( $h_ref->{$b}{$item}, $h_ref->{$a}{$item} );
    if ( $item eq 'view_count_raw' ) {
       $s[0] <=> $s[1] || $h_ref->{$a}{title} cmp $h_ref->{$b}{title};
    }
    else {
       $s[0] cmp $s[1] || $h_ref->{$a}{title} cmp $h_ref->{$b}{title};
   }
}


sub choose_videos {
    my ( $opt, $info, $tmp, $ex, $prompt ) = @_;
    my $regexp;
    my $back   = '       BACK';
    my $filter = '     FILTER';
    my $sort   = '       SORT';
    my $enter  = '      ENTER';
    my %chosen_video_ids;
    my @last_chosen_video_ids = ();

    FILTER: while ( 1 ) {
        my @pre  = ( length $regexp ? ( undef, $enter ) : ( undef, $filter, $sort, $enter ) );
        my @videos;
        my @tmp_video_ids;
        my $index = $#pre;
        my $mark = [];
        my @video_ids = sort { _my_sort( $opt, $tmp->{$ex}, $a, $b ) }  keys %{$tmp->{$ex}};

        VIDEO_ID: for my $video_id ( @video_ids ) {
            my $title = $tmp->{$ex}{$video_id}{title};
            $title =~ s/\s+/ /g;
            $title =~ s/^\s+|\s+\z//g;
            if ( length $regexp ) {
                if ( $regexp =~ /^!~\s(.+)\z/ ) {
                    my $r = $1;
                    if ( $title =~ /$r/i ) {
                        next VIDEO_ID;
                    }
                }
                elsif ( $title !~ /$regexp/i ) {
                    next VIDEO_ID;
                }
            }
            $tmp->{$ex}{$video_id}{from_list} = 1;
            if ( $ex eq 'youtube' ) {
                $tmp->{$ex}{$video_id}{extractor} = 'youtube';
            }
            if ( $opt->{list_sort_item} eq 'view_count_raw' || $opt->{show_view_count} ) {
                push @videos, sprintf "%11s | %7s  %10s  %$opt->{length_view_count}s  %s", $video_id,
                    $tmp->{$ex}{$video_id}{duration}, $tmp->{$ex}{$video_id}{upload_date}, $tmp->{$ex}{$video_id}{view_count}, $title;
            }
            else {
                push @videos, sprintf "%11s | %7s  %10s  %s", $video_id, $tmp->{$ex}{$video_id}{duration}, $tmp->{$ex}{$video_id}{upload_date}, $title;
            }
            push @tmp_video_ids, $video_id;
            $index++;
            push @$mark, $index if any { $video_id eq $_ } keys %chosen_video_ids;
        }
        my $choices = [ @pre, @videos ];
        # Choose
        my @idx = choose(
            $choices,
            { prompt => $prompt . ':', layout => 3, index => 1, clear_screen => 1, mark => $mark,
              undef => $back, no_spacebar => [ 0 .. $#pre ] }
        );
        if ( ! defined $idx[0] || ! defined $choices->[$idx[0]] ) {
            if ( length $regexp ) {
                delete @{$info->{$ex}}{ @last_chosen_video_ids };
                $regexp = '';
                next FILTER;
            }
            delete @{$info->{$ex}}{ keys %chosen_video_ids };
            return;
        }
        my $choice = $choices->[$idx[0]];
        if ( $choice eq $filter ) {
            shift @idx;
            @last_chosen_video_ids = ();
            for my $i ( @idx ) {
                my $video_id = $tmp_video_ids[$i - @pre];
                $info->{$ex}{$video_id} = $tmp->{$ex}{$video_id};
                $chosen_video_ids{$video_id}++;
                push @last_chosen_video_ids, $video_id;
            }
            for my $m ( @$mark ) {
                if ( none { $m == $_ } @idx ) {
                    my $video_id = $tmp_video_ids[$m - @pre];
                    delete $chosen_video_ids{$video_id};
                    delete $info->{$ex}{$video_id};
                }
            }
            my $trs = Term::ReadLine::Simple->new();
            $regexp = $trs->readline( "Regexp: " );
            next FILTER;
        }
        elsif ( $choice eq $sort ) {
            set_sort_videolist( $opt );
        }
        else {
            if ( $choice eq $enter ) {
                shift @idx;
            }
            @last_chosen_video_ids = ();
            for my $i ( @idx ) {
                my $video_id = $tmp_video_ids[$i - @pre];
                $info->{$ex}{$video_id} = $tmp->{$ex}{$video_id};
                $chosen_video_ids{$video_id}++;
                push @last_chosen_video_ids, $video_id;
            }
            for my $m ( @$mark ) {
                if ( none { $m == $_ } @idx ) {
                    my $video_id = $tmp_video_ids[$m - @pre];
                    delete $chosen_video_ids{$video_id};
                    delete $info->{$ex}{$video_id};
                }
            }
            if ( length $regexp ) {
                $regexp = '';
                next FILTER;
            }
            else {
                return;
            }
        }
    }
}


sub set_sort_videolist {
    my ( $opt ) = @_;
    my $backup_item  = $opt->{list_sort_item};
    my $backup_order = $opt->{list_sort_order};
    my $sort_items = [ 'upload_date', 'title', 'view_count_raw', 'duration' ];
    my $confirm = '  CONFIRM';
    my @pre = ( undef, $confirm );
    my $choices = [ @pre, map { my $s = ucfirst; $s =~ s/_raw\z//; $s =~ s/_/ /g; '- ' . $s } @$sort_items ];

    while ( 1 ) {
        my $current = ucfirst $opt->{list_sort_item};
        $current =~ s/_raw\z//;
        $current =~ s/_/ /g;
        my $prompt = sprintf 'Sort item: [%s]', $current;
        my $idx = choose (
            $choices,
            { prompt => $prompt, clear_screen => 0, layout => 3, index => 1, undef => '  BACK' }
        );
        if ( ! defined $idx || ! defined $choices->[$idx] ) {
            $opt->{list_sort_item} = $backup_item;
            return;
        }
        if ( $choices->[$idx] eq $confirm ) {
            last;
        }
        $idx -= @pre;
        $opt->{list_sort_item} = $sort_items->[$idx];
    }

    while ( 1 ) {
        my $curr_sort_item = ucfirst $opt->{list_sort_item};
        $curr_sort_item =~ s/_raw\z//;
        $curr_sort_item =~ s/_/ /g;
        my $order_prompt = sprintf 'Sort order "%s": [%s]', $curr_sort_item, $opt->{list_sort_order};
        my $choice = choose (
            [ @pre, '- Asc', '- Desc' ],
            { prompt => $order_prompt, clear_screen => 0, layout => 3, undef => '  BACK' }
        );
        if ( ! defined $choice ) {
            $opt->{list_sort_order} = $backup_order;
            return;
        }
        if ( $choice eq $confirm ) {
            $opt->{change}++;
            return;
        }
        $choice =~ s/^-\s//;
        $opt->{list_sort_order} = $choice;
    }
}


1;


__END__
