# Copyright 2011, 2012 Kevin Ryde

# Generated by Math-NumSeq tools/make-oeis-catalogue.pl -- DO NOT EDIT

# This file is part of Math-NumSeq.
#
# Math-NumSeq is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 3, or (at your option) any later
# version.
#
# Math-NumSeq is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with Math-NumSeq.  If not, see <http://www.gnu.org/licenses/>.

package Math::NumSeq::OEIS::Catalogue::Plugin::BuiltinTable;
use 5.004;
use strict;

use vars '$VERSION', '@ISA';
$VERSION = 53;
use Math::NumSeq::OEIS::Catalogue::Plugin;
@ISA = ('Math::NumSeq::OEIS::Catalogue::Plugin');

## no critic (CodeLayout::RequireTrailingCommaAtNewline)

# total 764 A-numbers in 111 modules

use constant info_arrayref =>
[
  {
    'anum' => 'A005101',
    'class' => 'Math::NumSeq::Abundant'
  },
  {
    'anum' => 'A005100',
    'class' => 'Math::NumSeq::Abundant',
    'parameters' => [
      'abundant_type',
      'deficient'
    ]
  },
  {
    'anum' => 'A091191',
    'class' => 'Math::NumSeq::Abundant',
    'parameters' => [
      'abundant_type',
      'primitive'
    ]
  },
  {
    'anum' => 'A000027',
    'class' => 'Math::NumSeq::All',
    'parameters' => [
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A001477',
    'class' => 'Math::NumSeq::All'
  },
  {
    'anum' => 'A030190',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      2,
      'i_start',
      0
    ]
  },
  {
    'anum' => 'A030302',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      2,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A030308',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      2,
      'order',
      'reverse',
      'i_start',
      0
    ]
  },
  {
    'anum' => 'A054635',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      3,
      'i_start',
      0
    ]
  },
  {
    'anum' => 'A003137',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      3,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A030341',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      3,
      'order',
      'reverse',
      'i_start',
      0
    ]
  },
  {
    'anum' => 'A030373',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      4,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A030386',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      4,
      'order',
      'reverse',
      'i_start',
      0
    ]
  },
  {
    'anum' => 'A031219',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      5,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A031235',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      5,
      'order',
      'reverse',
      'i_start',
      0
    ]
  },
  {
    'anum' => 'A030998',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      7,
      'i_start',
      0
    ]
  },
  {
    'anum' => 'A054634',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      8,
      'i_start',
      0
    ]
  },
  {
    'anum' => 'A031035',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      8,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A031045',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      8,
      'order',
      'reverse',
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A031076',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      9,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A031087',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      9,
      'order',
      'reverse',
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A007376',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A031298',
    'class' => 'Math::NumSeq::AllDigits',
    'parameters' => [
      'radix',
      10,
      'order',
      'reverse',
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A001358',
    'class' => 'Math::NumSeq::AlmostPrimes'
  },
  {
    'anum' => 'A014612',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      3
    ]
  },
  {
    'anum' => 'A014613',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      4
    ]
  },
  {
    'anum' => 'A014614',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      5
    ]
  },
  {
    'anum' => 'A046306',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      6
    ]
  },
  {
    'anum' => 'A046308',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      7
    ]
  },
  {
    'anum' => 'A046310',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      8
    ]
  },
  {
    'anum' => 'A046312',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      9
    ]
  },
  {
    'anum' => 'A046314',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      10
    ]
  },
  {
    'anum' => 'A069272',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      11
    ]
  },
  {
    'anum' => 'A069273',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      12
    ]
  },
  {
    'anum' => 'A069274',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      13
    ]
  },
  {
    'anum' => 'A069275',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      14
    ]
  },
  {
    'anum' => 'A069276',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      15
    ]
  },
  {
    'anum' => 'A069277',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      16
    ]
  },
  {
    'anum' => 'A069278',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      17
    ]
  },
  {
    'anum' => 'A069279',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      18
    ]
  },
  {
    'anum' => 'A069280',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      19
    ]
  },
  {
    'anum' => 'A069281',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'factor_count',
      20
    ]
  },
  {
    'anum' => 'A006881',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'multiplicity',
      'distinct'
    ]
  },
  {
    'anum' => 'A007304',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'multiplicity',
      'distinct',
      'factor_count',
      3
    ]
  },
  {
    'anum' => 'A046386',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'multiplicity',
      'distinct',
      'factor_count',
      4
    ]
  },
  {
    'anum' => 'A046387',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'multiplicity',
      'distinct',
      'factor_count',
      5
    ]
  },
  {
    'anum' => 'A067885',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'multiplicity',
      'distinct',
      'factor_count',
      6
    ]
  },
  {
    'anum' => 'A123321',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'multiplicity',
      'distinct',
      'factor_count',
      7
    ]
  },
  {
    'anum' => 'A123322',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'multiplicity',
      'distinct',
      'factor_count',
      8
    ]
  },
  {
    'anum' => 'A115343',
    'class' => 'Math::NumSeq::AlmostPrimes',
    'parameters' => [
      'multiplicity',
      'distinct',
      'factor_count',
      9
    ]
  },
  {
    'anum' => 'A109733',
    'class' => 'Math::NumSeq::AsciiSelf'
  },
  {
    'anum' => 'A014486',
    'class' => 'Math::NumSeq::BalancedBinary'
  },
  {
    'anum' => 'A086747',
    'class' => 'Math::NumSeq::BaumSweet'
  },
  {
    'anum' => 'A051003',
    'class' => 'Math::NumSeq::Beastly',
    'parameters' => [
      'radix',
      10
    ]
  },
  {
    'anum' => 'A000108',
    'class' => 'Math::NumSeq::Catalan'
  },
  {
    'anum' => 'A098597',
    'class' => 'Math::NumSeq::Catalan',
    'parameters' => [
      'values_type',
      'odd'
    ]
  },
  {
    'anum' => 'A006667',
    'class' => 'Math::NumSeq::CollatzSteps',
    'parameters' => [
      'step_type',
      'up'
    ]
  },
  {
    'anum' => 'A006666',
    'class' => 'Math::NumSeq::CollatzSteps',
    'parameters' => [
      'step_type',
      'down'
    ]
  },
  {
    'anum' => 'A006577',
    'class' => 'Math::NumSeq::CollatzSteps',
    'parameters' => [
      'step_type',
      'both'
    ]
  },
  {
    'anum' => 'A008908',
    'class' => 'Math::NumSeq::CollatzSteps',
    'parameters' => [
      'on_values',
      'even'
    ]
  },
  {
    'anum' => 'A087737',
    'class' => 'Math::NumSeq::ConcatNumbers',
    'parameters' => [
      'radix',
      2,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A001704',
    'class' => 'Math::NumSeq::ConcatNumbers',
    'parameters' => [
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A001703',
    'class' => 'Math::NumSeq::ConcatNumbers',
    'parameters' => [
      'i_start',
      1,
      'concat_count',
      3
    ]
  },
  {
    'anum' => 'A000578',
    'class' => 'Math::NumSeq::Cubes'
  },
  {
    'anum' => 'A002064',
    'class' => 'Math::NumSeq::CullenNumbers'
  },
  {
    'anum' => 'A173290',
    'class' => 'Math::NumSeq::DedekindPsiCumulative'
  },
  {
    'anum' => 'A019269',
    'class' => 'Math::NumSeq::DedekindPsiSteps'
  },
  {
    'anum' => 'A096246',
    'class' => 'Math::NumSeq::DeletablePrimes',
    'parameters' => [
      'radix',
      2
    ]
  },
  {
    'anum' => 'A080608',
    'class' => 'Math::NumSeq::DeletablePrimes'
  },
  {
    'anum' => 'A080791',
    'class' => 'Math::NumSeq::DigitCount',
    'parameters' => [
      'radix',
      2,
      'digit',
      0
    ]
  },
  {
    'anum' => 'A000120',
    'class' => 'Math::NumSeq::DigitCount',
    'parameters' => [
      'radix',
      2,
      'digit',
      1
    ]
  },
  {
    'anum' => 'A077267',
    'class' => 'Math::NumSeq::DigitCount',
    'parameters' => [
      'radix',
      3,
      'digit',
      0,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A062756',
    'class' => 'Math::NumSeq::DigitCount',
    'parameters' => [
      'radix',
      3,
      'digit',
      1
    ]
  },
  {
    'anum' => 'A081603',
    'class' => 'Math::NumSeq::DigitCount',
    'parameters' => [
      'radix',
      3,
      'digit',
      2
    ]
  },
  {
    'anum' => 'A160380',
    'class' => 'Math::NumSeq::DigitCount',
    'parameters' => [
      'radix',
      4,
      'digit',
      0
    ]
  },
  {
    'anum' => 'A160381',
    'class' => 'Math::NumSeq::DigitCount',
    'parameters' => [
      'radix',
      4,
      'digit',
      1
    ]
  },
  {
    'anum' => 'A160382',
    'class' => 'Math::NumSeq::DigitCount',
    'parameters' => [
      'radix',
      4,
      'digit',
      2
    ]
  },
  {
    'anum' => 'A160383',
    'class' => 'Math::NumSeq::DigitCount',
    'parameters' => [
      'radix',
      4,
      'digit',
      3
    ]
  },
  {
    'anum' => 'A102683',
    'class' => 'Math::NumSeq::DigitCount',
    'parameters' => [
      'radix',
      10,
      'digit',
      9
    ]
  },
  {
    'anum' => 'A090996',
    'class' => 'Math::NumSeq::DigitCountHigh',
    'parameters' => [
      'radix',
      2
    ]
  },
  {
    'anum' => 'A007814',
    'class' => 'Math::NumSeq::DigitCountLow',
    'parameters' => [
      'radix',
      2,
      'digit',
      0,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A007949',
    'class' => 'Math::NumSeq::DigitCountLow',
    'parameters' => [
      'radix',
      3,
      'digit',
      0,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A112765',
    'class' => 'Math::NumSeq::DigitCountLow',
    'parameters' => [
      'radix',
      5,
      'digit',
      0,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A122841',
    'class' => 'Math::NumSeq::DigitCountLow',
    'parameters' => [
      'radix',
      6,
      'digit',
      0,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A122840',
    'class' => 'Math::NumSeq::DigitCountLow',
    'parameters' => [
      'radix',
      10,
      'digit',
      0,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A070939',
    'class' => 'Math::NumSeq::DigitLength',
    'parameters' => [
      'radix',
      2
    ]
  },
  {
    'anum' => 'A081604',
    'class' => 'Math::NumSeq::DigitLength',
    'parameters' => [
      'radix',
      3
    ]
  },
  {
    'anum' => 'A110591',
    'class' => 'Math::NumSeq::DigitLength',
    'parameters' => [
      'radix',
      4
    ]
  },
  {
    'anum' => 'A110592',
    'class' => 'Math::NumSeq::DigitLength',
    'parameters' => [
      'radix',
      5
    ]
  },
  {
    'anum' => 'A055642',
    'class' => 'Math::NumSeq::DigitLength',
    'parameters' => [
      'radix',
      10
    ]
  },
  {
    'anum' => 'A083652',
    'class' => 'Math::NumSeq::DigitLengthCumulative',
    'parameters' => [
      'radix',
      2
    ]
  },
  {
    'anum' => 'A007954',
    'class' => 'Math::NumSeq::DigitProduct',
    'parameters' => [
      'radix',
      10
    ]
  },
  {
    'anum' => 'A031346',
    'class' => 'Math::NumSeq::DigitProductSteps'
  },
  {
    'anum' => 'A031347',
    'class' => 'Math::NumSeq::DigitProductSteps',
    'parameters' => [
      'values_type',
      'root'
    ]
  },
  {
    'anum' => 'A053735',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      3
    ]
  },
  {
    'anum' => 'A006287',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      3,
      'power',
      2
    ]
  },
  {
    'anum' => 'A053737',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      4
    ]
  },
  {
    'anum' => 'A053824',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      5
    ]
  },
  {
    'anum' => 'A053827',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      6
    ]
  },
  {
    'anum' => 'A053828',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      7
    ]
  },
  {
    'anum' => 'A053829',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      8
    ]
  },
  {
    'anum' => 'A053830',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      9
    ]
  },
  {
    'anum' => 'A007953',
    'class' => 'Math::NumSeq::DigitSum'
  },
  {
    'anum' => 'A053831',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      11
    ]
  },
  {
    'anum' => 'A053832',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      12
    ]
  },
  {
    'anum' => 'A053833',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      13
    ]
  },
  {
    'anum' => 'A053834',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      14
    ]
  },
  {
    'anum' => 'A053835',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      15
    ]
  },
  {
    'anum' => 'A053836',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'radix',
      16
    ]
  },
  {
    'anum' => 'A003132',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'power',
      2
    ]
  },
  {
    'anum' => 'A055012',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'power',
      3
    ]
  },
  {
    'anum' => 'A055013',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'power',
      4
    ]
  },
  {
    'anum' => 'A055014',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'power',
      5
    ]
  },
  {
    'anum' => 'A055015',
    'class' => 'Math::NumSeq::DigitSum',
    'parameters' => [
      'power',
      6
    ]
  },
  {
    'anum' => 'A010060',
    'class' => 'Math::NumSeq::DigitSumModulo',
    'parameters' => [
      'radix',
      2
    ]
  },
  {
    'anum' => 'A053838',
    'class' => 'Math::NumSeq::DigitSumModulo',
    'parameters' => [
      'radix',
      3
    ]
  },
  {
    'anum' => 'A053839',
    'class' => 'Math::NumSeq::DigitSumModulo',
    'parameters' => [
      'radix',
      4
    ]
  },
  {
    'anum' => 'A053840',
    'class' => 'Math::NumSeq::DigitSumModulo',
    'parameters' => [
      'radix',
      5
    ]
  },
  {
    'anum' => 'A053841',
    'class' => 'Math::NumSeq::DigitSumModulo',
    'parameters' => [
      'radix',
      6
    ]
  },
  {
    'anum' => 'A053842',
    'class' => 'Math::NumSeq::DigitSumModulo',
    'parameters' => [
      'radix',
      7
    ]
  },
  {
    'anum' => 'A053843',
    'class' => 'Math::NumSeq::DigitSumModulo',
    'parameters' => [
      'radix',
      8
    ]
  },
  {
    'anum' => 'A053844',
    'class' => 'Math::NumSeq::DigitSumModulo',
    'parameters' => [
      'radix',
      9
    ]
  },
  {
    'anum' => 'A053837',
    'class' => 'Math::NumSeq::DigitSumModulo',
    'parameters' => [
      'radix',
      10
    ]
  },
  {
    'anum' => 'A000005',
    'class' => 'Math::NumSeq::DivisorCount'
  },
  {
    'anum' => 'A003624',
    'class' => 'Math::NumSeq::DuffinianNumbers'
  },
  {
    'anum' => 'A080790',
    'class' => 'Math::NumSeq::Emirps',
    'parameters' => [
      'radix',
      2
    ]
  },
  {
    'anum' => 'A006567',
    'class' => 'Math::NumSeq::Emirps',
    'parameters' => [
      'radix',
      10
    ]
  },
  {
    'anum' => 'A126433',
    'class' => 'Math::NumSeq::ErdosSelfridgeClass',
    'parameters' => [
      'on_values',
      'primes'
    ]
  },
  {
    'anum' => 'A126805',
    'class' => 'Math::NumSeq::ErdosSelfridgeClass',
    'parameters' => [
      'on_values',
      'primes',
      'p_or_m',
      '-'
    ]
  },
  {
    'anum' => 'A005843',
    'class' => 'Math::NumSeq::Even'
  },
  {
    'anum' => 'A005563',
    'class' => 'Math::NumSeq::Expression',
    'parameters' => [
      'expression',
      'i*(i+2)'
    ]
  },
  {
    'anum' => 'A000447',
    'class' => 'Math::NumSeq::Expression',
    'parameters' => [
      'expression',
      'i*(4*i*i-1)/3'
    ]
  },
  {
    'anum' => 'A016743',
    'class' => 'Math::NumSeq::Expression',
    'parameters' => [
      'expression',
      '(2*i)**3'
    ]
  },
  {
    'anum' => 'A000079',
    'class' => 'Math::NumSeq::Expression',
    'parameters' => [
      'expression',
      '2**i'
    ]
  },
  {
    'anum' => 'A000244',
    'class' => 'Math::NumSeq::Expression',
    'parameters' => [
      'expression',
      '3**i'
    ]
  },
  {
    'anum' => 'A000302',
    'class' => 'Math::NumSeq::Expression',
    'parameters' => [
      'expression',
      '4**i'
    ]
  },
  {
    'anum' => 'A011557',
    'class' => 'Math::NumSeq::Expression',
    'parameters' => [
      'expression',
      '10**i'
    ]
  },
  {
    'anum' => 'A000142',
    'class' => 'Math::NumSeq::Factorials'
  },
  {
    'anum' => 'A003714',
    'class' => 'Math::NumSeq::Fibbinary'
  },
  {
    'anum' => 'A007895',
    'class' => 'Math::NumSeq::FibbinaryBitCount'
  },
  {
    'anum' => 'A000045',
    'class' => 'Math::NumSeq::Fibonacci'
  },
  {
    'anum' => 'A003849',
    'class' => 'Math::NumSeq::FibonacciWord'
  },
  {
    'anum' => 'A020806',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/7'
    ]
  },
  {
    'anum' => 'A000012',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/9'
    ]
  },
  {
    'anum' => 'A010680',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/11'
    ]
  },
  {
    'anum' => 'A021015',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/11'
    ]
  },
  {
    'anum' => 'A021016',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/12'
    ]
  },
  {
    'anum' => 'A021017',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/13'
    ]
  },
  {
    'anum' => 'A021018',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/14'
    ]
  },
  {
    'anum' => 'A021019',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/15'
    ]
  },
  {
    'anum' => 'A021020',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/16'
    ]
  },
  {
    'anum' => 'A007450',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/17'
    ]
  },
  {
    'anum' => 'A022001',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/997'
    ]
  },
  {
    'anum' => 'A022002',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/998'
    ]
  },
  {
    'anum' => 'A022003',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '1/999'
    ]
  },
  {
    'anum' => 'A010888',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '13717421/1111111110'
    ]
  },
  {
    'anum' => 'A010701',
    'class' => 'Math::NumSeq::FractionDigits',
    'parameters' => [
      'fraction',
      '10/3'
    ]
  },
  {
    'anum' => 'A020985',
    'class' => 'Math::NumSeq::GolayRudinShapiro'
  },
  {
    'anum' => 'A020987',
    'class' => 'Math::NumSeq::GolayRudinShapiro',
    'parameters' => [
      'values_type',
      '0,1'
    ]
  },
  {
    'anum' => 'A020986',
    'class' => 'Math::NumSeq::GolayRudinShapiroCumulative'
  },
  {
    'anum' => 'A061358',
    'class' => 'Math::NumSeq::GoldbachCount',
    'parameters' => [
      'i_start',
      0
    ]
  },
  {
    'anum' => 'A045917',
    'class' => 'Math::NumSeq::GoldbachCount',
    'parameters' => [
      'on_values',
      'even'
    ]
  },
  {
    'anum' => 'A001462',
    'class' => 'Math::NumSeq::GolombSequence'
  },
  {
    'anum' => 'A080605',
    'class' => 'Math::NumSeq::GolombSequence',
    'parameters' => [
      'using_values',
      'odd'
    ]
  },
  {
    'anum' => 'A080606',
    'class' => 'Math::NumSeq::GolombSequence',
    'parameters' => [
      'using_values',
      'even'
    ]
  },
  {
    'anum' => 'A080607',
    'class' => 'Math::NumSeq::GolombSequence',
    'parameters' => [
      'using_values',
      '3k'
    ]
  },
  {
    'anum' => 'A013189',
    'class' => 'Math::NumSeq::GolombSequence',
    'parameters' => [
      'using_values',
      'squares'
    ]
  },
  {
    'anum' => 'A169682',
    'class' => 'Math::NumSeq::GolombSequence',
    'parameters' => [
      'using_values',
      'primes'
    ]
  },
  {
    'anum' => 'A007770',
    'class' => 'Math::NumSeq::HappyNumbers',
    'parameters' => [
      'radix',
      10
    ]
  },
  {
    'anum' => 'A078627',
    'class' => 'Math::NumSeq::HappySteps',
    'parameters' => [
      'radix',
      2
    ]
  },
  {
    'anum' => 'A193995',
    'class' => 'Math::NumSeq::HappySteps'
  },
  {
    'anum' => 'A049445',
    'class' => 'Math::NumSeq::HarshadNumbers',
    'parameters' => [
      'radix',
      2
    ]
  },
  {
    'anum' => 'A064150',
    'class' => 'Math::NumSeq::HarshadNumbers',
    'parameters' => [
      'radix',
      3
    ]
  },
  {
    'anum' => 'A064438',
    'class' => 'Math::NumSeq::HarshadNumbers',
    'parameters' => [
      'radix',
      4
    ]
  },
  {
    'anum' => 'A064481',
    'class' => 'Math::NumSeq::HarshadNumbers',
    'parameters' => [
      'radix',
      5
    ]
  },
  {
    'anum' => 'A005349',
    'class' => 'Math::NumSeq::HarshadNumbers'
  },
  {
    'anum' => 'A005228',
    'class' => 'Math::NumSeq::HofstadterFigure'
  },
  {
    'anum' => 'A061577',
    'class' => 'Math::NumSeq::HofstadterFigure',
    'parameters' => [
      'start',
      2
    ]
  },
  {
    'anum' => 'A022935',
    'class' => 'Math::NumSeq::HofstadterFigure',
    'parameters' => [
      'start',
      3
    ]
  },
  {
    'anum' => 'A022936',
    'class' => 'Math::NumSeq::HofstadterFigure',
    'parameters' => [
      'start',
      4
    ]
  },
  {
    'anum' => 'A022937',
    'class' => 'Math::NumSeq::HofstadterFigure',
    'parameters' => [
      'start',
      5
    ]
  },
  {
    'anum' => 'A022938',
    'class' => 'Math::NumSeq::HofstadterFigure',
    'parameters' => [
      'start',
      6
    ]
  },
  {
    'anum' => 'A007320',
    'class' => 'Math::NumSeq::JugglerSteps'
  },
  {
    'anum' => 'A095398',
    'class' => 'Math::NumSeq::JugglerSteps',
    'parameters' => [
      'juggler_type',
      '2/3-3/2'
    ]
  },
  {
    'anum' => 'A095401',
    'class' => 'Math::NumSeq::JugglerSteps',
    'parameters' => [
      'juggler_type',
      '3/4-4/3'
    ]
  },
  {
    'anum' => 'A000002',
    'class' => 'Math::NumSeq::Kolakoski'
  },
  {
    'anum' => 'A046926',
    'class' => 'Math::NumSeq::LemoineCount'
  },
  {
    'anum' => 'A046924',
    'class' => 'Math::NumSeq::LemoineCount',
    'parameters' => [
      'one_as_prime',
      1
    ]
  },
  {
    'anum' => 'A046927',
    'class' => 'Math::NumSeq::LemoineCount',
    'parameters' => [
      'on_values',
      'odd'
    ]
  },
  {
    'anum' => 'A046925',
    'class' => 'Math::NumSeq::LemoineCount',
    'parameters' => [
      'on_values',
      'odd',
      'one_as_prime',
      1
    ]
  },
  {
    'anum' => 'A008836',
    'class' => 'Math::NumSeq::LiouvilleFunction'
  },
  {
    'anum' => 'A066829',
    'class' => 'Math::NumSeq::LiouvilleFunction',
    'parameters' => [
      'values_type',
      '0,1'
    ]
  },
  {
    'anum' => 'A065043',
    'class' => 'Math::NumSeq::LiouvilleFunction',
    'parameters' => [
      'values_type',
      '1,0'
    ]
  },
  {
    'anum' => 'A000204',
    'class' => 'Math::NumSeq::LucasNumbers'
  },
  {
    'anum' => 'A000959',
    'class' => 'Math::NumSeq::LuckyNumbers'
  },
  {
    'anum' => 'A062842',
    'class' => 'Math::NumSeq::MaxDigitCount'
  },
  {
    'anum' => 'A062843',
    'class' => 'Math::NumSeq::MaxDigitCount',
    'parameters' => [
      'digit',
      1
    ]
  },
  {
    'anum' => 'A064990',
    'class' => 'Math::NumSeq::MephistoWaltz'
  },
  {
    'anum' => 'A008683',
    'class' => 'Math::NumSeq::MobiusFunction'
  },
  {
    'anum' => 'A000035',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      2
    ]
  },
  {
    'anum' => 'A010872',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      3
    ]
  },
  {
    'anum' => 'A010873',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      4
    ]
  },
  {
    'anum' => 'A010874',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      5
    ]
  },
  {
    'anum' => 'A010875',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      6
    ]
  },
  {
    'anum' => 'A010876',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      7
    ]
  },
  {
    'anum' => 'A010877',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      8
    ]
  },
  {
    'anum' => 'A010878',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      9
    ]
  },
  {
    'anum' => 'A010879',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      10
    ]
  },
  {
    'anum' => 'A010880',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      11
    ]
  },
  {
    'anum' => 'A010881',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      12
    ]
  },
  {
    'anum' => 'A130909',
    'class' => 'Math::NumSeq::Modulo',
    'parameters' => [
      'modulus',
      16
    ]
  },
  {
    'anum' => 'A001101',
    'class' => 'Math::NumSeq::MoranNumbers'
  },
  {
    'anum' => 'A000004',
    'class' => 'Math::NumSeq::Multiples',
    'parameters' => [
      'multiples',
      0
    ]
  },
  {
    'anum' => 'A008585',
    'class' => 'Math::NumSeq::Multiples',
    'parameters' => [
      'multiples',
      3
    ]
  },
  {
    'anum' => 'A008586',
    'class' => 'Math::NumSeq::Multiples',
    'parameters' => [
      'multiples',
      4
    ]
  },
  {
    'anum' => 'A008587',
    'class' => 'Math::NumSeq::Multiples',
    'parameters' => [
      'multiples',
      5
    ]
  },
  {
    'anum' => 'A008588',
    'class' => 'Math::NumSeq::Multiples',
    'parameters' => [
      'multiples',
      6
    ]
  },
  {
    'anum' => 'A008589',
    'class' => 'Math::NumSeq::Multiples',
    'parameters' => [
      'multiples',
      7
    ]
  },
  {
    'anum' => 'A008590',
    'class' => 'Math::NumSeq::Multiples',
    'parameters' => [
      'multiples',
      8
    ]
  },
  {
    'anum' => 'A008591',
    'class' => 'Math::NumSeq::Multiples',
    'parameters' => [
      'multiples',
      9
    ]
  },
  {
    'anum' => 'A008592',
    'class' => 'Math::NumSeq::Multiples',
    'parameters' => [
      'multiples',
      10
    ]
  },
  {
    'anum' => 'A086746',
    'class' => 'Math::NumSeq::Multiples',
    'parameters' => [
      'multiples',
      3018,
      'i_start',
      1
    ]
  },
  {
    'anum' => 'A079000',
    'class' => 'Math::NumSeq::NumAronson'
  },
  {
    'anum' => 'A005408',
    'class' => 'Math::NumSeq::Odd'
  },
  {
    'anum' => 'A006995',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      2
    ]
  },
  {
    'anum' => 'A014190',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      3
    ]
  },
  {
    'anum' => 'A014192',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      4
    ]
  },
  {
    'anum' => 'A029952',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      5
    ]
  },
  {
    'anum' => 'A029953',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      6
    ]
  },
  {
    'anum' => 'A029954',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      7
    ]
  },
  {
    'anum' => 'A029803',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      8
    ]
  },
  {
    'anum' => 'A029955',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      9
    ]
  },
  {
    'anum' => 'A002113',
    'class' => 'Math::NumSeq::Palindromes'
  },
  {
    'anum' => 'A029956',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      11
    ]
  },
  {
    'anum' => 'A029957',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      12
    ]
  },
  {
    'anum' => 'A029958',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      13
    ]
  },
  {
    'anum' => 'A029959',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      14
    ]
  },
  {
    'anum' => 'A029960',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      15
    ]
  },
  {
    'anum' => 'A029730',
    'class' => 'Math::NumSeq::Palindromes',
    'parameters' => [
      'radix',
      16
    ]
  },
  {
    'anum' => 'A000129',
    'class' => 'Math::NumSeq::Pell'
  },
  {
    'anum' => 'A001608',
    'class' => 'Math::NumSeq::Perrin'
  },
  {
    'anum' => 'A006285',
    'class' => 'Math::NumSeq::PolignacObstinate'
  },
  {
    'anum' => 'A000326',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      5,
      'pairs',
      'first'
    ]
  },
  {
    'anum' => 'A005449',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      5,
      'pairs',
      'second'
    ]
  },
  {
    'anum' => 'A001318',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      5,
      'pairs',
      'both'
    ]
  },
  {
    'anum' => 'A000384',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      6,
      'pairs',
      'first'
    ]
  },
  {
    'anum' => 'A014105',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      6,
      'pairs',
      'second'
    ]
  },
  {
    'anum' => 'A000566',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      7
    ]
  },
  {
    'anum' => 'A085787',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      7,
      'pairs',
      'both'
    ]
  },
  {
    'anum' => 'A000567',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      8
    ]
  },
  {
    'anum' => 'A045944',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      8,
      'pairs',
      'second'
    ]
  },
  {
    'anum' => 'A001106',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      9
    ]
  },
  {
    'anum' => 'A179986',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      9,
      'pairs',
      'second'
    ]
  },
  {
    'anum' => 'A118277',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      9,
      'pairs',
      'both'
    ]
  },
  {
    'anum' => 'A001107',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      10
    ]
  },
  {
    'anum' => 'A033954',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      10,
      'pairs',
      'second'
    ]
  },
  {
    'anum' => 'A074377',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      10,
      'pairs',
      'both'
    ]
  },
  {
    'anum' => 'A051682',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      11
    ]
  },
  {
    'anum' => 'A062728',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      11,
      'pairs',
      'second'
    ]
  },
  {
    'anum' => 'A195160',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      11,
      'pairs',
      'both'
    ]
  },
  {
    'anum' => 'A051624',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      12
    ]
  },
  {
    'anum' => 'A135705',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      12,
      'pairs',
      'second'
    ]
  },
  {
    'anum' => 'A195162',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      12,
      'pairs',
      'both'
    ]
  },
  {
    'anum' => 'A195313',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      13,
      'pairs',
      'both'
    ]
  },
  {
    'anum' => 'A195818',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      14,
      'pairs',
      'both'
    ]
  },
  {
    'anum' => 'A051865',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      13
    ]
  },
  {
    'anum' => 'A051866',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      14
    ]
  },
  {
    'anum' => 'A051867',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      15
    ]
  },
  {
    'anum' => 'A051868',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      16
    ]
  },
  {
    'anum' => 'A051869',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      17
    ]
  },
  {
    'anum' => 'A051870',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      18
    ]
  },
  {
    'anum' => 'A051871',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      19
    ]
  },
  {
    'anum' => 'A051872',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      20
    ]
  },
  {
    'anum' => 'A051873',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      21
    ]
  },
  {
    'anum' => 'A051874',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      22
    ]
  },
  {
    'anum' => 'A051875',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      23
    ]
  },
  {
    'anum' => 'A051876',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      24
    ]
  },
  {
    'anum' => 'A195028',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      30,
      'pairs',
      'second'
    ]
  },
  {
    'anum' => 'A001105',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      6,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A033428',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      8,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A016742',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      10,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A033429',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      12,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A033581',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      14,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A033582',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      16,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A139098',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      18,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A016766',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      20,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A033583',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      22,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A033584',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      24,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A135453',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      26,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A152742',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      28,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A144555',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      30,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A064761',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      32,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A016802',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      34,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A017522',
    'class' => 'Math::NumSeq::Polygonal',
    'parameters' => [
      'polygonal',
      290,
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A008477',
    'class' => 'Math::NumSeq::PowerFlip'
  },
  {
    'anum' => 'A000188',
    'class' => 'Math::NumSeq::PowerPart'
  },
  {
    'anum' => 'A053150',
    'class' => 'Math::NumSeq::PowerPart',
    'parameters' => [
      'power',
      3
    ]
  },
  {
    'anum' => 'A053164',
    'class' => 'Math::NumSeq::PowerPart',
    'parameters' => [
      'power',
      4
    ]
  },
  {
    'anum' => 'A013929',
    'class' => 'Math::NumSeq::Powerful'
  },
  {
    'anum' => 'A046099',
    'class' => 'Math::NumSeq::Powerful',
    'parameters' => [
      'power',
      3
    ]
  },
  {
    'anum' => 'A046101',
    'class' => 'Math::NumSeq::Powerful',
    'parameters' => [
      'power',
      4
    ]
  },
  {
    'anum' => 'A001694',
    'class' => 'Math::NumSeq::Powerful',
    'parameters' => [
      'powerful_type',
      'all'
    ]
  },
  {
    'anum' => 'A036966',
    'class' => 'Math::NumSeq::Powerful',
    'parameters' => [
      'powerful_type',
      'all',
      'power',
      3
    ]
  },
  {
    'anum' => 'A036967',
    'class' => 'Math::NumSeq::Powerful',
    'parameters' => [
      'powerful_type',
      'all',
      'power',
      4
    ]
  },
  {
    'anum' => 'A069492',
    'class' => 'Math::NumSeq::Powerful',
    'parameters' => [
      'powerful_type',
      'all',
      'power',
      5
    ]
  },
  {
    'anum' => 'A069493',
    'class' => 'Math::NumSeq::Powerful',
    'parameters' => [
      'powerful_type',
      'all',
      'power',
      6
    ]
  },
  {
    'anum' => 'A001222',
    'class' => 'Math::NumSeq::PrimeFactorCount'
  },
  {
    'anum' => 'A087436',
    'class' => 'Math::NumSeq::PrimeFactorCount',
    'parameters' => [
      'prime_type',
      'odd'
    ]
  },
  {
    'anum' => 'A083025',
    'class' => 'Math::NumSeq::PrimeFactorCount',
    'parameters' => [
      'prime_type',
      '4k+1'
    ]
  },
  {
    'anum' => 'A065339',
    'class' => 'Math::NumSeq::PrimeFactorCount',
    'parameters' => [
      'prime_type',
      '4k+3'
    ]
  },
  {
    'anum' => 'A001221',
    'class' => 'Math::NumSeq::PrimeFactorCount',
    'parameters' => [
      'multiplicity',
      'distinct'
    ]
  },
  {
    'anum' => 'A005087',
    'class' => 'Math::NumSeq::PrimeFactorCount',
    'parameters' => [
      'multiplicity',
      'distinct',
      'prime_type',
      'odd'
    ]
  },
  {
    'anum' => 'A005089',
    'class' => 'Math::NumSeq::PrimeFactorCount',
    'parameters' => [
      'multiplicity',
      'distinct',
      'prime_type',
      '4k+1'
    ]
  },
  {
    'anum' => 'A005091',
    'class' => 'Math::NumSeq::PrimeFactorCount',
    'parameters' => [
      'multiplicity',
      'distinct',
      'prime_type',
      '4k+3'
    ]
  },
  {
    'anum' => 'A156542',
    'class' => 'Math::NumSeq::PrimeFactorCount',
    'parameters' => [
      'multiplicity',
      'distinct',
      'prime_type',
      'SG'
    ]
  },
  {
    'anum' => 'A049076',
    'class' => 'Math::NumSeq::PrimeIndexOrder',
    'parameters' => [
      'on_values',
      'primes'
    ]
  },
  {
    'anum' => 'A006450',
    'class' => 'Math::NumSeq::PrimeIndexPrimes'
  },
  {
    'anum' => 'A038580',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level',
      3
    ]
  },
  {
    'anum' => 'A049090',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level',
      4
    ]
  },
  {
    'anum' => 'A049203',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level',
      5
    ]
  },
  {
    'anum' => 'A049202',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level',
      6
    ]
  },
  {
    'anum' => 'A057849',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level',
      7
    ]
  },
  {
    'anum' => 'A057850',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level',
      8
    ]
  },
  {
    'anum' => 'A057851',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level',
      9
    ]
  },
  {
    'anum' => 'A057847',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level',
      10
    ]
  },
  {
    'anum' => 'A058332',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level',
      11
    ]
  },
  {
    'anum' => 'A093047',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level',
      12
    ]
  },
  {
    'anum' => 'A093046',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level',
      13
    ]
  },
  {
    'anum' => 'A018252',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level_type',
      'exact',
      'level',
      0
    ]
  },
  {
    'anum' => 'A007821',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level_type',
      'exact',
      'level',
      1
    ]
  },
  {
    'anum' => 'A049078',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level_type',
      'exact'
    ]
  },
  {
    'anum' => 'A049079',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level_type',
      'exact',
      'level',
      3
    ]
  },
  {
    'anum' => 'A049080',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level_type',
      'exact',
      'level',
      4
    ]
  },
  {
    'anum' => 'A049081',
    'class' => 'Math::NumSeq::PrimeIndexPrimes',
    'parameters' => [
      'level_type',
      'exact',
      'level',
      5
    ]
  },
  {
    'anum' => 'A000040',
    'class' => 'Math::NumSeq::Primes'
  },
  {
    'anum' => 'A002110',
    'class' => 'Math::NumSeq::Primorials'
  },
  {
    'anum' => 'A002378',
    'class' => 'Math::NumSeq::Pronic'
  },
  {
    'anum' => 'A080075',
    'class' => 'Math::NumSeq::ProthNumbers'
  },
  {
    'anum' => 'A009003',
    'class' => 'Math::NumSeq::PythagoreanHypots'
  },
  {
    'anum' => 'A008846',
    'class' => 'Math::NumSeq::PythagoreanHypots',
    'parameters' => [
      'pythagorean_type',
      'primitive'
    ]
  },
  {
    'anum' => 'A007088',
    'class' => 'Math::NumSeq::RadixConversion'
  },
  {
    'anum' => 'A007089',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'from_radix',
      3
    ]
  },
  {
    'anum' => 'A007090',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'from_radix',
      4
    ]
  },
  {
    'anum' => 'A007091',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'from_radix',
      5
    ]
  },
  {
    'anum' => 'A007092',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'from_radix',
      6
    ]
  },
  {
    'anum' => 'A007093',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'from_radix',
      7
    ]
  },
  {
    'anum' => 'A007094',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'from_radix',
      8
    ]
  },
  {
    'anum' => 'A000695',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'to_radix',
      4
    ]
  },
  {
    'anum' => 'A033042',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'to_radix',
      5
    ]
  },
  {
    'anum' => 'A033043',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'to_radix',
      6
    ]
  },
  {
    'anum' => 'A033045',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'to_radix',
      8
    ]
  },
  {
    'anum' => 'A033046',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'to_radix',
      9
    ]
  },
  {
    'anum' => 'A033047',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'to_radix',
      11
    ]
  },
  {
    'anum' => 'A033048',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'to_radix',
      12
    ]
  },
  {
    'anum' => 'A033049',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'to_radix',
      13
    ]
  },
  {
    'anum' => 'A033050',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'to_radix',
      14
    ]
  },
  {
    'anum' => 'A033051',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'to_radix',
      15
    ]
  },
  {
    'anum' => 'A033052',
    'class' => 'Math::NumSeq::RadixConversion',
    'parameters' => [
      'to_radix',
      16
    ]
  },
  {
    'anum' => 'A032924',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      3,
      'digit',
      0
    ]
  },
  {
    'anum' => 'A005823',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      3,
      'digit',
      1
    ]
  },
  {
    'anum' => 'A005836',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      3,
      'digit',
      2
    ]
  },
  {
    'anum' => 'A023705',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      4,
      'digit',
      0
    ]
  },
  {
    'anum' => 'A023709',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      4,
      'digit',
      1
    ]
  },
  {
    'anum' => 'A023713',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      4,
      'digit',
      2
    ]
  },
  {
    'anum' => 'A023717',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      4,
      'digit',
      3
    ]
  },
  {
    'anum' => 'A023721',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      5,
      'digit',
      0
    ]
  },
  {
    'anum' => 'A023725',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      5,
      'digit',
      1
    ]
  },
  {
    'anum' => 'A023729',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      5,
      'digit',
      2
    ]
  },
  {
    'anum' => 'A023733',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      5,
      'digit',
      3
    ]
  },
  {
    'anum' => 'A023737',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      5,
      'digit',
      4
    ]
  },
  {
    'anum' => 'A020657',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      7,
      'digit',
      6
    ]
  },
  {
    'anum' => 'A052382',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      10,
      'digit',
      0
    ]
  },
  {
    'anum' => 'A052383',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      10,
      'digit',
      1
    ]
  },
  {
    'anum' => 'A052404',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      10,
      'digit',
      2
    ]
  },
  {
    'anum' => 'A052405',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      10,
      'digit',
      3
    ]
  },
  {
    'anum' => 'A052406',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      10,
      'digit',
      4
    ]
  },
  {
    'anum' => 'A052413',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      10,
      'digit',
      5
    ]
  },
  {
    'anum' => 'A052414',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      10,
      'digit',
      6
    ]
  },
  {
    'anum' => 'A052419',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      10,
      'digit',
      7
    ]
  },
  {
    'anum' => 'A052421',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      10,
      'digit',
      8
    ]
  },
  {
    'anum' => 'A007095',
    'class' => 'Math::NumSeq::RadixWithoutDigit',
    'parameters' => [
      'radix',
      10,
      'digit',
      9
    ]
  },
  {
    'anum' => 'A002491',
    'class' => 'Math::NumSeq::ReRound'
  },
  {
    'anum' => 'A000960',
    'class' => 'Math::NumSeq::ReRound',
    'parameters' => [
      'extra_multiples',
      1
    ]
  },
  {
    'anum' => 'A112557',
    'class' => 'Math::NumSeq::ReRound',
    'parameters' => [
      'extra_multiples',
      2
    ]
  },
  {
    'anum' => 'A112558',
    'class' => 'Math::NumSeq::ReRound',
    'parameters' => [
      'extra_multiples',
      3
    ]
  },
  {
    'anum' => 'A113742',
    'class' => 'Math::NumSeq::ReRound',
    'parameters' => [
      'extra_multiples',
      4
    ]
  },
  {
    'anum' => 'A113743',
    'class' => 'Math::NumSeq::ReRound',
    'parameters' => [
      'extra_multiples',
      5
    ]
  },
  {
    'anum' => 'A113744',
    'class' => 'Math::NumSeq::ReRound',
    'parameters' => [
      'extra_multiples',
      6
    ]
  },
  {
    'anum' => 'A113745',
    'class' => 'Math::NumSeq::ReRound',
    'parameters' => [
      'extra_multiples',
      7
    ]
  },
  {
    'anum' => 'A113746',
    'class' => 'Math::NumSeq::ReRound',
    'parameters' => [
      'extra_multiples',
      8
    ]
  },
  {
    'anum' => 'A113747',
    'class' => 'Math::NumSeq::ReRound',
    'parameters' => [
      'extra_multiples',
      9
    ]
  },
  {
    'anum' => 'A113748',
    'class' => 'Math::NumSeq::ReRound',
    'parameters' => [
      'extra_multiples',
      10
    ]
  },
  {
    'anum' => 'A167782',
    'class' => 'Math::NumSeq::RepdigitAny'
  },
  {
    'anum' => 'A059711',
    'class' => 'Math::NumSeq::RepdigitRadix',
    'parameters' => [
      'i_start',
      3
    ]
  },
  {
    'anum' => 'A000225',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      2
    ]
  },
  {
    'anum' => 'A048328',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      3
    ]
  },
  {
    'anum' => 'A048329',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      4
    ]
  },
  {
    'anum' => 'A048331',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      6
    ]
  },
  {
    'anum' => 'A048332',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      7
    ]
  },
  {
    'anum' => 'A048334',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      9
    ]
  },
  {
    'anum' => 'A010785',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      10
    ]
  },
  {
    'anum' => 'A048335',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      11
    ]
  },
  {
    'anum' => 'A048336',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      12
    ]
  },
  {
    'anum' => 'A048337',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      13
    ]
  },
  {
    'anum' => 'A048338',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      14
    ]
  },
  {
    'anum' => 'A048339',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      15
    ]
  },
  {
    'anum' => 'A048340',
    'class' => 'Math::NumSeq::Repdigits',
    'parameters' => [
      'radix',
      16
    ]
  },
  {
    'anum' => 'A035522',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      2,
      'start',
      1
    ]
  },
  {
    'anum' => 'A061561',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      2,
      'start',
      22
    ]
  },
  {
    'anum' => 'A075253',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      2,
      'start',
      77
    ]
  },
  {
    'anum' => 'A075268',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      2,
      'start',
      442
    ]
  },
  {
    'anum' => 'A077076',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      2,
      'start',
      537
    ]
  },
  {
    'anum' => 'A077077',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      2,
      'start',
      775
    ]
  },
  {
    'anum' => 'A035523',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      3,
      'start',
      1
    ]
  },
  {
    'anum' => 'A035524',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      4,
      'start',
      1
    ]
  },
  {
    'anum' => 'A075299',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      4,
      'start',
      290
    ]
  },
  {
    'anum' => 'A075153',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      4,
      'start',
      318
    ]
  },
  {
    'anum' => 'A075466',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      4,
      'start',
      266718
    ]
  },
  {
    'anum' => 'A075467',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      4,
      'start',
      270798
    ]
  },
  {
    'anum' => 'A076247',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      4,
      'start',
      1059774
    ]
  },
  {
    'anum' => 'A076248',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'radix',
      4,
      'start',
      1059831
    ]
  },
  {
    'anum' => 'A001127',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'start',
      1
    ]
  },
  {
    'anum' => 'A033648',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'start',
      3
    ]
  },
  {
    'anum' => 'A033649',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'start',
      5
    ]
  },
  {
    'anum' => 'A033650',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'start',
      7
    ]
  },
  {
    'anum' => 'A033651',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'start',
      9
    ]
  },
  {
    'anum' => 'A033670',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'start',
      89
    ]
  },
  {
    'anum' => 'A006960',
    'class' => 'Math::NumSeq::ReverseAdd',
    'parameters' => [
      'start',
      196
    ]
  },
  {
    'anum' => 'A016016',
    'class' => 'Math::NumSeq::ReverseAddSteps'
  },
  {
    'anum' => 'A002262',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '0toN'
    ]
  },
  {
    'anum' => 'A002260',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '1toN'
    ]
  },
  {
    'anum' => 'A053186',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '0to2N'
    ]
  },
  {
    'anum' => 'A074294',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '1to2N'
    ]
  },
  {
    'anum' => 'A071797',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '1to2N+1'
    ]
  },
  {
    'anum' => 'A194029',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '1toFib'
    ]
  },
  {
    'anum' => 'A025581',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      'Nto0'
    ]
  },
  {
    'anum' => 'A004736',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      'Nto1'
    ]
  },
  {
    'anum' => 'A002024',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      'Nrep'
    ]
  },
  {
    'anum' => 'A003056',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      'N+1rep'
    ]
  },
  {
    'anum' => 'A051162',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '0toNinc'
    ]
  },
  {
    'anum' => 'A004526',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '2rep'
    ]
  },
  {
    'anum' => 'A002264',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '3rep'
    ]
  },
  {
    'anum' => 'A002265',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '4rep'
    ]
  },
  {
    'anum' => 'A002266',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '5rep'
    ]
  },
  {
    'anum' => 'A152467',
    'class' => 'Math::NumSeq::Runs',
    'parameters' => [
      'runs_type',
      '6rep'
    ]
  },
  {
    'anum' => 'A064223',
    'class' => 'Math::NumSeq::SelfLengthCumulative'
  },
  {
    'anum' => 'A005384',
    'class' => 'Math::NumSeq::SophieGermainPrimes'
  },
  {
    'anum' => 'A078510',
    'class' => 'Math::NumSeq::SpiroFibonacci'
  },
  {
    'anum' => 'A079421',
    'class' => 'Math::NumSeq::SpiroFibonacci',
    'parameters' => [
      'recurrence_type',
      'absdiff'
    ]
  },
  {
    'anum' => 'A040000',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      2
    ]
  },
  {
    'anum' => 'A040001',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      3
    ]
  },
  {
    'anum' => 'A040002',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      5
    ]
  },
  {
    'anum' => 'A040003',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      6
    ]
  },
  {
    'anum' => 'A010121',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      7
    ]
  },
  {
    'anum' => 'A040005',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      8
    ]
  },
  {
    'anum' => 'A040006',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      10
    ]
  },
  {
    'anum' => 'A040007',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      11
    ]
  },
  {
    'anum' => 'A040008',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      12
    ]
  },
  {
    'anum' => 'A010122',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      13
    ]
  },
  {
    'anum' => 'A010123',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      14
    ]
  },
  {
    'anum' => 'A040011',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      15
    ]
  },
  {
    'anum' => 'A040012',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      17
    ]
  },
  {
    'anum' => 'A040013',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      18
    ]
  },
  {
    'anum' => 'A010124',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      19
    ]
  },
  {
    'anum' => 'A040015',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      20
    ]
  },
  {
    'anum' => 'A010125',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      21
    ]
  },
  {
    'anum' => 'A010126',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      22
    ]
  },
  {
    'anum' => 'A010127',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      23
    ]
  },
  {
    'anum' => 'A040019',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      24
    ]
  },
  {
    'anum' => 'A040020',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      26
    ]
  },
  {
    'anum' => 'A040021',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      27
    ]
  },
  {
    'anum' => 'A040022',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      28
    ]
  },
  {
    'anum' => 'A010128',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      29
    ]
  },
  {
    'anum' => 'A040024',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      30
    ]
  },
  {
    'anum' => 'A010129',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      31
    ]
  },
  {
    'anum' => 'A010130',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      32
    ]
  },
  {
    'anum' => 'A010131',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      33
    ]
  },
  {
    'anum' => 'A010132',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      34
    ]
  },
  {
    'anum' => 'A040029',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      35
    ]
  },
  {
    'anum' => 'A040030',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      37
    ]
  },
  {
    'anum' => 'A040031',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      38
    ]
  },
  {
    'anum' => 'A040032',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      39
    ]
  },
  {
    'anum' => 'A040033',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      40
    ]
  },
  {
    'anum' => 'A010133',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      41
    ]
  },
  {
    'anum' => 'A040035',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      42
    ]
  },
  {
    'anum' => 'A010134',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      43
    ]
  },
  {
    'anum' => 'A040037',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      44
    ]
  },
  {
    'anum' => 'A010135',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      45
    ]
  },
  {
    'anum' => 'A010136',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      46
    ]
  },
  {
    'anum' => 'A010137',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      47
    ]
  },
  {
    'anum' => 'A040041',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      48
    ]
  },
  {
    'anum' => 'A040042',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      50
    ]
  },
  {
    'anum' => 'A040043',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      51
    ]
  },
  {
    'anum' => 'A010138',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      52
    ]
  },
  {
    'anum' => 'A010139',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      53
    ]
  },
  {
    'anum' => 'A010140',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      54
    ]
  },
  {
    'anum' => 'A010141',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      55
    ]
  },
  {
    'anum' => 'A040048',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      56
    ]
  },
  {
    'anum' => 'A010142',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      57
    ]
  },
  {
    'anum' => 'A010143',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      58
    ]
  },
  {
    'anum' => 'A010144',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      59
    ]
  },
  {
    'anum' => 'A040052',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      60
    ]
  },
  {
    'anum' => 'A010145',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      61
    ]
  },
  {
    'anum' => 'A010146',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      62
    ]
  },
  {
    'anum' => 'A040055',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      63
    ]
  },
  {
    'anum' => 'A040056',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      65
    ]
  },
  {
    'anum' => 'A040057',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      66
    ]
  },
  {
    'anum' => 'A010147',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      67
    ]
  },
  {
    'anum' => 'A040059',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      68
    ]
  },
  {
    'anum' => 'A010148',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      69
    ]
  },
  {
    'anum' => 'A010149',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      70
    ]
  },
  {
    'anum' => 'A010150',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      71
    ]
  },
  {
    'anum' => 'A040063',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      72
    ]
  },
  {
    'anum' => 'A010151',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      73
    ]
  },
  {
    'anum' => 'A010152',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      74
    ]
  },
  {
    'anum' => 'A010153',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      75
    ]
  },
  {
    'anum' => 'A010154',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      76
    ]
  },
  {
    'anum' => 'A010155',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      77
    ]
  },
  {
    'anum' => 'A010156',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      78
    ]
  },
  {
    'anum' => 'A010157',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      79
    ]
  },
  {
    'anum' => 'A040071',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      80
    ]
  },
  {
    'anum' => 'A040072',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      82
    ]
  },
  {
    'anum' => 'A040073',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      83
    ]
  },
  {
    'anum' => 'A040074',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      84
    ]
  },
  {
    'anum' => 'A010158',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      85
    ]
  },
  {
    'anum' => 'A010159',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      86
    ]
  },
  {
    'anum' => 'A040077',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      87
    ]
  },
  {
    'anum' => 'A010160',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      88
    ]
  },
  {
    'anum' => 'A010161',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      89
    ]
  },
  {
    'anum' => 'A040080',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      90
    ]
  },
  {
    'anum' => 'A010162',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      91
    ]
  },
  {
    'anum' => 'A010163',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      92
    ]
  },
  {
    'anum' => 'A010164',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      93
    ]
  },
  {
    'anum' => 'A010165',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      94
    ]
  },
  {
    'anum' => 'A010166',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      95
    ]
  },
  {
    'anum' => 'A010167',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      96
    ]
  },
  {
    'anum' => 'A010168',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      97
    ]
  },
  {
    'anum' => 'A010169',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      98
    ]
  },
  {
    'anum' => 'A010170',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      99
    ]
  },
  {
    'anum' => 'A010171',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      103
    ]
  },
  {
    'anum' => 'A010172',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      106
    ]
  },
  {
    'anum' => 'A010173',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      107
    ]
  },
  {
    'anum' => 'A010174',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      108
    ]
  },
  {
    'anum' => 'A010175',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      109
    ]
  },
  {
    'anum' => 'A010176',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      111
    ]
  },
  {
    'anum' => 'A010177',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      112
    ]
  },
  {
    'anum' => 'A010178',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      113
    ]
  },
  {
    'anum' => 'A010179',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      114
    ]
  },
  {
    'anum' => 'A010180',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      115
    ]
  },
  {
    'anum' => 'A010181',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      116
    ]
  },
  {
    'anum' => 'A010182',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      117
    ]
  },
  {
    'anum' => 'A010183',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      118
    ]
  },
  {
    'anum' => 'A010184',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      119
    ]
  },
  {
    'anum' => 'A010185',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      124
    ]
  },
  {
    'anum' => 'A010186',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      125
    ]
  },
  {
    'anum' => 'A010187',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      126
    ]
  },
  {
    'anum' => 'A010188',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      127
    ]
  },
  {
    'anum' => 'A010189',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      128
    ]
  },
  {
    'anum' => 'A010190',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      129
    ]
  },
  {
    'anum' => 'A010191',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      131
    ]
  },
  {
    'anum' => 'A010192',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      133
    ]
  },
  {
    'anum' => 'A010193',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      134
    ]
  },
  {
    'anum' => 'A010194',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      135
    ]
  },
  {
    'anum' => 'A010195',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      136
    ]
  },
  {
    'anum' => 'A010196',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      137
    ]
  },
  {
    'anum' => 'A010197',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      138
    ]
  },
  {
    'anum' => 'A010198',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      139
    ]
  },
  {
    'anum' => 'A010199',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      140
    ]
  },
  {
    'anum' => 'A010200',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      141
    ]
  },
  {
    'anum' => 'A010201',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      142
    ]
  },
  {
    'anum' => 'A010202',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      149
    ]
  },
  {
    'anum' => 'A010203',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      151
    ]
  },
  {
    'anum' => 'A010204',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      153
    ]
  },
  {
    'anum' => 'A010205',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      154
    ]
  },
  {
    'anum' => 'A010206',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      157
    ]
  },
  {
    'anum' => 'A010207',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      158
    ]
  },
  {
    'anum' => 'A010208',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      159
    ]
  },
  {
    'anum' => 'A010209',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      160
    ]
  },
  {
    'anum' => 'A010210',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      161
    ]
  },
  {
    'anum' => 'A010211',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      162
    ]
  },
  {
    'anum' => 'A010212',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      163
    ]
  },
  {
    'anum' => 'A010213',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      165
    ]
  },
  {
    'anum' => 'A010214',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      166
    ]
  },
  {
    'anum' => 'A010215',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      167
    ]
  },
  {
    'anum' => 'A010216',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      172
    ]
  },
  {
    'anum' => 'A010217',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      173
    ]
  },
  {
    'anum' => 'A010218',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      174
    ]
  },
  {
    'anum' => 'A010219',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      175
    ]
  },
  {
    'anum' => 'A010220',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      176
    ]
  },
  {
    'anum' => 'A010221',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      177
    ]
  },
  {
    'anum' => 'A010222',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      178
    ]
  },
  {
    'anum' => 'A010223',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      179
    ]
  },
  {
    'anum' => 'A010224',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      181
    ]
  },
  {
    'anum' => 'A010225',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      183
    ]
  },
  {
    'anum' => 'A010226',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      184
    ]
  },
  {
    'anum' => 'A010227',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      185
    ]
  },
  {
    'anum' => 'A010228',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      186
    ]
  },
  {
    'anum' => 'A010229',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      187
    ]
  },
  {
    'anum' => 'A010230',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      188
    ]
  },
  {
    'anum' => 'A010231',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      189
    ]
  },
  {
    'anum' => 'A010232',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      190
    ]
  },
  {
    'anum' => 'A010233',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      191
    ]
  },
  {
    'anum' => 'A010234',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      192
    ]
  },
  {
    'anum' => 'A010235',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      193
    ]
  },
  {
    'anum' => 'A010236',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      194
    ]
  },
  {
    'anum' => 'A010237',
    'class' => 'Math::NumSeq::SqrtContinued',
    'parameters' => [
      'sqrt',
      199
    ]
  },
  {
    'anum' => 'A003285',
    'class' => 'Math::NumSeq::SqrtContinuedPeriod'
  },
  {
    'anum' => 'A004609',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      6,
      'radix',
      2
    ]
  },
  {
    'anum' => 'A004539',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      2,
      'radix',
      2
    ]
  },
  {
    'anum' => 'A004540',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      2,
      'radix',
      3
    ]
  },
  {
    'anum' => 'A004541',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      2,
      'radix',
      4
    ]
  },
  {
    'anum' => 'A004542',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      2,
      'radix',
      5
    ]
  },
  {
    'anum' => 'A070197',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      2,
      'radix',
      60
    ]
  },
  {
    'anum' => 'A004548',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      3,
      'radix',
      3
    ]
  },
  {
    'anum' => 'A004547',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      3,
      'radix',
      2
    ]
  },
  {
    'anum' => 'A004555',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      5,
      'radix',
      2
    ]
  },
  {
    'anum' => 'A004556',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      5,
      'radix',
      3
    ]
  },
  {
    'anum' => 'A004557',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      5,
      'radix',
      4
    ]
  },
  {
    'anum' => 'A004558',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      5,
      'radix',
      5
    ]
  },
  {
    'anum' => 'A004559',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      5,
      'radix',
      6
    ]
  },
  {
    'anum' => 'A004560',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      5,
      'radix',
      7
    ]
  },
  {
    'anum' => 'A004561',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      5,
      'radix',
      8
    ]
  },
  {
    'anum' => 'A004562',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      5,
      'radix',
      9
    ]
  },
  {
    'anum' => 'A004563',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      6,
      'radix',
      4
    ]
  },
  {
    'anum' => 'A004564',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      6,
      'radix',
      5
    ]
  },
  {
    'anum' => 'A004565',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      6,
      'radix',
      6
    ]
  },
  {
    'anum' => 'A004566',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      6,
      'radix',
      7
    ]
  },
  {
    'anum' => 'A004567',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      6,
      'radix',
      8
    ]
  },
  {
    'anum' => 'A004568',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      6,
      'radix',
      9
    ]
  },
  {
    'anum' => 'A004569',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      7,
      'radix',
      2
    ]
  },
  {
    'anum' => 'A004570',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      7,
      'radix',
      3
    ]
  },
  {
    'anum' => 'A004571',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      7,
      'radix',
      4
    ]
  },
  {
    'anum' => 'A004572',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      7,
      'radix',
      5
    ]
  },
  {
    'anum' => 'A004573',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      7,
      'radix',
      6
    ]
  },
  {
    'anum' => 'A004574',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      7,
      'radix',
      7
    ]
  },
  {
    'anum' => 'A004575',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      7,
      'radix',
      8
    ]
  },
  {
    'anum' => 'A004576',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      7,
      'radix',
      9
    ]
  },
  {
    'anum' => 'A010465',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      7,
      'radix',
      10
    ]
  },
  {
    'anum' => 'A004578',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      8,
      'radix',
      3
    ]
  },
  {
    'anum' => 'A004579',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      8,
      'radix',
      4
    ]
  },
  {
    'anum' => 'A004580',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      8,
      'radix',
      5
    ]
  },
  {
    'anum' => 'A004581',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      8,
      'radix',
      6
    ]
  },
  {
    'anum' => 'A004582',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      8,
      'radix',
      7
    ]
  },
  {
    'anum' => 'A004583',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      8,
      'radix',
      8
    ]
  },
  {
    'anum' => 'A004584',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      8,
      'radix',
      9
    ]
  },
  {
    'anum' => 'A004585',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      10,
      'radix',
      2
    ]
  },
  {
    'anum' => 'A004586',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      10,
      'radix',
      3
    ]
  },
  {
    'anum' => 'A004587',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      10,
      'radix',
      4
    ]
  },
  {
    'anum' => 'A004588',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      10,
      'radix',
      5
    ]
  },
  {
    'anum' => 'A002193',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      2
    ]
  },
  {
    'anum' => 'A002194',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      3
    ]
  },
  {
    'anum' => 'A002163',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      5
    ]
  },
  {
    'anum' => 'A010467',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      10
    ]
  },
  {
    'anum' => 'A010468',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      11
    ]
  },
  {
    'anum' => 'A010469',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      12
    ]
  },
  {
    'anum' => 'A010470',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      13
    ]
  },
  {
    'anum' => 'A010471',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      14
    ]
  },
  {
    'anum' => 'A010472',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      15
    ]
  },
  {
    'anum' => 'A010473',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      17
    ]
  },
  {
    'anum' => 'A010474',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      18
    ]
  },
  {
    'anum' => 'A010475',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      19
    ]
  },
  {
    'anum' => 'A010476',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      20
    ]
  },
  {
    'anum' => 'A010477',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      21
    ]
  },
  {
    'anum' => 'A010478',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      22
    ]
  },
  {
    'anum' => 'A010479',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      23
    ]
  },
  {
    'anum' => 'A010480',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      24
    ]
  },
  {
    'anum' => 'A010481',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      26
    ]
  },
  {
    'anum' => 'A010482',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      27
    ]
  },
  {
    'anum' => 'A010483',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      28
    ]
  },
  {
    'anum' => 'A010484',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      29
    ]
  },
  {
    'anum' => 'A010485',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      30
    ]
  },
  {
    'anum' => 'A010486',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      31
    ]
  },
  {
    'anum' => 'A010487',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      32
    ]
  },
  {
    'anum' => 'A010488',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      33
    ]
  },
  {
    'anum' => 'A010489',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      34
    ]
  },
  {
    'anum' => 'A010490',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      35
    ]
  },
  {
    'anum' => 'A010491',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      37
    ]
  },
  {
    'anum' => 'A010492',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      38
    ]
  },
  {
    'anum' => 'A010493',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      39
    ]
  },
  {
    'anum' => 'A010494',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      40
    ]
  },
  {
    'anum' => 'A010495',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      41
    ]
  },
  {
    'anum' => 'A010496',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      42
    ]
  },
  {
    'anum' => 'A010497',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      43
    ]
  },
  {
    'anum' => 'A010498',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      44
    ]
  },
  {
    'anum' => 'A010499',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      45
    ]
  },
  {
    'anum' => 'A010500',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      46
    ]
  },
  {
    'anum' => 'A010501',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      47
    ]
  },
  {
    'anum' => 'A010502',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      48
    ]
  },
  {
    'anum' => 'A010504',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      51
    ]
  },
  {
    'anum' => 'A010505',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      52
    ]
  },
  {
    'anum' => 'A010506',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      53
    ]
  },
  {
    'anum' => 'A010507',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      54
    ]
  },
  {
    'anum' => 'A010508',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      55
    ]
  },
  {
    'anum' => 'A010509',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      56
    ]
  },
  {
    'anum' => 'A010510',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      57
    ]
  },
  {
    'anum' => 'A010511',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      58
    ]
  },
  {
    'anum' => 'A010512',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      59
    ]
  },
  {
    'anum' => 'A010513',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      60
    ]
  },
  {
    'anum' => 'A010514',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      61
    ]
  },
  {
    'anum' => 'A010515',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      62
    ]
  },
  {
    'anum' => 'A010516',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      63
    ]
  },
  {
    'anum' => 'A010517',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      65
    ]
  },
  {
    'anum' => 'A010518',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      66
    ]
  },
  {
    'anum' => 'A010519',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      67
    ]
  },
  {
    'anum' => 'A010520',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      68
    ]
  },
  {
    'anum' => 'A010521',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      69
    ]
  },
  {
    'anum' => 'A010522',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      70
    ]
  },
  {
    'anum' => 'A010523',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      71
    ]
  },
  {
    'anum' => 'A010524',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      72
    ]
  },
  {
    'anum' => 'A010525',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      73
    ]
  },
  {
    'anum' => 'A010526',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      74
    ]
  },
  {
    'anum' => 'A010528',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      76
    ]
  },
  {
    'anum' => 'A010529',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      77
    ]
  },
  {
    'anum' => 'A010530',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      78
    ]
  },
  {
    'anum' => 'A010531',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      79
    ]
  },
  {
    'anum' => 'A010532',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      80
    ]
  },
  {
    'anum' => 'A010533',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      82
    ]
  },
  {
    'anum' => 'A010534',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      83
    ]
  },
  {
    'anum' => 'A010535',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      84
    ]
  },
  {
    'anum' => 'A010536',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      85
    ]
  },
  {
    'anum' => 'A010537',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      86
    ]
  },
  {
    'anum' => 'A010538',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      87
    ]
  },
  {
    'anum' => 'A010539',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      88
    ]
  },
  {
    'anum' => 'A010540',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      89
    ]
  },
  {
    'anum' => 'A010541',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      90
    ]
  },
  {
    'anum' => 'A010542',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      91
    ]
  },
  {
    'anum' => 'A010543',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      92
    ]
  },
  {
    'anum' => 'A010544',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      93
    ]
  },
  {
    'anum' => 'A010545',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      94
    ]
  },
  {
    'anum' => 'A010546',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      95
    ]
  },
  {
    'anum' => 'A010547',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      96
    ]
  },
  {
    'anum' => 'A010548',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      97
    ]
  },
  {
    'anum' => 'A010549',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      98
    ]
  },
  {
    'anum' => 'A010550',
    'class' => 'Math::NumSeq::SqrtDigits',
    'parameters' => [
      'sqrt',
      99
    ]
  },
  {
    'anum' => 'A028254',
    'class' => 'Math::NumSeq::SqrtEngel'
  },
  {
    'anum' => 'A028257',
    'class' => 'Math::NumSeq::SqrtEngel',
    'parameters' => [
      'sqrt',
      3
    ]
  },
  {
    'anum' => 'A059176',
    'class' => 'Math::NumSeq::SqrtEngel',
    'parameters' => [
      'sqrt',
      5
    ]
  },
  {
    'anum' => 'A161368',
    'class' => 'Math::NumSeq::SqrtEngel',
    'parameters' => [
      'sqrt',
      7
    ]
  },
  {
    'anum' => 'A059177',
    'class' => 'Math::NumSeq::SqrtEngel',
    'parameters' => [
      'sqrt',
      10
    ]
  },
  {
    'anum' => 'A000290',
    'class' => 'Math::NumSeq::Squares'
  },
  {
    'anum' => 'A003154',
    'class' => 'Math::NumSeq::StarNumbers'
  },
  {
    'anum' => 'A002487',
    'class' => 'Math::NumSeq::SternDiatomic'
  },
  {
    'anum' => 'A000292',
    'class' => 'Math::NumSeq::Tetrahedral'
  },
  {
    'anum' => 'A000010',
    'class' => 'Math::NumSeq::Totient'
  },
  {
    'anum' => 'A002088',
    'class' => 'Math::NumSeq::TotientCumulative'
  },
  {
    'anum' => 'A082897',
    'class' => 'Math::NumSeq::TotientPerfect'
  },
  {
    'anum' => 'A003434',
    'class' => 'Math::NumSeq::TotientSteps'
  },
  {
    'anum' => 'A053478',
    'class' => 'Math::NumSeq::TotientStepsSum',
    'parameters' => [
      'including_self',
      1
    ]
  },
  {
    'anum' => 'A092693',
    'class' => 'Math::NumSeq::TotientStepsSum',
    'parameters' => [
      'including_self',
      0
    ]
  },
  {
    'anum' => 'A000217',
    'class' => 'Math::NumSeq::Triangular'
  },
  {
    'anum' => 'A000073',
    'class' => 'Math::NumSeq::Tribonacci'
  },
  {
    'anum' => 'A001359',
    'class' => 'Math::NumSeq::TwinPrimes',
    'parameters' => [
      'pairs',
      'first'
    ]
  },
  {
    'anum' => 'A006512',
    'class' => 'Math::NumSeq::TwinPrimes',
    'parameters' => [
      'pairs',
      'second'
    ]
  },
  {
    'anum' => 'A001097',
    'class' => 'Math::NumSeq::TwinPrimes',
    'parameters' => [
      'pairs',
      'both'
    ]
  },
  {
    'anum' => 'A014574',
    'class' => 'Math::NumSeq::TwinPrimes',
    'parameters' => [
      'pairs',
      'average'
    ]
  },
  {
    'anum' => 'A002858',
    'class' => 'Math::NumSeq::UlamSequence',
    'parameters' => [
      'start_values',
      '1,2'
    ]
  },
  {
    'anum' => 'A002859',
    'class' => 'Math::NumSeq::UlamSequence',
    'parameters' => [
      'start_values',
      '1,3'
    ]
  },
  {
    'anum' => 'A003666',
    'class' => 'Math::NumSeq::UlamSequence',
    'parameters' => [
      'start_values',
      '1,4'
    ]
  },
  {
    'anum' => 'A003667',
    'class' => 'Math::NumSeq::UlamSequence',
    'parameters' => [
      'start_values',
      '1,5'
    ]
  },
  {
    'anum' => 'A001857',
    'class' => 'Math::NumSeq::UlamSequence',
    'parameters' => [
      'start_values',
      '2,3'
    ]
  },
  {
    'anum' => 'A048951',
    'class' => 'Math::NumSeq::UlamSequence',
    'parameters' => [
      'start_values',
      '2,4'
    ]
  },
  {
    'anum' => 'A007300',
    'class' => 'Math::NumSeq::UlamSequence',
    'parameters' => [
      'start_values',
      '2,5'
    ]
  },
  {
    'anum' => 'A000975',
    'class' => 'Math::NumSeq::UndulatingNumbers',
    'parameters' => [
      'radix',
      2,
      'including_repdigits',
      0
    ]
  },
  {
    'anum' => 'A003261',
    'class' => 'Math::NumSeq::WoodallNumbers'
  }
]
;
1;
__END__
