#!/usr/bin/perl

# Copyright 2008, 2009 Kevin Ryde

# This file is part of Gtk2-Ex-Clock.
#
# Gtk2-Ex-Clock is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3, or (at your option) any later
# version.
#
# Gtk2-Ex-Clock is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
#
# You should have received a copy of the GNU General Public License along
# with Gtk2-Ex-Clock.  If not, see <http://www.gnu.org/licenses/>.


# Usage: perl screenshot.pl [outputfile.png]
#
# Draw a clock write it to the given output file in PNG format.
# The default output file is /tmp/screenshot.png

use strict;
use warnings;
use File::Basename;
use FindBin;
use POSIX;
use Time::HiRes;
use Gtk2 '-init';
use Gtk2::Ex::Clock;


# PNG spec 11.3.4.2 suggests RFC822 (or rather RFC1123) for CreationTime
use constant STRFTIME_FORMAT_RFC822 => '%a, %d %b %Y %H:%M:%S %z';

my $progname = $FindBin::Script; # basename part
print "progname '$progname'\n";
my $output_filename = (@ARGV >= 1 ? $ARGV[0] : '/tmp/screenshot.png');

my $toplevel = Gtk2::Window->new('toplevel');
$toplevel->signal_connect (destroy => sub { Gtk2->main_quit });

# fake time for Clock.pm to read
# like Test::MockTime, but that module doesn't override Time::HiRes
{ no warnings;
  *Time::HiRes::gettimeofday = sub { return 14*3600 + 59*60 }; # 14:59
}
my $clock = Gtk2::Ex::Clock->new (format => '%a %H:%M',
                                  timezone => 'GMT',
                                  xpad => 6,
                                  ypad => 4);
$toplevel->add ($clock);

Glib::Timeout->add
  (2000,
   sub {
     my $window = $toplevel->window;
     my ($width, $height) = $window->get_size;
     my $pixbuf = Gtk2::Gdk::Pixbuf->get_from_drawable ($window,
                                                        undef, # colormap
                                                        0,0, 0,0,
                                                        $width, $height);
     $pixbuf->save
       ($output_filename, 'png',
        'tEXt::Title'         => 'Clock Screenshot',
        'tEXt::Author'        => 'Kevin Ryde',
        'tEXt::Copyright'     => 'Copyright 2008, 2009 Kevin Ryde',
        'tEXt::Creation Time' => POSIX::strftime (STRFTIME_FORMAT_RFC822,
                                                  localtime(time)),
        'tEXt::Description'   => 'A sample screenshot of a Gtk2::Ex::Clock display',
        'tEXt::Software'      => "Generated by $progname",
        'tEXt::Homepage'      => 'http://www.geocities.com/user42_kevin/gtk2-ex-clock/index.html',
       );
     Gtk2->main_quit;
     return 0; # Glib::SOURCE_REMOVE
   });

$toplevel->show_all;
Gtk2->main;
exit 0
