
# Build the whole PDL distribtuion

$::PP_VERBOSE = 0; # =1 makes PP waffle a lot

# Version test.
BEGIN{
    eval "use 5.005";
    die "PDL requires Perl v5.005 or later\n" if $@ ne "";
}

eval "use 5.6.0";
if ($@ ne ""){
    warn "\nThe TriD and OpenGL packages now require Perl 5.6.0 or later!\n".
	"Building PDL without TriD (WITH_3D=>0)\n\n";
}else{
    $perl_560=1;
}

END{
    warn "\n\n*The next major version of PDL (v2.3) will require Perl v5.6.0 or later!*\n".
	"*Upgrade your perl now for maximum PDL fun in the future!*\n\n" 
	    unless $perl_560;
}

$seen_pdlconf = 0;

# Scan ARGV for config file argument
@ARGV = map {
	if(/^PDLCONF=(.*)$/) {
		$seen_pdlconf=1;
		$pdl_conf_file = $1; ();
	} else {
		$_
	}
} @ARGV;

if(!$seen_pdlconf) {
	my $defname = "$ENV{HOME}/.perldl.conf";
	if(-f $defname) {
		$pdl_conf_file = $defname;
	}
}


# First read in distribution config file 

require './perldl.conf';

%PDL_CONFIG_DIST = %PDL_CONFIG; # Save standard values


# Now read in the users config file if specified

if (-f $pdl_conf_file) {
    warn "\nINFORMATION: using file $pdl_conf_file to set configuration defaults\n\n";
    require $pdl_conf_file;
}

# Sanity checking of user supplied keys (look for ones not defined in dist)

for(keys %PDL_CONFIG) {
	if(!exists($PDL_CONFIG_DIST{$_})) {
	   die("Invalid key $_ found in user supplied $pdl_conf_file - this key appears to be no longer in use. Please review configuration options");
	}
}

# Merge in default options where not supplied in users file

for(keys %PDL_CONFIG_DIST) {
   $PDL_CONFIG{$_} = $PDL_CONFIG_DIST{$_} unless exists $PDL_CONFIG{$_};
}

$PDL_CONFIG{WITH_3D} = 0 unless $perl_560;

# Get Version from Basic/PDL.pm and generated Basic/Core/Version.pm from it
require 'Basic/PDL.pm';

my $versionFile = 'Basic/Core/Version.pm';
open(VERSIONFILE, ">$versionFile") or die("Can't Open '$versionFile' for Writing!\n");
print VERSIONFILE "package PDL::Version;\n\n";
print VERSIONFILE "\# This File was autogenerated by MakeFile.PL from the version\n";
print VERSIONFILE "\#  number in PDL.pm. It is used by PDL::Lite and others as\n";
print VERSIONFILE "\#  a single, consistent place to get the current PDL version.\n\n";
print VERSIONFILE "\$VERSION='".$PDL::VERSION."';\n";
print VERSIONFILE "1;\n";

close VERSIONFILE;

# Are we using bad values or not? Are we using NaN or not?
# NOTE: 
#  only create if there's been a change (or the file doesn't exist)
#  since *.pd uses this as a dependency
#
{
    my $badFile = "Basic/Core/badsupport.p";
    my $create_badFile = 1;

    if ( -e $badFile ) {
	require $badFile;
	if ( $bvalflag == $PDL_CONFIG{WITH_BADVAL} and
	     $usenan   == $PDL_CONFIG{BADVAL_USENAN} ) {
	    $create_badFile = 0;
	}
    }

    if ( $create_badFile ) {
	use IO::File;
	my $fh = new IO::File ">$badFile"
	    or die "Can't open '$badFile' for writing.!\n";
	print $fh "# Autogenerated by top-level Makefile.PL ".(localtime)."\n";
	print $fh "\$bvalflag = $PDL_CONFIG{WITH_BADVAL};\n";
	print $fh "\$usenan   = $PDL_CONFIG{BADVAL_USENAN};\n";
	print $fh "1;  # return true\n";
	$fh->close;
    }
}

use ExtUtils::MakeMaker;

my @podpms = map { $_.".pod", '$(INST_LIBDIR)/PDL/' . $_ .".pod"} 
  qw/perldl pdldoc/;

WriteMakefile(
	      'PREREQ_PM' => { 'ExtUtils::F77' => 1.10, 'File::Spec' => 0.6 },
	      'NAME' => 'PDL',
	      'VERSION_FROM' => 'Basic/Core/Version.pm',
	      'EXE_FILES' => ['perldl', 'pdldoc'],
	      'PM' => { @podpms }, # so that the script docs are picked up                 
	      'MAN3PODS' => {}, # don't pick up the script pods again                        
# 'OPTIMIZE'  => '-g',		  # If you want to debug, uncomment this.
	      'linkext'  => {LINKTYPE => ''},  # No linking required in this directory
	      'dist'     => { COMPRESS => 'gzip', SUFFIX => 'gz'},
	      'clean' => {
		  'FILES' => 'perldl pdldoc pdldoc.db pdldoc.pod perldl.pod ' .
		      'tbyte.tif tmp0 tmp0.hdr tushort.tif ' . 
		      'MANIFEST.bak tmp1* tmpraw* t/tmpraw* t/tmp1*'
		      },
	      'realclean' => {'FILES' => 'Basic/Core/Config.pm'},
	      ($] ge '5.005') ? (
				 'AUTHOR' => 'PerlDL Developers (perldl@jach.hawaii.edu)',
				 'ABSTRACT' => 'Perl Data Language',
				 ) : (),

	      );

print STDERR "Writing Basic/Core/Config.pm\n";

open OUT, ">Basic/Core/Config.pm" or die "Couldn't open Config.pm for writing";
print OUT "# AUTOMATICALLY GENERATED BY THE PDL TOPLEVEL Makefile.PL.
# DO NOT HAND-EDIT - CHANGES WILL BE LOST UPON YOUR NEXT 
#  'perl Makefile.PL'!!!
package PDL;
\%PDL::Config = (
";
for(keys %PDL_CONFIG) {
	print OUT "\t$_\t=>\t";
	if(defined $PDL_CONFIG{$_}) {
		print OUT '"',quotemeta($PDL_CONFIG{$_}),'"';
	} else {
		print OUT "undef";
	}
	print OUT ",\n";
}
print OUT ");\n1;";
close OUT;

# Extra build target to build the doc database

sub MY::postamble {
my $text = 
' 
doctest :: 
	@echo "doctest: Building PDL documentation database in blib ..."
	@$(PERL) -I$(INST_ARCHLIB) -I$(INST_LIB) \
		Doc/scantree.pl 
	@$(PERL)  -I$(INST_ARCHLIB) -I$(INST_LIB) \
		Doc/mkhtmldoc.pl 

doc_site_install ::
	@echo "doc_site_install: Building PDL documentation database ..."
	@$(PERL) -Mblib Doc/scantree.pl $(INSTALLSITEARCH)
	@$(PERL) Doc/mkhtmldoc.pl $(INSTALLSITEARCH)/PDL
  
doc_perl_install ::
	@echo "doc_perl_install: Building PDL documentation database ..."
	@$(PERL) -Mblib Doc/scantree.pl $(INSTALLARCHLIB)
	@$(PERL) Doc/mkhtmldoc.pl $(INSTALLARCHLIB)/PDL

';

# note: podselect wasn't in the perl distribution prior to 5.6.0
my $podsel = "podselect";

if ( $] < 5.006 ) {
    # make your own podsel
    $podsel = "podsel";
    print "Building a simple version of podselect, called $podsel.\n";
    unlink $podsel if -f $podsel;
    my $fh = new IO::File "> $podsel" or die "Can't create $podsel: $!";
    
    use Config;
    print $fh <<"!GROK!THIS!";
$Config{'startperl'}
    eval 'exec perl -S \$0 "\$@"'
        if 0;
!GROK!THIS!

    # no variable substitution here
    print $fh <<'!NO!SUBS!';                                                

# script to emulate podselect (available in perl 5.6.0)
use blib;
use PDL::Pod::Select;

die "Usage: $0 <file>\n" if $#ARGV == -1;
podselect(@ARGV);
exit;
!NO!SUBS!
    $fh->close;
    chmod 0755, $podsel;
    $podsel = "./$podsel"; # '.' may not be in our path (potential win32 problem?)
} # if: perl version < 5.006

$text .=                                                                      
"
perldl.pod : perldl subdirs
\t$podsel perldl > perldl.pod

pdldoc.pod : pdldoc subdirs
\t$podsel pdldoc > pdldoc.pod

";

return $text

}

sub MY::test {
        package MY; # so that "SUPER" works right
        my $inherited = shift->SUPER::test(@_);
	my @lines = split "\n", $inherited;
	my @new = ();
	my $pass = 1;
	foreach (@lines) {
		if ($pass) {
			push @new, $_;
			$pass = 0 if /^test\b/;
		} else {
			if (/^\s*$/) {
				push @new, '';
				$pass = 1;
			}
		}
	}
	return join("\n", @new,"\n");
}

