package Finance::Bank::Transaction;

sub grok_ga {
    my $trans=shift;
    return if not $trans->{misc1};
    if ($trans->{misc1} =~ /^GA NR(\d{8}) BLZ(\d{8}) (\d)$/) {
	$trans->{type} = 'ATM';
	$trans->{atm_number}=$1;
	$trans->{atm_blz}=$2;
	$trans->{atm_unknown}=$3;
	# The meaning of the * vs space before the GEB is unknown, but
	# probably just a different ATM being obnixious.
	# The lack of support for non-EUR currency is a bug.
	$trans->{'misc2'} =~ m<^(\d\d)\.(\d\d)/(\d\d)\.(\d\d)UHR\ (.*?) EUR([\d ]{8},\d\d)[* ]GEB\.EUR([\d ]\d,\d\d)$>
	  or warn "Strange ATM transaction?" and return;
	my ($day,$month,$hour,$minute)=($1,$2,$3,$4);
	# $trans->{bill_date}
	$trans->{atm_desc}=$5;
	$trans->{atm_amount}=cleanamount($6);
	$trans->{atm_fees}=cleanamount($7);
	
	$trans->{groked}++;
    }
}

# Called "minimal" because that's the place we shop the most that uses this
# comment-info format.  
# Also used by Karstadt, HL, Media Markt, C&A...
sub grok_minimal {
    my $trans=shift;
    return unless $trans->{misc2};
    return unless ($trans->{misc2} =~ m<^(\d{27})>);
    $trans->{__minimal_info}++;
    
    local $_=$1;
    my $day   = substr($_, 0, 2);
    my $month = substr($_, 2, 2);
    my $hour  = substr($_, 4, 2);
    my $min   = substr($_, 6, 2);
    # FIXME: Format does not provide for year (?), so assume this year.
    # FIXME: Assume not in future?
    my $year  = (localtime)[5];
    local $ENV{TZ}="MET"; # middle-european time.
    
    # Scalar localtime for debugging
    $trans->{bill_date}=timelocal(0,$min,$hour,$day,$month-1,$year);

    # Bunch of ??? digits here
    
    $trans->{store_number}   =substr($_, 19, 4)+0;
    $trans->{checkout_number}=substr($_, 23, 4)+0;
    
    $trans->{groked}++;
}

sub grok_visa {
    my $trans=shift;
    
    # VISA transactions
    return unless $trans->{misc1};
    return unless ($trans->{misc1} =~ /^VISAUMSATZ (\d{16})$/);
    $trans->{type}='credit card';
    $trans->{ccard_type}='VISA';
    $trans->{ccard_number}=$1;
    
    # CAFE PRESS.COM       26.02. 877-809-165 US        22,71 KURS ZU EURO       1,237300 GEBUEHR 00000000,32
    # USAIR       03741773 21.04. BERLIN      DE         0,00 0,000000 
    return unless ($trans->{misc2} =~ /^(.{20}) (\d\d)\.(\d\d)\. (.{11}) (..) ([ \d]{9},\d\d) (.*)/);
    $trans->{info1}=$1;
    my $day=$2;
    my $mon=$3;
    # FIXME: Format does not provide for year (?), so assume this year.
    # FIXME: Assume not in future?
    my $year  = (localtime)[5];
    local $ENV{TZ}="MET"; # middle-european time.
    $trans->{bill_date}=timelocal(0,0,0,$day,$mon-1,$year);
    $trans->{info2}=$4;
    $trans->{country}=$5;
    $trans->{amount_remote_currency}=cleanamount($6) || $trans->{amount};
    $7 =~ m/ *(KURS ZU EURO ([ \d]{7},\d{6}))? *(GEBUEHR ([ \d]{8}[.,]\d\d))?/;
    $trans->{exchangerate} = cleannumber $2 || 1;
    $trans->{fees} = cleannumber $4 || 0;
    
    # Amount = amount_remote_currency/exchangerate + fees
    my $err = $trans->{amount} - 
      ($trans->{amount_remote_currency}/$trans->{exchangerate} +
       $trans->{fees});
    warn "Error $err" if abs($err)>0.005;

    $trans->{groked}++;
}

sub grok_ec {
    my $trans = shift;
    
    return unless $trans->{misc2} 
      and ($trans->{misc2} =~ m/^(?:EC |ELV|POZ)(\d{8}) (\d\d)\.(\d\d) (\d\d)\.(\d\d) (...)$/);
    # print "Past EC regex.\n";
    #                               1       2       3      4       5      6
    # $trans->{???} = $1; # ???
    # print $trans->{misc2}, "\n";
    my ($day, $mon, $hour, $min) = ($2,$3,$4,$5);
    my $tz = $6;
    $tz =~ s/ME0/MET/;
    local $ENV{TZ}=$tz;
    $trans->{sale_date} = timelocal(0,$min,$hour,$day,$mon-1,(localtime)[5]);

    $trans->{groked}++;
}

# This is the version of POZ transactions that do not begin with a 27 digit
# number.
sub grok_poz {
    my $trans=shift;
    
    return unless $trans->{misc2};
    # If the "minimal" 27-digit number is there, don't try to do this
    # (far more heuristic) parsing.
    return if ($trans->{groked});
    
    return unless $trans->{misc2} =~ /((?:POZ|ELV)\d{8}) (\d\d)\.(\d\d) (\d\d)\.(\d\d) (...)/;
    my ($reader, $day, $month, $hour, $minute, $tz) = ($1,$2,$3,$4,$5,$6);
    
    $tz =~ s/ME0/MET/;
    local $ENV{TZ}=$tz;
    my $date = timelocal(0,$minute,$hour,$day,$month-1,(localtime)[5]);
    $trans->{bill_date}=$date;
#    $trans->{type}=$type;
    $trans->{card_reader}=$reader;
    
    $trans->{groked}++;
}
