package Paws::GameLift::FleetAttributes;
  use Moose;
  has BuildId => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has FleetId => (is => 'ro', isa => 'Str');
  has LogPaths => (is => 'ro', isa => 'ArrayRef[Str]');
  has Name => (is => 'ro', isa => 'Str');
  has NewGameSessionProtectionPolicy => (is => 'ro', isa => 'Str');
  has ServerLaunchParameters => (is => 'ro', isa => 'Str');
  has ServerLaunchPath => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has TerminationTime => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::FleetAttributes

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::FleetAttributes object:

  $service_obj->Method(Att1 => { BuildId => $value, ..., TerminationTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::FleetAttributes object:

  $result = $service_obj->Method(...);
  $result->Att1->BuildId

=head1 DESCRIPTION

General properties describing a fleet.

=head1 ATTRIBUTES


=head2 BuildId => Str

  Unique identifier for a build.


=head2 CreationTime => Str

  Time stamp indicating when this object was created. Format is an
integer representing the number of seconds since the Unix epoch (Unix
time).


=head2 Description => Str

  Human-readable description of the fleet.


=head2 FleetId => Str

  Unique identifier for a fleet.


=head2 LogPaths => ArrayRef[Str]

  Path to game-session log files generated by your game server. Once a
game session has been terminated, Amazon GameLift captures and stores
the logs on Amazon S3. Use the GameLift console to access the stored
logs.


=head2 Name => Str

  Descriptive label associated with this fleet. Fleet names do not need
to be unique.


=head2 NewGameSessionProtectionPolicy => Str

  Type of game session protection to set for all new instances started in
the fleet.

=over

=item * NoProtection: The game session can be terminated during a
scale-down event.

=item * FullProtection: If the game session is in an ACTIVE status, it
cannot be terminated during a scale-down event.

=back



=head2 ServerLaunchParameters => Str

  Parameters required to launch your game server. These parameters should
be expressed as a string of command-line parameters. Example: "+sv_port
33435 +start_lobby".


=head2 ServerLaunchPath => Str

  Path to the launch executable for the game server. A game server is
built into a C<C:\game> drive. This value must be expressed as
C<C:\game\[launchpath]>. Example: If, when built, your game server
files are in a folder called "MyGame", your log path should be
C<C:\game\MyGame\server.exe>.


=head2 Status => Str

  Current status of the fleet. Possible fleet states include:

=over

=item * NEW: A new fleet has been defined and hosts allocated.

=item * DOWNLOADING/VALIDATING/BUILDING/ACTIVATING: The new fleet is
being set up with the game build, and new hosts are being started.

=item * ACTIVE: Hosts can now accept game sessions.

=item * ERROR: An error occurred when downloading, validating,
building, or activating the fleet.

=item * DELETING: Hosts are responding to a delete fleet request.

=item * TERMINATED: The fleet no longer exists.

=back



=head2 TerminationTime => Str

  Time stamp indicating when this fleet was terminated. Format is an
integer representing the number of seconds since the Unix epoch (Unix
time).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: https://github.com/pplu/aws-sdk-perl

Please report bugs to: https://github.com/pplu/aws-sdk-perl/issues

=cut

