=head1

Locale::CLDR::Locales::Ta - Package for language Tamil

=cut

package Locale::CLDR::Locales::Ta;
# This file auto generated from Data\common\main\ta.xml
#	on Sat  6 Feb 11:03:32 am GMT

use version;

our $VERSION = version->declare('v0.28.3');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => 'ArrayRef',
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal','spellout-ordinal','digits-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => 'HashRef',
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'digits-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(−→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=#,##,##0=.),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=#,##,##0=.),
				},
			},
		},
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(எதிர்ம →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(பூஜ்யம்),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← புள்ளி →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(ஒன்று),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(இரண்டு),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(மூன்று),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(நான்கு),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(ஐந்து),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(ஆறு),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(ஏழு),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(எட்டு),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(ஒன்பது),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(பத்து),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(பதினொன்று),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(பன்னிரண்டு),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(பதின்மூன்று),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(பதினான்கு),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(பதினைந்து),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(பதினாறு),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(பதினேழு),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(பதினெட்டு),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(பத்தொன்பது),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(இருபது[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(முப்பது[ →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(நாற்பது[ →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(ஐம்பது[ →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(அறுபது[ →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(எழுபது[ →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(எண்பது[ →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(தொண்ணூறு[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(நூறு[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(இருநூறு[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(முந்நூறு[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(நாநூறூ[ →→]),
				},
				'500' => {
					base_value => q(500),
					divisor => q(100),
					rule => q(ஐநூறு[ →→]),
				},
				'600' => {
					base_value => q(600),
					divisor => q(100),
					rule => q(அறுநூறு[ →→]),
				},
				'700' => {
					base_value => q(700),
					divisor => q(100),
					rule => q(எழுநூறு[ →→]),
				},
				'800' => {
					base_value => q(800),
					divisor => q(100),
					rule => q(எண்நூறு[ →→]),
				},
				'900' => {
					base_value => q(900),
					divisor => q(100),
					rule => q(தொள்ளாயிரம்[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←← ஆயிரம்[ →→]),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(←← லட்சம்[ →→]),
				},
				'10000000' => {
					base_value => q(10000000),
					divisor => q(10000000),
					rule => q(←← கோடி[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(எதிர்ம →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(பூஜ்யம்),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(முதலாவது),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(இரண்டாவது),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(மூன்றாவது),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(நான்காவது),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(ஐந்தாவது),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(ஆறாவது),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(ஏழாவது),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(எட்டாவது),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(ஒன்பதாவது),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(பத்தாவது),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(பதினொன்றாவது),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(பன்னிரண்டாவது),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(பதிமூன்றாவது),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(பதிநான்காவது),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(பதினைந்தாவது),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(பதினாறாவது),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(பதினேழாவது),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(பதினெட்டாவது),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(பத்தொன்பதாவது),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(இருபதாவது),
				},
				'21' => {
					base_value => q(21),
					divisor => q(10),
					rule => q(=#,##,##0=ாவது),
				},
				'max' => {
					base_value => q(21),
					divisor => q(10),
					rule => q(=#,##,##0=ாவது),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'அஃபார்',
 				'ab' => 'அப்காஜியான்',
 				'ace' => 'ஆச்சினீஸ்',
 				'ach' => 'அகோலி',
 				'ada' => 'அதாங்மே',
 				'ady' => 'அதகே',
 				'ae' => 'அவெஸ்தான்',
 				'aeb' => 'துனிசிய அரபு',
 				'af' => 'ஆஃப்ரிகான்ஸ்',
 				'afh' => 'அஃப்ரிஹிலி',
 				'agq' => 'அகெம்',
 				'ain' => 'ஐனு',
 				'ak' => 'அகான்',
 				'akk' => 'அக்கேதியன்',
 				'ale' => 'அலூட்',
 				'alt' => 'தெற்கு அல்தை',
 				'am' => 'அம்ஹாரிக்',
 				'an' => 'ஆர்கோனீஸ்',
 				'ang' => 'பழைய ஆங்கிலம்',
 				'anp' => 'அங்கிகா',
 				'ar' => 'அரபிக்',
 				'ar_001' => 'நவீன நிலையான அரபிக்',
 				'arc' => 'அராமைக்',
 				'arn' => 'மபுசே',
 				'arp' => 'அரபஹோ',
 				'arw' => 'அராவாக்',
 				'as' => 'அஸ்ஸாமீஸ்',
 				'asa' => 'அசு',
 				'ast' => 'அஸ்துரியன்',
 				'av' => 'அவேரிக்',
 				'awa' => 'அவதி',
 				'ay' => 'அய்மரா',
 				'az' => 'அஸர்பைஜானி',
 				'az@alt=short' => 'அஸேரி',
 				'ba' => 'பஷ்கிர்',
 				'bal' => 'பெலுசி',
 				'ban' => 'பலினீஸ்',
 				'bas' => 'பாஸா',
 				'be' => 'பெலாருஷியன்',
 				'bej' => 'பேஜா',
 				'bem' => 'பெம்பா',
 				'bez' => 'பெனா',
 				'bfq' => 'படகா',
 				'bg' => 'பல்கேரியன்',
 				'bgn' => 'மேற்கு பலோச்சி',
 				'bho' => 'போஜ்பூரி',
 				'bi' => 'பிஸ்லாமா',
 				'bik' => 'பிகோல்',
 				'bin' => 'பினி',
 				'bla' => 'சிக்சிகா',
 				'bm' => 'பம்பாரா',
 				'bn' => 'வங்காளம்',
 				'bo' => 'திபெத்தியன்',
 				'bpy' => 'பிஷ்ணுப்பிரியா',
 				'br' => 'பிரெட்டன்',
 				'bra' => 'ப்ராஜ்',
 				'brx' => 'போடோ',
 				'bs' => 'போஸ்னியன்',
 				'bua' => 'புரியாத்',
 				'bug' => 'புகினீஸ்',
 				'byn' => 'ப்லின்',
 				'ca' => 'கேட்டலான்',
 				'cad' => 'கேடோ',
 				'car' => 'கரீப்',
 				'cch' => 'ஆட்சம்',
 				'ce' => 'செச்சென்',
 				'ceb' => 'செபுவானோ',
 				'cgg' => 'சிகா',
 				'ch' => 'சாமோரோ',
 				'chb' => 'சிப்சா',
 				'chg' => 'ஷகதை',
 				'chk' => 'சூகிசே',
 				'chm' => 'மாரி',
 				'chn' => 'சினூக் ஜார்கான்',
 				'cho' => 'சோக்தௌ',
 				'chp' => 'சிபெவ்யான்',
 				'chr' => 'செரோகீ',
 				'chy' => 'செயேனி',
 				'ckb' => 'மத்திய குர்திஷ்',
 				'co' => 'கார்சிகன்',
 				'cop' => 'காப்டிக்',
 				'cr' => 'க்ரீ',
 				'crh' => 'கிரிமியன் துர்க்கி',
 				'cs' => 'செக்',
 				'csb' => 'கஷுபியன்',
 				'cu' => 'சர்ச் ஸ்லாவிக்',
 				'cv' => 'சுவாஷ்',
 				'cy' => 'வேல்ஷ்',
 				'da' => 'டேனிஷ்',
 				'dak' => 'தகோடா',
 				'dar' => 'தார்குவா',
 				'dav' => 'டைடா',
 				'de' => 'ஜெர்மன்',
 				'de_AT' => 'ஆஸ்திரிய ஜெர்மன்',
 				'de_CH' => 'ஸ்விஸ் ஹை ஜெர்மன்',
 				'del' => 'தெலாவேர்',
 				'den' => 'ஸ்லாவ்',
 				'dgr' => 'டோக்ரிப்',
 				'din' => 'டின்கா',
 				'dje' => 'சார்மா',
 				'doi' => 'டோக்ரி',
 				'dsb' => 'லோயர் சோர்பியன்',
 				'dua' => 'டுவாலா',
 				'dum' => 'மத்திய டச்சு',
 				'dv' => 'திவேஹி',
 				'dyo' => 'ஜோலா-ஃபோன்யி',
 				'dyu' => 'ட்யூலா',
 				'dz' => 'பூடானி',
 				'ebu' => 'எம்பு',
 				'ee' => 'ஈவ்',
 				'efi' => 'எஃபிக்',
 				'egy' => 'பண்டைய எகிப்தியன்',
 				'eka' => 'ஈகாஜுக்',
 				'el' => 'கிரேக்கம்',
 				'elx' => 'எலமைட்',
 				'en' => 'ஆங்கிலம்',
 				'en_AU' => 'ஆஸ்திரேலிய ஆங்கிலம்',
 				'en_CA' => 'கனடிய ஆங்கிலம்',
 				'en_GB' => 'பிரிட்டிஷ் ஆங்கிலம்',
 				'en_GB@alt=short' => 'ஆங்கிலம் (யூகே)',
 				'en_US' => 'அமெரிக்க ஆங்கிலம்',
 				'enm' => 'மத்திய ஆங்கிலம்',
 				'eo' => 'எஸ்பரேன்டோ',
 				'es' => 'ஸ்பானிஷ்',
 				'es_ES' => 'ஸ்பானிஷ் (ஐரோப்பா)',
 				'et' => 'எஸ்டோனியன்',
 				'eu' => 'பாஸ்க்',
 				'ewo' => 'எவோன்டோ',
 				'fa' => 'பெர்ஷியன்',
 				'fan' => 'ஃபங்க்',
 				'fat' => 'ஃபான்டி',
 				'ff' => 'ஃபுலா',
 				'fi' => 'ஃபின்னிஷ்',
 				'fil' => 'ஃபிலிபினோ',
 				'fj' => 'ஃபிஜியன்',
 				'fo' => 'ஃபரோயிஸ்',
 				'fon' => 'ஃபான்',
 				'fr' => 'பிரெஞ்சு',
 				'fr_CA' => 'கனடிய பிரெஞ்சு',
 				'fr_CH' => 'ஸ்விஸ் பிரஞ்சு',
 				'frm' => 'மத்திய ஃப்ரென்ச்',
 				'fro' => 'பழைய ஃப்ரென்ச்',
 				'frr' => 'வடக்கு ஃப்ரிஸியான்',
 				'frs' => 'கிழக்கு ஃப்ரிஸியான்',
 				'fur' => 'ஃப்ரியூலியன்',
 				'fy' => 'மேற்கு ஃப்ரிஷியன்',
 				'ga' => 'ஐரிஷ்',
 				'gaa' => 'கா',
 				'gag' => 'காகௌஸ்',
 				'gay' => 'கயோ',
 				'gba' => 'பயா',
 				'gd' => 'ஸ்காட்ஸ் கேலிக்',
 				'gez' => 'கீஜ்',
 				'gil' => 'கில்பெர்டீஸ்',
 				'gl' => 'காலிஸியன்',
 				'gmh' => 'மத்திய ஹை ஜெர்மன்',
 				'gn' => 'குரானி',
 				'goh' => 'பழைய ஹை ஜெர்மன்',
 				'gon' => 'கோன்டி',
 				'gor' => 'கோரோன்டலோ',
 				'got' => 'கோதிக்',
 				'grb' => 'க்ரேபோ',
 				'grc' => 'பண்டைய கிரேக்கம்',
 				'gsw' => 'ஜெர்மன் (ஸ்விஸ்)',
 				'gu' => 'குஜராத்தி',
 				'guz' => 'குஸி',
 				'gv' => 'மேங்க்ஸ்',
 				'gwi' => 'குவிசின்',
 				'ha' => 'ஹௌஸா',
 				'hai' => 'ஹைடா',
 				'haw' => 'ஹவாயியன்',
 				'he' => 'ஹீப்ரூ',
 				'hi' => 'இந்தி',
 				'hif' => 'பிஜி இந்தி',
 				'hil' => 'ஹிலிகாய்னான்',
 				'hit' => 'ஹிட்டைட்',
 				'hmn' => 'மாங்க்',
 				'ho' => 'ஹிரி மோட்டு',
 				'hr' => 'குரோஷியன்',
 				'hsb' => 'அப்பர் சோர்பியான்',
 				'ht' => 'ஹைத்தியன்',
 				'hu' => 'ஹங்கேரியன்',
 				'hup' => 'ஹுபா',
 				'hy' => 'ஆர்மேனியன்',
 				'hz' => 'ஹெரேரோ',
 				'ia' => 'இண்டர்லிங்வா',
 				'iba' => 'இபான்',
 				'id' => 'இந்தோனேஷியன்',
 				'ie' => 'இன்டர்லிங்',
 				'ig' => 'இக்போ',
 				'ii' => 'சிசுவான் ஈ',
 				'ik' => 'இனுபியாக்',
 				'ilo' => 'இலோகோ',
 				'inh' => 'இங்குஷ்',
 				'io' => 'இடோ',
 				'is' => 'ஐஸ்லேண்டிக்',
 				'it' => 'இத்தாலியன்',
 				'iu' => 'இனுகிடூட்',
 				'ja' => 'ஜப்பானியம்',
 				'jbo' => 'லோஜ்பன்',
 				'jgo' => 'நகொம்பா',
 				'jmc' => 'மாசெம்',
 				'jpr' => 'ஜூதேயோ-பெர்ஷியன்',
 				'jrb' => 'ஜூதேயோ-அராபிக்',
 				'jv' => 'ஜாவனீஸ்',
 				'ka' => 'ஜார்ஜியன்',
 				'kaa' => 'காரா-கல்பாக்',
 				'kab' => 'கபாய்ல்',
 				'kac' => 'காசின்',
 				'kaj' => 'ஜ்ஜூ',
 				'kam' => 'கம்பா',
 				'kaw' => 'காவி',
 				'kbd' => 'கபார்டியன்',
 				'kcg' => 'தையாப்',
 				'kde' => 'மகொண்டே',
 				'kea' => 'கபுவெர்தியானு',
 				'kfo' => 'கோரோ',
 				'kg' => 'காங்கோ',
 				'kha' => 'காஸி',
 				'kho' => 'கோதானீஸ்',
 				'khq' => 'கொய்ரா சீனீ',
 				'ki' => 'கிகுயூ',
 				'kj' => 'குவான்யாமா',
 				'kk' => 'கசாக்',
 				'kl' => 'கலாலிசூட்',
 				'kln' => 'கலின்ஜின்',
 				'km' => 'கெமெர்',
 				'kmb' => 'கிம்புன்து',
 				'kn' => 'கன்னடம்',
 				'ko' => 'கொரியன்',
 				'koi' => 'கொமி-பெர்ம்யாக்',
 				'kok' => 'கொங்கணி',
 				'kos' => 'கோஸ்ரைன்',
 				'kpe' => 'க்பெல்லே',
 				'kr' => 'கனுரி',
 				'krc' => 'கராசே-பல்கார்',
 				'krl' => 'கரேலியன்',
 				'kru' => 'குருக்',
 				'ks' => 'காஷ்மிரி',
 				'ksb' => 'ஷம்பாலா',
 				'ksf' => 'பாஃபியா',
 				'ku' => 'குர்திஷ்',
 				'kum' => 'கும்இக்',
 				'kut' => 'குடேனை',
 				'kv' => 'கோமி',
 				'kw' => 'கார்னிஷ்',
 				'ky' => 'கிர்கிஸ்',
 				'la' => 'லத்தின்',
 				'lad' => 'லடினோ',
 				'lag' => 'லங்கி',
 				'lah' => 'லஹன்டா',
 				'lam' => 'லம்பா',
 				'lb' => 'லக்ஸம்போர்கிஷ்',
 				'lez' => 'லெஜ்ஜியன்',
 				'lg' => 'கான்டா',
 				'li' => 'லிம்பர்கிஷ்',
 				'lkt' => 'லகோடா',
 				'ln' => 'லிங்காலா',
 				'lo' => 'லாவோ',
 				'lol' => 'மோங்கோ',
 				'loz' => 'லோசி',
 				'lrc' => 'வடக்கு லுரி',
 				'lt' => 'லிதுவேனியன்',
 				'lu' => 'லுபா-கடாங்கா',
 				'lua' => 'லுபா-லுலுலா',
 				'lui' => 'லுய்சேனோ',
 				'lun' => 'லூன்டா',
 				'luo' => 'லுயோ',
 				'lus' => 'லுஷய்',
 				'luy' => 'லுயியா',
 				'lv' => 'லாட்வியன்',
 				'mad' => 'மதுரீஸ்',
 				'mag' => 'மகாஹி',
 				'mai' => 'மைதிலி',
 				'mak' => 'மகாசார்',
 				'man' => 'மான்டிங்கோ',
 				'mas' => 'மாசாய்',
 				'mdf' => 'மோக்க்ஷா',
 				'mdr' => 'மான்டார்',
 				'men' => 'மென்டீ',
 				'mer' => 'மெரு',
 				'mfe' => 'மொரிசியன்',
 				'mg' => 'மலகாஸி',
 				'mga' => 'மத்திய ஐரிஷ்',
 				'mgh' => 'மகுவா-மீட்டோ',
 				'mgo' => 'மேடா',
 				'mh' => 'மார்ஷெலிஷ்',
 				'mi' => 'மௌரி',
 				'mic' => 'மிக்மாக்',
 				'min' => 'மின்னாங்கபௌ',
 				'mk' => 'மாஸிடோனியன்',
 				'ml' => 'மலையாளம்',
 				'mn' => 'மங்கோலியன்',
 				'mnc' => 'மன்சு',
 				'mni' => 'மனிபூரி',
 				'moh' => 'மொஹாக்',
 				'mos' => 'மோஸ்ஸி',
 				'mr' => 'மராத்தி',
 				'ms' => 'மலாய்',
 				'mt' => 'மால்டிஸ்',
 				'mua' => 'முன்டாங்',
 				'mul' => 'பல மொழிகள்',
 				'mus' => 'க்ரீக்',
 				'mwl' => 'மிரான்டீஸ்',
 				'mwr' => 'மார்வாரி',
 				'my' => 'பர்மீஸ்',
 				'myv' => 'ஏர்ஜியா',
 				'mzn' => 'மசந்தேரனி',
 				'na' => 'நவ்ரூ',
 				'nap' => 'நியோபோலிடன்',
 				'naq' => 'நாமா',
 				'nb' => 'நார்வேஜியன் பொக்மால்',
 				'nd' => 'வடக்கு தெபெலே',
 				'nds' => 'லோ ஜெர்மன்',
 				'nds_NL' => 'லோ சாக்ஸன்',
 				'ne' => 'நேபாளி',
 				'new' => 'நெவாரி',
 				'ng' => 'தோங்கா',
 				'nia' => 'நியாஸ்',
 				'niu' => 'நியூவான்',
 				'nl' => 'டச்சு',
 				'nl_BE' => 'ஃப்லெமிஷ்',
 				'nmg' => 'க்வாசியோ',
 				'nn' => 'நார்வேஜியன் நியூநார்ஸ்க்',
 				'no' => 'நார்வே',
 				'nog' => 'நோகை',
 				'non' => 'பழைய நோர்ஸ்',
 				'nqo' => 'என்‘கோ',
 				'nr' => 'தெற்கு தெபெலே',
 				'nso' => 'வடக்கு சோதோ',
 				'nus' => 'நியூர்',
 				'nv' => 'நவாஜோ',
 				'nwc' => 'பாரம்பரிய நேவாரி',
 				'ny' => 'நயன்ஜா',
 				'nym' => 'நியாம்வேஜி',
 				'nyn' => 'நியான்கோலே',
 				'nyo' => 'நியோரோ',
 				'nzi' => 'நிஜ்மா',
 				'oc' => 'ஒக்கிடன்',
 				'oj' => 'ஓஜிபவா',
 				'om' => 'ஒரோமோ',
 				'or' => 'ஒரியா',
 				'os' => 'ஒசெட்டிக்',
 				'osa' => 'ஓசேஜ்',
 				'ota' => 'ஒட்டோமன் துர்க்கி',
 				'pa' => 'பஞ்சாபி',
 				'pag' => 'பன்காசினன்',
 				'pal' => 'பாஹ்லவி',
 				'pam' => 'பம்பாங்கா',
 				'pap' => 'பபியேமென்டோ',
 				'pau' => 'பலௌவ்ன்',
 				'pdc' => 'பென்சில்வேனிய ஜெர்மன்',
 				'peo' => 'பழைய பெர்ஷியன்',
 				'phn' => 'ஃபொனிஷியன்',
 				'pi' => 'பாலி',
 				'pl' => 'போலிஷ்',
 				'pon' => 'ஃபோன்பெயென்',
 				'pro' => 'பழைய ப்ரோவென்சால்',
 				'ps' => 'பஷ்தோ',
 				'ps@alt=variant' => 'புஷ்தோ',
 				'pt' => 'போர்ச்சுக்கீஸ்',
 				'pt_BR' => 'போர்ச்சுகீஸ் (பிரேசில்)',
 				'pt_PT' => 'போர்ச்சுகீஸ் (ஐரோப்பா)',
 				'qu' => 'கிவேசுவா',
 				'quc' => 'கீசீ',
 				'raj' => 'ராஜஸ்தானி',
 				'rap' => 'ரபனுய்',
 				'rar' => 'ரரோடோங்கன்',
 				'rm' => 'ரோமான்ஷ்',
 				'rn' => 'ருண்டி',
 				'ro' => 'ரோமேனியன்',
 				'ro_MD' => 'மோல்டாவியன்',
 				'rof' => 'ரோம்போ',
 				'rom' => 'ரோமானி',
 				'root' => 'ரூட்',
 				'ru' => 'ரஷியன்',
 				'rup' => 'அரோமானியன்',
 				'rw' => 'கின்யாருவான்டா',
 				'rwk' => 'ருவா',
 				'sa' => 'சமஸ்கிருதம்',
 				'sad' => 'சான்டாவே',
 				'sah' => 'யாகுட்',
 				'sam' => 'சமாரிடன் அராமைக்',
 				'saq' => 'சம்புரு',
 				'sas' => 'சாசாக்',
 				'sat' => 'சான்டாலி',
 				'saz' => 'சௌராஷ்டிரம்',
 				'sbp' => 'சங்கு',
 				'sc' => 'சாடினியன்',
 				'scn' => 'சிசிலியன்',
 				'sco' => 'ஸ்காட்ஸ்',
 				'sd' => 'சிந்தி',
 				'sdh' => 'தெற்கு குர்திஷ்',
 				'se' => 'வடக்கு சமி',
 				'seh' => 'செனா',
 				'sel' => 'செல்குப்',
 				'ses' => 'கொய்ராபோரோ சென்னி',
 				'sg' => 'சாங்கோ',
 				'sga' => 'பழைய ஐரிஷ்',
 				'sh' => 'செர்போ-க்ரோஷியன்',
 				'shi' => 'தசேஹித்',
 				'shn' => 'ஷான்',
 				'si' => 'சிங்களம்',
 				'sid' => 'சிடாமோ',
 				'sk' => 'ஸ்லோவாக்',
 				'sl' => 'ஸ்லோவேனியன்',
 				'sm' => 'ஸாமோவான்',
 				'sma' => 'தெற்கு சமி',
 				'smj' => 'லுலே சமி',
 				'smn' => 'இனாரி சமி',
 				'sms' => 'ஸ்கோல்ட் சமி',
 				'sn' => 'ஷோனா',
 				'snk' => 'சோனின்கே',
 				'so' => 'சோமாலி',
 				'sog' => 'சோக்தியன்',
 				'sq' => 'அல்பேனியன்',
 				'sr' => 'செர்பியன்',
 				'srn' => 'ஸ்ரானன் டோங்கோ',
 				'srr' => 'செரெர்',
 				'ss' => 'ஸ்வாடீ',
 				'st' => 'தெற்கு ஸோதோ',
 				'su' => 'சுண்டானீஸ்',
 				'suk' => 'சுகுமா',
 				'sus' => 'சுசு',
 				'sux' => 'சுமேரியன்',
 				'sv' => 'ஸ்வீடிஷ்',
 				'sw' => 'சுவாஹிலி',
 				'swb' => 'கொமோரியன்',
 				'swc' => 'காங்கோ சுவாஹிலி',
 				'syc' => 'பாரம்பரிய சிரியாக்',
 				'syr' => 'சிரியாக்',
 				'ta' => 'தமிழ்',
 				'te' => 'தெலுங்கு',
 				'tem' => 'டிம்னே',
 				'teo' => 'டெசோ',
 				'ter' => 'டெரெனோ',
 				'tet' => 'டெடும்',
 				'tg' => 'தாஜிக்',
 				'th' => 'தாய்',
 				'ti' => 'டிக்ரின்யா',
 				'tig' => 'டைக்ரே',
 				'tiv' => 'டிவ்',
 				'tk' => 'துருக்மென்',
 				'tkl' => 'டோகேலௌ',
 				'tl' => 'டாகாலோக்',
 				'tlh' => 'க்ளிங்கோன்',
 				'tli' => 'டிலிங்கிட்',
 				'tmh' => 'டாமாஷேக்',
 				'tn' => 'ஸ்வானா',
 				'to' => 'டோங்கான்',
 				'tog' => 'நயாசா டோங்கா',
 				'tpi' => 'டோக் பிஸின்',
 				'tr' => 'துருக்கிஷ்',
 				'ts' => 'ஸோங்கா',
 				'tsi' => 'ட்ஸிம்ஷியன்',
 				'tt' => 'டாடர்',
 				'tum' => 'தும்புகா',
 				'tvl' => 'டுவாலு',
 				'tw' => 'ட்வி',
 				'twq' => 'டசவாக்',
 				'ty' => 'டஹிதியான்',
 				'tyv' => 'டுவினியன்',
 				'tzm' => 'மத்திய அட்லஸ் டமசைட்',
 				'udm' => 'உட்முர்ட்',
 				'ug' => 'உய்குர்',
 				'uga' => 'உகாரிட்க்',
 				'uk' => 'உக்ரைனியன்',
 				'umb' => 'அம்பொண்டு',
 				'und' => 'அறியப்படாத மொழி',
 				'ur' => 'உருது',
 				'uz' => 'உஸ்பெக்',
 				'vai' => 'வை',
 				've' => 'வென்டா',
 				'vi' => 'வியட்நாமிஸ்',
 				'vo' => 'ஒலாபூக்',
 				'vot' => 'வோட்க்',
 				'vun' => 'வுன்ஜோ',
 				'wa' => 'ஒவாலூன்',
 				'wal' => 'வாலாமோ',
 				'war' => 'வாரே',
 				'was' => 'வாஷோ',
 				'wbp' => 'வல்பிரி',
 				'wo' => 'ஒலூஃப்',
 				'xal' => 'கல்மிக்',
 				'xh' => 'ஹோசா',
 				'xog' => 'சோகா',
 				'yao' => 'யாவ்',
 				'yap' => 'யாபேசி',
 				'yi' => 'இத்திஷ்',
 				'yo' => 'யோருபா',
 				'yue' => 'காண்டோனீஸ்',
 				'za' => 'ஜுவாங்',
 				'zap' => 'ஜாபோடெக்',
 				'zbl' => 'ப்லிஸ்ஸிம்பால்ஸ்',
 				'zen' => 'ஜெனகா',
 				'zgh' => 'ஸ்டாண்டர்ட் மொராக்கன் தமாசைட்',
 				'zh' => 'சீனம்',
 				'zh_Hans' => 'எளிதாக்கப்பட்ட சீனம்',
 				'zh_Hant' => 'பாரம்பரிய சீனம்',
 				'zu' => 'ஜுலு',
 				'zun' => 'ஜூனி',
 				'zxx' => 'மொழி உள்ளடக்கம் ஏதுமில்லை',
 				'zza' => 'ஜாஜா',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'அரபிக்',
 			'Arab@alt=variant' => 'பெர்சோ அரபிக்',
 			'Armi' => 'இம்பேரியல் அரமெய்க்',
 			'Armn' => 'அர்மேனியன்',
 			'Avst' => 'அவெஸ்தான்',
 			'Bali' => 'பாலினீஸ்',
 			'Batk' => 'பாடாக்',
 			'Beng' => 'வங்காளம்',
 			'Blis' => 'ப்லிஸ்ஸிமிபால்ஸ்',
 			'Bopo' => 'போபோமோஃபோ',
 			'Brah' => 'பிரம்மி',
 			'Brai' => 'பிரெயில்',
 			'Bugi' => 'புகினீஸ்',
 			'Buhd' => 'புகித்',
 			'Cakm' => 'சக்மா',
 			'Cans' => 'யுனிஃபைடு கனடியன் அபொரிஜினல் சிலபிக்ஸ்',
 			'Cari' => 'கரியன்',
 			'Cham' => 'சாம்',
 			'Cher' => 'செரோக்கி',
 			'Cirt' => 'கிர்த்',
 			'Copt' => 'காப்டிக்',
 			'Cprt' => 'சைப்ரியாட்',
 			'Cyrl' => 'சிரிலிக்',
 			'Cyrs' => 'பழைய சர்ச் ஸ்லவோனிக் சிரிலிக்',
 			'Deva' => 'தேவநாகரி',
 			'Dsrt' => 'டெசராட்',
 			'Egyd' => 'எகிப்தியன் டெமோட்டிக்',
 			'Egyh' => 'எகிப்தியன் ஹைரேட்டிக்',
 			'Egyp' => 'எகிப்தியன் ஹைரோகிளிப்ஸ்',
 			'Ethi' => 'எத்தியோபிக்',
 			'Geok' => 'ஜியார்ஜியன் குட்சுரி',
 			'Geor' => 'ஜார்ஜியன்',
 			'Glag' => 'க்லாகோலிடிக்',
 			'Goth' => 'கோதிக்',
 			'Grek' => 'கிரேக்கம்',
 			'Gujr' => 'குஜராத்தி',
 			'Guru' => 'குர்முகி',
 			'Hang' => 'ஹங்குல்',
 			'Hani' => 'ஹன்',
 			'Hano' => 'ஹனுனூ',
 			'Hans' => 'எளிதாக்கப்பட்டது',
 			'Hans@alt=stand-alone' => 'எளிதாக்கப்பட்ட ஹன்',
 			'Hant' => 'பாரம்பரியம்',
 			'Hant@alt=stand-alone' => 'பாரம்பரிய ஹன்',
 			'Hebr' => 'ஹீப்ரு',
 			'Hira' => 'ஹிராகானா',
 			'Hmng' => 'பஹாவ் மாங்க்',
 			'Hrkt' => 'கடாகானா அல்லது ஹிராகானா',
 			'Hung' => 'பழைய ஹங்கேரியன்',
 			'Inds' => 'சிந்து',
 			'Ital' => 'பழைய இத்தாலி',
 			'Java' => 'ஜாவனீஸ்',
 			'Jpan' => 'ஜப்பானியம்',
 			'Kali' => 'கயாஹ் லீ',
 			'Kana' => 'கதகானா',
 			'Khar' => 'கரோஷ்டி',
 			'Khmr' => 'கமெர்',
 			'Knda' => 'கன்னடம்',
 			'Kore' => 'கொரியன்',
 			'Kthi' => 'காய்தி',
 			'Lana' => 'லன்னா',
 			'Laoo' => 'லாவோ',
 			'Latf' => 'ஃப்ரக்டூர் லெத்தின்',
 			'Latg' => 'கேலிக் லெத்தின்',
 			'Latn' => 'லத்தின்',
 			'Lepc' => 'லெப்சா',
 			'Limb' => 'லிம்பு',
 			'Lina' => 'லினியர் ஏ',
 			'Linb' => 'லினியர் பி',
 			'Lyci' => 'லிசியன்',
 			'Lydi' => 'லிடியன்',
 			'Mand' => 'மேன்டியன்',
 			'Mani' => 'மனிசெய்ன்',
 			'Maya' => 'மயான் ஹைரோகிளிப்',
 			'Mero' => 'மெராய்டிக்',
 			'Mlym' => 'மலையாளம்',
 			'Mong' => 'மங்கோலியன்',
 			'Moon' => 'மூன்',
 			'Mtei' => 'மெய்தெய் மயக்',
 			'Mymr' => 'மியான்மர்',
 			'Nkoo' => 'என்‘கோ',
 			'Ogam' => 'ஒகாம்',
 			'Olck' => 'ஒல் சிக்கி',
 			'Orkh' => 'ஆர்கான்',
 			'Orya' => 'ஒரியா',
 			'Osma' => 'ஒஸ்மான்யா',
 			'Perm' => 'பழைய பெர்மிக்',
 			'Phag' => 'பக்ஸ்-பா',
 			'Phli' => 'இன்ஸ்கிரிப்ஷனல் பஹலவி',
 			'Phlp' => 'சால்டர் பஹலவி',
 			'Phlv' => 'புக் பஹலவி',
 			'Phnx' => 'ஃபோனேஷியன்',
 			'Plrd' => 'போலார்ட் ஃபொனெட்டிக்',
 			'Prti' => 'இன்ஸ்கிரிப்ஷனல் பார்த்தியன்',
 			'Rjng' => 'ரெஜெய்ன்',
 			'Roro' => 'ரொங்கோரொங்கோ',
 			'Runr' => 'ருனிக்',
 			'Samr' => 'சமாரிடன்',
 			'Sara' => 'சாராதி',
 			'Saur' => 'சௌராஷ்ட்ரா',
 			'Sgnw' => 'ஸைன்எழுத்து',
 			'Shaw' => 'ஷவியான்',
 			'Sinh' => 'சிங்களம்',
 			'Sund' => 'சுந்தானீஸ்',
 			'Sylo' => 'சிலோடி நக்ரி',
 			'Syrc' => 'சிரியாக்',
 			'Syre' => 'எஸ்ட்ரெங்கெலோ சிரியாக்',
 			'Syrj' => 'மேற்கு சிரியாக்',
 			'Syrn' => 'கிழக்கு சிரியாக்',
 			'Tagb' => 'தகோவானா',
 			'Tale' => 'தாய் லே',
 			'Talu' => 'புதிய தை லூ',
 			'Taml' => 'தமிழ்',
 			'Tavt' => 'தை வியத்',
 			'Telu' => 'தெலுங்கு',
 			'Teng' => 'தெங்வார்',
 			'Tfng' => 'டிஃபினாக்',
 			'Tglg' => 'தகலாக்',
 			'Thaa' => 'தானா',
 			'Thai' => 'தாய்',
 			'Tibt' => 'திபெத்தியன்',
 			'Ugar' => 'உகாரதிக்',
 			'Vaii' => 'வை',
 			'Visp' => 'விசிபிள் ஸ்பீச்',
 			'Xpeo' => 'பழைய பெர்ஷியன்',
 			'Xsux' => 'சுமெரோ-அக்கடியன் க்யூனிஃபார்ம்',
 			'Yiii' => 'யீ',
 			'Zinh' => 'பாரம்பரியமான',
 			'Zmth' => 'கணிதக்குறியீடு',
 			'Zsym' => 'சின்னங்கள்',
 			'Zxxx' => 'எழுதப்படாதது',
 			'Zyyy' => 'பொது',
 			'Zzzz' => 'அறியப்படாத எழுத்து',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'உலகம்',
 			'002' => 'ஆப்ரிக்கா',
 			'003' => 'வட அமெரிக்கா',
 			'005' => 'தென் அமெரிக்கா',
 			'009' => 'ஓஷியானியா',
 			'011' => 'மேற்கு ஆப்ரிக்கா',
 			'013' => 'மத்திய அமெரிக்கா',
 			'014' => 'கிழக்கு ஆப்ரிக்கா',
 			'015' => 'வடக்கு ஆப்ரிக்கா',
 			'017' => 'மத்திய ஆப்ரிக்கா',
 			'018' => 'தெற்கு ஆப்ரிக்கா',
 			'019' => 'அமெரிக்காஸ்',
 			'021' => 'வடக்கு அமெரிக்கா',
 			'029' => 'கரீபியன்',
 			'030' => 'கிழக்கு ஆசியா',
 			'034' => 'தெற்கு ஆசியா',
 			'035' => 'தென்கிழக்கு ஆசியா',
 			'039' => 'தெற்கு ஐரோப்பா',
 			'053' => 'ஆஸ்திரலேசியா',
 			'054' => 'மெலனேஷியா',
 			'057' => 'மைக்ரோ நேஷியா பிரதேசம்',
 			'061' => 'பாலினேஷியா',
 			'142' => 'ஆசியா',
 			'143' => 'மத்திய ஆசியா',
 			'145' => 'மேற்கு ஆசியா',
 			'150' => 'ஐரோப்பா',
 			'151' => 'கிழக்கு ஐரோப்பா',
 			'154' => 'வடக்கு ஐரோப்பா',
 			'155' => 'மேற்கு ஐரோப்பா',
 			'419' => 'லத்தீன் அமெரிக்கா',
 			'AC' => 'அஷன்ஷியன் தீவு',
 			'AD' => 'அன்டோரா',
 			'AE' => 'ஐக்கிய அரபு எமிரேட்ஸ்',
 			'AF' => 'ஆப்கானிஸ்தான்',
 			'AG' => 'ஆண்டிகுவா மற்றும் பார்புடா',
 			'AI' => 'அங்குய்லா',
 			'AL' => 'அல்பேனியா',
 			'AM' => 'அர்மேனியா',
 			'AN' => 'நெதர்லாந்து ஆண்டில்லெஸ்',
 			'AO' => 'அங்கோலா',
 			'AQ' => 'அண்டார்டிகா',
 			'AR' => 'அர்ஜென்டினா',
 			'AS' => 'அமெரிக்க சமோவா',
 			'AT' => 'ஆஸ்திரியா',
 			'AU' => 'ஆஸ்திரேலியா',
 			'AW' => 'அரூபா',
 			'AX' => 'ஆலந்து தீவுகள்',
 			'AZ' => 'அசர்பைஜான்',
 			'BA' => 'போஸ்னியா & ஹெர்ஸகோவினா',
 			'BB' => 'பார்படோஸ்',
 			'BD' => 'பங்களாதேஷ்',
 			'BE' => 'பெல்ஜியம்',
 			'BF' => 'புர்கினா ஃபாஸோ',
 			'BG' => 'பல்கேரியா',
 			'BH' => 'பஹ்ரைன்',
 			'BI' => 'புருண்டி',
 			'BJ' => 'பெனின்',
 			'BL' => 'செயின்ட் பார்தேலெமி',
 			'BM' => 'பெர்முடா',
 			'BN' => 'புரூனேய்',
 			'BO' => 'பொலிவியா',
 			'BQ' => 'கரீபியன் நெதர்லாந்து',
 			'BR' => 'பிரேசில்',
 			'BS' => 'பஹாமாஸ்',
 			'BT' => 'பூடான்',
 			'BV' => 'பொவேட் தீவுகள்',
 			'BW' => 'போட்ஸ்வானா',
 			'BY' => 'பெலாரூஸ்',
 			'BZ' => 'பெலிஸ்',
 			'CA' => 'கனடா',
 			'CC' => 'கோகோஸ் (கீலிங்) தீவுகள்',
 			'CD' => 'காங்கோ - கின்ஷாசா',
 			'CD@alt=variant' => 'காங்கோ (டிஆர்சி)',
 			'CF' => 'மத்திய ஆப்ரிக்கக் குடியரசு',
 			'CG' => 'காங்கோ - ப்ராஸாவில்லே',
 			'CG@alt=variant' => 'காங்கோ (குடியரசு)',
 			'CH' => 'ஸ்விட்சர்லாந்து',
 			'CI' => 'கோட் தி’வாயர்',
 			'CI@alt=variant' => 'ஐவரி கோஸ்ட்',
 			'CK' => 'குக் தீவுகள்',
 			'CL' => 'சிலி',
 			'CM' => 'கேமரூன்',
 			'CN' => 'சீனா',
 			'CO' => 'கொலம்பியா',
 			'CP' => 'கிலிப்பர்டன் தீவு',
 			'CR' => 'கோஸ்டாரிகா',
 			'CU' => 'கியூபா',
 			'CV' => 'கேப் வெர்டே',
 			'CW' => 'குராகவ்',
 			'CX' => 'கிறிஸ்துமஸ் தீவு',
 			'CY' => 'சைப்ரஸ்',
 			'CZ' => 'செக் குடியரசு',
 			'DE' => 'ஜெர்மனி',
 			'DG' => 'டியகோ கார்ஷியா',
 			'DJ' => 'ஜிபௌட்டி',
 			'DK' => 'டென்மார்க்',
 			'DM' => 'டொமினிகா',
 			'DO' => 'டொமினிகன் குடியரசு',
 			'DZ' => 'அல்ஜீரியா',
 			'EA' => 'சியூடா & மெலில்லா',
 			'EC' => 'ஈக்வடார்',
 			'EE' => 'எஸ்டோனியா',
 			'EG' => 'எகிப்து',
 			'EH' => 'மேற்கு சஹாரா',
 			'ER' => 'எரிட்ரியா',
 			'ES' => 'ஸ்பெயின்',
 			'ET' => 'எதியோப்பியா',
 			'EU' => 'ஐரோப்பிய யூனியன்',
 			'FI' => 'பின்லாந்து',
 			'FJ' => 'ஃபிஜி',
 			'FK' => 'ஃபாக்லாந்து தீவுகள்',
 			'FK@alt=variant' => 'ஃபாக்லாந்து தீவுகள் (இஸ்லாஸ் மால்வினஸ்)',
 			'FM' => 'மைக்ரோனேஷியா',
 			'FO' => 'ஃபாரோ தீவுகள்',
 			'FR' => 'பிரான்ஸ்',
 			'GA' => 'கேபான்',
 			'GB' => 'ஐக்கிய பேரரசு',
 			'GB@alt=short' => 'யூகே',
 			'GD' => 'கிரனெடா',
 			'GE' => 'ஜார்ஜியா',
 			'GF' => 'பிரெஞ்சு கயானா',
 			'GG' => 'கெர்ன்சி',
 			'GH' => 'கானா',
 			'GI' => 'ஜிப்ரால்டர்',
 			'GL' => 'கிரீன்லாந்து',
 			'GM' => 'காம்பியா',
 			'GN' => 'கினியா',
 			'GP' => 'க்வாதேலோப்',
 			'GQ' => 'ஈக்வடோரியல் கினியா',
 			'GR' => 'கிரீஸ்',
 			'GS' => 'தென் ஜியார்ஜியா மற்றும் தென் சான்ட்விச் தீவுகள்',
 			'GT' => 'கவுதமாலா',
 			'GU' => 'குவாம்',
 			'GW' => 'கினியா-பிஸ்ஸாவ்',
 			'GY' => 'கயானா',
 			'HK' => 'ஹாங்காங் எஸ்ஏஆர் சீனா',
 			'HK@alt=short' => 'ஹாங்காங்',
 			'HM' => 'ஹேர்ட் மற்றும் மெக்டொனால்டு தீவுகள்',
 			'HN' => 'ஹோண்டூராஸ்',
 			'HR' => 'குரேஷியா',
 			'HT' => 'ஹைட்டி',
 			'HU' => 'ஹங்கேரி',
 			'IC' => 'கேனரி தீவுகள்',
 			'ID' => 'இந்தோனேஷியா',
 			'IE' => 'அயர்லாந்து',
 			'IL' => 'இஸ்ரேல்',
 			'IM' => 'ஐல் ஆஃப் மேன்',
 			'IN' => 'இந்தியா',
 			'IO' => 'பிரிட்டிஷ் இந்தியப் பெருங்கடல் பிரதேசம்',
 			'IQ' => 'ஈராக்',
 			'IR' => 'ஈரான்',
 			'IS' => 'ஐஸ்லாந்து',
 			'IT' => 'இத்தாலி',
 			'JE' => 'ஜெர்சி',
 			'JM' => 'ஜமைகா',
 			'JO' => 'ஜோர்டான்',
 			'JP' => 'ஜப்பான்',
 			'KE' => 'கென்யா',
 			'KG' => 'கிர்கிஸ்தான்',
 			'KH' => 'கம்போடியா',
 			'KI' => 'கிரிபடி',
 			'KM' => 'கோமரோஸ்',
 			'KN' => 'செயின்ட் கிட்ஸ் & நெவிஸ்',
 			'KP' => 'வட கொரியா',
 			'KR' => 'தென் கொரியா',
 			'KW' => 'குவைத்',
 			'KY' => 'கெய்மென் தீவுகள்',
 			'KZ' => 'கஸகஸ்தான்',
 			'LA' => 'லாவோஸ்',
 			'LB' => 'லெபனான்',
 			'LC' => 'செயின்ட் லூசியா',
 			'LI' => 'லிச்செண்ஸ்டெய்ன்',
 			'LK' => 'இலங்கை',
 			'LR' => 'லைபீரியா',
 			'LS' => 'லெசோதோ',
 			'LT' => 'லிதுவேனியா',
 			'LU' => 'லக்ஸ்சம்பர்க்',
 			'LV' => 'லாட்வியா',
 			'LY' => 'லிபியா',
 			'MA' => 'மொராக்கோ',
 			'MC' => 'மொனாக்கோ',
 			'MD' => 'மால்டோவா',
 			'ME' => 'மான்டேனெக்ரோ',
 			'MF' => 'செயின்ட் மார்ட்டீன்',
 			'MG' => 'மடகாஸ்கர்',
 			'MH' => 'மார்ஷல் தீவுகள்',
 			'MK' => 'மாசிடோனியா',
 			'MK@alt=variant' => 'மாசிடோனியா (ஃபைரோம்)',
 			'ML' => 'மாலி',
 			'MM' => 'மியான்மார் (பர்மா)',
 			'MN' => 'மங்கோலியா',
 			'MO' => 'மகாவ் எஸ்ஏஆர் சீனா',
 			'MO@alt=short' => 'மகாவ்',
 			'MP' => 'வடக்கு மரியானா தீவுகள்',
 			'MQ' => 'மார்டினிக்',
 			'MR' => 'மௌரிடானியா',
 			'MS' => 'மாண்ட்செராட்',
 			'MT' => 'மால்டா',
 			'MU' => 'மொரிசியஸ்',
 			'MV' => 'மாலத்தீவு',
 			'MW' => 'மலாவி',
 			'MX' => 'மெக்சிகோ',
 			'MY' => 'மலேசியா',
 			'MZ' => 'மொசாம்பிக்',
 			'NA' => 'நமீபியா',
 			'NC' => 'நியூ கேலிடோனியா',
 			'NE' => 'நைஜர்',
 			'NF' => 'நார்ஃபோக் தீவுகள்',
 			'NG' => 'நைஜீரியா',
 			'NI' => 'நிகரகுவா',
 			'NL' => 'நெதர்லாந்து',
 			'NO' => 'நார்வே',
 			'NP' => 'நேபாளம்',
 			'NR' => 'நௌரு',
 			'NU' => 'நியூ',
 			'NZ' => 'நியூசிலாந்து',
 			'OM' => 'ஓமன்',
 			'PA' => 'பனாமா',
 			'PE' => 'பெரு',
 			'PF' => 'பிரெஞ்சு பாலினேஷியா',
 			'PG' => 'பப்புவா நியூ கினியா',
 			'PH' => 'பிலிப்பைன்ஸ்',
 			'PK' => 'பாகிஸ்தான்',
 			'PL' => 'போலந்து',
 			'PM' => 'செயின்ட் பியர் & மிக்வேலான்',
 			'PN' => 'பிட்கெய்ர்ன் தீவுகள்',
 			'PR' => 'பியூர்டோ ரிகோ',
 			'PS' => 'பாலஸ்தீனிய பிரதேசங்கள்',
 			'PS@alt=short' => 'பாலஸ்தீனம்',
 			'PT' => 'போர்ச்சுக்கல்',
 			'PW' => 'பாலோ',
 			'PY' => 'பராகுவே',
 			'QA' => 'கத்தார்',
 			'QO' => 'வெளிப்புற ஓஷியானியா',
 			'RE' => 'ரீயூனியன்',
 			'RO' => 'ருமேனியா',
 			'RS' => 'செர்பியா',
 			'RU' => 'ரஷ்யா',
 			'RW' => 'ருவான்டா',
 			'SA' => 'சவூதி அரேபியா',
 			'SB' => 'சாலமன் தீவுகள்',
 			'SC' => 'சீஷெல்ஸ்',
 			'SD' => 'சூடான்',
 			'SE' => 'ஸ்வீடன்',
 			'SG' => 'சிங்கப்பூர்',
 			'SH' => 'செயின்ட் ஹெலெனா',
 			'SI' => 'ஸ்லோவேனியா',
 			'SJ' => 'ஸ்வல்பார்டு & ஜான் மேயன்',
 			'SK' => 'ஸ்லோவாகியா',
 			'SL' => 'சியாரா லியோன்',
 			'SM' => 'சான் மரினோ',
 			'SN' => 'செனெகல்',
 			'SO' => 'சோமாலியா',
 			'SR' => 'சுரினாம்',
 			'SS' => 'தெற்கு சூடான்',
 			'ST' => 'சாவ் தோம் & ப்ரின்சிபி',
 			'SV' => 'எல் சால்வடார்',
 			'SX' => 'சின்ட் மார்டென்',
 			'SY' => 'சிரியா',
 			'SZ' => 'ஸ்வாஸிலாந்து',
 			'TA' => 'டிரிஸ்டன் டா குன்ஹா',
 			'TC' => 'டர்க்ஸ் & கைகோஸ் தீவுகள்',
 			'TD' => 'சாட்',
 			'TF' => 'பிரெஞ்சு தெற்கு பிரதேசங்கள்',
 			'TG' => 'டோகோ',
 			'TH' => 'தாய்லாந்து',
 			'TJ' => 'தாஜிகிஸ்தான்',
 			'TK' => 'டோகேலோ',
 			'TL' => 'தைமூர்-லெஸ்தே',
 			'TL@alt=variant' => 'கிழக்கு தைமூர்',
 			'TM' => 'துர்க்மெனிஸ்தான்',
 			'TN' => 'டுனிசியா',
 			'TO' => 'டோங்கா',
 			'TR' => 'துருக்கி',
 			'TT' => 'ட்ரினிடாட் & டொபாகோ',
 			'TV' => 'துவாலூ',
 			'TW' => 'தைவான்',
 			'TZ' => 'தான்சானியா',
 			'UA' => 'உக்ரைன்',
 			'UG' => 'உகாண்டா',
 			'UM' => 'யூ.எஸ். வெளிப்புற தீவுகள்',
 			'US' => 'அமெரிக்கா',
 			'US@alt=short' => 'யூஎஸ்',
 			'UY' => 'உருகுவே',
 			'UZ' => 'உஸ்பெகிஸ்தான்',
 			'VA' => 'வாடிகன் நகரம்',
 			'VC' => 'செயின்ட் வின்சென்ட் & கிரெனடைன்ஸ்',
 			'VE' => 'வெனிசுலா',
 			'VG' => 'பிரிட்டீஷ் கன்னித் தீவுகள்',
 			'VI' => 'யூ.எஸ். கன்னித் தீவுகள்',
 			'VN' => 'வியட்நாம்',
 			'VU' => 'வனுவாட்டு',
 			'WF' => 'வாலிஸ் மற்றும் ஃபுடுனா',
 			'WS' => 'சமோவா',
 			'XK' => 'கொசோவோ',
 			'YE' => 'ஏமன்',
 			'YT' => 'மயோட்',
 			'ZA' => 'தென் ஆப்பிரிக்கா',
 			'ZM' => 'ஜாம்பியா',
 			'ZW' => 'ஜிம்பாப்வே',
 			'ZZ' => 'அறியப்படாத பிரதேசம்',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'PINYIN' => 'பின்யின் ரோமானைசெஷன்',
 			'WADEGILE' => 'வேட்-கைல்ஸ் ரோமனைஷேசன்',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'நாள்காட்டி',
 			'colalternate' => 'சின்னங்கள் வரிசைப்படுத்தலைப் புறக்கணி',
 			'colbackwards' => 'நேர்மறையான உச்சரிப்பு வரிசைபடுத்துதல்',
 			'colcasefirst' => 'பெரெழுத்து/சிற்றெழுத்து வரிசைமுறை',
 			'colcaselevel' => 'எழுத்து உணர்ந்து வரிசைபடுத்துதல்',
 			'colhiraganaquaternary' => 'கானா வரிசைபடுத்துதல்',
 			'collation' => 'வரிசை முறை',
 			'colnormalization' => 'இயல்பாக்கப்பட்ட வரிசைபடுத்துதல்',
 			'colnumeric' => 'எண்முறை வரிசைபடுத்துதல்',
 			'colstrength' => 'வரிசைப்படுத்தல் வலிமை',
 			'currency' => 'நாணயம்',
 			'hc' => 'மணிநேர சுழற்சி (12, 24)',
 			'lb' => 'வரி முறிப்பு ஸ்டைல்',
 			'ms' => 'அளவிடும் முறை',
 			'numbers' => 'எண்கள்',
 			'timezone' => 'நேர மண்டலம்',
 			'va' => 'மொழி மாறிலி',
 			'variabletop' => 'சின்னங்களாக வரிசைப்படுத்து',
 			'x' => 'தனிப்பட்ட பயன்',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{புத்த நாள்காட்டி},
 				'chinese' => q{சீன நாள்காட்டி},
 				'coptic' => q{காப்டிக் நாள்காட்டி},
 				'dangi' => q{டேங்கி நாள்காட்டி},
 				'ethiopic' => q{எத்தியோப்பிக் நாள்காட்டி},
 				'ethiopic-amete-alem' => q{எத்தியோபிக் அமேதே ஆலெம் நாள்காட்டி},
 				'gregorian' => q{கிரிகோரியன் நாள்காட்டி},
 				'hebrew' => q{ஹீப்ரு நாள்காட்டி},
 				'indian' => q{இந்திய தேச நாள்காட்டி},
 				'islamic' => q{இஸ்லாமிய நாள்காட்டி},
 				'islamic-civil' => q{இஸ்லாமிய சிவில் நாள்காட்டி},
 				'iso8601' => q{ISO-8601 நாள்காட்டி},
 				'japanese' => q{ஜப்பானிய நாள்காட்டி},
 				'persian' => q{பெர்சியன் நாள்காட்டி},
 				'roc' => q{மின்கோ நாள்காட்டி},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{சின்னங்களை வரிசைப்படுத்து},
 				'shifted' => q{சின்னங்களைப் புறக்கணித்து வரிசைப்படுத்து},
 			},
 			'colbackwards' => {
 				'no' => q{உச்சரிப்புகளை இயல்பாக வரிசைபடுத்து},
 				'yes' => q{உச்சரிப்புகளை நேர்மறையாக வரிசைபடுத்து},
 			},
 			'colcasefirst' => {
 				'lower' => q{முதலில் சிற்றெழுத்துகளை வரிசைப்படுத்து},
 				'no' => q{இயல்பான எழுத்து வடிவில் வரிசைபடுத்து},
 				'upper' => q{முதலில் பேரெழுத்துகளை வரிசைப்படுத்து},
 			},
 			'colcaselevel' => {
 				'no' => q{எழுத்து உணர்வின்றி வரிசைபடுத்து},
 				'yes' => q{எழுத்து உணர்வில் வரிசைபடுத்து},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{கானாவை தனியாக வரிசைப்படுத்து},
 				'yes' => q{கானாவை வேறுபட்டதாக வரிசைப்படுத்து},
 			},
 			'collation' => {
 				'big5han' => q{பாரம்பரிய சீன வரிசை வடிவம் - Big5},
 				'dictionary' => q{அகராதி வரிசை முறை},
 				'ducet' => q{இயல்புநிலை யுனிகோட் வரிசை முறை},
 				'gb2312han' => q{எளிமையாக்கப்பட்ட சீன வரிசை வடிவம் - GB2312},
 				'phonebook' => q{தொலைபேசி புத்தக வரிசை முறை},
 				'phonetic' => q{ஒலியியல் வரிசைப்படுத்தல் முறை},
 				'pinyin' => q{பின்யின் வரிசை முறை},
 				'reformed' => q{சீர்திருத்தப்பட்ட வரிசை முறை},
 				'search' => q{பொதுப்படையான தேடல்},
 				'searchjl' => q{ஹங்குல் முதன்மை மெய்யெழுத்தின்படி தேடு},
 				'standard' => q{நிலையான வரிசை முறை},
 				'stroke' => q{ஸ்ட்ரோக் வரிசை முறை},
 				'traditional' => q{பாரம்பரிய வரிசை முறை},
 				'unihan' => q{ரேடியன் ஸ்ட்ரோக் வரிசை முறை},
 			},
 			'colnormalization' => {
 				'no' => q{இயல்பாக்கம் இல்லாமல் வரிசைபடுத்து},
 				'yes' => q{இயல்பாக்கப்பட்ட யூனிகோடை வரிசைப்படுத்து},
 			},
 			'colnumeric' => {
 				'no' => q{இலக்கங்களை, தனியாக வரிசைப்படுத்து},
 				'yes' => q{இலக்கங்களை எண்களாக வரிசைப்படுத்து},
 			},
 			'colstrength' => {
 				'identical' => q{அனைத்தையும் வரிசைப்படுத்து},
 				'primary' => q{அடிப்படை எழுத்துகளை மட்டும் வரிசைபடுத்து},
 				'quaternary' => q{உச்சரிப்புகள்/எழுத்து/அகலம்/கானாவை வரிசைப்படுத்து},
 				'secondary' => q{உச்சரிப்புகளை வரிசைபடுத்து},
 				'tertiary' => q{உச்சரிப்புகள்/எழுத்து/அகலத்தை வரிசைப்படுத்து},
 			},
 			'hc' => {
 				'h11' => q{12 மணிநேர முறைமை (0–11)},
 				'h12' => q{12 மணிநேர முறைமை (1–12)},
 				'h23' => q{24 மணிநேர முறைமை (0–23)},
 				'h24' => q{24 மணிநேர முறைமை (1–24)},
 			},
 			'lb' => {
 				'loose' => q{தளர்வான வரி முறிப்பு ஸ்டைல்},
 				'normal' => q{சாதாரண வரி முறிப்பு ஸ்டைல்},
 				'strict' => q{கண்டிப்பான வரி முறிப்பு ஸ்டைல்},
 			},
 			'ms' => {
 				'metric' => q{மெட்ரிக் முறை},
 				'uksystem' => q{இம்பீரியல் அளவிடும் முறை},
 				'ussystem' => q{அமெரிக்க அளவிடும் முறை},
 			},
 			'numbers' => {
 				'arab' => q{அரபிய-இந்திய இலக்கங்கள்},
 				'arabext' => q{நீட்டிக்கப்பட்ட அரபிய-இந்திய இலக்கங்கள்},
 				'armn' => q{ஆர்மேனியன் எண்கள்},
 				'armnlow' => q{ஆர்மேனியன் சிற்றெழுத்து எண்கள்},
 				'beng' => q{பெங்காலி இலக்கங்கள்},
 				'deva' => q{தேவநாகரி இலக்கங்கள்},
 				'ethi' => q{எத்தியோப்பிய எண்கள்},
 				'finance' => q{நிதி எண்கள்},
 				'fullwide' => q{முழு-அகல இலக்கங்கள்},
 				'geor' => q{ஜார்ஜியன் எண்கள்},
 				'grek' => q{கிரீக் எண்கள்},
 				'greklow' => q{கிரீக் சிற்றெழுத்து எண்கள்},
 				'gujr' => q{குஜராத்தி இலக்கங்கள்},
 				'guru' => q{குர்முகி இலக்கங்கள்},
 				'hanidec' => q{சீன பின்ன எண்கள்},
 				'hans' => q{எளிதாக்கப்பட்ட சீன எண்கள்},
 				'hansfin' => q{எளிதாக்கப்பட்ட சீன நிதி எண்கள்},
 				'hant' => q{பாரம்பரிய சீன எண்கள்},
 				'hantfin' => q{பாரம்பரிய சீன நிதி எண்கள்},
 				'hebr' => q{ஹீப்ரு எண்கள்},
 				'jpan' => q{ஜப்பானிய எண்கள்},
 				'jpanfin' => q{ஜப்பானிய நிதி எண்கள்},
 				'khmr' => q{கெமெர் இலக்கங்கள்},
 				'knda' => q{கன்னட இலக்கங்கள்},
 				'laoo' => q{லாவோ இலக்கங்கள்},
 				'latn' => q{மேற்கத்திய இலக்கங்கள்},
 				'mlym' => q{மலையாள இலக்கங்கள்},
 				'mong' => q{மங்கோலியன் இலக்கங்கள்},
 				'mymr' => q{மியான்மர் இலக்கங்கள்},
 				'native' => q{சொந்த இலக்கங்கள்},
 				'orya' => q{ஒரியா இலக்கங்கள்},
 				'roman' => q{ரோமன் எண்கள்},
 				'romanlow' => q{ரோமன் சிற்றெழுத்து எண்கள்},
 				'taml' => q{பாரம்பரிய தமிழ் எண்கள்},
 				'tamldec' => q{தமிழ் இலக்கங்கள்},
 				'telu' => q{தெலுங்கு இலக்கங்கள்},
 				'thai' => q{தாய் இலக்கங்கள்},
 				'tibt' => q{திபெத்தியன் இலக்கங்கள்},
 				'traditional' => q{பாரம்பரிய எண்கள்},
 				'vaii' => q{வை எண்கள்},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{மெட்ரிக்},
 			'UK' => q{யூகே},
 			'US' => q{யூஎஸ்},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'BGN',
 			'numeric' => 'எண்',
 			'tone' => 'டோன்',
 			'ungegn' => 'UNGEGN',
 			'x-accents' => 'ஒலிப்புகள்',
 			'x-fullwidth' => 'முழு அகலம்',
 			'x-halfwidth' => 'அரை அகலம்',
 			'x-jamo' => 'ஜமோ',
 			'x-pinyin' => 'பின்யின்',
 			'x-publishing' => 'வெளியிடுகிறது',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'மொழி: {0}',
 			'script' => 'எழுத்து: {0}',
 			'region' => 'பிரதேசம்: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍])},
			index => ['அ', 'ஆ', 'இ', 'ஈ', 'உ', 'ஊ', 'எ', 'ஏ', 'ஐ', 'ஒ', 'ஓ', 'ஔ', 'க', 'ங', 'ச', 'ஞ', 'ட', 'ண', 'த', 'ந', 'ப', 'ம', 'ய', 'ர', 'ல', 'வ', 'ழ', 'ள', 'ற', 'ன', 'ஜ', 'ஶ', 'ஷ', 'ஸ', 'ஹ', '{க\u0BCDஷ}'],
			main => qr{(?^u:[அ ஆ இ ஈ உ ஊ எ ஏ ஐ ஒ ஓ ஔ ஃ க ங ச ஞ ட ண த ந ப ம ய ர ல வ ழ ள ற ன ஜ ஷ ஸ ஹ ா ி ீ ு ூ ெ ே ை ொ ோ ௌ ்])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″])},
		};
	},
EOT
: sub {
		return { index => ['அ', 'ஆ', 'இ', 'ஈ', 'உ', 'ஊ', 'எ', 'ஏ', 'ஐ', 'ஒ', 'ஓ', 'ஔ', 'க', 'ங', 'ச', 'ஞ', 'ட', 'ண', 'த', 'ந', 'ப', 'ம', 'ய', 'ர', 'ல', 'வ', 'ழ', 'ள', 'ற', 'ன', 'ஜ', 'ஶ', 'ஷ', 'ஸ', 'ஹ', '{க\u0BCDஷ}'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'name' => q(ஏக்கர்),
						'one' => q({0} ஏக்கர்),
						'other' => q({0} ஏக்கர்),
					},
					'acre-foot' => {
						'name' => q(ஏக்கர் அடி),
						'one' => q({0} ஏக்கர் அடி),
						'other' => q({0} ஏக்கர் அடி),
					},
					'ampere' => {
						'name' => q(ஆம்பியர்கள்),
						'one' => q({0} ஆம்பியர்),
						'other' => q({0} ஆம்பியர்கள்),
					},
					'arc-minute' => {
						'name' => q(ஆர்க் நிமிடங்கள்),
						'one' => q({0} ஆர்க் நிமிடம்),
						'other' => q({0} ஆர்க் நிமிடங்கள்),
					},
					'arc-second' => {
						'name' => q(ஆர்க் விநாடிகள்),
						'one' => q({0} ஆர்க் விநாடி),
						'other' => q({0} ஆர்க் விநாடிகள்),
					},
					'astronomical-unit' => {
						'name' => q(வானியல் அலகுகள்),
						'one' => q({0} வானியல் அலகு),
						'other' => q({0} வானியல் அலகுகள்),
					},
					'bit' => {
						'name' => q(பிட்கள்),
						'one' => q({0} பிட்),
						'other' => q({0} பிட்கள்),
					},
					'byte' => {
						'name' => q(பைட்கள்),
						'one' => q({0} பைட்),
						'other' => q({0} பைட்கள்),
					},
					'calorie' => {
						'name' => q(கலோரிகள்),
						'one' => q({0} கலோரி),
						'other' => q({0} கலோரிகள்),
					},
					'carat' => {
						'name' => q(கேரட்கள்),
						'one' => q({0} கேரட்),
						'other' => q({0} கேரட்கள்),
					},
					'celsius' => {
						'name' => q(டிகிரி செல்சியஸ்),
						'one' => q({0} டிகிரி செல்சியஸ்),
						'other' => q({0}டிகிரி செல்சியஸ்),
					},
					'centiliter' => {
						'name' => q(சென்டிலிட்டர்கள்),
						'one' => q({0} சென்டிலிட்டர்),
						'other' => q({0} சென்டிலிட்டர்கள்),
					},
					'centimeter' => {
						'name' => q(சென்டிமீட்டர்கள்),
						'one' => q({0} சென்டிமீட்டர்),
						'other' => q({0} சென்டிமீட்டர்கள்),
						'per' => q({0}/செ.மீ.),
					},
					'century' => {
						'name' => q(நூற்றாண்டுகள்),
						'one' => q({0} நூற்றாண்டு),
						'other' => q({0} நூற்றாண்டுகள்),
					},
					'coordinate' => {
						'east' => q({0}கி),
						'north' => q({0}வ),
						'south' => q({0}தெ),
						'west' => q({0}மே),
					},
					'cubic-centimeter' => {
						'name' => q(கனசதுர சென்டிமீட்டர்கள்),
						'one' => q({0} கனசதுர சென்டிமீட்டர்),
						'other' => q({0} கனசதுர சென்டிமீட்டர்கள்),
						'per' => q({0}/கனசதுர சென்டிமீட்டர்),
					},
					'cubic-foot' => {
						'name' => q(கனசதுர அடி),
						'one' => q({0} கனசதுர அடி),
						'other' => q({0} கனசதுர அடி),
					},
					'cubic-inch' => {
						'name' => q(கனசதுர அங்குலங்கள்),
						'one' => q({0} கனசதுர அங்குலம்),
						'other' => q({0} கனசதுர அங்குலங்கள்),
					},
					'cubic-kilometer' => {
						'name' => q(கன கிலோமீட்டர்கள்),
						'one' => q({0} கன கிலோமீட்டர்),
						'other' => q({0} கன கிலோமீட்டர்),
					},
					'cubic-meter' => {
						'name' => q(கன மீட்டர்கள்),
						'one' => q({0} கன மீட்டர்),
						'other' => q({0} கன மீட்டர்கள்),
						'per' => q({0}/கன மீட்டர்),
					},
					'cubic-mile' => {
						'name' => q(கன மைல்கள்),
						'one' => q({0} கன மைல்),
						'other' => q({0} கன மைல்கள்),
					},
					'cubic-yard' => {
						'name' => q(கன யார்டுகள்),
						'one' => q({0} கன யார்டு),
						'other' => q({0} கன யார்டுகள்),
					},
					'cup' => {
						'name' => q(கோப்பைகள்),
						'one' => q({0} கோப்பை),
						'other' => q({0} கோப்பைகள்),
					},
					'cup-metric' => {
						'name' => q(மெட்ரிக் கோப்பைகள்),
						'one' => q({0} மெட்ரிக் கோப்பை),
						'other' => q({0} மெட்ரிக் கோப்பைகள்),
					},
					'day' => {
						'name' => q(நாட்கள்),
						'one' => q({0} நாள்),
						'other' => q({0} நாட்கள்),
						'per' => q({0}/நாள்),
					},
					'deciliter' => {
						'name' => q(டெசிலிட்டர்கள்),
						'one' => q({0} டெசிலிட்டர்),
						'other' => q({0} டெசிலிட்டர்கள்),
					},
					'decimeter' => {
						'name' => q(டெசிமீட்டர்கள்),
						'one' => q({0} டெசிமீட்டர்),
						'other' => q({0} டெசிமீட்டர்கள்),
					},
					'degree' => {
						'name' => q(டிகிரி),
						'one' => q({0} டிகிரி),
						'other' => q({0} டிகிரி),
					},
					'fahrenheit' => {
						'name' => q(டிகிரி ஃபாரன்ஹீட்),
						'one' => q({0} டிகிரி ஃபாரன்ஹீட்),
						'other' => q({0} டிகிரி ஃபாரன்ஹீட்),
					},
					'fluid-ounce' => {
						'name' => q(திரவ அவுன்ஸ்),
						'one' => q({0} திரவ அவுன்ஸ்),
						'other' => q({0} திரவ அவுன்ஸ்),
					},
					'foodcalorie' => {
						'name' => q(கலோரிகள்),
						'one' => q({0} கலோரி),
						'other' => q({0} கலோரிகள்),
					},
					'foot' => {
						'name' => q(அடி),
						'one' => q({0} அடி),
						'other' => q({0} அடி),
						'per' => q({0}/அடி),
					},
					'g-force' => {
						'name' => q(ஜி-ஃபோர்ஸ்),
						'one' => q({0} ஜி-ஃபோர்ஸ்),
						'other' => q({0} ஜி-ஃபோர்ஸ்),
					},
					'gallon' => {
						'name' => q(கேலன்கள்),
						'one' => q({0} கேலன்),
						'other' => q({0} கேலன்கள்),
						'per' => q({0}/கேலன்),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(கிகாபிட்கள்),
						'one' => q({0} கிகாபிட்),
						'other' => q({0} கிகாபிட்கள்),
					},
					'gigabyte' => {
						'name' => q(கிகாபைட்கள்),
						'one' => q({0} கிகாபைட்),
						'other' => q({0} கிகாபைட்கள்),
					},
					'gigahertz' => {
						'name' => q(கிகாஹெர்ட்ஸ்),
						'one' => q({0} கிகாஹெர்ட்ஸ்),
						'other' => q({0} கிகாஹெர்ட்ஸ்),
					},
					'gigawatt' => {
						'name' => q(கிகாவாட்ஸ்),
						'one' => q({0} கிகாவாட்),
						'other' => q({0} கிகாவாட்ஸ்),
					},
					'gram' => {
						'name' => q(கிராம்கள்),
						'one' => q({0} கிராம்),
						'other' => q({0} கிராம்கள்),
						'per' => q({0}/கிராம்),
					},
					'hectare' => {
						'name' => q(ஹெக்டேர்),
						'one' => q({0} ஹெக்டேர்),
						'other' => q({0} ஹெக்டேர்),
					},
					'hectoliter' => {
						'name' => q(ஹெக்டோலிட்டர்கள்),
						'one' => q({0} ஹெக்டாலிட்டர்),
						'other' => q({0} ஹெக்டோலிட்டர்கள்),
					},
					'hectopascal' => {
						'name' => q(ஹெக்டோபாஸ்கல்),
						'one' => q({0} ஹெக்டோபாஸ்கல்),
						'other' => q({0} ஹெக்டோபாஸ்கல்),
					},
					'hertz' => {
						'name' => q(ஹெர்ட்ஸ்),
						'one' => q({0} ஹெர்ட்ஸ்),
						'other' => q({0} ஹெர்ட்ஸ்),
					},
					'horsepower' => {
						'name' => q(குதிரைத்திறன்),
						'one' => q({0} குதிரைத்திறன்),
						'other' => q({0} குதிரைத்திறன்),
					},
					'hour' => {
						'name' => q(மணிநேரங்கள்),
						'one' => q({0} மணிநேரம்),
						'other' => q({0} மணிநேரங்கள்),
						'per' => q({0}/மணிநேரம்),
					},
					'inch' => {
						'name' => q(அங்குலங்கள்),
						'one' => q({0} அங்குலம்),
						'other' => q({0} அங்குலங்கள்),
						'per' => q({0}/அங்குலம்),
					},
					'inch-hg' => {
						'name' => q(பாதரச அங்குலங்கள்),
						'one' => q({0} பாதரச அங்குலம்),
						'other' => q({0} பாதரச அங்குலங்கள்),
					},
					'joule' => {
						'name' => q(ஜூல்கள்),
						'one' => q({0} ஜூல்),
						'other' => q({0} ஜூல்கள்),
					},
					'karat' => {
						'name' => q(காரட்கள்),
						'one' => q({0} காரட்),
						'other' => q({0} காரட்கள்),
					},
					'kelvin' => {
						'name' => q(கெல்வின்),
						'one' => q({0} கெல்வின்),
						'other' => q({0} கெல்வின்),
					},
					'kilobit' => {
						'name' => q(கிலோ பிட்கள்),
						'one' => q({0} கிலோ பிட்),
						'other' => q({0} கிலோ பிட்கள்),
					},
					'kilobyte' => {
						'name' => q(கிலோ பைட்கள்),
						'one' => q({0} கிலோ பைட்),
						'other' => q({0} கிலோ பைட்கள்),
					},
					'kilocalorie' => {
						'name' => q(கிலோகலோரிகள்),
						'one' => q({0} கிலோகலோரி),
						'other' => q({0} கிலோகலோரிகள்),
					},
					'kilogram' => {
						'name' => q(கிலோகிராம்கள்),
						'one' => q({0} கிலோகிராம்),
						'other' => q({0} கிலோகிராம்கள்),
						'per' => q({0}/கிலோகிராம்),
					},
					'kilohertz' => {
						'name' => q(கிலோஹெர்ட்ஸ்),
						'one' => q({0} கிலோஹெர்ட்ஸ்),
						'other' => q({0} கிலோஹெர்ட்ஸ்),
					},
					'kilojoule' => {
						'name' => q(கிலோஜூல்கள்),
						'one' => q({0} கிலோஜூல்),
						'other' => q({0} கிலோஜூல்கள்),
					},
					'kilometer' => {
						'name' => q(கிலோமீட்டர்கள்),
						'one' => q({0} கிலோமீட்டர்),
						'other' => q({0} கிலோமீட்டர்கள்),
						'per' => q({0}/கிலோமீட்டர்),
					},
					'kilometer-per-hour' => {
						'name' => q(கிலோமீட்டர்கள்/மணிநேரம்),
						'one' => q({0} கிலோமீட்டர்/மணிநேரம்),
						'other' => q({0} கிலோமீட்டர்கள்/மணிநேரம்),
					},
					'kilowatt' => {
						'name' => q(கிலோவாட்கள்),
						'one' => q({0} கிலோவாட்),
						'other' => q({0} கிலோவாட்கள்),
					},
					'kilowatt-hour' => {
						'name' => q(கிலோவாட் மணிநேரம்),
						'one' => q({0} கிலோவாட் மணிநேரம்),
						'other' => q({0} கிலோவாட் மணிநேரம்),
					},
					'knot' => {
						'name' => q(நாட்),
						'one' => q({0} நாட்),
						'other' => q({0} நாட்),
					},
					'light-year' => {
						'name' => q(ஒளி ஆண்டுகள்),
						'one' => q({0} ஒளி ஆண்டு),
						'other' => q({0} ஒளி ஆண்டுகள்),
					},
					'liter' => {
						'name' => q(லிட்டர்கள்),
						'one' => q({0} லிட்டர்),
						'other' => q({0} லிட்டர்கள்),
						'per' => q({0}/லிட்டர்),
					},
					'liter-per-100kilometers' => {
						'name' => q(லிட்டர்/100கி.மீ),
						'one' => q({0} லிட்டர்/100கி.மீ),
						'other' => q({0} லிட்டர்/100கி.மீ),
					},
					'liter-per-kilometer' => {
						'name' => q(லிட்டர்கள்/கிலோமீட்டர்),
						'one' => q({0} லிட்டர்/கிலோமீட்டர்),
						'other' => q({0} லிட்டர்கள்/கிலோமீட்டர்),
					},
					'lux' => {
						'name' => q(லக்ஸ்),
						'one' => q({0} லக்ஸ்),
						'other' => q({0} லக்ஸ்),
					},
					'megabit' => {
						'name' => q(மெகா பிட்கள்),
						'one' => q({0} மெகா பிட்),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(மெகாபைட்கள்),
						'one' => q({0} மெகாபைட்),
						'other' => q({0} மெகாபைட்கள்),
					},
					'megahertz' => {
						'name' => q(மெகாஹெர்ட்ஸ்),
						'one' => q({0} மெகாஹெர்ட்ஸ்),
						'other' => q({0} மெகாஹெர்ட்ஸ்),
					},
					'megaliter' => {
						'name' => q(மெகாலிட்டர்கள்),
						'one' => q({0} மெகாலிட்டர்),
						'other' => q({0} மெகாலிட்டர்கள்),
					},
					'megawatt' => {
						'name' => q(மெகாவாட்ஸ்),
						'one' => q({0} மெகாவாட்),
						'other' => q({0} மெகாவாட்ஸ்),
					},
					'meter' => {
						'name' => q(மீட்டர்கள்),
						'one' => q({0} மீட்டர்),
						'other' => q({0} மீட்டர்கள்),
						'per' => q({0}/மீ.),
					},
					'meter-per-second' => {
						'name' => q(மீட்டர்கள்/விநாடி),
						'one' => q({0} மீட்டர்/விநாடி),
						'other' => q({0} மீட்டர்கள்/விநாடி),
					},
					'meter-per-second-squared' => {
						'name' => q(சதுர வினாடிக்கு மீட்டர்),
						'one' => q(சதுர வினாடிக்கு {0} மீட்டர்),
						'other' => q(சதுர வினாடிக்கு {0} மீட்டர்கள்),
					},
					'metric-ton' => {
						'name' => q(மெட்ரிக் டன்கள்),
						'one' => q({0} மெட்ரிக் டன்),
						'other' => q({0} மெட்ரிக் டன்கள்),
					},
					'microgram' => {
						'name' => q(மைக்ரோ கிராம்கள்),
						'one' => q({0} மைக்ரோ கிராம்),
						'other' => q({0} மைக்ரோ கிராம்கள்),
					},
					'micrometer' => {
						'name' => q(மைக்ரோமீட்டர்கள்),
						'one' => q({0} மைக்ரோமீட்டர்),
						'other' => q({0} மைக்ரோமீட்டர்கள்),
					},
					'microsecond' => {
						'name' => q(மைக்ரோவிநாடிகள்),
						'one' => q({0} மைக்ரோவிநாடி),
						'other' => q({0} மைக்ரோவிநாடிகள்),
					},
					'mile' => {
						'name' => q(மைல்கள்),
						'one' => q({0} மைல்),
						'other' => q({0} மைல்கள்),
					},
					'mile-per-gallon' => {
						'name' => q(மைல்கள்/கேலன்),
						'one' => q({0} மைல்/காலன்),
						'other' => q({0} மைல்கள்/காலன்),
					},
					'mile-per-hour' => {
						'name' => q(மைல்கள்/மணிநேரம்),
						'one' => q({0} மைல்/மணிநேரம்),
						'other' => q({0} மைல்கள்/மணிநேரம்),
					},
					'mile-scandinavian' => {
						'name' => q(ஸ்கேண்டிநேவியன் மைல்),
						'one' => q({0} ஸ்கேண்டிநேவியன் மைல்),
						'other' => q({0} ஸ்கேண்டிநேவியன் மைல்கள்),
					},
					'milliampere' => {
						'name' => q(மில்லி ஆம்பியர்கள்),
						'one' => q({0} மில்லி ஆம்பியர்),
						'other' => q({0} மில்லி ஆம்பியர்கள்),
					},
					'millibar' => {
						'name' => q(மில்லிபார்கள்),
						'one' => q({0} மில்லிபார்),
						'other' => q({0} மில்லிபார்கள்),
					},
					'milligram' => {
						'name' => q(மில்லி கிராம்கள்),
						'one' => q({0} மில்லி கிராம்),
						'other' => q({0} மில்லி கிராம்கள்),
					},
					'milliliter' => {
						'name' => q(மில்லிலிட்டர்கள்),
						'one' => q({0} மில்லிலிட்டர்),
						'other' => q({0} மில்லிலிட்டர்கள்),
					},
					'millimeter' => {
						'name' => q(மில்லிமீட்டர்கள்),
						'one' => q({0} மில்லிமீட்டர்),
						'other' => q({0} மில்லிமீட்டர்கள்),
					},
					'millimeter-of-mercury' => {
						'name' => q(பாதரச மில்லிமீட்டர்கள்),
						'one' => q({0} பாதரச மில்லிமீட்டர்),
						'other' => q({0} பாதரச மில்லிமீட்டர்கள்),
					},
					'millisecond' => {
						'name' => q(மில்லிவிநாடிகள்),
						'one' => q({0} மில்லிவிநாடி),
						'other' => q({0} மில்லிவிநாடிகள்),
					},
					'milliwatt' => {
						'name' => q(மில்லிவாட்ஸ்),
						'one' => q({0} மில்லிவாட்),
						'other' => q({0} மில்லிவாட்ஸ்),
					},
					'minute' => {
						'name' => q(நிமிடங்கள்),
						'one' => q({0} நிமிடம்),
						'other' => q({0} நிமிடங்கள்),
						'per' => q({0}/நிமிடம்),
					},
					'month' => {
						'name' => q(மாதங்கள்),
						'one' => q({0} மாதம்),
						'other' => q({0} மாதங்கள்),
						'per' => q({0}/மா),
					},
					'nanometer' => {
						'name' => q(நானோமீட்டர்கள்),
						'one' => q({0} நானோமீட்டர்),
						'other' => q({0} நானோமீட்டர்கள்),
					},
					'nanosecond' => {
						'name' => q(நானோசெகண்டுகள்),
						'one' => q({0} நானோசெகண்டு),
						'other' => q({0} நானோசெகண்டுகள்),
					},
					'nautical-mile' => {
						'name' => q(கடல் மைல்கள்),
						'one' => q({0} கடல் மைல்),
						'other' => q({0} கடல் மைல்கள்),
					},
					'ohm' => {
						'name' => q(ஓம்ஸ்),
						'one' => q({0} ஓம்),
						'other' => q({0} ஓம்ஸ்),
					},
					'ounce' => {
						'name' => q(அவுன்ஸ்கள்),
						'one' => q({0} அவுன்ஸ்),
						'other' => q({0} அவுன்ஸ்கள்),
						'per' => q({0}/அவுன்ஸ்),
					},
					'ounce-troy' => {
						'name' => q(ட்ராய் அவுன்ஸ்கள்),
						'one' => q({0} ட்ராய் அவுன்ஸ்),
						'other' => q({0} ட்ராய் அவுன்ஸ்கள்),
					},
					'parsec' => {
						'name' => q(புடைநொடிகள்),
						'one' => q({0} புடைநொடி),
						'other' => q({0} புடைநொடிகள்),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(பைக்கோமீட்டர்கள்),
						'one' => q({0} பைக்கோமீட்டர்),
						'other' => q({0} பைக்கோமீட்டர்கள்),
					},
					'pint' => {
						'name' => q(பின்ட்கள்),
						'one' => q({0} பின்ட்),
						'other' => q({0} பின்ட்கள்),
					},
					'pint-metric' => {
						'name' => q(மெட்ரிக் பின்ட்கள்),
						'one' => q({0} மெட்ரிக் பின்ட்),
						'other' => q({0} மெட்ரிக் பின்ட்கள்),
					},
					'pound' => {
						'name' => q(பவுண்டுகள்),
						'one' => q({0} பவுண்டு),
						'other' => q({0} பவுண்டுகள்),
						'per' => q({0}/பவுண்டு),
					},
					'pound-per-square-inch' => {
						'name' => q(பவுண்டுகள்/சதுர அங்குலம்),
						'one' => q({0} பவுண்டு/சதுர அங்குலம்),
						'other' => q({0} பவுண்டுகள்/சதுர அங்குலம்),
					},
					'quart' => {
						'name' => q(குவார்ட்ஸ்),
						'one' => q({0} குவார்ட்),
						'other' => q({0} குவார்ட்ஸ்),
					},
					'radian' => {
						'name' => q(ரேடியன்),
						'one' => q({0} ரேடியன்),
						'other' => q({0} ரேடியன்),
					},
					'revolution' => {
						'name' => q(சுழற்சி),
						'one' => q({0} சுழற்சி),
						'other' => q({0} சுழற்சிகள்),
					},
					'second' => {
						'name' => q(விநாடிகள்),
						'one' => q({0} விநாடி),
						'other' => q({0} விநாடிகள்),
						'per' => q({0}/விநாடி),
					},
					'square-centimeter' => {
						'name' => q(சதுர சென்டி மீட்டர்கள்),
						'one' => q({0} சதுர சென்டிமீட்டர்),
						'other' => q({0} சதுர சென்டிமீட்டர்கள்),
						'per' => q({0}/சதுர சென்டிமீட்டர்),
					},
					'square-foot' => {
						'name' => q(சதுர அடி),
						'one' => q({0} சதுர அடி),
						'other' => q({0} சதுர அடி),
					},
					'square-inch' => {
						'name' => q(சதுர அங்குலங்கள்),
						'one' => q({0} சதுர அங்குலம்),
						'other' => q({0} சதுர அங்குலங்கள்),
						'per' => q({0}/சதுர அங்குலம்),
					},
					'square-kilometer' => {
						'name' => q(சதுர கிலோமீட்டர்கள்),
						'one' => q({0} சதுர கிலோமீட்டர்),
						'other' => q({0} சதுர கிலோமீட்டர்கள்),
					},
					'square-meter' => {
						'name' => q(சதுர மீட்டர்கள்),
						'one' => q({0} சதுர மீட்டர்),
						'other' => q({0} சதுர மீட்டர்),
						'per' => q({0}/சதுர மீட்டர்),
					},
					'square-mile' => {
						'name' => q(சதுர மைல்கள்),
						'one' => q({0} சதுர மைல்),
						'other' => q({0} சதுர மைல்),
					},
					'square-yard' => {
						'name' => q(சதுர யார்டுகள்),
						'one' => q({0} சதுர யார்டு),
						'other' => q({0} சதுர யார்டுகள்),
					},
					'tablespoon' => {
						'name' => q(மேஜைக்கரண்டி),
						'one' => q({0} மேஜைக்கரண்டி),
						'other' => q({0} மேஜைக்கரண்டி),
					},
					'teaspoon' => {
						'name' => q(தேக்கரண்டி),
						'one' => q({0} தேக்கரண்டி),
						'other' => q({0} தேக்கரண்டி),
					},
					'terabit' => {
						'name' => q(டெரா பிட்கள்),
						'one' => q({0} டெரா பிட்),
						'other' => q({0} டெரா பிட்கள்),
					},
					'terabyte' => {
						'name' => q(டெராபைட்கள்),
						'one' => q({0} டெராபைட்),
						'other' => q({0} டெராபைட்கள்),
					},
					'ton' => {
						'name' => q(டன்கள்),
						'one' => q({0} டன்),
						'other' => q({0} டன்கள்),
					},
					'volt' => {
						'name' => q(வோல்ட்கள்),
						'one' => q({0} வோல்ட்),
						'other' => q({0} வோல்ட்கள்),
					},
					'watt' => {
						'name' => q(வாட்ஸ்),
						'one' => q({0} வாட்),
						'other' => q({0} வாட்ஸ்),
					},
					'week' => {
						'name' => q(வாரங்கள்),
						'one' => q({0} வாரம்),
						'other' => q({0} வாரங்கள்),
						'per' => q({0}/வா),
					},
					'yard' => {
						'name' => q(கெஜம்),
						'one' => q({0} கெஜம்),
						'other' => q({0} கெஜம்),
					},
					'year' => {
						'name' => q(ஆண்டுகள்),
						'one' => q({0} ஆண்டு),
						'other' => q({0} ஆண்டுகள்),
						'per' => q(ஒரு வருடத்தில் {0}),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} ஏக்.),
						'other' => q({0} ஏக்.),
					},
					'arc-minute' => {
						'one' => q({0}நிமி.),
						'other' => q({0}நிமி.),
					},
					'arc-second' => {
						'one' => q({0}வி.),
						'other' => q({0}வி.),
					},
					'celsius' => {
						'name' => q(°செ),
						'one' => q({0}°செ.),
						'other' => q({0}°செ.),
					},
					'centimeter' => {
						'name' => q(செ.மீ.),
						'one' => q({0}செ.மீ.),
						'other' => q({0}செ.மீ.),
					},
					'coordinate' => {
						'east' => q({0}கி),
						'north' => q({0}வ),
						'south' => q({0}தெ),
						'west' => q({0}மே),
					},
					'cubic-kilometer' => {
						'one' => q({0} க.கி.மீ.),
						'other' => q({0} க.கி.மீ.),
					},
					'cubic-mile' => {
						'one' => q({0} க.மை.),
						'other' => q({0} க.மை.),
					},
					'day' => {
						'name' => q(நா),
						'one' => q({0} நா),
						'other' => q({0} நா),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°ஃபா.),
						'other' => q({0}°ஃபா.),
					},
					'foot' => {
						'one' => q({0} அடி),
						'other' => q({0} அடி),
					},
					'g-force' => {
						'one' => q({0} ஜி.ஃபோ.),
						'other' => q({0} ஜி.ஃபோ.),
					},
					'gram' => {
						'name' => q(கிராம்),
						'one' => q({0} கி.),
						'other' => q({0} கி.),
					},
					'hectare' => {
						'one' => q({0} ஹெக்.),
						'other' => q({0} ஹெக்.),
					},
					'hectopascal' => {
						'one' => q({0} ஹெ.பா.),
						'other' => q({0} ஹெ.பா.),
					},
					'horsepower' => {
						'one' => q({0} கு.வே.),
						'other' => q({0} கு.வே.),
					},
					'hour' => {
						'name' => q(மணி),
						'one' => q({0} ம.நே.),
						'other' => q({0} ம.நே.),
					},
					'inch' => {
						'one' => q({0} அங்.),
						'other' => q({0} அங்.),
					},
					'inch-hg' => {
						'one' => q({0} பா.அங்.),
						'other' => q({0} பா.அங்.),
					},
					'kilogram' => {
						'name' => q(கி.கி.),
						'one' => q({0}கி.கி.),
						'other' => q({0}கி.கி.),
					},
					'kilometer' => {
						'name' => q(கி.மீ.),
						'one' => q({0}கி.மீ.),
						'other' => q({0}கி.மீ.),
					},
					'kilometer-per-hour' => {
						'name' => q(கி.மீ./ம.),
						'one' => q({0}கி.மீ./ம.),
						'other' => q({0}கி.மீ./ம.),
					},
					'kilowatt' => {
						'one' => q({0} கி.வா.),
						'other' => q({0} கி.வா.),
					},
					'light-year' => {
						'one' => q({0} ஒ.ஆ.),
						'other' => q({0} ஒ.ஆ.),
					},
					'liter' => {
						'name' => q(லிட்டர்),
						'one' => q({0}லி.),
						'other' => q({0}லி.),
					},
					'liter-per-100kilometers' => {
						'name' => q(லி./100கி.மீ),
						'one' => q({0}லி./100கி.மீ),
						'other' => q({0}லி./100கி.மீ),
					},
					'meter' => {
						'name' => q(மீ.),
						'one' => q({0}மீ.),
						'other' => q({0}மீ.),
					},
					'meter-per-second' => {
						'one' => q({0} மீ/வி),
						'other' => q({0} மீ/வி),
					},
					'mile' => {
						'one' => q({0} மை.),
						'other' => q({0} மை.),
					},
					'mile-per-hour' => {
						'one' => q({0} மை/ம.நே.),
						'other' => q({0} மை/ம.நே.),
					},
					'millibar' => {
						'one' => q({0} மி.பா.),
						'other' => q({0} மி.பா.),
					},
					'millimeter' => {
						'name' => q(மி.மீ.),
						'one' => q({0}மி.மீ.),
						'other' => q({0}மி.மீ.),
					},
					'millisecond' => {
						'name' => q(மி.வி.),
						'one' => q({0} மி.வி.),
						'other' => q({0} மி.வி.),
					},
					'minute' => {
						'name' => q(நிமி.),
						'one' => q({0} நிமி.),
						'other' => q({0} நிமி.),
					},
					'month' => {
						'name' => q(மா),
						'one' => q({0} மா),
						'other' => q({0} மா),
					},
					'ounce' => {
						'one' => q({0} அவு.),
						'other' => q({0} அவு.),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} பை.மீ.),
						'other' => q({0} பை.மீ.),
					},
					'pound' => {
						'one' => q({0} பவு.),
						'other' => q({0} பவு.),
					},
					'second' => {
						'name' => q(வி.),
						'one' => q({0} வி.),
						'other' => q({0} வி.),
					},
					'square-foot' => {
						'one' => q({0} ச.அ.),
						'other' => q({0} ச.அ.),
					},
					'square-kilometer' => {
						'one' => q({0} ச.கிமீ.),
						'other' => q({0} ச.கிமீ.),
					},
					'square-meter' => {
						'one' => q({0} ச.மீ.),
						'other' => q({0} ச.மீ.),
					},
					'square-mile' => {
						'one' => q({0} ச. மை.),
						'other' => q({0} ச. மை.),
					},
					'watt' => {
						'one' => q({0} வா.),
						'other' => q({0} வா.),
					},
					'week' => {
						'name' => q(வா),
						'one' => q({0} வா),
						'other' => q({0} வா),
					},
					'yard' => {
						'one' => q({0} நீட்.),
						'other' => q({0} நீட்.),
					},
					'year' => {
						'name' => q(ஆண்டு),
						'one' => q({0} ஆ),
						'other' => q({0} ஆ),
					},
				},
				'short' => {
					'acre' => {
						'name' => q(ஏக்கர்),
						'one' => q({0} ஏக்.),
						'other' => q({0} ஏக்.),
					},
					'acre-foot' => {
						'name' => q(ஏக். அடி),
						'one' => q({0} ஏக். அடி),
						'other' => q({0} ஏக். அடி),
					},
					'ampere' => {
						'name' => q(ஆம்ப்.),
						'one' => q({0} ஆம்.),
						'other' => q({0} ஆம்.),
					},
					'arc-minute' => {
						'name' => q(ஆர்க்நிமி.),
						'one' => q({0} ஆர்க்நிமி.),
						'other' => q({0} ஆர்க்நிமி.),
					},
					'arc-second' => {
						'name' => q(ஆர்க்விநா.),
						'one' => q({0} ஆர்க்விநா.),
						'other' => q({0} ஆர்க்விநா.),
					},
					'astronomical-unit' => {
						'name' => q(வா.அ.),
						'one' => q({0} வா.அ.),
						'other' => q({0} வா.அ.),
					},
					'bit' => {
						'name' => q(பிட்),
						'one' => q({0} பிட்),
						'other' => q({0} பிட்),
					},
					'byte' => {
						'name' => q(பைட்),
						'one' => q({0} பை.),
						'other' => q({0} பை.),
					},
					'calorie' => {
						'name' => q(கலோ.),
						'one' => q({0} கலோ.),
						'other' => q({0} கலோ.),
					},
					'carat' => {
						'name' => q(கேரட்கள்),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					'celsius' => {
						'name' => q(டிகிரி செ.),
						'one' => q({0}°செ.),
						'other' => q({0}°செ.),
					},
					'centiliter' => {
						'name' => q(செ.லி.),
						'one' => q({0} செ.லி.),
						'other' => q({0} செ.லி.),
					},
					'centimeter' => {
						'name' => q(செ.மீ.),
						'one' => q({0} செ.மீ.),
						'other' => q({0} செ.மீ.),
						'per' => q({0}/செ.மீ.),
					},
					'century' => {
						'name' => q(நூ.),
						'one' => q({0} நூ.),
						'other' => q({0} நூ.),
					},
					'coordinate' => {
						'east' => q({0}கி),
						'north' => q({0}வ),
						'south' => q({0}தெ),
						'west' => q({0}மே),
					},
					'cubic-centimeter' => {
						'name' => q(செ.மீ.³),
						'one' => q({0} செ.மீ.³),
						'other' => q({0} செ.மீ.³),
						'per' => q({0}/cm³),
					},
					'cubic-foot' => {
						'name' => q(அடி³),
						'one' => q({0} அடி³),
						'other' => q({0} அடி³),
					},
					'cubic-inch' => {
						'name' => q(அங்.³),
						'one' => q({0} அங்.³),
						'other' => q({0} அங்.³),
					},
					'cubic-kilometer' => {
						'name' => q(கிமீ³),
						'one' => q({0} கிமீ³),
						'other' => q({0} கிமீ³),
					},
					'cubic-meter' => {
						'name' => q(மீ³),
						'one' => q({0} மீ³),
						'other' => q({0} மீ³),
						'per' => q({0}/மீ³),
					},
					'cubic-mile' => {
						'name' => q(மை³),
						'one' => q({0} மை³),
						'other' => q({0} மை³),
					},
					'cubic-yard' => {
						'name' => q(யா.³),
						'one' => q({0} யா.³),
						'other' => q({0} யா.³),
					},
					'cup' => {
						'name' => q(கோப்பைகள்),
						'one' => q({0} கோ.),
						'other' => q({0} கோ.),
					},
					'cup-metric' => {
						'name' => q(மெ.கோப்பை),
						'one' => q({0} மெ.கோ.),
						'other' => q({0} மெ.கோ.),
					},
					'day' => {
						'name' => q(நாட்கள்),
						'one' => q({0} நாள்),
						'other' => q({0} நாட்கள்),
						'per' => q({0}/நா),
					},
					'deciliter' => {
						'name' => q(டெ.லி.),
						'one' => q({0} டெ.லி.),
						'other' => q({0} டெ.லி.),
					},
					'decimeter' => {
						'name' => q(டெ.மீ),
						'one' => q({0} டெ.மீ),
						'other' => q({0} டெ.மீ),
					},
					'degree' => {
						'name' => q(டிகிரி),
						'one' => q({0} டிகி.),
						'other' => q({0} டிகி.),
					},
					'fahrenheit' => {
						'name' => q(டிகி. ஃபா.),
						'one' => q({0}°ஃபா.),
						'other' => q({0}°ஃபா.),
					},
					'fluid-ounce' => {
						'name' => q(தி. அவு.),
						'one' => q({0} தி. அவு.),
						'other' => q({0} தி. அவு.),
					},
					'foodcalorie' => {
						'name' => q(கலோ.),
						'one' => q({0} கலோ.),
						'other' => q({0} கலோ.),
					},
					'foot' => {
						'name' => q(அடி),
						'one' => q({0} அடி),
						'other' => q({0} அடி),
						'per' => q({0}/அடி),
					},
					'g-force' => {
						'name' => q(ஜி-ஃபோர்ஸ்),
						'one' => q({0} ஜி.ஃபோ.),
						'other' => q({0} ஜி.ஃபோ.),
					},
					'gallon' => {
						'name' => q(கேல.),
						'one' => q({0} கேல.),
						'other' => q({0} கேல.),
						'per' => q({0}/கேல.),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(கி.பிட்),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'name' => q(கி.பைட்),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'name' => q(ஜி.ஹெஸ்.),
						'one' => q({0} ஜி.ஹெஸ்.),
						'other' => q({0} ஜி.ஹெஸ்.),
					},
					'gigawatt' => {
						'name' => q(கி.வாட்.),
						'one' => q({0} கி.வாட்.),
						'other' => q({0} கி.வாட்.),
					},
					'gram' => {
						'name' => q(கிராம்கள்),
						'one' => q({0} கி.),
						'other' => q({0} கி.),
						'per' => q({0}/கி.),
					},
					'hectare' => {
						'name' => q(ஹெக்டேர்),
						'one' => q({0} ஹெக்.),
						'other' => q({0} ஹெக்.),
					},
					'hectoliter' => {
						'name' => q(ஹெ.லி.),
						'one' => q({0} ஹெ.லி.),
						'other' => q({0} ஹெ.லி.),
					},
					'hectopascal' => {
						'name' => q(ஹெ.பாஸ்.),
						'one' => q({0} ஹெ.பாஸ்.),
						'other' => q({0} ஹெ.பாஸ்.),
					},
					'hertz' => {
						'name' => q(ஹெஸ்.),
						'one' => q({0} ஹெஸ்.),
						'other' => q({0} ஹெஸ்.),
					},
					'horsepower' => {
						'name' => q(கு.தி.),
						'one' => q({0} கு.தி.),
						'other' => q({0} கு.தி.),
					},
					'hour' => {
						'name' => q(மணிநேர),
						'one' => q({0} மணிநேரம்),
						'other' => q({0} மணிநேரம்),
						'per' => q({0} /ம.நே),
					},
					'inch' => {
						'name' => q(அங்குலங்கள்),
						'one' => q({0} அங்.),
						'other' => q({0} அங்.),
						'per' => q({0}/அங்.),
					},
					'inch-hg' => {
						'name' => q(Hg அங்.),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'name' => q(ஜூல்),
						'one' => q({0} ஜூ.),
						'other' => q({0} ஜூ.),
					},
					'karat' => {
						'name' => q(காரட்கள்),
						'one' => q({0} கார.),
						'other' => q({0} கார.),
					},
					'kelvin' => {
						'name' => q(கெல்),
						'one' => q({0} கெல்),
						'other' => q({0} கெல்),
					},
					'kilobit' => {
						'name' => q(kb),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'name' => q(kB),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'name' => q(கி.கலோ.),
						'one' => q({0} கி.கலோ.),
						'other' => q({0} கி.கலோ.),
					},
					'kilogram' => {
						'name' => q(கி.கி.),
						'one' => q({0} கி.கி.),
						'other' => q({0} கி.கி.),
						'per' => q({0}/கி.கி.),
					},
					'kilohertz' => {
						'name' => q(கி.ஹெஸ்.),
						'one' => q({0} கி.ஹெஸ்.),
						'other' => q({0} கி.ஹெஸ்.),
					},
					'kilojoule' => {
						'name' => q(கி.ஜூ.),
						'one' => q({0} கி.ஜூ.),
						'other' => q({0} கி.ஜூ.),
					},
					'kilometer' => {
						'name' => q(கி.மீ.),
						'one' => q({0} கி.மீ.),
						'other' => q({0} கி.மீ.),
						'per' => q({0}/கி.மீ.),
					},
					'kilometer-per-hour' => {
						'name' => q(கி.மீ./மணிநேரம்),
						'one' => q({0} கி.மீ./ம.நே.),
						'other' => q({0} கி.மீ./ம.நே.),
					},
					'kilowatt' => {
						'name' => q(கி.வா.),
						'one' => q({0} கி.வா.),
						'other' => q({0} கி.வா.),
					},
					'kilowatt-hour' => {
						'name' => q(கி.வா-ம.நே.),
						'one' => q({0} கி.வா.ம.நே.),
						'other' => q({0} கி.வா.ம.நே.),
					},
					'knot' => {
						'name' => q(நா.),
						'one' => q({0} நா.),
						'other' => q({0} நா.),
					},
					'light-year' => {
						'name' => q(ஒளி ஆண்டுகள்),
						'one' => q({0} ஒ.ஆ.),
						'other' => q({0} ஒ.ஆ.),
					},
					'liter' => {
						'name' => q(லிட்டர்கள்),
						'one' => q({0} லி.),
						'other' => q({0} லி.),
						'per' => q({0}/லி.),
					},
					'liter-per-100kilometers' => {
						'name' => q(லி./100கி.மீ),
						'one' => q({0} லி./100கி.மீ),
						'other' => q({0} லி./100கி.மீ),
					},
					'liter-per-kilometer' => {
						'name' => q(லி./கி.மீ.),
						'one' => q({0} லி./கி.மீ.),
						'other' => q({0} லி./கி.மீ.),
					},
					'lux' => {
						'name' => q(லக்ஸ்),
						'one' => q({0} லக்.),
						'other' => q({0} லக்.),
					},
					'megabit' => {
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(MB),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'name' => q(மெ.ஹெஸ்.),
						'one' => q({0} மெ.ஹெஸ்.),
						'other' => q({0} மெ.ஹெஸ்.),
					},
					'megaliter' => {
						'name' => q(மெ.லி.),
						'one' => q({0} மெ.லி.),
						'other' => q({0} மெ.லி.),
					},
					'megawatt' => {
						'name' => q(மெ.வா.),
						'one' => q({0} மெ.வா.),
						'other' => q({0} மெ.வா.),
					},
					'meter' => {
						'name' => q(மீட்டர்கள்),
						'one' => q({0} மீ.),
						'other' => q({0} மீ.),
						'per' => q({0}/மீ.),
					},
					'meter-per-second' => {
						'name' => q(மீட்டர்கள்/விநாடி),
						'one' => q({0} மீ/வி),
						'other' => q({0} மீ/வி),
					},
					'meter-per-second-squared' => {
						'name' => q(மீ/வி²),
						'one' => q({0} மீ/வி²),
						'other' => q({0} மீ/வி²),
					},
					'metric-ton' => {
						'name' => q(ட.),
						'one' => q({0} ட.),
						'other' => q({0} ட.),
					},
					'microgram' => {
						'name' => q(µகி),
						'one' => q({0} µகி),
						'other' => q({0} µகி),
					},
					'micrometer' => {
						'name' => q(µமீ.),
						'one' => q({0} µமீ.),
						'other' => q({0} µமீ.),
					},
					'microsecond' => {
						'name' => q(μsecs),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(மைல்கள்),
						'one' => q({0} மை.),
						'other' => q({0} மை.),
					},
					'mile-per-gallon' => {
						'name' => q(மைல்கள்/கா.),
						'one' => q({0} மை./கா.),
						'other' => q({0} மை./கா.),
					},
					'mile-per-hour' => {
						'name' => q(மை/ம.நே.),
						'one' => q({0} மை/ம.நே.),
						'other' => q({0} மை/ம.நே.),
					},
					'mile-scandinavian' => {
						'name' => q(ஸ்.மை.),
						'one' => q({0} ஸ்.மை.),
						'other' => q({0} ஸ்.மை.),
					},
					'milliampere' => {
						'name' => q(மில்லி ஆம்ப்ஸ்),
						'one' => q({0} மி.ஆ.),
						'other' => q({0} மி.ஆ.),
					},
					'millibar' => {
						'name' => q(மில்லிபார்),
						'one' => q({0} மி.பா.),
						'other' => q({0} மி.பா.),
					},
					'milligram' => {
						'name' => q(மி.கி.),
						'one' => q({0} மி.கி.),
						'other' => q({0} மி.கி.),
					},
					'milliliter' => {
						'name' => q(மிலி),
						'one' => q({0} மிலி),
						'other' => q({0} மிலி),
					},
					'millimeter' => {
						'name' => q(மி.மீ.),
						'one' => q({0} மி.மீ.),
						'other' => q({0} மி.மீ.),
					},
					'millimeter-of-mercury' => {
						'name' => q(mm Hg),
						'one' => q({0} Hg மி.மீ.),
						'other' => q({0} Hg மி.மீ.),
					},
					'millisecond' => {
						'name' => q(மில்லிவிநாடி),
						'one' => q({0} மி.வி.),
						'other' => q({0} மி.வி.),
					},
					'milliwatt' => {
						'name' => q(மி.வா.),
						'one' => q({0} மி.வா.),
						'other' => q({0} மி.வா.),
					},
					'minute' => {
						'name' => q(நிமிட),
						'one' => q({0} நிமிடம்),
						'other' => q({0} நிமிட),
						'per' => q({0}/நிமிட),
					},
					'month' => {
						'name' => q(மாத),
						'one' => q({0} மாதம்),
						'other' => q({0} மாத),
						'per' => q({0}/மா),
					},
					'nanometer' => {
						'name' => q(நா.மீ.),
						'one' => q({0} நா.மீ.),
						'other' => q({0} நா.மீ.),
					},
					'nanosecond' => {
						'name' => q(நானோசெகண்டுகள்),
						'one' => q({0} நா.செ.),
						'other' => q({0} நா.செ.),
					},
					'nautical-mile' => {
						'name' => q(க.மை.),
						'one' => q({0} க.மை.),
						'other' => q({0} க.மை.),
					},
					'ohm' => {
						'name' => q(ஓம்ஸ்),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(அவு.),
						'one' => q({0} அவு.),
						'other' => q({0} அவு.),
						'per' => q({0}/அவு.),
					},
					'ounce-troy' => {
						'name' => q(அவு. டி.),
						'one' => q({0} அவு. டி.),
						'other' => q({0} அவு. டி.),
					},
					'parsec' => {
						'name' => q(பு.நொ.),
						'one' => q({0} பு.நொ.),
						'other' => q({0} பு.நொ.),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(பை.மீ),
						'one' => q({0} பை.மீ.),
						'other' => q({0} பை.மீ.),
					},
					'pint' => {
						'name' => q(பின்ட்கள்),
						'one' => q({0} பின்.),
						'other' => q({0} பின்.),
					},
					'pint-metric' => {
						'name' => q(மெ.பி.),
						'one' => q({0} மெ.பி.),
						'other' => q({0} மெ.பி.),
					},
					'pound' => {
						'name' => q(பவுண்டுகள்),
						'one' => q({0} பவு.),
						'other' => q({0} பவு.),
						'per' => q({0}/பவு.),
					},
					'pound-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'quart' => {
						'name' => q(குவாட்.),
						'one' => q({0} குவாட்.),
						'other' => q({0} குவாட்.),
					},
					'radian' => {
						'name' => q(ரேடி.),
						'one' => q({0} ரேடி.),
						'other' => q({0} ரேடி.),
					},
					'revolution' => {
						'name' => q(சுழற்.),
						'one' => q({0} சுழற்.),
						'other' => q({0} சுழற்.),
					},
					'second' => {
						'name' => q(விநாடிகள்),
						'one' => q({0} விநாடி),
						'other' => q({0} விநாடிகள்),
						'per' => q({0}/வி),
					},
					'square-centimeter' => {
						'name' => q(செ.மீ.²),
						'one' => q({0} செ.மீ.²),
						'other' => q({0} செ.மீ.²),
						'per' => q({0}/செ.மீ.²),
					},
					'square-foot' => {
						'name' => q(சதுர அடி),
						'one' => q({0} ச.அ.),
						'other' => q({0} ச.அ.),
					},
					'square-inch' => {
						'name' => q(அங்குலங்கள்²),
						'one' => q({0} அங்.²),
						'other' => q({0} அங்.²),
						'per' => q({0}/அங்.²),
					},
					'square-kilometer' => {
						'name' => q(கி.மீ.²),
						'one' => q({0} கி.மீ.²),
						'other' => q({0} கி.மீ.²),
					},
					'square-meter' => {
						'name' => q(மீட்டர்கள்²),
						'one' => q({0} மீ²),
						'other' => q({0} மீ²),
						'per' => q({0}/மீ²),
					},
					'square-mile' => {
						'name' => q(சதுர மைல்கள்),
						'one' => q({0} ச. மை.),
						'other' => q({0} ச. மை.),
					},
					'square-yard' => {
						'name' => q(யார்டுகள்²),
						'one' => q({0} யா²),
						'other' => q({0} யா.²),
					},
					'tablespoon' => {
						'name' => q(மே.க.),
						'one' => q({0} மே.க.),
						'other' => q({0} மே.க.),
					},
					'teaspoon' => {
						'name' => q(தே.க.),
						'one' => q({0} தே.க.),
						'other' => q({0} தே.க.),
					},
					'terabit' => {
						'name' => q(Tb),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(TB),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(டன்கள்),
						'one' => q({0} டன்),
						'other' => q({0} டன்),
					},
					'volt' => {
						'name' => q(வோல்ட்கள்),
						'one' => q({0} வோ.),
						'other' => q({0} வோ.),
					},
					'watt' => {
						'name' => q(வாட்ஸ்),
						'one' => q({0} வா.),
						'other' => q({0} வா.),
					},
					'week' => {
						'name' => q(வார),
						'one' => q({0} வாரம்),
						'other' => q({0} வார),
						'per' => q({0}/வார),
					},
					'yard' => {
						'name' => q(கெஜ.),
						'one' => q({0} கெஜ.),
						'other' => q({0} கெஜ.),
					},
					'year' => {
						'name' => q(ஆண்டுகள்),
						'one' => q({0} ஆண்டு),
						'other' => q({0} ஆண்டு.),
						'per' => q({0}/ஆ.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ஆம்|ஆ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:இல்லை|இ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'tamldec',
);

has traditional_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'taml',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> 'Int',
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0ஆ',
					'other' => '0ஆ',
				},
				'10000' => {
					'one' => '00ஆ',
					'other' => '00ஆ',
				},
				'100000' => {
					'one' => '000ஆ',
					'other' => '000ஆ',
				},
				'1000000' => {
					'one' => '0மி',
					'other' => '0மி',
				},
				'10000000' => {
					'one' => '00மி',
					'other' => '00மி',
				},
				'100000000' => {
					'one' => '000மி',
					'other' => '000மி',
				},
				'1000000000' => {
					'one' => '0பி',
					'other' => '0பி',
				},
				'10000000000' => {
					'one' => '00பி',
					'other' => '00பி',
				},
				'100000000000' => {
					'one' => '000பி',
					'other' => '000பி',
				},
				'1000000000000' => {
					'one' => '0டி',
					'other' => '0டி',
				},
				'10000000000000' => {
					'one' => '00டி',
					'other' => '00டி',
				},
				'100000000000000' => {
					'one' => '000டி',
					'other' => '000டி',
				},
				'standard' => {
					'' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ஆயிரம்',
					'other' => '0 ஆயிரம்',
				},
				'10000' => {
					'one' => '00 ஆயிரம்',
					'other' => '00 ஆயிரம்',
				},
				'100000' => {
					'one' => '000 ஆயிரம்',
					'other' => '000 ஆயிரம்',
				},
				'1000000' => {
					'one' => '0 மில்லியன்',
					'other' => '0 மில்லியன்',
				},
				'10000000' => {
					'one' => '00 மில்லியன்',
					'other' => '00 மில்லியன்',
				},
				'100000000' => {
					'one' => '000 மில்லியன்',
					'other' => '000 மில்லியன்',
				},
				'1000000000' => {
					'one' => '0 பில்லியன்',
					'other' => '0 பில்லியன்',
				},
				'10000000000' => {
					'one' => '00 பில்லியன்',
					'other' => '00 பில்லியன்',
				},
				'100000000000' => {
					'one' => '000 பில்லியன்',
					'other' => '000 பில்லியன்',
				},
				'1000000000000' => {
					'one' => '0 டிரில்லியன்',
					'other' => '0 டிரில்லியன்',
				},
				'10000000000000' => {
					'one' => '00 டிரில்லியன்',
					'other' => '00 டிரில்லியன்',
				},
				'100000000000000' => {
					'one' => '000 டிரில்லியன்',
					'other' => '000 டிரில்லியன்',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0ஆ',
					'other' => '0ஆ',
				},
				'10000' => {
					'one' => '00ஆ',
					'other' => '00ஆ',
				},
				'100000' => {
					'one' => '000ஆ',
					'other' => '000ஆ',
				},
				'1000000' => {
					'one' => '0மி',
					'other' => '0மி',
				},
				'10000000' => {
					'one' => '00மி',
					'other' => '00மி',
				},
				'100000000' => {
					'one' => '000மி',
					'other' => '000மி',
				},
				'1000000000' => {
					'one' => '0பி',
					'other' => '0பி',
				},
				'10000000000' => {
					'one' => '00பி',
					'other' => '00பி',
				},
				'100000000000' => {
					'one' => '000பி',
					'other' => '000பி',
				},
				'1000000000000' => {
					'one' => '0டி',
					'other' => '0டி',
				},
				'10000000000000' => {
					'one' => '00டி',
					'other' => '00டி',
				},
				'100000000000000' => {
					'one' => '000டி',
					'other' => '000டி',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(ஐக்கிய அரபு எமிரேட்ஸ் திர்ஹம்),
				'one' => q(ஐக்கிய அரபு எமிரேட்ஸ் திர்ஹம்),
				'other' => q(ஐக்கிய அரபு எமிரேட்ஸ் திர்ஹம்கள்),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(ஆஃப்கான் ஆஃப்கானி),
				'one' => q(ஆஃப்கான் ஆஃப்கானி),
				'other' => q(ஆஃப்கான் ஆஃப்கானிகள்),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(அல்பேனியன் லெக்),
				'one' => q(அல்பேனியன் லெக்),
				'other' => q(அல்பேனியன் லெகே),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(ஆர்மேனியன் ட்ராம்),
				'one' => q(ஆர்மேனியன் ட்ராம்),
				'other' => q(ஆர்மேனியன் ட்ராம்கள்),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(நெதர்லேண்ட்ஸ் அன்டிலியன் கில்டர்),
				'one' => q(நெதர்லேண்ட்ஸ் அன்டிலியன் கில்டர்),
				'other' => q(நெதர்லேண்ட்ஸ் அன்டிலியன் கில்டர்கள்),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(அங்கோலன் க்வான்ஸா),
				'one' => q(அங்கோலன் க்வான்ஸா),
				'other' => q(அங்கோலன் க்வான்ஸாக்கள்),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(அர்ஜென்டினா பேசோ),
				'one' => q(அர்ஜென்டினா பேசோ),
				'other' => q(அர்ஜென்டினா பேசோக்கள்),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ஆஸ்திரேலிய டாலர்),
				'one' => q(ஆஸ்திரேலிய டாலர்),
				'other' => q(ஆஸ்திரேலிய டாலர்கள்),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(அருபன் ஃப்ளோரின்),
				'one' => q(அருபன் ஃப்ளோரின்),
				'other' => q(அருபன் ஃப்ளோரின்),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(அசர்பைஜானி மனத்),
				'one' => q(அஜர்பைசானி மனத்),
				'other' => q(அசர்பைஜானி மனத்கள்),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(போஸ்னியா-ஹெர்ஸேகோவினா கன்வெர்டிபில் மார்க்),
				'one' => q(போஸ்னியா-ஹெர்ஸேகோவினா கன்வெர்டிபில் மார்க்),
				'other' => q(போஸ்னியா-ஹெர்ஸேகோவினா கன்வெர்டிபில் மார்க்குகள்),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(பார்பேடியன் டாலர்),
				'one' => q(பார்பேடியன் டாலர்),
				'other' => q(பார்பேடியன் டாலர்கள்),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(பங்களாதேஷி டாகா),
				'one' => q(பங்களாதேஷி டாகா),
				'other' => q(பங்களாதேஷி டாகாக்கள்),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(பல்கேரியன் லேவ்),
				'one' => q(பல்கேரியன் லேவ்),
				'other' => q(பல்கேரியன் லேவா),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(பஹ்ரைனி தினார்),
				'one' => q(பஹ்ரைனி தினார்),
				'other' => q(பஹ்ரைனி தினார்கள்),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(புருண்டியன் ஃப்ராங்க்),
				'one' => q(புருண்டியன் ஃப்ராங்க்),
				'other' => q(புருண்டியன் ஃப்ராங்க்குகள்),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(பெர்முடன் டாலர்),
				'one' => q(பெர்முடன் டாலர்),
				'other' => q(பெர்முடன் டாலர்கள்),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(புரூனே டாலர்),
				'one' => q(புரூனே டாலர்),
				'other' => q(புரூனே டாலர்கள்),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(பொலிவியன் பொலிவியானோ),
				'one' => q(பொலிவியன் பொலிவியானோ),
				'other' => q(பொலிவியன் பொலிவியானோக்கள்),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(பிரேசிலியன் ரியால்),
				'one' => q(பிரேசிலியன் ரியால்),
				'other' => q(பிரேசிலியன் ரியால்கள்),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(பஹாமியன் டாலர்),
				'one' => q(பஹாமியன் டாலர்),
				'other' => q(பஹாமியன் டாலர்கள்),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(பூட்டானீஸ் குல்ட்ரம்),
				'one' => q(பூட்டானீஸ் குல்ட்ரம்),
				'other' => q(பூட்டானீஸ் குல்ட்ரம்கள்),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(போட்ஸ்வானா புலா),
				'one' => q(போட்ஸ்வானா புலா),
				'other' => q(போட்ஸ்வானா புலாக்கள்),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(பெலருசியன் ரூபில்),
				'one' => q(பெலருசியன் ரூபில்),
				'other' => q(பெலருசியன் ரூபில்கள்),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(பெலீஸ் டாலர்),
				'one' => q(பெலீஸ் டாலர்),
				'other' => q(பெலீஸ் டாலர்கள்),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(கனடியன் டாலர்),
				'one' => q(கனடியன் டாலர்),
				'other' => q(கனடியன் டாலர்கள்),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(காங்கோலீஸ் ஃப்ராங்க்),
				'one' => q(காங்கோலீஸ் ஃப்ராங்க்),
				'other' => q(காங்கோலீஸ் ஃப்ராங்க்குகள்),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(சுவிஸ் ஃப்ராங்க்),
				'one' => q(சுவிஸ் ஃப்ராங்க்),
				'other' => q(சுவிஸ் ஃப்ராங்குகள்),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(சிலியன் பெசோ),
				'one' => q(சிலியன் பெசோ),
				'other' => q(சிலியன் பெசோக்கள்),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(சீன யுவான்),
				'one' => q(சீன யுவான்),
				'other' => q(சீன யுவான்),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(கொலம்பியன் பெசோ),
				'one' => q(கொலம்பியன் பெசோ),
				'other' => q(கொலம்பியன் பெசோக்கள்),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(கோஸ்டா ரிகன் கொலோன்),
				'one' => q(கோஸ்டா ரிகன் கொலோன்),
				'other' => q(கோஸ்டா ரிகன் கொலோன்கள்),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(கியூபன் கன்வெர்டிபில் பேசோ),
				'one' => q(கியூபன் கன்வெர்டிபில் பேசோ),
				'other' => q(கியூபன் கன்வெர்டிபில் பேசோக்கள்),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(கியூபன் பெசோ),
				'one' => q(கியூபன் பெசோ),
				'other' => q(கியூபன் பேசோக்கள்),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(கேப் வெர்டியன் எஸ்குடோ),
				'one' => q(கேப் வெர்டியன் எஸ்குடோ),
				'other' => q(கேப் வெர்டியன் எஸ்குடோக்கள்),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(செக் குடியரசு கொருனா),
				'one' => q(செக் குடியரசு கொருனா),
				'other' => q(செக்குடியரசு கொருனாக்கள்),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(ஜிபவ்டியென் ஃப்ராங்க்),
				'one' => q(ஜிபவ்டியென் ஃப்ராங்க்),
				'other' => q(ஜிபவ்டியென் ஃப்ராங்க்குகள்),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(டானிஷ் க்ரோன்),
				'one' => q(டானிஷ் க்ரோன்),
				'other' => q(டானிஷ் க்ரோன்),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(டொமினிக்கன் பேசோ),
				'one' => q(டொமினிக்கன் பேசோ),
				'other' => q(டொமினிக்கன் பேசோக்கள்),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(அல்ஜீரியன் தினார்),
				'one' => q(அல்ஜீரியன் தினார்),
				'other' => q(அல்ஜீரியன் தினார்கள்),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(எகிப்திய பவுண்டு),
				'one' => q(எகிப்திய பவுண்டு),
				'other' => q(எகிப்திய பவுண்டுகள்),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(இரிடிரியன் நக்ஃபா),
				'one' => q(இரிடிரியன் நக்ஃபா),
				'other' => q(இரிடிரியன் நக்ஃபாக்கள்),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(எத்தியோப்பியன் பிர்),
				'one' => q(எத்தியோப்பியன் பிர்),
				'other' => q(எத்தியோப்பியன் பிர்கள்),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(யூரோ),
				'one' => q(யூரோ),
				'other' => q(யூரோக்கள்),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ஃபிஜியன் டாலர்),
				'one' => q(ஃபிஜியன் டாலர்),
				'other' => q(ஃபிஜியன் டாலர்கள்),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ஃபாக்லாந்து தீவுகள் பவுண்டு),
				'one' => q(ஃபாக்லாந்து தீவுகள் பவுண்டு),
				'other' => q(ஃபாக்லாந்து தீவுகள் பவுண்டுகள்),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(பிரிட்டிஷ் பவுண்ட் ஸ்டெர்லிங்),
				'one' => q(பிரிட்டிஷ் பவுண்ட் ஸ்டெர்லிங்),
				'other' => q(பிரிட்டிஷ் பவுண்ட் ஸ்டெர்லிங்),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(ஜியார்ஜியன் லாரி),
				'one' => q(ஜியார்ஜியன் லாரி),
				'other' => q(ஜியார்ஜியன் லாரிகள்),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(கானயன் சேடி),
				'one' => q(கானயன் சேடி),
				'other' => q(கானயன் சேடிகள்),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(கிப்ரால்டர் பவுண்ட்),
				'one' => q(கிப்ரால்டர் பவுண்ட்),
				'other' => q(கிப்ரால்டர் பவுண்டுகள்),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(கேம்பியன் தலாசி),
				'one' => q(கேம்பியன் தலாசி),
				'other' => q(கேம்பியன் தலாசிகள்),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(கினியன் ஃப்ராங்க்),
				'one' => q(கினியன் ஃப்ராங்க்),
				'other' => q(கினியன் ஃப்ராங்குகள்),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(குவாடெமெலன் குயூட்ஸல்),
				'one' => q(குவாடெமெலன் குயூட்ஸல்),
				'other' => q(குவாடெமெலன் குயூட்ஸல்கள்),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(கயானீஸ் டாலர்),
				'one' => q(கயானீஸ் டாலர்),
				'other' => q(கயானீஸ் டாலர்கள்),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ஹாங்காங் டாலர்),
				'one' => q(ஹாங்காங் டாலர்),
				'other' => q(ஹாங்காங் டாலர்கள்),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(ஹோன்டூரன் லெம்பீரா),
				'one' => q(ஹோன்டூரன் லெம்பீரா),
				'other' => q(ஹோன்டூரன் லெம்பீராக்கள்),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(குரோஷியன் குனா),
				'one' => q(குரோஷியன் குனா),
				'other' => q(குரோஷியன் குனாக்கள்),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(ஹைட்டியன் கோர்டே),
				'one' => q(ஹைட்டியன் கோர்டே),
				'other' => q(ஹைட்டியன் கோர்டேக்கள்),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(ஹங்கேரியன் ஃபோரின்ட்),
				'one' => q(ஹங்கேரியன் ஃபோரின்ட்),
				'other' => q(ஹங்கேரியன் ஃபோரின்ட்கள்),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(இந்தோனேஷியன் ருபியா),
				'one' => q(இந்தோனேஷியன் ருபியா),
				'other' => q(இந்தோனேஷியன் ருபியாக்கள்),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(இஸ்ரேலி நியூ ஷிகேல்),
				'one' => q(இஸ்ரேலி நியூ ஷிகேல்),
				'other' => q(இஸ்ரேலி நியூ ஷிகேல்கள்),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(இந்திய ரூபாய்),
				'one' => q(இந்திய ரூபாய்),
				'other' => q(இந்திய ரூபாய்கள்),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ஈராக்கி தினார்),
				'one' => q(ஈராக்கி தினார்),
				'other' => q(ஈராக்கி தினார்கள்),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ஈரானியன் ரியால்),
				'one' => q(ஈரானியன் ரியால்),
				'other' => q(ஈரானியன் ரியால்கள்),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(ஐஸ்லாண்டிக் க்ரோனா),
				'one' => q(ஐஸ்லாண்டிக் க்ரோனா),
				'other' => q(ஐஸ்லாண்டிக் க்ரோனர்),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ஜமைக்கான் டாலர்),
				'one' => q(ஜமைக்கான் டாலர்),
				'other' => q(ஜமைக்கான் டாலர்கள்),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(ஜோர்டானிய தினார்),
				'one' => q(ஜோர்டானிய தினார்),
				'other' => q(ஜோர்டானிய தினார்கள்),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(ஜப்பானிய யென்),
				'one' => q(ஜப்பானிய யென்),
				'other' => q(ஜப்பானிய யென்),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(கென்யன் ஷில்லிங்),
				'one' => q(கென்யன் ஷில்லிங்),
				'other' => q(கென்யன் ஷில்லிங்குகள்),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(கிர்கிஸ்தானி சோம்),
				'one' => q(கிரிகிஸ்தானி சோம்),
				'other' => q(கிர்கிஸ்தானி சோம்கள்),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(கம்போடியன் ரியெல்),
				'one' => q(கம்போடியன் ரியெல்),
				'other' => q(கம்போடியன் ரியெல்கள்),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(கமோரியன் ஃப்ராங்க்),
				'one' => q(கமோரியன் ஃப்ராங்க்),
				'other' => q(கமோரியன் ஃப்ராங்க்குகள்),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(வட கொரிய வான்),
				'one' => q(வட கொரிய வான்),
				'other' => q(வட கொரிய வான்),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(தென் கொரிய வான்),
				'one' => q(தென் கொரிய வான்),
				'other' => q(தென் கொரிய வான்),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(குவைத்தி தினார்),
				'one' => q(குவைத்தி தினார்),
				'other' => q(குவைத்தி தினார்கள்),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(கேமன் தீவுகள் டாலர்),
				'one' => q(கேமன் தீவுகள் டாலர்),
				'other' => q(கேமன் தீவுகள் டாலர்கள்),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(கஸகஸ்தானி டென்கே),
				'one' => q(கஸகஸ்தானி டென்கே),
				'other' => q(கஸகஸ்தானி டென்கேக்கள்),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(லவோஷியன் கிப்),
				'one' => q(லவோஷியன் கிப்),
				'other' => q(லவோஷியன் கிப்கள்),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(லெபனீஸ் பவுண்ட்),
				'one' => q(லெபனீஸ் பவுண்ட்),
				'other' => q(லெபனீஸ் பவுண்டுகள்),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(இலங்கை ரூபாய்),
				'one' => q(இலங்கை ரூபாய்),
				'other' => q(இலங்கை ரூபாய்கள்),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(லைபீரியன் டாலர்),
				'one' => q(லைபீரியன் டாலர்),
				'other' => q(லைபீரியன் டாலர்கள்),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(லெசோதோ லோட்டி),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(லிதுவேனியன் லிடஸ்),
				'one' => q(லிதுவேனியன் லிடாஸ்),
				'other' => q(லிதுவேனியன் லிடை),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(லத்வியன் லாட்ஸ்),
				'one' => q(லாத்வியன் லாட்ஸ்),
				'other' => q(லத்வியன் லாட்டி),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(லிபியன் தினார்),
				'one' => q(லிபியன் தினார்),
				'other' => q(லிபியன் தினார்கள்),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(மொராக்கோ திர்ஹாம்),
				'one' => q(மொராக்கோ திர்ஹாம்),
				'other' => q(மொராக்கோ திர்ஹாம்கள்),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(மால்டோவன் லியூ),
				'one' => q(மால்டோவன் லியூ),
				'other' => q(மால்டோவன் லேய்),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(மலகாசி ஏரியரி),
				'one' => q(மலகாசி ஏரியரி),
				'other' => q(மலகாசி ஏரியரிகள்),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(மாசிடோனியன் டேனார்),
				'one' => q(மாசிடோனியன் டேனார்),
				'other' => q(மாசிடோனியன் டேனாரி),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(மியான்மர் கியாத்),
				'one' => q(மியான்மர் கியாத்),
				'other' => q(மியான்மர் கியாத்கள்),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(மங்கோலியன் டுக்ரிக்),
				'one' => q(மங்கோலியன் டுக்ரிக்),
				'other' => q(மங்கோலியன் டுக்ரிக்குகள்),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(மெகனீஸ் படாகா),
				'one' => q(மெகனீஸ் படாகா),
				'other' => q(மெகனீஸ் படாகாக்கள்),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(மொரிஷியனியன் ஒகுய்யா),
				'one' => q(மொரிஷியனியன் ஒகுய்யா),
				'other' => q(மொரிஷியனியன் ஒகுய்யாக்கள்),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(மொரீஷியன் ருபீ),
				'one' => q(மொரீஷியன் ருபீ),
				'other' => q(மொரீஷியன் ருபீக்கள்),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(மாலத்தீவு ருஃபியா),
				'one' => q(மாலத்தீவு ருஃபியா),
				'other' => q(மாலத்தீவு ருஃபியாக்கள்),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(மலாவியன் குவாச்சா),
				'one' => q(மலாவியன் குவாச்சா),
				'other' => q(மலாவியன் குவாச்சாக்கள்),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(மெக்ஸிகன் பெசோ),
				'one' => q(மெக்ஸிகன் பெசோ),
				'other' => q(மெக்ஸிகன் பெசோக்கள்),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(மலேஷியன் ரிங்கிட்),
				'one' => q(மலேஷியன் ரிங்கிட்),
				'other' => q(மலேஷியன் ரிங்கிட்கள்),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(மொசாம்பிகேன் மெடிகல்),
				'one' => q(மொசாம்பிகேன் மெடிகல்),
				'other' => q(மொசாம்பிகேன் மெடிகல்கள்),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(நமீபியன் டாலர்),
				'one' => q(நமீபியன் டாலர்),
				'other' => q(நமீபியன் டாலர்கள்),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(நைஜீரியன் நைரா),
				'one' => q(நைஜீரியன் நைரா),
				'other' => q(நைஜீரியன் நைராக்கள்),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(நிகாராகுவான் கோர்டோபா),
				'one' => q(நிகாராகுவான் கோர்டோபா),
				'other' => q(நிகாராகுவான் கோர்டோபாக்கள்),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(நார்வேஜியன் க்ரோன்),
				'one' => q(நார்வேஜியன் க்ரோன்),
				'other' => q(நார்வேஜியன் க்ரோனர்),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(நேபாளீஸ் ரூபாய்),
				'one' => q(நேபாளீஸ் ரூபாய்),
				'other' => q(நேபாளீஸ் ரூபாய்கள்),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(நியூசிலாந்து டாலர்),
				'one' => q(நியூசிலாந்து டாலர்),
				'other' => q(நியூசிலாந்து டாலர்கள்),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ஓமானி ரியால்),
				'one' => q(ஓமானி ரியால்),
				'other' => q(ஓமானி ரியால்கள்),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(பனாமானியன் பால்போவா),
				'one' => q(பனாமானியன் பால்போவா),
				'other' => q(பனாமானியன் பால்போவாக்கள்),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(பெருவியன் நியூவோ சோல்),
				'one' => q(பெருவியன் நியூவோ சோல்),
				'other' => q(பெருவியன் நியூவோ சோல்கள்),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(பபுவா நியூ கினியன் கினா),
				'one' => q(பபுவா நியூ கினியன் கினா),
				'other' => q(பபுவா நியூ கினியன் கினா),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(பிலிப்பைன் பெசோ),
				'one' => q(பிலிப்பைன் பெசோ),
				'other' => q(பிலிப்பைன் பெசோக்கள்),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(பாகிஸ்தானி ரூபாய்),
				'one' => q(பாகிஸ்தானி ரூபாய்),
				'other' => q(பாகிஸ்தானி ரூபாய்கள்),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(போலிஷ் ஸ்லாட்டி),
				'one' => q(போலிஷ் ஸ்லாட்டி),
				'other' => q(போலிஷ் ஸ்லாட்டிகள்),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(பராகுவன் குவாரானி),
				'one' => q(பராகுவன் குவாரானி),
				'other' => q(பராகுவன் குவாரானிகள்),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(கத்தாரி ரியால்),
				'one' => q(கத்தாரி ரியால்),
				'other' => q(கத்தாரி ரியால்கள்),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(ரோமானியன் லியூ),
				'one' => q(ரோமானியன் லியூ),
				'other' => q(ரோமானியன் லேய்),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(செர்பியன் தினார்),
				'one' => q(செர்பியன் தினார்),
				'other' => q(செர்பியன் தினார்கள்),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(ரஷியன் ரூபிள்),
				'one' => q(ரஷியன் ரூபிள்),
				'other' => q(ரஷியன் ரூபிள்கள்),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(ருவாண்டா ஃப்ராங்க்),
				'one' => q(ருவாண்டா ஃப்ராங்க்),
				'other' => q(ருவாண்டா ஃப்ராங்க்குகள்),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(சவுதி ரியால்),
				'one' => q(சவுதி ரியால்),
				'other' => q(சவுதி ரியால்கள்),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(சாலமன் தீவுகள் டாலர்),
				'one' => q(சாலமன் தீவுகள் டாலர்),
				'other' => q(சாலமன் தீவுகள் டாலர்கள்),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(சிசீலோயிஸ் ருபீ),
				'one' => q(சிசீலோயிஸ் ருபீ),
				'other' => q(சிசீலோயிஸ் ருபீக்கள்),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(சூடானீஸ் பவுண்டு),
				'one' => q(சூடானீஸ் பவுண்டு),
				'other' => q(சூடானீஸ் பவுண்டுகள்),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(ஸ்வீடிஷ் க்ரோனா),
				'one' => q(ஸ்வீடிஷ் க்ரோனா),
				'other' => q(ஸ்வீடிஷ் க்ரோனர்),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(சிங்கப்பூர் டாலர்),
				'one' => q(சிங்கப்பூர் டாலர்),
				'other' => q(சிங்கப்பூர் டாலர்கள்),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(செயின்ட் ஹெலேனா பவுண்டு),
				'one' => q(செயின்ட் ஹெலேனா பவுண்டு),
				'other' => q(செயின்ட் ஹெலேனா பவுண்டுகள்),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(சியாரா லியோனியன் லியோன்),
				'one' => q(சியாரா லியோனியன் லியோன்),
				'other' => q(சியாரா லியோனியன் லியோன்கள்),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(சோமாலி ஷில்லிங்),
				'one' => q(சோமாலி ஷில்லிங்),
				'other' => q(சோமாலி ஷில்லிங்குகள்),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(சுரினாமீஸ் டாலர்),
				'one' => q(சுரினாமீஸ் டாலர்),
				'other' => q(சுரினாமீஸ் டாலர்கள்),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(தெற்கு சூடானீஸ் பவுண்டு),
				'one' => q(தெற்கு சூடானீஸ் பவுண்டு),
				'other' => q(தெற்கு சூடானீஸ் பவுண்டுகள்),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(சாவ் டோமி மற்றும் பிரின்ஸ்பி டோப்ரா),
				'one' => q(சாவ் டோமி மற்றும் பிரின்ஸ்பி டோப்ரா),
				'other' => q(சாவ் டோமி மற்றும் பிரின்ஸ்பி டோப்ராக்கள்),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(சிரியன் பவுண்ட்),
				'one' => q(சிரியன் பவுண்ட்),
				'other' => q(சிரியன் பவுண்டுகள்),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(சுவாஸி லிலாங்கனி),
				'one' => q(சுவாஸி லிலாங்கனி),
				'other' => q(சுவாஸி எமாலாங்கனி),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(தாய் பாட்),
				'one' => q(தாய் பாட்),
				'other' => q(தாய் பாட்),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(தஜிகிஸ்தானி சோமோனி),
				'one' => q(தஜிகிஸ்தானி சோமோனி),
				'other' => q(தஜிகிஸ்தானி சோமோனிகள்),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(துர்க்மேனிஸ்தானி மனத்),
				'one' => q(துர்க்மேனிஸ்தானி மனத்),
				'other' => q(துர்க்மேனிஸ்தானி மனத்),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(துனிஷியன் தினார்),
				'one' => q(துனிஷியன் தினார்),
				'other' => q(துனிஷியன் தினார்கள்),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(தொங்கான் பங்கா),
				'one' => q(தொங்கான் பங்கா),
				'other' => q(தொங்கான் பங்கா),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(துருக்கிஷ் லீரா),
				'one' => q(துருக்கிஷ் லீரா),
				'other' => q(துருக்கிஷ் லீரா),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(டிரினிடாட் மற்றும் டோபாகோ டாலர்),
				'one' => q(டிரினிடாட் மற்றும் டோபாகோ டாலர்),
				'other' => q(டிரினிடாட் மற்றும் டோபாகோ டாலர்கள்),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(புதிய தைவான் டாலர்),
				'one' => q(புதிய தைவான் டாலர்),
				'other' => q(புதிய தைவான் டாலர்கள்),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(தன்ஸானியன் ஷில்லிங்),
				'one' => q(தன்ஸானியன் ஷில்லிங்),
				'other' => q(தன்ஸானியன் ஷில்லிங்குகள்),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(உக்ரைனியன் ஹிரைவ்னியா),
				'one' => q(உக்ரைனியன் ஹிரைவ்னியா),
				'other' => q(உக்ரைனியன் ஹிரைவ்னியாக்கள்),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(உகாண்டன் ஷில்லிங்),
				'one' => q(உகாண்டன் ஷில்லிங்),
				'other' => q(உகாண்டன் ஷில்லிங்குகள்),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(அமெரிக்க டாலர்),
				'one' => q(அமெரிக்க டாலர்),
				'other' => q(அமெரிக்க டாலர்கள்),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(உருகுவேயன் பேசோ),
				'one' => q(உருகுவேயன் பேசோ),
				'other' => q(உருகுவேயன் பேசோக்கள்),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(உஸ்பெக்கிஸ்தானி சோம்),
				'one' => q(உஸ்பெக்கிஸ்தானி சோம்),
				'other' => q(உஸ்பெக்கிஸ்தானி சோம்),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(வெனிசுலன் போலிவர்),
				'one' => q(வெனிசுலன் போலிவர்),
				'other' => q(வெனிசுலன் போலிவர்கள்),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(வியட்நாமீஸ் டாங்),
				'one' => q(வியட்நாமீஸ் டாங்),
				'other' => q(வியட்நாமீஸ் டாங்),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(வனுவாட்டு வாட்டு),
				'one' => q(வனுவாட்டு வாட்டு),
				'other' => q(வனுவாட்டு வாட்டுகள்),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(சமோவான் தாலா),
				'one' => q(சமோவான் தாலா),
				'other' => q(சமோவான் தாலா),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(மத்திய ஆப்பிரிக்க CFA ஃப்ராங்க்),
				'one' => q(மத்திய ஆப்பிரிக்க CFA ஃப்ராங்க்),
				'other' => q(மத்திய ஆப்பிரிக்க CFA ஃப்ராங்க்குகள்),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(கிழக்கு கரீபியன் டாலர்),
				'one' => q(கிழக்கு கரீபியன் டாலர்),
				'other' => q(கிழக்கு கரீபியன் டாலர்கள்),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(மேற்கு ஆப்பிரிக்கன் CFA ஃப்ராங்க்),
				'one' => q(மேற்கு ஆப்பிரிக்கன் CFA ஃப்ராங்க்),
				'other' => q(மேற்கு ஆப்பிரிக்கன் CFA ஃப்ராங்க்குகள்),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ஃப்ராங்க் \(CFP\)),
				'one' => q(ஃப்ராங்க் \(CFP\)),
				'other' => q(ஃப்ராங்குகள் \(CFP\)),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(தெரியாத நாணயம்),
				'one' => q(\(தெரியாத நாணய அலகு\)),
				'other' => q(\(தெரியாத நாணயம்\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(ஏமனி ரியால்),
				'one' => q(ஏமனி ரியால்),
				'other' => q(ஏமனி ரியால்கள்),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(தென் ஆப்ரிக்க ராண்ட்),
				'one' => q(தென் ஆப்ரிக்க ராண்ட்),
				'other' => q(தென் ஆப்ரிக்க ராண்ட்),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(ஸாம்பியன் குவாசா \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(ஸாம்பியன் குவாசா),
				'one' => q(ஸாம்பியன் குவாசா),
				'other' => q(ஸாம்பியன் குவாசாக்கள்),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'chinese' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'மா1',
							'மா2',
							'மா3',
							'மா4',
							'மா5',
							'மா6',
							'மா7',
							'மா8',
							'மா9',
							'மா10',
							'மா11',
							'மா12'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'மாதம்1',
							'மாதம்2',
							'மாதம்3',
							'மாதம்4',
							'மாதம்5',
							'மாதம்6',
							'மாதம்7',
							'மாதம்8',
							'மாதம்9',
							'மாதம்10',
							'மாதம்11',
							'மாதம்12'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'மா1',
							'மா2',
							'மா3',
							'மா4',
							'மா5',
							'மா6',
							'மா7',
							'மா8',
							'மா9',
							'மா10',
							'மா11',
							'மா12'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'மாதம்1',
							'மாதம்2',
							'மாதம்3',
							'மாதம்4',
							'மாதம்5',
							'மாதம்6',
							'மாதம்7',
							'மாதம்8',
							'மாதம்9',
							'மாதம்10',
							'மாதம்11',
							'மாதம்12'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ஜன.',
							'பிப்.',
							'மார்.',
							'ஏப்.',
							'மே',
							'ஜூன்',
							'ஜூலை',
							'ஆக.',
							'செப்.',
							'அக்.',
							'நவ.',
							'டிச.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ஜ',
							'பி',
							'மா',
							'ஏ',
							'மே',
							'ஜூ',
							'ஜூ',
							'ஆ',
							'செ',
							'அ',
							'ந',
							'டி'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ஜனவரி',
							'பிப்ரவரி',
							'மார்ச்',
							'ஏப்ரல்',
							'மே',
							'ஜூன்',
							'ஜூலை',
							'ஆகஸ்ட்',
							'செப்டம்பர்',
							'அக்டோபர்',
							'நவம்பர்',
							'டிசம்பர்'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ஜன.',
							'பிப்.',
							'மார்.',
							'ஏப்.',
							'மே',
							'ஜூன்',
							'ஜூலை',
							'ஆக.',
							'செப்.',
							'அக்.',
							'நவ.',
							'டிச.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ஜ',
							'பி',
							'மா',
							'ஏ',
							'மே',
							'ஜூ',
							'ஜூ',
							'ஆ',
							'செ',
							'அ',
							'ந',
							'டி'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ஜனவரி',
							'பிப்ரவரி',
							'மார்ச்',
							'ஏப்ரல்',
							'மே',
							'ஜூன்',
							'ஜூலை',
							'ஆகஸ்டு',
							'செப்டம்பர்',
							'அக்டோபர்',
							'நவம்பர்',
							'டிசம்பர்'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'திங்.',
						tue => 'செவ்.',
						wed => 'புத.',
						thu => 'வியா.',
						fri => 'வெள்.',
						sat => 'சனி',
						sun => 'ஞாயி.'
					},
					narrow => {
						mon => 'தி',
						tue => 'செ',
						wed => 'பு',
						thu => 'வி',
						fri => 'வெ',
						sat => 'ச',
						sun => 'ஞா'
					},
					short => {
						mon => 'தி',
						tue => 'செ',
						wed => 'பு',
						thu => 'வி',
						fri => 'வெ',
						sat => 'ச',
						sun => 'ஞா'
					},
					wide => {
						mon => 'திங்கள்',
						tue => 'செவ்வாய்',
						wed => 'புதன்',
						thu => 'வியாழன்',
						fri => 'வெள்ளி',
						sat => 'சனி',
						sun => 'ஞாயிறு'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'திங்.',
						tue => 'செவ்.',
						wed => 'புத.',
						thu => 'வியா.',
						fri => 'வெள்.',
						sat => 'சனி',
						sun => 'ஞாயி.'
					},
					narrow => {
						mon => 'தி',
						tue => 'செ',
						wed => 'பு',
						thu => 'வி',
						fri => 'வெ',
						sat => 'ச',
						sun => 'ஞா'
					},
					short => {
						mon => 'தி',
						tue => 'செ',
						wed => 'பு',
						thu => 'வி',
						fri => 'வெ',
						sat => 'ச',
						sun => 'ஞா'
					},
					wide => {
						mon => 'திங்கள்',
						tue => 'செவ்வாய்',
						wed => 'புதன்',
						thu => 'வியாழன்',
						fri => 'வெள்ளி',
						sat => 'சனி',
						sun => 'ஞாயிறு'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'காலா.1',
						1 => 'காலா.2',
						2 => 'காலா.3',
						3 => 'காலா.4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1ஆம் காலாண்டு',
						1 => '2ஆம் காலாண்டு',
						2 => '3ஆம் காலாண்டு',
						3 => '4ஆம் காலாண்டு'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'காலா.1',
						1 => 'காலா.2',
						2 => 'காலா.3',
						3 => 'காலா.4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1ஆம் காலாண்டு',
						1 => '2ஆம் காலாண்டு',
						2 => '3ஆம் காலாண்டு',
						3 => '4ஆம் காலாண்டு'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	traits		=> ['Code'],
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	handles		=> { call => 'execute_method' },
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'chinese') {
				if($day_period_type eq 'default') {
					return 'evening2' if $time >= 1800
						&& $time < 2100;
					return 'morning2' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 300
						&& $time < 500;
					return 'evening1' if $time >= 1600
						&& $time < 1800;
					return 'afternoon1' if $time > 1200
						&& $time < 1400;
					return 'noon' if $time == 1200;
					return 'afternoon2' if $time >= 1400
						&& $time < 1600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon2' if $time >= 1400
						&& $time < 1600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'evening1' if $time >= 1600
						&& $time < 1800;
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'evening2' if $time >= 1800
						&& $time < 2100;
					return 'morning2' if $time >= 500
						&& $time < 1200;
					return 'morning1' if $time >= 300
						&& $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'evening2' if $time >= 1800
						&& $time < 2100;
					return 'morning2' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 300
						&& $time < 500;
					return 'evening1' if $time >= 1600
						&& $time < 1800;
					return 'afternoon1' if $time > 1200
						&& $time < 1400;
					return 'noon' if $time == 1200;
					return 'afternoon2' if $time >= 1400
						&& $time < 1600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon2' if $time >= 1400
						&& $time < 1600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'evening1' if $time >= 1600
						&& $time < 1800;
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'evening2' if $time >= 1800
						&& $time < 2100;
					return 'morning2' if $time >= 500
						&& $time < 1200;
					return 'morning1' if $time >= 300
						&& $time < 500;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'evening2' if $time >= 1800
						&& $time < 2100;
					return 'morning2' if $time >= 500
						&& $time < 1200;
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'midnight' if $time == 0;
					return 'morning1' if $time >= 300
						&& $time < 500;
					return 'evening1' if $time >= 1600
						&& $time < 1800;
					return 'afternoon1' if $time > 1200
						&& $time < 1400;
					return 'noon' if $time == 1200;
					return 'afternoon2' if $time >= 1400
						&& $time < 1600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon2' if $time >= 1400
						&& $time < 1600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'evening1' if $time >= 1600
						&& $time < 1800;
					return 'night1' if $time >= 2100
						&& $time < 2400;
					return 'evening2' if $time >= 1800
						&& $time < 2100;
					return 'morning2' if $time >= 500
						&& $time < 1200;
					return 'morning1' if $time >= 300
						&& $time < 500;
				}
				last SWITCH;
				}
		}
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'afternoon2' => q{பிற்.},
					'morning1' => q{அதி.},
					'night1' => q{இர.},
					'am' => q{மு.ப},
					'midnight' => q{நள்.},
					'noon' => q{நண்.},
					'evening1' => q{மா.},
					'afternoon1' => q{மதி.},
					'morning2' => q{கா.},
					'pm' => q{பி.ப},
					'evening2' => q{அந்தி மா.},
				},
				'abbreviated' => {
					'evening2' => q{அந்தி மாலை},
					'pm' => q{பிற்பகல்},
					'morning2' => q{காலை},
					'evening1' => q{மாலை},
					'afternoon1' => q{மதியம்},
					'noon' => q{நண்பகல்},
					'am' => q{முற்பகல்},
					'night1' => q{இரவு},
					'midnight' => q{நள்ளிரவு},
					'morning1' => q{அதிகாலை},
					'afternoon2' => q{பிற்பகல்},
				},
				'wide' => {
					'afternoon2' => q{பிற்பகல்},
					'afternoon1' => q{மதியம்},
					'evening1' => q{மாலை},
					'noon' => q{நண்பகல்},
					'night1' => q{இரவு},
					'midnight' => q{நள்ளிரவு},
					'am' => q{முற்பகல்},
					'morning1' => q{அதிகாலை},
					'evening2' => q{அந்தி மாலை},
					'morning2' => q{காலை},
					'pm' => q{பிற்பகல்},
				},
			},
			'stand-alone' => {
				'wide' => {
					'afternoon2' => q{பிற்பகல்},
					'morning1' => q{அதிகாலை},
					'night1' => q{இரவு},
					'am' => q{முற்பகல்},
					'midnight' => q{நள்ளிரவு},
					'noon' => q{நண்பகல்},
					'afternoon1' => q{மதியம்},
					'evening1' => q{மாலை},
					'morning2' => q{காலை},
					'pm' => q{பிற்பகல்},
					'evening2' => q{அந்தி மாலை},
				},
				'narrow' => {
					'noon' => q{நண்.},
					'afternoon1' => q{மதி.},
					'evening1' => q{மா.},
					'morning1' => q{அதி.},
					'night1' => q{இ.},
					'am' => q{மு.ப},
					'midnight' => q{நள்.},
					'afternoon2' => q{பிற்.},
					'morning2' => q{கா.},
					'pm' => q{பி.ப},
					'evening2' => q{அந்தி மா.},
				},
				'abbreviated' => {
					'evening2' => q{அந்தி மாலை},
					'morning2' => q{காலை},
					'pm' => q{பிற்பகல்},
					'evening1' => q{மாலை},
					'afternoon1' => q{மதியம்},
					'noon' => q{நண்பகல்},
					'am' => q{முற்பகல்},
					'night1' => q{இரவு},
					'midnight' => q{நள்ளிரவு},
					'morning1' => q{அதிகாலை},
					'afternoon2' => q{பிற்பகல்},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'கி.மு.',
				'1' => 'கி.பி.'
			},
			wide => {
				'0' => 'கிறிஸ்துவுக்கு முன்',
				'1' => 'அன்னோ டோமினி'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
			'full' => q{U MMMM d, EEEE},
			'long' => q{U, d MMMM},
			'medium' => q{U, d MMM},
			'short' => q{dd-MM-y},
		},
		'generic' => {
			'full' => q{EEEE, d MMMM, y G},
			'long' => q{d MMMM, y G},
			'medium' => q{d MMM, y G},
			'short' => q{d-M-y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM, y},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM, y},
			'short' => q{d/M/yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{a h:mm:ss zzzz},
			'long' => q{a h:mm:ss z},
			'medium' => q{a h:mm:ss},
			'short' => q{a h:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
			'full' => q{{1} அன்று {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1} ’அன்று’ {0}},
			'long' => q{{1} ’அன்று’ {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			E => q{ccc},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E a h:mm},
			Ehms => q{E a h:mm:ss},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{MM-dd, E},
			MMM => q{LLL},
			MMMEd => q{MMM d, E},
			MMMMd => q{d MMMM},
			MMMd => q{MMM d},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{a h},
			hm => q{a h:mm},
			hms => q{a h:mm:ss},
			hmsv => q{a h:mm:ss v},
			hmv => q{a h:mm v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM, y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM, y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
		'generic' => {
			E => q{ccc},
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{a h},
			hm => q{a h:mm},
			hms => q{a h:mm:ss},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y G},
			yyyyMEd => q{E, d/M/y G},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM, y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM, y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{a h – a h},
				h => q{a h–h},
			},
			hm => {
				a => q{a h:mm – a h:mm},
				h => q{a h:mm–h:mm},
				m => q{a h:mm–h:mm},
			},
			hmv => {
				a => q{a h:mm – a h:mm v},
				h => q{a h:mm – h:mm v},
				m => q{a h:mm – h:mm v},
			},
			hv => {
				a => q{a h – a h v},
				h => q{a h – h v},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM – MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y},
				d => q{E, d MMM – E, d MMM, y},
				y => q{E, d MMM, y – E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM – MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{d – d MMM, y},
				y => q{d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{a h – a h},
				h => q{a h–h},
			},
			hm => {
				a => q{a h:mm – a h:mm},
				h => q{a h:mm–h:mm},
				m => q{a h:mm–h:mm},
			},
			hmv => {
				a => q{a h:mm – a h:mm v},
				h => q{a h:mm–h:mm v},
				m => q{a h:mm–h:mm v},
			},
			hv => {
				a => q{a h – a h v},
				h => q{a h–h v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y G},
				d => q{E, d/M/y – E, d/M/y G},
				y => q{E, d/M/y – E, d/M/y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y G},
				d => q{E, d MMM – E, d MMM, y G},
				y => q{E, d MMM, y – E, d MMM, y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y G},
				d => q{d–d MMM, y G},
				y => q{d MMM, y – d MMM, y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} நேரம்),
		regionFormat => q({0} பகலொளி நேரம்),
		regionFormat => q({0} நிலையான நேரம்),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(அக்ரே கோடை நேரம்),
				'generic' => q(அக்ரே நேரம்),
				'standard' => q(அக்ரே தர நேரம்),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(ஆஃப்கானிஸ்தான் நேரம்),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#அபிட்ஜான்#,
		},
		'Africa/Accra' => {
			exemplarCity => q#அக்ரா#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#அடிஸ் அபாபா#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#அல்ஜியர்ஸ்#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#அஸ்மாரா#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#பமாகோ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#பாங்குயீ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#பஞ்சுல்#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#பிஸாவ்#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#பிளான்டையர்#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#பிராஸாவில்லி#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#புஜும்புரா#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#கெய்ரோ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#காஸாபிளான்கா#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#சியூட்டா#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#கோனக்ரே#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#டாகர்#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#தார் எஸ் சலாம்#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#டிஜிபவ்டி#,
		},
		'Africa/Douala' => {
			exemplarCity => q#தவுலா#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#எல் ஆயுன்#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ஃப்ரீடவுன்#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#கபோரோன்#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ஹராரே#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ஜோஹன்னஸ்பெர்க்#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ஜுபா#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#கம்பாலா#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#கார்டோம்#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#கிகலி#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#கின்ஷசா#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#லாகோஸ்#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#லிப்ரேவில்லே#,
		},
		'Africa/Lome' => {
			exemplarCity => q#லோம்#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#லுவான்டா#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#லுபும்பாஷி#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#லுசாகா#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#மாலபோ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#மபுடோ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#மசேரு#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#பபான்#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#மொகாதிஷு#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#மான்ரோவியா#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#நைரோபி#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ஜமேனா#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#நியாமே#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#நோவாக்சோட்#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#அவுகடவ்கு#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#போர்ட்டோ-நோவோ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#சாவோ டோமே#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#த்ரிபோலி#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#டுனிஸ்#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#வைண்ட்ஹோக்#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(மத்திய ஆப்பிரிக்க நேரம்),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(கிழக்கு ஆப்பிரிக்க நேரம்),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(தென் ஆப்பிரிக்க நிலையான நேரம்),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(மேற்கு ஆப்பிரிக்கா கோடை நேரம்),
				'generic' => q(மேற்கு ஆப்பிரிக்க நேரம்),
				'standard' => q(மேற்கு ஆப்பிரிக்க நிலையான நேரம்),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(அலாஸ்கா பகலொளி நேரம்),
				'generic' => q(அலாஸ்கா நேரம்),
				'standard' => q(அலாஸ்கா நிலையான நேரம்),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(அல்மாடி கோடை நேரம்),
				'generic' => q(அல்மாடி நேரம்),
				'standard' => q(அல்மாடி தர நேரம்),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(அமேசான் கோடை நேரம்),
				'generic' => q(அமேசான் நேரம்),
				'standard' => q(அமேசான் நிலையான நேரம்),
			},
		},
		'America/Adak' => {
			exemplarCity => q#அடக்#,
		},
		'America/Anchorage' => {
			exemplarCity => q#அங்கோரேஜ்#,
		},
		'America/Anguilla' => {
			exemplarCity => q#அங்குயுலா#,
		},
		'America/Antigua' => {
			exemplarCity => q#ஆன்டிகுவா#,
		},
		'America/Araguaina' => {
			exemplarCity => q#அரகுவாய்னா#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#லா ரியோஜா#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ரியோ கேலிகாஸ்#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#சால்டா#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#சான் ஜுவான்#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#சான் லூயிஸ்#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#டுகுமன்#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#உஷுவாயா#,
		},
		'America/Aruba' => {
			exemplarCity => q#அரூபா#,
		},
		'America/Asuncion' => {
			exemplarCity => q#அஸன்சியன்#,
		},
		'America/Bahia' => {
			exemplarCity => q#பாஹியா#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#பஹியா பந்தேராஸ்#,
		},
		'America/Barbados' => {
			exemplarCity => q#பார்படாஸ்#,
		},
		'America/Belem' => {
			exemplarCity => q#பெலெம்#,
		},
		'America/Belize' => {
			exemplarCity => q#பெலிஸ்#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ப்லாங்க்-சப்லான்#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#போவா விஸ்டா#,
		},
		'America/Bogota' => {
			exemplarCity => q#போகோடா#,
		},
		'America/Boise' => {
			exemplarCity => q#போய்ஸ்#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ப்யூனோஸ் ஏர்ஸ்#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#கேம்பிரிட்ஜ் வளைகுடா#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#கேம்போ கிராண்டே#,
		},
		'America/Cancun' => {
			exemplarCity => q#கன்குன்#,
		},
		'America/Caracas' => {
			exemplarCity => q#கேராகஸ்#,
		},
		'America/Catamarca' => {
			exemplarCity => q#கடமார்கா#,
		},
		'America/Cayenne' => {
			exemplarCity => q#கெய்ன்#,
		},
		'America/Cayman' => {
			exemplarCity => q#கேமன்#,
		},
		'America/Chicago' => {
			exemplarCity => q#சிகாகோ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#சுவாவா#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#அடிகோகன்#,
		},
		'America/Cordoba' => {
			exemplarCity => q#கார்டோபா#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#கோஸ்டா ரிகா#,
		},
		'America/Creston' => {
			exemplarCity => q#க்ரெஸ்டான்#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#குயாபே#,
		},
		'America/Curacao' => {
			exemplarCity => q#க்யூராகோ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#டென்மார்க்ஷாவ்ன்#,
		},
		'America/Dawson' => {
			exemplarCity => q#டாவ்சன்#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#டாவ்சன் கிரீக்#,
		},
		'America/Denver' => {
			exemplarCity => q#டென்வர்#,
		},
		'America/Detroit' => {
			exemplarCity => q#டெட்ராய்ட்#,
		},
		'America/Dominica' => {
			exemplarCity => q#டொமினிகா#,
		},
		'America/Edmonton' => {
			exemplarCity => q#எட்மான்டான்#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ஈருனெபே#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#எல் சால்வடோர்#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ஃபோர்டாலெசா#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#கிலேஸ் வளைகுடா#,
		},
		'America/Godthab' => {
			exemplarCity => q#நூக்#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#கூஸ் பே#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#கிராண்ட் துர்க்#,
		},
		'America/Grenada' => {
			exemplarCity => q#கிரனடா#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#கவுடேலூப்#,
		},
		'America/Guatemala' => {
			exemplarCity => q#கவுதமாலா#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#குவாயகில்#,
		},
		'America/Guyana' => {
			exemplarCity => q#கயானா#,
		},
		'America/Halifax' => {
			exemplarCity => q#ஹலிஃபேக்ஸ்#,
		},
		'America/Havana' => {
			exemplarCity => q#ஹவானா#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ஹெர்மோசிலோ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#நாக்ஸ், இண்டியானா#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#மரென்கோ, இண்டியானா#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#பீட்டர்ஸ்பெர்க், இண்டியானா#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#டெல் சிட்டி, இண்டியானா#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#வேவே, இண்டியானா#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#வின்செனேஸ், இண்டியானா#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#வினாமேக், இண்டியானா#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#இண்டியானாபொலிஸ்#,
		},
		'America/Inuvik' => {
			exemplarCity => q#இனுவிக்#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#இகாலூயித்#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ஜமைக்கா#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ஜூஜுய்#,
		},
		'America/Juneau' => {
			exemplarCity => q#ஜுனியூ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#மான்டிசெல்லோ, கென்டக்கி#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#கிரெலன்டிஜ்#,
		},
		'America/La_Paz' => {
			exemplarCity => q#லா பாஸ்#,
		},
		'America/Lima' => {
			exemplarCity => q#லிமா#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#லாஸ் ஏஞ்சல்ஸ்#,
		},
		'America/Louisville' => {
			exemplarCity => q#லூயிஸ்வில்லே#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#லோயர் பிரின்ஸஸ் குவார்ட்டர்#,
		},
		'America/Maceio' => {
			exemplarCity => q#மேசியோ#,
		},
		'America/Managua' => {
			exemplarCity => q#மானாகுவா#,
		},
		'America/Manaus' => {
			exemplarCity => q#மனாஸ்#,
		},
		'America/Marigot' => {
			exemplarCity => q#மாரிகாட்#,
		},
		'America/Martinique' => {
			exemplarCity => q#மார்ட்டினிக்#,
		},
		'America/Matamoros' => {
			exemplarCity => q#மடமோராஸ்#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#மஸட்லன்#,
		},
		'America/Mendoza' => {
			exemplarCity => q#மென்டோஸா#,
		},
		'America/Menominee' => {
			exemplarCity => q#மெனோமினி#,
		},
		'America/Merida' => {
			exemplarCity => q#மெரிடா#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#மெட்லகட்லா#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#மெக்ஸிகோ நகரம்#,
		},
		'America/Miquelon' => {
			exemplarCity => q#மிக்யூலன்#,
		},
		'America/Moncton' => {
			exemplarCity => q#மாங்டான்#,
		},
		'America/Monterrey' => {
			exemplarCity => q#மான்டெர்ரே#,
		},
		'America/Montevideo' => {
			exemplarCity => q#மான்டேவீடியோ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#மான்செரேட்#,
		},
		'America/Nassau' => {
			exemplarCity => q#நசவ்#,
		},
		'America/New_York' => {
			exemplarCity => q#நியூயார்க்#,
		},
		'America/Nipigon' => {
			exemplarCity => q#நிபிகான்#,
		},
		'America/Nome' => {
			exemplarCity => q#நோம்#,
		},
		'America/Noronha' => {
			exemplarCity => q#நோரன்ஹா#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#பெவுலா, வடக்கு டகோட்டா#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#சென்டர், வடக்கு டகோடா#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#நியூ சலேம், வடக்கு டகோடா#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ஒஜினகா#,
		},
		'America/Panama' => {
			exemplarCity => q#பனாமா#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#பாங்னிர்துங்#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#பரமரிபோ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ஃபோனிக்ஸ்#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#போர்ட்-வ்-பிரின்ஸ்#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#போர்ட் ஆஃப் ஸ்பெயின்#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#போர்ட்டோ வெல்ஹோ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#பியூர்டோ ரிகோ#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ரெய்னி ரிவர்#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ரான்கின் இன்லெட்#,
		},
		'America/Recife' => {
			exemplarCity => q#ரெஸிஃபி#,
		},
		'America/Regina' => {
			exemplarCity => q#ரெஜினா#,
		},
		'America/Resolute' => {
			exemplarCity => q#ரெசலூட்#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ரியோ பிரான்கோ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#சான்டா இசபெல்#,
		},
		'America/Santarem' => {
			exemplarCity => q#சான்டரெம்#,
		},
		'America/Santiago' => {
			exemplarCity => q#சாண்டியாகோ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#சாண்டோ டோமிங்கோ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#சாவோ பவுலோ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#இடோகோர்டோர்மிட்#,
		},
		'America/Sitka' => {
			exemplarCity => q#சிட்கா#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#செயின்ட் பார்தேலெமி#,
		},
		'America/St_Johns' => {
			exemplarCity => q#செயின்ட் ஜான்ஸ்#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#செயின்ட் கீட்ஸ்#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#செயிண்ட் லூசியா#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#செயின்ட் தாமஸ்#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#செயிண்ட் வின்சென்ட்#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ஸ்விஃப்ட் கரண்ட்#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#தெகுசிகல்பா#,
		},
		'America/Thule' => {
			exemplarCity => q#துலே#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#தண்டர் பே#,
		},
		'America/Tijuana' => {
			exemplarCity => q#டிஜுவானா#,
		},
		'America/Toronto' => {
			exemplarCity => q#டொரொன்டோ#,
		},
		'America/Tortola' => {
			exemplarCity => q#டோர்டோலா#,
		},
		'America/Vancouver' => {
			exemplarCity => q#வான்கூவர்#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#வொயிட்ஹார்ஸ்#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#வின்னிபெக்#,
		},
		'America/Yakutat' => {
			exemplarCity => q#யகுடட்#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#யெல்லோநைஃப்#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(மத்திய பகலொளி நேரம்),
				'generic' => q(மத்திய நேரம்),
				'standard' => q(மத்திய நிலையான நேரம்),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(கிழக்கத்திய பகலொளி நேரம்),
				'generic' => q(கிழக்கத்திய நேரம்),
				'standard' => q(கிழக்கத்திய நிலையான நேரம்),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(மவுன்டைன் பகலொளி நேரம்),
				'generic' => q(மவுன்டைன் நேரம்),
				'standard' => q(மவுன்டைன் நிலையான நேரம்),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(பசிபிக் பகலொளி நேரம்),
				'generic' => q(பசிபிக் நேரம்),
				'standard' => q(பசிபிக் நிலையான நேரம்),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(அனாடையர் கோடை நேரம்),
				'generic' => q(அனடீர் நேரம்),
				'standard' => q(அனாடையர் தர நேரம்),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#கேஸி#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#டேவிஸ்#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#டுமோண்ட்-டி உர்வில்லே#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#மாக்கியூரி#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#மாசன்#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#மெக்மர்டோ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#பால்மர்#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ரோதேரா#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ஸ்யோவா#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ட்ரோல்#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#வோஸ்டோக்#,
		},
		'Apia' => {
			long => {
				'daylight' => q(ஏபியா பகலொளி நேரம்),
				'generic' => q(ஏபியா நேரம்),
				'standard' => q(ஏபியா நிலையான நேரம்),
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q(அட்டௌ கோடை நேரம்),
				'generic' => q(அட்டௌ நேரம்),
				'standard' => q(அட்டௌ தர நேரம்),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(அட்டோபே கோடை நேரம்),
				'generic' => q(அட்டோபே நேரம்),
				'standard' => q(அட்டோபே தர நேரம்),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(அரேபிய பகலொளி நேரம்),
				'generic' => q(அரேபிய நேரம்),
				'standard' => q(அரேபிய நிலையான நேரம்),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#லாங்இயர்பியன்#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(அர்ஜென்டினா கோடை நேரம்),
				'generic' => q(அர்ஜென்டினா நேரம்),
				'standard' => q(அர்ஜென்டினா நிலையான நேரம்),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(மேற்கத்திய அர்ஜென்டினா கோடை நேரம்),
				'generic' => q(மேற்கத்திய அர்ஜென்டினா நேரம்),
				'standard' => q(மேற்கத்திய அர்ஜென்டினா நிலையான நேரம்),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(ஆர்மேனிய கோடை நேரம்),
				'generic' => q(ஆர்மேனிய நேரம்),
				'standard' => q(ஆர்மேனிய நிலையான நேரம்),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ஏடன்#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#அல்மாதி#,
		},
		'Asia/Amman' => {
			exemplarCity => q#அம்மான்#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#அனடீர்#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#அக்தவ்#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#அக்டோப்#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#அஷ்காபாத்#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#பாக்தாத்#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#பஹ்ரைன்#,
		},
		'Asia/Baku' => {
			exemplarCity => q#பாக்கூ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#பாங்காக்#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#பெய்ரூட்#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#பிஷ்கெக்#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#புருனே#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#கொல்கத்தா#,
		},
		'Asia/Chita' => {
			exemplarCity => q#சிடா#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#சோய்பால்சான்#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#கொழும்பு#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#டமாஸ்கஸ்#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#டாக்கா#,
		},
		'Asia/Dili' => {
			exemplarCity => q#டிலி#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#துபாய்#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#துஷன்பே#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#காஸா#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ஹெப்ரான்#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ஹாங்காங்#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ஹோவ்த்#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#இர்குட்ஸ்க்#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ஜகார்த்தா#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ஜெயபூரா#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ஜெருசலேம்#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#காபூல்#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#காம்சட்கா#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#கராச்சி#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#காத்மாண்டு#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#கான்டிகா#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#கிராஸ்னோயார்க்ஸ்#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#கோலாலம்பூர்#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#குசிங்#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#குவைத்#,
		},
		'Asia/Macau' => {
			exemplarCity => q#மகவ்#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#மகதன்#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#மக்கஸர்#,
		},
		'Asia/Manila' => {
			exemplarCity => q#மணிலா#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#மஸ்கட்#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#நிகோசியா#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#நோவோகுஸ்நெட்ஸ்க்#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#நோவோசீபிர்ஸ்க்#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ஓம்ஸ்க்#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ஓரல்#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ஃப்னோம் பென்#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#போன்டியானாக்#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#பியோங்கியாங்#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#கத்தார்#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#கிஸிலோர்டா#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ரங்கூன்#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ரியாத்#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ஹோ சி மின் சிட்டி#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#சகலின்#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#சமார்கண்ட்#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#சியோல்#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ஷாங்காய்#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#சிங்கப்பூர்#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#ஸ்ரெட்நிகோலிம்ஸ்க்#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#தைபே#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#தாஷ்கண்ட்#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#த்பிலிசி#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#டெஹ்ரான்#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#திம்பு#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#டோக்கியோ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#உலான்பாட்டர்#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#உரும்கி#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#உஸ்ட்-நேரா#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#வியன்டியன்#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#விளாடிவொஸ்தோக்#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#யகுட்ஸ்க்#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#யெகாடிரின்பர்க்#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ஏரேவன்#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(அட்லாண்டிக் பகலொளி நேரம்),
				'generic' => q(அட்லாண்டிக் நேரம்),
				'standard' => q(அட்லாண்டிக் நிலையான நேரம்),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#அசோரஸ்#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#பெர்முடா#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#கேனரி#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#கேப் வெர்டே#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ஃபரோ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#மடிரா#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ரேக்ஜாவிக்#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#தெற்கு ஜார்ஜியா#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#செயின்ட் ஹெலெனா#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ஸ்டேன்லி#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#அடிலெய்ட்#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#பிரிஸ்பேன்#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#புரோக்கன் ஹில்#,
		},
		'Australia/Currie' => {
			exemplarCity => q#கியூரி#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#டார்வின்#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#யூக்லா#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ஹோபர்ட்#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#லின்டெமன்#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#லார்டு ஹோவே#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#மெல்போர்ன்#,
		},
		'Australia/Perth' => {
			exemplarCity => q#பெர்த்#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#சிட்னி#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(ஆஸ்திரேலியன் மத்திய பகலொளி நேரம்),
				'generic' => q(மத்திய ஆஸ்திரேலிய நேரம்),
				'standard' => q(ஆஸ்திரேலியன் மத்திய நிலையான நேரம்),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(ஆஸ்திரேலியன் மத்திய மேற்கத்திய பகலொளி நேரம்),
				'generic' => q(ஆஸ்திரேலியன் மத்திய மேற்கத்திய நேரம்),
				'standard' => q(ஆஸ்திரேலியன் மத்திய மேற்கத்திய நிலையான நேரம்),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(ஆஸ்திரேலியன் கிழக்கத்திய பகலொளி நேரம்),
				'generic' => q(கிழக்கத்திய ஆஸ்திரேலிய நேரம்),
				'standard' => q(ஆஸ்திரேலியன் கிழக்கத்திய நிலையான நேரம்),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(ஆஸ்திரேலியன் மேற்கத்திய பகலொளி நேரம்),
				'generic' => q(மேற்கத்திய ஆஸ்திரேலிய நேரம்),
				'standard' => q(ஆஸ்திரேலியன் மேற்கத்திய நிலையான நேரம்),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(அசர்பைஜான் கோடை நேரம்),
				'generic' => q(அசர்பைஜான் நேரம்),
				'standard' => q(அசர்பைஜான் நிலையான நேரம்),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(அசோர்ஸ் கோடை நேரம்),
				'generic' => q(அசோரஸ் நேரம்),
				'standard' => q(அசோரஸ் நிலையான நேரம்),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(வங்கதேச கோடை நேரம்),
				'generic' => q(வங்கதேச நேரம்),
				'standard' => q(வங்கதேச நிலையான நேரம்),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(பூடான் நேரம்),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(பொலிவியா நேரம்),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(பிரேசிலியா கோடை நேரம்),
				'generic' => q(பிரேசிலியா நேரம்),
				'standard' => q(பிரேசிலியா நிலையான நேரம்),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(புருனே டருஸ்ஸலாம் நேரம்),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(கேப் வெர்டே கோடை நேரம்),
				'generic' => q(கேப் வெர்டே நேரம்),
				'standard' => q(கேப் வெர்டே நிலையான நேரம்),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(சாமோரோ நிலையான நேரம்),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(சத்தாம் பகலொளி நேரம்),
				'generic' => q(சத்தாம் நேரம்),
				'standard' => q(சத்தாம் நிலையான நேரம்),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(சிலி கோடை நேரம்),
				'generic' => q(சிலி நேரம்),
				'standard' => q(சிலி நிலையான நேரம்),
			},
		},
		'China' => {
			long => {
				'daylight' => q(சீன பகலொளி நேரம்),
				'generic' => q(சீன நேரம்),
				'standard' => q(சீன நிலையான நேரம்),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(சோய்பால்சன் கோடை நேரம்),
				'generic' => q(சோய்பால்சன் நேரம்),
				'standard' => q(சோய்பால்சன் நிலையான நேரம்),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(கிறிஸ்துமஸ் தீவு நேரம்),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(கோகோஸ் தீவுகள் நேரம்),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(கொலம்பியா கோடை நேரம்),
				'generic' => q(கொலம்பியா நேரம்),
				'standard' => q(கொலம்பியா நிலையான நேரம்),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(குக் தீவுகள் அரை கோடை நேரம்),
				'generic' => q(குக் தீவுகள் நேரம்),
				'standard' => q(குக் தீவுகள் நிலையான நேரம்),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(கியூபா பகலொளி நேரம்),
				'generic' => q(கியூபா நேரம்),
				'standard' => q(கியூபா நிலையான நேரம்),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(டேவிஸ் நேரம்),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(டுமோண்ட்-டி உர்வில்லே நேரம்),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(கிழக்கு திமோர் நேரம்),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ஈஸ்டர் தீவு கோடை நேரம்),
				'generic' => q(ஈஸ்டர் தீவு நேரம்),
				'standard' => q(ஈஸ்டர் தீவு நிலையான நேரம்),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(ஈக்வடார் நேரம்),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#தெரியாத நகரம்#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ஆம்ஸ்டர்டம்#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#அண்டோரா#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ஏதேன்ஸ்#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#பெல்க்ரேடு#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#பெர்லின்#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#பிரடிஸ்லாவா#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#புருசேல்ஸ்#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#புசாரெஸ்ட்#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#புடாபெஸ்ட்#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#பசிங்ஜென்#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#சிசினவ்#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#கோபன்ஹேகன்#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#டப்ளின்#,
			long => {
				'daylight' => q(ஐரிஷ் நிலையான நேரம்),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ஜிப்ரால்டர்#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#கர்னஸே#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ஹெல்சிங்கி#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ஐல் ஆஃப் மேன்#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#இஸ்தான்புல்#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ஜெர்சி#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#கலினின்கிராடு#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#கீவ்#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#லிஸ்பன்#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ஜுப்லானா#,
		},
		'Europe/London' => {
			exemplarCity => q#லண்டன்#,
			long => {
				'daylight' => q(பிரிட்டிஷ் கோடை நேரம்),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#லக்சம்பர்க்#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#மாட்ரிட்#,
		},
		'Europe/Malta' => {
			exemplarCity => q#மால்டா#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#மரிஹமன்#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#மின்ஸ்க்#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#மொனாக்கோ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#மாஸ்கோ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ஓஸ்லோ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#பாரீஸ்#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#போட்கோரிகா#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ப்ராக்#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ரிகா#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ரோம்#,
		},
		'Europe/Samara' => {
			exemplarCity => q#சமாரா#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#சான் மாரினோ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#சராஜேவோ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#சிம்ஃபெரோபோல்#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#ஸ்கோப்ஜே#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#சோஃபியா#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ஸ்டாக்ஹோம்#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#டலின்#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#திரானே#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#உஜ்கோரோட்#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#வதுஸ்#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#வாடிகன்#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#வியன்னா#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#வில்னியஸ்#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#வோல்கோகிராட்#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#வார்ஸா#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ஸக்ரெப்#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ஜபோரோஸியே#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ஜூரிச்#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(மத்திய ஐரோப்பிய கோடை நேரம்),
				'generic' => q(மத்திய ஐரோப்பிய நேரம்),
				'standard' => q(மத்திய ஐரோப்பிய நிலையான நேரம்),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(கிழக்கத்திய ஐரோப்பிய கோடை நேரம்),
				'generic' => q(கிழக்கத்திய ஐரோப்பிய நேரம்),
				'standard' => q(கிழக்கத்திய ஐரோப்பிய நிலையான நேரம்),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(தூர-கிழக்கு ஐரோப்பிய நேரம்),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(மேற்கத்திய ஐரோப்பிய கோடை நேரம்),
				'generic' => q(மேற்கத்திய ஐரோப்பிய நேரம்),
				'standard' => q(மேற்கத்திய ஐரோப்பிய நிலையான நேரம்),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(ஃபாக்லாந்து தீவுகள் கோடை நேரம்),
				'generic' => q(ஃபாக்லாந்து தீவுகள் நேரம்),
				'standard' => q(ஃபாக்லாந்து தீவுகள் நிலையான நேரம்),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(ஃபிஜி கோடை நேரம்),
				'generic' => q(ஃபிஜி நேரம்),
				'standard' => q(ஃபிஜி நிலையான நேரம்),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(ஃபிரஞ்சு கயானா நேரம்),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(ஃபிரஞ்சு தெற்கத்திய & அண்டார்டிக் நேரம்),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(கிரீன்விச் சராசரி நேரம்),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(கலபகோஸ் நேரம்),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(கேம்பியர் நேரம்),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(ஜார்ஜியா கோடை நேரம்),
				'generic' => q(ஜார்ஜியா நேரம்),
				'standard' => q(ஜார்ஜியா நிலையான நேரம்),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(கில்பர்ட் தீவுகள் நேரம்),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(கிழக்கு கிரீன்லாந்து கோடை நேரம்),
				'generic' => q(கிழக்கு கிரீன்லாந்து நேரம்),
				'standard' => q(கிழக்கு கிரீன்லாந்து நிலையான நேரம்),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(மேற்கு கிரீன்லாந்து கோடை நேரம்),
				'generic' => q(மேற்கு கிரீன்லாந்து நேரம்),
				'standard' => q(மேற்கு கிரீன்லாந்து நிலையான நேரம்),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(கம் தர நேரம்),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(வளைகுடா நிலையான நேரம்),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(கயானா நேரம்),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(ஹவாய்-அலேஷியன் பகலொளி நேரம்),
				'generic' => q(ஹவாய்-அலேஷியன் நேரம்),
				'standard' => q(ஹவாய்-அலேஷியன் நிலையான நேரம்),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(ஹாங்காங் கோடை நேரம்),
				'generic' => q(ஹாங்காங் நேரம்),
				'standard' => q(ஹாங்காங் நிலையான நேரம்),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(ஹோவ்த் கோடை நேரம்),
				'generic' => q(ஹோவ்த் நேரம்),
				'standard' => q(ஹோவ்த் நிலையான நேரம்),
			},
		},
		'India' => {
			long => {
				'standard' => q(இந்திய நிலையான நேரம்),
			},
			short => {
				'standard' => q(IST),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ஆண்டனநரிவோ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#சாகோஸ்#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#கிறிஸ்துமஸ்#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#கோகோஸ்#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#கொமரோ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#கெர்யூலென்#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#மாஹே#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#மாலத்தீவுகள்#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#மொரிஷியஸ்#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#மயோட்டி#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ரீயூனியன்#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(இந்தியப் பெருங்கடல் நேரம்),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(இந்தோசீன நேரம்),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(மத்திய இந்தோனேஷிய நேரம்),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(கிழக்கத்திய இந்தோனேஷிய நேரம்),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(மேற்கத்திய இந்தோனேஷியா நேரம்),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ஈரான் பகலொளி நேரம்),
				'generic' => q(ஈரான் நேரம்),
				'standard' => q(ஈரான் நிலையான நேரம்),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(இர்குட்ஸ்க் கோடை நேரம்),
				'generic' => q(இர்குட்ஸ்க் நேரம்),
				'standard' => q(இர்குட்ஸ்க் நிலையான நேரம்),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(இஸ்ரேல் பகலொளி நேரம்),
				'generic' => q(இஸ்ரேல் நேரம்),
				'standard' => q(இஸ்ரேல் நிலையான நேரம்),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(ஜப்பான் பகலொளி நேரம்),
				'generic' => q(ஜப்பான் நேரம்),
				'standard' => q(ஜப்பான் நிலையான நேரம்),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(பெட்ரோபவ்லோவ்ஸ்க் கம்சட்ஸ்கி கோடை நேரம்),
				'generic' => q(பெட்ரோபவ்லோவ்ஸ்க் கம்சட்ஸ்கி நேரம்),
				'standard' => q(பெட்ரோபவ்லோவ்ஸ்க் கம்சட்ஸ்கி தர நேரம்),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(கிழக்கு கஜகஸ்தான் நேரம்),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(மேற்கு கஜகஸ்தான் நேரம்),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(கொரிய பகலொளி நேரம்),
				'generic' => q(கொரிய நேரம்),
				'standard' => q(கொரிய நிலையான நேரம்),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(கோஸ்ரே நேரம்),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(க்ரஸ்னோயார்ஸ்க் கோடை நேரம்),
				'generic' => q(க்ரஸ்னோயார்ஸ்க் நேரம்),
				'standard' => q(க்ரஸ்னோயார்ஸ்க் நிலையான நேரம்),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(கிர்கிஸ்தான் நேரம்),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(லங்கா நேரம்),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(லைன் தீவுகள் நேரம்),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(லார்ட் ஹோவ் பகலொளி நேரம்),
				'generic' => q(லார்ட் ஹோவ் நேரம்),
				'standard' => q(லார்ட் ஹோவ் நிலையான நேரம்),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(மக்காவ் கோடை நேரம்),
				'generic' => q(மக்காவ் நேரம்),
				'standard' => q(மக்காவ் தர நேரம்),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(மாக்கியூரி தீவு நேரம்),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(மகதன் கோடை நேரம்),
				'generic' => q(மகதன் நேரம்),
				'standard' => q(மகதன் நிலையான நேரம்),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(மலேஷிய நேரம்),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(மாலத்தீவுகள் நேரம்),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(மார்கியூசாஸ் நேரம்),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(மார்ஷல் தீவுகள் நேரம்),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(மொரிஷியஸ் கோடை நேரம்),
				'generic' => q(மொரிஷியஸ் நேரம்),
				'standard' => q(மொரிஷியஸ் நிலையான நேரம்),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(மாசன் நேரம்),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(வடமேற்கு மெக்ஸிகோ பகலொளி நேரம்),
				'generic' => q(வடமேற்கு மெக்ஸிகோ நேரம்),
				'standard' => q(வடமேற்கு மெக்ஸிகோ நிலையான நேரம்),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(மெக்ஸிகன் பசிபிக் பகலொளி நேரம்),
				'generic' => q(மெக்ஸிகன் பசிபிக் நேரம்),
				'standard' => q(மெக்ஸிகன் பசிபிக் நிலையான நேரம்),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(உலன் பாடர் கோடை நேரம்),
				'generic' => q(உலன் பாடர் நேரம்),
				'standard' => q(உலன் பாடர் நிலையான நேரம்),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(மாஸ்கோ கோடை நேரம்),
				'generic' => q(மாஸ்கோ நேரம்),
				'standard' => q(மாஸ்கோ நிலையான நேரம்),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(மியான்மர் நேரம்),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(நவ்ரூ நேரம்),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(நேபாள் நேரம்),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(நியூ கலிடோனியா கோடை நேரம்),
				'generic' => q(நியூ கலிடோனியா நேரம்),
				'standard' => q(நியூ கலிடோனியா நிலையான நேரம்),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(நியூசிலாந்து பகலொளி நேரம்),
				'generic' => q(நியூசிலாந்து நேரம்),
				'standard' => q(நியூசிலாந்து நிலையான நேரம்),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(நியூஃபவுண்ட்லாந்து பகலொளி நேரம்),
				'generic' => q(நியூஃபவுண்ட்லாந்து நேரம்),
				'standard' => q(நியூஃபவுண்ட்லாந்து நிலையான நேரம்),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(நியு நேரம்),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(நோர்ஃபோக் தீவுகள் நேரம்),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(பெர்னான்டோ டி நோரோன்ஹா கோடை நேரம்),
				'generic' => q(பெர்னாண்டோ டி நோரன்ஹா நேரம்),
				'standard' => q(பெர்னான்டோ டி நோரோன்ஹா நிலையான நேரம்),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(வடக்கு மரினா தீவுகள் நேரம்),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(நோவோசிபிரிஸ்க் கோடை நேரம்),
				'generic' => q(நோவோசிபிரிஸ்க் நேரம்),
				'standard' => q(நோவோசிபிரிஸ்க் நிலையான நேரம்),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ஓம்ஸ்க் கோடை நேரம்),
				'generic' => q(ஓம்ஸ்க் நேரம்),
				'standard' => q(ஓம்ஸ்க் நிலையான நேரம்),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#அபியா#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ஆக்லாந்து#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#போகெய்ன்வில்லே#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#சத்தாம்#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ஈஸ்டர்#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ஈஃபேட்#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#எண்டர்பரி#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ஃபகாஃபோ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ஃபிஜி#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ஃபுனாஃபுடி#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#கலபகோஸ்#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#கேம்பியர்#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#கவுடால்கேனல்#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#குவாம்#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ஹோனோலூலூ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ஜோன்ஸ்டன்#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#கிரிடிமடி#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#கோஸ்ரே#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#க்வாஜாலீயன்#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#மஜுரோ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#மார்கியூசாஸ்#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#மிட்வே#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#நவ்ரூ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#நியு#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#நார்ஃபோக்#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#நவுமியா#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#பேகோ பேகோ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#பாலவ்#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#பிட்கெய்ர்ன்#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ஃபோன்பெய்#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#போர்ட் மோர்ஸ்பை#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ரரோடோங்கா#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#சைபன்#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#தஹிதி#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#தராவா#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#டோன்கடப்பு#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#சுக்#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#வேக்#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#வாலிஸ்#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(பாகிஸ்தான் கோடை நேரம்),
				'generic' => q(பாகிஸ்தான் நேரம்),
				'standard' => q(பாகிஸ்தான் நிலையான நேரம்),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(பாலவ் நேரம்),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(பபுவா நியூ கினியா நேரம்),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(பராகுவே கோடை நேரம்),
				'generic' => q(பராகுவே நேரம்),
				'standard' => q(பராகுவே நிலையான நேரம்),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(பெரு கோடை நேரம்),
				'generic' => q(பெரு நேரம்),
				'standard' => q(பெரு நிலையான நேரம்),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(பிலிப்பைன் கோடை நேரம்),
				'generic' => q(பிலிப்பைன் நேரம்),
				'standard' => q(பிலிப்பைன் நிலையான நேரம்),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(ஃபோனிக்ஸ் தீவுகள் நேரம்),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(செயின்ட் பியரி & மிக்குயிலான் பகலொளி நேரம்),
				'generic' => q(செயின்ட் பியரி & மிக்குயிலான் நேரம்),
				'standard' => q(செயின்ட் பியரி & மிக்குயிலான் நிலையான நேரம்),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(பிட்கெய்ர்ன் நேரம்),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(போனாபே நேரம்),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(கைஜைலோர்டா கோடை நேரம்),
				'generic' => q(கைஜைலோர்டா நேரம்),
				'standard' => q(கைஜைலோர்டா தர நேரம்),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(ரீயூனியன் நேரம்),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(ரோதேரா நேரம்),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(சகலின் கோடை நேரம்),
				'generic' => q(சகலின் நேரம்),
				'standard' => q(சகலின் நிலையான நேரம்),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(சமரா கோடை நேரம்),
				'generic' => q(சமரா நேரம்),
				'standard' => q(சமரா தர நேரம்),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(சமோவா பகலொளி நேரம்),
				'generic' => q(சமோவா நேரம்),
				'standard' => q(சமோவா நிலையான நேரம்),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(சீசெல்ஸ் நேரம்),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(சிங்கப்பூர் நிலையான நேரம்),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(சாலமன் தீவுகள் நேரம்),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(தெற்கு ஜார்ஜியா நேரம்),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(சுரினாம் நேரம்),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(ஸ்யோவா நேரம்),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(தஹிதி நேரம்),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(தைபே பகலொளி நேரம்),
				'generic' => q(தைபே நேரம்),
				'standard' => q(தைபே நிலையான நேரம்),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(தஜிகிஸ்தான் நேரம்),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(டோக்கெலாவ் நேரம்),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(டோங்கா கோடை நேரம்),
				'generic' => q(டோங்கா நேரம்),
				'standard' => q(டோங்கா நிலையான நேரம்),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(சுக் நேரம்),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(துர்க்மெனிஸ்தான் கோடை நேரம்),
				'generic' => q(துர்க்மெனிஸ்தான் நேரம்),
				'standard' => q(துர்க்மெனிஸ்தான் நிலையான நேரம்),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(துவாலு நேரம்),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(உருகுவே கோடை நேரம்),
				'generic' => q(உருகுவே நேரம்),
				'standard' => q(உருகுவே நிலையான நேரம்),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(உஸ்பெகிஸ்தான் கோடை நேரம்),
				'generic' => q(உஸ்பெகிஸ்தான் நேரம்),
				'standard' => q(உஸ்பெகிஸ்தான் நிலையான நேரம்),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(வனுவாட்டு கோடை நேரம்),
				'generic' => q(வனுவாட்டு நேரம்),
				'standard' => q(வனுவாட்டு நிலையான நேரம்),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(வெனிசுலா நேரம்),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(விளாடிவோஸ்டோக் கோடை நேரம்),
				'generic' => q(விளாடிவோஸ்டோக் நேரம்),
				'standard' => q(விளாடிவோஸ்டோக் நிலையான நேரம்),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(வோல்கோக்ராட் கோடை நேரம்),
				'generic' => q(வோல்கோக்ராட் நேரம்),
				'standard' => q(வோல்கோக்ராட் நிலையான நேரம்),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(வோஸ்டோக் நேரம்),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(வேக் தீவு நேரம்),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(வாலிஸ் மற்றும் ஃப்யூடுனா நேரம்),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(யகுட்ஸ்க் கோடை நேரம்),
				'generic' => q(யகுட்ஸ்க் நேரம்),
				'standard' => q(யகுட்ஸ்க் நிலையான நேரம்),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(யேகாடெரின்பர்க் கோடை நேரம்),
				'generic' => q(யேகாடெரின்பர்க் நேரம்),
				'standard' => q(யேகாடெரின்பர்க் நிலையான நேரம்),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
