=encoding utf8

=head1

Locale::CLDR::Locales::Si - Package for language Sinhala

=cut

package Locale::CLDR::Locales::Si;
# This file auto generated from Data\common\main\si.xml
#	on Tue 10 Oct  8:39:18 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.2');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'අෆාර්',
 				'ab' => 'ඇබ්කාසියානු',
 				'ace' => 'අචයිනිස්',
 				'ada' => 'අඩන්ග්මෙ',
 				'ady' => 'අඩිඝෙ',
 				'aeb' => 'ටියුනිසියනු අරාබි',
 				'af' => 'අෆ්රිකාන්ස්',
 				'agq' => 'ඇගම්',
 				'ain' => 'අයිනු',
 				'ak' => 'අකාන්',
 				'ale' => 'ඇලුඑට්',
 				'alt' => 'සතර්න් අල්ටය්',
 				'am' => 'ඇම්හාරික්',
 				'an' => 'ඇරගොනීස්',
 				'anp' => 'අන්ගික',
 				'ar' => 'අරාබි',
 				'ar_001' => 'නූතන සම්මත අරාබි',
 				'arn' => 'මපුචෙ',
 				'arp' => 'ඇරපහො',
 				'as' => 'ඇසෑම්',
 				'asa' => 'අසු',
 				'ast' => 'ඇස්ටියුරියන්',
 				'av' => 'ඇවරික්',
 				'awa' => 'අවදි',
 				'ay' => 'අයිමරා',
 				'az' => 'අසර්බයිජාන්',
 				'az@alt=short' => 'අසීරී',
 				'ba' => 'බාෂ්කිර්',
 				'ban' => 'බැලිනීස්',
 				'bas' => 'බසා',
 				'be' => 'බෙලරුසියානු',
 				'bem' => 'බෙම්බා',
 				'bez' => 'බෙනා',
 				'bg' => 'බල්ගේරියානු',
 				'bgn' => 'බටහිර බලොචි',
 				'bho' => 'බොජ්පුරි',
 				'bi' => 'බිස්ලමා',
 				'bin' => 'බිනි',
 				'bla' => 'සික්සිකා',
 				'bm' => 'බම්බරා',
 				'bn' => 'බෙංගාලි',
 				'bo' => 'ටිබෙට්',
 				'br' => 'බ්‍රේටොන්',
 				'brx' => 'බොඩො',
 				'bs' => 'බොස්නියානු',
 				'bug' => 'බුගිනීස්',
 				'byn' => 'බ්ලින්',
 				'ca' => 'කැටලන්',
 				'ce' => 'චෙච්නියානු',
 				'ceb' => 'සෙබුඅනො',
 				'cgg' => 'චිගා',
 				'ch' => 'චමොරො',
 				'chk' => 'චූකීස්',
 				'chm' => 'මරි',
 				'cho' => 'චොක්ටොව්',
 				'chr' => 'චෙරොකී',
 				'chy' => 'චෙයෙන්නෙ',
 				'ckb' => 'සොරානි කුර්දිෂ්',
 				'co' => 'කෝසිකානු',
 				'crs' => 'සෙසෙල්ව ක්‍රොල් ෆ්‍රෙන්ච්',
 				'cs' => 'චෙක්',
 				'cu' => 'චර්ච් ස්ලැවික්',
 				'cv' => 'චවේෂ්',
 				'cy' => 'වෙල්ෂ්',
 				'da' => 'ඩැනිශ්',
 				'dak' => 'ඩකොටා',
 				'dar' => 'ඩාර්ග්වා',
 				'dav' => 'ටයිටා',
 				'de' => 'ජර්මන්',
 				'de_AT' => 'ඔස්ට්‍රියානු ජර්මන්',
 				'de_CH' => 'ස්විස් උසස් ජර්මන්',
 				'dgr' => 'ඩොග්‍රිබ්',
 				'dje' => 'සර්මා',
 				'dsb' => 'පහළ සෝබියානු',
 				'dua' => 'ඩුආලා',
 				'dv' => 'ඩිවෙහි',
 				'dyo' => 'ජොල-ෆෝනියි',
 				'dz' => 'ඩිසොන්කා',
 				'dzg' => 'ඩසාගා',
 				'ebu' => 'එම්බු',
 				'ee' => 'ඉව්',
 				'efi' => 'එෆික්',
 				'eka' => 'එකජුක්',
 				'el' => 'ග්‍රීක',
 				'en' => 'ඉංග්‍රීසි',
 				'en_AU' => 'ඕස්ට්‍රේලියානු ඉංග්‍රීසි',
 				'en_CA' => 'කැනේඩියානු ඉංග්‍රීසි',
 				'en_GB' => 'බ්‍රිතාන්‍ය ඉංග්‍රීසි',
 				'en_GB@alt=short' => 'එ.රා ඉංග්‍රීසි',
 				'en_US' => 'ඇමෙරිකානු ඉංග්‍රීසි',
 				'en_US@alt=short' => 'එ.ජ ඉංග්‍රීසි',
 				'eo' => 'එස්පැරන්ටෝ',
 				'es' => 'ස්පාඤ්ඤ',
 				'es_419' => 'ලතින් ඇමරිකානු ස්පාඤ්ඤ',
 				'es_ES' => 'යුරෝපීය ස්පාඤ්ඤ',
 				'es_MX' => 'මෙක්සිකානු ස්පාඤ්ඤ',
 				'et' => 'එස්තෝනියානු',
 				'eu' => 'බාස්ක්',
 				'ewo' => 'එවොන්ඩො',
 				'fa' => 'පර්සියානු',
 				'ff' => 'ෆුලාහ්',
 				'fi' => 'ෆින්ලන්ත',
 				'fil' => 'පිලිපීන',
 				'fj' => 'ෆීජි',
 				'fo' => 'ෆාරෝස්',
 				'fon' => 'ෆොන්',
 				'fr' => 'ප්‍රංශ',
 				'fr_CA' => 'කැනේඩියානු ප්‍රංශ',
 				'fr_CH' => 'ස්විස් ප්‍රංශ',
 				'fur' => 'ෆ්‍රියුලියන්',
 				'fy' => 'බටහිර ෆ්‍රිසියානු',
 				'ga' => 'අයර්ලන්ත',
 				'gaa' => 'ගා',
 				'gag' => 'ගගාස්',
 				'gan' => 'ගැන් චයිනිස්',
 				'gd' => 'ස්කොට්ටිශ් ගෙලික්',
 				'gez' => 'ගීස්',
 				'gil' => 'ගිල්බර්ටීස්',
 				'gl' => 'ගැලීසියානු',
 				'gn' => 'ගුවාරනි',
 				'gor' => 'ගොරොන්ටාලො',
 				'gsw' => 'ස්විස් ජර්මානු',
 				'gu' => 'ගුජරාටි',
 				'guz' => 'ගුසී',
 				'gv' => 'මැන්ක්ස්',
 				'gwi' => 'ග්විචින්',
 				'ha' => 'හෝසා',
 				'hak' => 'හකා චයිනිස්',
 				'haw' => 'හවායි',
 				'he' => 'හීබෲ',
 				'hi' => 'හින්දි',
 				'hil' => 'හිලිගෙනන්',
 				'hmn' => 'මොන්ග්',
 				'hr' => 'කෝඒෂියානු',
 				'hsb' => 'ඉහළ සෝබියානු',
 				'hsn' => 'සියැන් චීන',
 				'ht' => 'හයිටි',
 				'hu' => 'හන්ගේරියානු',
 				'hup' => 'හුපා',
 				'hy' => 'ආර්මේනියානු',
 				'hz' => 'හෙරෙරො',
 				'ia' => 'ඉන්ටලින්ගුආ',
 				'iba' => 'ඉබන්',
 				'ibb' => 'ඉබිබියො',
 				'id' => 'ඉන්දුනීසියානු',
 				'ig' => 'ඉග්බෝ',
 				'ii' => 'සිචුආන් යී',
 				'ilo' => 'ඉලොකො',
 				'inh' => 'ඉන්ගුෂ්',
 				'io' => 'ඉඩො',
 				'is' => 'අයිස්ලන්ත',
 				'it' => 'ඉතාලි',
 				'iu' => 'ඉනුක්ටිටුට්',
 				'ja' => 'ජපන්',
 				'jbo' => 'ලොජ්බන්',
 				'jgo' => 'නොම්බා',
 				'jmc' => 'මැකාමී',
 				'jv' => 'ජාවා',
 				'ka' => 'ජෝර්ජියානු',
 				'kab' => 'කාබිල්',
 				'kac' => 'කචින්',
 				'kaj' => 'ජ්ජු',
 				'kam' => 'කැම්බා',
 				'kbd' => 'කබාර්ඩියන්',
 				'kcg' => 'ට්යප්',
 				'kde' => 'මැකොන්ඩ්',
 				'kea' => 'කබුවෙර්ඩියානු',
 				'kfo' => 'කොරො',
 				'kha' => 'ඛසි',
 				'khq' => 'කොයිරා චිනි',
 				'ki' => 'කිකුයු',
 				'kj' => 'කුයන්යමා',
 				'kk' => 'කසාඛ්',
 				'kkj' => 'කකො',
 				'kl' => 'කලාලිසට්',
 				'kln' => 'කලෙන්ජන්',
 				'km' => 'කමර්',
 				'kmb' => 'කිම්බුන්ඩු',
 				'kn' => 'කණ්ණඩ',
 				'ko' => 'කොරියානු',
 				'koi' => 'කොමි-පර්මියාක්',
 				'kok' => 'කොන්කනි',
 				'kpe' => 'ක්පෙලෙ',
 				'kr' => 'කනුරි',
 				'krc' => 'කරන්චි-බාකර්',
 				'krl' => 'කැරෙලියන්',
 				'kru' => 'කුරුඛ්',
 				'ks' => 'කාෂ්මීර්',
 				'ksb' => 'ශාම්බලා',
 				'ksf' => 'බාෆියා',
 				'ksh' => 'කොලොග්නියන්',
 				'ku' => 'කුර්දි',
 				'kum' => 'කුමික්',
 				'kv' => 'කොමි',
 				'kw' => 'කෝනීසියානු',
 				'ky' => 'කිර්ගිස්',
 				'la' => 'ලතින්',
 				'lad' => 'ලඩිනො',
 				'lag' => 'ලංගි',
 				'lb' => 'ලක්සැම්බර්ග්',
 				'lez' => 'ලෙස්ගියන්',
 				'lg' => 'ගන්ඩා',
 				'li' => 'ලිම්බර්ගිශ්',
 				'lkt' => 'ලකොට',
 				'ln' => 'ලින්ගලා',
 				'lo' => 'ලාඕ',
 				'loz' => 'ලොසි',
 				'lrc' => 'උතුරු ලුරි',
 				'lt' => 'ලිතුවේනියානු',
 				'lu' => 'ලුබා-කටන්ගා',
 				'lua' => 'ලුබ-ලුලුඅ',
 				'lun' => 'ලුන්ඩ',
 				'luo' => 'ලුඔ',
 				'lus' => 'මිසො',
 				'luy' => 'ලුයියා',
 				'lv' => 'ලැට්වියානු',
 				'mad' => 'මදුරීස්',
 				'mag' => 'මඝහි',
 				'mai' => 'මයිතිලි',
 				'mak' => 'මකාසාර්',
 				'mas' => 'මසායි',
 				'mdf' => 'මොක්ශා',
 				'men' => 'මෙන්ඩෙ',
 				'mer' => 'මෙරු',
 				'mfe' => 'මොරිස්යෙම්',
 				'mg' => 'මලගාසි',
 				'mgh' => 'මඛුවා-මීටෝ',
 				'mgo' => 'මෙටා',
 				'mh' => 'මාශලීස්',
 				'mi' => 'මාවොරි',
 				'mic' => 'මික්මැක්',
 				'min' => 'මිනන්ග්කබාවු',
 				'mk' => 'මැසිඩෝනියානු',
 				'ml' => 'මලයාලම්',
 				'mn' => 'මොංගෝලියානු',
 				'mni' => 'මනිපුරි',
 				'moh' => 'මොහොව්ක්',
 				'mos' => 'මොස්සි',
 				'mr' => 'මරාති',
 				'ms' => 'මැලේ',
 				'mt' => 'මොල්ටිස්',
 				'mua' => 'මුන්ඩන්',
 				'mul' => 'බහු භාෂා',
 				'mus' => 'ක්‍රීක්',
 				'mwl' => 'මිරන්ඩීස්',
 				'my' => 'බුරුම',
 				'myv' => 'එර්ස්යා',
 				'mzn' => 'මැසන්ඩරනි',
 				'na' => 'නෞරු',
 				'nan' => 'මින් නන් චයිනිස්',
 				'nap' => 'නියාපොලිටන්',
 				'naq' => 'නාමා',
 				'nb' => 'නෝර්වීජියානු බොක්මල්',
 				'nd' => 'උතුරු එන්ඩිබෙලෙ',
 				'nds' => 'පහළ ජර්මන්',
 				'nds_NL' => 'පහළ සැක්සන්',
 				'ne' => 'නේපාල',
 				'new' => 'නෙවාරි',
 				'ng' => 'න්ඩොන්ගා',
 				'nia' => 'නියාස්',
 				'niu' => 'නියුඑන්',
 				'nl' => 'ලන්දේසි',
 				'nl_BE' => 'ෆ්ලෙමිශ්',
 				'nmg' => 'කුවාසිඔ',
 				'nn' => 'නෝර්වීජියානු නයිනෝර්ස්ක්',
 				'nnh' => 'න්ගියාම්බූන්',
 				'nog' => 'නොගායි',
 				'nqo' => 'එන්‘කෝ',
 				'nr' => 'සෞත් ඩ්බේල්',
 				'nso' => 'නොදර්න් සොතො',
 				'nus' => 'නොයර්',
 				'nv' => 'නවාජො',
 				'ny' => 'න්යන්ජා',
 				'nyn' => 'නයන්කෝලෙ',
 				'oc' => 'ඔසිටාන්',
 				'om' => 'ඔරොමෝ',
 				'or' => 'ඔඩියා',
 				'os' => 'ඔසිටෙක්',
 				'pa' => 'පන්ජාබි',
 				'pag' => 'පන්ගසීනන්',
 				'pam' => 'පන්පන්ග',
 				'pap' => 'පපියමෙන්ටො',
 				'pau' => 'පලවුවන්',
 				'pcm' => 'නෛජීරියන් පෙන්ගින්',
 				'pl' => 'පෝලන්ත',
 				'prg' => 'පෘශියන්',
 				'ps' => 'පෂ්ටො',
 				'pt' => 'පෘතුගීසි',
 				'pt_BR' => 'බ්‍රසීල පෘතුගීසි',
 				'pt_PT' => 'යුරෝපීය පෘතුගීසි',
 				'qu' => 'ක්වීචුවා',
 				'quc' => 'කියිචේ',
 				'rap' => 'රපනුයි',
 				'rar' => 'රරොටොන්ගන්',
 				'rm' => 'රොමෑන්ශ්',
 				'rn' => 'රුන්ඩි',
 				'ro' => 'රොමේනියානු',
 				'ro_MD' => 'මොල්ඩවිආනු',
 				'rof' => 'රෝම්බෝ',
 				'root' => 'රූට්',
 				'ru' => 'රුසියානු',
 				'rup' => 'ඇරොමානියානු',
 				'rw' => 'කින්යර්වන්ඩා',
 				'rwk' => 'ර්වා',
 				'sa' => 'සංස්කෘත',
 				'sad' => 'සන්ඩවෙ',
 				'sah' => 'සඛා',
 				'saq' => 'සම්බුරු',
 				'sat' => 'සෑන්ටලි',
 				'sba' => 'න්ගම්බෙ',
 				'sbp' => 'සංගු',
 				'sc' => 'සාර්ඩිනිඅන්',
 				'scn' => 'සිසිලියන්',
 				'sco' => 'ස්කොට්ස්',
 				'sd' => 'සින්ධි',
 				'sdh' => 'දකුණු කුර්දි',
 				'se' => 'උතුරු සාමි',
 				'seh' => 'සෙනා',
 				'ses' => 'කෝයිරාබොරො සෙන්නි',
 				'sg' => 'සන්ග්‍රෝ',
 				'shi' => 'ටචේල්හිට්',
 				'shn' => 'ශාන්',
 				'si' => 'සිංහල',
 				'sk' => 'ස්ලෝවැක්',
 				'sl' => 'ස්ලෝවේනියානු',
 				'sm' => 'සෑමොඅන්',
 				'sma' => 'දකුණු සාමි',
 				'smj' => 'ලුලේ සාමි',
 				'smn' => 'ඉනාරි සාමි',
 				'sms' => 'ස්කොල්ට් සාමි',
 				'sn' => 'ශෝනා',
 				'snk' => 'සොනින්කෙ',
 				'so' => 'සෝමාලි',
 				'sq' => 'ඇල්බේනියානු',
 				'sr' => 'සර්බියානු',
 				'srn' => 'ස්‍රන් ටොන්ගො',
 				'ss' => 'ස්වති',
 				'ssy' => 'සහො',
 				'st' => 'සතර්න් සොතො',
 				'su' => 'සන්ඩනීසියානු',
 				'suk' => 'සුකුමා',
 				'sv' => 'ස්වීඩන්',
 				'sw' => 'ස්වාහිලි',
 				'sw_CD' => 'කොංගෝ ස්වාහිලි',
 				'swb' => 'කොමොරියන්',
 				'syr' => 'ස්‍රයෑක්',
 				'ta' => 'දෙමළ',
 				'te' => 'තෙළිඟු',
 				'tem' => 'ටිම්නෙ',
 				'teo' => 'ටෙසෝ',
 				'tet' => 'ටේටම්',
 				'tg' => 'ටජික්',
 				'th' => 'තායි',
 				'ti' => 'ටිග්‍රින්යා',
 				'tig' => 'ටීග්‍රෙ',
 				'tk' => 'ටර්ක්මෙන්',
 				'tlh' => 'ක්ලින්ගොන්',
 				'tn' => 'ස්වනා',
 				'to' => 'ටොංගා',
 				'tpi' => 'ටොක් පිසින්',
 				'tr' => 'තුර්කි',
 				'trv' => 'ටරොකො',
 				'ts' => 'සොන්ග',
 				'tt' => 'ටාටර්',
 				'tum' => 'ටුම්බුකා',
 				'tvl' => 'ටුවාලු',
 				'twq' => 'ටසවාක්',
 				'ty' => 'ටහිටියන්',
 				'tyv' => 'ටුවිනියන්',
 				'tzm' => 'මධ්‍යම ඇට්ලස් ටමසිට්',
 				'udm' => 'අඩ්මර්ට්',
 				'ug' => 'උයිගර්',
 				'uk' => 'යුක්රේනියානු',
 				'umb' => 'උබුන්ඩු',
 				'und' => 'නොදන්නා භාෂාව',
 				'ur' => 'උර්දු',
 				'uz' => 'උස්බෙක්',
 				'vai' => 'වයි',
 				've' => 'වෙන්ඩා',
 				'vi' => 'වියට්නාම්',
 				'vo' => 'වොලපූක්',
 				'vun' => 'වුන්ජෝ',
 				'wa' => 'වෑලූන්',
 				'wae' => 'වොල්සර්',
 				'wal' => 'වොලෙට්ට',
 				'war' => 'වොරෙය්',
 				'wbp' => 'වොපිරි',
 				'wo' => 'වොලොෆ්',
 				'wuu' => 'වූ චයිනිස්',
 				'xal' => 'කල්මික්',
 				'xh' => 'ශෝසා',
 				'xog' => 'සොගා',
 				'yav' => 'යන්ග්බෙන්',
 				'ybb' => 'යෙම්බා',
 				'yi' => 'යිඩිශ්',
 				'yo' => 'යොරූබා',
 				'yue' => 'කැන්ටොනීස්',
 				'zgh' => 'සම්මත මොරොක්කෝ ටමසිග්ත්',
 				'zh' => 'චීන',
 				'zh_Hans' => 'සරල චීන',
 				'zh_Hant' => 'සාම්ප්‍රදායික චීන',
 				'zu' => 'සුලු',
 				'zun' => 'සුනි',
 				'zxx' => 'වාග් විද්‍යා අන්තර්ගතයක් නැත',
 				'zza' => 'සාසා',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'අරාබි',
 			'Armn' => 'ආර්මේනියානු',
 			'Beng' => 'බෙංගාලි',
 			'Bopo' => 'බොපොමොෆෝ',
 			'Brai' => 'බ්‍රේල්',
 			'Cyrl' => 'සිරිලික්',
 			'Deva' => 'දේවනාගරී',
 			'Ethi' => 'ඉතියෝපියානු',
 			'Geor' => 'ජෝර්ජියානු',
 			'Grek' => 'ග්‍රීක',
 			'Gujr' => 'ගුජරාටි',
 			'Guru' => 'ගුර්මුඛි',
 			'Hanb' => 'හැන්ඩ්බ්',
 			'Hang' => 'හැන්ගුල්',
 			'Hani' => 'හන්',
 			'Hans' => 'සුළුකළ',
 			'Hans@alt=stand-alone' => 'සුළුකළ හෑන්',
 			'Hant' => 'සාම්ප්‍රදායික',
 			'Hant@alt=stand-alone' => 'සම්ප්‍රදායික හෑන්',
 			'Hebr' => 'හීබෲ',
 			'Hira' => 'හිරඟනා',
 			'Hrkt' => 'ජෑපනීස් සිලබරීස්',
 			'Jamo' => 'ජාමො',
 			'Jpan' => 'ජපන්',
 			'Kana' => 'කතකනා',
 			'Khmr' => 'කමර්',
 			'Knda' => 'කණ්ණඩ',
 			'Kore' => 'කොරියානු',
 			'Laoo' => 'ලාඕ',
 			'Latn' => 'ලතින්',
 			'Mlym' => 'මලයාලම්',
 			'Mong' => 'මොන්ගෝලියානු',
 			'Mymr' => 'මියන්මාර',
 			'Orya' => 'ඔරියා',
 			'Sinh' => 'සිංහල',
 			'Taml' => 'දෙමළ',
 			'Telu' => 'තෙළිඟු',
 			'Thaa' => 'තාන',
 			'Thai' => 'තායි',
 			'Tibt' => 'ටි‍බෙට්',
 			'Zmth' => 'ගණිතමය සංකේත',
 			'Zsye' => 'ඉමොජි',
 			'Zsym' => 'සංකේත',
 			'Zxxx' => 'අලිඛිත',
 			'Zyyy' => 'පොදු',
 			'Zzzz' => 'නොදත් අක්ෂර මාලාව',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ලෝකය',
 			'002' => 'අප්‍රිකාව',
 			'003' => 'උතුරු ඇමෙරිකාව',
 			'005' => 'දකුණු ඇමෙරිකාව',
 			'009' => 'ඕෂනියාව',
 			'011' => 'බටහිරදිග අප්‍රිකාව',
 			'013' => 'මධ්‍යම ඇමෙරිකාව',
 			'014' => 'පෙරදිග අප්‍රිකාව',
 			'015' => 'උතුරුදිග අප්‍රිකාව',
 			'017' => 'මධ්‍යම අප්‍රිකාව',
 			'018' => 'දකුණුදිග අප්‍රිකාව',
 			'019' => 'ඇමරිකාව',
 			'021' => 'උතුරුදිග ඇමෙරිකාව',
 			'029' => 'කැරීබියන්',
 			'030' => 'නැගෙනහිර ආසියාව',
 			'034' => 'දකුණු ආසියාව',
 			'035' => 'අග්නිදිග ආසියාව',
 			'039' => 'දකුණුදිග යුරෝපය',
 			'053' => 'ඕස්ට්‍රලේෂියාව',
 			'054' => 'මෙලනීසියාව',
 			'057' => 'මයික්‍රෝනීසියානු කළාපය',
 			'061' => 'පොලිනීසියාව',
 			'142' => 'ආසියාව',
 			'143' => 'මධ්‍යම ආසියාව',
 			'145' => 'බටහිර ආසියාව',
 			'150' => 'යුරෝපය',
 			'151' => 'නැගෙනහිර යුරෝපය',
 			'154' => 'උතුරු යුරෝපය',
 			'155' => 'බටහිර යුරෝපය',
 			'202' => 'උප-සහරානු අප්‍රිකාව',
 			'419' => 'ලතින් ඇමෙරිකාව',
 			'AC' => 'ඇසෙන්ෂන් දිවයින',
 			'AD' => 'ඇන්ඩෝරාව',
 			'AE' => 'එක්සත් අරාබි එමිර් රාජ්‍යය',
 			'AF' => 'ඇෆ්ගනිස්ථානය',
 			'AG' => 'ඇන්ටිගුවා සහ බාබියුඩාව',
 			'AI' => 'ඇන්ගුයිලාව',
 			'AL' => 'ඇල්බේනියාව',
 			'AM' => 'ආර්මේනියාව',
 			'AO' => 'ඇන්ගෝලාව',
 			'AQ' => 'ඇන්ටාක්ටිකාව',
 			'AR' => 'ආර්ජෙන්ටිනාව',
 			'AS' => 'ඇමරිකානු සැමෝවා',
 			'AT' => 'ඔස්ට්‍රියාව',
 			'AU' => 'ඕස්ට්‍රේලියාව',
 			'AW' => 'අරූබා',
 			'AX' => 'ඕලන්ඩ් දූපත්',
 			'AZ' => 'අසර්බයිජානය',
 			'BA' => 'බොස්නියාව සහ හර්සගොවීනාව',
 			'BB' => 'බාබඩෝස්',
 			'BD' => 'බංග්ලාදේශය',
 			'BE' => 'බෙල්ජියම',
 			'BF' => 'බර්කිනා ෆාසෝ',
 			'BG' => 'බල්ගේරියාව',
 			'BH' => 'බහරේන්',
 			'BI' => 'බුරුන්දි',
 			'BJ' => 'බෙනින්',
 			'BL' => 'ශාන්ත බර්තලෙමි',
 			'BM' => 'බර්මියුඩා',
 			'BN' => 'බෲනායි',
 			'BO' => 'බොලීවියාව',
 			'BQ' => 'කැරිබියානු නෙදර්ලන්තය',
 			'BR' => 'බ්‍රසීලය',
 			'BS' => 'බහමාස්',
 			'BT' => 'භූතානය',
 			'BV' => 'බුවට් දුපත්',
 			'BW' => 'බොට්ස්වානා',
 			'BY' => 'බෙලරුස්',
 			'BZ' => 'බෙලීස්',
 			'CA' => 'කැනඩාව',
 			'CC' => 'කොකෝස් දූපත්',
 			'CD' => 'කොංගො - කින්ශාසා',
 			'CD@alt=variant' => 'කොංගෝව',
 			'CF' => 'මධ්‍යම අප්‍රිකානු ජනරජය',
 			'CG' => 'කොංගො - බ්‍රසාවිල්',
 			'CG@alt=variant' => 'කොංගෝ (ජනරජය)',
 			'CH' => 'ස්විස්ටර්ලන්තය',
 			'CI' => 'කෝට් දි අයිවරි',
 			'CI@alt=variant' => 'අයිවරි කෝස්ට්',
 			'CK' => 'කුක් දූපත්',
 			'CL' => 'චිලී',
 			'CM' => 'කැමරූන්',
 			'CN' => 'චීනය',
 			'CO' => 'කොළොම්බියාව',
 			'CP' => 'ක්ලීපර්ටන් දූපත',
 			'CR' => 'කොස්ටරිකාව',
 			'CU' => 'කියුබාව',
 			'CV' => 'කේප් වර්ඩ්',
 			'CW' => 'කුරකාවෝ',
 			'CX' => 'ක්‍රිස්මස් දූපත',
 			'CY' => 'සයිප්‍රසය',
 			'CZ' => 'චෙචියාව',
 			'CZ@alt=variant' => 'චෙක් ජනරජය',
 			'DE' => 'ජර්මනිය',
 			'DG' => 'දියාගෝ ගාර්සියා',
 			'DJ' => 'ජිබුටි',
 			'DK' => 'ඩෙන්මාර්කය',
 			'DM' => 'ඩොමිනිකාව',
 			'DO' => 'ඩොමිනිකා ජනරජය',
 			'DZ' => 'ඇල්ජීරියාව',
 			'EA' => 'සෙයුටා සහ මෙලිල්ලා',
 			'EC' => 'ඉක්වදෝරය',
 			'EE' => 'එස්තෝනියාව',
 			'EG' => 'ඊජිප්තුව',
 			'EH' => 'බටහිර සහරාව',
 			'ER' => 'එරිත්‍රියාව',
 			'ES' => 'ස්පාඤ්ඤය',
 			'ET' => 'ඉතියෝපියාව',
 			'EU' => 'යුරෝපා සංගමය',
 			'EZ' => 'යුරෝ කලාපය',
 			'FI' => 'ෆින්ලන්තය',
 			'FJ' => 'ෆීජී',
 			'FK' => 'ෆෝක්ලන්ත දූපත්',
 			'FK@alt=variant' => 'ෆෝක්ලන්ත දූපත් (අයිලස් මල්වියනාස්)',
 			'FM' => 'මයික්‍රොනීසියාව',
 			'FO' => 'ෆැරෝ දූපත්',
 			'FR' => 'ප්‍රංශය',
 			'GA' => 'ගැබොන්',
 			'GB' => 'එක්සත් රාජධානිය',
 			'GB@alt=short' => 'එ.රා',
 			'GD' => 'ග්‍රැනඩාව',
 			'GE' => 'ජෝර්ජියාව',
 			'GF' => 'ප්‍රංශ ගයනාව',
 			'GG' => 'ගර්න්සිය',
 			'GH' => 'ඝානාව',
 			'GI' => 'ජිබ්‍රෝල්ටාව',
 			'GL' => 'ග්‍රීන්ලන්තය',
 			'GM' => 'ගැම්බියාව',
 			'GN' => 'ගිණියාව',
 			'GP' => 'ග්වෝඩලෝප්',
 			'GQ' => 'සමක ගිනියාව',
 			'GR' => 'ග්‍රීසිය',
 			'GS' => 'දකුණු ජෝර්ජියාව සහ දකුණු සැන්ඩ්විච් දූපත්',
 			'GT' => 'ගෝතමාලාව',
 			'GU' => 'ගුවාම්',
 			'GW' => 'ගිනි බිසව්',
 			'GY' => 'ගයනාව',
 			'HK' => 'හොංකොං චීන විශේෂ පරිපාලන කලාපය',
 			'HK@alt=short' => 'හොංකොං',
 			'HM' => 'හර්ඩ් දූපත සහ මැක්ඩොනල්ඩ් දූපත්',
 			'HN' => 'හොන්ඩුරාස්',
 			'HR' => 'ක්‍රොඒෂියාව',
 			'HT' => 'හයිටි',
 			'HU' => 'හන්ගේරියාව',
 			'IC' => 'කැනරි සූපත්',
 			'ID' => 'ඉන්දුනීසියාව',
 			'IE' => 'අයර්ලන්තය',
 			'IL' => 'ඊශ්‍රායලය',
 			'IM' => 'අයිල් ඔෆ් මෑන්',
 			'IN' => 'ඉන්දියාව',
 			'IO' => 'බ්‍රිතාන්‍ය ඉන්දීය සාගර බල ප්‍රදේශය',
 			'IQ' => 'ඉරාකය',
 			'IR' => 'ඉරානය',
 			'IS' => 'අයිස්ලන්තය',
 			'IT' => 'ඉතාලිය',
 			'JE' => 'ජර්සි',
 			'JM' => 'ජැමෙයිකාව',
 			'JO' => 'ජෝර්දානය',
 			'JP' => 'ජපානය',
 			'KE' => 'කෙන්යාව',
 			'KG' => 'කිර්ගිස්තානය',
 			'KH' => 'කාම්බෝජය',
 			'KI' => 'කිරිබති',
 			'KM' => 'කොමොරෝස්',
 			'KN' => 'ශාන්ත කිට්ස් සහ නේවිස්',
 			'KP' => 'උතුරු කොරියාව',
 			'KR' => 'දකුණු කොරියාව',
 			'KW' => 'කුවේටය',
 			'KY' => 'කේමන් දූපත්',
 			'KZ' => 'කසකස්තානය',
 			'LA' => 'ලාඕසය',
 			'LB' => 'ලෙබනනය',
 			'LC' => 'ශාන්ත ලුසියා',
 			'LI' => 'ලික්ටන්ස්ටයින්',
 			'LK' => 'ශ්‍රී ලංකාව',
 			'LR' => 'ලයිබීරියාව',
 			'LS' => 'ලෙසතෝ',
 			'LT' => 'ලිතුවේනියාව',
 			'LU' => 'ලක්ශම්බර්ග්',
 			'LV' => 'ලැට්වියාව',
 			'LY' => 'ලිබියාව',
 			'MA' => 'මොරොක්කෝව',
 			'MC' => 'මොනාකෝව',
 			'MD' => 'මොල්ඩෝවාව',
 			'ME' => 'මොන්ටෙනීග්‍රෝ',
 			'MF' => 'ශාන්ත මාර්ටින්',
 			'MG' => 'මැඩගස්කරය',
 			'MH' => 'මාෂල් දූපත්',
 			'MK' => 'මැසිඩෝනියාව',
 			'MK@alt=variant' => 'මැසිඩෝනියාව (FYROM)',
 			'ML' => 'මාලි',
 			'MM' => 'මියන්මාරය (බුරුමය)',
 			'MN' => 'මොන්ගෝලියාව',
 			'MO' => 'මකාවු චීන විශේෂ පරිපාලන කලාපය',
 			'MO@alt=short' => 'මකාවු',
 			'MP' => 'උතුරු මරියානා දූපත්',
 			'MQ' => 'මර්ටිනික්',
 			'MR' => 'මොරිටේනියාව',
 			'MS' => 'මොන්සෙරාට්',
 			'MT' => 'මෝල්ටාව',
 			'MU' => 'මුරුසිය',
 			'MV' => 'මාල දිවයින',
 			'MW' => 'මලාවි',
 			'MX' => 'මෙක්සිකෝව',
 			'MY' => 'මැලේසියාව',
 			'MZ' => 'මොසැම්බික්',
 			'NA' => 'නැමීබියාව',
 			'NC' => 'නව කැලිඩෝනියාව',
 			'NE' => 'නයිජර්',
 			'NF' => 'නෝෆෝක් දූපත',
 			'NG' => 'නයිජීරියාව',
 			'NI' => 'නිකරගුවාව',
 			'NL' => 'නෙදර්ලන්තය',
 			'NO' => 'නෝර්වේ',
 			'NP' => 'නේපාලය',
 			'NR' => 'නාවුරු',
 			'NU' => 'නියූ',
 			'NZ' => 'නවසීලන්තය',
 			'OM' => 'ඕමානය',
 			'PA' => 'පැනමාව',
 			'PE' => 'පේරු',
 			'PF' => 'ප්‍රංශ පොලිනීසියාව',
 			'PG' => 'පැපුවා නිව් ගිනියාව',
 			'PH' => 'පිලිපීනය',
 			'PK' => 'පාකිස්තානය',
 			'PL' => 'පෝලන්තය',
 			'PM' => 'ශාන්ත පියරේ සහ මැකෝලන්',
 			'PN' => 'පිට්කෙය්න් දූපත්',
 			'PR' => 'පුවර්ටෝ රිකෝ',
 			'PS' => 'පලස්තීන රාජ්‍යය',
 			'PS@alt=short' => 'පලස්තීනය',
 			'PT' => 'පෘතුගාලය',
 			'PW' => 'පලාවු',
 			'PY' => 'පැරගුවේ',
 			'QA' => 'කටාර්',
 			'QO' => 'ඈත ඕෂනියාව',
 			'RE' => 'රීයුනියන්',
 			'RO' => 'රුමේනියාව',
 			'RS' => 'සර්බියාව',
 			'RU' => 'රුසියාව',
 			'RW' => 'රුවන්ඩාව',
 			'SA' => 'සෞදි අරාබිය',
 			'SB' => 'සොලමන් දූපත්',
 			'SC' => 'සීශෙල්ස්',
 			'SD' => 'සූඩානය',
 			'SE' => 'ස්වීඩනය',
 			'SG' => 'සිංගප්පූරුව',
 			'SH' => 'ශාන්ත හෙලේනා',
 			'SI' => 'ස්ලෝවේනියාව',
 			'SJ' => 'ස්වෙල්බර්ඩ් සහ ජේන් මයේන්',
 			'SK' => 'ස්ලෝවැකියාව',
 			'SL' => 'සියරාලියෝන්',
 			'SM' => 'සැන් මැරිනෝ',
 			'SN' => 'සෙනගාලය',
 			'SO' => 'සෝමාලියාව',
 			'SR' => 'සුරිනාමය',
 			'SS' => 'දකුණු සුඩානය',
 			'ST' => 'සාඕ තෝම් සහ ප්‍රින්සිප්',
 			'SV' => 'එල් සැල්වදෝරය',
 			'SX' => 'ශාන්ත මාර්ටෙන්',
 			'SY' => 'සිරියාව',
 			'SZ' => 'ස්වාසිලන්තය',
 			'TA' => 'ට්‍රිස්ටන් ද කුන්හා',
 			'TC' => 'ටර්ක්ස් සහ කයිකොස් දූපත්',
 			'TD' => 'චැච්',
 			'TF' => 'දකුණු ප්‍රංශ දූපත් සමූහය',
 			'TG' => 'ටොගෝ',
 			'TH' => 'තායිලන්තය',
 			'TJ' => 'ටජිකිස්තානය',
 			'TK' => 'ටොකලාවු',
 			'TL' => 'ටිමෝර් - ලෙස්ත්',
 			'TL@alt=variant' => 'නැගෙනහිර ටිමෝරය',
 			'TM' => 'ටර්ක්මෙනිස්ථානය',
 			'TN' => 'ටියුනීසියාව',
 			'TO' => 'ටොංගා',
 			'TR' => 'තුර්කිය',
 			'TT' => 'ට්‍රිනිඩෑඩ් සහ ටොබැගෝ',
 			'TV' => 'ටුවාලූ',
 			'TW' => 'තායිවානය',
 			'TZ' => 'ටැන්සානියාව',
 			'UA' => 'යුක්රේනය',
 			'UG' => 'උගන්ඩාව',
 			'UM' => 'එක්සත් ජනපද ඈත දූපත්',
 			'UN' => 'එක්සත් ජාතීන්',
 			'UN@alt=short' => 'එක්සත් ජාතීන්',
 			'US' => 'එක්සත් ජනපදය',
 			'US@alt=short' => 'එ.ජ',
 			'UY' => 'උරුගුවේ',
 			'UZ' => 'උස්බෙකිස්ථානය',
 			'VA' => 'වතිකානු නගරය',
 			'VC' => 'ශාන්ත වින්සන්ට් සහ ග්‍රෙනඩින්ස්',
 			'VE' => 'වෙනිසියුලාව',
 			'VG' => 'බ්‍රිතාන්‍ය වර්ජින් දූපත්',
 			'VI' => 'ඇමරිකානු වර්ජින් දූපත්',
 			'VN' => 'වියට්නාමය',
 			'VU' => 'වනුවාටු',
 			'WF' => 'වැලිස් සහ ෆුටුනා',
 			'WS' => 'සැමෝවා',
 			'XK' => 'කොසෝවෝ',
 			'YE' => 'යේමනය',
 			'YT' => 'මයෝට්',
 			'ZA' => 'දකුණු අප්‍රිකාව',
 			'ZM' => 'සැම්බියාව',
 			'ZW' => 'සිම්බාබ්වේ',
 			'ZZ' => 'හඳුනා නොගත් කළාපය',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'දින දර්ශනය',
 			'cf' => 'මුදල් ආකෘති',
 			'collation' => 'පෙළගැස්ම',
 			'currency' => 'විනිමය',
 			'hc' => 'පැය චක්‍රය',
 			'lb' => 'පේළි කඩන විලාසය',
 			'ms' => 'මිනුම් ක්‍රමය',
 			'numbers' => 'ඉලක්කම්',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{බොදු දින දර්ශනය},
 				'chinese' => q{චීන දින දර්ශනය},
 				'dangi' => q{ඩැන්ගී දින දර්ශනය},
 				'ethiopic' => q{ඉතියෝපියානු දින දර්ශනය},
 				'gregorian' => q{ග්‍රෙගරියානු දින දර්ශනය},
 				'hebrew' => q{හීබෲ දින දර්ශනය},
 				'islamic' => q{ඉස්ලාමීය දින දර්ශනය},
 				'iso8601' => q{අඑස්ඔ-8601 දින දර්ශනය},
 				'japanese' => q{ජපන් දින දර්ශනය},
 				'persian' => q{පර්සියානු දින දර්ශනය},
 				'roc' => q{මින්ගා දින දර්ශනය},
 			},
 			'cf' => {
 				'account' => q{ගිණුම්කරණ මුදල් ආකෘති},
 				'standard' => q{සම්මත මුදල් ආකෘති},
 			},
 			'collation' => {
 				'dictionary' => q{ශබ්දකෝෂ පෙළගැස්ම},
 				'ducet' => q{යුනිකේත පෙරනිමි පෙළගැස්ම},
 				'search' => q{සාමාන්‍ය සෙවීම},
 				'standard' => q{සම්මත පෙළගැස්ම},
 			},
 			'hc' => {
 				'h11' => q{පැය 12 ක්‍රමය},
 				'h12' => q{පැය 12 ක්‍රමය},
 				'h23' => q{පැය 24 ක්‍රමය},
 				'h24' => q{පැය 24 ක්‍රමය},
 			},
 			'lb' => {
 				'loose' => q{ලිහිල් කඩන විලාසය},
 				'normal' => q{සාමාන්‍ය පේළි කඩන විලාසය},
 				'strict' => q{තද පේළි කඩන විලාසය},
 			},
 			'ms' => {
 				'metric' => q{මෙට්‍රික් ක්‍රමය},
 				'uksystem' => q{රාජකීය මිනුම් ක්‍රමය},
 				'ussystem' => q{එජ මිනුම් ක්‍රමය},
 			},
 			'numbers' => {
 				'arab' => q{ඉන්දු අරාබි ඉලක්කම්},
 				'arabext' => q{වැඩි කළ ඉන්දු අරාබි ඉලක්කම්},
 				'armn' => q{ඇමරිකානු සංඛ්‍යාංකන},
 				'armnlow' => q{ඇමරිකානු කුඩා සංඛ්‍යාංකන},
 				'beng' => q{බෙංගාලි ඉලක්කම්},
 				'deva' => q{දේවනාගරී ඉලක්කම්},
 				'ethi' => q{ඉතියෝපියානු සංඛ්‍යාංකන},
 				'fullwide' => q{සම්පූර්ණ පළල ඉලක්කම්},
 				'geor' => q{ජෝජියානු සංඛ්‍යාංකන},
 				'grek' => q{ග්‍රීක සංඛ්‍යාංකන},
 				'greklow' => q{ග්‍රීක කුඩා සංඛ්‍යාංකන},
 				'gujr' => q{ගුජරාටි ඉලක්කම්},
 				'guru' => q{ගුර්මුකී ඉලක්කම්},
 				'hanidec' => q{චීන දශමය සංඛ්‍යාංකන},
 				'hans' => q{සුළුකළ චීන සංඛ්‍යාංකන},
 				'hansfin' => q{සුළුකළ චීන මුල්‍යමය සංඛ්‍යාංකන},
 				'hant' => q{සාම්ප්‍රදායික චීන සංඛ්‍යාංකන},
 				'hantfin' => q{සාම්ප්‍රදායික චීන මුල්‍යමය සංඛ්‍යාංකන},
 				'hebr' => q{හීබෲ සංඛ්‍යාංකන},
 				'jpan' => q{ජපාන සංඛ්‍යාංකන},
 				'jpanfin' => q{ජපාන මුල්‍යමය සංඛ්‍යාංකන},
 				'khmr' => q{කමර් ඉලක්කම්},
 				'knda' => q{කන්නඩ ඉලක්කම්},
 				'laoo' => q{ලාඕ ඉලක්කම්},
 				'latn' => q{බටහිර ඉලක්කම්},
 				'mlym' => q{මලයාලම් ඉලක්කම්},
 				'mymr' => q{බුරුම ඉලක්කම්},
 				'orya' => q{ඔරියා ඉලක්කම්},
 				'roman' => q{රෝමානු සංඛ්‍යාංකන},
 				'romanlow' => q{රෝමානු කුඩා සංඛ්‍යාංකන},
 				'taml' => q{සාම්ප්‍රදායික දෙමළ සංඛ්‍යාංකන},
 				'tamldec' => q{දෙමළ ඉලක්කම්},
 				'telu' => q{තෙළිඟු ඉලක්කම්},
 				'thai' => q{තායි ඉලක්කම්},
 				'tibt' => q{ටිබෙට ඉලක්කම්},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{මෙට්රික්},
 			'UK' => q{එංගලන්ත},
 			'US' => q{ඇමරිකානු},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => '{0} භාෂාව: සිංහල',
 			'script' => '{0} අක්ෂර මාලාව: සිංහල',
 			'region' => 'කලාපය: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[​‌‍ ඎ ඏ ඐ ඦ ෳ]},
			index => ['අ', 'ආ', 'ඇ', 'ඈ', 'ඉ', 'ඊ', 'උ', 'ඌ', 'ඍ', 'එ', 'ඒ', 'ඓ', 'ඔ', 'ඕ', 'ඖ', 'ක', 'ඛ', 'ග', 'ඝ', 'ඞ', 'ඟ', 'ච', 'ඡ', 'ජ', 'ඣ', 'ඥ', 'ඤ', 'ට', 'ඨ', 'ඩ', 'ඪ', 'ණ', 'ඬ', 'ත', 'ථ', 'ද', 'ධ', 'න', 'ඳ', 'ප', 'ඵ', 'බ', 'භ', 'ම', 'ඹ', 'ය', 'ර', 'ල', 'ව', 'ශ', 'ෂ', 'ස', 'හ', 'ළ', 'ෆ'],
			main => qr{[අ ආ ඇ ඈ ඉ ඊ උ ඌ ඍ එ ඒ ඓ ඔ ඕ ඖ ං ඃ ක ඛ ග ඝ ඞ ඟ ච ඡ ජ ඣ ඥ ඤ ට ඨ ඩ ඪ ණ ඬ ත ථ ද ධ න ඳ ප ඵ බ භ ම ඹ ය ර ල ව ශ ෂ ස හ ළ ෆ ා ැ ෑ ි ී ු ූ ෘ ෲ ෟ ෙ ේ ෛ ො ෝ ෞ ්]},
			numbers => qr{[\- , . % ‰ + 0 1 2 3 4 5 6 7 8 9]},
			punctuation => qr{[\- ‐ – — , ; \: ! ? . … ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['අ', 'ආ', 'ඇ', 'ඈ', 'ඉ', 'ඊ', 'උ', 'ඌ', 'ඍ', 'එ', 'ඒ', 'ඓ', 'ඔ', 'ඕ', 'ඖ', 'ක', 'ඛ', 'ග', 'ඝ', 'ඞ', 'ඟ', 'ච', 'ඡ', 'ජ', 'ඣ', 'ඥ', 'ඤ', 'ට', 'ඨ', 'ඩ', 'ඪ', 'ණ', 'ඬ', 'ත', 'ථ', 'ද', 'ධ', 'න', 'ඳ', 'ප', 'ඵ', 'බ', 'භ', 'ම', 'ඹ', 'ය', 'ර', 'ල', 'ව', 'ශ', 'ෂ', 'ස', 'හ', 'ළ', 'ෆ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h.mm',
				hms => 'h.mm.ss',
				ms => 'm.ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'' => {
						'name' => q(කාර්ඩිනල් දිශාව),
					},
					'acre' => {
						'name' => q(අක්කර),
						'one' => q(අක්කර {0}),
						'other' => q(අක්කර {0}),
					},
					'acre-foot' => {
						'name' => q(අක්කර-අඩි),
						'one' => q(අක්කර-අඩි {0}),
						'other' => q(අක්කර-අඩි {0}),
					},
					'ampere' => {
						'name' => q(ඇම්පියර),
						'one' => q(ඇම්පියර {0}),
						'other' => q(ඇම්පියර {0}),
					},
					'arc-minute' => {
						'name' => q(මිනිත්තු),
						'one' => q(මිනිත්තු {0}),
						'other' => q(මිනිත්තු {0}),
					},
					'arc-second' => {
						'name' => q(තත්පර),
						'one' => q(තත්පර {0}),
						'other' => q(තත්පර {0}),
					},
					'astronomical-unit' => {
						'name' => q(නක්ෂත්‍ර ඒකක),
						'one' => q(නක්ෂත්‍ර ඒකක {0}),
						'other' => q(නක්ෂත්‍ර ඒකක {0}),
					},
					'atmosphere' => {
						'name' => q(වායුගෝල),
						'one' => q(වායුගෝල {0}),
						'other' => q(වායුගෝල {0}),
					},
					'bit' => {
						'name' => q(බීට්),
						'one' => q(බීට් {0}),
						'other' => q(බීට් {0}),
					},
					'byte' => {
						'name' => q(බයිට්),
						'one' => q(බයිට් {0}),
						'other' => q(බයිට් {0}),
					},
					'calorie' => {
						'name' => q(කැලරි),
						'one' => q(කැලරි {0}),
						'other' => q(කැලරි {0}),
					},
					'carat' => {
						'name' => q(කැරට්),
						'one' => q(කැරට් {0}),
						'other' => q(කැරට් {0}),
					},
					'celsius' => {
						'name' => q(සෙල්සියස් අංශක),
						'one' => q(සෙල්සියස් අංශක {0}),
						'other' => q(සෙල්සියස් අංශක {0}),
					},
					'centiliter' => {
						'name' => q(සෙන්ටිලීටරය),
						'one' => q(සෙන්ටිලීටරය {0}),
						'other' => q(සෙන්ටිලීටරය {0}),
					},
					'centimeter' => {
						'name' => q(සෙන්ටිමීටර්),
						'one' => q(සෙන්ටිමීටර් {0}),
						'other' => q(සෙන්ටිමීටර් {0}),
						'per' => q(සෙන්ටිමීටරයට {0}),
					},
					'century' => {
						'name' => q(සියවස),
						'one' => q(සියවස් {0}),
						'other' => q(සියවස් {0}),
					},
					'coordinate' => {
						'east' => q({0}නැ),
						'north' => q({0}උ),
						'south' => q({0}ද),
						'west' => q({0}බ),
					},
					'cubic-centimeter' => {
						'name' => q(ඝන සෙන්ටිමීටරය),
						'one' => q(ඝන සෙන්ටිමීටරය {0}),
						'other' => q(ඝන සෙන්ටිමීටරය {0}),
						'per' => q(ඝන සෙන්ටිමීටරයට {0}),
					},
					'cubic-foot' => {
						'name' => q(ඝන අඩි),
						'one' => q(ඝන අඩි {0}),
						'other' => q(ඝන අඩි {0}),
					},
					'cubic-inch' => {
						'name' => q(ඝන අඟල්),
						'one' => q(ඝන අඟල් {0}),
						'other' => q(ඝන අඟල් {0}),
					},
					'cubic-kilometer' => {
						'name' => q(ඝන කිලෝමීටර්),
						'one' => q(ඝන කිලෝමීටර් {0}),
						'other' => q(ඝන කිලෝමීටර් {0}),
					},
					'cubic-meter' => {
						'name' => q(ඝන මීටර),
						'one' => q(ඝන මීටර {0}),
						'other' => q(ඝන මීටර {0}),
						'per' => q(ඝන මීටරට {0}),
					},
					'cubic-mile' => {
						'name' => q(ඝන සැතපුම්),
						'one' => q(ඝන සැතපුම් {0}),
						'other' => q(ඝන සැතපුම් {0}),
					},
					'cubic-yard' => {
						'name' => q(ඝන යාර),
						'one' => q(ඝන යාර {0}),
						'other' => q(ඝන යාර {0}),
					},
					'cup' => {
						'name' => q(කෝප්ප),
						'one' => q(කෝප්ප {0}),
						'other' => q(කෝප්ප {0}),
					},
					'cup-metric' => {
						'name' => q(මෙට්‍රික් කෝප්ප),
						'one' => q(මෙට්‍රික් කෝප්ප {0}),
						'other' => q(මෙට්‍රික් කෝප්ප {0}),
					},
					'day' => {
						'name' => q(දින),
						'one' => q(දින {0}),
						'other' => q(දින {0}),
						'per' => q(දිනයට {0}),
					},
					'deciliter' => {
						'name' => q(ඩෙසිලීටර),
						'one' => q(ඩෙසිලීටරය {0}),
						'other' => q(ඩෙසිලීටරය {0}),
					},
					'decimeter' => {
						'name' => q(ඩෙසිමීටර),
						'one' => q(ඩෙසිමීටර {0}),
						'other' => q(ඩෙසිමීටර {0}),
					},
					'degree' => {
						'name' => q(අංශක),
						'one' => q(අංශක {0}),
						'other' => q(අංශක {0}),
					},
					'fahrenheit' => {
						'name' => q(ෆැරන්හයිට් අංශක),
						'one' => q(ෆැරන්හයිට් අංශක {0}),
						'other' => q(ෆැරන්හයිට් අංශක {0}),
					},
					'fluid-ounce' => {
						'name' => q(ද්‍රව අවුන්ස),
						'one' => q(ද්‍රව අවුන්ස {0}),
						'other' => q(ද්‍රව අවුන්ස {0}),
					},
					'foodcalorie' => {
						'name' => q(කැලරි),
						'one' => q(කැලරි {0}),
						'other' => q(කැලරි {0}),
					},
					'foot' => {
						'name' => q(අඩි),
						'one' => q(අඩි {0}),
						'other' => q(අඩි {0}),
						'per' => q(අඩියට {0}),
					},
					'g-force' => {
						'name' => q(g-බලය),
						'one' => q(g-බලය {0}),
						'other' => q(g-බලය {0}),
					},
					'gallon' => {
						'name' => q(ගැලුම්),
						'one' => q(ගැලුම් {0}),
						'other' => q(ගැලුම් {0}),
						'per' => q(ගැලුමට {0}),
					},
					'gallon-imperial' => {
						'name' => q(ඉම්පීරියල් ගැලුම්),
						'one' => q({0} ඉම්පී. ගැලුම),
						'other' => q({0} ඉම්පී. ගැලුම්),
						'per' => q(ඉම්පීරියල් ගැලුමකට {0}),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ගිගාබීට්),
						'one' => q(ගිගාබීට් {0}),
						'other' => q(ගිගාබීට් {0}),
					},
					'gigabyte' => {
						'name' => q(ගිගාබයිට්‌),
						'one' => q(ගිගාබයිට්‌ {0}),
						'other' => q(ගිගාබයිට්‌ {0}),
					},
					'gigahertz' => {
						'name' => q(ගිගාහට්ස්),
						'one' => q(ගිගාහට්ස් {0}),
						'other' => q(ගිගාහට්ස් {0}),
					},
					'gigawatt' => {
						'name' => q(ගිගා වොට්),
						'one' => q(ගිගා වොට් {0}),
						'other' => q(ගිගා වොට් {0}),
					},
					'gram' => {
						'name' => q(ග්‍රෑම්),
						'one' => q(ග්‍රෑම් {0}),
						'other' => q(ග්‍රෑම් {0}),
						'per' => q(ග්‍රෑමයට {0}),
					},
					'hectare' => {
						'name' => q(හෙක්ටයාර්),
						'one' => q(හෙක්ටයාර් {0}),
						'other' => q(හෙක්ටයාර් {0}),
					},
					'hectoliter' => {
						'name' => q(භෙක්ටොලීටර්),
						'one' => q(භෙක්ටොලීටර් {0}),
						'other' => q(භෙක්ටොලීටර් {0}),
					},
					'hectopascal' => {
						'name' => q(හෙක්ටොපැස්කල්),
						'one' => q(හෙක්ටොපැස්කල් {0}),
						'other' => q(හෙක්ටොපැස්කල් {0}),
					},
					'hertz' => {
						'name' => q(හට්ස්),
						'one' => q(හට්ස් {0}),
						'other' => q(හට්ස් {0}),
					},
					'horsepower' => {
						'name' => q(අශ්වබල),
						'one' => q(අශ්වබල {0}),
						'other' => q(අශ්වබල {0}),
					},
					'hour' => {
						'name' => q(පැය),
						'one' => q(පැය {0}),
						'other' => q(පැය {0}),
						'per' => q(පැයට {0}),
					},
					'inch' => {
						'name' => q(අඟල්),
						'one' => q(අඟල් {0}),
						'other' => q(අඟල් {0}),
						'per' => q(අඟලයට {0}),
					},
					'inch-hg' => {
						'name' => q(රසදිය අඟල්),
						'one' => q(රසදිය අඟල් {0}),
						'other' => q(රසදිය අඟල් {0}),
					},
					'joule' => {
						'name' => q(ජුල්),
						'one' => q(ජුල් {0}),
						'other' => q(ජුල් {0}),
					},
					'karat' => {
						'name' => q(ක්‍රාත්),
						'one' => q(ක්‍රාත් {0}),
						'other' => q(ක්‍රාත් {0}),
					},
					'kelvin' => {
						'name' => q(කෙල්වින් අංශක),
						'one' => q(කෙල්වින් අංශක {0}),
						'other' => q(කෙල්වින් අංශක {0}),
					},
					'kilobit' => {
						'name' => q(කිලෝබිට්),
						'one' => q(කිලෝබිට් {0}),
						'other' => q(කිලෝබිට් {0}),
					},
					'kilobyte' => {
						'name' => q(කිලෝබයිට්),
						'one' => q(කිලෝබයිට් {0}),
						'other' => q(කිලෝබයිට් {0}),
					},
					'kilocalorie' => {
						'name' => q(කිලෝ කැලරි),
						'one' => q(කිලෝ කැලරි {0}),
						'other' => q(කිලෝ කැලරි {0}),
					},
					'kilogram' => {
						'name' => q(කිලෝග්‍රෑම්),
						'one' => q(කිලෝග්‍රෑම් {0}),
						'other' => q(කිලෝග්‍රෑම් {0}),
						'per' => q(කිලෝග්‍රෑමයට {0}),
					},
					'kilohertz' => {
						'name' => q(කිලෝහට්ස්),
						'one' => q(කිලෝහට්ස් {0}),
						'other' => q(කිලෝහට්ස් {0}),
					},
					'kilojoule' => {
						'name' => q(කිලෝ ජුල්),
						'one' => q(කිලෝ ජුල් {0}),
						'other' => q(කිලෝ ජුල් {0}),
					},
					'kilometer' => {
						'name' => q(කිලෝමීටර්),
						'one' => q(කිලෝමීටර් {0}),
						'other' => q(කිලෝමීටර් {0}),
						'per' => q(කිලෝමීටරයට {0}),
					},
					'kilometer-per-hour' => {
						'name' => q(පැයට කිලෝමීටර්),
						'one' => q(පැයට කිලෝමීටර් {0}),
						'other' => q(පැයට කිලෝමීටර් {0}),
					},
					'kilowatt' => {
						'name' => q(කිලෝ වොට්),
						'one' => q(කිලෝ වොට් {0}),
						'other' => q(කිලෝ වොට් {0}),
					},
					'kilowatt-hour' => {
						'name' => q(කිලෝවොට්-පැය),
						'one' => q(කිලෝවොට්-පැය {0}),
						'other' => q(කිලෝවොට්-පැය {0}),
					},
					'knot' => {
						'name' => q(නාවික සැතපුම්),
						'one' => q(නාවික සැතපුම් {0}),
						'other' => q(නාවික සැතපුම් {0}),
					},
					'light-year' => {
						'name' => q(ආලෝක වර්ෂ),
						'one' => q(ආලෝක වර්ෂ {0}),
						'other' => q(ආලෝක වර්ෂ {0}),
					},
					'liter' => {
						'name' => q(ලීටර්),
						'one' => q(ලීටර් {0}),
						'other' => q(ලීටර් {0}),
						'per' => q(ලීටරයට {0}),
					},
					'liter-per-100kilometers' => {
						'name' => q(කිලෝ මීටර 100 ට ලීටර),
						'one' => q(කිලෝ මීටර 100 ට ලීටර {0}),
						'other' => q(කිලෝ මීටර 100 ට ලීටර {0}),
					},
					'liter-per-kilometer' => {
						'name' => q(කිලෝ මීටරයට ලීටරය),
						'one' => q(කිලෝ මීටරයට ලීටරය {0}),
						'other' => q(කිලෝ මීටරයට ලීටරය {0}),
					},
					'lux' => {
						'name' => q(ලක්ස්),
						'one' => q(ලක්ස් {0}),
						'other' => q(ලක්ස් {0}),
					},
					'megabit' => {
						'name' => q(මෙගාබීට්),
						'one' => q(මෙගාබීට් {0}),
						'other' => q(මෙගාබීට් {0}),
					},
					'megabyte' => {
						'name' => q(මෙගාබයිට්),
						'one' => q(මෙගාබයිට් {0}),
						'other' => q(මෙගාබයිට් {0}),
					},
					'megahertz' => {
						'name' => q(මෙගාහර්ට්ස්),
						'one' => q(මෙගාහර්ට්ස් {0}),
						'other' => q(මෙගාහර්ට්ස් {0}),
					},
					'megaliter' => {
						'name' => q(මෙගාලීටර්),
						'one' => q(මෙගාලීටර් {0}),
						'other' => q(මෙගාලීටර් {0}),
					},
					'megawatt' => {
						'name' => q(මෙගාවොට්),
						'one' => q(මෙගාවොට් {0}),
						'other' => q(මෙගාවොට් {0}),
					},
					'meter' => {
						'name' => q(මීටර්),
						'one' => q(මීටර් {0}),
						'other' => q(මීටර් {0}),
						'per' => q(මීටරයට {0}),
					},
					'meter-per-second' => {
						'name' => q(තත්පරයට මීටර්),
						'one' => q(තත්පරයට මීටර් {0}),
						'other' => q(තත්පරයට මීටර් {0}),
					},
					'meter-per-second-squared' => {
						'name' => q(තත්පර වර්ගයට මීටර),
						'one' => q(තත්පර වර්ගයට මීටර {0}),
						'other' => q(තත්පර වර්ගයට මීටර {0}),
					},
					'metric-ton' => {
						'name' => q(මෙට්ට්‍රික් ටොන්),
						'one' => q(මෙට්ට්‍රික් ටොන් {0}),
						'other' => q(මෙට්ට්‍රික් ටොන් {0}),
					},
					'microgram' => {
						'name' => q(මයික්‍රෝ ග්‍රෑම්),
						'one' => q(මයික්‍රෝ ග්‍රෑම් {0}),
						'other' => q(මයික්‍රෝ ග්‍රෑම් {0}),
					},
					'micrometer' => {
						'name' => q(මයික්‍රෝමීටර),
						'one' => q(මයික්‍රෝමීටර {0}),
						'other' => q(මයික්‍රෝමීටර {0}),
					},
					'microsecond' => {
						'name' => q(මයික්‍රොතත්පර),
						'one' => q(මයික්‍රොතත්පර {0}),
						'other' => q(මයික්‍රොතත්පර {0}),
					},
					'mile' => {
						'name' => q(සැතපුම්),
						'one' => q(සැතපුම් {0}),
						'other' => q(සැතපුම් {0}),
					},
					'mile-per-gallon' => {
						'name' => q(ගැලුමට හැතැප්ම),
						'one' => q(ගැලුමට හැතැප්ම {0}),
						'other' => q(ගැලුමට හැතැප්ම {0}),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(ඉම්පීරියල් ගැලුමට හැතැප්ම),
						'one' => q({0} ඉම්පීරියල් ගැලුමට හැතැප්ම),
						'other' => q({0} ඉම්පීරියල් ගැලුමට හැතැප්ම),
					},
					'mile-per-hour' => {
						'name' => q(පැයට සැතපුම්),
						'one' => q(පැයට සැතපුම් {0}),
						'other' => q(පැයට සැතපුම් {0}),
					},
					'mile-scandinavian' => {
						'name' => q(ස්කැන්ඩිනේවියානු සැතපුම්),
						'one' => q(ස්කැන්ඩිනේවියානු සැතපුම් {0}),
						'other' => q(ස්කැන්ඩිනේවියානු සැතපුම් {0}),
					},
					'milliampere' => {
						'name' => q(මිලි ඇම්පියර),
						'one' => q(මිලි ඇම්පියර {0}),
						'other' => q(මිලි ඇම්පියරය {0}),
					},
					'millibar' => {
						'name' => q(මිලිබාර්),
						'one' => q(මිලිබාර් {0}),
						'other' => q(මිලිබාර් {0}),
					},
					'milligram' => {
						'name' => q(මිලිග්‍රෑම්),
						'one' => q(මිලිග්‍රෑම් {0}),
						'other' => q(මිලිග්‍රෑම් {0}),
					},
					'milligram-per-deciliter' => {
						'name' => q(ඩෙසිලීටරයකට මිලිග්‍රෑම්),
						'one' => q(ඩෙසිලීටරයකට මිලිග්‍රෑම් {0}),
						'other' => q(ඩෙසිලීටරයකට මිලිග්‍රෑම් {0}),
					},
					'milliliter' => {
						'name' => q(මිලිලීටර්),
						'one' => q(මිලිලීටර් {0}),
						'other' => q(මිලිලීටර් {0}),
					},
					'millimeter' => {
						'name' => q(මිලිමීටර්),
						'one' => q(මිලිමීටර් {0}),
						'other' => q(මිලිමීටර් {0}),
					},
					'millimeter-of-mercury' => {
						'name' => q(රසදිය මිලිමීටර),
						'one' => q(රසදිය මිලිමීටර {0}),
						'other' => q(රසදිය මිලිමීටර {0}),
					},
					'millimole-per-liter' => {
						'name' => q(ලීටරයකට මිලිමෝල්),
						'one' => q(ලීටරයකට මිලිමෝල් {0}),
						'other' => q(ලීටරයකට මිලිමෝල් {0}),
					},
					'millisecond' => {
						'name' => q(මිලිතත්පර),
						'one' => q(මිලිතත්පර {0}),
						'other' => q(මිලිතත්පර {0}),
					},
					'milliwatt' => {
						'name' => q(මිලිවොට්),
						'one' => q(මිලිවොට් {0}),
						'other' => q(මිලිවොට් {0}),
					},
					'minute' => {
						'name' => q(මිනිත්තු),
						'one' => q(මිනිත්තු {0}),
						'other' => q(මිනිත්තු {0}),
						'per' => q(මිනිත්තුවට {0}),
					},
					'month' => {
						'name' => q(මාස),
						'one' => q(මාස {0}),
						'other' => q(මාස {0}),
						'per' => q(මාසයට {0}),
					},
					'nanometer' => {
						'name' => q(නැනෝමීටර),
						'one' => q(නැනෝමීටර {0}),
						'other' => q(නැනෝමීටර {0}),
					},
					'nanosecond' => {
						'name' => q(නැනෝතත්පර),
						'one' => q(නැනෝතත්පර {0}),
						'other' => q(නැනෝතත්පර {0}),
					},
					'nautical-mile' => {
						'name' => q(නාවුක සැතපුම්),
						'one' => q(නාවුක සැතපුම් {0}),
						'other' => q(නාවුක සැතපුම් {0}),
					},
					'ohm' => {
						'name' => q(ඕම්),
						'one' => q(ඕම් {0}),
						'other' => q(ඕම් {0}),
					},
					'ounce' => {
						'name' => q(අවුන්ස),
						'one' => q(අවුන්ස {0}),
						'other' => q(අවුන්ස {0}),
						'per' => q(අවුන්සයට {0}),
					},
					'ounce-troy' => {
						'name' => q(ට්‍රෝයි අවුන්ස),
						'one' => q(ට්‍රෝයි අවුන්ස {0}),
						'other' => q(ට්‍රෝයි අවුන්ස {0}),
					},
					'parsec' => {
						'name' => q(පාර්සෙක්),
						'one' => q(පාර්සෙක් {0}),
						'other' => q(පාර්සෙක් {0}),
					},
					'part-per-million' => {
						'name' => q(මිලියනයට කොටස්),
						'one' => q(මිලියනයට කොටස් {0}),
						'other' => q(මිලියනයට කොටස් {0}),
					},
					'per' => {
						'1' => q({1} ට {0} බැගින්),
					},
					'percent' => {
						'name' => q(ප්‍රතිශතය),
						'one' => q(ප්‍රතිශතය {0}),
						'other' => q(ප්‍රතිශතය {0}),
					},
					'permille' => {
						'name' => q(ප්‍රතිසහශ්‍රක),
						'one' => q(ප්‍රතිසහශ්‍රක {0}),
						'other' => q(ප්‍රතිසහශ්‍රක {0}),
					},
					'petabyte' => {
						'name' => q(පෙටාබයිට්),
						'one' => q(පෙටාබයිට් {0}),
						'other' => q(පෙටාබයිට් {0}),
					},
					'picometer' => {
						'name' => q(පිකොමිටර්),
						'one' => q(පිකොමිටර් {0}),
						'other' => q(පිකොමිටර් {0}),
					},
					'pint' => {
						'name' => q(පයින්ට්),
						'one' => q(පයින්ට් {0}),
						'other' => q(පයින්ට් {0}),
					},
					'pint-metric' => {
						'name' => q(මෙට්‍රික් පයින්ට්),
						'one' => q(මෙට්‍රික් පයින්ට් {0}),
						'other' => q(මෙට්‍රික් පයින්ට් {0}),
					},
					'point' => {
						'name' => q(පොයින්ට්),
						'one' => q(පොයින්ට් {0}),
						'other' => q(පොයින්ට් {0}),
					},
					'pound' => {
						'name' => q(රාත්තල්),
						'one' => q(රාත්තල් {0}),
						'other' => q(රාත්තල් {0}),
						'per' => q(රාත්තලට {0}),
					},
					'pound-per-square-inch' => {
						'name' => q(වර්ග අලඟකට රාත්තල්),
						'one' => q(වර්ග අලඟකට රාත්තල් {0}),
						'other' => q(වර්ග අලඟකට රාත්තල් {0}),
					},
					'quart' => {
						'name' => q(ක්වාට්),
						'one' => q(ක්වාට් {0}),
						'other' => q(ක්වාට් {0}),
					},
					'radian' => {
						'name' => q(රේඩියන්),
						'one' => q(රේඩියන් {0}),
						'other' => q(රේඩියන් {0}),
					},
					'revolution' => {
						'name' => q(පරිභ්‍රමණය),
						'one' => q(පරිභ්‍රමණ {0}),
						'other' => q(පරිභ්‍රමණය {0}),
					},
					'second' => {
						'name' => q(තත්පර),
						'one' => q(තත්පර {0}),
						'other' => q(තත්පර {0}),
						'per' => q(තත්පරයට {0}),
					},
					'square-centimeter' => {
						'name' => q(වර්ග සෙන්ටිමීටර),
						'one' => q(වර්ග සෙන්ටිමීටර {0}),
						'other' => q(වර්ග සෙන්ටිමීටර {0}),
						'per' => q(වර්ග සෙන්ටිමීටරයට {0}),
					},
					'square-foot' => {
						'name' => q(වර්ග අඩි),
						'one' => q(වර්ග අඩි {0}),
						'other' => q(වර්ග අඩි {0}),
					},
					'square-inch' => {
						'name' => q(වර්ග අඟල්),
						'one' => q(වර්ග අඟල් {0}),
						'other' => q(වර්ග අඟල් {0}),
						'per' => q(වර්ග අඟලට {0}),
					},
					'square-kilometer' => {
						'name' => q(වර්ග කිලෝමීටර්),
						'one' => q(වර්ග කිලෝමීටර් {0}),
						'other' => q(වර්ග කිලෝමීටර් {0}),
						'per' => q({0} කට වර්ග කිලෝමීටර්),
					},
					'square-meter' => {
						'name' => q(වර්ග මීටර්),
						'one' => q(වර්ග මීටර් {0}),
						'other' => q(වර්ග මීටර් {0}),
						'per' => q(වර්ග මීටරයට {0}),
					},
					'square-mile' => {
						'name' => q(වර්ග සැතපුම්),
						'one' => q(වර්ග සැතපුම් {0}),
						'other' => q(වර්ග සැතපුම් {0}),
						'per' => q({0} කට වර්ග සැතපුම්),
					},
					'square-yard' => {
						'name' => q(වර්ග යාර),
						'one' => q(වර්ග යාර {0}),
						'other' => q(වර්ග යාර {0}),
					},
					'tablespoon' => {
						'name' => q(මේස හැදී),
						'one' => q(මේස හැදී {0}),
						'other' => q(මේස හැදී {0}),
					},
					'teaspoon' => {
						'name' => q(තේ හැදී),
						'one' => q(තේ හැදී {0}),
						'other' => q(තේ හැදී {0}),
					},
					'terabit' => {
						'name' => q(ටෙරාබිට්),
						'one' => q(ටෙරාබිට් {0}),
						'other' => q(ටෙරාබිට් {0}),
					},
					'terabyte' => {
						'name' => q(ටෙරාබයිට්),
						'one' => q(ටෙරාබයිට් {0}),
						'other' => q(ටෙරාබයිට් {0}),
					},
					'ton' => {
						'name' => q(ටොන්),
						'one' => q(ටොන් {0}),
						'other' => q(ටොන් {0}),
					},
					'volt' => {
						'name' => q(වෝල්ට්),
						'one' => q(වෝල්ට් {0}),
						'other' => q(වෝල්ට් {0}),
					},
					'watt' => {
						'name' => q(වොට්),
						'one' => q(වොට් {0}),
						'other' => q(වොට් {0}),
					},
					'week' => {
						'name' => q(සති),
						'one' => q(සති {0}),
						'other' => q(සති {0}),
						'per' => q(සතියට {0}),
					},
					'yard' => {
						'name' => q(යාර),
						'one' => q(යාර {0}),
						'other' => q(යාර {0}),
					},
					'year' => {
						'name' => q(වසර),
						'one' => q(වසර {0}),
						'other' => q(වසර {0}),
						'per' => q(වසරට {0}),
					},
				},
				'narrow' => {
					'' => {
						'name' => q(දිශාව),
					},
					'acre' => {
						'one' => q(අක්කර {0}),
						'other' => q(අක්කර {0}),
					},
					'arc-minute' => {
						'one' => q(මිනිත්තු {0}),
						'other' => q(මිනිත්තු {0}),
					},
					'arc-second' => {
						'one' => q(තත් {0}),
						'other' => q(තත් {0}),
					},
					'celsius' => {
						'name' => q(සෙල්සියස් අංශක),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'name' => q(සෙ.මී),
						'one' => q(සෙ.මී {0}),
						'other' => q(සෙ.මී {0}),
					},
					'coordinate' => {
						'east' => q({0}නැ),
						'north' => q({0}උ),
						'south' => q({0}ද),
						'west' => q({0}බ),
					},
					'cubic-kilometer' => {
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					'day' => {
						'name' => q(දින),
						'one' => q(දි {0}),
						'other' => q(දි {0}),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q(ෆැර. {0}°),
						'other' => q(ෆැර. {0}°),
					},
					'foot' => {
						'one' => q({0}'),
						'other' => q({0}'),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'name' => q(ග්‍රෑම්),
						'one' => q(ග්‍රෑ. {0}),
						'other' => q(ග්‍රෑ. {0}),
					},
					'hectare' => {
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(පැය),
						'one' => q(පැය {0}),
						'other' => q(පැය {0}),
					},
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'inch-hg' => {
						'one' => q(රසදිය {0}"),
						'other' => q(රසදිය {0}"),
					},
					'kilogram' => {
						'name' => q(කි.ග්‍රෑ.),
						'one' => q(කිග්‍රෑ{0}),
						'other' => q(කිග්‍රෑ{0}),
					},
					'kilometer' => {
						'name' => q(කි.මී),
						'one' => q(කි.මී {0}),
						'other' => q(කි.මී {0}),
					},
					'kilometer-per-hour' => {
						'name' => q(පැයට කිලෝමීටර්),
						'one' => q(කිමී/පැ {0}),
						'other' => q(කිමී/පැ {0}),
					},
					'kilowatt' => {
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'one' => q(ආ.ව {0}),
						'other' => q(ආ.ව {0}),
					},
					'liter' => {
						'name' => q(ලීටර්),
						'one' => q(ලී {0}),
						'other' => q(ලී {0}),
					},
					'liter-per-100kilometers' => {
						'name' => q(ලී/කිමී100),
						'one' => q(ලී/කිමී100 {0}),
						'other' => q(ලී/කිමී100 {0}),
					},
					'meter' => {
						'name' => q(මීටර්),
						'one' => q(මී {0}),
						'other' => q(මී {0}),
					},
					'meter-per-second' => {
						'one' => q(මී/තත් {0}),
						'other' => q(මී/තත් {0}),
					},
					'mile' => {
						'one' => q(සැත {0}),
						'other' => q(සැත {0}),
					},
					'mile-per-hour' => {
						'one' => q(පැ/සැ {0}),
						'other' => q(පැ/සැ {0}),
					},
					'millibar' => {
						'one' => q(මි.බා. {0}),
						'other' => q(මි.බා. {0}),
					},
					'millimeter' => {
						'name' => q(මිමී),
						'one' => q(මිමී {0}),
						'other' => q(මිමී {0}),
					},
					'millisecond' => {
						'name' => q(මිලිතත්),
						'one' => q(මිලිතත් {0}),
						'other' => q(මිලිතත් {0}),
					},
					'minute' => {
						'name' => q(මිනි),
						'one' => q(මි {0}),
						'other' => q(මි {0}),
					},
					'month' => {
						'name' => q(මාස),
						'one' => q(මා {0}),
						'other' => q(මා {0}),
					},
					'ounce' => {
						'one' => q(අවුන්ස {0}),
						'other' => q(අවුන්ස {0}),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(%),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'picometer' => {
						'one' => q(පිමී {0}),
						'other' => q(පිමී {0}),
					},
					'pound' => {
						'one' => q(රා. {0}),
						'other' => q(රා. {0}),
					},
					'second' => {
						'name' => q(තත්),
						'one' => q(ත {0}),
						'other' => q(ත {0}),
					},
					'square-foot' => {
						'one' => q({0} ft²),
						'other' => q({0} ft²),
					},
					'square-kilometer' => {
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					'watt' => {
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'name' => q(සති),
						'one' => q(ස {0}),
						'other' => q(ස {0}),
					},
					'yard' => {
						'one' => q(යාර {0}),
						'other' => q(යාර {0}),
					},
					'year' => {
						'name' => q(වසර),
						'one' => q(ව {0}),
						'other' => q(ව {0}),
					},
				},
				'short' => {
					'' => {
						'name' => q(දිශාව),
					},
					'acre' => {
						'name' => q(අක්කර),
						'one' => q(අක්කර {0}),
						'other' => q(අක්කර {0}),
					},
					'acre-foot' => {
						'name' => q(අක්කර-අඩි),
						'one' => q(අක්-අඩි {0}),
						'other' => q(අක්-අඩි {0}),
					},
					'ampere' => {
						'name' => q(ඇම්පිර),
						'one' => q(ඇ {0}),
						'other' => q(ඇ {0}),
					},
					'arc-minute' => {
						'name' => q(මිනිත්තු),
						'one' => q(මිනිත්තු {0}),
						'other' => q(මිනිත්තු {0}),
					},
					'arc-second' => {
						'name' => q(තත්පර),
						'one' => q(තත් {0}),
						'other' => q(තත් {0}),
					},
					'astronomical-unit' => {
						'name' => q(නඒ),
						'one' => q(නඒ {0}),
						'other' => q(නඒ {0}),
					},
					'atmosphere' => {
						'name' => q(වායුගෝ),
						'one' => q(වායුගෝ {0}),
						'other' => q(වායුගෝ {0}),
					},
					'bit' => {
						'name' => q(බීට්),
						'one' => q(බීට් {0}),
						'other' => q(බීට් {0}),
					},
					'byte' => {
						'name' => q(බයිට්),
						'one' => q(බයිට් {0}),
						'other' => q(බයිට් {0}),
					},
					'calorie' => {
						'name' => q(කැල),
						'one' => q(කැල {0}),
						'other' => q(කැල {0}),
					},
					'carat' => {
						'name' => q(කැරට්),
						'one' => q(කැට් {0}),
						'other' => q(කැට් {0}),
					},
					'celsius' => {
						'name' => q(සෙල්සියස් අංශක),
						'one' => q(සෙල්. {0}°),
						'other' => q(සෙල්. {0}°),
					},
					'centiliter' => {
						'name' => q(සෙලී),
						'one' => q(සෙලී {0}),
						'other' => q(සෙලී {0}),
					},
					'centimeter' => {
						'name' => q(සෙ.මී),
						'one' => q(සෙ.මී {0}),
						'other' => q(සෙ.මී {0}),
						'per' => q({0}/සෙ.මී),
					},
					'century' => {
						'name' => q(සි),
						'one' => q(සි {0}),
						'other' => q(සි {0}),
					},
					'coordinate' => {
						'east' => q({0}නැ),
						'north' => q({0}උ),
						'south' => q({0}ද),
						'west' => q({0}බ),
					},
					'cubic-centimeter' => {
						'name' => q(සෙමී³),
						'one' => q(ඝසෙ {0}),
						'other' => q(ඝසෙ {0}),
						'per' => q({0}/ඝසෙ),
					},
					'cubic-foot' => {
						'name' => q(අඩි³),
						'one' => q(අඩි³ {0}),
						'other' => q(අඩි³ {0}),
					},
					'cubic-inch' => {
						'name' => q(අඟල්³),
						'one' => q(අල්³ {0}),
						'other' => q(අල්³ {0}),
					},
					'cubic-kilometer' => {
						'name' => q(කිමී³),
						'one' => q(කිමී³ {0}),
						'other' => q(කිමී³ {0}),
					},
					'cubic-meter' => {
						'name' => q(මී³),
						'one' => q(මී³ {0}),
						'other' => q(මී³ {0}),
						'per' => q({0}/මී³),
					},
					'cubic-mile' => {
						'name' => q(සැත³),
						'one' => q(සැත³ {0}),
						'other' => q(සැත³ {0}),
					},
					'cubic-yard' => {
						'name' => q(යාර³),
						'one' => q(යාර³ {0}),
						'other' => q(යාර³ {0}),
					},
					'cup' => {
						'name' => q(කෝප්ප),
						'one' => q(කෝ {0}),
						'other' => q(කෝ {0}),
					},
					'cup-metric' => {
						'name' => q(මෙකෝප්ප),
						'one' => q(මෙකෝ {0}),
						'other' => q(මෙකෝ {0}),
					},
					'day' => {
						'name' => q(දින),
						'one' => q(දින {0}),
						'other' => q(දින {0}),
						'per' => q({0}/දි),
					},
					'deciliter' => {
						'name' => q(ඩෙලී),
						'one' => q(ඩෙලී {0}),
						'other' => q(ඩෙලී {0}),
					},
					'decimeter' => {
						'name' => q(ඩෙමී),
						'one' => q(ඩෙමී {0}),
						'other' => q(ඩෙමී {0}),
					},
					'degree' => {
						'name' => q(අංශක),
						'one' => q(අංශක {0}),
						'other' => q(අංශක {0}),
					},
					'fahrenheit' => {
						'name' => q(ෆැර. අ),
						'one' => q(ෆැර. {0}°),
						'other' => q(ෆැර. {0}°),
					},
					'fluid-ounce' => {
						'name' => q(ද්‍රව අවු),
						'one' => q(ද්‍රව අවු {0}),
						'other' => q(ද්‍රව අවු {0}),
					},
					'foodcalorie' => {
						'name' => q(කැල),
						'one' => q(කැල {0}),
						'other' => q(කැල {0}),
					},
					'foot' => {
						'name' => q(අඩි),
						'one' => q(අඩි {0}),
						'other' => q(අඩි {0}),
						'per' => q({0}/අඩි),
					},
					'g-force' => {
						'name' => q(g-බලය),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(ගැලු),
						'one' => q(ගැලු {0}),
						'other' => q(ගැලු {0}),
						'per' => q({0}/ගැලු),
					},
					'gallon-imperial' => {
						'name' => q(ඉම්පී. ගැ),
						'one' => q({0} ගැ ඉම්පී.),
						'other' => q({0} ගැ ඉම්පී.),
						'per' => q({0}/ ගැ ඉම්පී.),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ගිබීට්),
						'one' => q(ගිබී {0}),
						'other' => q(ගිබී {0}),
					},
					'gigabyte' => {
						'name' => q(ගිබයිට්‌),
						'one' => q(ගිබ {0}),
						'other' => q(ගිබ {0}),
					},
					'gigahertz' => {
						'name' => q(ගිහස්),
						'one' => q(ගිහස් {0}),
						'other' => q(ගිහස් {0}),
					},
					'gigawatt' => {
						'name' => q(ගිවො),
						'one' => q(ගිවො {0}),
						'other' => q(ගිවො {0}),
					},
					'gram' => {
						'name' => q(ග්‍රෑම්),
						'one' => q(ග්‍රෑ. {0}),
						'other' => q(ග්‍රෑ. {0}),
						'per' => q({0}/ග්‍රෑ.),
					},
					'hectare' => {
						'name' => q(හෙක්ටයාර්),
						'one' => q(හෙක් {0}),
						'other' => q(හෙක් {0}),
					},
					'hectoliter' => {
						'name' => q(භෙලී),
						'one' => q(භෙලී {0}),
						'other' => q(භෙලී {0}),
					},
					'hectopascal' => {
						'name' => q(හෙක්ටොපැස්කල්),
						'one' => q(හෙ.පැ {0}),
						'other' => q(හෙ.පැ {0}),
					},
					'hertz' => {
						'name' => q(හස්),
						'one' => q(හස් {0}),
						'other' => q(හස් {0}),
					},
					'horsepower' => {
						'name' => q(අබ),
						'one' => q(අබ {0}),
						'other' => q(අබ {0}),
					},
					'hour' => {
						'name' => q(පැය),
						'one' => q(පැය {0}),
						'other' => q(පැය {0}),
						'per' => q(පැයට {0}),
					},
					'inch' => {
						'name' => q(අඟල්),
						'one' => q(අඟල් {0}),
						'other' => q(අඟල් {0}),
						'per' => q({0}/අඟල්),
					},
					'inch-hg' => {
						'name' => q(ර අඟ),
						'one' => q(ර අඟ {0}),
						'other' => q(ර අඟ {0}),
					},
					'joule' => {
						'name' => q(ජුල්),
						'one' => q(ජු {0}),
						'other' => q(ජු {0}),
					},
					'karat' => {
						'name' => q(ක්‍රාත්),
						'one' => q(ක්‍රාත් {0}),
						'other' => q(ක්‍රාත් {0}),
					},
					'kelvin' => {
						'name' => q(කෙල්. අ),
						'one' => q(කෙල්. {0}°),
						'other' => q(කෙල්. {0}°),
					},
					'kilobit' => {
						'name' => q(කිබීට්),
						'one' => q(කිබී {0}),
						'other' => q(කිබී {0}),
					},
					'kilobyte' => {
						'name' => q(කිබයිට්),
						'one' => q(කිබ {0}),
						'other' => q(කිබ {0}),
					},
					'kilocalorie' => {
						'name' => q(කිකැලරි),
						'one' => q(කිකැලරි {0}),
						'other' => q(කිකැලරි {0}),
					},
					'kilogram' => {
						'name' => q(කි.ග්‍රෑ.),
						'one' => q(කි.ග්‍රෑ. {0}),
						'other' => q(කි.ග්‍රෑ. {0}),
						'per' => q({0}/කි.ග්‍රෑ.),
					},
					'kilohertz' => {
						'name' => q(කිහස්),
						'one' => q(කිහස් {0}),
						'other' => q(කිහස් {0}),
					},
					'kilojoule' => {
						'name' => q(කිලෝ ජුල්),
						'one' => q(කිජු {0}),
						'other' => q(කිජු {0}),
					},
					'kilometer' => {
						'name' => q(කි.මී),
						'one' => q(කි.මී {0}),
						'other' => q(කි.මී {0}),
						'per' => q({0}/කි.මී),
					},
					'kilometer-per-hour' => {
						'name' => q(පැයට කිලෝමීටර්),
						'one' => q(කිමී/පැ {0}),
						'other' => q(කිමී/පැ {0}),
					},
					'kilowatt' => {
						'name' => q(කිවො),
						'one' => q(කිවො {0}),
						'other' => q(කිවො {0}),
					},
					'kilowatt-hour' => {
						'name' => q(කිවො-පැය),
						'one' => q(කිවො-පැය {0}),
						'other' => q(කිවො-පැය {0}),
					},
					'knot' => {
						'name' => q(නාසැ),
						'one' => q(නාසැ {0}),
						'other' => q(නාසැ {0}),
					},
					'light-year' => {
						'name' => q(ආලෝක වර්ෂ),
						'one' => q(ආ.ව {0}),
						'other' => q(ආ.ව {0}),
					},
					'liter' => {
						'name' => q(ලීටර්),
						'one' => q(ලී {0}),
						'other' => q(ලී {0}),
						'per' => q({0}/ලී),
					},
					'liter-per-100kilometers' => {
						'name' => q(ලී/කිමී100),
						'one' => q(ලී/කිමී100 {0}),
						'other' => q(ලී/100කිමී {0}),
					},
					'liter-per-kilometer' => {
						'name' => q(ලීටරය/කිමී),
						'one' => q(ලී/කිමී {0}),
						'other' => q(ලී/කිමී {0}),
					},
					'lux' => {
						'name' => q(ලක්ස්),
						'one' => q(ලක් {0}),
						'other' => q(ලක් {0}),
					},
					'megabit' => {
						'name' => q(මෙබීට්),
						'one' => q(මෙබි {0}),
						'other' => q(මෙබි {0}),
					},
					'megabyte' => {
						'name' => q(මෙබයිට්),
						'one' => q(මෙබ {0}),
						'other' => q(මෙබ {0}),
					},
					'megahertz' => {
						'name' => q(මෙග),
						'one' => q(මෙහ {0}),
						'other' => q(මෙහ {0}),
					},
					'megaliter' => {
						'name' => q(මෙලී),
						'one' => q(මෙලී {0}),
						'other' => q(මෙලී {0}),
					},
					'megawatt' => {
						'name' => q(මෙවො),
						'one' => q(මෙවො {0}),
						'other' => q(මෙවො {0}),
					},
					'meter' => {
						'name' => q(මීටර්),
						'one' => q(මී {0}),
						'other' => q(මී {0}),
						'per' => q({0}/මී),
					},
					'meter-per-second' => {
						'name' => q(තත්පරයට මීටර්),
						'one' => q(මී/තත් {0}),
						'other' => q(මී/තත් {0}),
					},
					'meter-per-second-squared' => {
						'name' => q(මීටර/තත්පර වර්ගයට),
						'one' => q(මී/තව {0}),
						'other' => q(මී/තව {0}),
					},
					'metric-ton' => {
						'name' => q(ටො),
						'one' => q(ටො {0}),
						'other' => q(ටො {0}),
					},
					'microgram' => {
						'name' => q(මග්‍රෑ),
						'one' => q(මග්‍රෑ {0}),
						'other' => q(මග්‍රෑ {0}),
					},
					'micrometer' => {
						'name' => q(මමීටර),
						'one' => q(මමී {0}),
						'other' => q(මමී {0}),
					},
					'microsecond' => {
						'name' => q(මයික්‍රොතත්),
						'one' => q(මයික්‍රොතත් {0}),
						'other' => q(මයික්‍රොතත් {0}),
					},
					'mile' => {
						'name' => q(සැතපුම්),
						'one' => q(සැත {0}),
						'other' => q(සැත {0}),
					},
					'mile-per-gallon' => {
						'name' => q(හැතැප්ම/ගැලු),
						'one' => q(හැගැ {0}),
						'other' => q(හැගැ {0}),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(හැතැප්ම/ගැලුම්),
						'one' => q({0} ගැහැ),
						'other' => q({0} ගැහැ),
					},
					'mile-per-hour' => {
						'name' => q(පැයට සැතපුම්),
						'one' => q(පැ/සැ {0}),
						'other' => q(පැ/සැ {0}),
					},
					'mile-scandinavian' => {
						'name' => q(ස්කැන්සැත),
						'one' => q(ස්කැසැත {0}),
						'other' => q(ස්කැසැත {0}),
					},
					'milliampere' => {
						'name' => q(මිලිඇම්පිර),
						'one' => q(මිඇ {0}),
						'other' => q(මිඇ {0}),
					},
					'millibar' => {
						'name' => q(මිලිබාර්),
						'one' => q(මි.බාර් {0}),
						'other' => q(මි.බාර් {0}),
					},
					'milligram' => {
						'name' => q(මිග්‍රෑ),
						'one' => q(මිග්‍රෑ {0}),
						'other' => q(මිග්‍රෑ {0}),
					},
					'milligram-per-deciliter' => {
						'name' => q(මිග්‍රෑ/ඩෙලි),
						'one' => q({0} මිග්‍රෑ/ඩෙලි),
						'other' => q({0} මිග්‍රෑ/ඩෙලි),
					},
					'milliliter' => {
						'name' => q(මිලී),
						'one' => q(මිලී {0}),
						'other' => q(මිලී {0}),
					},
					'millimeter' => {
						'name' => q(මිමී),
						'one' => q(මිමී {0}),
						'other' => q(මිමී {0}),
					},
					'millimeter-of-mercury' => {
						'name' => q(ර මිමී),
						'one' => q(ර මිමී {0}),
						'other' => q(ර මිමී {0}),
					},
					'millimole-per-liter' => {
						'name' => q(මිලිමෝල්/ලීටර්),
						'one' => q({0} මිමෝල්/ලී),
						'other' => q({0} මිමෝල්/ලී),
					},
					'millisecond' => {
						'name' => q(මිලිතත්පර),
						'one' => q(මිලිතත් {0}),
						'other' => q(මිලිතත් {0}),
					},
					'milliwatt' => {
						'name' => q(මිවො),
						'one' => q(මිවො {0}),
						'other' => q(මිවො {0}),
					},
					'minute' => {
						'name' => q(මිනි),
						'one' => q(මිනි {0}),
						'other' => q(මිනි {0}),
						'per' => q({0}/මිනි),
					},
					'month' => {
						'name' => q(මාස),
						'one' => q(මාස {0}),
						'other' => q(මාස {0}),
						'per' => q({0}/මා),
					},
					'nanometer' => {
						'name' => q(නැමී),
						'one' => q(නැමී {0}),
						'other' => q(නැමී {0}),
					},
					'nanosecond' => {
						'name' => q(නැනෝතත්),
						'one' => q(නැත {0}),
						'other' => q(නැත {0}),
					},
					'nautical-mile' => {
						'name' => q(නාසැත),
						'one' => q(නාසැත {0}),
						'other' => q(නාසැත {0}),
					},
					'ohm' => {
						'name' => q(ඕම්),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(අවුස),
						'one' => q(අවුස {0}),
						'other' => q(අවුස {0}),
						'per' => q({0}/අවුස),
					},
					'ounce-troy' => {
						'name' => q(අවුස ට්‍රෝයි),
						'one' => q(අවුස ට්‍රෝ {0}),
						'other' => q(අවුස ට්‍රෝ {0}),
					},
					'parsec' => {
						'name' => q(පාර්සෙක්),
						'one' => q(පාසෙ {0}),
						'other' => q(පාසෙ {0}),
					},
					'part-per-million' => {
						'name' => q(කොටස්/මිලියනය),
						'one' => q({0} මිලිකො),
						'other' => q({0} මිලිකො),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(ප්‍රතිශතය),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'permille' => {
						'name' => q(‰),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'name' => q(පෙබයිට්),
						'one' => q(පෙබ {0}),
						'other' => q(පෙබ {0}),
					},
					'picometer' => {
						'name' => q(පිකොමිටර්),
						'one' => q(පිමී {0}),
						'other' => q(පිමී {0}),
					},
					'pint' => {
						'name' => q(පයින්ට්),
						'one' => q(පට් {0}),
						'other' => q(පට් {0}),
					},
					'pint-metric' => {
						'name' => q(මෙපට්),
						'one' => q(මෙපට් {0}),
						'other' => q(මෙපට් {0}),
					},
					'point' => {
						'name' => q(පොයින්ට්),
						'one' => q(පො {0}),
						'other' => q(පො {0}),
					},
					'pound' => {
						'name' => q(රාත්තල්),
						'one' => q(රා {0}),
						'other' => q(රා {0}),
						'per' => q({0}/රා),
					},
					'pound-per-square-inch' => {
						'name' => q(වඅ රා),
						'one' => q(වඅ රා {0}),
						'other' => q(වඅ රා {0}),
					},
					'quart' => {
						'name' => q(ක්වාට්),
						'one' => q(ක්ට් {0}),
						'other' => q(ක්ට් {0}),
					},
					'radian' => {
						'name' => q(රේඩියන්),
						'one' => q(රේඩි {0}),
						'other' => q(රේඩි {0}),
					},
					'revolution' => {
						'name' => q(පරිභ්‍ර),
						'one' => q(පරිභ්‍ර {0}),
						'other' => q(පරිභ්‍ර {0}),
					},
					'second' => {
						'name' => q(තත්පර),
						'one' => q(තත් {0}),
						'other' => q(තත් {0}),
						'per' => q(තත්පරයට {0}),
					},
					'square-centimeter' => {
						'name' => q(වසෙ),
						'one' => q(වසෙ {0}),
						'other' => q(වසෙ {0}),
						'per' => q({0}/වසෙ),
					},
					'square-foot' => {
						'name' => q(වර්ග අඩි),
						'one' => q({0} ft²),
						'other' => q({0} ft²),
					},
					'square-inch' => {
						'name' => q(වර්ග අඟල්),
						'one' => q(වඅ {0}),
						'other' => q(වඅ {0}),
						'per' => q({0}/වඅ),
					},
					'square-kilometer' => {
						'name' => q(ව.කී),
						'one' => q(ව.කී {0}),
						'other' => q(ව.කී {0}),
						'per' => q({0} කට වර්ග කිලෝමීටර්),
					},
					'square-meter' => {
						'name' => q(වර්ග මීටර්),
						'one' => q(ව.මී {0}),
						'other' => q(ව.මී {0}),
						'per' => q({0}/ව.මී),
					},
					'square-mile' => {
						'name' => q(වර්ග සැතපුම්),
						'one' => q(ව.සැ {0}),
						'other' => q(ව.සැ {0}),
						'per' => q({0} කට ව.සැ),
					},
					'square-yard' => {
						'name' => q(වර්ග යාර),
						'one' => q(වයා {0}),
						'other' => q(වයා {0}),
					},
					'tablespoon' => {
						'name' => q(මේසහැදී),
						'one' => q(මේසහැදී {0}),
						'other' => q(මේසහැදී {0}),
					},
					'teaspoon' => {
						'name' => q(තේහැදී),
						'one' => q(තේහැදී {0}),
						'other' => q(තේහැදී {0}),
					},
					'terabit' => {
						'name' => q(ටෙබිට්),
						'one' => q(ටේබි {0}),
						'other' => q(ටේබි {0}),
					},
					'terabyte' => {
						'name' => q(ටෙබයිට්),
						'one' => q(ටෙබ {0}),
						'other' => q(ටෙබ {0}),
					},
					'ton' => {
						'name' => q(ටොන්),
						'one' => q(ටොන් {0}),
						'other' => q(ටොන් {0}),
					},
					'volt' => {
						'name' => q(වෝල්ට්),
						'one' => q(වෝ {0}),
						'other' => q(වෝ {0}),
					},
					'watt' => {
						'name' => q(වොට්),
						'one' => q(වොට් {0}),
						'other' => q(වොට් {0}),
					},
					'week' => {
						'name' => q(සති),
						'one' => q(සති {0}),
						'other' => q(සති {0}),
						'per' => q({0}/ස),
					},
					'yard' => {
						'name' => q(යාර),
						'one' => q(යාර {0}),
						'other' => q(යාර {0}),
					},
					'year' => {
						'name' => q(වසර),
						'one' => q(වසර {0}),
						'other' => q(වසර {0}),
						'per' => q({0}/ව),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ඔව්|ඔ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:නැත|නැ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, සහ {1}),
				2 => q({0} සහ {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(.),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => 'ද0',
					'other' => 'ද0',
				},
				'10000' => {
					'one' => 'ද00',
					'other' => 'ද00',
				},
				'100000' => {
					'one' => 'ද000',
					'other' => 'ද000',
				},
				'1000000' => {
					'one' => 'මි0',
					'other' => 'මි0',
				},
				'10000000' => {
					'one' => 'මි00',
					'other' => 'මි00',
				},
				'100000000' => {
					'one' => 'මි000',
					'other' => 'මි000',
				},
				'1000000000' => {
					'one' => 'බි0',
					'other' => 'බි0',
				},
				'10000000000' => {
					'one' => 'බි00',
					'other' => 'බි00',
				},
				'100000000000' => {
					'one' => 'බි000',
					'other' => 'බි000',
				},
				'1000000000000' => {
					'one' => 'ට්‍රි0',
					'other' => 'ට්‍රි0',
				},
				'10000000000000' => {
					'one' => 'ට්‍රි00',
					'other' => 'ට්‍රි00',
				},
				'100000000000000' => {
					'one' => 'ට්‍රි000',
					'other' => 'ට්‍රි000',
				},
				'standard' => {
					'default' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => 'දහස 0',
					'other' => 'දහස 0',
				},
				'10000' => {
					'one' => 'දහස 00',
					'other' => 'දහස 00',
				},
				'100000' => {
					'one' => 'දහස 000',
					'other' => 'දහස 000',
				},
				'1000000' => {
					'one' => 'මිලියන 0',
					'other' => 'මිලියන 0',
				},
				'10000000' => {
					'one' => 'මිලියන 00',
					'other' => 'මිලියන 00',
				},
				'100000000' => {
					'one' => 'මිලියන 000',
					'other' => 'මිලියන 000',
				},
				'1000000000' => {
					'one' => 'බිලියන 0',
					'other' => 'බිලියන 0',
				},
				'10000000000' => {
					'one' => 'බිලියන 00',
					'other' => 'බිලියන 00',
				},
				'100000000000' => {
					'one' => 'බිලියන 000',
					'other' => 'බිලියන 000',
				},
				'1000000000000' => {
					'one' => 'ට්‍රිලියන 0',
					'other' => 'ට්‍රිලියන 0',
				},
				'10000000000000' => {
					'one' => 'ට්‍රිලියන 00',
					'other' => 'ට්‍රිලියන 00',
				},
				'100000000000000' => {
					'one' => 'ට්‍රිලියන 000',
					'other' => 'ට්‍රිලියන 000',
				},
			},
			'short' => {
				'1000' => {
					'one' => 'ද0',
					'other' => 'ද0',
				},
				'10000' => {
					'one' => 'ද00',
					'other' => 'ද00',
				},
				'100000' => {
					'one' => 'ද000',
					'other' => 'ද000',
				},
				'1000000' => {
					'one' => 'මි0',
					'other' => 'මි0',
				},
				'10000000' => {
					'one' => 'මි00',
					'other' => 'මි00',
				},
				'100000000' => {
					'one' => 'මි000',
					'other' => 'මි000',
				},
				'1000000000' => {
					'one' => 'බි0',
					'other' => 'බි0',
				},
				'10000000000' => {
					'one' => 'බි00',
					'other' => 'බි00',
				},
				'100000000000' => {
					'one' => 'බි000',
					'other' => 'බි000',
				},
				'1000000000000' => {
					'one' => 'ට්‍රි0',
					'other' => 'ට්‍රි0',
				},
				'10000000000000' => {
					'one' => 'ට්‍රි00',
					'other' => 'ට්‍රි00',
				},
				'100000000000000' => {
					'one' => 'ට්‍රි000',
					'other' => 'ට්‍රි000',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(එක්සත් අරාබි එමිරේට්ස් ඩිරාම්),
				'one' => q(එක්සත් අරාබි එමිරේට්ස් ඩිරාම්),
				'other' => q(එක්සත් අරාබි එමිරේට්ස් ඩිරාම්),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(ඇෆ්ගනිථාන ඇෆ්ගනි),
				'one' => q(ඇෆ්ගනිථාන ඇෆ්ගනි),
				'other' => q(ඇෆ්ගනිථාන ඇෆ්ගනි),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(ඇල්බේනියානු ලෙක්),
				'one' => q(ඇල්බේනියානු ලෙක්),
				'other' => q(ඇල්බේනියානු ලෙක්),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(ආර්මේනියානු ඩ්‍රෑම්),
				'one' => q(ආර්මේනියානු ඩ්‍රෑම්),
				'other' => q(ආර්මේනියානු ඩ්‍රෑම්),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(නෙදර්ලන්ත ඇන්ටිලියන් ගිල්ඩර්),
				'one' => q(නෙදර්ලන්ත ඇන්ටිලියන් ගිල්ඩර්),
				'other' => q(නෙදර්ලන්ත ඇන්ටිලියන් ගිල්ඩර්),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(ඇන්ගෝලානු ක්වන්සා),
				'one' => q(ඇන්ගෝලානු ක්වන්සා),
				'other' => q(ඇන්ගෝලානු ක්වන්සා),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(ආර්ජන්ටිනා පෙසෝ),
				'one' => q(ආර්ජන්ටිනා පෙසෝ),
				'other' => q(ආර්ජන්ටිනා පෙසෝ),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ඔස්ට්‍රේලියානු ඩොලර්),
				'one' => q(ඔස්ට්‍රේලියානු ඩොලර්),
				'other' => q(ඔස්ට්‍රේලියානු ඩොලර්),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(අරූබානු ෆ්ලෝරින්),
				'one' => q(අරූබානු ෆ්ලෝරින්),
				'other' => q(අරූබානු ෆ්ලෝරින්),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(අසර්බයිජානු මනාට්),
				'one' => q(අසර්බයිජානු මනාට්),
				'other' => q(අසර්බයිජානු මනාට්),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(බොස්නියා හර්සගොවීනා පරිවර්ත්‍ය මාර්ක්),
				'one' => q(බොස්නියා හර්සගොවීනා පරිවර්ත්‍ය මාර්ක්),
				'other' => q(බොස්නියා හර්සගොවීනා පරිවර්ත්‍ය මාර්ක්),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(බාබේඩියානු ඩොලර්),
				'one' => q(බාබේඩියානු ඩොලර්),
				'other' => q(බාබේඩියානු ඩොලර්),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(බංග්ලාදේශ් ටකා),
				'one' => q(බංග්ලාදේශ් ටකා),
				'other' => q(බංග්ලාදේශ් ටකා),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(බල්ගේරියානු ලිව්),
				'one' => q(බල්ගේරියානු ලිව්),
				'other' => q(බල්ගේරියානු ලිව්),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(බහරේන් ඩිනාර්),
				'one' => q(බහරේන් ඩිනාර්),
				'other' => q(බහරේන් ඩිනාර්),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(බුරුන්දි ෆ්‍රෑන්ක්),
				'one' => q(බුරුන්දි ෆ්‍රෑන්ක්),
				'other' => q(බුරුන්දි ෆ්‍රෑන්ක්),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(බර්මියුඩානු ඩොලර්),
				'one' => q(බර්මියුඩානු ඩොලර්),
				'other' => q(බර්මියුඩානු ඩොලර්),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(බෘනායි ඩොලර්),
				'one' => q(බෘනායි ඩොලර්),
				'other' => q(බෘනායි ඩොලර්),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(බොලිවියානු බොලිවියානෝ),
				'one' => q(බොලිවියානු බොලිවියානෝ),
				'other' => q(බොලිවියානු බොලිවියානෝ),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(බ්‍රසීල රියල්),
				'one' => q(බ්‍රසීල රියල්),
				'other' => q(බ්‍රසීල රියල්),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(බහමානු ඩොලර්),
				'one' => q(බහමානු ඩොලර්),
				'other' => q(බහමානු ඩොලර්),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(භූතාන නගුල්ට්‍රම්),
				'one' => q(භූතාන නගුල්ට්‍රම්),
				'other' => q(භූතාන නගුල්ට්‍රම්),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(බොට්ස්වානා පුලා),
				'one' => q(බොට්ස්වානා පුලා),
				'other' => q(බොට්ස්වානා පුලා),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(බෙලරූස් රූබල්),
				'one' => q(බෙලරූස් රූබල්),
				'other' => q(බෙලරූස් රූබල්),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(බෙලරූස් රූබල් \(2000–2016\)),
				'one' => q(බෙලරූස් රූබල් \(2000–2016\)),
				'other' => q(බෙලරූස් රූබල් \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(බෙලීස් ඩොලර්),
				'one' => q(බෙලිස් ඩොලර්),
				'other' => q(බෙලිස් ඩොලර්),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(කැනේඩියානු ඩොලර්),
				'one' => q(කැනේඩියානු ඩොලර්),
				'other' => q(කැනේඩියානු ඩොලර්),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(කොංගෝ ෆ්‍රෑන්ක්),
				'one' => q(කොංගෝ ෆ්‍රෑන්ක්),
				'other' => q(කොංගෝ ෆ්‍රෑන්ක්),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(ස්විස් ෆ්‍රෑන්ක්),
				'one' => q(ස්විස් ෆ්‍රෑන්ක්),
				'other' => q(ස්විස් ෆ්‍රෑන්ක්),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(චිලි පැසෝ),
				'one' => q(චිලි පැසෝ),
				'other' => q(චිලි පැසෝ),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(චීන යුආන් \(එතෙර\)),
				'one' => q(චීන යුආන් \(එතෙර\)),
				'other' => q(චීන යුආන් \(එතෙර\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(චීන යුආන්),
				'one' => q(චීන යුආන්),
				'other' => q(චීන යුආන්),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(කොලොම්බියානු පෙසෝ),
				'one' => q(කොලොම්බියානු පෙසෝ),
				'other' => q(කොලොම්බියානු පෙසෝ),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(කොස්ට රිකා කොලෝන්),
				'one' => q(කොස්ට රිකා කොලෝන්),
				'other' => q(කොස්ට රිකා කොලෝන්),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(මාරුකළ හැකි කියුබානු පැසෝ),
				'one' => q(මාරුකළ හැකි කියුබානු පැසෝ),
				'other' => q(මාරුකළ හැකි කියුබානු පැසෝ),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(කියුබානු පැසෝ),
				'one' => q(කියුබානු පැසෝ),
				'other' => q(කියුබානු පැසෝ),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(කේප් වර්ඩ් එස්කියුඩෝ),
				'one' => q(කේප් වර්ඩ් එස්කියුඩෝ),
				'other' => q(කේප් වර්ඩ් එස්කියුඩෝ),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(චෙක් රිපබ්ලික් කොරූනා),
				'one' => q(චෙක් රිපබ්ලික් කොරූනා),
				'other' => q(චෙක් රිපබ්ලික් කොරූනා),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(ජිබූති ෆ්‍රෑන්ක්),
				'one' => q(ජිබූති ෆ්‍රෑන්ක්),
				'other' => q(ජිබූති ෆ්‍රෑන්ක්),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ඩැනිෂ් ක්‍රෝන්),
				'one' => q(ඩැනිෂ් ක්‍රෝන්),
				'other' => q(ඩැනිෂ් ක්‍රෝන්),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ඩොමිනිකානු පෙසෝ),
				'one' => q(ඩොමිනිකානු පෙසෝ),
				'other' => q(ඩොමිනිකානු පෙසෝ),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(ඇල්ගේරියානු ඩිනාර්),
				'one' => q(ඇල්ගේරියානු ඩිනාර්),
				'other' => q(ඇල්ගේරියානු ඩිනාර්),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(ඊජිප්තු පවුම්),
				'one' => q(ඊජිප්තු පවුම්),
				'other' => q(ඊජිප්තු පවුම්),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(එරිත්‍රියානු නැක්ෆා),
				'one' => q(එරිත්‍රියානු නැක්ෆා),
				'other' => q(එරිත්‍රියානු නැක්ෆා),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ඉතියෝපියානු බීර්),
				'one' => q(ඉතියෝපියානු බීර්),
				'other' => q(ඉතියෝපියානු බීර්),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(යුරෝ),
				'one' => q(යුරෝ),
				'other' => q(යුරෝ),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ෆිජියන් ඩොලර්),
				'one' => q(ෆිජියන් ඩොලර්),
				'other' => q(ෆිජියන් ඩොලර්),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ෆෝක්ලන්ඩ් දූපත් පවුම්),
				'one' => q(ෆෝක්ලන්ඩ් දූපත් පවුම්),
				'other' => q(ෆෝක්ලන්ඩ් දූපත් පවුම්),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(බ්‍රිතාන්‍ය ස්ටර්ලින් පවුම්),
				'one' => q(බ්‍රිතාන්‍ය ස්ටර්ලින් පවුම්),
				'other' => q(බ්‍රිතාන්‍ය ස්ටර්ලින් පවුම්),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(ජෝජියානු ලැරී),
				'one' => q(ජෝජියානු ලැරී),
				'other' => q(ජෝජියානු ලැරී),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ඝානා සෙඩි),
				'one' => q(ඝානා සෙඩි),
				'other' => q(ඝානා සෙඩි),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(ජිබ්‍රෝල්ටා පවුම්),
				'one' => q(ජිබ්‍රෝල්ටා පවුම්),
				'other' => q(ජිබ්‍රෝල්ටා පවුම්),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(ගැම්බියානු දලාසි),
				'one' => q(ගැම්බියානු දලාසි),
				'other' => q(ගැම්බියානු දලාසි),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(ගිනියානු ෆ්රෑන්ක්),
				'one' => q(ගිනියානු ෆ්‍රෑන්ක්),
				'other' => q(ගිනියානු ෆ්‍රෑන්ක්),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(ගෝතමාලානු ක්වෙට්සල්),
				'one' => q(ගෝතමාලානු ක්වෙට්සල්),
				'other' => q(ගෝතමාලානු ක්වෙට්සල්),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(ගයනා ඩොලර්),
				'one' => q(ගයනා ඩොලර්),
				'other' => q(ගයනා ඩොලර්),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(හොංකොං ඩොලර්),
				'one' => q(හොංකොං ඩොලර්),
				'other' => q(හොංකොං ඩොලර්),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(හොන්ඩුරානු ලෙම්පිරා),
				'one' => q(හොන්ඩුරානු ලෙම්පිරා),
				'other' => q(හොන්ඩුරානු ලෙම්පිරා),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(ක්‍රොඒෂියානු කූනා),
				'one' => q(ක්‍රොඒෂියානු කූනා),
				'other' => q(ක්‍රොඒෂියානු කූනා),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(හයිටි ගෝර්ඩ්),
				'one' => q(හයිටි ගෝර්ඩ්),
				'other' => q(හයිටි ගෝර්ඩ්),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(හංගේරියානු ෆරින්ට්),
				'one' => q(හංගේරියානු ෆරින්ට්),
				'other' => q(හංගේරියානු ෆරින්ට්),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(ඉන්දුනීසියානු රුපියා),
				'one' => q(ඉන්දුනීසියානු රුපියා),
				'other' => q(ඉන්දුනීසියානු රුපියා),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ඊශ්‍රායල නව ශෙකල්),
				'one' => q(ඊශ්‍රායල නව ශෙකල්),
				'other' => q(ඊශ්‍රායල නව ශෙකල්),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ඉන්දියානු රුපියල්),
				'one' => q(ඉන්දියානු රුපියල්),
				'other' => q(ඉන්දියානු රුපියල්),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ඉරාක ඩිනාර්),
				'one' => q(ඉරාක ඩිනාර්),
				'other' => q(ඉරාක ඩිනාර්),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ඉරාන රියාල්),
				'one' => q(ඉරාන රියාල්),
				'other' => q(ඉරාන රියාල්),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(අයිස්ලන්තික ක්‍රෝනා),
				'one' => q(අයිස්ලන්තික ක්‍රෝනා),
				'other' => q(අයිස්ලන්තික ක්‍රෝනා),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ජැමෙයිකානු ඩොලර්),
				'one' => q(ජැමෙයිකානු ඩොලර්),
				'other' => q(ජැමෙයිකානු ඩොලර්),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(ජෝර්දාන් ඩිනාර්),
				'one' => q(ජෝර්දාන් ඩිනාර්),
				'other' => q(ජෝර්දාන් ඩිනාර්),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(ජපන් යෙන්),
				'one' => q(ජපන් යෙන්),
				'other' => q(ජපන් යෙන්),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(කෙන්යානු ශිලිං),
				'one' => q(කෙන්යානු ශිලිං),
				'other' => q(කෙන්යානු ශිලිං),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(කිරිගිස්ථාන සම්),
				'one' => q(කිරිගිස්ථාන සම්),
				'other' => q(කිරිගිස්ථාන සම්),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(කාම්බෝජ රියේල්),
				'one' => q(කාම්බෝජ රියේල්),
				'other' => q(කාම්බෝජ රියේල්),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(කොමොරියානු ෆ්‍රෑන්ක්),
				'one' => q(කොමොරියානු ෆ්‍රෑන්ක්),
				'other' => q(කොමොරියානු ෆ්‍රෑන්ක්),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(උතුරු කොරියානු වොන්),
				'one' => q(උතුරු කොරියානු වොන්),
				'other' => q(උතුරු කොරියානු වොන්),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(දකුණු කොරියානු වොන්),
				'one' => q(දකුණු කොරියානු වොන්),
				'other' => q(දකුණු කොරියානු වොන්),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(කුවේට් ඩිනාර්),
				'one' => q(කුවේට් ඩිනාර්),
				'other' => q(කුවේට් ඩිනාර්),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(කේමන් දූපත් ඩොලර්),
				'one' => q(කේමන් දූපත් ඩොලර්),
				'other' => q(කේමන් දූපත් ඩොලර්),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(කසකස්ථාන ටෙන්ග),
				'one' => q(කසකස්ථාන ටෙන්ග),
				'other' => q(කසකස්ථාන ටෙන්ග),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(ලාඕස් කිප්),
				'one' => q(ලාඕස් කිප්),
				'other' => q(ලාඕස් කිප්),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(ලෙබනන පවුම්),
				'one' => q(ලෙබනන පවුම්),
				'other' => q(ලෙබනන පවුම්),
			},
		},
		'LKR' => {
			symbol => 'රු.',
			display_name => {
				'currency' => q(ශ්‍රී ලංකා රුපියල),
				'one' => q(ශ්‍රී ලංකා රුපියල),
				'other' => q(ශ්‍රී ලංකා රුපියල),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(ලයිබේරියානු ඩොලර්),
				'one' => q(ලයිබේරියානු ඩොලර්),
				'other' => q(ලයිබේරියානු ඩොලර්),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(ලිතුවේනියානු),
				'one' => q(ලිතුවේනියානු),
				'other' => q(ලිතුවේනියානු),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(ලැට්වියානු ලැට්ස්),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(ලිබියානු ඩිනාර්),
				'one' => q(ලිබියානු ඩිනාර්),
				'other' => q(ලිබියානු ඩිනාර්),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(මොරොක්කෝ ඩිර්හැම්),
				'one' => q(මොරොක්කෝ ඩිර්හැම්),
				'other' => q(මොරොක්කෝ ඩිර්හැම්),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(මෝල්ඩෝවානු ලෙව්),
				'one' => q(මෝල්ඩෝවානු ලෙව්),
				'other' => q(මෝල්ඩෝවානු ලෙව්),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(මලගාසි අරියාරි),
				'one' => q(මලගාසි අරියාරි),
				'other' => q(මලගාසි අරියාරි),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(මැසඩෝනියානු ඩිනාර්),
				'one' => q(මැසඩෝනියානු ඩිනාර්),
				'other' => q(මැසඩෝනියානු ඩිනාර්),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(බුරුම ක්යාට්),
				'one' => q(බුරුම ක්යාට්),
				'other' => q(බුරුම ක්යාට්),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(මොන්ගෝලියානු ටග්‍රික්),
				'one' => q(මොන්ගෝලියානු ටග්‍රික්),
				'other' => q(මොන්ගෝලියානු ටග්‍රික්),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(මැකනීස් පටකා),
				'one' => q(මැකනීස් පටකා),
				'other' => q(මැකනීස් පටකා),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(මුරුසි ඔයිගුයියා \(1973–2017\)),
				'one' => q(මුරුසි ඔයිගුයියා \(1973–2017\)),
				'other' => q(මුරුසි ඔයිගුයියා \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(මුරුසි ඔයිගුයියා),
				'one' => q(මුරුසි ඔයිගුයියා),
				'other' => q(මුරුසි ඔයිගුයියා),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(මුරිසියානු රුපියල්),
				'one' => q(මුරිසියානු රුපියල්),
				'other' => q(මුරිසියානු රුපියල්),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(මාලදිවයින් රුෆියා),
				'one' => q(මාලදිවයින් රුෆියා),
				'other' => q(මාලදිවයින් රුෆියා),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(මලාවි ක්වාචා),
				'one' => q(මලාවි ක්වාචා),
				'other' => q(මලාවි ක්වාචා),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(මෙක්සිකානු ඩොලර්),
				'one' => q(මෙක්සිකානු ඩොලර්),
				'other' => q(මෙක්සිකානු ඩොලර්),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(මැලේසියානු රින්ගිට්),
				'one' => q(මැලේසියානු රින්ගිට්),
				'other' => q(මැලේසියානු රින්ගිට්),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(මොසැම්බිකන් මෙටිකල්),
				'one' => q(මොසැම්බිකන් මෙටිකල්),
				'other' => q(මොසැම්බිකන් මෙටිකල්),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(නැමීබියානු ඩොලර්),
				'one' => q(නැමීබියානු ඩොලර්),
				'other' => q(නැමීබියානු ඩොලර්),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(නයිජීරියානු නයිරා),
				'one' => q(නයිජීරියානු නයිරා),
				'other' => q(නයිජීරියානු නයිරා),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(නිකරගුවානු කොඩෝබා),
				'one' => q(නිකරගුවානු කොඩෝබා),
				'other' => q(නිකරගුවානු කොඩෝබා),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(නොර්වීජියන් ක්‍රෝන්),
				'one' => q(නොර්වීජියන් ක්‍රෝන්),
				'other' => q(නොර්වීජියන් ක්‍රෝන්),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(නේපාල රුපියල්),
				'one' => q(නේපාල රුපියල්),
				'other' => q(නේපාල රුපියල්),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(නවසීලන්ත ඩොලර්),
				'one' => q(නවසීලන්ත ඩොලර්),
				'other' => q(නවසීලන්ත ඩොලර්),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ඕමාන් රියාල්),
				'one' => q(ඕමාන් රියාල්),
				'other' => q(ඕමාන් රියාල්),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(පැනමා බැල්බෝ),
				'one' => q(පැනමා බැල්බෝ),
				'other' => q(පැනමා බැල්බෝ),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(පේරු සොල්),
				'one' => q(පේරු සොල්),
				'other' => q(පේරු සොල්),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(පැපුවා නිව් ගිනියානු කිනා),
				'one' => q(පැපුවා නිව් ගිනියානු කිනා),
				'other' => q(පැපුවා නිව් ගිනියානු කිනා),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(පිලිපීන පෙසෝ),
				'one' => q(පිලිපීන පෙසෝ),
				'other' => q(පිලිපීන පෙසෝ),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(පාකිස්ථාන රුපියල්),
				'one' => q(පාකිස්ථාන රුපියල්),
				'other' => q(පාකිස්ථාන රුපියල්),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(පොලිෂ් ස්ලොටි),
				'one' => q(පොලිෂ් ස්ලොටි),
				'other' => q(පොලිෂ් ස්ලොටි),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(පැරගුවේ ගුවරානි),
				'one' => q(පැරගුවේ ගුවරානි),
				'other' => q(පැරගුවේ ගුවරානි),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(කටාර් රියාල්),
				'one' => q(කටාර් රියාල්),
				'other' => q(කටාර් රියාල්),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(රොමේනියානු ලෙව්),
				'one' => q(රොමේනියානු ලෙව්),
				'other' => q(රොමේනියානු ලෙව්),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(සර්බියානු ඩිනාර්),
				'one' => q(සර්බියානු ඩිනාර්),
				'other' => q(සර්බියානු ඩිනාර්),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(රුසියන් රූබල්),
				'one' => q(රුසියන් රූබල්),
				'other' => q(රුසියන් රූබල්),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(රුවන්ඩා ෆ්‍රෑන්ක්),
				'one' => q(රුවන්ඩා ෆ්‍රෑන්ක්),
				'other' => q(රුවන්ඩා ෆ්‍රෑන්ක්),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(සවුදි රියාල්),
				'one' => q(සවුදි රියාල්),
				'other' => q(සවුදි රියාල්),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(සොලමන් දූපත් ඩොලර්),
				'one' => q(සොලමන් දූපත් ඩොලර්),
				'other' => q(සොලමන් දූපත් ඩොලර්),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(සීෂෙලියානු රුපියල),
				'one' => q(සීෂෙලියානු රුපියල),
				'other' => q(සීෂෙලියානු රුපියල),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(සුඩාන පවුම්),
				'one' => q(සුඩාන පවුම්),
				'other' => q(සුඩාන පවුම්),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(ස්වෙඩිෂ් ක්‍රෝනා),
				'one' => q(ස්වෙඩිෂ් ක්‍රෝනා),
				'other' => q(ස්වෙඩිෂ් ක්‍රෝනා),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(සිංගප්පූරු ඩොලර්),
				'one' => q(සිංගප්පූරු ඩොලර්),
				'other' => q(සිංගප්පූරු ඩොලර්),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(ශාන්ත හෙලේනා පවුම්),
				'one' => q(ශාන්ත හෙලේනා පවුම්),
				'other' => q(ශාන්ත හෙලේනා පවුම්),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(සියරා ලියොන් ලියොන්),
				'one' => q(සියරා ලියොන් ලියොන්),
				'other' => q(සියරා ලියොන් ලියොන්),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(සෝමාලියානු ශිලිං),
				'one' => q(සෝමාලියානු ශිලිං),
				'other' => q(සෝමාලියානු ශිලිං),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(සුරිනාම් ඩොලර්),
				'one' => q(සුරිනාම් ඩොලර්),
				'other' => q(සුරිනාම් ඩොලර්),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(දකුණු සුඩාන පවුම්),
				'one' => q(දකුණු සුඩාන පවුම්),
				'other' => q(දකුණු සුඩාන පවුම්),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(සාඕ තෝම් සහ ප්‍රින්සිප් දොබ්‍රා \(1977–2017\)),
				'one' => q(සාඕ තෝම් සහ ප්‍රින්සිප් දොබ්‍රා \(1977–2017\)),
				'other' => q(සාඕ තෝම් සහ ප්‍රින්සිප් දොබ්‍රා \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'Db',
			display_name => {
				'currency' => q(සාඕ තෝම් සහ ප්‍රින්සිප් දොබ්‍රා),
				'one' => q(සාඕ තෝම් සහ ප්‍රින්සිප් දොබ්‍රා),
				'other' => q(සාඕ තෝම් සහ ප්‍රින්සිප් දොබ්‍රා),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(සිරියානු පවුම්),
				'one' => q(සිරියානු පවුම්),
				'other' => q(සිරියානු පවුම්),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(ස්වාසි ලිලන්ජනි),
				'one' => q(ස්වාසි ලිලන්ජනි),
				'other' => q(ස්වාසි ලිලන්ජනි),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(තායි බාත්),
				'one' => q(තායි බාත්),
				'other' => q(තායි බාත්),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(තජිකිස්ථාන සමොනි),
				'one' => q(තජිකිස්ථාන සමොනි),
				'other' => q(තජිකිස්ථාන සමොනි),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(තක්මෙනිස්ථාන මනාට්),
				'one' => q(තක්මෙනිස්ථාන මනාට්),
				'other' => q(තක්මෙනිස්ථාන මනාට්),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(ටියුනීසියානු ඩිනාර්),
				'one' => q(ටියුනීසියානු ඩිනාර්),
				'other' => q(ටියුනීසියානු ඩිනාර්),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(ටොංගානු පාන්ගා),
				'one' => q(ටොංගානු පාන්ගා),
				'other' => q(ටොංගානු පාන්ගා),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(තුර්කි ලිරා),
				'one' => q(තුර්කි ලිරා),
				'other' => q(තුර්කි ලිරා),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ට්‍රිනිඩෑඩ් සහ ටොබෑගෝ ඩොලර්),
				'one' => q(ට්‍රිනිඩෑඩ් සහ ටොබෑගෝ ඩොලර්),
				'other' => q(ට්‍රිනිඩෑඩ් සහ ටොබෑගෝ ඩොලර්),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(නව තායිවාන ඩොලර්),
				'one' => q(නව තායිවාන ඩොලර්),
				'other' => q(නව තායිවාන ඩොලර්),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(ටැන්සානියානු ශිලිං),
				'one' => q(ටැන්සානියානු ශිලිං),
				'other' => q(ටැන්සානියානු ශිලිං),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(යුක්රේන හ්‍රිව්නියා),
				'one' => q(යුක්රේන හ්‍රිව්නියා),
				'other' => q(යුක්රේන හ්‍රිව්නියා),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(උගන්ඩා ශිලිං),
				'one' => q(උගන්ඩා ශිලිං),
				'other' => q(උගන්ඩා ශිලිං),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(ඇමරිකානු ඩොලර්),
				'one' => q(ඇමරිකානු ඩොලර්),
				'other' => q(ඇමරිකානු ඩොලර්),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(උරුගුවේ පෙසෝ),
				'one' => q(උරුගුවේ පෙසෝ),
				'other' => q(උරුගුවේ පෙසෝ),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(උස්බෙකිස්ථාන සම්),
				'one' => q(උස්බෙකිස්ථාන සම්),
				'other' => q(උස්බෙකිස්ථාන සම්),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(වෙනිසියුලානු බොලිවර් \(2008–2018\)),
				'one' => q(වෙනිසියුලානු බොලිවර් \(2008–2018\)),
				'other' => q(වෙනිසියුලානු බොලිවර් \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(වෙනිසියුලානු බොලිවර්),
				'one' => q(වෙනිසියුලානු බොලිවර්),
				'other' => q(වෙනිසියුලානු බොලිවර්),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(වියට්නාම ඩොන්),
				'one' => q(වියට්නාම ඩොන්),
				'other' => q(වියට්නාම ඩොන්),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(වනුවාටු වාටු),
				'one' => q(වනුවාටු වාටු),
				'other' => q(වනුවාටු වාටු),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(සැමෝවා ටාලා),
				'one' => q(සැමෝවා ටාලා),
				'other' => q(සැමෝවා ටාලා),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(සිෆ්එ ෆ්රෑන්ක් බිඊඑසි),
				'one' => q(සිෆ්එ ෆ්රෑන්ක් බිඊඑසි),
				'other' => q(සිෆ්එ ෆ්රෑන්ක් බිඊඑසි),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(නැගෙනහිර කැරිබියානු ඩොලර්),
				'one' => q(නැගෙනහිර කැරිබියානු ඩොලර්),
				'other' => q(නැගෙනහිර කැරිබියානු ඩොලර්),
			},
		},
		'XOF' => {
			symbol => 'සිෆ්එ',
			display_name => {
				'currency' => q(සිෆ්එ ෆ්රෑන්ක් බිසීඊඑඔ),
				'one' => q(සිෆ්එ ෆ්රෑන්ක් බිසීඊඑඔ),
				'other' => q(සිෆ්එ ෆ්රෑන්ක් බිසීඊඑඔ),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ප්‍රංශ පොලිනීසියානු ෆ්‍රෑන්ක්),
				'one' => q(ප්‍රංශ පොලිනීසියානු ෆ්‍රෑන්ක්),
				'other' => q(ප්‍රංශ පොලිනීසියානු ෆ්‍රෑන්ක්),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(නොදත් මුදල්),
				'one' => q(නොදත් මුදල්),
				'other' => q(නොදත් මුදල්),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(යේමන රියාල්),
				'one' => q(යේමන රියාල්),
				'other' => q(යේමන රියාල්),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(දකුණු අප්‍රිකානු රැන්ඩ්),
				'one' => q(දකුණු අප්‍රිකානු රැන්ඩ්),
				'other' => q(දකුණු අප්‍රිකානු රැන්ඩ්),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(සැම්බියානු ක්වාචා \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(සැම්බියානු ක්වාචා),
				'one' => q(සැම්බියානු ක්වාචා),
				'other' => q(සැම්බියානු ක්වාචා),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ජන',
							'පෙබ',
							'මාර්තු',
							'අප්‍රේල්',
							'මැයි',
							'ජූනි',
							'ජූලි',
							'අගෝ',
							'සැප්',
							'ඔක්',
							'නොවැ',
							'දෙසැ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ජ',
							'පෙ',
							'මා',
							'අ',
							'මැ',
							'ජූ',
							'ජූ',
							'අ',
							'සැ',
							'ඔ',
							'නෙ',
							'දෙ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ජනවාරි',
							'පෙබරවාරි',
							'මාර්තු',
							'අප්‍රේල්',
							'මැයි',
							'ජූනි',
							'ජූලි',
							'අගෝස්තු',
							'සැප්තැම්බර්',
							'ඔක්තෝබර්',
							'නොවැම්බර්',
							'දෙසැම්බර්'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ජන',
							'පෙබ',
							'මාර්',
							'අප්‍රේල්',
							'මැයි',
							'ජූනි',
							'ජූලි',
							'අගෝ',
							'සැප්',
							'ඔක්',
							'නොවැ',
							'දෙසැ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ජ',
							'පෙ',
							'මා',
							'අ',
							'මැ',
							'ජූ',
							'ජූ',
							'අ',
							'සැ',
							'ඔ',
							'නෙ',
							'දෙ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ජනවාරි',
							'පෙබරවාරි',
							'මාර්තු',
							'අප්‍රේල්',
							'මැයි',
							'ජූනි',
							'ජූලි',
							'අගෝස්තු',
							'සැප්තැම්බර්',
							'ඔක්තෝබර්',
							'නොවැම්බර්',
							'දෙසැම්බර්'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'සඳුදා',
						tue => 'අඟහ',
						wed => 'බදාදා',
						thu => 'බ්‍රහස්',
						fri => 'සිකු',
						sat => 'සෙන',
						sun => 'ඉරිදා'
					},
					narrow => {
						mon => 'ස',
						tue => 'අ',
						wed => 'බ',
						thu => 'බ්‍ර',
						fri => 'සි',
						sat => 'සෙ',
						sun => 'ඉ'
					},
					short => {
						mon => 'සඳු',
						tue => 'අඟ',
						wed => 'බදා',
						thu => 'බ්‍රහ',
						fri => 'සිකු',
						sat => 'සෙන',
						sun => 'ඉරි'
					},
					wide => {
						mon => 'සඳුදා',
						tue => 'අඟහරුවාදා',
						wed => 'බදාදා',
						thu => 'බ්‍රහස්පතින්දා',
						fri => 'සිකුරාදා',
						sat => 'සෙනසුරාදා',
						sun => 'ඉරිදා'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'සඳුදා',
						tue => 'අඟහ',
						wed => 'බදාදා',
						thu => 'බ්‍රහස්',
						fri => 'සිකු',
						sat => 'සෙන',
						sun => 'ඉරිදා'
					},
					narrow => {
						mon => 'ස',
						tue => 'අ',
						wed => 'බ',
						thu => 'බ්‍ර',
						fri => 'සි',
						sat => 'සෙ',
						sun => 'ඉ'
					},
					short => {
						mon => 'සඳු',
						tue => 'අඟ',
						wed => 'බදා',
						thu => 'බ්‍රහ',
						fri => 'සිකු',
						sat => 'සෙන',
						sun => 'ඉරි'
					},
					wide => {
						mon => 'සඳුදා',
						tue => 'අඟහරුවාදා',
						wed => 'බදාදා',
						thu => 'බ්‍රහස්පතින්දා',
						fri => 'සිකුරාදා',
						sat => 'සෙනසුරාදා',
						sun => 'ඉරිදා'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'කාර්:1',
						1 => 'කාර්:2',
						2 => 'කාර්:3',
						3 => 'කාර්:4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1 වන කාර්තුව',
						1 => '2 වන කාර්තුව',
						2 => '3 වන කාර්තුව',
						3 => '4 වන කාර්තුව'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'කාර්:1',
						1 => 'කාර්:2',
						2 => 'කාර්:3',
						3 => 'කාර්:4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => '1 වන කාර්තුව',
						1 => '2 වන කාර්තුව',
						2 => '3 වන කාර්තුව',
						3 => '4 වන කාර්තුව'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'evening1' if $time >= 1400
						&& $time < 1800;
					return 'morning1' if $time >= 100
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1800
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'evening1' if $time >= 1400
						&& $time < 1800;
					return 'morning1' if $time >= 100
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1800
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'evening1' if $time >= 1400
						&& $time < 1800;
					return 'morning1' if $time >= 100
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1800
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'evening1' if $time >= 1400
						&& $time < 1800;
					return 'morning1' if $time >= 100
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1800
						&& $time < 2400;
					return 'night2' if $time >= 0
						&& $time < 100;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{දවල්},
					'am' => q{පෙ.ව.},
					'evening1' => q{හවස},
					'midnight' => q{මැදියම},
					'morning1' => q{පාන්දර},
					'morning2' => q{උදේ},
					'night1' => q{රෑ},
					'night2' => q{මැදියමට පසු},
					'noon' => q{මධ්‍යාහ්නය},
					'pm' => q{ප.ව.},
				},
				'narrow' => {
					'afternoon1' => q{ද},
					'am' => q{පෙ},
					'evening1' => q{හ},
					'midnight' => q{මැ},
					'morning1' => q{පා},
					'morning2' => q{උ},
					'night1' => q{රෑ},
					'night2' => q{මැ},
					'noon' => q{ම},
					'pm' => q{ප},
				},
				'wide' => {
					'afternoon1' => q{දවල්},
					'am' => q{පෙ.ව.},
					'evening1' => q{හවස},
					'midnight' => q{මැදියම},
					'morning1' => q{පාන්දර},
					'morning2' => q{උදේ},
					'night1' => q{රෑ},
					'night2' => q{මැදියමට පසු},
					'noon' => q{මධ්‍යාහ්නය},
					'pm' => q{ප.ව.},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{දවල්},
					'am' => q{පෙ.ව.},
					'evening1' => q{හවස},
					'midnight' => q{මැදියම},
					'morning1' => q{පාන්දර},
					'morning2' => q{උදේ},
					'night1' => q{රෑ},
					'night2' => q{මැදියමට පසු},
					'noon' => q{මධ්‍යාහ්නය},
					'pm' => q{ප.ව.},
				},
				'narrow' => {
					'afternoon1' => q{දවල්},
					'am' => q{පෙ.ව.},
					'evening1' => q{හවස},
					'midnight' => q{මැදියම},
					'morning1' => q{පාන්දර},
					'morning2' => q{උදේ},
					'night1' => q{රෑ},
					'night2' => q{මැදියමට පසු},
					'noon' => q{මධ්‍යාහ්නය},
					'pm' => q{ප.ව.},
				},
				'wide' => {
					'afternoon1' => q{දවල්},
					'am' => q{පෙ.ව.},
					'evening1' => q{හවස},
					'midnight' => q{මැදියම},
					'morning1' => q{පාන්දර},
					'morning2' => q{උදේ},
					'night1' => q{රෑ},
					'night2' => q{මැදියමට පසු},
					'noon' => q{මධ්‍යාහ්නය},
					'pm' => q{ප.ව.},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ක්‍රි.පූ.',
				'1' => 'ක්‍රි.ව.'
			},
			wide => {
				'0' => 'ක්‍රිස්තු පූර්ව',
				'1' => 'ක්‍රිස්තු වර්ෂ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{G y MMMM d, EEEE},
			'long' => q{G y MMMM d},
			'medium' => q{G y MMM d},
			'short' => q{GGGGG y-MM-dd},
		},
		'gregorian' => {
			'full' => q{y MMMM d, EEEE},
			'long' => q{y MMMM d},
			'medium' => q{y MMM d},
			'short' => q{y-MM-dd},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH.mm.ss zzzz},
			'long' => q{HH.mm.ss z},
			'medium' => q{HH.mm.ss},
			'short' => q{HH.mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			E => q{ccc},
			EBhm => q{E B h:mm},
			EBhms => q{E B h:mm:ss},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{M-d, E},
			MMM => q{LLL},
			MMMEd => q{MMM d E},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{M-d},
			d => q{d},
			h => q{a h},
			hm => q{a h.mm},
			hms => q{a h.mm.ss},
			ms => q{mm.ss},
			y => q{G y},
			yyyy => q{G y},
			yyyyM => q{G y-M},
			yyyyMEd => q{G y-M-d, E},
			yyyyMMM => q{G y MMM},
			yyyyMMMEd => q{G y MMM d, E},
			yyyyMMMM => q{G y MMMM},
			yyyyMMMd => q{G y MMM d},
			yyyyMd => q{G y-M-d},
			yyyyQQQ => q{G y QQQ},
			yyyyQQQQ => q{G y QQQQ},
		},
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH.mm},
			EHms => q{E HH.mm.ss},
			Ed => q{d E},
			Ehm => q{E a h.mm},
			Ehms => q{E a h.mm.ss},
			Gy => q{G y},
			GyMMM => q{G y MMM},
			GyMMMEd => q{G y MMM d, E},
			GyMMMd => q{G y MMM d},
			H => q{HH},
			Hm => q{HH.mm},
			Hms => q{HH.mm.ss},
			Hmsv => q{HH.mm.ss v},
			Hmv => q{HH.mm v},
			M => q{L},
			MEd => q{M-d, E},
			MMM => q{LLL},
			MMMEd => q{MMM d E},
			MMMMW => q{MMM සතිය W},
			MMMMd => q{MMMM d},
			MMMd => q{MMM d},
			Md => q{M-d},
			d => q{d},
			h => q{a h},
			hm => q{a h.mm},
			hms => q{a h.mm.ss},
			hmsv => q{h.mm.ss a v},
			hmv => q{h.mm a v},
			ms => q{mm.ss},
			y => q{y},
			yM => q{y-M},
			yMEd => q{y-M-d, E},
			yMMM => q{y MMM},
			yMMMEd => q{y MMM d, E},
			yMMMM => q{y MMMM},
			yMMMd => q{y MMM d},
			yMd => q{y-M-d},
			yQQQ => q{y QQQ},
			yQQQQ => q{y QQQQ},
			yw => q{Y සතිය w},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH.mm–HH.mm},
				m => q{HH.mm–HH.mm},
			},
			Hmv => {
				H => q{HH.mm–HH.mm v},
				m => q{HH.mm–HH.mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{M-d, E – M-d, E},
				d => q{M-d, E – M-d, E},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{MMM-dd, E – MMM-dd, E},
				d => q{MMM-d, E – MMM-d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{M-d – M-d},
				d => q{M-d – M-d},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{a h – a h},
				h => q{a h–h},
			},
			hm => {
				a => q{a h.mm – a h.mm},
				h => q{a h.mm – h.mm},
				m => q{a h.mm – h.mm},
			},
			hmv => {
				a => q{a h.mm – a hhh.mm v},
				h => q{a h.mm – h.mm v},
				m => q{a h.mm – h.mm v},
			},
			hv => {
				a => q{a h – a h v},
				h => q{a h – h vv},
			},
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{G y-M – y-M},
				y => q{G y-M – y-M},
			},
			yMEd => {
				M => q{G y-M-d, E – y-M-d, E},
				d => q{G y-M-d, E – y-M-d, E},
				y => q{G y-M-d, E – y-M-d, E},
			},
			yMMM => {
				M => q{G y MMM–MMM},
				y => q{G y MMM – y MMM},
			},
			yMMMEd => {
				M => q{G y MMM d, E – y MMM d, E},
				d => q{G y MMM d, E – y MMM d, E},
				y => q{G y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{G y MMMM – MMMM},
				y => q{G y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{G y MMM d – MMM d},
				d => q{G y MMM d – d},
				y => q{G y MMM d – y MMM d},
			},
			yMd => {
				M => q{G y-M-d – y-M-d},
				d => q{G y-M-d – y-M-d},
				y => q{G y-M-d – y-M-d},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH.mm–HH.mm},
				m => q{HH.mm–HH.mm},
			},
			Hmv => {
				H => q{HH.mm–HH.mm v},
				m => q{HH.mm–HH.mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{M-d, E – M-d, E},
				d => q{M-d, E – M-d, E},
			},
			MMM => {
				M => q{LLL–LLL},
			},
			MMMEd => {
				M => q{MMM-dd, E – MMM-dd, E},
				d => q{MMM-d, E – MMM-d, E},
			},
			MMMd => {
				M => q{MMM d – MMM d},
				d => q{MMM d–d},
			},
			Md => {
				M => q{M-d – M-d},
				d => q{M-d – M-d},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{a h – a h},
				h => q{a h–h},
			},
			hm => {
				a => q{a h.mm – a h.mm},
				h => q{a h.mm – h.mm},
				m => q{a h.mm – h.mm},
			},
			hmv => {
				a => q{a h.mm – a h.mm v},
				h => q{a h.mm – h.mm v},
				m => q{a h.mm – h.mm v},
			},
			hv => {
				a => q{a h – a h v},
				h => q{a h – h v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{y-MM – y-MM},
				y => q{y-MM – y-MM},
			},
			yMEd => {
				M => q{y-M-d, E – y-M-d, E},
				d => q{y-M-d, E – y-M-d, E},
				y => q{y-M-d, E – y-M-d, E},
			},
			yMMM => {
				M => q{y MMM–MMM},
				y => q{y MMM – y MMM},
			},
			yMMMEd => {
				M => q{y MMM d, E – y MMM d, E},
				d => q{y MMM d, E – y MMM d, E},
				y => q{y MMM d, E – y MMM d, E},
			},
			yMMMM => {
				M => q{y MMMM – MMMM},
				y => q{y MMMM – y MMMM},
			},
			yMMMd => {
				M => q{y MMM d – MMM d},
				d => q{y MMM d – d},
				y => q{y MMM d – y MMM d},
			},
			yMd => {
				M => q{y-M-d – y-M-d},
				d => q{y-M-d – y-M-d},
				y => q{y-M-d – y-M-d},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH.mm;-HH.mm),
		gmtFormat => q(ග්‍රිමවේ{0}),
		gmtZeroFormat => q(ග්‍රිමවේ),
		regionFormat => q({0} වේලාව),
		regionFormat => q({0} දිවාආලෝක වේලාව),
		regionFormat => q({0} සම්මත වේලාව),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#ඇෆ්ගනිස්ථාන වේලාව#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#අබිජාන්#,
		},
		'Africa/Accra' => {
			exemplarCity => q#අක්රා#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#අඩිස් අබාබා#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ඇල්ජියර්ස්#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#අස්මාරා#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#බමකො#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#බන්ගුයි#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#බන්ජුල්#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#බිසෝ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#බ්ලන්ටයර්#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#බ්‍රසාවිල්#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#බුජුම්බුරා#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#කයිරෝ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#කැසබ්ලන්කා#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#සෙයුටා#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#කොනක්‍රි#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ඩකර්#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#දාර් එස් සලාම්#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ජිබුටි#,
		},
		'Africa/Douala' => {
			exemplarCity => q#දෞඅලා#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#එල් ආයුන්#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ෆ්‍රීටවුන්#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ගැබරෝන්#,
		},
		'Africa/Harare' => {
			exemplarCity => q#හරාරේ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ජොහන්නස්බර්ග්#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ජුබා#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#කම්පාලා#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#කාර්ටොම්#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#කිගාලි#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#කින්ශාසා#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ලාගෝස්#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ලිබ්රවිල්#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ලෝම්#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ලුවන්ඩා#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ලුබුම්බාශි#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ලුසාකා#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#මලබෝ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#මපුටෝ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#මසේරු#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ම්බබානේ#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#මොගඩිෂු#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#මොන්රොවියා#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#නයිරෝබි#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ද්ජමෙනා#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#නියාමේ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#නුආක්චොට්#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ඔආගඩොගො#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#පොර්තෝ-නොවෝ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#සාඕ තෝම්#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ට්‍රිපොලි#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ටියුනිස්#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#වින්ඩ්හොඑක්#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#මධ්‍යම අප්‍රිකානු වේලාව#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#නැගෙනහිර අප්‍රිකානු වේලාව#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#දකුණු අප්‍රිකානු වේලාව#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#බටහිර අප්‍රිකානු ග්‍රීෂ්ම කාලය#,
				'generic' => q#බටහිර අප්‍රිකානු වේලාව#,
				'standard' => q#බටහිර අප්‍රිකානු සම්මත වේලාව#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#ඇලස්කා දිවාආලෝක වේලාව#,
				'generic' => q#ඇලස්කා වේලාව#,
				'standard' => q#ඇලස්කා සම්මත වේලාව#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ඇමර්සන් ග්‍රීෂ්ම කාලය#,
				'generic' => q#ඇමර්සන් වේලාව#,
				'standard' => q#ඇමර්සන් සම්මත වේලාව#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#ඇඩක්#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ඇනකොරාජ්#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ඇන්ගුයිලාව#,
		},
		'America/Antigua' => {
			exemplarCity => q#ඇන්ටිගුවා#,
		},
		'America/Araguaina' => {
			exemplarCity => q#ඇරගුඅයිනා#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ලා රිජෝලා#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#රියෝ ගලෙගොස්#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#සොල්ටා#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#සැන් ජුවාන්#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#සැන් ලුවිස්#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ටුකුමන්#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#උෂුඅයියා#,
		},
		'America/Aruba' => {
			exemplarCity => q#අරූබා#,
		},
		'America/Asuncion' => {
			exemplarCity => q#අසුන්සියොන්#,
		},
		'America/Bahia' => {
			exemplarCity => q#බහියා#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#බහියා බන්දෙරාස්#,
		},
		'America/Barbados' => {
			exemplarCity => q#බාබඩෝස්#,
		},
		'America/Belem' => {
			exemplarCity => q#බෙලෙම්#,
		},
		'America/Belize' => {
			exemplarCity => q#බෙලීස්#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#බ්ලැන්ක්-සැබ්ලන්#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#බොආ විස්ටා#,
		},
		'America/Bogota' => {
			exemplarCity => q#බොගොටා#,
		},
		'America/Boise' => {
			exemplarCity => q#බොයිසි#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#බුවනෝස් අයර්ස්#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#කේම්බ්‍රිජ් බොක්ක#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#කම්පෝ ග්‍රෑන්ඩ්#,
		},
		'America/Cancun' => {
			exemplarCity => q#කැන්කුන්#,
		},
		'America/Caracas' => {
			exemplarCity => q#කරකස්#,
		},
		'America/Catamarca' => {
			exemplarCity => q#කටමර්කා#,
		},
		'America/Cayenne' => {
			exemplarCity => q#කේයෙන්#,
		},
		'America/Cayman' => {
			exemplarCity => q#කේමන්#,
		},
		'America/Chicago' => {
			exemplarCity => q#චිකාගෝ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#චිහුආහුආ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ඇටිකොකන්#,
		},
		'America/Cordoba' => {
			exemplarCity => q#කොර්දොබා#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#කොස්ටරිකා#,
		},
		'America/Creston' => {
			exemplarCity => q#ක්‍රෙස්ටන්#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#කුයිඅබා#,
		},
		'America/Curacao' => {
			exemplarCity => q#කුරකාවෝ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ඩෙන්මාර්ක්ශව්න්#,
		},
		'America/Dawson' => {
			exemplarCity => q#ඩෝසන්#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ඩෝසන් ක්‍රීක්#,
		},
		'America/Denver' => {
			exemplarCity => q#ඩෙන්වර්#,
		},
		'America/Detroit' => {
			exemplarCity => q#ඩෙත්රුවා#,
		},
		'America/Dominica' => {
			exemplarCity => q#ඩොමිනිකා#,
		},
		'America/Edmonton' => {
			exemplarCity => q#එඩ්මන්ටන්#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#එයිරුනේප්#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#එල්සැල්වදෝර්#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ෆෝට් නෙල්සන්#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ෆොර්ටලේසා#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ග්ලේස් බොක්ක#,
		},
		'America/Godthab' => {
			exemplarCity => q#නූක්#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ගූස් බොක්ක#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ග්රෑන්ඩ් ටර්ක්#,
		},
		'America/Grenada' => {
			exemplarCity => q#ග්‍රැනඩා#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ග්වාඩ්ලෝප්#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ගෝතමාලාව#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ගුඅයාකුයිල්#,
		},
		'America/Guyana' => {
			exemplarCity => q#ගයනාව#,
		},
		'America/Halifax' => {
			exemplarCity => q#හලිෆැක්ස්#,
		},
		'America/Havana' => {
			exemplarCity => q#හවානා#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#හෙමොසිලෝ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#නොක්ස්, ඉන්දියානා#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#මරෙන්ගෝ, ඉන්දියානා#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#පීටර්ස්බර්ග්, ඉන්දියානා#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ටෙල් නගරය, ඉන්දියානා#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#වෙවේ, ඉන්දියානා#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#වින්සනස්, ඉන්දියානා#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#විනමැක්, ඉන්දියානා#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ඉන්ඩියානපොලිස්#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ඉනුවික්#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ඉකාලුයිට්#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ජැමෙයිකා#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ජුජුයි#,
		},
		'America/Juneau' => {
			exemplarCity => q#ජූනෝ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#මොන්ටිසෙලෝ, කෙන්ටකි#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ක්‍රලෙන්දිජ්ක්#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ලා පස්#,
		},
		'America/Lima' => {
			exemplarCity => q#ලීමා#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ලොස් ඇන්ජලීස්#,
		},
		'America/Louisville' => {
			exemplarCity => q#ලුවිස්විල්#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ලෝවර් ප්‍රින්සස් ක්වාටර්#,
		},
		'America/Maceio' => {
			exemplarCity => q#මසේයියෝ#,
		},
		'America/Managua' => {
			exemplarCity => q#මනගුආ#,
		},
		'America/Manaus' => {
			exemplarCity => q#මැනෝස්#,
		},
		'America/Marigot' => {
			exemplarCity => q#මැරිගොට්#,
		},
		'America/Martinique' => {
			exemplarCity => q#මාටිනික්#,
		},
		'America/Matamoros' => {
			exemplarCity => q#මටමොරොස්#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#මසට්ලාන්#,
		},
		'America/Mendoza' => {
			exemplarCity => q#මෙන්ඩෝසා#,
		},
		'America/Menominee' => {
			exemplarCity => q#මෙනොමිනී#,
		},
		'America/Merida' => {
			exemplarCity => q#මෙරිඩා#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#මෙට්ලකට්ලා#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#මෙක්සිකෝ නගරය#,
		},
		'America/Miquelon' => {
			exemplarCity => q#මිකියුලන්#,
		},
		'America/Moncton' => {
			exemplarCity => q#මොන්ක්ටන්#,
		},
		'America/Monterrey' => {
			exemplarCity => q#මොන්ටෙරේ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#මොන්ටෙවිඩියෝ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#මොන්ට්සේරාට්#,
		},
		'America/Nassau' => {
			exemplarCity => q#නස්සෝ#,
		},
		'America/New_York' => {
			exemplarCity => q#නිව්යෝක්#,
		},
		'America/Nipigon' => {
			exemplarCity => q#නිපිගන්#,
		},
		'America/Nome' => {
			exemplarCity => q#නෝම්#,
		},
		'America/Noronha' => {
			exemplarCity => q#නොරොන්හා#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#බියුලා, උතුරු ඩකෝටා#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#මධ්‍යම, උතුරු ඩකෝටා#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#නව සලෙම්ම, උතුරු ඩකෝටා#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ඔජිනගා#,
		},
		'America/Panama' => {
			exemplarCity => q#පැනමා#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#පැන්නීටන්#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#පැරාමරිබෝ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ෆීනික්ස්#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#පොර්ට්-ඕ-ප්‍රින්ස්#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#පොර්ට් ඔෆ් ස්පෙයින්#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#පොර්තෝ වෙල්හෝ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#පුවටොරිකෝව#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#පුන්ටා ඇරිනාස්#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#රෙයිනි ගඟ#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#රැන්කින් පිවිසුම#,
		},
		'America/Recife' => {
			exemplarCity => q#රෙසිෆ්#,
		},
		'America/Regina' => {
			exemplarCity => q#රෙජිනා#,
		},
		'America/Resolute' => {
			exemplarCity => q#රෙසොලුට්#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#රියෝ බ්‍රන්කෝ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#සැන්ටා ඉසබෙල්#,
		},
		'America/Santarem' => {
			exemplarCity => q#සන්ටරේම්#,
		},
		'America/Santiago' => {
			exemplarCity => q#සන්තියාගෝ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#සැන්ටෝ ඩොමින්ගෝ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#සාවෝ පෝලො#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ඉටොකොර්ටෝමිට්#,
		},
		'America/Sitka' => {
			exemplarCity => q#සිට්කා#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ශාන්ත බර්තලෙමි#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ශාන්ත ජෝන්ගේ#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#ශාන්ත කිට්ස්#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#ශාන්ත ලුසියා#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#ශාන්ත තෝමස්#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#ශාන්ත වින්ට්සන්#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ස්විෆ්ට් කරන්ට්#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ටෙගුසිගල්පා#,
		},
		'America/Thule' => {
			exemplarCity => q#තුලේ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#තන්ඩර් බොක්ක#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ටිජුආනා#,
		},
		'America/Toronto' => {
			exemplarCity => q#ටොරන්ටෝ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ටොර්ටෝලා#,
		},
		'America/Vancouver' => {
			exemplarCity => q#වැන්කුවර්#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#වයිට්හෝර්ස්#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#විනිපෙග්#,
		},
		'America/Yakutat' => {
			exemplarCity => q#යකුටට්#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#යෙලෝනයිෆ්#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#උතුරු ඇමරිකානු මධ්‍යම දිවාආලෝක වේලාව#,
				'generic' => q#උතුරු ඇමරිකානු මධ්‍යම වේලාව#,
				'standard' => q#උතුරු ඇමරිකානු මධ්‍යම සම්මත වේලාව#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#උතුරු ඇමරිකානු නැගෙනහිර දිවාආලෝක වේලාව#,
				'generic' => q#උතුරු ඇමරිකානු නැගෙනහිර වේලාව#,
				'standard' => q#උතුරු ඇමරිකානු නැගෙනහිර සම්මත වේලාව#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#උතුරු ඇමරිකානු කඳුකර දිවාආලෝක වේලාව#,
				'generic' => q#උතුරු ඇමරිකානු කඳුකර වේලාව#,
				'standard' => q#උතුරු ඇමරිකානු කඳුකර සම්මත වේලාව#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#උතුරු ඇමරිකානු පැසිෆික් දිවාආලෝක වේලාව#,
				'generic' => q#උතුරු ඇමරිකානු පැසිෆික් වේලාව#,
				'standard' => q#උතුරු ඇමරිකානු පැසිෆික් සම්මත වේලාව#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#කැසේ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ඩේවිස්#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ඩුමොන්ට් ඩු‘ර්විල්#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#මක්කුවරි#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#මව්සන්#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#මැක්මුර්ඩෝ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#පැල්මර්#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#රොතෙරා#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#සියෝවා#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ට්‍රෝල්#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#වොස්ටොක්#,
		},
		'Apia' => {
			long => {
				'daylight' => q#අපියා දිවා වේලාව#,
				'generic' => q#අපියා වේලාව#,
				'standard' => q#අපියා සම්මත වේලාව#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#අරාබි දහවල් වේලාව#,
				'generic' => q#අරාබි වේලාව#,
				'standard' => q#අරාබි සම්මත වේලාව#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ලෝන්ග්ඉයර්බියෙන්#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ආර්ජන්ටිනා ග්‍රීෂ්ම කාලය#,
				'generic' => q#ආර්ජන්ටිනා වේලාව#,
				'standard' => q#ආර්ජන්ටිනා සම්මත වේලාව#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#බටහිර ආර්ජන්ටිනා ග්‍රීෂ්ම කාලය#,
				'generic' => q#බටහිර ආර්ජන්ටිනා වේලාව#,
				'standard' => q#බටහිර ආර්ජන්ටිනා සම්මත වේලාව#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#ආමේනියානු ග්‍රීෂ්ම වේලාව#,
				'generic' => q#ආමේනියානු වේලාව#,
				'standard' => q#ආමේනියානු සම්මත වේලාව#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ඒඩ්න්#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#අල්මටි#,
		},
		'Asia/Amman' => {
			exemplarCity => q#අම්මාන්#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#ඇනාදිය්ර්#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#අක්ටෝ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#අක්ටෝබ්#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#අශ්ගබැට්#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#ඇටිරවු#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#බැග්ඩෑඩ්#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#බහරේන්#,
		},
		'Asia/Baku' => {
			exemplarCity => q#බාකු#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#බැංකොක්#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#බර්නෞල්#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#බීරුට්#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#බිශ්කෙක්#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#බෲනායි#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#කල්කටා#,
		},
		'Asia/Chita' => {
			exemplarCity => q#චිටා#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#චොයිබල්සාන්#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#කොළඹ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ඩැමස්කස්#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ඩකා#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ඩිලි#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ඩුබායි#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ඩුශන්බේ#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ෆැමගුස්ටා#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ගාසා#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#හෙබ්රෝන්#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#හොංකොං#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#හොව්ඩ්#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ඉරකුට්ස්ක්#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ජකර්තා#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ජයපුර#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ජෙරුසලම#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#කාබුල්#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#කම්චට්කා#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#කරච්චිචි#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#කත්මන්ඩු#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ඛන්ඩිගා#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ක්‍රස්නෝයාර්ස්ක්#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ක්වාලාලම්පූර්#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#කුචිං#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#කුවේට්#,
		},
		'Asia/Macau' => {
			exemplarCity => q#මැකාවු#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#මගඩන්#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#මක්ස්සාර්#,
		},
		'Asia/Manila' => {
			exemplarCity => q#මැනිලා#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#මස්කට්#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#නිකෝසියා#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#නොවොකුස්නේට්ස්ක්#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#නොවොසිබර්ස්ක්#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ඔම්ස්ක්#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ඔරාල්#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#නොම් පෙන්#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#පොන්ටියනක්#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ප්යෝන්ග්යැන්ග්#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#කටාර්#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ක්යිසිලෝර්ඩා#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#රැංගුන්#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#රියාද්#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#හෝචි මිං නගරය#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#සක්හලින්#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#සාමාර්කන්ඩ්#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#සෝල්#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ෂැන්හයි#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#සිංගප්පූරුව#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#ශ්‍රෙඩ්නෙකෝලිම්සක්#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#තායිපෙ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ටෂ්කෙන්ට්#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#ට්බිලිසි#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ටෙහෙරාන්#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#තිම්පු#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ටෝකියෝ#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ටොම්ස්ක්#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#උලාන්බාටර්#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#උරුම්කි#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#උස්ට්-නෙරා#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#වියැන්ටියන්#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ව්ලඩිවොස්ටොක්#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#යකුට්ස්ක්#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#යෙකටරින්බර්ග්#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#යෙරෙවන්#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#අත්ලාන්තික් දිවාආලෝක වේලාව#,
				'generic' => q#අත්ලාන්තික් වේලාව#,
				'standard' => q#අත්ලාන්තික් සම්මත වේලාව#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ඇසොරේ#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#බර්මියුඩා#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#කැනරි#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#කේප් වර්ඩ්#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ෆාරෝ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#මඩෙයිරා#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#රෙයික්ජාවික්#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#දකුණු ජෝර්ජියාව#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#ශා. හෙලේනා#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ස්ටැන්ලි#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ඇඩිලේඩ්#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#බ්‍රිස්බේන්#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#බ්‍රෝකන් හිල්#,
		},
		'Australia/Currie' => {
			exemplarCity => q#කුරී#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ඩාවින්#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ඉයුක්ලා#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#හෝබාර්ට්#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ලින්ඩේමන්#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ලෝර්ඩ් හෝව්#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#මෙල්බෝර්න්#,
		},
		'Australia/Perth' => {
			exemplarCity => q#පර්ත්#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#සිඩ්නි#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#මධ්‍යම ඔස්ට්‍රේලියානු දහවල් වේලාව#,
				'generic' => q#මධ්‍යම ඕස්ට්‍රේලියානු වේලාව#,
				'standard' => q#ඕස්ට්‍රේලියානු සම්මත වේලාව#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#මධ්‍යම බටහිර ඔස්ට්‍රේලියානු දහවල් වේලාව#,
				'generic' => q#මධ්‍යම බටහිර ඔස්ට්‍රේලියානු වේලාව#,
				'standard' => q#මධ්‍යම බටහිර ඔස්ට්‍රේලියානු සම්මත වේලාව#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#නැඟෙනහිර ඕස්ට්‍රේලියානු දහවල් වේලාව#,
				'generic' => q#නැගෙනහිර ඕස්ට්‍රේලියානු වේලාව#,
				'standard' => q#නැගෙනහිර ඕස්ට්‍රේලියානු සම්මත වේලාව#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#බටහිර ඔස්ට්‍රේලියානු දහවල් වේලාව#,
				'generic' => q#බටහිර ඕස්ට්‍රේලියානු වේලාව#,
				'standard' => q#බටහිර ඕස්ට්‍රේලියානු සම්මත වේලාව#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#අසර්බයිජාන් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#අසර්බයිජාන් වේලාව#,
				'standard' => q#අසර්බයිජාන් සම්මත වේලාව#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ඇසොර්ස් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#ඇසොර්ස් වේලාව#,
				'standard' => q#ඇසොර්ස් සම්මත වේලාව#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#බංගලාදේශ ග්‍රීෂ්ම කාලය#,
				'generic' => q#බංගලාදේශ වේලාව#,
				'standard' => q#බංගලාදේශ සම්මත වේලාව#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#භුතාන වේලාව#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#බොලිවියා වේලාව#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#බ්‍රසීල ග්‍රීෂ්ම කාලය#,
				'generic' => q#බ්‍රසීල වේලාව#,
				'standard' => q#බ්‍රසීල සම්මත වේලාව#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#බෘනායි දරුස්සලාම් වේලාව#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#කේප්වේඩ් ග්‍රීෂ්ම කාලය#,
				'generic' => q#කේප්වේඩ් වේලාව#,
				'standard' => q#කේප්වේඩ් සම්මත වේලාව#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#චමොරෝ වේලාව#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#චැතම් දිවා වේලාව#,
				'generic' => q#චැතම් වේලාව#,
				'standard' => q#චැතම් සම්මත වේලාව#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#චිලී ග්‍රීෂ්ම කාලය#,
				'generic' => q#චිලී වේලාව#,
				'standard' => q#චිලී සම්මත වේලාව#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#චීන දහවල් වේලාව#,
				'generic' => q#චීන වේලාව#,
				'standard' => q#චීන සම්මත වේලාව#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#චොයිබල්සාන් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#චොයිබල්සාන් වේලාව#,
				'standard' => q#චොයිබල්සාන් සම්මත වේලාව#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ක්‍රිස්මස් දුපත් වේලාව#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#කොකෝස් දුපත් වේලාව#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#කොලොම්බියා ග්‍රීෂ්ම කාලය#,
				'generic' => q#කොලොම්බියා වේලාව#,
				'standard' => q#කොලොම්බියා සම්මත වේලාව#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#කුක් දුපත් භාග ග්‍රීෂ්ම වේලාව#,
				'generic' => q#කුක් දුපත් වේලාව#,
				'standard' => q#කුක් දුපත් සම්මත වේලාව#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#කියුබානු දිවාආලෝක වේලාව#,
				'generic' => q#කියුබානු වේලාව#,
				'standard' => q#කියුබානු සම්මත වේලාව#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ඩාවිස් වේලාව#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#දුමොන්ත්-ඩ්උර්විල් වේලාව#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#නැගෙනහිර ටිමෝර් වේලාව#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ඊස්ටර් දූපත් ග්‍රීෂ්ම කාලය#,
				'generic' => q#ඊස්ටර් දූපත් වේලාව#,
				'standard' => q#ඊස්ටර් දූපත් සම්මත වේලාව#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ඉක්වදෝර් වේලාව#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#සමකක්ෂ සාර්ව වේලාව#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#හඳුනා නොගත් නගරය#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ඇම්ස්ටර්ඩෑම්#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ඇන්ඩෝරාව#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#අස්ට්‍රඛාන්#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ඇතැන්ස්#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#බෙල්ග්‍රේඩ්ඩ්#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#බර්ලින්#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#බ්‍රටිස්ලවා#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#බ්‍රසල්ස්#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#බුකාරෙස්ට්#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#බුඩාපෙස්ට්#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#බුසින්ජෙන්#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#චිසිනෝ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#කෝපන්හේගන්#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ඩබ්ලින්#,
			long => {
				'daylight' => q#අයර්ලන්ත සම්මත වේලාව#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ජිබ්රෝල්ටා#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ගුවන්සේ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#හෙල්සින්කි#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#අයිල් ඔෆ් මෑන්#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ඉස්තාන්බුල්#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ජර්සි#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#කලිනින්ග්‍රෑඩ්#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#කිව්#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#කිරොව්#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ලිස්බන්#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ල්ජුබුල්ජනා#,
		},
		'Europe/London' => {
			exemplarCity => q#ලන්ඩන්#,
			long => {
				'daylight' => q#බ්‍රිතාන්‍ය ගිම්හාන වේලාව#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ලක්සැම්බර්ග්#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#මැඩ්රිඩ්#,
		},
		'Europe/Malta' => {
			exemplarCity => q#මෝල්ටා#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#මරියෙහම්න්#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#මින්ස්ක්#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#මොනැකෝ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#මොස්කව්#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ඔස්ලෝ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#පැරිස්#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#පොඩ්ගොරිකා#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ප්‍රෙග්#,
		},
		'Europe/Riga' => {
			exemplarCity => q#රිගා#,
		},
		'Europe/Rome' => {
			exemplarCity => q#රෝමය#,
		},
		'Europe/Samara' => {
			exemplarCity => q#සමරා#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#සැන් මැරිනෝ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#සරාජෙවෝ#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#සරටොව්#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#සිම්ෆෙරෝපොල්#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#ස්කොප්ජේ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#සොෆියා#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ස්ටොක්හෝම්#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ටලින්#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ටිරානේ#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#උල්යනොව්ස්ක්#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#උස්ගොරෝඩ්#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#වඩුස්#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#වතිකානුව#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#වියනා#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#විල්නියුස්#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#වොල්ගොග්‍රෑඩ්#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#වර්සෝ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#සග්රෙබ්#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#සපොරෝසියේ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#සූරිච්#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#මධ්‍යම යුරෝපීය ග්‍රීෂ්ම වේලාව#,
				'generic' => q#මධ්‍යම යුරෝපීය වේලාව#,
				'standard' => q#මධ්‍යම යුරෝපීය සම්මත වේලාව#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#නැගෙනහිර යුරෝපීය ග්‍රීෂ්ම වේලාව#,
				'generic' => q#නැගෙනහිර යුරෝපීය වේලාව#,
				'standard' => q#නැගෙනහිර යුරෝපීය සම්මත වේලාව#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#තවත්-නැගෙනහිර යුරෝපීය වේලාව#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#බටහිර යුරෝපීය ග්‍රීෂ්ම වේලාව#,
				'generic' => q#බටහිර යුරෝපීය වේලාව#,
				'standard' => q#බටහිර යුරෝපීය සම්මත වේලාව#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#ෆෝක්ලන්ඩ් දූපත් ග්‍රීෂ්ම කාලය#,
				'generic' => q#ෆෝක්ලන්ඩ් දූපත් වේලාව#,
				'standard' => q#ෆෝක්ලන්ඩ් දූපත් සම්මත වේලාව#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#ෆිජි ග්‍රීෂ්ම වේලාව#,
				'generic' => q#ෆිජි වේලාව#,
				'standard' => q#ෆිජි සම්මත වේලාව#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#ප්‍රංශ ගයනා වේලාව#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#ප්‍රංශ දකුණුදිග සහ ඇන්ටාර්ක්ටික් වේලාව#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ග්‍රිනිච් මධ්‍යම වේලාව#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#ගලපගොස් වේලාව#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#ගැම්බියර් වේලාව#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#ජෝර්ජියානු ග්‍රීෂ්ම වේලාව#,
				'generic' => q#ජෝර්ජියානු වේලාව#,
				'standard' => q#ජෝර්ජියානු සම්මත වේලාව#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#ගිල්බර්ට් දුපත් වේලාව#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#නැගෙනහිර ග්‍රීන්ලන්ත ග්‍රීෂ්ම කාලය#,
				'generic' => q#නැගෙනහිර ග්‍රීන්ලන්ත වේලාව#,
				'standard' => q#නැගෙනහිර ග්‍රීන්ලන්ත සම්මත වේලාව#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#බටහිර ග්‍රීන්ලන්ත ග්‍රීෂ්ම කාලය#,
				'generic' => q#බටහිර ග්‍රීන්ලන්ත වේලාව#,
				'standard' => q#බටහිර ග්‍රීන්ලන්ත සම්මත වේලාව#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#ගල්ෆ් වේලාව#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#ගයනා වේලාව#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#හවායි-අලෙයුතියාන් දිවාආලෝක වේලාව#,
				'generic' => q#හවායි-අලෙයුතියාන් වේලාව#,
				'standard' => q#හවායි-අලෙයුතියාන් සම්මත වේලාව#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#හොංකොං ග්‍රීෂ්ම වේලාව#,
				'generic' => q#හොංකොං වේලාව#,
				'standard' => q#හොංකොං සම්මත වේලාව#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#හොව්ඩ් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#හොව්ඩ් වේලාව#,
				'standard' => q#හොව්ඩ් සම්මත වේලාව#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ඉන්දියානු වේලාව#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ඇන්ටනානරිවෝ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#චාගොස්#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ක්‍රිස්මස්#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#කොකොස්#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#කොමොරෝ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#කෙර්ගුඑලෙන්#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#මාහේ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#මාල දිවයින#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#මුරුසිය#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#මයෝටි#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#රියුනියන්#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ඉන්දියන් සාගර වේලාව#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ඉන්දුචීන වේලාව#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#මධ්‍යම ඉන්දුනීසියානු වේලාව#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#නැගෙනහිර ඉන්දුනීසියානු වේලාව#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#බටහිර ඉන්දුනීසියානු වේලාව#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ඉරාන දිවා කාලය#,
				'generic' => q#ඉරාන වේලාව#,
				'standard' => q#ඉරාන සම්මත වේලාව#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ඉර්කුට්ස්ක් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#ඉර්කුට්ස්ක් වේලාව#,
				'standard' => q#ඉර්කුට්ස්ක් සම්මත වේලාව#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ඊශ්‍රායල දහවල් වේලාව#,
				'generic' => q#ඊශ්‍රායල වේලාව#,
				'standard' => q#ඊශ්‍රායල සම්මත වේලාව#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#ජපාන දහවල් වේලාව#,
				'generic' => q#ජපාන වේලාව#,
				'standard' => q#ජපාන සම්මත වේලාව#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#නැගෙනහිර කසකස්තාන වේලාව#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#බටහිර කසකස්තාන වේලාව#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#කොරියානු දහවල් වේලාව#,
				'generic' => q#කොරියානු වේලාව#,
				'standard' => q#කොරියානු සම්මත වේලාව#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#කොස්රේ වේලාව#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#ක්‍රස්නොයාර්ස්ක් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#ක්‍රස්නොයාර්ස්ක් වේලාව#,
				'standard' => q#ක්‍රස්නොයාර්ස්ක් සම්මත වේලාව#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#කිර්ගිස්තාන වේලාව#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#ශ්‍රී ලංකා වේලාව#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#ලයින් දුපත් වේලාව#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#ලෝර්ඩ් හෝව් දිවා වේලාව#,
				'generic' => q#ලෝර්ඩ් හෝව් වේලාව#,
				'standard' => q#ලෝර්ඩ් හෝව් සම්මත වේලාව#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#මැක්කුඅරි දුපත් වේලාව#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#මෙගඩන් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#මෙගඩන් වේලාව#,
				'standard' => q#මෙගඩන් සම්මත වේලාව#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#මැලේසියානු වේලාව#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#මාලදිවයින් වේලාව#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#මාර්කුඑසාස් වේලාව#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#මාර්ෂල් දුපත් වේලාව#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#මුරුසි ග්‍රීෂ්ම කාලය#,
				'generic' => q#මුරුසි වේලාව#,
				'standard' => q#මුරුසි සම්මත වේලාව#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#මොව්සන් වේලාව#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#වයඹ මෙක්සිකෝ දිවාආලෝක වේලාව#,
				'generic' => q#වයඹ මෙක්සිකෝ වේලාව#,
				'standard' => q#වයඹ මෙක්සිකෝ සම්මත වේලාව#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#මෙක්සිකෝ පැසිෆික් දිවාආලෝක වේලාව#,
				'generic' => q#මෙක්සිකෝ පැසිෆික් වේලාව#,
				'standard' => q#මෙක්සිකෝ පැසිෆික් සම්මත වේලාව#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#උලාන් බාටර් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#උලාන් බාටර් වේලාව#,
				'standard' => q#උලාන් බාටර් සම්මත වේලාව#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#මොස්කව් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#මොස්කව් වේලාව#,
				'standard' => q#මොස්කව් සම්මත වේලාව#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#මියන්මාර් වේලාව#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#නාවුරු වේලාව#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#නේපාල වේලාව#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#නව සෙලඩොනියානු ග්‍රීෂ්ම වේලාව#,
				'generic' => q#නව සෙලඩොනියානු වේලාව#,
				'standard' => q#නව සෙලඩොනියානු සම්මත වේලාව#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#නවසීලන්ත දිවා වේලාව#,
				'generic' => q#නවසීලන්ත වේලාව#,
				'standard' => q#නවසීලන්ත සම්මත වේලාව#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#නිව්ෆවුන්ලන්ත දිවාආලෝක වේලාව#,
				'generic' => q#නිව්ෆවුන්ලන්ත වේලාව#,
				'standard' => q#නිව්ෆවුන්ලන්ත සම්මත වේලාව#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#නියු වේලාව#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#නොෆොල්ක් දුපත් වේලාව#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ෆර්නැන්ඩෝ ඩි නොරොන්හා ග්‍රීෂ්ම කාලය#,
				'generic' => q#ෆර්නැන්ඩෝ ඩි නොරොන්හා වේලාව#,
				'standard' => q#ෆර්නැන්ඩෝ ඩි නොරොන්හා සම්මත වේලාව#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#නොවසිබිර්ස්ක් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#නොවසිබිර්ස්ක් වේලාව#,
				'standard' => q#නොවසිබිර්ස්ක් සම්මත වේලාව#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ඔම්ස්ක් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#ඔම්ස්ක් වේලාව#,
				'standard' => q#ඔම්ස්ක් සම්මත වේලාව#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ඇපියා#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ඕක්ලන්ඩ්#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#බෝගන්විලා#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#චැතම්#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ඊස්ටර්#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#එෆාත්#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#එන්ඩර්බරි#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ෆාකාඕෆෝ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ෆීජි#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ෆුනෆුටි#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ගලපගෝස්#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ගම්බියෙර්#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ගුවාඩල්කැනල්#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ගුවාම්#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#හොනොලුලු#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ජොන්ස්ටන්#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#කිරිමටි#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#කොස්රේ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ක්වාජලෙයින්#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#මජුරෝ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#මාකුවෙසාස්#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#මිඩ්වේ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#නවුරු#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#නියු#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#නෝෆෝක්#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#නෝමියා#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#පගෝ පගෝ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#පලාවු#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#පිට්කෙයාන්#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#පොන්පෙයි#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#පොර්ට් මොරෙස්බි#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#රරෝටෝන්ගා#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#සයිපාන්#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ටහිති#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ටරාවා#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ටොන්ගටාපු#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#චූක්#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#වේක්#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#වැලිස්#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#පාකිස්ථාන ග්‍රීෂ්ම කාලය#,
				'generic' => q#පාකිස්ථාන වේලාව#,
				'standard' => q#පාකිස්ථාන සම්මත වේලාව#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#පලාවු වේලාව#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#පැපුවා නිව් ගිනීයා වේලාව#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#පැරගුවේ ග්‍රීෂ්ම කාලය#,
				'generic' => q#පැරගුවේ වේලාව#,
				'standard' => q#පැරගුවේ සම්මත වේලාව#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#පේරු ග්‍රීෂ්ම කාලය#,
				'generic' => q#පේරු වේලාව#,
				'standard' => q#පේරු සම්මත වේලාව#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#පිලිපීන ග්‍රීෂ්ම වේලාව#,
				'generic' => q#පිලිපීන වේලාව#,
				'standard' => q#පිලිපීන සම්මත වේලාව#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ෆීනික්ස් දුපත් වේලාව#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#ශාන්ත පියරේ සහ මැකෝලන් දිවාආලෝක වේලාව#,
				'generic' => q#ශාන්ත පියරේ සහ මැකෝලන් වේලාව#,
				'standard' => q#ශාන්ත පියරේ සහ මැකෝලන් සම්මත වේලාව#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#පිට්කෙයාන් වේලාව#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#පොනපේ වේලාව#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#ප්යොන්ග්යන් වේලාව#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#රියුනියන් වේලාව#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#රොතෙරා වේලාව#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#සඛලින් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#සඛලින් වේලාව#,
				'standard' => q#සඛලින් සම්මත වේලාව#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#සැමෝවා ග්‍රීෂ්ම වේලාව#,
				'generic' => q#සැමෝවා වේලාව#,
				'standard' => q#සැමෝවා සම්මත වේලාව#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#සීෂෙල්ස් වේලාව#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#සිංගප්පුරු වේලාව#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#සොලොමන් දූපත් වේලාව#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#දකුණු ජෝජියා වේලාව#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#සුරිනාම වේලාව#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#ස්යෝවා වේලාව#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#ටාහිටි වේලාව#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#තායිපේ දහවල් වේලාව#,
				'generic' => q#තායිපේ වේලාව#,
				'standard' => q#තායිපේ සම්මත වේලාව#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ටජිකිස්තාන වේලාව#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ටොකෙලාවු වේලාව#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ටොංගා ග්‍රීෂ්ම වේලාව#,
				'generic' => q#ටොංගා වේලාව#,
				'standard' => q#ටොංගා සම්මත වේලාව#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#චුක් වේලාව#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#ටර්ක්මෙනිස්තාන ග්‍රීෂ්ම වේලාව#,
				'generic' => q#ටර්ක්මෙනිස්තාන වේලාව#,
				'standard' => q#ටර්ක්මෙනිස්තාන සම්මත වේලාව#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ටුවාලු වේලාව#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#උරුගුවේ ග්‍රීෂ්ම කාලය#,
				'generic' => q#උරුගුවේ වේලාව#,
				'standard' => q#උරුගුවේ සම්මත වේලාව#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#උස්බෙකිස්තාන ග්‍රීෂ්ම වේලාව#,
				'generic' => q#උස්බෙකිස්තාන වේලාව#,
				'standard' => q#උස්බෙකිස්තාන සම්මත වේලාව#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#වනුආටු ගිම්හාන වේලාව#,
				'generic' => q#වනුආටු වේලාව#,
				'standard' => q#වනුආටු සම්මත වේලාව#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#වෙනිසියුලා වේලාව#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ව්ලදිවෝස්ටෝක් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#ව්ලදිවෝස්ටෝක් වේලාව#,
				'standard' => q#ව්ලදිවෝස්ටෝක් සම්මත වේලාව#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#වොල්ගොග්‍රාඩ් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#වොල්ගොග්‍රාඩ් වේලාව#,
				'standard' => q#වොල්ගොග්‍රාඩ් සම්මත වේලාව#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#වොස්ටොක් වේලාව#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#වේක් දූපත් වේලාව#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#වැලිස් සහ ෆුටුනා වේලාව#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#යකුට්ස්ක් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#යකුට්ස්ක් වේලාව#,
				'standard' => q#යකුට්ස්ක් සම්මත වේලාව#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#යෙකටෙරින්බර්ග් ග්‍රීෂ්ම වේලාව#,
				'generic' => q#යෙකටෙරින්බර්ග් වේලාව#,
				'standard' => q#යෙකටෙරින්බර්ග් සම්මත වේලාව#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
