=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Ml - Package for language Malayalam

=cut

package Locale::CLDR::Locales::Ml;
# This file auto generated from Data\common\main\ml.xml
#	on Fri 28 Jun  8:55:56 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.45.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'അഫാർ',
 				'ab' => 'അബ്‌ഖാസിയൻ',
 				'ace' => 'അചിനീസ്',
 				'ach' => 'അകോലി',
 				'ada' => 'അഡാങ്‌മി',
 				'ady' => 'അഡൈഗേ',
 				'ae' => 'അവസ്റ്റാൻ',
 				'af' => 'ആഫ്രിക്കാൻസ്',
 				'afh' => 'ആഫ്രിഹിലി',
 				'agq' => 'ആഘേം',
 				'ain' => 'ഐനു',
 				'ak' => 'അകാൻ‌',
 				'akk' => 'അക്കാഡിയൻ',
 				'ale' => 'അലൂട്ട്',
 				'alt' => 'തെക്കൻ അൾത്തായി',
 				'am' => 'അംഹാരിക്',
 				'an' => 'അരഗോണീസ്',
 				'ang' => 'പഴയ ഇംഗ്ലീഷ്',
 				'ann' => 'ഒബോളോ',
 				'anp' => 'ആൻഗിക',
 				'ar' => 'അറബിക്',
 				'ar_001' => 'ആധുനിക സ്റ്റാൻഡേർഡ് അറബിക്',
 				'arc' => 'അരമായ',
 				'arn' => 'മാപുചി',
 				'arp' => 'അറാപഹോ',
 				'ars' => 'നജ്‌ദി അറബിക്',
 				'arw' => 'അറാവക്',
 				'as' => 'ആസ്സാമീസ്',
 				'asa' => 'ആസു',
 				'ast' => 'അസ്ട്ടൂരിയൻ',
 				'atj' => 'അറ്റികമെക്‌വ്',
 				'av' => 'അവാരിക്',
 				'awa' => 'അവാധി',
 				'ay' => 'അയ്മാറ',
 				'az' => 'അസർബൈജാനി',
 				'az@alt=short' => 'അസേരി',
 				'ba' => 'ബഷ്ഖിർ',
 				'bal' => 'ബലൂചി',
 				'ban' => 'ബാലിനീസ്',
 				'bas' => 'ബാസ',
 				'bax' => 'ബാമുൻ',
 				'bbj' => 'ഘോമാല',
 				'be' => 'ബെലാറുഷ്യൻ',
 				'bej' => 'ബേജ',
 				'bem' => 'ബേംബ',
 				'bez' => 'ബെനാ',
 				'bfd' => 'ബാഫട്ട്',
 				'bg' => 'ബൾഗേറിയൻ',
 				'bgc' => 'ഹർയാൻവി',
 				'bgn' => 'പശ്ചിമ ബലൂചി',
 				'bho' => 'ഭോജ്‌പുരി',
 				'bi' => 'ബിസ്‌ലാമ',
 				'bik' => 'ബികോൽ',
 				'bin' => 'ബിനി',
 				'bkm' => 'കോം',
 				'bla' => 'സിക്സിക',
 				'bm' => 'ബംബാറ',
 				'bn' => 'ബംഗ്ലാ',
 				'bo' => 'ടിബറ്റൻ',
 				'br' => 'ബ്രെട്ടൺ',
 				'bra' => 'ബ്രജ്',
 				'brx' => 'ബോഡോ',
 				'bs' => 'ബോസ്നിയൻ',
 				'bss' => 'അക്കൂസ്',
 				'bua' => 'ബുറിയത്ത്',
 				'bug' => 'ബുഗിനീസ്',
 				'bum' => 'ബുളു',
 				'byn' => 'ബ്ലിൻ',
 				'byv' => 'മെഡുംബ',
 				'ca' => 'കറ്റാലാൻ',
 				'cad' => 'കാഡോ',
 				'car' => 'കാരിബ്',
 				'cay' => 'കയൂഗ',
 				'cch' => 'അറ്റ്സാം',
 				'ccp' => 'ചക്‌മ',
 				'ce' => 'ചെചൻ',
 				'ceb' => 'സെബുവാനോ',
 				'cgg' => 'ചിഗ',
 				'ch' => 'ചമോറോ',
 				'chb' => 'ചിബ്ച',
 				'chg' => 'ഷാഗതായ്',
 				'chk' => 'ചൂകീസ്',
 				'chm' => 'മാരി',
 				'chn' => 'ചിനൂഗ് ജാർഗൺ',
 				'cho' => 'ചോക്റ്റാവ്',
 				'chp' => 'ചിപേവ്യൻ',
 				'chr' => 'ഷെരോക്കി',
 				'chy' => 'ഷായാൻ',
 				'ckb' => 'സെൻട്രൽ കുർദിഷ്',
 				'ckb@alt=variant' => 'സൊറാനി കുർദിഷ്',
 				'clc' => 'ചിൽകോട്ടിൻ',
 				'co' => 'കോർസിക്കൻ',
 				'cop' => 'കോപ്റ്റിക്',
 				'cr' => 'ക്രീ',
 				'crg' => 'മിചിഫ്',
 				'crh' => 'ക്രിമിയൻ ടർക്കിഷ്',
 				'crj' => 'സതേൺ ഈസ്റ്റ് ക്രീ',
 				'crk' => 'പ്ലെയ്‌ൻസ് ക്രീ',
 				'crl' => 'നോർത്തേൺ ഈസ്റ്റ് ക്രീ',
 				'crm' => 'മൂസ് ക്രീ',
 				'crr' => 'കരോലീന അൽഗോൻക്വിയാൻ',
 				'crs' => 'സെഷൽവ ക്രിയോൾ ഫ്രഞ്ച്',
 				'cs' => 'ചെക്ക്',
 				'csb' => 'കാഷുബിയാൻ',
 				'csw' => 'സ്വാംപി ക്രീ',
 				'cu' => 'ചർച്ച് സ്ലാവിക്',
 				'cv' => 'ചുവാഷ്',
 				'cy' => 'വെൽഷ്',
 				'da' => 'ഡാനിഷ്',
 				'dak' => 'ഡകോട്ട',
 				'dar' => 'ഡർഗ്വാ',
 				'dav' => 'തൈത',
 				'de' => 'ജർമ്മൻ',
 				'de_AT' => 'ഓസ്‌ട്രിയൻ ജർമ്മൻ',
 				'de_CH' => 'സ്വിസ് ഹൈ ജർമ്മൻ',
 				'del' => 'ദെലവേർ',
 				'den' => 'സ്ലേവ്',
 				'dgr' => 'ഡോഗ്രിബ്',
 				'din' => 'ദിൻക',
 				'dje' => 'സാർമ്മ',
 				'doi' => 'ഡോഗ്രി',
 				'dsb' => 'ലോവർ സോർബിയൻ',
 				'dua' => 'ദ്വാല',
 				'dum' => 'മദ്ധ്യ ഡച്ച്',
 				'dv' => 'ദിവെഹി',
 				'dyo' => 'ജോല-ഫോൻയി',
 				'dyu' => 'ദ്വൈല',
 				'dz' => 'ദ്‌സോങ്ക',
 				'dzg' => 'ഡാസാഗ',
 				'ebu' => 'എംബു',
 				'ee' => 'യൂ',
 				'efi' => 'എഫിക്',
 				'egy' => 'പ്രാചീന ഈജിപ്ഷ്യൻ',
 				'eka' => 'എകാജുക്',
 				'el' => 'ഗ്രീക്ക്',
 				'elx' => 'എലാമൈറ്റ്',
 				'en' => 'ഇംഗ്ലീഷ്',
 				'en_AU' => 'ഓസ്‌ട്രേലിയൻ ഇംഗ്ലീഷ്',
 				'en_CA' => 'കനേഡിയൻ ഇംഗ്ലീഷ്',
 				'en_GB' => 'ബ്രിട്ടീഷ് ഇംഗ്ലീഷ്',
 				'en_GB@alt=short' => 'യു.കെ. ഇംഗ്ലീഷ്',
 				'en_US' => 'അമേരിക്കൻ ഇംഗ്ലീഷ്',
 				'en_US@alt=short' => 'യു.എസ്. ഇംഗ്ലീഷ്',
 				'enm' => 'മദ്ധ്യ ഇംഗ്ലീഷ്',
 				'eo' => 'എസ്‌പരാന്റോ',
 				'es' => 'സ്‌പാനിഷ്',
 				'es_419' => 'ലാറ്റിൻ അമേരിക്കൻ സ്‌പാനിഷ്',
 				'es_ES' => 'യൂറോപ്യൻ സ്‌പാനിഷ്',
 				'es_MX' => 'മെക്സിക്കൻ സ്പാനിഷ്',
 				'et' => 'എസ്റ്റോണിയൻ',
 				'eu' => 'ബാസ്‌ക്',
 				'ewo' => 'എവോൻഡോ',
 				'fa' => 'പേർഷ്യൻ',
 				'fa_AF' => 'ഡാരി',
 				'fan' => 'ഫങ്',
 				'fat' => 'ഫാന്റി',
 				'ff' => 'ഫുല',
 				'fi' => 'ഫിന്നിഷ്',
 				'fil' => 'ഫിലിപ്പിനോ',
 				'fj' => 'ഫിജിയൻ',
 				'fo' => 'ഫാറോസ്',
 				'fon' => 'ഫോൻ',
 				'fr' => 'ഫ്രഞ്ച്',
 				'fr_CA' => 'കനേഡിയൻ ഫ്രഞ്ച്',
 				'fr_CH' => 'സ്വിസ് ഫ്രഞ്ച്',
 				'frc' => 'കേജൺ ഫ്രഞ്ച്',
 				'frm' => 'മദ്ധ്യ ഫ്രഞ്ച്',
 				'fro' => 'പഴയ ഫ്രഞ്ച്',
 				'frr' => 'നോർത്തേൻ ഫ്രിഷ്യൻ',
 				'frs' => 'ഈസ്റ്റേൺ ഫ്രിഷ്യൻ',
 				'fur' => 'ഫ്രിയുലിയാൻ',
 				'fy' => 'പശ്ചിമ ഫ്രിഷിയൻ',
 				'ga' => 'ഐറിഷ്',
 				'gaa' => 'ഗാ',
 				'gag' => 'ഗാഗൂസ്',
 				'gan' => 'ഗാൻ ചൈനീസ്',
 				'gay' => 'ഗയൊ',
 				'gba' => 'ഗബ്യ',
 				'gd' => 'സ്കോട്ടിഷ് ഗൈലിക്',
 				'gez' => 'ഗീസ്',
 				'gil' => 'ഗിൽബർട്ടീസ്',
 				'gl' => 'ഗലീഷ്യൻ',
 				'gmh' => 'മദ്ധ്യ ഉച്ച ജർമൻ',
 				'gn' => 'ഗ്വരനി',
 				'goh' => 'ഓൾഡ് ഹൈ ജർമൻ',
 				'gon' => 'ഗോണ്ഡി',
 				'gor' => 'ഗൊറോന്റാലോ',
 				'got' => 'ഗോഥിക്ക്',
 				'grb' => 'ഗ്രബൊ',
 				'grc' => 'പുരാതന ഗ്രീക്ക്',
 				'gsw' => 'സ്വിസ് ജർമ്മൻ',
 				'gu' => 'ഗുജറാത്തി',
 				'guz' => 'ഗുസീ',
 				'gv' => 'മാൻസ്',
 				'gwi' => 'ഗ്വിച്ചിൻ',
 				'ha' => 'ഹൗസ',
 				'hai' => 'ഹൈഡ',
 				'hak' => 'ഹാക്ക ചൈനീസ്',
 				'haw' => 'ഹവായിയൻ',
 				'hax' => 'സതേൺ ഹൈഡ',
 				'he' => 'ഹീബ്രു',
 				'hi' => 'ഹിന്ദി',
 				'hi_Latn@alt=variant' => 'ഹിംഗ്ലീഷ്',
 				'hil' => 'ഹിലിഗയ്നോൺ',
 				'hit' => 'ഹിറ്റൈറ്റ്',
 				'hmn' => 'മോങ്',
 				'ho' => 'ഹിരി മോതു',
 				'hr' => 'ക്രൊയേഷ്യൻ',
 				'hsb' => 'അപ്പർ സോർബിയൻ',
 				'hsn' => 'ഷ്യാങ് ചൈനീസ്',
 				'ht' => 'ഹെയ്‌തിയൻ ക്രിയോൾ',
 				'hu' => 'ഹംഗേറിയൻ',
 				'hup' => 'ഹൂപ',
 				'hur' => 'ഹോക്കൊമെലം',
 				'hy' => 'അർമേനിയൻ',
 				'hz' => 'ഹെരേരൊ',
 				'ia' => 'ഇന്റർലിംഗ്വ',
 				'iba' => 'ഇബാൻ',
 				'ibb' => 'ഇബീബിയോ',
 				'id' => 'ഇന്തോനേഷ്യൻ',
 				'ie' => 'ഇന്റർലിംഗ്വേ',
 				'ig' => 'ഇഗ്ബോ',
 				'ii' => 'ഷുവാൻയി',
 				'ik' => 'ഇനുപിയാക്',
 				'ikt' => 'വെസ്റ്റേൺ കനേഡിയൻ ഇനുക്ടിറ്റൂറ്റ്',
 				'ilo' => 'ഇലോകോ',
 				'inh' => 'ഇങ്കുഷ്',
 				'io' => 'ഇഡോ',
 				'is' => 'ഐസ്‌ലാൻഡിക്',
 				'it' => 'ഇറ്റാലിയൻ',
 				'iu' => 'ഇനുക്റ്റിറ്റുട്ട്',
 				'ja' => 'ജാപ്പനീസ്',
 				'jbo' => 'ലോജ്ബാൻ',
 				'jgo' => 'ഗോമ്പ',
 				'jmc' => 'മചേം',
 				'jpr' => 'ജൂഡിയോ-പേർഷ്യൻ',
 				'jrb' => 'ജൂഡിയോ-അറബിക്',
 				'jv' => 'ജാവനീസ്',
 				'ka' => 'ജോർജിയൻ',
 				'kaa' => 'കര-കാൽപ്പക്',
 				'kab' => 'കബൈൽ',
 				'kac' => 'കാചിൻ',
 				'kaj' => 'ജ്യൂ',
 				'kam' => 'കംബ',
 				'kaw' => 'കാവി',
 				'kbd' => 'കബർഡിയാൻ',
 				'kbl' => 'കനെംബു',
 				'kcg' => 'ട്യാപ്',
 				'kde' => 'മക്കോണ്ടെ',
 				'kea' => 'കബുവെർദിയാനു',
 				'kfo' => 'കോറോ',
 				'kg' => 'കോംഗോ',
 				'kgp' => 'കെയിൻഗാംഗ്',
 				'kha' => 'ഖാസി',
 				'kho' => 'ഘോറ്റാനേസേ',
 				'khq' => 'കൊയ്റ ചീനി',
 				'ki' => 'കികൂയു',
 				'kj' => 'ക്വാന്യമ',
 				'kk' => 'കസാഖ്',
 				'kkj' => 'കാകോ',
 				'kl' => 'കലാല്ലിസുട്ട്',
 				'kln' => 'കലെഞ്ചിൻ',
 				'km' => 'ഖമെർ',
 				'kmb' => 'കിംബുണ്ടു',
 				'kn' => 'കന്നഡ',
 				'ko' => 'കൊറിയൻ',
 				'koi' => 'കോമി-പെർമ്യാക്ക്',
 				'kok' => 'കൊങ്കണി',
 				'kos' => 'കൊസറേയൻ',
 				'kpe' => 'പെൽ',
 				'kr' => 'കനൂറി',
 				'krc' => 'കരാചൈ-ബാൽകാർ',
 				'krl' => 'കരീലിയൻ',
 				'kru' => 'കുരുഖ്',
 				'ks' => 'കശ്‌മീരി',
 				'ksb' => 'ഷംഭാള',
 				'ksf' => 'ബാഫിയ',
 				'ksh' => 'കൊളോണിയൻ',
 				'ku' => 'കുർദ്ദിഷ്',
 				'kum' => 'കൂമിക്ക്',
 				'kut' => 'കുതേനൈ',
 				'kv' => 'കോമി',
 				'kw' => 'കോർണിഷ്',
 				'kwk' => 'ക്വാക്വല',
 				'ky' => 'കിർഗിസ്',
 				'la' => 'ലാറ്റിൻ',
 				'lad' => 'ലഡീനോ',
 				'lag' => 'ലാംഗി',
 				'lah' => 'ലഹ്‌ൻഡ',
 				'lam' => 'ലംബ',
 				'lb' => 'ലക്‌സംബർഗിഷ്',
 				'lez' => 'ലസ്ഗിയൻ',
 				'lg' => 'ഗാണ്ട',
 				'li' => 'ലിംബർഗിഷ്',
 				'lil' => 'ലില്ലുവെറ്റ്',
 				'lkt' => 'ലകൗട്ട',
 				'lmo' => 'ലൊംബാർഡ്',
 				'ln' => 'ലിംഗാല',
 				'lo' => 'ലാവോ',
 				'lol' => 'മോങ്കോ',
 				'lou' => 'ലൂസിയാന ക്രിയോൾ',
 				'loz' => 'ലൊസി',
 				'lrc' => 'വടക്കൻ ലൂറി',
 				'lsm' => 'സാമിയ',
 				'lt' => 'ലിത്വാനിയൻ',
 				'lu' => 'ലുബ-കറ്റംഗ',
 				'lua' => 'ലൂബ-ലുലുവ',
 				'lui' => 'ലൂയിസെനോ',
 				'lun' => 'ലുൻഡ',
 				'luo' => 'ലുവോ',
 				'lus' => 'മിസോ',
 				'luy' => 'ലുയിയ',
 				'lv' => 'ലാറ്റ്വിയൻ',
 				'mad' => 'മദുരേസേ',
 				'maf' => 'മാഫ',
 				'mag' => 'മഗാഹി',
 				'mai' => 'മൈഥിലി',
 				'mak' => 'മകാസർ',
 				'man' => 'മണ്ഡിൻഗോ',
 				'mas' => 'മസായ്',
 				'mde' => 'മാബ',
 				'mdf' => 'മോക്ഷ',
 				'mdr' => 'മണ്ഡാർ',
 				'men' => 'മെൻഡെ',
 				'mer' => 'മേരു',
 				'mfe' => 'മൊറിസിൻ',
 				'mg' => 'മലഗാസി',
 				'mga' => 'മദ്ധ്യ ഐറിഷ്',
 				'mgh' => 'മാഖുവാ-മീത്തോ',
 				'mgo' => 'മേത്താ',
 				'mh' => 'മാർഷല്ലീസ്',
 				'mi' => 'മവോറി',
 				'mic' => 'മിക്മാക്',
 				'min' => 'മിനാങ്കബൗ',
 				'mk' => 'മാസിഡോണിയൻ',
 				'ml' => 'മലയാളം',
 				'mn' => 'മംഗോളിയൻ',
 				'mnc' => 'മാൻ‌ചു',
 				'mni' => 'മണിപ്പൂരി',
 				'moe' => 'ഇന്നു-ഐമൂൻ',
 				'moh' => 'മോഹാക്',
 				'mos' => 'മൊസ്സി',
 				'mr' => 'മറാത്തി',
 				'ms' => 'മലെയ്',
 				'mt' => 'മാൾട്ടീസ്',
 				'mua' => 'മുന്ദാംഗ്',
 				'mul' => 'പലഭാഷകൾ',
 				'mus' => 'ക്രീക്ക്',
 				'mwl' => 'മിരാൻറസേ',
 				'mwr' => 'മർവാരി',
 				'my' => 'ബർമീസ്',
 				'mye' => 'മയീൻ',
 				'myv' => 'ഏഴ്സ്യ',
 				'mzn' => 'മസന്ററാനി',
 				'na' => 'നൗറു',
 				'nan' => 'മിൻ നാൻ ചൈനീസ്',
 				'nap' => 'നെപ്പോളിറ്റാൻ',
 				'naq' => 'നാമ',
 				'nb' => 'നോർവീജിയൻ ബുക്‌മൽ',
 				'nd' => 'നോർത്ത് ഡെബിൾ',
 				'nds' => 'ലോ ജർമൻ',
 				'nds_NL' => 'ലോ സാക്സൺ',
 				'ne' => 'നേപ്പാളി',
 				'new' => 'നേവാരി',
 				'ng' => 'ഡോങ്ക',
 				'nia' => 'നിയാസ്',
 				'niu' => 'ന്യുവാൻ',
 				'nl' => 'ഡച്ച്',
 				'nl_BE' => 'ഫ്ലമിഷ്',
 				'nmg' => 'ക്വേസിയോ',
 				'nn' => 'നോർവീജിയൻ നൈനോർക്‌സ്',
 				'nnh' => 'ഗീംബൂൺ',
 				'no' => 'നോർവീജിയൻ',
 				'nog' => 'നോഗൈ',
 				'non' => 'പഴയ നോഴ്‌സ്',
 				'nqo' => 'ഇൻകോ',
 				'nr' => 'ദക്ഷിണ നെഡിബിൾ',
 				'nso' => 'നോർത്തേൻ സോതോ',
 				'nus' => 'നുവേർ',
 				'nv' => 'നവാജോ',
 				'nwc' => 'ക്ലാസിക്കൽ നേവാരി',
 				'ny' => 'ന്യൻജ',
 				'nym' => 'ന്യാംവേസി',
 				'nyn' => 'ന്യാൻകോൾ',
 				'nyo' => 'ന്യോറോ',
 				'nzi' => 'സിമ',
 				'oc' => 'ഓക്‌സിറ്റൻ',
 				'oj' => 'ഓജിബ്വാ',
 				'ojb' => 'നോർത്ത്‌വെസ്റ്റേൺ ഒജീബ്‌വെ',
 				'ojc' => 'സെൻട്രൽ ഒജീബ്‌വെ',
 				'ojs' => 'ഒജി-ക്രീ',
 				'ojw' => 'വെസ്റ്റേൺ ഒജീബ്‌വെ',
 				'oka' => 'ഒകാനഗൻ',
 				'om' => 'ഒറോമോ',
 				'or' => 'ഒഡിയ',
 				'os' => 'ഒസ്സെറ്റിക്',
 				'osa' => 'ഒസേജ്',
 				'ota' => 'ഓട്ടോമൻ തുർക്കിഷ്',
 				'pa' => 'പഞ്ചാബി',
 				'pag' => 'പങ്കാസിനൻ',
 				'pal' => 'പാഹ്ലവി',
 				'pam' => 'പാംപൻഗ',
 				'pap' => 'പാപിയാമെന്റൊ',
 				'pau' => 'പലാവുൻ',
 				'pcm' => 'നൈജീരിയൻ പിഡ്‌ഗിൻ',
 				'peo' => 'പഴയ പേർഷ്യൻ',
 				'phn' => 'ഫീനിഷ്യൻ',
 				'pi' => 'പാലി',
 				'pis' => 'പിജിൻ',
 				'pl' => 'പോളിഷ്',
 				'pon' => 'പൊൻപിയൻ',
 				'pqm' => 'മലിസീറ്റ്-പസാമക്വുഡി',
 				'prg' => 'പ്രഷ്യൻ',
 				'pro' => 'പഴയ പ്രൊവൻഷ്ൽ',
 				'ps' => 'പഷ്‌തോ',
 				'ps@alt=variant' => 'പുഷ്തോ',
 				'pt' => 'പോർച്ചുഗീസ്',
 				'pt_BR' => 'ബ്രസീലിയൻ പോർച്ചുഗീസ്',
 				'pt_PT' => 'യൂറോപ്യൻ പോർച്ചുഗീസ്',
 				'qu' => 'ക്വെച്ചുവ',
 				'quc' => 'ക്വിച്ചെ',
 				'raj' => 'രാജസ്ഥാനി',
 				'rap' => 'രാപനൂയി',
 				'rar' => 'രാരോടോങ്കൻ',
 				'rhg' => 'റോഹിംഗാ',
 				'rm' => 'റൊമാഞ്ച്',
 				'rn' => 'റുണ്ടി',
 				'ro' => 'റൊമാനിയൻ',
 				'ro_MD' => 'മോൾഡാവിയൻ',
 				'rof' => 'റോംബോ',
 				'rom' => 'റൊമാനി',
 				'ru' => 'റഷ്യൻ',
 				'rup' => 'ആരോമാനിയൻ',
 				'rw' => 'കിന്യാർവാണ്ട',
 				'rwk' => 'റുവാ',
 				'sa' => 'സംസ്‌കൃതം',
 				'sad' => 'സാൻഡവേ',
 				'sah' => 'സാഖ',
 				'sam' => 'സമരിയാക്കാരുടെ അരമായ',
 				'saq' => 'സംബുരു',
 				'sas' => 'സസാക്',
 				'sat' => 'സന്താലി',
 				'sba' => 'ഗംബായ്',
 				'sbp' => 'സംഗു',
 				'sc' => 'സർഡിനിയാൻ',
 				'scn' => 'സിസിലിയൻ',
 				'sco' => 'സ്കോട്സ്',
 				'sd' => 'സിന്ധി',
 				'sdh' => 'തെക്കൻ കുർദ്ദിഷ്',
 				'se' => 'വടക്കൻ സമി',
 				'see' => 'സെനേക',
 				'seh' => 'സേന',
 				'sel' => 'സെൽകപ്',
 				'ses' => 'കൊയ്റാബൊറോ സെന്നി',
 				'sg' => 'സാംഗോ',
 				'sga' => 'പഴയ ഐറിഷ്',
 				'sh' => 'സെർബോ-ക്രൊയേഷ്യൻ',
 				'shi' => 'താച്ചലിറ്റ്',
 				'shn' => 'ഷാൻ',
 				'shu' => 'ചാഡിയൻ അറബി',
 				'si' => 'സിംഹള',
 				'sid' => 'സിഡാമോ',
 				'sk' => 'സ്ലോവാക്',
 				'sl' => 'സ്ലോവേനിയൻ',
 				'slh' => 'സതേൺ ലുഷൂറ്റ്‌സീഡ്',
 				'sm' => 'സമോവൻ',
 				'sma' => 'തെക്കൻ സമി',
 				'smj' => 'ലൂലീ സമി',
 				'smn' => 'ഇനാരി സമി',
 				'sms' => 'സ്കോൾട്ട് സമി',
 				'sn' => 'ഷോണ',
 				'snk' => 'സോണിൻകെ',
 				'so' => 'സോമാലി',
 				'sog' => 'സോജിഡിയൻ',
 				'sq' => 'അൽബേനിയൻ',
 				'sr' => 'സെർബിയൻ',
 				'srn' => 'ശ്രാനൻ ഡോങ്കോ',
 				'srr' => 'സെറർ',
 				'ss' => 'സ്വാറ്റി',
 				'ssy' => 'സാഹോ',
 				'st' => 'തെക്കൻ സോതോ',
 				'str' => 'സ്ട്രെയ്റ്റ്സ് സെയ്‌ലിഷ്',
 				'su' => 'സുണ്ടാനീസ്',
 				'suk' => 'സുകുമ',
 				'sus' => 'സുസു',
 				'sux' => 'സുമേരിയൻ',
 				'sv' => 'സ്വീഡിഷ്',
 				'sw' => 'സ്വാഹിലി',
 				'sw_CD' => 'കോംഗോ സ്വാഹിലി',
 				'swb' => 'കൊമോറിയൻ',
 				'syc' => 'പുരാതന സുറിയാനിഭാഷ',
 				'syr' => 'സുറിയാനി',
 				'ta' => 'തമിഴ്',
 				'tce' => 'സതേൺ ടറ്റ്ഷോൺ',
 				'te' => 'തെലുങ്ക്',
 				'tem' => 'ടിംനേ',
 				'teo' => 'ടെസോ',
 				'ter' => 'ടെറേനോ',
 				'tet' => 'ടെറ്റും',
 				'tg' => 'താജിക്',
 				'tgx' => 'ടാഗിഷ്',
 				'th' => 'തായ്',
 				'tht' => 'ടാഹ്‌ൽടൻ',
 				'ti' => 'ടൈഗ്രിന്യ',
 				'tig' => 'ടൈഗ്രി',
 				'tiv' => 'ടിവ്',
 				'tk' => 'തുർക്‌മെൻ',
 				'tkl' => 'ടൊക്കേലൗ',
 				'tl' => 'തഗാലോഗ്',
 				'tlh' => 'ക്ലിംഗോൺ',
 				'tli' => 'ലിംഗ്വിറ്റ്',
 				'tmh' => 'ടമഷേക്',
 				'tn' => 'സ്വാന',
 				'to' => 'ടോംഗൻ',
 				'tog' => 'ന്യാസാ ഡോങ്ക',
 				'tok' => 'ടോകി പോന',
 				'tpi' => 'ടോക് പിസിൻ',
 				'tr' => 'ടർക്കിഷ്',
 				'trv' => 'തരോക്കോ',
 				'ts' => 'സോംഗ',
 				'tsi' => 'സിംഷ്യൻ',
 				'tt' => 'ടാട്ടർ',
 				'ttm' => 'നോർത്തേൺ ടറ്റ്ഷോൺ',
 				'tum' => 'ടുംബുക',
 				'tvl' => 'ടുവാലു',
 				'tw' => 'ട്വി',
 				'twq' => 'ടസവാക്ക്',
 				'ty' => 'താഹിതിയൻ',
 				'tyv' => 'തുവിനിയൻ',
 				'tzm' => 'മധ്യ അറ്റ്‌ലസ് ടമാസൈറ്റ്',
 				'udm' => 'ഉഡ്മുർട്ട്',
 				'ug' => 'ഉയ്ഘുർ',
 				'ug@alt=variant' => 'ഉയ്ഗൂർ',
 				'uga' => 'ഉഗറിട്ടിക്',
 				'uk' => 'ഉക്രേനിയൻ',
 				'umb' => 'ഉംബുന്ദു',
 				'und' => 'അജ്ഞാത ഭാഷ',
 				'ur' => 'ഉറുദു',
 				'uz' => 'ഉസ്‌ബെക്ക്',
 				'vai' => 'വൈ',
 				've' => 'വെന്ദ',
 				'vi' => 'വിയറ്റ്നാമീസ്',
 				'vo' => 'വോളാപുക്',
 				'vot' => 'വോട്ടിക്',
 				'vun' => 'വുൻജോ',
 				'wa' => 'വല്ലൂൺ',
 				'wae' => 'വാൾസർ',
 				'wal' => 'വൊലൈറ്റ',
 				'war' => 'വാരേയ്',
 				'was' => 'വാഷൊ',
 				'wbp' => 'വൂൾപിരി',
 				'wo' => 'വൊളോഫ്',
 				'wuu' => 'വു ചൈനീസ്',
 				'xal' => 'കാൽമിക്',
 				'xh' => 'ഖോസ',
 				'xog' => 'സോഗോ',
 				'yao' => 'യാവോ',
 				'yap' => 'യെപ്പീസ്',
 				'yav' => 'യാംഗ്ബെൻ',
 				'ybb' => 'യംബ',
 				'yi' => 'യിദ്ദിഷ്',
 				'yo' => 'യൊറൂബാ',
 				'yrl' => 'നീൻഗാറ്റു',
 				'yue' => 'കാന്റണീസ്',
 				'yue@alt=menu' => 'ചൈനീസ്, കാന്റണീസ്',
 				'za' => 'സ്വാംഗ്',
 				'zap' => 'സാപ്പോടെക്',
 				'zbl' => 'ബ്ലിസ്സിംബൽസ്',
 				'zen' => 'സെനഗ',
 				'zgh' => 'സ്റ്റാൻഡേർഡ് മൊറോക്കൻ റ്റാമസിയറ്റ്',
 				'zh' => 'ചൈനീസ്',
 				'zh@alt=menu' => 'ചൈനീസ്, മാൻഡറിൻ',
 				'zh_Hans' => 'ലളിതമാക്കിയ ചൈനീസ്',
 				'zh_Hans@alt=long' => 'ലളിതവൽകൃത മാൻഡറിൻ ചൈനീസ്',
 				'zh_Hant' => 'പരമ്പരാഗത ചൈനീസ്',
 				'zh_Hant@alt=long' => 'പരമ്പരാഗത മാൻഡറിൻ ചൈനീസ്',
 				'zu' => 'സുലു',
 				'zun' => 'സുനി',
 				'zxx' => 'ഭാഷാപരമായ ഉള്ളടക്കമൊന്നുമില്ല',
 				'zza' => 'സാസാ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'അദ്‌ലാം',
 			'Arab' => 'അറബിക്',
 			'Arab@alt=variant' => 'പേഴ്‌സോ-അറബിക്',
 			'Aran' => 'നസ്‌റ്റാലിക്',
 			'Armi' => 'അർമി',
 			'Armn' => 'അർമേനിയൻ',
 			'Avst' => 'അവെസ്ഥൻ',
 			'Bali' => 'ബാലിനീസ്',
 			'Batk' => 'ബട്ടക്',
 			'Beng' => 'ബംഗാളി',
 			'Blis' => 'ബ്ലിസ് ചിത്ര ലിപി',
 			'Bopo' => 'ബോപ്പോമോഫോ',
 			'Brah' => 'ബ്രാഹ്മി',
 			'Brai' => 'ബ്രെയ്‌ലി',
 			'Bugi' => 'ബുഗിനീസ്',
 			'Buhd' => 'ബുഹിഡ്',
 			'Cakm' => 'ചക്മ',
 			'Cans' => 'ഏകീകൃത കനേഡിയൻ ഗോത്രലിപി',
 			'Cari' => 'ചരിയൻ',
 			'Cham' => 'ഛം',
 			'Cher' => 'ചെറോക്കി',
 			'Cirt' => 'ചിർത്ത്',
 			'Copt' => 'കോപ്റ്റിക്',
 			'Cprt' => 'സൈപ്രിയോട്ട്',
 			'Cyrl' => 'സിറിലിക്',
 			'Cyrs' => 'പുരാതന ചർച്ച് സ്ലവോണിക് സിറിലിക്',
 			'Deva' => 'ദേവനാഗരി',
 			'Dsrt' => 'ഡെസെർട്ട്',
 			'Egyd' => 'ഈജിപ്ഷ്യൻ ഡിമോട്ടിക്',
 			'Egyh' => 'ഈജിപ്ഷ്യൻ ഹിരാറ്റിക്',
 			'Egyp' => 'ഈജിപ്ഷ്യൻ ചിത്രലിപി',
 			'Ethi' => 'എത്യോപിക്',
 			'Geok' => 'ജോർജ്ജിയൻ ഖുട്സുരി',
 			'Geor' => 'ജോർജ്ജിയൻ',
 			'Glag' => 'ഗ്ലഗോലിറ്റിക്',
 			'Goth' => 'ഗോഥിക്',
 			'Grek' => 'ഗ്രീക്ക്',
 			'Gujr' => 'ഗുജറാത്തി',
 			'Guru' => 'ഗുരുമുഖി',
 			'Hanb' => 'ഹൻബ്',
 			'Hang' => 'ഹാംഗുൽ',
 			'Hani' => 'ഹാൻ',
 			'Hano' => 'ഹനുനൂ',
 			'Hans' => 'ലളിതവൽക്കരിച്ചത്',
 			'Hans@alt=stand-alone' => 'ലളിതവൽക്കരിച്ച ഹാൻ',
 			'Hant' => 'പരമ്പരാഗതം',
 			'Hant@alt=stand-alone' => 'പരമ്പരാഗത ഹാൻ',
 			'Hebr' => 'ഹീബ്രു',
 			'Hira' => 'ഹിരഗാന',
 			'Hmng' => 'പഹ്വാ ഹമോംഗ്',
 			'Hrkt' => 'ജാപ്പനീസ് സില്ലബറീസ്',
 			'Hung' => 'പുരാതന ഹംഗേറിയൻ',
 			'Inds' => 'സിന്ധു',
 			'Ital' => 'പഴയ ഇറ്റാലിയൻ',
 			'Jamo' => 'ജാമോ',
 			'Java' => 'ജാവനീസ്',
 			'Jpan' => 'ജാപ്പനീസ്',
 			'Kali' => 'കയാ ലി',
 			'Kana' => 'കറ്റക്കാന',
 			'Khar' => 'ഖരോഷ്ടി',
 			'Khmr' => 'ഖമെർ',
 			'Knda' => 'കന്നഡ',
 			'Kore' => 'കൊറിയൻ',
 			'Kthi' => 'ക്തി',
 			'Lana' => 'ലന്ന',
 			'Laoo' => 'ലാവോ',
 			'Latf' => 'ഫ്രാക്ടുർ ലാറ്റിൻ',
 			'Latg' => 'ഗെയ്‌ലിക് ലാറ്റിൻ',
 			'Latn' => 'ലാറ്റിൻ',
 			'Lepc' => 'ലെപ്ച',
 			'Limb' => 'ലിംബു',
 			'Lina' => 'സമരേഖയിലുള്ള എ',
 			'Linb' => 'ലീനിയർ ബി',
 			'Lyci' => 'ലൈസിൻ',
 			'Lydi' => 'ലൈഡിയൻ',
 			'Mand' => 'മൻഡേയൻ',
 			'Mani' => 'മണിചേയൻ',
 			'Maya' => 'മായൻ ചിത്രലിപി',
 			'Mero' => 'മെറോയിറ്റിക്',
 			'Mlym' => 'മലയാളം',
 			'Mong' => 'മംഗോളിയൻ',
 			'Moon' => 'മൂൺ',
 			'Mtei' => 'മേറ്റി മായക്',
 			'Mymr' => 'മ്യാൻമാർ',
 			'Nkoo' => 'എൻകോ',
 			'Ogam' => 'ഒഖാം',
 			'Olck' => 'ഒൽ ചിക്കി',
 			'Orkh' => 'ഒർഖോൺ',
 			'Orya' => 'ഒഡിയ',
 			'Osma' => 'ഒസ്‌മാനിയ',
 			'Perm' => 'പുരാതന പെർമിക്',
 			'Phag' => 'ഫഗസ് പ',
 			'Phli' => 'എഴുത്തു പഹൽവി',
 			'Phlp' => 'സാൾട്ടർ പഹൽവി',
 			'Phlv' => 'പഹൽവി ലിപി',
 			'Phnx' => 'ഫിനീഷ്യൻ',
 			'Plrd' => 'പൊള്ളാർഡ് ശബ്ദലിപി',
 			'Prti' => 'പൃതി',
 			'Rjng' => 'റെജാംഗ്',
 			'Rohg' => 'ഹനിഫി',
 			'Roro' => 'റൊംഗോറൊംഗോ',
 			'Runr' => 'റുണിക്',
 			'Samr' => 'സമരിയ',
 			'Sara' => 'സരതി',
 			'Saur' => 'സൗരാഷ്ട്ര',
 			'Sgnw' => 'ചിഹ്നലിപി',
 			'Shaw' => 'ഷാവിയൻ',
 			'Sinh' => 'സിംഹള',
 			'Sund' => 'സന്താനീസ്',
 			'Sylo' => 'സൈലോതി നാഗരി',
 			'Syrc' => 'സിറിയക്ക്',
 			'Syre' => 'എസ്റ്റ്രാംഗ്ലോ സിറിയക്',
 			'Syrj' => 'പശ്ചിമസുറിയാനി',
 			'Syrn' => 'കിഴക്കൻ സിറിയക്',
 			'Tagb' => 'തഗ്ബൻവാ',
 			'Tale' => 'തായ് ലേ',
 			'Talu' => 'പുതിയ തായ് ല്യൂ',
 			'Taml' => 'തമിഴ്',
 			'Tavt' => 'ത്വട്',
 			'Telu' => 'തെലുങ്ക്',
 			'Teng' => 'തെംഗ്വർ',
 			'Tfng' => 'തിഫിനാഗ്',
 			'Tglg' => 'തഗലോഗ്',
 			'Thaa' => 'ഥാന',
 			'Thai' => 'തായ്',
 			'Tibt' => 'ടിബറ്റൻ',
 			'Ugar' => 'ഉഗ്രൈറ്റിക്',
 			'Vaii' => 'വൈ',
 			'Visp' => 'ദൃശ്യഭാഷ',
 			'Xpeo' => 'പഴയ പേർഷ്യൻ',
 			'Xsux' => 'സുമേറോ അക്കാഡിയൻ ക്യുണിഫോം',
 			'Yiii' => 'യി',
 			'Zinh' => 'പാരമ്പര്യമായ',
 			'Zmth' => 'ഗണിത രൂപം',
 			'Zsye' => 'ഇമോജി',
 			'Zsym' => 'ചിഹ്നങ്ങൾ',
 			'Zxxx' => 'എഴുതപ്പെടാത്തത്',
 			'Zyyy' => 'സാധാരണ',
 			'Zzzz' => 'അജ്ഞാത ലിപി',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'ലോകം',
 			'002' => 'ആഫ്രിക്ക',
 			'003' => 'വടക്കേ അമേരിക്ക',
 			'005' => 'തെക്കേ അമേരിക്ക',
 			'009' => 'ഓഷ്യാനിയ',
 			'011' => 'പശ്ചിമ ആഫ്രിക്ക',
 			'013' => 'മദ്ധ്യ അമേരിക്ക',
 			'014' => 'കിഴക്കൻ ആഫ്രിക്ക',
 			'015' => 'ഉത്തരാഫ്രിക്ക',
 			'017' => 'മദ്ധ്യ ആഫ്രിക്ക',
 			'018' => 'തെക്കേ ആഫ്രിക്ക',
 			'019' => 'അമേരിക്കകൾ',
 			'021' => 'വടക്കൻ അമേരിക്ക',
 			'029' => 'കരീബിയൻ',
 			'030' => 'കിഴക്കൻ ഏഷ്യ',
 			'034' => 'തെക്കേ ഏഷ്യ',
 			'035' => 'തെക്ക്-കിഴക്കൻ ഏഷ്യ',
 			'039' => 'തെക്കേ യൂറോപ്പ്',
 			'053' => 'ഓസ്‌ട്രേലിയയും ന്യൂസിലാൻഡും',
 			'054' => 'മെലനേഷ്യ',
 			'057' => 'മൈക്രോനേഷ്യൻ പ്രദേശം',
 			'061' => 'പോളിനേഷ്യ',
 			'142' => 'ഏഷ്യ',
 			'143' => 'മദ്ധ്യേഷ്യ',
 			'145' => 'പശ്ചിമേഷ്യ',
 			'150' => 'യൂറോപ്പ്',
 			'151' => 'കിഴക്കൻ യൂറോപ്പ്',
 			'154' => 'വടക്കേ യൂറോപ്പ്',
 			'155' => 'പശ്ചിമ യൂറോപ്പ്',
 			'202' => 'സബ്-സഹാറൻ ആഫ്രിക്ക',
 			'419' => 'ലാറ്റിനമേരിക്ക',
 			'AC' => 'അസൻഷൻ ദ്വീപ്',
 			'AD' => 'അൻഡോറ',
 			'AE' => 'യുണൈറ്റഡ് അറബ് എമിറൈറ്റ്‌സ്',
 			'AF' => 'അഫ്‌ഗാനിസ്ഥാൻ',
 			'AG' => 'ആൻറിഗ്വയും ബർബുഡയും',
 			'AI' => 'ആൻഗ്വില്ല',
 			'AL' => 'അൽബേനിയ',
 			'AM' => 'അർമേനിയ',
 			'AO' => 'അംഗോള',
 			'AQ' => 'അന്റാർട്ടിക്ക',
 			'AR' => 'അർജന്റീന',
 			'AS' => 'അമേരിക്കൻ സമോവ',
 			'AT' => 'ഓസ്ട്രിയ',
 			'AU' => 'ഓസ്‌ട്രേലിയ',
 			'AW' => 'അറൂബ',
 			'AX' => 'അലൻഡ് ദ്വീപുകൾ',
 			'AZ' => 'അസർബൈജാൻ',
 			'BA' => 'ബോസ്നിയയും ഹെർസഗോവിനയും',
 			'BB' => 'ബാർബഡോസ്',
 			'BD' => 'ബംഗ്ലാദേശ്',
 			'BE' => 'ബെൽജിയം',
 			'BF' => 'ബർക്കിന ഫാസോ',
 			'BG' => 'ബൾഗേറിയ',
 			'BH' => 'ബഹ്റിൻ',
 			'BI' => 'ബറുണ്ടി',
 			'BJ' => 'ബെനിൻ',
 			'BL' => 'സെന്റ് ബാർത്തലമി',
 			'BM' => 'ബർമുഡ',
 			'BN' => 'ബ്രൂണൈ',
 			'BO' => 'ബൊളീവിയ',
 			'BQ' => 'കരീബിയൻ നെതർലാൻഡ്സ്',
 			'BR' => 'ബ്രസീൽ',
 			'BS' => 'ബഹാമാസ്',
 			'BT' => 'ഭൂട്ടാൻ',
 			'BV' => 'ബൗവെട്ട് ദ്വീപ്',
 			'BW' => 'ബോട്സ്വാന',
 			'BY' => 'ബെലറൂസ്',
 			'BZ' => 'ബെലീസ്',
 			'CA' => 'കാനഡ',
 			'CC' => 'കോക്കസ് (കീലിംഗ്) ദ്വീപുകൾ',
 			'CD' => 'കോംഗോ - കിൻഷാസ',
 			'CD@alt=variant' => 'കോംഗോ (DRC)',
 			'CF' => 'സെൻട്രൽ ആഫ്രിക്കൻ റിപ്പബ്ലിക്ക്',
 			'CG' => 'കോംഗോ - ബ്രാസവില്ലി',
 			'CG@alt=variant' => 'കോംഗോ (റിപ്പബ്ലിക്ക്)',
 			'CH' => 'സ്വിറ്റ്സർലാൻഡ്',
 			'CI' => 'കോട്ട് ഡി വാർ',
 			'CI@alt=variant' => 'ഐവറി കോസ്റ്റ്',
 			'CK' => 'കുക്ക് ദ്വീപുകൾ',
 			'CL' => 'ചിലി',
 			'CM' => 'കാമറൂൺ',
 			'CN' => 'ചൈന',
 			'CO' => 'കൊളംബിയ',
 			'CP' => 'ക്ലിപ്പെർട്ടൻ ദ്വീപ്',
 			'CR' => 'കോസ്റ്ററിക്ക',
 			'CU' => 'ക്യൂബ',
 			'CV' => 'കേപ്പ് വേർഡ്',
 			'CW' => 'കുറാകാവോ',
 			'CX' => 'ക്രിസ്മസ് ദ്വീപ്',
 			'CY' => 'സൈപ്രസ്',
 			'CZ' => 'ചെക്കിയ',
 			'CZ@alt=variant' => 'ചെക്ക് റിപ്പബ്ലിക്ക്',
 			'DE' => 'ജർമ്മനി',
 			'DG' => 'ഡീഗോ ഗ്രാഷ്യ',
 			'DJ' => 'ജിബൂത്തി',
 			'DK' => 'ഡെൻമാർക്ക്',
 			'DM' => 'ഡൊമിനിക്ക',
 			'DO' => 'ഡൊമിനിക്കൻ റിപ്പബ്ലിക്ക്',
 			'DZ' => 'അൾജീരിയ',
 			'EA' => 'സെയൂത്ത ആൻഡ് മെലിയ',
 			'EC' => 'ഇക്വഡോർ',
 			'EE' => 'എസ്റ്റോണിയ‍',
 			'EG' => 'ഈജിപ്ത്',
 			'EH' => 'പശ്ചിമ സഹാറ',
 			'ER' => 'എറിത്രിയ',
 			'ES' => 'സ്‌പെയിൻ',
 			'ET' => 'എത്യോപ്യ',
 			'EU' => 'യൂറോപ്യൻ യൂണിയൻ',
 			'EZ' => 'യൂറോസോൺ',
 			'FI' => 'ഫിൻലാൻഡ്',
 			'FJ' => 'ഫിജി',
 			'FK' => 'ഫാക്ക്‌ലാന്റ് ദ്വീപുകൾ',
 			'FK@alt=variant' => 'ഫോക്ക്‌ലൻഡ് ദ്വീപുകൾ (ഇസ്‌ലാസ് മാൽവീനാസ്)',
 			'FM' => 'മൈക്രോനേഷ്യ',
 			'FO' => 'ഫറോ ദ്വീപുകൾ',
 			'FR' => 'ഫ്രാൻസ്',
 			'GA' => 'ഗാബൺ',
 			'GB' => 'യുണൈറ്റഡ് കിംഗ്ഡം',
 			'GB@alt=short' => 'യുകെ',
 			'GD' => 'ഗ്രനേഡ',
 			'GE' => 'ജോർജ്ജിയ',
 			'GF' => 'ഫ്രഞ്ച് ഗയാന',
 			'GG' => 'ഗേൺസി',
 			'GH' => 'ഘാന',
 			'GI' => 'ജിബ്രാൾട്ടർ',
 			'GL' => 'ഗ്രീൻലൻഡ്',
 			'GM' => 'ഗാംബിയ',
 			'GN' => 'ഗിനിയ',
 			'GP' => 'ഗ്വാഡലൂപ്പ്',
 			'GQ' => 'ഇക്വറ്റോറിയൽ ഗിനിയ',
 			'GR' => 'ഗ്രീസ്',
 			'GS' => 'ദക്ഷിണ ജോർജ്ജിയയും ദക്ഷിണ സാൻഡ്‌വിച്ച് ദ്വീപുകളും',
 			'GT' => 'ഗ്വാട്ടിമാല',
 			'GU' => 'ഗ്വാം',
 			'GW' => 'ഗിനിയ-ബിസൗ',
 			'GY' => 'ഗയാന',
 			'HK' => 'ഹോങ്കോങ് (SAR) ചൈന',
 			'HK@alt=short' => 'ഹോങ്കോങ്',
 			'HM' => 'ഹേർഡ്, മക്ഡോണൾഡ് ദ്വീപുകൾ',
 			'HN' => 'ഹോണ്ടുറാസ്',
 			'HR' => 'ക്രൊയേഷ്യ',
 			'HT' => 'ഹെയ്തി',
 			'HU' => 'ഹംഗറി',
 			'IC' => 'കാനറി ദ്വീപുകൾ',
 			'ID' => 'ഇന്തോനേഷ്യ',
 			'IE' => 'അയർലൻഡ്',
 			'IL' => 'ഇസ്രായേൽ',
 			'IM' => 'ഐൽ ഓഫ് മാൻ',
 			'IN' => 'ഇന്ത്യ',
 			'IO' => 'ബ്രിട്ടീഷ് ഇന്ത്യൻ ഓഷ്യൻ ടെറിട്ടറി',
 			'IO@alt=chagos' => 'ചാഗോസ് ആർക്കിപ്പെലഗോ',
 			'IQ' => 'ഇറാഖ്',
 			'IR' => 'ഇറാൻ',
 			'IS' => 'ഐസ്‌ലാന്റ്',
 			'IT' => 'ഇറ്റലി',
 			'JE' => 'ജേഴ്സി',
 			'JM' => 'ജമൈക്ക',
 			'JO' => 'ജോർദ്ദാൻ',
 			'JP' => 'ജപ്പാൻ',
 			'KE' => 'കെനിയ',
 			'KG' => 'കിർഗിസ്ഥാൻ',
 			'KH' => 'കംബോഡിയ',
 			'KI' => 'കിരിബാട്ടി',
 			'KM' => 'കോമൊറോസ്',
 			'KN' => 'സെന്റ് കിറ്റ്‌സും നെവിസും',
 			'KP' => 'ഉത്തരകൊറിയ',
 			'KR' => 'ദക്ഷിണകൊറിയ',
 			'KW' => 'കുവൈറ്റ്',
 			'KY' => 'കേയ്മാൻ ദ്വീപുകൾ',
 			'KZ' => 'കസാഖിസ്ഥാൻ',
 			'LA' => 'ലാവോസ്',
 			'LB' => 'ലെബനൻ',
 			'LC' => 'സെന്റ് ലൂസിയ',
 			'LI' => 'ലിച്ചൺസ്റ്റൈൻ',
 			'LK' => 'ശ്രീലങ്ക',
 			'LR' => 'ലൈബീരിയ',
 			'LS' => 'ലെസോതോ',
 			'LT' => 'ലിത്വാനിയ',
 			'LU' => 'ലക്സംബർഗ്',
 			'LV' => 'ലാറ്റ്വിയ',
 			'LY' => 'ലിബിയ',
 			'MA' => 'മൊറോക്കൊ',
 			'MC' => 'മൊണാക്കോ',
 			'MD' => 'മൾഡോവ',
 			'ME' => 'മോണ്ടെനെഗ്രോ',
 			'MF' => 'സെന്റ് മാർട്ടിൻ',
 			'MG' => 'മഡഗാസ്കർ',
 			'MH' => 'മാർഷൽ ദ്വീപുകൾ',
 			'MK' => 'നോർത്ത് മാസിഡോണിയ',
 			'ML' => 'മാലി',
 			'MM' => 'മ്യാൻമാർ (ബർമ്മ)',
 			'MN' => 'മംഗോളിയ',
 			'MO' => 'മക്കാവു SAR ചൈന',
 			'MO@alt=short' => 'മക്കാവു',
 			'MP' => 'ഉത്തര മറിയാനാ ദ്വീപുകൾ',
 			'MQ' => 'മാർട്ടിനിക്ക്',
 			'MR' => 'മൗറിറ്റാനിയ',
 			'MS' => 'മൊണ്ടെസരത്ത്',
 			'MT' => 'മാൾട്ട',
 			'MU' => 'മൗറീഷ്യസ്',
 			'MV' => 'മാലിദ്വീപ്',
 			'MW' => 'മലാവി',
 			'MX' => 'മെക്സിക്കോ',
 			'MY' => 'മലേഷ്യ',
 			'MZ' => 'മൊസാംബിക്ക്',
 			'NA' => 'നമീബിയ',
 			'NC' => 'ന്യൂ കാലിഡോണിയ',
 			'NE' => 'നൈജർ',
 			'NF' => 'നോർഫോക് ദ്വീപ്',
 			'NG' => 'നൈജീരിയ',
 			'NI' => 'നിക്കരാഗ്വ',
 			'NL' => 'നെതർലാൻഡ്‌സ്',
 			'NO' => 'നോർവെ',
 			'NP' => 'നേപ്പാൾ',
 			'NR' => 'നൗറു',
 			'NU' => 'ന്യൂയി',
 			'NZ' => 'ന്യൂസിലൻഡ്',
 			'NZ@alt=variant' => 'ഓട്ടേറുവ ന്യൂസിലൻഡ്',
 			'OM' => 'ഒമാൻ',
 			'PA' => 'പനാമ',
 			'PE' => 'പെറു',
 			'PF' => 'ഫ്രഞ്ച് പോളിനേഷ്യ',
 			'PG' => 'പാപ്പുവ ന്യൂ ഗിനിയ',
 			'PH' => 'ഫിലിപ്പീൻസ്',
 			'PK' => 'പാക്കിസ്ഥാൻ',
 			'PL' => 'പോളണ്ട്',
 			'PM' => 'സെന്റ് പിയറി ആൻഡ് മിക്വലൻ',
 			'PN' => 'പിറ്റ്‌കെയ്‌ൻ ദ്വീപുകൾ',
 			'PR' => 'പോർട്ടോ റിക്കോ',
 			'PS' => 'പാലസ്‌തീൻ പ്രദേശങ്ങൾ',
 			'PS@alt=short' => 'പലസ്‌തീൻ',
 			'PT' => 'പോർച്ചുഗൽ',
 			'PW' => 'പലാവു',
 			'PY' => 'പരാഗ്വേ',
 			'QA' => 'ഖത്തർ',
 			'QO' => 'ദ്വീപസമൂഹം',
 			'RE' => 'റീയൂണിയൻ',
 			'RO' => 'റൊമാനിയ',
 			'RS' => 'സെർബിയ',
 			'RU' => 'റഷ്യ',
 			'RW' => 'റുവാണ്ട',
 			'SA' => 'സൗദി അറേബ്യ',
 			'SB' => 'സോളമൻ ദ്വീപുകൾ',
 			'SC' => 'സീഷെൽസ്',
 			'SD' => 'സുഡാൻ',
 			'SE' => 'സ്വീഡൻ',
 			'SG' => 'സിംഗപ്പൂർ',
 			'SH' => 'സെന്റ് ഹെലീന',
 			'SI' => 'സ്ലോവേനിയ',
 			'SJ' => 'സ്വാൽബാഡും ജാൻ മായേനും',
 			'SK' => 'സ്ലോവാക്യ',
 			'SL' => 'സിയെറ ലിയോൺ',
 			'SM' => 'സാൻ മറിനോ',
 			'SN' => 'സെനഗൽ',
 			'SO' => 'സോമാലിയ',
 			'SR' => 'സുരിനാം',
 			'SS' => 'ദക്ഷിണ സുഡാൻ',
 			'ST' => 'സാവോ ടോമും പ്രിൻസിപെയും',
 			'SV' => 'എൽ സാൽവദോർ',
 			'SX' => 'സിന്റ് മാർട്ടെൻ',
 			'SY' => 'സിറിയ',
 			'SZ' => 'സ്വാസിലൻഡ്',
 			'SZ@alt=variant' => 'സ്വാസിലാൻഡ്',
 			'TA' => 'ട്രിസ്റ്റൻ ഡ കൂന',
 			'TC' => 'ടർക്ക്‌സും കെയ്‌ക്കോ ദ്വീപുകളും',
 			'TD' => 'ഛാഡ്',
 			'TF' => 'ഫ്രഞ്ച് ദക്ഷിണ ഭൂപ്രദേശം',
 			'TG' => 'ടോഗോ',
 			'TH' => 'തായ്‌ലാൻഡ്',
 			'TJ' => 'താജിക്കിസ്ഥാൻ',
 			'TK' => 'ടോക്കെലൂ',
 			'TL' => 'തിമോർ-ലെസ്റ്റെ',
 			'TL@alt=variant' => 'കിഴക്കൻ തിമോർ',
 			'TM' => 'തുർക്ക്മെനിസ്ഥാൻ',
 			'TN' => 'ടുണീഷ്യ',
 			'TO' => 'ടോംഗ',
 			'TR' => 'തുർക്കിയെ',
 			'TT' => 'ട്രിനിഡാഡും ടുബാഗോയും',
 			'TV' => 'ടുവാലു',
 			'TW' => 'തായ്‌വാൻ',
 			'TZ' => 'ടാൻസാനിയ',
 			'UA' => 'ഉക്രെയ്‌ൻ',
 			'UG' => 'ഉഗാണ്ട',
 			'UM' => 'യു.എസ്. ദ്വീപസമൂഹങ്ങൾ',
 			'UN' => 'ഐക്യരാഷ്ട്രസഭ',
 			'UN@alt=short' => 'യുഎൻ',
 			'US' => 'അമേരിക്കൻ ഐക്യനാടുകൾ',
 			'US@alt=short' => 'യു.എസ്',
 			'UY' => 'ഉറുഗ്വേ',
 			'UZ' => 'ഉസ്‌ബെക്കിസ്ഥാൻ',
 			'VA' => 'വത്തിക്കാൻ',
 			'VC' => 'സെന്റ് വിൻസെന്റും ഗ്രനെഡൈൻസും',
 			'VE' => 'വെനിസ്വേല',
 			'VG' => 'ബ്രിട്ടീഷ് വെർജിൻ ദ്വീപുകൾ',
 			'VI' => 'യു.എസ്. വെർജിൻ ദ്വീപുകൾ',
 			'VN' => 'വിയറ്റ്നാം',
 			'VU' => 'വന്വാതു',
 			'WF' => 'വാലിസ് ആന്റ് ഫ്യൂച്യുന',
 			'WS' => 'സമോവ',
 			'XA' => 'കൃത്രിമ ഉച്ചാരണം',
 			'XB' => 'സ്യൂഡോ-ബൈഡി',
 			'XK' => 'കൊസോവൊ',
 			'YE' => 'യെമൻ',
 			'YT' => 'മയോട്ടി',
 			'ZA' => 'ദക്ഷിണാഫ്രിക്ക',
 			'ZM' => 'സാംബിയ',
 			'ZW' => 'സിംബാബ്‌വേ',
 			'ZZ' => 'അജ്ഞാത പ്രദേശം',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'1996' => '1996-ലെ ജർമൻ ലിപി',
 			'1606NICT' => '1606 വരെയുള്ള ആധുനികമദ്ധ്യകാല ഫ്രഞ്ച്',
 			'AREVELA' => 'കിഴക്കൻ അർമീനിയൻ',
 			'BOONT' => 'ബൂണ്ട്‌ലിങ്ങ്',
 			'FONIPA' => 'ഐപി‌എ സ്വനവ്യവസ്ഥ',
 			'MONOTON' => 'മോണോറ്റോണിക്',
 			'NEDIS' => 'നേറ്റിസോൺ പ്രാദേശികരൂപം',
 			'NJIVA' => 'ഗ്നിവ/നിജിവ പ്രാദേശികരൂപം',
 			'PINYIN' => 'പിൻയിൻ റോമനൈസേഷൻ',
 			'POSIX' => 'കമ്പ്യൂട്ടർ',
 			'REVISED' => 'പരിഷ്ക്കരിച്ച ലിപി',
 			'WADEGILE' => 'വേഡ്-ഗൈൽസ് റോമനൈസേഷൻ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'കലണ്ടർ',
 			'cf' => 'കറൻസി ഫോർമാറ്റ്',
 			'colalternate' => 'ചിഹ്നങ്ങൾ പ്രകാരം അടുക്കുന്നത് അവഗണിക്കുക',
 			'colbackwards' => 'വിപരീതക്രമ ആക്‌സന്റ് പ്രകാരമുള്ള അടുക്കൽ',
 			'colcasefirst' => 'വലിയക്ഷര/ചെറിയക്ഷര പ്രകാരമുള്ള അടുക്കൽ',
 			'colcaselevel' => 'കേസ് സെൻസിറ്റീവ് അടുക്കൽ',
 			'collation' => 'അടുക്കൽ ക്രമം',
 			'colnormalization' => 'സാധാരണ അടുക്കൽ',
 			'colnumeric' => 'അക്കങ്ങൾ പ്രകാരമുള്ള അടുക്കൽ',
 			'colstrength' => 'അടുക്കൽ ദൃഢത',
 			'currency' => 'നാണയം',
 			'hc' => 'സമയ ഘടന (12 / 24)',
 			'lb' => 'രേഖ വിഭാജി ശൈലി',
 			'ms' => 'അളക്കൽ സംവിധാനം',
 			'numbers' => 'അക്കങ്ങൾ‌',
 			'timezone' => 'സമയ മേഖല',
 			'va' => 'ഭാഷാ ഭേദം',
 			'x' => 'സ്വകാര്യ ഉപയോഗം',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ബുദ്ധമതകലണ്ടർ},
 				'chinese' => q{ചൈനീസ് കലണ്ടർ},
 				'coptic' => q{കോപ്റ്റിക് കലണ്ടർ},
 				'dangi' => q{ഡാംഗി കലണ്ടർ},
 				'ethiopic' => q{എത്യോപിക് കലണ്ടർ},
 				'ethiopic-amete-alem' => q{എത്യോപിക് അമെതെ അലെം കലണ്ടർ},
 				'gregorian' => q{ഇംഗ്ലീഷ് കലണ്ടർ},
 				'hebrew' => q{ഹീബ്രൂ കലണ്ടർ},
 				'indian' => q{ശകവർഷ കലണ്ടർ},
 				'islamic' => q{ഇസ്‌ലാമിക് കലണ്ടർ},
 				'islamic-civil' => q{ഇസ്ലാമിക് കലണ്ടർ},
 				'islamic-rgsa' => q{ഇസ്ലാം-അറബിക് കലണ്ടർ},
 				'islamic-tbla' => q{ഇസ്ലാം-ജ്യോതിഷ കലണ്ടർ},
 				'islamic-umalqura' => q{ഇസ്‌ലാമിക് കലണ്ടർ (ഉം അൽ ഖുറ)},
 				'iso8601' => q{ഐഎസ്ഓ 8601 കലണ്ടർ},
 				'japanese' => q{ജാപ്പനീസ് കലണ്ടർ},
 				'persian' => q{പേർഷ്യൻ കലണ്ടർ},
 				'roc' => q{മിംഗ്വോ കലണ്ടർ},
 			},
 			'cf' => {
 				'account' => q{അക്കൗണ്ടിംഗ് കറൻസി ഫോർമാറ്റ്},
 				'standard' => q{സാധാരണ കറൻസി ഫോർമാറ്റ്},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{ചിഹ്നങ്ങൾ അടുക്കുക},
 				'shifted' => q{അവഗണിക്കൽ ചിഹ്നങ്ങൾ അടുക്കുക},
 			},
 			'colbackwards' => {
 				'no' => q{സാധാരണ ആക്‌സന്റുകൾ പ്രകാരം അടുക്കുക},
 				'yes' => q{ആക്‌സന്റുകളെ വിപരീതക്രമത്തിൽ അടുക്കുക},
 			},
 			'colcasefirst' => {
 				'lower' => q{ആദ്യം ചെറിയക്ഷര പ്രകാരം അടുക്കുക},
 				'no' => q{സാധാരണ കേസ് ക്രമത്തിൽ അടുക്കുക},
 				'upper' => q{ആദ്യം വലിയക്ഷരപ്രകാരം അടുക്കുക},
 			},
 			'colcaselevel' => {
 				'no' => q{കേസ് സെൻസിറ്റീവ് പ്രകാരം അടുക്കുക},
 				'yes' => q{കേസ് സെൻസിറ്റീവ് അടുക്കുക},
 			},
 			'collation' => {
 				'big5han' => q{പരമ്പരാഗത ചൈനീസ് ക്രമീകരണം - ബിഗ്5},
 				'compat' => q{അനുയോജ്യതയ്‌ക്കായുള്ള മുൻ അടുക്കൽ ക്രമം},
 				'dictionary' => q{നിഘണ്ടു അടുക്കൽ ക്രമം},
 				'ducet' => q{സ്ഥിര യൂണികോഡ് അടുക്കൽ ക്രമം},
 				'emoji' => q{ഇമോജി അടുക്കൽ ക്രമം},
 				'eor' => q{യൂറോപ്യൻ അടുക്കൽ നിയമങ്ങൾ},
 				'gb2312han' => q{ലളിതമായ ചൈനീസ് ക്രമീകരണം - ജീബി2312},
 				'phonebook' => q{ഫോൺബുക്കിലെ ക്രമീകരണം},
 				'phonetic' => q{സ്വരസൂചക അടുക്കൽ ക്രമം},
 				'pinyin' => q{പിൻ‌യിൻ ക്രമീകരണം},
 				'reformed' => q{നവീകരിച്ച അടുക്കൽ ക്രമം},
 				'search' => q{പൊതുവായ ആവശ്യത്തിനുള്ള തിരയൽ},
 				'searchjl' => q{ഹാംഗൽ പ്രാരംഭ വ്യഞ്ജനാക്ഷരം പ്രകാരം തിരയുക},
 				'standard' => q{സാധാരണ അടുക്കൽ ക്രമം},
 				'stroke' => q{സ്റ്റ്രോക്ക് ക്രമീകരണം},
 				'traditional' => q{പരമ്പരാഗത ക്രമീകരണം},
 				'unihan' => q{റാഡിക്കൽ-സ്ട്രോക്ക് അടുക്കൽ ക്രമം},
 				'zhuyin' => q{ജുയൻ അടുക്കൽ ക്രമം},
 			},
 			'colnormalization' => {
 				'no' => q{സാധാരണരീതി ഇല്ലാതെ അടുക്കുക},
 				'yes' => q{സാധാരണ യൂണിക്കോഡ് അടുക്കുക},
 			},
 			'colnumeric' => {
 				'no' => q{ഓരോ ഡിജിറ്റുകൾ പ്രകാരം അടുക്കുക},
 				'yes' => q{ഡിജിറ്റുകളെ സംഖ്യാപരമായി അടുക്കുക},
 			},
 			'colstrength' => {
 				'identical' => q{എല്ലാം അടുക്കുക},
 				'primary' => q{അടിസ്ഥാന അക്ഷരങ്ങൾ മാത്രം അടുക്കുക},
 				'quaternary' => q{ആക്‌സന്റുകൾ/കേസ്/വീതി/Kana അടുക്കുക},
 				'secondary' => q{ആക്‌സന്റുകൾ അടുക്കുക},
 				'tertiary' => q{ആക്‌സന്റുകൾ/കേസ്/വീതി അടുക്കുക},
 			},
 			'd0' => {
 				'fwidth' => q{ഫുൾവിഡ്‌ത്തിലേക്ക്},
 				'hwidth' => q{ഹാഫ്‌വിഡ്‌ത്തിലേക്ക്},
 				'npinyin' => q{സംഖ്യാപരമായ},
 			},
 			'hc' => {
 				'h11' => q{12 മണിക്കൂർ സംവിധാനം (0–11)},
 				'h12' => q{12 മണിക്കൂർ സംവിധാനം (1–12)},
 				'h23' => q{24 മണിക്കൂർ സംവിധാനം (0–23)},
 				'h24' => q{24 മണിക്കൂർ സംവിധാനം (1–24)},
 			},
 			'lb' => {
 				'loose' => q{അനിയന്ത്രിത രേഖാ വിഭാജി ശൈലി},
 				'normal' => q{സാധാരണ രേഖ വിഭാജി ശൈലി},
 				'strict' => q{നിയന്ത്രിത രേഖ വിഭാജി ശൈലി},
 			},
 			'm0' => {
 				'bgn' => q{യു.എസ്. BGN ലിപ്യന്തരണം},
 				'ungegn' => q{യു.എൻ. GEGN ലിപ്യന്തരണം},
 			},
 			'ms' => {
 				'metric' => q{മെട്രിക്ക് സംവിധാനം},
 				'uksystem' => q{ബ്രിട്ടീഷ് അളക്കൽ സംവിധാനം},
 				'ussystem' => q{യുഎസ് അളക്കൽ സംവിധാനം},
 			},
 			'numbers' => {
 				'ahom' => q{അഹോം അക്കങ്ങൾ},
 				'arab' => q{അറബിക്-ഇന്ത്യ അക്കങ്ങൾ},
 				'arabext' => q{വിപുലീകൃത അറബിക്-ഇന്ത്യ അക്കങ്ങൾ},
 				'armn' => q{അർമേനിയൻ സംഖ്യകൾ},
 				'armnlow' => q{അർമേനിയൻ ചെറിയ സംഖ്യകൾ},
 				'bali' => q{ബെലിനീസ് അക്കങ്ങൾ},
 				'beng' => q{ബംഗ്ലാ അക്കങ്ങൾ},
 				'brah' => q{ബ്രാഹ്‌മി അക്കങ്ങൾ},
 				'cakm' => q{ചക്മ അക്കങ്ങൾ},
 				'cham' => q{ചാം അക്കങ്ങൾ},
 				'cyrl' => q{സിറിലിക് അക്കങ്ങൾ},
 				'deva' => q{ദേവനാഗരി അക്കങ്ങൾ},
 				'ethi' => q{എത്യോപിക് സംഖ്യകൾ},
 				'finance' => q{സാമ്പത്തിക സംഖ്യകൾ},
 				'fullwide' => q{പൂർണ വലുപ്പമുള്ള സംഖ്യകൾ},
 				'geor' => q{ജോർജിയൻ സംഖ്യകൾ},
 				'gonm' => q{മസാറം ഗോണ്ടി അക്കങ്ങൾ},
 				'grek' => q{ഗ്രീക്ക് സംഖ്യകൾ},
 				'greklow' => q{ഗ്രീക്ക് ചെറിയക്ഷര സംഖ്യകൾ},
 				'gujr' => q{ഗുജറാത്തി അക്കങ്ങൾ},
 				'guru' => q{ഗുരുമുഖി അക്കങ്ങൾ},
 				'hanidec' => q{ചൈനീസ് ദശാംശ സംഖ്യകൾ},
 				'hans' => q{ലളിതവൽക്കരിച്ച ചൈനീസ് സംഖ്യകൾ},
 				'hansfin' => q{ലളിതവൽക്കരിച്ച ചൈനീസ് ധനകാര്യ സംഖ്യകൾ},
 				'hant' => q{പരമ്പരാഗത ചൈനീസ് സംഖ്യകൾ},
 				'hantfin' => q{പരമ്പരാഗത ചൈനീസ് ധനകാര്യ സംഖ്യകൾ},
 				'hebr' => q{ഹീബ്രു സംഖ്യകൾ},
 				'hmng' => q{പഹാവ് മോംഗ് അക്കങ്ങൾ},
 				'java' => q{ജാവനീസ് അക്കങ്ങൾ},
 				'jpan' => q{ജാപ്പനീസ് സംഖ്യകൾ},
 				'jpanfin' => q{ജാപ്പനീസ് ധനകാര്യ സംഖ്യകൾ},
 				'kali' => q{കയാഹ് ലി അക്കങ്ങൾ},
 				'khmr' => q{ഖമേർ അക്കങ്ങൾ},
 				'knda' => q{കന്നഡ സംഖ്യകൾ},
 				'lana' => q{തായ് താം ഹോറ അക്കങ്ങൾ},
 				'lanatham' => q{തായ് താം താം അക്കങ്ങൾ},
 				'laoo' => q{ലാവോ അക്കങ്ങൾ},
 				'latn' => q{പടിഞ്ഞാറൻ അക്കങ്ങൾ},
 				'lepc' => q{ലെപ്‌ച അക്കങ്ങൾ},
 				'limb' => q{ലിംബു അക്കങ്ങൾ},
 				'mathbold' => q{ഗണിത ബോൾഡ് അക്കങ്ങൾ},
 				'mathdbl' => q{ഗണിത ഏകസ്‌പെയ്‌സ് അക്കങ്ങൾ},
 				'mathmono' => q{ഗണിത ഏകസ്‌പെയ്‌സ് അക്കങ്ങൾ},
 				'mathsanb' => q{ഗണിത സാൻസ്‌-സെരീഫ് ബോൾഡ് അക്കങ്ങൾ},
 				'mathsans' => q{ഗണിത സാൻസ്-സെരീഫ് അക്കങ്ങൾ},
 				'mlym' => q{മലയാളം അക്കങ്ങൾ},
 				'modi' => q{മോഡി അക്കങ്ങൾ},
 				'mong' => q{മംഗോളിയൻ സംഖ്യകൾ},
 				'mroo' => q{മ്രോ അക്കങ്ങൾ},
 				'mtei' => q{മീറ്റെയ് മായെക് അക്കങ്ങൾ},
 				'mymr' => q{മ്യാൻമാർ അക്കങ്ങൾ},
 				'mymrshan' => q{മ്യാൻമാർ ഷാൻ അക്കങ്ങൾ},
 				'mymrtlng' => q{മ്യാൻമാർ തായ് ലെയിംഗ് അക്കങ്ങൾ},
 				'native' => q{തദ്ദേശീയ അക്കങ്ങൾ},
 				'nkoo' => q{എൻകോ അക്കങ്ങൾ},
 				'olck' => q{ഓൾ ചികി അക്കങ്ങൾ},
 				'orya' => q{ഒഡിയ അക്കങ്ങൾ},
 				'osma' => q{ഒസ്‌മാന്യ അക്കങ്ങൾ},
 				'roman' => q{റോമൻ സംഖ്യകൾ},
 				'romanlow' => q{റോമൻ ചെറിയ സംഖ്യകൾ},
 				'saur' => q{സൗരാഷ്‌ട്ര അക്കങ്ങൾ},
 				'shrd' => q{ശാരദ അക്കങ്ങൾ},
 				'sind' => q{ഖുഡവാഡി അക്കങ്ങൾ},
 				'sinh' => q{സിംഹള ലിത് അക്കങ്ങൾ},
 				'sora' => q{സോറ സോംപെങ് അക്കങ്ങൾ},
 				'sund' => q{സുഡാനീസ് അക്കങ്ങൾ},
 				'takr' => q{ടാക്രി അക്കങ്ങൾ},
 				'talu' => q{പുതിയ തായ് ലൂ അക്കങ്ങൾ},
 				'taml' => q{പരമ്പരാഗത തമിഴ് സംഖ്യകൾ},
 				'tamldec' => q{തമിഴ് അക്കങ്ങൾ},
 				'telu' => q{തെലുങ്ക് സംഖ്യകൾ},
 				'thai' => q{തായി അക്കങ്ങൾ},
 				'tibt' => q{ടിബറ്റൻ അക്കങ്ങൾ},
 				'tirh' => q{തിർഹുത്ത അക്കങ്ങൾ},
 				'traditional' => q{സാധാരണയായി ഉപയോഗിച്ചുവരുന്ന സംഖ്യകൾ},
 				'vaii' => q{വായ് സംഖ്യകൾ},
 				'wara' => q{വറാങ് സിറ്റി അക്കങ്ങൾ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{മെട്രിക്ക്},
 			'UK' => q{യുകെ},
 			'US' => q{യുഎസ്},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'ഭാഷ: {0}',
 			'script' => 'ലിപി: {0}',
 			'region' => 'പ്രദേശം: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌‍ഃ ൠ ഌ ൡ ൿ]},
			index => ['അ', 'ആ', 'ഇ', 'ഈ', 'ഉ', 'ഊ', 'ഋ', 'എ', 'ഏ', 'ഐ', 'ഒ', 'ഓ', 'ഔ', 'ക', 'ഖ', 'ഗ', 'ഘ', 'ങ', 'ച', 'ഛ', 'ജ', 'ഝ', 'ഞ', 'ട', 'ഠ', 'ഡ', 'ഢ', 'ണ', 'ത', 'ഥ', 'ദ', 'ധ', 'ന', 'പ', 'ഫ', 'ബ', 'ഭ', 'മ', 'യ', 'ര', 'ല', 'വ', 'ശ', 'ഷ', 'സ', 'ഹ', 'ള', 'ഴ', 'റ'],
			main => qr{[അ ആ ഇ ഈ ഉ ഊ ഋ എ ഏ ഐ ഒ ഓ ഔ ക ഖ ഗ ഘ ങ ച ഛ ജ ഝ ഞ ട ഠ ഡ ഢ ണ ൺ ത ഥ ദ ധ ന ൻ പ ഫ ബ ഭ മ ം യ ര ർ ല ൽ വ ശ ഷ സ ഹ ള ൾ ഴ റ ാ ി ീ ു ൂ ൃ െ േ ൈ ൊ ോ ൌ ൗ ്]},
			numbers => qr{[\- ‑ , . % ‰ + 0൦ 1൧ 2൨ 3൩ 4൪ 5൫ 6൬ 7൭ 8൮ 9൯]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘’ "“” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['അ', 'ആ', 'ഇ', 'ഈ', 'ഉ', 'ഊ', 'ഋ', 'എ', 'ഏ', 'ഐ', 'ഒ', 'ഓ', 'ഔ', 'ക', 'ഖ', 'ഗ', 'ഘ', 'ങ', 'ച', 'ഛ', 'ജ', 'ഝ', 'ഞ', 'ട', 'ഠ', 'ഡ', 'ഢ', 'ണ', 'ത', 'ഥ', 'ദ', 'ധ', 'ന', 'പ', 'ഫ', 'ബ', 'ഭ', 'മ', 'യ', 'ര', 'ല', 'വ', 'ശ', 'ഷ', 'സ', 'ഹ', 'ള', 'ഴ', 'റ'], };
},
);


has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(കാർഡിനൽ ദിശ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(കാർഡിനൽ ദിശ),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(കിബി{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(കിബി{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(മെബി{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(മെബി{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(gibi{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(gibi{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(tebi{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(tebi{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(pebi{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(pebi{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(exbi{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(exbi{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(zebi{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(zebi{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(യോബൈ{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(യോബൈ{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ഡെസി{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ഡെസി{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(പിക്കോ{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(പിക്കോ{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ഫെംറ്റോ{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ഫെംറ്റോ{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(ആറ്റോ{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(ആറ്റോ{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(സെന്റി{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(സെന്റി{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(സെപ്റ്റോ{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(സെപ്റ്റോ{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(യോക്റ്റോ{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(യോക്റ്റോ{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(മില്ലി{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(മില്ലി{0}),
					},
					# Long Unit Identifier
					'10p-30' => {
						'1' => q(quecto{0}),
					},
					# Core Unit Identifier
					'30' => {
						'1' => q(quecto{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(മൈക്രോ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(മൈക്രോ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(നാനോ{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(നാനോ{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ഡെകാ{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ഡെകാ{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ടെറാ{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ടെറാ{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(പെറ്റാ{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(പെറ്റാ{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(എക്സാ{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(എക്സാ{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ഹെക്റ്റോ{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ഹെക്റ്റോ{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(സെറ്റാ{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(സെറ്റാ{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(യൊറ്റാ{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(യൊറ്റാ{0}),
					},
					# Long Unit Identifier
					'10p27' => {
						'1' => q(ronna{0}),
					},
					# Core Unit Identifier
					'10p27' => {
						'1' => q(ronna{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(കിലോ{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(കിലോ{0}),
					},
					# Long Unit Identifier
					'10p30' => {
						'1' => q(ക്വെറ്റാ{0}),
					},
					# Core Unit Identifier
					'10p30' => {
						'1' => q(ക്വെറ്റാ{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(മെഗാ{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(മെഗാ{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(ഗിഗാ{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(ഗിഗാ{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'1' => q(neuter),
						'one' => q({0} ജി-ഫോഴ്‌സ്),
						'other' => q({0} ജി-ഫോഴ്‌സ്),
					},
					# Core Unit Identifier
					'g-force' => {
						'1' => q(neuter),
						'one' => q({0} ജി-ഫോഴ്‌സ്),
						'other' => q({0} ജി-ഫോഴ്‌സ്),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'one' => q({0} മീറ്റർ/സെക്കൻഡ്²),
						'other' => q({0} മീറ്റർ/സെക്കൻഡ്²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'one' => q({0} മീറ്റർ/സെക്കൻഡ്²),
						'other' => q({0} മീറ്റർ/സെക്കൻഡ്²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'1' => q(neuter),
						'name' => q(ആർക്ക്മിനിറ്റ്),
						'one' => q({0} ആർക്ക്മിനിറ്റ്),
						'other' => q({0} ആർക്ക്മിനിറ്റ്),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'1' => q(neuter),
						'name' => q(ആർക്ക്മിനിറ്റ്),
						'one' => q({0} ആർക്ക്മിനിറ്റ്),
						'other' => q({0} ആർക്ക്മിനിറ്റ്),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'1' => q(neuter),
						'name' => q(ആർക്ക്സെക്കൻഡ്),
						'one' => q({0} ആർക്ക്സെക്കൻഡ്),
						'other' => q({0} ആർക്ക്സെക്കൻഡ്),
					},
					# Core Unit Identifier
					'arc-second' => {
						'1' => q(neuter),
						'name' => q(ആർക്ക്സെക്കൻഡ്),
						'one' => q({0} ആർക്ക്സെക്കൻഡ്),
						'other' => q({0} ആർക്ക്സെക്കൻഡ്),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'1' => q(neuter),
					},
					# Core Unit Identifier
					'degree' => {
						'1' => q(neuter),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'1' => q(neuter),
						'one' => q({0} റേഡിയൻ),
						'other' => q({0} റേഡിയൻ),
					},
					# Core Unit Identifier
					'radian' => {
						'1' => q(neuter),
						'one' => q({0} റേഡിയൻ),
						'other' => q({0} റേഡിയൻ),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'1' => q(neuter),
						'name' => q(റെവല്യൂഷൻ),
						'one' => q({0} റെവല്യൂഷൻ),
						'other' => q({0} റെവല്യൂഷൻ),
					},
					# Core Unit Identifier
					'revolution' => {
						'1' => q(neuter),
						'name' => q(റെവല്യൂഷൻ),
						'one' => q({0} റെവല്യൂഷൻ),
						'other' => q({0} റെവല്യൂഷൻ),
					},
					# Long Unit Identifier
					'area-acre' => {
						'one' => q({0} ഏക്കർ),
						'other' => q({0} ഏക്കർ),
					},
					# Core Unit Identifier
					'acre' => {
						'one' => q({0} ഏക്കർ),
						'other' => q({0} ഏക്കർ),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(ദുനം),
						'one' => q({0} ദുനം),
						'other' => q({0} ദുനങ്ങൾ),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(ദുനം),
						'one' => q({0} ദുനം),
						'other' => q({0} ദുനങ്ങൾ),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'1' => q(neuter),
						'one' => q({0} ഹെക്‌ടർ),
						'other' => q({0} ഹെക്‌ടർ),
					},
					# Core Unit Identifier
					'hectare' => {
						'1' => q(neuter),
						'one' => q({0} ഹെക്‌ടർ),
						'other' => q({0} ഹെക്‌ടർ),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(ചതുരശ്ര സെന്റിമീറ്റർ),
						'one' => q({0} ചതുരശ്ര സെന്റിമീറ്റർ),
						'other' => q({0} ചതുരശ്ര സെന്റിമീറ്റർ),
						'per' => q({0} / ചതുരശ്ര സെന്റിമീറ്റർ),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(ചതുരശ്ര സെന്റിമീറ്റർ),
						'one' => q({0} ചതുരശ്ര സെന്റിമീറ്റർ),
						'other' => q({0} ചതുരശ്ര സെന്റിമീറ്റർ),
						'per' => q({0} / ചതുരശ്ര സെന്റിമീറ്റർ),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ചതുരശ്ര അടി),
						'one' => q({0} ചതുരശ്ര അടി),
						'other' => q({0} ചതുരശ്ര അടി),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ചതുരശ്ര അടി),
						'one' => q({0} ചതുരശ്ര അടി),
						'other' => q({0} ചതുരശ്ര അടി),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(ചതുരശ്ര ഇഞ്ച്),
						'one' => q({0} ചതുരശ്ര ഇഞ്ച്),
						'other' => q({0} ചതുരശ്ര ഇഞ്ച്),
						'per' => q({0} / ചതുരശ്ര ഇഞ്ച്),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(ചതുരശ്ര ഇഞ്ച്),
						'one' => q({0} ചതുരശ്ര ഇഞ്ച്),
						'other' => q({0} ചതുരശ്ര ഇഞ്ച്),
						'per' => q({0} / ചതുരശ്ര ഇഞ്ച്),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(ചതുരശ്ര കിലോമീറ്റർ),
						'one' => q({0} ചതുരശ്ര കിലോമീറ്റർ),
						'other' => q({0} ചതുരശ്ര കിലോമീറ്റർ),
						'per' => q({0}/ചതുരശ്ര കിലോമീറ്റർ),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(ചതുരശ്ര കിലോമീറ്റർ),
						'one' => q({0} ചതുരശ്ര കിലോമീറ്റർ),
						'other' => q({0} ചതുരശ്ര കിലോമീറ്റർ),
						'per' => q({0}/ചതുരശ്ര കിലോമീറ്റർ),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(ചതുരശ്ര മീറ്റർ),
						'one' => q({0} ചതുരശ്ര മീറ്റർ),
						'other' => q({0} ചതുരശ്ര മീറ്റർ),
						'per' => q({0} / ചതുരശ്ര മീറ്റർ),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(ചതുരശ്ര മീറ്റർ),
						'one' => q({0} ചതുരശ്ര മീറ്റർ),
						'other' => q({0} ചതുരശ്ര മീറ്റർ),
						'per' => q({0} / ചതുരശ്ര മീറ്റർ),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(ചതുരശ്ര മൈൽ),
						'one' => q({0} ചതുരശ്ര മൈൽ),
						'other' => q({0} ചതുരശ്ര മൈൽ),
						'per' => q({0} / ചതുരശ്ര മൈൽ),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(ചതുരശ്ര മൈൽ),
						'one' => q({0} ചതുരശ്ര മൈൽ),
						'other' => q({0} ചതുരശ്ര മൈൽ),
						'per' => q({0} / ചതുരശ്ര മൈൽ),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(ചതുരശ്ര വാര),
						'one' => q({0} ചതുരശ്ര വാര),
						'other' => q({0} ചതുരശ്ര വാര),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(ചതുരശ്ര വാര),
						'one' => q({0} ചതുരശ്ര വാര),
						'other' => q({0} ചതുരശ്ര വാര),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ഇനങ്ങൾ),
						'one' => q({0} ഇനം),
						'other' => q({0} ഇനങ്ങൾ),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ഇനങ്ങൾ),
						'one' => q({0} ഇനം),
						'other' => q({0} ഇനങ്ങൾ),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'1' => q(neuter),
						'one' => q({0} ക്യാരറ്റ്),
						'other' => q({0} ക്യാരറ്റ്),
					},
					# Core Unit Identifier
					'karat' => {
						'1' => q(neuter),
						'one' => q({0} ക്യാരറ്റ്),
						'other' => q({0} ക്യാരറ്റ്),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(മില്ലിഗ്രാം / ഡെസിലിറ്റർ),
						'one' => q({0} മില്ലിഗ്രാം / ഡെസിലിറ്റർ),
						'other' => q({0} മില്ലിഗ്രാം / ഡെസിലിറ്റർ),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(മില്ലിഗ്രാം / ഡെസിലിറ്റർ),
						'one' => q({0} മില്ലിഗ്രാം / ഡെസിലിറ്റർ),
						'other' => q({0} മില്ലിഗ്രാം / ഡെസിലിറ്റർ),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(മില്ലിമോൾ / ലിറ്റർ),
						'one' => q({0} മില്ലിമോൾ / ലിറ്റർ),
						'other' => q({0} മില്ലിമോൾ / ലിറ്റർ),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(മില്ലിമോൾ / ലിറ്റർ),
						'one' => q({0} മില്ലിമോൾ / ലിറ്റർ),
						'other' => q({0} മില്ലിമോൾ / ലിറ്റർ),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'1' => q(neuter),
						'name' => q(മോളുകൾ),
						'one' => q({0} മോൾ),
						'other' => q({0} മോളുകൾ),
					},
					# Core Unit Identifier
					'mole' => {
						'1' => q(neuter),
						'name' => q(മോളുകൾ),
						'one' => q({0} മോൾ),
						'other' => q({0} മോളുകൾ),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'1' => q(neuter),
					},
					# Core Unit Identifier
					'percent' => {
						'1' => q(neuter),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'1' => q(neuter),
						'name' => q(പ്രതിമില്ലി),
						'one' => q({0} പ്രതിമില്ലി),
						'other' => q({0} പ്രതിമില്ലി),
					},
					# Core Unit Identifier
					'permille' => {
						'1' => q(neuter),
						'name' => q(പ്രതിമില്ലി),
						'one' => q({0} പ്രതിമില്ലി),
						'other' => q({0} പ്രതിമില്ലി),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'1' => q(neuter),
						'name' => q(പാർട്‌സ് / മില്ല്യൺ),
						'one' => q(പാർട്ട് / മില്ല്യൺ),
						'other' => q({0} പാർട്‌സ് / മില്ല്യൺ),
					},
					# Core Unit Identifier
					'permillion' => {
						'1' => q(neuter),
						'name' => q(പാർട്‌സ് / മില്ല്യൺ),
						'one' => q(പാർട്ട് / മില്ല്യൺ),
						'other' => q({0} പാർട്‌സ് / മില്ല്യൺ),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'1' => q(neuter),
						'one' => q({0} പെ൪മിറിയാഡ്),
						'other' => q({0} പെ൪മിറിയാഡ്),
					},
					# Core Unit Identifier
					'permyriad' => {
						'1' => q(neuter),
						'one' => q({0} പെ൪മിറിയാഡ്),
						'other' => q({0} പെ൪മിറിയാഡ്),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ലിറ്റർ/100 കിലോമീറ്റർ),
						'one' => q({0} ലിറ്റർ/100 കിലോമീറ്റർ),
						'other' => q({0} ലിറ്റർ/100 കിലോമീറ്റർ),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ലിറ്റർ/100 കിലോമീറ്റർ),
						'one' => q({0} ലിറ്റർ/100 കിലോമീറ്റർ),
						'other' => q({0} ലിറ്റർ/100 കിലോമീറ്റർ),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ലിറ്റർ/കിലോമീറ്റർ),
						'one' => q({0} ലിറ്റർ/കിലോമീറ്റർ),
						'other' => q({0} ലിറ്റർ/കിലോമീറ്റർ),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ലിറ്റർ/കിലോമീറ്റർ),
						'one' => q({0} ലിറ്റർ/കിലോമീറ്റർ),
						'other' => q({0} ലിറ്റർ/കിലോമീറ്റർ),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(മൈൽ/ഗാലൻ),
						'one' => q({0} മൈൽ/ഗാലൻ),
						'other' => q({0} മൈൽ/ഗാലൻ),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(മൈൽ/ഗാലൻ),
						'one' => q({0} മൈൽ/ഗാലൻ),
						'other' => q({0} മൈൽ/ഗാലൻ),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(മൈൽ / ഇംപീ. ഗാലൺ),
						'one' => q({0} മൈൽ / ഇംപീ. ഗാലൺ),
						'other' => q({0} മൈൽ / ഇംപീ. ഗാലൺ),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(മൈൽ / ഇംപീ. ഗാലൺ),
						'one' => q({0} മൈൽ / ഇംപീ. ഗാലൺ),
						'other' => q({0} മൈൽ / ഇംപീ. ഗാലൺ),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} കിഴക്ക്),
						'north' => q({0} വടക്ക്),
						'south' => q({0} തെക്ക്),
						'west' => q({0} പടിഞ്ഞാറ്),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} കിഴക്ക്),
						'north' => q({0} വടക്ക്),
						'south' => q({0} തെക്ക്),
						'west' => q({0} പടിഞ്ഞാറ്),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'1' => q(neuter),
					},
					# Core Unit Identifier
					'bit' => {
						'1' => q(neuter),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'1' => q(neuter),
					},
					# Core Unit Identifier
					'byte' => {
						'1' => q(neuter),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(ഗിഗാബിറ്റ്),
						'one' => q({0} ജിഗാബിറ്റ്),
						'other' => q({0} ജിഗാബിറ്റ്),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(ഗിഗാബിറ്റ്),
						'one' => q({0} ജിഗാബിറ്റ്),
						'other' => q({0} ജിഗാബിറ്റ്),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(ഗിഗാബൈറ്റ്),
						'one' => q({0} ഗിഗാബൈറ്റ്),
						'other' => q({0} ഗിഗാബൈറ്റ്),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(ഗിഗാബൈറ്റ്),
						'one' => q({0} ഗിഗാബൈറ്റ്),
						'other' => q({0} ഗിഗാബൈറ്റ്),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(കിലോബിറ്റ്),
						'one' => q({0} കിലോബിറ്റ്),
						'other' => q({0} കിലോബിറ്റ്),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(കിലോബിറ്റ്),
						'one' => q({0} കിലോബിറ്റ്),
						'other' => q({0} കിലോബിറ്റ്),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(കിലോബൈറ്റ്),
						'one' => q({0} കിലോബൈറ്റ്),
						'other' => q({0} കിലോബൈറ്റ്),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(കിലോബൈറ്റ്),
						'one' => q({0} കിലോബൈറ്റ്),
						'other' => q({0} കിലോബൈറ്റ്),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(മെഗാബിറ്റ്),
						'one' => q({0} മെഗാബിറ്റ്),
						'other' => q({0} മെഗാബിറ്റ്),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(മെഗാബിറ്റ്),
						'one' => q({0} മെഗാബിറ്റ്),
						'other' => q({0} മെഗാബിറ്റ്),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(മെഗാബൈറ്റ്),
						'one' => q({0} മെഗാബൈറ്റ്),
						'other' => q({0} മെഗാബൈറ്റ്),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(മെഗാബൈറ്റ്),
						'one' => q({0} മെഗാബൈറ്റ്),
						'other' => q({0} മെഗാബൈറ്റ്),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(പെറ്റാബൈറ്റുകൾ),
						'one' => q({0} പെറ്റാബൈറ്റ്),
						'other' => q({0} പെറ്റാബൈറ്റ്),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(പെറ്റാബൈറ്റുകൾ),
						'one' => q({0} പെറ്റാബൈറ്റ്),
						'other' => q({0} പെറ്റാബൈറ്റ്),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(ടെറാബിറ്റ്),
						'one' => q({0} ടെറാബിറ്റ്),
						'other' => q({0} ടെറാബിറ്റ്),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(ടെറാബിറ്റ്),
						'one' => q({0} ടെറാബിറ്റ്),
						'other' => q({0} ടെറാബിറ്റ്),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ടെറാബൈറ്റ്),
						'one' => q({0} ടെറാബൈറ്റ്),
						'other' => q({0} ടെറാബൈറ്റ്),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ടെറാബൈറ്റ്),
						'one' => q({0} ടെറാബൈറ്റ്),
						'other' => q({0} ടെറാബൈറ്റ്),
					},
					# Long Unit Identifier
					'duration-century' => {
						'1' => q(neuter),
						'name' => q(നൂറ്റാണ്ടുകൾ),
						'one' => q({0} നൂറ്റാണ്ട്),
						'other' => q({0} നൂറ്റാണ്ടുകൾ),
					},
					# Core Unit Identifier
					'century' => {
						'1' => q(neuter),
						'name' => q(നൂറ്റാണ്ടുകൾ),
						'one' => q({0} നൂറ്റാണ്ട്),
						'other' => q({0} നൂറ്റാണ്ടുകൾ),
					},
					# Long Unit Identifier
					'duration-day' => {
						'1' => q(neuter),
						'one' => q({0} ദിവസം),
						'other' => q({0} ദിവസം),
						'per' => q({0} / ദിവസം),
					},
					# Core Unit Identifier
					'day' => {
						'1' => q(neuter),
						'one' => q({0} ദിവസം),
						'other' => q({0} ദിവസം),
						'per' => q({0} / ദിവസം),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'1' => q(neuter),
						'name' => q(ദശാബ്‌ദം),
						'one' => q(ദശാബ്‌ദം),
						'other' => q({0} ദശാബ്‌ദം),
					},
					# Core Unit Identifier
					'decade' => {
						'1' => q(neuter),
						'name' => q(ദശാബ്‌ദം),
						'one' => q(ദശാബ്‌ദം),
						'other' => q({0} ദശാബ്‌ദം),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'1' => q(neuter),
						'one' => q({0} മണിക്കൂർ),
						'other' => q({0} മണിക്കൂർ),
						'per' => q({0} / മണിക്കൂർ),
					},
					# Core Unit Identifier
					'hour' => {
						'1' => q(neuter),
						'one' => q({0} മണിക്കൂർ),
						'other' => q({0} മണിക്കൂർ),
						'per' => q({0} / മണിക്കൂർ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(മൈക്രോസെക്കൻഡ്),
						'one' => q({0} മൈക്രോസെക്കൻഡ്),
						'other' => q({0} മൈക്രോസെക്കൻഡ്),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(മൈക്രോസെക്കൻഡ്),
						'one' => q({0} മൈക്രോസെക്കൻഡ്),
						'other' => q({0} മൈക്രോസെക്കൻഡ്),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'one' => q({0} മില്ലിസെക്കൻഡ്),
						'other' => q({0} മില്ലിസെക്കൻഡ്),
					},
					# Core Unit Identifier
					'millisecond' => {
						'one' => q({0} മില്ലിസെക്കൻഡ്),
						'other' => q({0} മില്ലിസെക്കൻഡ്),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'1' => q(neuter),
						'name' => q(മിനിറ്റ്),
						'one' => q({0} മിനിറ്റ്),
						'other' => q({0} മിനിറ്റ്),
						'per' => q({0} / മിനിറ്റ്),
					},
					# Core Unit Identifier
					'minute' => {
						'1' => q(neuter),
						'name' => q(മിനിറ്റ്),
						'one' => q({0} മിനിറ്റ്),
						'other' => q({0} മിനിറ്റ്),
						'per' => q({0} / മിനിറ്റ്),
					},
					# Long Unit Identifier
					'duration-month' => {
						'1' => q(neuter),
						'per' => q({0} / മാസം),
					},
					# Core Unit Identifier
					'month' => {
						'1' => q(neuter),
						'per' => q({0} / മാസം),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'one' => q({0} നാനോസെക്കൻഡ്),
						'other' => q({0} നാനോസെക്കൻഡ്),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'one' => q({0} നാനോസെക്കൻഡ്),
						'other' => q({0} നാനോസെക്കൻഡ്),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(പാദങ്ങൾ),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(പാദങ്ങൾ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'1' => q(neuter),
						'one' => q({0} സെക്കൻഡ്),
						'other' => q({0} സെക്കൻഡ്),
						'per' => q({0} / സെക്കൻഡ്),
					},
					# Core Unit Identifier
					'second' => {
						'1' => q(neuter),
						'one' => q({0} സെക്കൻഡ്),
						'other' => q({0} സെക്കൻഡ്),
						'per' => q({0} / സെക്കൻഡ്),
					},
					# Long Unit Identifier
					'duration-week' => {
						'1' => q(neuter),
						'one' => q({0} ആഴ്ച),
						'other' => q({0} ആഴ്ച),
						'per' => q({0} / ആഴ്ച),
					},
					# Core Unit Identifier
					'week' => {
						'1' => q(neuter),
						'one' => q({0} ആഴ്ച),
						'other' => q({0} ആഴ്ച),
						'per' => q({0} / ആഴ്ച),
					},
					# Long Unit Identifier
					'duration-year' => {
						'1' => q(neuter),
						'one' => q({0} വർഷം),
						'other' => q({0} വർഷം),
						'per' => q({0} / വർഷം),
					},
					# Core Unit Identifier
					'year' => {
						'1' => q(neuter),
						'one' => q({0} വർഷം),
						'other' => q({0} വർഷം),
						'per' => q({0} / വർഷം),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'1' => q(neuter),
						'one' => q({0} ആമ്പിയർ),
						'other' => q({0} ആമ്പിയർ),
					},
					# Core Unit Identifier
					'ampere' => {
						'1' => q(neuter),
						'one' => q({0} ആമ്പിയർ),
						'other' => q({0} ആമ്പിയർ),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'one' => q({0} മില്ലിആമ്പിയർ),
						'other' => q({0} മില്ലിആമ്പിയർ),
					},
					# Core Unit Identifier
					'milliampere' => {
						'one' => q({0} മില്ലിആമ്പിയർ),
						'other' => q({0} മില്ലിആമ്പിയർ),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'1' => q(neuter),
						'one' => q({0} ഓം),
						'other' => q({0} ഓം),
					},
					# Core Unit Identifier
					'ohm' => {
						'1' => q(neuter),
						'one' => q({0} ഓം),
						'other' => q({0} ഓം),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'1' => q(neuter),
						'one' => q({0} വോൾട്ട്),
						'other' => q({0} വോൾട്ട്),
					},
					# Core Unit Identifier
					'volt' => {
						'1' => q(neuter),
						'one' => q({0} വോൾട്ട്),
						'other' => q({0} വോൾട്ട്),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(ബ്രിട്ടീഷ് തെർമൽ യൂണിറ്റ്),
						'one' => q({0} ബ്രിട്ടീഷ് തെർമൽ യൂണിറ്റ്),
						'other' => q({0} ബ്രിട്ടീഷ് തെർമൽ യൂണിറ്റുകൾ),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(ബ്രിട്ടീഷ് തെർമൽ യൂണിറ്റ്),
						'one' => q({0} ബ്രിട്ടീഷ് തെർമൽ യൂണിറ്റ്),
						'other' => q({0} ബ്രിട്ടീഷ് തെർമൽ യൂണിറ്റുകൾ),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'1' => q(neuter),
						'name' => q(കലോറി),
						'one' => q({0} കലോറി),
						'other' => q({0} കലോറി),
					},
					# Core Unit Identifier
					'calorie' => {
						'1' => q(neuter),
						'name' => q(കലോറി),
						'one' => q({0} കലോറി),
						'other' => q({0} കലോറി),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'one' => q({0} ഇലക്ട്രോൺവോൾട്ട്),
						'other' => q({0} ഇലക്ട്രോൺവോൾട്ട്),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'one' => q({0} ഇലക്ട്രോൺവോൾട്ട്),
						'other' => q({0} ഇലക്ട്രോൺവോൾട്ട്),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(കലോറി),
						'one' => q({0} കലോറി),
						'other' => q({0} കലോറി),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(കലോറി),
						'one' => q({0} കലോറി),
						'other' => q({0} കലോറി),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'1' => q(neuter),
						'one' => q({0} ജൂൾ),
						'other' => q({0} ജൂൾ),
					},
					# Core Unit Identifier
					'joule' => {
						'1' => q(neuter),
						'one' => q({0} ജൂൾ),
						'other' => q({0} ജൂൾ),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(കിലോകലോറി),
						'one' => q({0} കിലോകലോറി),
						'other' => q({0} കിലോകലോറി),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(കിലോകലോറി),
						'one' => q({0} കിലോകലോറി),
						'other' => q({0} കിലോകലോറി),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(കിലോജൂൾ),
						'one' => q({0} കിലോജൂൾ),
						'other' => q({0} കിലോജൂൾ),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(കിലോജൂൾ),
						'one' => q({0} കിലോജൂൾ),
						'other' => q({0} കിലോജൂൾ),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(കിലോവാട്ട് മണിക്കൂർ),
						'one' => q({0} കിലോവാട്ട്/മണിക്കൂർ),
						'other' => q({0} കിലോവാട്ട്/മണിക്കൂർ),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(കിലോവാട്ട് മണിക്കൂർ),
						'one' => q({0} കിലോവാട്ട്/മണിക്കൂർ),
						'other' => q({0} കിലോവാട്ട്/മണിക്കൂർ),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(കിലോവാട്ട് മണിക്കൂ൪ പെ൪ 100 കിലോമീറ്റ൪),
						'one' => q({0} കിലോവാട്ട് മണിക്കൂ൪ പെ൪ 100 കിലോമീറ്റ൪),
						'other' => q({0} കിലോവാട്ട് മണിക്കൂ൪ പെ൪ 100 കിലോമീറ്റ൪),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(കിലോവാട്ട് മണിക്കൂ൪ പെ൪ 100 കിലോമീറ്റ൪),
						'one' => q({0} കിലോവാട്ട് മണിക്കൂ൪ പെ൪ 100 കിലോമീറ്റ൪),
						'other' => q({0} കിലോവാട്ട് മണിക്കൂ൪ പെ൪ 100 കിലോമീറ്റ൪),
					},
					# Long Unit Identifier
					'force-newton' => {
						'1' => q(neuter),
						'name' => q(ന്യൂട്ടൻസ്),
						'one' => q({0} ന്യൂട്ടൻ),
						'other' => q({0} ന്യൂട്ടൻസ്),
					},
					# Core Unit Identifier
					'newton' => {
						'1' => q(neuter),
						'name' => q(ന്യൂട്ടൻസ്),
						'one' => q({0} ന്യൂട്ടൻ),
						'other' => q({0} ന്യൂട്ടൻസ്),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(പൗണ്ട്സ് ഓഫ് ഫോഴ്സ്),
						'one' => q({0} പൗണ്ട് ഓഫ് ഫോഴ്സ്),
						'other' => q({0} പൗണ്ട്സ് ഓഫ് ഫോഴ്സ്),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(പൗണ്ട്സ് ഓഫ് ഫോഴ്സ്),
						'one' => q({0} പൗണ്ട് ഓഫ് ഫോഴ്സ്),
						'other' => q({0} പൗണ്ട്സ് ഓഫ് ഫോഴ്സ്),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(ജിഗാഹെർട്സ്),
						'one' => q({0} ഗിഗാഹെർട്സ്),
						'other' => q({0} ഗിഗാഹെർട്സ്),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(ജിഗാഹെർട്സ്),
						'one' => q({0} ഗിഗാഹെർട്സ്),
						'other' => q({0} ഗിഗാഹെർട്സ്),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'1' => q(neuter),
						'name' => q(ഹെർട്സ്),
						'one' => q({0} ഹെർട്സ്),
						'other' => q({0} ഹെർട്സ്),
					},
					# Core Unit Identifier
					'hertz' => {
						'1' => q(neuter),
						'name' => q(ഹെർട്സ്),
						'one' => q({0} ഹെർട്സ്),
						'other' => q({0} ഹെർട്സ്),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(കിലോഹെർട്സ്),
						'one' => q({0} കിലോഹെർട്സ്),
						'other' => q({0} കിലോഹെർട്സ്),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(കിലോഹെർട്സ്),
						'one' => q({0} കിലോഹെർട്സ്),
						'other' => q({0} കിലോഹെർട്സ്),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(മെഗാഹെർട്സ്),
						'one' => q({0} മെഗാഹെർട്സ്),
						'other' => q({0} മെഗാഹെർട്സ്),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(മെഗാഹെർട്സ്),
						'one' => q({0} മെഗാഹെർട്സ്),
						'other' => q({0} മെഗാഹെർട്സ്),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(ഡോട്ട്സ് പ൪ സെന്റിമീറ്റ൪),
						'one' => q({0} ഡോട്ട് പ൪ സെന്റിമീറ്റ൪),
						'other' => q({0} ഡോട്ട്സ് പ൪ സെന്റിമീറ്റ൪),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(ഡോട്ട്സ് പ൪ സെന്റിമീറ്റ൪),
						'one' => q({0} ഡോട്ട് പ൪ സെന്റിമീറ്റ൪),
						'other' => q({0} ഡോട്ട്സ് പ൪ സെന്റിമീറ്റ൪),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(ഡോട്ട്സ് പ൪ ഇഞ്ച്),
						'one' => q({0} ഡോട്ട്സ് പ൪ ഇഞ്ച്),
						'other' => q({0} ഡോട്ട്സ് പ൪ ഇഞ്ച്),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(ഡോട്ട്സ് പ൪ ഇഞ്ച്),
						'one' => q({0} ഡോട്ട്സ് പ൪ ഇഞ്ച്),
						'other' => q({0} ഡോട്ട്സ് പ൪ ഇഞ്ച്),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'1' => q(neuter),
						'name' => q(ടൈപോഗ്രഫിക്ക് ems),
						'one' => q({0} em),
						'other' => q({0} ems),
					},
					# Core Unit Identifier
					'em' => {
						'1' => q(neuter),
						'name' => q(ടൈപോഗ്രഫിക്ക് ems),
						'one' => q({0} em),
						'other' => q({0} ems),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(മെഗാപിക്സൽസ്),
						'one' => q({0} മെഗാപിക്സൽ),
						'other' => q({0} മെഗാപിക്സൽസ്),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(മെഗാപിക്സൽസ്),
						'one' => q({0} മെഗാപിക്സൽ),
						'other' => q({0} മെഗാപിക്സൽസ്),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'1' => q(neuter),
						'name' => q(പിക്സൽസ്),
						'one' => q({0} പിക്സൽ),
						'other' => q({0} px),
					},
					# Core Unit Identifier
					'pixel' => {
						'1' => q(neuter),
						'name' => q(പിക്സൽസ്),
						'one' => q({0} പിക്സൽ),
						'other' => q({0} px),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(പിക്സൽസ് പ൪ സെന്റിമീറ്റ൪),
						'one' => q({0} പിക്സൽ പ൪ സെന്റിമീറ്റ൪),
						'other' => q({0} പിക്സൽസ് പ൪ സെന്റിമീറ്റ൪),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(പിക്സൽസ് പ൪ സെന്റിമീറ്റ൪),
						'one' => q({0} പിക്സൽ പ൪ സെന്റിമീറ്റ൪),
						'other' => q({0} പിക്സൽസ് പ൪ സെന്റിമീറ്റ൪),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(പിക്സൽസ് പ൪ ഇഞ്ച്),
						'one' => q({0} പിക്സൽ പ൪ ഇഞ്ച്),
						'other' => q({0} പിക്സൽസ് പ൪ ഇഞ്ച്),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(പിക്സൽസ് പ൪ ഇഞ്ച്),
						'one' => q({0} പിക്സൽ പ൪ ഇഞ്ച്),
						'other' => q({0} പിക്സൽസ് പ൪ ഇഞ്ച്),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(ജ്യോതിശാസ്‌ത്ര യൂണിറ്റ്),
						'one' => q({0} ജ്യോതിശാസ്‌ത്ര യൂണിറ്റ്),
						'other' => q({0} ജ്യോതിശാസ്‌ത്ര യൂണിറ്റ്),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(ജ്യോതിശാസ്‌ത്ര യൂണിറ്റ്),
						'one' => q({0} ജ്യോതിശാസ്‌ത്ര യൂണിറ്റ്),
						'other' => q({0} ജ്യോതിശാസ്‌ത്ര യൂണിറ്റ്),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(സെന്റീമീറ്റർ),
						'one' => q({0} സെന്റീമീറ്റർ),
						'other' => q({0} സെന്റീമീറ്റർ),
						'per' => q({0} / സെന്റിമീറ്റർ),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(സെന്റീമീറ്റർ),
						'one' => q({0} സെന്റീമീറ്റർ),
						'other' => q({0} സെന്റീമീറ്റർ),
						'per' => q({0} / സെന്റിമീറ്റർ),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ഡെസീമീറ്റർ),
						'one' => q({0} ഡെസീമീറ്റർ),
						'other' => q({0} ഡെസീമീറ്റർ),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ഡെസീമീറ്റർ),
						'one' => q({0} ഡെസീമീറ്റർ),
						'other' => q({0} ഡെസീമീറ്റർ),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'one' => q({0} ഫാതം),
						'other' => q({0} ഫാതം),
					},
					# Core Unit Identifier
					'fathom' => {
						'one' => q({0} ഫാതം),
						'other' => q({0} ഫാതം),
					},
					# Long Unit Identifier
					'length-foot' => {
						'per' => q({0} / അടി),
					},
					# Core Unit Identifier
					'foot' => {
						'per' => q({0} / അടി),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'one' => q({0} ഫർലോങ്),
						'other' => q({0} ഫർലോങ്),
					},
					# Core Unit Identifier
					'furlong' => {
						'one' => q({0} ഫർലോങ്),
						'other' => q({0} ഫർലോങ്),
					},
					# Long Unit Identifier
					'length-inch' => {
						'per' => q({0} / ഇഞ്ച്),
					},
					# Core Unit Identifier
					'inch' => {
						'per' => q({0} / ഇഞ്ച്),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(കിലോമീറ്റർ),
						'one' => q({0} കിലോമീറ്റർ),
						'other' => q({0} കിലോമീറ്റർ),
						'per' => q({0} / കിലോമീറ്റർ),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(കിലോമീറ്റർ),
						'one' => q({0} കിലോമീറ്റർ),
						'other' => q({0} കിലോമീറ്റർ),
						'per' => q({0} / കിലോമീറ്റർ),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'one' => q({0} പ്രകാശവർഷം),
						'other' => q({0} പ്രകാശവർഷം),
					},
					# Core Unit Identifier
					'light-year' => {
						'one' => q({0} പ്രകാശവർഷം),
						'other' => q({0} പ്രകാശവർഷം),
					},
					# Long Unit Identifier
					'length-meter' => {
						'1' => q(neuter),
						'one' => q({0} മീറ്റർ),
						'other' => q({0} മീറ്റർ),
						'per' => q({0} / മീറ്റർ),
					},
					# Core Unit Identifier
					'meter' => {
						'1' => q(neuter),
						'one' => q({0} മീറ്റർ),
						'other' => q({0} മീറ്റർ),
						'per' => q({0} / മീറ്റർ),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(മൈക്രോമീറ്റർ),
						'one' => q({0} മൈക്രോമീറ്റർ),
						'other' => q({0} മൈക്രോമീറ്റർ),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(മൈക്രോമീറ്റർ),
						'one' => q({0} മൈക്രോമീറ്റർ),
						'other' => q({0} മൈക്രോമീറ്റർ),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'1' => q(neuter),
						'name' => q(സ്കാൻഡിനേവിയൻ മൈൽ),
						'one' => q({0} സ്കാൻഡിനേവിയൻ മൈൽ),
						'other' => q({0} സ്കാൻഡിനേവിയൻ മൈൽ),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'1' => q(neuter),
						'name' => q(സ്കാൻഡിനേവിയൻ മൈൽ),
						'one' => q({0} സ്കാൻഡിനേവിയൻ മൈൽ),
						'other' => q({0} സ്കാൻഡിനേവിയൻ മൈൽ),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'one' => q({0} മില്ലീമീറ്റർ),
						'other' => q({0} മില്ലീമീറ്റർ),
					},
					# Core Unit Identifier
					'millimeter' => {
						'one' => q({0} മില്ലീമീറ്റർ),
						'other' => q({0} മില്ലീമീറ്റർ),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(നാനോമീറ്റർ),
						'one' => q({0} നാനോമീറ്റർ),
						'other' => q({0} നാനോമീറ്റർ),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(നാനോമീറ്റർ),
						'one' => q({0} നാനോമീറ്റർ),
						'other' => q({0} നാനോമീറ്റർ),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(നോട്ടിക്കൽ മൈൽ),
						'one' => q({0} നോട്ടിക്കൽ മൈൽ),
						'other' => q({0} നോട്ടിക്കൽ മൈൽ),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(നോട്ടിക്കൽ മൈൽ),
						'one' => q({0} നോട്ടിക്കൽ മൈൽ),
						'other' => q({0} നോട്ടിക്കൽ മൈൽ),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'one' => q({0} പാർസെക്),
						'other' => q({0} പാർസെക്),
					},
					# Core Unit Identifier
					'parsec' => {
						'one' => q({0} പാർസെക്),
						'other' => q({0} പാർസെക്),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(പൈക്കോമീറ്റർ),
						'one' => q({0} പൈക്കോമീറ്റർ),
						'other' => q({0} പൈക്കോമീറ്റർ),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(പൈക്കോമീറ്റർ),
						'one' => q({0} പൈക്കോമീറ്റർ),
						'other' => q({0} പൈക്കോമീറ്റർ),
					},
					# Long Unit Identifier
					'length-point' => {
						'one' => q({0} പോയിന്റ്),
						'other' => q({0} പോയിന്റ്),
					},
					# Core Unit Identifier
					'point' => {
						'one' => q({0} പോയിന്റ്),
						'other' => q({0} പോയിന്റ്),
					},
					# Long Unit Identifier
					'light-candela' => {
						'1' => q(neuter),
						'name' => q(കാൻഡെല),
					},
					# Core Unit Identifier
					'candela' => {
						'1' => q(neuter),
						'name' => q(കാൻഡെല),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'1' => q(neuter),
						'name' => q(ലൂമെൻ),
					},
					# Core Unit Identifier
					'lumen' => {
						'1' => q(neuter),
						'name' => q(ലൂമെൻ),
					},
					# Long Unit Identifier
					'light-lux' => {
						'1' => q(neuter),
					},
					# Core Unit Identifier
					'lux' => {
						'1' => q(neuter),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'one' => q({0} സോളാർ ലുമിനോസിറ്റി),
						'other' => q({0} സോളാർ ലുമിനോസിറ്റീസ്),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'one' => q({0} സോളാർ ലുമിനോസിറ്റി),
						'other' => q({0} സോളാർ ലുമിനോസിറ്റീസ്),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'1' => q(neuter),
						'one' => q({0} ക്യാരറ്റ്),
						'other' => q({0} ക്യാരറ്റ്),
					},
					# Core Unit Identifier
					'carat' => {
						'1' => q(neuter),
						'one' => q({0} ക്യാരറ്റ്),
						'other' => q({0} ക്യാരറ്റ്),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'one' => q(ഡാൽട്ടൻ),
						'other' => q({0} ഡാൽട്ടണുകൾ),
					},
					# Core Unit Identifier
					'dalton' => {
						'one' => q(ഡാൽട്ടൻ),
						'other' => q({0} ഡാൽട്ടണുകൾ),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'one' => q({0} ഭൂപിണ്ഡം),
						'other' => q({0} ഭൂപിണ്ഡം),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'one' => q({0} ഭൂപിണ്ഡം),
						'other' => q({0} ഭൂപിണ്ഡം),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'1' => q(neuter),
					},
					# Core Unit Identifier
					'gram' => {
						'1' => q(neuter),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'1' => q(neuter),
						'name' => q(കിലോഗ്രാം),
						'one' => q({0} കിലോഗ്രാം),
						'other' => q({0} കിലോഗ്രാം),
						'per' => q({0}/കിലോഗ്രാം),
					},
					# Core Unit Identifier
					'kilogram' => {
						'1' => q(neuter),
						'name' => q(കിലോഗ്രാം),
						'one' => q({0} കിലോഗ്രാം),
						'other' => q({0} കിലോഗ്രാം),
						'per' => q({0}/കിലോഗ്രാം),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(മൈക്രോഗ്രാം),
						'one' => q({0} മൈക്രോഗ്രാം),
						'other' => q({0} മൈക്രോഗ്രാം),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(മൈക്രോഗ്രാം),
						'one' => q({0} മൈക്രോഗ്രാം),
						'other' => q({0} മൈക്രോഗ്രാം),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(മില്ലിഗ്രാം),
						'one' => q({0} മില്ലിഗ്രാം),
						'other' => q({0} മില്ലിഗ്രാം),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(മില്ലിഗ്രാം),
						'one' => q({0} മില്ലിഗ്രാം),
						'other' => q({0} മില്ലിഗ്രാം),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(ഔൺസ്),
						'one' => q({0} ഔൺസ്),
						'other' => q({0} ഔൺസ്),
						'per' => q({0}/ഔൺസ്),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(ഔൺസ്),
						'one' => q({0} ഔൺസ്),
						'other' => q({0} ഔൺസ്),
						'per' => q({0}/ഔൺസ്),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ട്രോയ് ഔൺസ്),
						'one' => q({0} ട്രോയ് ഔൺസ്),
						'other' => q({0} ട്രോയ് ഔൺസ്),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ട്രോയ് ഔൺസ്),
						'one' => q({0} ട്രോയ് ഔൺസ്),
						'other' => q({0} ട്രോയ് ഔൺസ്),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'one' => q({0} പൗണ്ട്),
						'other' => q({0} പൗണ്ട്),
						'per' => q({0}/പൗണ്ട്),
					},
					# Core Unit Identifier
					'pound' => {
						'one' => q({0} പൗണ്ട്),
						'other' => q({0} പൗണ്ട്),
						'per' => q({0}/പൗണ്ട്),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'one' => q({0} സൂര്യപിണ്ഡം),
						'other' => q({0} സൂര്യപിണ്ഡം),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'one' => q({0} സൂര്യപിണ്ഡം),
						'other' => q({0} സൂര്യപിണ്ഡം),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'one' => q({0} സ്റ്റോൺ),
						'other' => q({0} സ്റ്റോൺ),
					},
					# Core Unit Identifier
					'stone' => {
						'one' => q({0} സ്റ്റോൺ),
						'other' => q({0} സ്റ്റോൺ),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'1' => q(neuter),
						'name' => q(മെട്രിക് ടൺ),
						'one' => q({0} മെട്രിക് ടൺ),
						'other' => q({0} മെട്രിക് ടൺ),
					},
					# Core Unit Identifier
					'tonne' => {
						'1' => q(neuter),
						'name' => q(മെട്രിക് ടൺ),
						'one' => q({0} മെട്രിക് ടൺ),
						'other' => q({0} മെട്രിക് ടൺ),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(ഗിഗാവാട്ട്),
						'one' => q({0} ഗിഗാവാട്ട്),
						'other' => q({0} ഗിഗാവാട്ട്),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(ഗിഗാവാട്ട്),
						'one' => q({0} ഗിഗാവാട്ട്),
						'other' => q({0} ഗിഗാവാട്ട്),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(കുതിരശക്തി),
						'one' => q({0} കുതിരശക്തി),
						'other' => q({0} കുതിരശക്തി),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(കുതിരശക്തി),
						'one' => q({0} കുതിരശക്തി),
						'other' => q({0} കുതിരശക്തി),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(കിലോവാട്ട്),
						'one' => q({0} കിലോവാട്ട്),
						'other' => q({0} കിലോവാട്ട്),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(കിലോവാട്ട്),
						'one' => q({0} കിലോവാട്ട്),
						'other' => q({0} കിലോവാട്ട്),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(മെഗാവാട്ട്),
						'one' => q({0} മെഗാവാട്ട്),
						'other' => q({0} മെഗാവാട്ട്),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(മെഗാവാട്ട്),
						'one' => q({0} മെഗാവാട്ട്),
						'other' => q({0} മെഗാവാട്ട്),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(മില്ലിവാട്ട്),
						'one' => q({0} മില്ലിവാട്ട്),
						'other' => q({0} മില്ലിവാട്ട്),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(മില്ലിവാട്ട്),
						'one' => q({0} മില്ലിവാട്ട്),
						'other' => q({0} മില്ലിവാട്ട്),
					},
					# Long Unit Identifier
					'power-watt' => {
						'1' => q(neuter),
						'one' => q({0} വാട്ട്),
						'other' => q({0} വാട്ട്),
					},
					# Core Unit Identifier
					'watt' => {
						'1' => q(neuter),
						'one' => q({0} വാട്ട്),
						'other' => q({0} വാട്ട്),
					},
					# Long Unit Identifier
					'power2' => {
						'one' => q(വർഗ്ഗം {0}),
						'other' => q(വർഗ്ഗം {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'one' => q(വർഗ്ഗം {0}),
						'other' => q(വർഗ്ഗം {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'one' => q(ക്യുബിക് {0}),
						'other' => q(ക്യുബിക് {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'one' => q(ക്യുബിക് {0}),
						'other' => q(ക്യുബിക് {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'1' => q(neuter),
						'name' => q(അറ്റ്‌മോസ്‌ഫിയർ),
						'one' => q({0} അറ്റ്‌മോസ്‌ഫിയർ),
						'other' => q({0} അറ്റ്‌മോസ്‌ഫിയർ),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'1' => q(neuter),
						'name' => q(അറ്റ്‌മോസ്‌ഫിയർ),
						'one' => q({0} അറ്റ്‌മോസ്‌ഫിയർ),
						'other' => q({0} അറ്റ്‌മോസ്‌ഫിയർ),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'1' => q(neuter),
						'name' => q(ബാറുകൾ),
						'one' => q({0} ബാർ),
						'other' => q({0} ബാറുകൾ),
					},
					# Core Unit Identifier
					'bar' => {
						'1' => q(neuter),
						'name' => q(ബാറുകൾ),
						'one' => q({0} ബാർ),
						'other' => q({0} ബാറുകൾ),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(ഹെക്‌ടോപാസ്‌ക്കൽ),
						'one' => q({0} ഹെക്‌ടോപാസ്‌ക്കൽ),
						'other' => q({0} ഹെക്‌ടോപാസ്‌ക്കൽ),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(ഹെക്‌ടോപാസ്‌ക്കൽ),
						'one' => q({0} ഹെക്‌ടോപാസ്‌ക്കൽ),
						'other' => q({0} ഹെക്‌ടോപാസ്‌ക്കൽ),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ഇഞ്ച് ഓഫ് മെർക്കുറി),
						'one' => q({0} ഇഞ്ച് ഓഫ് മെർക്കുറി),
						'other' => q({0} ഇഞ്ച് ഓഫ് മെർക്കുറി),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ഇഞ്ച് ഓഫ് മെർക്കുറി),
						'one' => q({0} ഇഞ്ച് ഓഫ് മെർക്കുറി),
						'other' => q({0} ഇഞ്ച് ഓഫ് മെർക്കുറി),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(കിലോപാസ്കൽ),
						'one' => q({0} കിലോപാസ്കൽ),
						'other' => q({0} കിലോപാസ്കൽ),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(കിലോപാസ്കൽ),
						'one' => q({0} കിലോപാസ്കൽ),
						'other' => q({0} കിലോപാസ്കൽ),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(മെഗാപാസ്കൽ),
						'one' => q({0} മെഗാപാസ്കൽ),
						'other' => q({0} മെഗാപാസ്കലുകൾ),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(മെഗാപാസ്കൽ),
						'one' => q({0} മെഗാപാസ്കൽ),
						'other' => q({0} മെഗാപാസ്കലുകൾ),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(മില്ലിബാർ),
						'one' => q({0} മില്ലിബാർ),
						'other' => q({0} മില്ലിബാർ),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(മില്ലിബാർ),
						'one' => q({0} മില്ലിബാർ),
						'other' => q({0} മില്ലിബാർ),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(മില്ലീമീറ്റർ മെർക്കുറി),
						'one' => q({0} മില്ലീമീറ്റർ മെർക്കുറി),
						'other' => q({0} മില്ലീമീറ്റർ മെർക്കുറി),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(മില്ലീമീറ്റർ മെർക്കുറി),
						'one' => q({0} മില്ലീമീറ്റർ മെർക്കുറി),
						'other' => q({0} മില്ലീമീറ്റർ മെർക്കുറി),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'1' => q(neuter),
						'name' => q(പാസ്കൽസ്),
						'one' => q({0} പാസ്കൽ),
						'other' => q({0} പാസ്കൽസ്),
					},
					# Core Unit Identifier
					'pascal' => {
						'1' => q(neuter),
						'name' => q(പാസ്കൽസ്),
						'one' => q({0} പാസ്കൽ),
						'other' => q({0} പാസ്കൽസ്),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(പൗണ്ട് / ചതുരശ്ര ഇഞ്ച്),
						'one' => q({0} പൗണ്ട് / ചതുരശ്ര ഇഞ്ച്),
						'other' => q({0} പൗണ്ട് / ചതുരശ്ര ഇഞ്ച്),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(പൗണ്ട് / ചതുരശ്ര ഇഞ്ച്),
						'one' => q({0} പൗണ്ട് / ചതുരശ്ര ഇഞ്ച്),
						'other' => q({0} പൗണ്ട് / ചതുരശ്ര ഇഞ്ച്),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(കിലോമീറ്റർ/മണിക്കൂർ),
						'one' => q({0} കിലോമീറ്റർ/മണിക്കൂർ),
						'other' => q({0} കിലോമീറ്റർ/മണിക്കൂർ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(കിലോമീറ്റർ/മണിക്കൂർ),
						'one' => q({0} കിലോമീറ്റർ/മണിക്കൂർ),
						'other' => q({0} കിലോമീറ്റർ/മണിക്കൂർ),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(മീറ്റർ/സെക്കൻഡ്),
						'one' => q({0} മീറ്റർ/സെക്കൻഡ്),
						'other' => q({0} മീറ്റർ/സെക്കൻഡ്),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(മീറ്റർ/സെക്കൻഡ്),
						'one' => q({0} മീറ്റർ/സെക്കൻഡ്),
						'other' => q({0} മീറ്റർ/സെക്കൻഡ്),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(മൈൽ/മണിക്കൂർ),
						'one' => q({0} മൈൽ/മണിക്കൂർ),
						'other' => q({0} മൈൽ/മണിക്കൂർ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(മൈൽ/മണിക്കൂർ),
						'one' => q({0} മൈൽ/മണിക്കൂർ),
						'other' => q({0} മൈൽ/മണിക്കൂർ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'1' => q(neuter),
						'name' => q(ഡിഗ്രി സെൽഷ്യസ്),
						'one' => q({0} ഡിഗ്രി സെൽഷ്യസ്),
						'other' => q({0} ഡിഗ്രി സെൽഷ്യസ്),
					},
					# Core Unit Identifier
					'celsius' => {
						'1' => q(neuter),
						'name' => q(ഡിഗ്രി സെൽഷ്യസ്),
						'one' => q({0} ഡിഗ്രി സെൽഷ്യസ്),
						'other' => q({0} ഡിഗ്രി സെൽഷ്യസ്),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(ഡിഗ്രി ഫാരൻഹീറ്റ്),
						'one' => q({0} ഡിഗ്രി ഫാരൻഹീറ്റ്),
						'other' => q({0} ഡിഗ്രി ഫാരൻഹീറ്റ്),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(ഡിഗ്രി ഫാരൻഹീറ്റ്),
						'one' => q({0} ഡിഗ്രി ഫാരൻഹീറ്റ്),
						'other' => q({0} ഡിഗ്രി ഫാരൻഹീറ്റ്),
					},
					# Long Unit Identifier
					'temperature-generic' => {
						'1' => q(neuter),
					},
					# Core Unit Identifier
					'generic' => {
						'1' => q(neuter),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'1' => q(neuter),
						'name' => q(കെൽവിൻ),
						'one' => q({0} കെൽവിൻ),
						'other' => q({0} കെൽവിൻ),
					},
					# Core Unit Identifier
					'kelvin' => {
						'1' => q(neuter),
						'name' => q(കെൽവിൻ),
						'one' => q({0} കെൽവിൻ),
						'other' => q({0} കെൽവിൻ),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(ന്യൂട്ടൺ മീറ്റർ),
						'one' => q({0} ന്യൂട്ടൺ മീറ്റർ),
						'other' => q({0} ന്യൂട്ടൺ മീറ്ററുകൾ),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(ന്യൂട്ടൺ മീറ്റർ),
						'one' => q({0} ന്യൂട്ടൺ മീറ്റർ),
						'other' => q({0} ന്യൂട്ടൺ മീറ്ററുകൾ),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(പൗണ്ട് ഫീറ്റ്),
						'one' => q({0} പൗണ്ട് ഫൂട്ട്),
						'other' => q({0} പൗണ്ട് ഫീറ്റ്),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(പൗണ്ട് ഫീറ്റ്),
						'one' => q({0} പൗണ്ട് ഫൂട്ട്),
						'other' => q({0} പൗണ്ട് ഫീറ്റ്),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(ഏക്കർ അടി),
						'one' => q({0} ഏക്കർ അടി),
						'other' => q({0} ഏക്കർ അടി),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(ഏക്കർ അടി),
						'one' => q({0} ഏക്കർ അടി),
						'other' => q({0} ഏക്കർ അടി),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'one' => q({0} ബാരൽ),
						'other' => q({0} ബാരൽ),
					},
					# Core Unit Identifier
					'barrel' => {
						'one' => q({0} ബാരൽ),
						'other' => q({0} ബാരൽ),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(സെന്റീലിറ്റർ),
						'one' => q({0} സെന്റീലിറ്റർ),
						'other' => q({0} സെന്റീലിറ്റർ),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(സെന്റീലിറ്റർ),
						'one' => q({0} സെന്റീലിറ്റർ),
						'other' => q({0} സെന്റീലിറ്റർ),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(ക്യൂബിക് സെന്റീമീറ്റർ),
						'one' => q({0} ക്യൂബിക് സെന്റീമീറ്റർ),
						'other' => q({0} ക്യൂബിക് സെന്റീമീറ്റർ),
						'per' => q({0} / ക്യൂബിക് സെന്റീമീറ്റർ),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(ക്യൂബിക് സെന്റീമീറ്റർ),
						'one' => q({0} ക്യൂബിക് സെന്റീമീറ്റർ),
						'other' => q({0} ക്യൂബിക് സെന്റീമീറ്റർ),
						'per' => q({0} / ക്യൂബിക് സെന്റീമീറ്റർ),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ക്യൂബിക് അടി),
						'one' => q({0} ക്യൂബിക് അടി),
						'other' => q({0} ക്യൂബിക് അടി),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ക്യൂബിക് അടി),
						'one' => q({0} ക്യൂബിക് അടി),
						'other' => q({0} ക്യൂബിക് അടി),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(ക്യൂബിക് ഇഞ്ച്),
						'one' => q({0} ക്യൂബിക് ഇഞ്ച്),
						'other' => q({0} ക്യൂബിക് ഇഞ്ച്),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(ക്യൂബിക് ഇഞ്ച്),
						'one' => q({0} ക്യൂബിക് ഇഞ്ച്),
						'other' => q({0} ക്യൂബിക് ഇഞ്ച്),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(ക്യൂബിക് കിലോമീറ്റർ),
						'one' => q({0} ക്യൂബിക് കിലോമീറ്റർ),
						'other' => q({0} ക്യൂബിക് കിലോമീറ്റർ),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(ക്യൂബിക് കിലോമീറ്റർ),
						'one' => q({0} ക്യൂബിക് കിലോമീറ്റർ),
						'other' => q({0} ക്യൂബിക് കിലോമീറ്റർ),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(ക്യൂബിക് മീറ്റർ),
						'one' => q({0} ക്യൂബിക് മീറ്റർ),
						'other' => q({0} ക്യൂബിക് മീറ്റർ),
						'per' => q({0} / ക്യൂബിക് മീറ്റർ),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(ക്യൂബിക് മീറ്റർ),
						'one' => q({0} ക്യൂബിക് മീറ്റർ),
						'other' => q({0} ക്യൂബിക് മീറ്റർ),
						'per' => q({0} / ക്യൂബിക് മീറ്റർ),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(ക്യൂബിക്ക് മൈൽ),
						'one' => q({0} ക്യൂബിക്ക് മൈൽ),
						'other' => q({0} ക്യൂബിക്ക് മൈൽ),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(ക്യൂബിക്ക് മൈൽ),
						'one' => q({0} ക്യൂബിക്ക് മൈൽ),
						'other' => q({0} ക്യൂബിക്ക് മൈൽ),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(ക്യൂബിക് യാർഡ്),
						'one' => q({0} ക്യൂബിക് യാർഡ്),
						'other' => q({0} ക്യൂബിക് യാർഡ്),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(ക്യൂബിക് യാർഡ്),
						'one' => q({0} ക്യൂബിക് യാർഡ്),
						'other' => q({0} ക്യൂബിക് യാർഡ്),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'1' => q(neuter),
						'name' => q(മെട്രിക് കപ്പ്),
						'one' => q({0} മെട്രിക് കപ്പ്),
						'other' => q({0} മെട്രിക് കപ്പ്),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'1' => q(neuter),
						'name' => q(മെട്രിക് കപ്പ്),
						'one' => q({0} മെട്രിക് കപ്പ്),
						'other' => q({0} മെട്രിക് കപ്പ്),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ഡെസിലിറ്റർ),
						'one' => q({0} ഡെസിലിറ്റർ),
						'other' => q({0} ഡെസിലിറ്റർ),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ഡെസിലിറ്റർ),
						'one' => q({0} ഡെസിലിറ്റർ),
						'other' => q({0} ഡെസിലിറ്റർ),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(dram),
						'one' => q({0} dram),
						'other' => q({0} dram),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(dram),
						'one' => q({0} dram),
						'other' => q({0} dram),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(തുള്ളികൾ),
						'one' => q({0} തുള്ളി),
						'other' => q({0} തുള്ളികൾ),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(തുള്ളികൾ),
						'one' => q({0} തുള്ളി),
						'other' => q({0} തുള്ളികൾ),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(ഫ്ലൂയിഡ് ഔൺസ്),
						'one' => q({0} ഫ്ലൂയിഡ് ഔൺസ്),
						'other' => q({0} ഫ്ലൂയിഡ് ഔൺസ്),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(ഫ്ലൂയിഡ് ഔൺസ്),
						'one' => q({0} ഫ്ലൂയിഡ് ഔൺസ്),
						'other' => q({0} ഫ്ലൂയിഡ് ഔൺസ്),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(ഗാലൺ),
						'one' => q({0} ഗാലൺ),
						'other' => q({0} ഗാലൺ),
						'per' => q({0} / ഗാലൺ),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(ഗാലൺ),
						'one' => q({0} ഗാലൺ),
						'other' => q({0} ഗാലൺ),
						'per' => q({0} / ഗാലൺ),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'one' => q({0} ഇംപീ. ഗാലൺ),
						'other' => q({0} ഇംപീ. ഗാലൺ),
						'per' => q({0} / ഇംപീ. ഗാലൺ),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'one' => q({0} ഇംപീ. ഗാലൺ),
						'other' => q({0} ഇംപീ. ഗാലൺ),
						'per' => q({0} / ഇംപീ. ഗാലൺ),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(ഹെക്ടോലിറ്റർ),
						'one' => q({0} ഹെക്ടോലിറ്റർ),
						'other' => q({0} ഹെക്ടോലിറ്റർ),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(ഹെക്ടോലിറ്റർ),
						'one' => q({0} ഹെക്ടോലിറ്റർ),
						'other' => q({0} ഹെക്ടോലിറ്റർ),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'1' => q(neuter),
						'one' => q({0} ലിറ്റർ),
						'other' => q({0} ലിറ്റർ),
						'per' => q({0} / ലിറ്റർ),
					},
					# Core Unit Identifier
					'liter' => {
						'1' => q(neuter),
						'one' => q({0} ലിറ്റർ),
						'other' => q({0} ലിറ്റർ),
						'per' => q({0} / ലിറ്റർ),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(മെഗാലിറ്റർ),
						'one' => q({0} മെഗാലിറ്റർ),
						'other' => q({0} മെഗാലിറ്റർ),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(മെഗാലിറ്റർ),
						'one' => q({0} മെഗാലിറ്റർ),
						'other' => q({0} മെഗാലിറ്റർ),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(മില്ലിലിറ്റർ),
						'one' => q({0} മില്ലിലിറ്റർ),
						'other' => q({0} മില്ലിലിറ്റർ),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(മില്ലിലിറ്റർ),
						'one' => q({0} മില്ലിലിറ്റർ),
						'other' => q({0} മില്ലിലിറ്റർ),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(പൈന്റ്),
						'one' => q({0} പൈന്റ്),
						'other' => q({0} പൈന്റ്),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(പൈന്റ്),
						'one' => q({0} പൈന്റ്),
						'other' => q({0} പൈന്റ്),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'1' => q(neuter),
						'name' => q(മെട്രിക് പൈന്റ്),
						'one' => q({0} മെട്രിക് പൈന്റ്),
						'other' => q({0} മെട്രിക് പൈന്റ്),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'1' => q(neuter),
						'name' => q(മെട്രിക് പൈന്റ്),
						'one' => q({0} മെട്രിക് പൈന്റ്),
						'other' => q({0} മെട്രിക് പൈന്റ്),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(ക്വാർട്ട്),
						'one' => q({0} ക്വാർട്ട്),
						'other' => q({0} ക്വാർട്ട്),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(ക്വാർട്ട്),
						'one' => q({0} ക്വാർട്ട്),
						'other' => q({0} ക്വാർട്ട്),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(ടേബിൾസ്‌പൂൺ),
						'one' => q({0} ടേബിൾസ്‌പൂൺ),
						'other' => q({0} ടേബിൾസ്‌പൂൺ),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(ടേബിൾസ്‌പൂൺ),
						'one' => q({0} ടേബിൾസ്‌പൂൺ),
						'other' => q({0} ടേബിൾസ്‌പൂൺ),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(ടീസ്‌പൂൺ),
						'one' => q({0} ടീസ്‌പൂൺ),
						'other' => q({0} ടീസ്‌പൂൺ),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(ടീസ്‌പൂൺ),
						'one' => q({0} ടീസ്‌പൂൺ),
						'other' => q({0} ടീസ്‌പൂൺ),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'10p3' => {
						'1' => q(കി.{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(കി.{0}),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(മീ/സെ²),
						'one' => q({0}മീ/സെ²),
						'other' => q({0}മീ/സെ²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(മീ/സെ²),
						'one' => q({0}മീ/സെ²),
						'other' => q({0}മീ/സെ²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'area-acre' => {
						'one' => q({0} ഏ),
						'other' => q({0} ഏക്ക),
					},
					# Core Unit Identifier
					'acre' => {
						'one' => q({0} ഏ),
						'other' => q({0} ഏക്ക),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(ദുനം),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(ദുനം),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0} ഹെ),
						'other' => q({0} ഹെ),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0} ഹെ),
						'other' => q({0} ഹെ),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'one' => q({0} ച. അടി),
						'other' => q({0} ച.അടി),
					},
					# Core Unit Identifier
					'square-foot' => {
						'one' => q({0} ച. അടി),
						'other' => q({0} ച.അടി),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'one' => q({0} ച.കിമീ),
						'other' => q({0} ച.കിമീ),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'one' => q({0} ച.കിമീ),
						'other' => q({0} ച.കിമീ),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'one' => q({0} ച.മീ),
						'other' => q({0} ച.മീ),
					},
					# Core Unit Identifier
					'square-meter' => {
						'one' => q({0} ച.മീ),
						'other' => q({0} ച.മീ),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'one' => q({0} ച.മൈ),
						'other' => q({0} ച.മൈ),
					},
					# Core Unit Identifier
					'square-mile' => {
						'one' => q({0} ച.മൈ),
						'other' => q({0} ച.മൈ),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(‱),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(‱),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'one' => q({0}ലി/100കി.മീ.),
						'other' => q({0}ലി/100കി.മീ),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'one' => q({0}ലി/100കി.മീ.),
						'other' => q({0}ലി/100കി.മീ),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}കി.),
						'north' => q({0}വ.),
						'south' => q({0}തെ.),
						'west' => q({0}പ.),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}കി.),
						'north' => q({0}വ.),
						'south' => q({0}തെ.),
						'west' => q({0}പ.),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(ജിബി),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(ജിബി),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(കെബി),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(കെബി),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(എംബി),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(എംബി),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ടിബി),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ടിബി),
					},
					# Long Unit Identifier
					'duration-day' => {
						'one' => q({0} ദി),
						'other' => q({0} ദി),
					},
					# Core Unit Identifier
					'day' => {
						'one' => q({0} ദി),
						'other' => q({0} ദി),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ദശാബ്‌ദം),
						'one' => q({0}ദശാ.),
						'other' => q({0}ദശാ.),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ദശാബ്‌ദം),
						'one' => q({0}ദശാ.),
						'other' => q({0}ദശാ.),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(മി.സെ.),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(മി.സെ.),
					},
					# Long Unit Identifier
					'duration-month' => {
						'one' => q({0} മാ),
						'other' => q({0} മാ),
					},
					# Core Unit Identifier
					'month' => {
						'one' => q({0} മാ),
						'other' => q({0} മാ),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(നാ.സെ.),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(നാ.സെ.),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(സെ.),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(സെ.),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ആ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ആ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(വ),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(വ),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(ഡോട്ട്),
						'one' => q({0} ഡോട്ട്),
						'other' => q({0} ഡോട്ട്),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(ഡോട്ട്),
						'one' => q({0} ഡോട്ട്),
						'other' => q({0} ഡോട്ട്),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'one' => q({0}ജ്യോ.യൂ),
						'other' => q({0}ജ്യോ.യൂ),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'one' => q({0}ജ്യോ.യൂ),
						'other' => q({0}ജ്യോ.യൂ),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'one' => q({0}ഫാ.),
						'other' => q({0}ഫാ.),
					},
					# Core Unit Identifier
					'fathom' => {
						'one' => q({0}ഫാ.),
						'other' => q({0}ഫാ.),
					},
					# Long Unit Identifier
					'length-foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'one' => q({0}ഫർ.),
						'other' => q({0}ഫർ.),
					},
					# Core Unit Identifier
					'furlong' => {
						'one' => q({0}ഫർ.),
						'other' => q({0}ഫർ.),
					},
					# Long Unit Identifier
					'length-inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(പ്ര.വ.),
						'one' => q({0} പ്ര.വ),
						'other' => q({0} പ്ര.വ),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(പ്ര.വ.),
						'one' => q({0} പ്ര.വ),
						'other' => q({0} പ്ര.വ),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(μമീ.),
						'one' => q({0}μമീ.),
						'other' => q({0}μമീ.),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(μമീ.),
						'one' => q({0}μമീ.),
						'other' => q({0}μമീ.),
					},
					# Long Unit Identifier
					'length-mile' => {
						'one' => q({0} മൈ),
						'other' => q({0} മൈ),
					},
					# Core Unit Identifier
					'mile' => {
						'one' => q({0} മൈ),
						'other' => q({0} മൈ),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'one' => q({0}സ്.മൈ.),
						'other' => q({0}സ്.മൈ.),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'one' => q({0}സ്.മൈ.),
						'other' => q({0}സ്.മൈ.),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(മി.മീ.),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(മി.മീ.),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'one' => q({0}ന.മൈ.),
						'other' => q({0}ന.മൈ.),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'one' => q({0}ന.മൈ.),
						'other' => q({0}ന.മൈ.),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'one' => q({0} പൈ.മീ),
						'other' => q({0} പൈ.മീ),
					},
					# Core Unit Identifier
					'picometer' => {
						'one' => q({0} പൈ.മീ),
						'other' => q({0} പൈ.മീ),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(പോ.),
						'one' => q({0}പോ.),
						'other' => q({0}പോ.),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(പോ.),
						'one' => q({0}പോ.),
						'other' => q({0}പോ.),
					},
					# Long Unit Identifier
					'length-yard' => {
						'one' => q({0} യാ),
						'other' => q({0} യാ),
					},
					# Core Unit Identifier
					'yard' => {
						'one' => q({0} യാ),
						'other' => q({0} യാ),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(സോളാർ ലുമിനോസൈട്സ്),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(സോളാർ ലുമിനോസൈട്സ്),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'one' => q({0}CD),
						'other' => q({0}CD),
					},
					# Core Unit Identifier
					'carat' => {
						'one' => q({0}CD),
						'other' => q({0}CD),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ഡാ.),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ഡാ.),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(M⊕),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(M⊕),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(grain),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(grain),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'one' => q({0}കി.ഗ്രാം),
						'other' => q({0}കി.ഗ്രാം),
					},
					# Core Unit Identifier
					'kilogram' => {
						'one' => q({0}കി.ഗ്രാം),
						'other' => q({0}കി.ഗ്രാം),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'one' => q({0}μ.ഗ്രാം.),
						'other' => q({0}μ.ഗ്രാം.),
					},
					# Core Unit Identifier
					'microgram' => {
						'one' => q({0}μ.ഗ്രാം.),
						'other' => q({0}μ.ഗ്രാം.),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'one' => q({0}മി.ഗ്രാം.),
						'other' => q({0}മി.ഗ്രാം.),
					},
					# Core Unit Identifier
					'milligram' => {
						'one' => q({0}മി.ഗ്രാം.),
						'other' => q({0}മി.ഗ്രാം.),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'one' => q({0} ഔ),
						'other' => q({0} ഔ),
					},
					# Core Unit Identifier
					'ounce' => {
						'one' => q({0} ഔ),
						'other' => q({0} ഔ),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(പൗ),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(പൗ),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(M☉),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(M☉),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'one' => q({0}സ്റ്റോ.),
						'other' => q({0}സ്റ്റോ.),
					},
					# Core Unit Identifier
					'stone' => {
						'one' => q({0}സ്റ്റോ.),
						'other' => q({0}സ്റ്റോ.),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'one' => q({0}ടൺ),
						'other' => q({0}ടൺ),
					},
					# Core Unit Identifier
					'ton' => {
						'one' => q({0}ടൺ),
						'other' => q({0}ടൺ),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'one' => q({0}ട.),
						'other' => q({0}ട.),
					},
					# Core Unit Identifier
					'tonne' => {
						'one' => q({0}ട.),
						'other' => q({0}ട.),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0} വാ),
						'other' => q({0} വാ),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0} വാ),
						'other' => q({0} വാ),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'one' => q({0} ബാർ),
						'other' => q({0}ബാർ),
					},
					# Core Unit Identifier
					'bar' => {
						'one' => q({0} ബാർ),
						'other' => q({0}ബാർ),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'one' => q({0}" Hg),
						'other' => q({0}" Hg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'one' => q({0}" Hg),
						'other' => q({0}" Hg),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'one' => q({0} മിബാ),
						'other' => q({0} മിബാ),
					},
					# Core Unit Identifier
					'millibar' => {
						'one' => q({0} മിബാ),
						'other' => q({0} മിബാ),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'one' => q({0}മിമീ.മെ.),
						'other' => q({0}മിമീ.മെ.),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'one' => q({0}മിമീ.മെ.),
						'other' => q({0}മിമീ.മെ.),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'one' => q({0}കി.മീ/മ.),
						'other' => q({0}കി.മീ/മ.),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'one' => q({0}കി.മീ/മ.),
						'other' => q({0}കി.മീ/മ.),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'one' => q({0}നോട്ട്),
						'other' => q({0}നോട്ട്),
					},
					# Core Unit Identifier
					'knot' => {
						'one' => q({0}നോട്ട്),
						'other' => q({0}നോട്ട്),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(മീ/സെ.),
						'one' => q({0} മീ/സെ),
						'other' => q({0} മീ/സെ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(മീ/സെ.),
						'one' => q({0} മീ/സെ),
						'other' => q({0} മീ/സെ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(മൈ/മ.),
						'one' => q({0} മൈ/മ),
						'other' => q({0} മൈ/മ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(മൈ/മ.),
						'one' => q({0} മൈ/മ),
						'other' => q({0} മൈ/മ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°സെ),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°സെ),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(°ഫാ),
						'one' => q({0}°ഫാ),
						'other' => q({0}°ഫാ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(°ഫാ),
						'one' => q({0}°ഫാ),
						'other' => q({0}°ഫാ),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'one' => q({0}K),
						'other' => q({0}K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'one' => q({0}K),
						'other' => q({0}K),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'one' => q({0} പറ),
						'other' => q({0} bu),
					},
					# Core Unit Identifier
					'bushel' => {
						'one' => q({0} പറ),
						'other' => q({0} bu),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0} കിമീ³),
						'other' => q({0} കിമീ³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0} കിമീ³),
						'other' => q({0} കിമീ³),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(dsp),
						'one' => q({0}dsp),
						'other' => q({0}dsp),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(dsp),
						'one' => q({0}dsp),
						'other' => q({0}dsp),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(dsp Imp),
						'one' => q({0}dsp-Imp),
						'other' => q({0}dsp-Imp),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(dsp Imp),
						'one' => q({0}dsp-Imp),
						'other' => q({0}dsp-Imp),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(fl.dr.),
						'one' => q({0}fl.dr.),
						'other' => q({0}fl.dr.),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(fl.dr.),
						'one' => q({0}fl.dr.),
						'other' => q({0}fl.dr.),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(തു),
						'one' => q({0}തു),
						'other' => q({0}തു),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(തു),
						'one' => q({0}തു),
						'other' => q({0}തു),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'one' => q({0}fl oz Im),
						'other' => q({0}fl oz Im),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'one' => q({0}fl oz Im),
						'other' => q({0}fl oz Im),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ദിശ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ദിശ),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(പി{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(പി{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(യോ{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(യോ{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(ജി-ഫോഴ്‌സ്),
						'one' => q({0} ജി),
						'other' => q({0} ജി),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(ജി-ഫോഴ്‌സ്),
						'one' => q({0} ജി),
						'other' => q({0} ജി),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(മീറ്റർ/സെക്കൻഡ്²),
						'one' => q({0} മീ/സെ²),
						'other' => q({0} മീ/സെ²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(മീറ്റർ/സെക്കൻഡ്²),
						'one' => q({0} മീ/സെ²),
						'other' => q({0} മീ/സെ²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(ആർക്ക്.മി.),
						'one' => q({0} ആർക്ക്.മി.),
						'other' => q({0} ആർക്ക്.മി.),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(ആർക്ക്.മി.),
						'one' => q({0} ആർക്ക്.മി.),
						'other' => q({0} ആർക്ക്.മി.),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(ആർക്ക്.സെ.),
						'one' => q({0} ആർക്ക്.സെ.),
						'other' => q({0} ആർക്ക്.സെ.),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(ആർക്ക്.സെ.),
						'one' => q({0} ആർക്ക്.സെ.),
						'other' => q({0} ആർക്ക്.സെ.),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(ഡിഗ്രി),
						'one' => q({0} ഡിഗ്രി),
						'other' => q({0} ഡിഗ്രി),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(ഡിഗ്രി),
						'one' => q({0} ഡിഗ്രി),
						'other' => q({0} ഡിഗ്രി),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(റേഡിയൻ),
						'one' => q({0} റേഡി.),
						'other' => q({0} റേഡി.),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(റേഡിയൻ),
						'one' => q({0} റേഡി.),
						'other' => q({0} റേഡി.),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(റെവ.),
						'one' => q({0} റെവ.),
						'other' => q({0} റെവ.),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(റെവ.),
						'one' => q({0} റെവ.),
						'other' => q({0} റെവ.),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ഏക്കർ),
						'one' => q({0} ഏക്ക.),
						'other' => q({0} ഏക്ക.),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ഏക്കർ),
						'one' => q({0} ഏക്ക.),
						'other' => q({0} ഏക്ക.),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(ദുനങ്ങൾ),
						'one' => q({0} ദുനം),
						'other' => q({0} ദുനം),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(ദുനങ്ങൾ),
						'one' => q({0} ദുനം),
						'other' => q({0} ദുനം),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ഹെക്‌ടർ),
						'one' => q({0} ഹെക്.),
						'other' => q({0} ഹെക്.),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ഹെക്‌ടർ),
						'one' => q({0} ഹെക്.),
						'other' => q({0} ഹെക്.),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(സെ.മീ²),
						'one' => q({0} സെ.മീ²),
						'other' => q({0} സെ.മീ²),
						'per' => q({0}/സെ.മീ²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(സെ.മീ²),
						'one' => q({0} സെ.മീ²),
						'other' => q({0} സെ.മീ²),
						'per' => q({0}/സെ.മീ²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ചതു.അടി),
						'one' => q({0} ചതു.അടി),
						'other' => q({0} ചതു.അടി),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ചതു.അടി),
						'one' => q({0} ചതു.അടി),
						'other' => q({0} ചതു.അടി),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(ഇഞ്ച്²),
						'one' => q({0} ഇഞ്ച്²),
						'other' => q({0} ഇഞ്ച്²),
						'per' => q({0}/ഇഞ്ച്²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(ഇഞ്ച്²),
						'one' => q({0} ഇഞ്ച്²),
						'other' => q({0} ഇഞ്ച്²),
						'per' => q({0}/ഇഞ്ച്²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(കി.മീ²),
						'one' => q({0} കി.മീ²),
						'other' => q({0} കി.മീ²),
						'per' => q({0}/കി.മീ²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(കി.മീ²),
						'one' => q({0} കി.മീ²),
						'other' => q({0} കി.മീ²),
						'per' => q({0}/കി.മീ²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(മീറ്റർ²),
						'one' => q({0} മീ²),
						'other' => q({0} മീ²),
						'per' => q({0}/മീ²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(മീറ്റർ²),
						'one' => q({0} മീ²),
						'other' => q({0} മീ²),
						'per' => q({0}/മീ²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(ചതു.മൈൽ),
						'one' => q({0} ചതു.മൈ),
						'other' => q({0} ചതു.മൈ),
						'per' => q({0}/മൈ²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(ചതു.മൈൽ),
						'one' => q({0} ചതു.മൈ),
						'other' => q({0} ചതു.മൈ),
						'per' => q({0}/മൈ²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(വാര²),
						'one' => q({0} വാ²),
						'other' => q({0} വാ²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(വാര²),
						'one' => q({0} വാ²),
						'other' => q({0} വാ²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ഇനം),
						'one' => q({0} ഇനം),
						'other' => q({0} ഇനം),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ഇനം),
						'one' => q({0} ഇനം),
						'other' => q({0} ഇനം),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(ക്യാരറ്റ്),
						'one' => q({0} ക്യാ.),
						'other' => q({0} ക്യാ.),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(ക്യാരറ്റ്),
						'one' => q({0} ക്യാ.),
						'other' => q({0} ക്യാ.),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(മി.ഗ്രാം/ഡെ.ലി.),
						'one' => q({0} മി.ഗ്രാം/ഡെ.ലി.),
						'other' => q({0} മി.ഗ്രാം/ഡെ.ലി.),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(മി.ഗ്രാം/ഡെ.ലി.),
						'one' => q({0} മി.ഗ്രാം/ഡെ.ലി.),
						'other' => q({0} മി.ഗ്രാം/ഡെ.ലി.),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(മില്ലിമോൾ/ലിറ്റർ),
						'one' => q({0} മി.മോ/ലി.),
						'other' => q({0} മി.മോ/ലി.),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(മില്ലിമോൾ/ലിറ്റർ),
						'one' => q({0} മി.മോ/ലി.),
						'other' => q({0} മി.മോ/ലി.),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(മോൾ),
						'one' => q({0} മോൾ),
						'other' => q({0} മോൾ),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(മോൾ),
						'one' => q({0} മോൾ),
						'other' => q({0} മോൾ),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(പാർട്‌സ്/മില്ല്യൺ),
						'one' => q({0} പാ.പെ.മി.),
						'other' => q({0} പാ.പെ.മി.),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(പാർട്‌സ്/മില്ല്യൺ),
						'one' => q({0} പാ.പെ.മി.),
						'other' => q({0} പാ.പെ.മി.),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(പെ൪മിറിയാഡ്),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(പെ൪മിറിയാഡ്),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ലി./100 കി.മീ.),
						'one' => q({0} ലി./100 കി.മീ.),
						'other' => q({0} ലി./100 കി.മീ.),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ലി./100 കി.മീ.),
						'one' => q({0} ലി./100 കി.മീ.),
						'other' => q({0} ലി./100 കി.മീ.),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ലിറ്റർ/കി.മീ.),
						'one' => q({0} ലി/കി.മീ.),
						'other' => q({0} ലി/കി.മീ.),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ലിറ്റർ/കി.മീ.),
						'one' => q({0} ലി/കി.മീ.),
						'other' => q({0} ലി/കി.മീ.),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(മൈൽ/ഗാ.),
						'one' => q({0} മൈ/ഗാ.),
						'other' => q({0} മൈ/ഗാ.),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(മൈൽ/ഗാ.),
						'one' => q({0} മൈ/ഗാ.),
						'other' => q({0} മൈ/ഗാ.),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(മൈൽ/ഗാ. ഇംപീ.),
						'one' => q({0} മൈ.പെ.ഗാ./ഇം‌പീ.),
						'other' => q({0} മൈ.പെ.ഗാ./ഇം‌പീ.),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(മൈൽ/ഗാ. ഇംപീ.),
						'one' => q({0} മൈ.പെ.ഗാ./ഇം‌പീ.),
						'other' => q({0} മൈ.പെ.ഗാ./ഇം‌പീ.),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} കി.),
						'north' => q({0} വ.),
						'south' => q({0} തെ.),
						'west' => q({0} പ.),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} കി.),
						'north' => q({0} വ.),
						'south' => q({0} തെ.),
						'west' => q({0} പ.),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(ബിറ്റ്),
						'one' => q({0} ബിറ്റ്),
						'other' => q({0} ബിറ്റ്),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(ബിറ്റ്),
						'one' => q({0} ബിറ്റ്),
						'other' => q({0} ബിറ്റ്),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(ബൈറ്റ്),
						'one' => q({0} ബൈറ്റ്),
						'other' => q({0} ബൈറ്റ്),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(ബൈറ്റ്),
						'one' => q({0} ബൈറ്റ്),
						'other' => q({0} ബൈറ്റ്),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(ജി.ബിറ്റ്),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(ജി.ബിറ്റ്),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(ജി.ബൈറ്റ്),
						'one' => q({0} ജിബി),
						'other' => q({0} ജിബി),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(ജി.ബൈറ്റ്),
						'one' => q({0} ജിബി),
						'other' => q({0} ജിബി),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(കി.ബിറ്റ്),
						'one' => q({0} കി.ബിറ്റ്),
						'other' => q({0} കി.ബിറ്റ്),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(കി.ബിറ്റ്),
						'one' => q({0} കി.ബിറ്റ്),
						'other' => q({0} കി.ബിറ്റ്),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(കി.ബൈറ്റ്),
						'one' => q({0} കെബി),
						'other' => q({0} കെബി),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(കി.ബൈറ്റ്),
						'one' => q({0} കെബി),
						'other' => q({0} കെബി),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(മെ.ബിറ്റ്),
						'one' => q({0} മെ.ബി.),
						'other' => q({0} മെ.ബി.),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(മെ.ബിറ്റ്),
						'one' => q({0} മെ.ബി.),
						'other' => q({0} മെ.ബി.),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(മെ.ബൈറ്റ്),
						'one' => q({0} എംബി),
						'other' => q({0} എംബി),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(മെ.ബൈറ്റ്),
						'one' => q({0} എംബി),
						'other' => q({0} എംബി),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(പെ.ബൈ.),
						'one' => q({0} പിബി),
						'other' => q({0} പിബി),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(പെ.ബൈ.),
						'one' => q({0} പിബി),
						'other' => q({0} പിബി),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(ടെ.ബിറ്റ്),
						'one' => q({0} ടെ.ബി.),
						'other' => q({0} ടെ.ബി.),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(ടെ.ബിറ്റ്),
						'one' => q({0} ടെ.ബി.),
						'other' => q({0} ടെ.ബി.),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ടെ.ബൈറ്റ്),
						'one' => q({0} ടിബി),
						'other' => q({0} ടിബി),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ടെ.ബൈറ്റ്),
						'one' => q({0} ടിബി),
						'other' => q({0} ടിബി),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(നൂ.),
						'one' => q({0} നൂ.),
						'other' => q({0} നൂ.),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(നൂ.),
						'one' => q({0} നൂ.),
						'other' => q({0} നൂ.),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ദിവസം),
						'one' => q({0} ദിവസം‌),
						'other' => q({0} ദിവസം‌),
						'per' => q({0}/ദി.),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ദിവസം),
						'one' => q({0} ദിവസം‌),
						'other' => q({0} ദിവസം‌),
						'per' => q({0}/ദി.),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ദശാ.),
						'one' => q({0} ദശാബ്‌ദം),
						'other' => q({0} ദശാബ്‌ദം),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ദശാ.),
						'one' => q({0} ദശാബ്‌ദം),
						'other' => q({0} ദശാബ്‌ദം),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(മണിക്കൂർ),
						'one' => q({0} മ),
						'other' => q({0} മ),
						'per' => q({0}/മ.),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(മണിക്കൂർ),
						'one' => q({0} മ),
						'other' => q({0} മ),
						'per' => q({0}/മ.),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(μ.സെ.),
						'one' => q({0} μ.സെ.),
						'other' => q({0} μ.സെ.),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(μ.സെ.),
						'one' => q({0} μ.സെ.),
						'other' => q({0} μ.സെ.),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(മില്ലിസെക്കൻഡ്),
						'one' => q({0} മി.സെ.),
						'other' => q({0} മി.സെ.),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(മില്ലിസെക്കൻഡ്),
						'one' => q({0} മി.സെ.),
						'other' => q({0} മി.സെ.),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(മി.),
						'one' => q({0} മി.),
						'other' => q({0} മി.),
						'per' => q({0}/മി.),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(മി.),
						'one' => q({0} മി.),
						'other' => q({0} മി.),
						'per' => q({0}/മി.),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(മാസം),
						'one' => q({0} മാസം),
						'other' => q({0} മാസം),
						'per' => q({0}/മാ.),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(മാസം),
						'one' => q({0} മാസം),
						'other' => q({0} മാസം),
						'per' => q({0}/മാ.),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(നാനോസെക്കൻഡ്),
						'one' => q({0} നാ.സെ.),
						'other' => q({0} നാ.സെ.),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(നാനോസെക്കൻഡ്),
						'one' => q({0} നാ.സെ.),
						'other' => q({0} നാ.സെ.),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(പാദം),
						'one' => q({0} പാദം),
						'other' => q({0} പാദങ്ങൾ),
						'per' => q({0}/പാദം),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(പാദം),
						'one' => q({0} പാദം),
						'other' => q({0} പാദങ്ങൾ),
						'per' => q({0}/പാദം),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(സെക്കൻഡ്),
						'one' => q({0} സെ.),
						'other' => q({0} സെ.),
						'per' => q({0}/സെ.),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(സെക്കൻഡ്),
						'one' => q({0} സെ.),
						'other' => q({0} സെ.),
						'per' => q({0}/സെ.),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ആഴ്ച),
						'one' => q({0} ആ),
						'other' => q({0} ആ),
						'per' => q({0}/ആ.),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ആഴ്ച),
						'one' => q({0} ആ),
						'other' => q({0} ആ),
						'per' => q({0}/ആ.),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(വർഷം),
						'one' => q({0} വ),
						'other' => q({0} വ),
						'per' => q({0}/വ.),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(വർഷം),
						'one' => q({0} വ),
						'other' => q({0} വ),
						'per' => q({0}/വ.),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(ആമ്പിയർ),
						'one' => q({0} ആ.),
						'other' => q({0} ആ.),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(ആമ്പിയർ),
						'one' => q({0} ആ.),
						'other' => q({0} ആ.),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(മില്ലിആമ്പിയർ),
						'one' => q({0} മി.ആ.),
						'other' => q({0} മി.ആ.),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(മില്ലിആമ്പിയർ),
						'one' => q({0} മി.ആ.),
						'other' => q({0} മി.ആ.),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(ഓം),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(ഓം),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(വോൾട്ട്),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(വോൾട്ട്),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(കലോ.),
						'one' => q({0} കലോ.),
						'other' => q({0} കലോ.),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(കലോ.),
						'one' => q({0} കലോ.),
						'other' => q({0} കലോ.),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(ഇലക്ട്രോൺവോൾട്ട്),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(ഇലക്ട്രോൺവോൾട്ട്),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(കലോ.),
						'one' => q({0} കലോ.),
						'other' => q({0} കലോ.),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(കലോ.),
						'one' => q({0} കലോ.),
						'other' => q({0} കലോ.),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(ജൂൾ),
						'one' => q({0} ജൂ.),
						'other' => q({0} ജൂ.),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(ജൂൾ),
						'one' => q({0} ജൂ.),
						'other' => q({0} ജൂ.),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(കി.കലോ.),
						'one' => q({0} കി.കലോ.),
						'other' => q({0} കി.കലോ.),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(കി.കലോ.),
						'one' => q({0} കി.കലോ.),
						'other' => q({0} കി.കലോ.),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(കി.ജൂ.),
						'one' => q({0} കി.ജൂ.),
						'other' => q({0} കി.ജൂ.),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(കി.ജൂ.),
						'one' => q({0} കി.ജൂ.),
						'other' => q({0} കി.ജൂ.),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(കി.വാ/മ.),
						'one' => q({0} കി.വാ/മ.),
						'other' => q({0} കി.വാ/മ.),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(കി.വാ/മ.),
						'one' => q({0} കി.വാ/മ.),
						'other' => q({0} കി.വാ/മ.),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(US തേം),
						'one' => q({0} US തേം),
						'other' => q({0} US തേം),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(US തേം),
						'one' => q({0} US തേം),
						'other' => q({0} US തേം),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(ന്യൂട്ടൻ),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(ന്യൂട്ടൻ),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(പൗണ്ട് ഫോഴ്സ്),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(പൗണ്ട് ഫോഴ്സ്),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(ഗി.ഹെ.),
						'one' => q({0} ഗി.ഹെ.),
						'other' => q({0} ഗി.ഹെ.),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(ഗി.ഹെ.),
						'one' => q({0} ഗി.ഹെ.),
						'other' => q({0} ഗി.ഹെ.),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(ഹെ.),
						'one' => q({0} ഹെ.),
						'other' => q({0} ഹെ.),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(ഹെ.),
						'one' => q({0} ഹെ.),
						'other' => q({0} ഹെ.),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(കി.ഹെ.),
						'one' => q({0} കി.ഹെ.),
						'other' => q({0} കി.ഹെ.),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(കി.ഹെ.),
						'one' => q({0} കി.ഹെ.),
						'other' => q({0} കി.ഹെ.),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(മെ.ഹെ.),
						'one' => q({0} മെ.ഹെ.),
						'other' => q({0} മെ.ഹെ.),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(മെ.ഹെ.),
						'one' => q({0} മെ.ഹെ.),
						'other' => q({0} മെ.ഹെ.),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(ഡോട്ട്സ്),
						'one' => q({0} ഡോട്ട്),
						'other' => q({0} ഡോട്ട്സ്),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(ഡോട്ട്സ്),
						'one' => q({0} ഡോട്ട്),
						'other' => q({0} ഡോട്ട്സ്),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0}dpcm),
						'other' => q({0} dpcm),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(dpcm),
						'one' => q({0}dpcm),
						'other' => q({0} dpcm),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(dpi),
						'one' => q({0} dpi),
						'other' => q({0} dpi),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(ജ്യോ.യൂ.),
						'one' => q({0} ജ്യോ.യൂ.),
						'other' => q({0} ജ്യോ.യൂ.),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(ജ്യോ.യൂ.),
						'one' => q({0} ജ്യോ.യൂ.),
						'other' => q({0} ജ്യോ.യൂ.),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(സെ.മീ.),
						'one' => q({0} സെ.മീ.),
						'other' => q({0} സെ.മീ.),
						'per' => q({0}/സെ.മീ.),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(സെ.മീ.),
						'one' => q({0} സെ.മീ.),
						'other' => q({0} സെ.മീ.),
						'per' => q({0}/സെ.മീ.),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ഡെ.മീ.),
						'one' => q({0} ഡെ.മീ.),
						'other' => q({0} ഡെ.മീ),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ഡെ.മീ.),
						'one' => q({0} ഡെ.മീ.),
						'other' => q({0} ഡെ.മീ),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(ഫാതം),
						'one' => q({0} ഫാ.),
						'other' => q({0} ഫാ.),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(ഫാതം),
						'one' => q({0} ഫാ.),
						'other' => q({0} ഫാ.),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(അടി),
						'one' => q({0} അടി),
						'other' => q({0} അടി),
						'per' => q({0}/അടി),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(അടി),
						'one' => q({0} അടി),
						'other' => q({0} അടി),
						'per' => q({0}/അടി),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(ഫർലോങ്),
						'one' => q({0} ഫർ.),
						'other' => q({0} ഫർ.),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(ഫർലോങ്),
						'one' => q({0} ഫർ.),
						'other' => q({0} ഫർ.),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(ഇഞ്ച്),
						'one' => q({0} ഇഞ്ച്),
						'other' => q({0} ഇഞ്ച്),
						'per' => q({0}/ഇഞ്ച്),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(ഇഞ്ച്),
						'one' => q({0} ഇഞ്ച്),
						'other' => q({0} ഇഞ്ച്),
						'per' => q({0}/ഇഞ്ച്),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(കി.മീ.),
						'one' => q({0} കി.മീ.),
						'other' => q({0} കി.മീ.),
						'per' => q({0}/കി.മീ.),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(കി.മീ.),
						'one' => q({0} കി.മീ.),
						'other' => q({0} കി.മീ.),
						'per' => q({0}/കി.മീ.),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(പ്രകാശവർഷം),
						'one' => q({0} പ്ര.വ.),
						'other' => q({0} പ്ര.വ.),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(പ്രകാശവർഷം),
						'one' => q({0} പ്ര.വ.),
						'other' => q({0} പ്ര.വ.),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(മീറ്റർ),
						'one' => q({0} മീ.),
						'other' => q({0} മീ.),
						'per' => q({0}/മീ.),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(മീറ്റർ),
						'one' => q({0} മീ.),
						'other' => q({0} മീ.),
						'per' => q({0}/മീ.),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(μമീറ്റർ),
						'one' => q(μമീ.),
						'other' => q({0} μമീ.),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(μമീറ്റർ),
						'one' => q(μമീ.),
						'other' => q({0} μമീ.),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(മൈൽ),
						'one' => q({0} മൈൽ),
						'other' => q({0} മൈൽ),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(മൈൽ),
						'one' => q({0} മൈൽ),
						'other' => q({0} മൈൽ),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(സ്.മൈ.),
						'one' => q({0} സ്.മൈ.),
						'other' => q({0} സ്.മൈ.),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(സ്.മൈ.),
						'one' => q({0} സ്.മൈ.),
						'other' => q({0} സ്.മൈ.),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(മില്ലീമീറ്റർ),
						'one' => q({0} മി.മീ.),
						'other' => q({0} മി.മീ.),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(മില്ലീമീറ്റർ),
						'one' => q({0} മി.മീ.),
						'other' => q({0} മി.മീ.),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(നാ.മീ.),
						'one' => q({0} നാ.മീ.),
						'other' => q({0} നാ.മീ.),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(നാ.മീ.),
						'one' => q({0} നാ.മീ.),
						'other' => q({0} നാ.മീ.),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(നോ.മൈ.),
						'one' => q({0} നോ.മൈ.),
						'other' => q({0} നോ.മൈ.),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(നോ.മൈ.),
						'one' => q({0} നോ.മൈ.),
						'other' => q({0} നോ.മൈ.),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(പാർസെക്),
						'one' => q({0} പാ.സെ.),
						'other' => q({0} പാ.സെ.),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(പാർസെക്),
						'one' => q({0} പാ.സെ.),
						'other' => q({0} പാ.സെ.),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(പൈ.മീ.),
						'one' => q({0} പൈ.മീ.),
						'other' => q({0} പൈ.മീ.),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(പൈ.മീ.),
						'one' => q({0} പൈ.മീ.),
						'other' => q({0} പൈ.മീ.),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(പോയിന്റ്),
						'one' => q({0} പോ.),
						'other' => q({0} പോ.),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(പോയിന്റ്),
						'one' => q({0} പോ.),
						'other' => q({0} പോ.),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(വാര),
						'one' => q({0} വാര),
						'other' => q({0} വാര),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(വാര),
						'one' => q({0} വാര),
						'other' => q({0} വാര),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(ലക്സ്),
						'one' => q({0} ലക്സ്),
						'other' => q({0} ലക്സ്),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(ലക്സ്),
						'one' => q({0} ലക്സ്),
						'other' => q({0} ലക്സ്),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(സോളാർ ലുമിനോസിറ്റീസ്),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(സോളാർ ലുമിനോസിറ്റീസ്),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(ക്യാരറ്റ്),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(ക്യാരറ്റ്),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ഡാൽട്ടണുകൾ),
						'one' => q({0} ഡാ),
						'other' => q({0} ഡാ),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ഡാൽട്ടണുകൾ),
						'one' => q({0} ഡാ),
						'other' => q({0} ഡാ),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(ഭൂപിണ്ഡം),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(ഭൂപിണ്ഡം),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(ഗ്രെയിൻ),
						'one' => q({0} gr),
						'other' => q({0} gr),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(ഗ്രെയിൻ),
						'one' => q({0} gr),
						'other' => q({0} gr),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ഗ്രാം),
						'one' => q({0} ഗ്രാം),
						'other' => q({0} ഗ്രാം),
						'per' => q({0}/ഗ്രാം),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ഗ്രാം),
						'one' => q({0} ഗ്രാം),
						'other' => q({0} ഗ്രാം),
						'per' => q({0}/ഗ്രാം),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(കി.ഗ്രാം),
						'one' => q({0} കി.ഗ്രാം),
						'other' => q({0} കി.ഗ്രാം),
						'per' => q({0}/കി.ഗ്രാം),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(കി.ഗ്രാം),
						'one' => q({0} കി.ഗ്രാം),
						'other' => q({0} കി.ഗ്രാം),
						'per' => q({0}/കി.ഗ്രാം),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(μ.ഗ്രാം.),
						'one' => q({0} μ.ഗ്രാം.),
						'other' => q({0} μ.ഗ്രാം.),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(μ.ഗ്രാം.),
						'one' => q({0} μ.ഗ്രാം.),
						'other' => q({0} μ.ഗ്രാം.),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(മി.ഗ്രാം.),
						'one' => q({0} മി.ഗ്രാം.),
						'other' => q({0} മി.ഗ്രാം.),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(മി.ഗ്രാം.),
						'one' => q({0} മി.ഗ്രാം.),
						'other' => q({0} മി.ഗ്രാം.),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(ഔ.),
						'one' => q({0} ഔ.),
						'other' => q({0} ഔ.),
						'per' => q({0}/ഔ.),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(ഔ.),
						'one' => q({0} ഔ.),
						'other' => q({0} ഔ.),
						'per' => q({0}/ഔ.),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(ട്രോ.ഔ.),
						'one' => q({0} ട്രോ.ഔ.),
						'other' => q({0} ട്രോ.ഔ.),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(ട്രോ.ഔ.),
						'one' => q({0} ട്രോ.ഔ.),
						'other' => q({0} ട്രോ.ഔ.),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(പൗണ്ട്),
						'one' => q({0} പൗ),
						'other' => q({0} പൗ),
						'per' => q({0}/പൗ.),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(പൗണ്ട്),
						'one' => q({0} പൗ),
						'other' => q({0} പൗ),
						'per' => q({0}/പൗ.),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(സൂര്യപിണ്ഡം),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(സൂര്യപിണ്ഡം),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(സ്റ്റോൺ),
						'one' => q({0} സ്റ്റോ.),
						'other' => q({0} സ്റ്റോ.),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(സ്റ്റോൺ),
						'one' => q({0} സ്റ്റോ.),
						'other' => q({0} സ്റ്റോ.),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ടൺ),
						'one' => q({0} ടൺ),
						'other' => q({0} ടൺ),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ടൺ),
						'one' => q({0} ടൺ),
						'other' => q({0} ടൺ),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(ട.),
						'one' => q({0} ട.),
						'other' => q({0} ട.),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(ട.),
						'one' => q({0} ട.),
						'other' => q({0} ട.),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(ഗി.വാ.),
						'one' => q({0} ഗി.വാ.),
						'other' => q({0} ഗി.വാ.),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(ഗി.വാ.),
						'one' => q({0} ഗി.വാ.),
						'other' => q({0} ഗി.വാ.),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(എച്ച്.പി.),
						'one' => q({0} എച്ച്.പി.),
						'other' => q({0} എച്ച്.പി.),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(എച്ച്.പി.),
						'one' => q({0} എച്ച്.പി.),
						'other' => q({0} എച്ച്.പി.),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(കി.വാ.),
						'one' => q({0} കി.വാ.),
						'other' => q({0} കി.വാ.),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(കി.വാ.),
						'one' => q({0} കി.വാ.),
						'other' => q({0} കി.വാ.),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(മെ.വാ.),
						'one' => q({0} മെ.വാ.),
						'other' => q({0} മെ.വാ.),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(മെ.വാ.),
						'one' => q({0} മെ.വാ.),
						'other' => q({0} മെ.വാ.),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(മി.വാ.),
						'one' => q({0} മി.വാ.),
						'other' => q({0} മി.വാ.),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(മി.വാ.),
						'one' => q({0} മി.വാ.),
						'other' => q({0} മി.വാ.),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(വാട്ട്),
						'one' => q({0} വാ.),
						'other' => q({0} വാ.),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(വാട്ട്),
						'one' => q({0} വാ.),
						'other' => q({0} വാ.),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(ബാർ),
						'one' => q({0} ബാർ),
						'other' => q({0} ബാർ),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(ബാർ),
						'one' => q({0} ബാർ),
						'other' => q({0} ബാർ),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(ഹെ.പാ.),
						'one' => q({0} ഹെ.പാ.),
						'other' => q({0} ഹെ.പാ.),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(ഹെ.പാ.),
						'one' => q({0} ഹെ.പാ.),
						'other' => q({0} ഹെ.പാ.),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ഇഞ്ച് മെ.),
						'one' => q({0} ഇഞ്ച് മെ.),
						'other' => q({0} ഇഞ്ച് മെ.),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ഇഞ്ച് മെ.),
						'one' => q({0} ഇഞ്ച് മെ.),
						'other' => q({0} ഇഞ്ച് മെ.),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(മി.ബാ),
						'one' => q({0} മി.ബാ),
						'other' => q({0} മി.ബാ),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(മി.ബാ),
						'one' => q({0} മി.ബാ),
						'other' => q({0} മി.ബാ),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(മിമീ.മെ.),
						'one' => q({0} മിമീ.മെ.),
						'other' => q({0} മിമീ.മെ.),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(മിമീ.മെ.),
						'one' => q({0} മിമീ.മെ.),
						'other' => q({0} മിമീ.മെ.),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(പാ),
						'one' => q({0} പാ),
						'other' => q({0} പാ),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(പാ),
						'one' => q({0} പാ),
						'other' => q({0} പാ),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(പിഎസ്ഐ),
						'one' => q({0} പിഎസ്ഐ),
						'other' => q({0} പിഎസ്ഐ),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(പിഎസ്ഐ),
						'one' => q({0} പിഎസ്ഐ),
						'other' => q({0} പിഎസ്ഐ),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(കി.മീ/മ.),
						'one' => q({0} കി.മീ/മ.),
						'other' => q({0} കി.മീ/മ.),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(കി.മീ/മ.),
						'one' => q({0} കി.മീ/മ.),
						'other' => q({0} കി.മീ/മ.),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(നോട്ട്),
						'one' => q({0} നോട്ട്),
						'other' => q({0} നോട്ട്),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(നോട്ട്),
						'one' => q({0} നോട്ട്),
						'other' => q({0} നോട്ട്),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(മീറ്റർ/സെ.),
						'one' => q({0} മീ/സെ.),
						'other' => q({0} മീ/സെ.),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(മീറ്റർ/സെ.),
						'one' => q({0} മീ/സെ.),
						'other' => q({0} മീ/സെ.),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(മൈൽ/മ.),
						'one' => q({0} മൈ/മ.),
						'other' => q({0} മൈ/മ.),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(മൈൽ/മ.),
						'one' => q({0} മൈ/മ.),
						'other' => q({0} മൈ/മ.),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(ഡിഗ്രി.സെ.),
						'one' => q({0}°സെ),
						'other' => q({0}°സെ),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(ഡിഗ്രി.സെ.),
						'one' => q({0}°സെ),
						'other' => q({0}°സെ),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(ഡിഗ്രി.ഫാ.),
						'one' => q({0}° ഫാ),
						'other' => q({0}°ഫാ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(ഡിഗ്രി.ഫാ.),
						'one' => q({0}° ഫാ),
						'other' => q({0}°ഫാ),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'one' => q({0} K​),
						'other' => q({0} K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'one' => q({0} K​),
						'other' => q({0} K),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(ഏ. അടി),
						'one' => q({0} ഏ. അടി),
						'other' => q({0} ഏ. അടി),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(ഏ. അടി),
						'one' => q({0} ഏ. അടി),
						'other' => q({0} ഏ. അടി),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(ബാരൽ),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(ബാരൽ),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(സെ.ലി.),
						'one' => q({0} സെ.ലി.),
						'other' => q({0} സെ.ലി.),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(സെ.ലി.),
						'one' => q({0} സെ.ലി.),
						'other' => q({0} സെ.ലി.),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(സെ.മീ³),
						'one' => q({0} സെ.മീ³),
						'other' => q({0} സെ.മീ³),
						'per' => q({0}/സെ.മീ³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(സെ.മീ³),
						'one' => q({0} സെ.മീ³),
						'other' => q({0} സെ.മീ³),
						'per' => q({0}/സെ.മീ³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(അടി³),
						'one' => q({0} അടി³),
						'other' => q({0} അടി³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(അടി³),
						'one' => q({0} അടി³),
						'other' => q({0} അടി³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(ഇഞ്ച്³),
						'one' => q({0} ഇഞ്ച്³),
						'other' => q({0} ഇഞ്ച്³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(ഇഞ്ച്³),
						'one' => q({0} ഇഞ്ച്³),
						'other' => q({0} ഇഞ്ച്³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(കി.മീ³),
						'one' => q({0} കി.മീ³),
						'other' => q({0} കി.മീ³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(കി.മീ³),
						'one' => q({0} കി.മീ³),
						'other' => q({0} കി.മീ³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(മീ³),
						'one' => q({0} മീ³),
						'other' => q({0} മീ³),
						'per' => q({0}/മീ³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(മീ³),
						'one' => q({0} മീ³),
						'other' => q({0} മീ³),
						'per' => q({0}/മീ³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(മൈ³),
						'one' => q({0} മൈ³),
						'other' => q({0} മൈ³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(മൈ³),
						'one' => q({0} മൈ³),
						'other' => q({0} മൈ³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(വാര³),
						'one' => q({0} വാ³),
						'other' => q({0} വാ³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(വാര³),
						'one' => q({0} വാ³),
						'other' => q({0} വാ³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(കപ്പ്),
						'one' => q({0} കപ്പ്),
						'other' => q({0} കപ്പ്),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(കപ്പ്),
						'one' => q({0} കപ്പ്),
						'other' => q({0} കപ്പ്),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(മെ. ക.),
						'one' => q({0} മെ. ക.),
						'other' => q({0} മെ. ക.),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(മെ. ക.),
						'one' => q({0} മെ. ക.),
						'other' => q({0} മെ. ക.),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ഡെ.ലി.),
						'one' => q({0} ഡെ.ലി.),
						'other' => q({0} ഡെ.ലി.),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ഡെ.ലി.),
						'one' => q({0} ഡെ.ലി.),
						'other' => q({0} ഡെ.ലി.),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(തുള്ളി),
						'one' => q({0} തുള്ളി),
						'other' => q({0} തുള്ളി),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(തുള്ളി),
						'one' => q({0} തുള്ളി),
						'other' => q({0} തുള്ളി),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(ഫ്ലൂ. ഔ.),
						'one' => q({0} ഫ്ലൂ. ഔ.),
						'other' => q({0} ഫ്ലൂ. ഔ.),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(ഫ്ലൂ. ഔ.),
						'one' => q({0} ഫ്ലൂ. ഔ.),
						'other' => q({0} ഫ്ലൂ. ഔ.),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(ഗാ.),
						'one' => q({0} ഗാ.),
						'other' => q({0} ഗാ.),
						'per' => q({0}/ഗാ.),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(ഗാ.),
						'one' => q({0} ഗാ.),
						'other' => q({0} ഗാ.),
						'per' => q({0}/ഗാ.),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(ഇംപീ. ഗാലൺ),
						'one' => q({0} ഗാ. ഇംപീ.),
						'other' => q({0} ഗാ. ഇംപീ.),
						'per' => q({0}/ഗാ. ഇംപീ.),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(ഇംപീ. ഗാലൺ),
						'one' => q({0} ഗാ. ഇംപീ.),
						'other' => q({0} ഗാ. ഇംപീ.),
						'per' => q({0}/ഗാ. ഇംപീ.),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(ഹെ.ലി.),
						'one' => q({0} ഹെ.ലി.),
						'other' => q({0} ഹെ.ലി.),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(ഹെ.ലി.),
						'one' => q({0} ഹെ.ലി.),
						'other' => q({0} ഹെ.ലി.),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(ജിഗർ),
						'one' => q({0} ജിഗർ),
						'other' => q({0} ജിഗർ),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(ജിഗർ),
						'one' => q({0} ജിഗർ),
						'other' => q({0} ജിഗർ),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ലിറ്റർ),
						'one' => q({0} ലി.),
						'other' => q({0} ലി.),
						'per' => q({0}/ലി.),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ലിറ്റർ),
						'one' => q({0} ലി.),
						'other' => q({0} ലി.),
						'per' => q({0}/ലി.),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(മെ.ലി.),
						'one' => q({0} മെ.ലി.),
						'other' => q({0} മെ.ലി.),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(മെ.ലി.),
						'one' => q({0} മെ.ലി.),
						'other' => q({0} മെ.ലി.),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(മി.ലി.),
						'one' => q({0} മി.ലി.),
						'other' => q({0} മി.ലി.),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(മി.ലി.),
						'one' => q({0} മി.ലി.),
						'other' => q({0} മി.ലി.),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(നുള്ള്),
						'one' => q({0} നുള്ള്),
						'other' => q({0} നുള്ള്),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(നുള്ള്),
						'one' => q({0} നുള്ള്),
						'other' => q({0} നുള്ള്),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(പൈ.),
						'one' => q({0} പൈ.),
						'other' => q({0} പൈ.),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(പൈ.),
						'one' => q({0} പൈ.),
						'other' => q({0} പൈ.),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(മെ. പൈ.),
						'one' => q({0} മെ. പൈ.),
						'other' => q({0} മെ. പൈ.),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(മെ. പൈ.),
						'one' => q({0} മെ. പൈ.),
						'other' => q({0} മെ. പൈ.),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(ക്വാ.),
						'one' => q({0} ക്വാ.),
						'other' => q({0} ക്വാ.),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(ക്വാ.),
						'one' => q({0} ക്വാ.),
						'other' => q({0} ക്വാ.),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(ടേ.സ്‌പൂ.),
						'one' => q({0} ടേ.സ്‌പൂ.),
						'other' => q({0} ടേ.സ്‌പൂ.),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(ടേ.സ്‌പൂ.),
						'one' => q({0} ടേ.സ്‌പൂ.),
						'other' => q({0} ടേ.സ്‌പൂ.),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(ടീ.സ്‌പൂ.),
						'one' => q({0} ടീ.സ്‌പൂ.),
						'other' => q({0} ടീ.സ്‌പൂ.),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(ടീ.സ്‌പൂ.),
						'one' => q({0} ടീ.സ്‌പൂ.),
						'other' => q({0} ടീ.സ്‌പൂ.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ഉവ്വ്|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:അല്ല|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				end => q({0}, {1} എന്നിവ),
				2 => q({0} കൂടാതെ {1}),
		} }
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'mlym',
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 ആയിരം',
					'other' => '0 ആയിരം',
				},
				'10000' => {
					'one' => '00 ആയിരം',
					'other' => '00 ആയിരം',
				},
				'100000' => {
					'one' => '000 ആയിരം',
					'other' => '000 ആയിരം',
				},
				'1000000' => {
					'one' => '0 ദശലക്ഷം',
					'other' => '0 ദശലക്ഷം',
				},
				'10000000' => {
					'one' => '00 ദശലക്ഷം',
					'other' => '00 ദശലക്ഷം',
				},
				'100000000' => {
					'one' => '000 ദശലക്ഷം',
					'other' => '000 ദശലക്ഷം',
				},
				'1000000000' => {
					'one' => '0B',
					'other' => '0B',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
				'1000000000000' => {
					'one' => '0 ട്രില്യൺ',
					'other' => '0 ട്രില്യൺ',
				},
				'10000000000000' => {
					'one' => '00 ട്രില്യൺ',
					'other' => '00 ട്രില്യൺ',
				},
				'100000000000000' => {
					'one' => '000 ട്രില്യൺ',
					'other' => '000 ട്രില്യൺ',
				},
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ആയിരം',
					'other' => '0 ആയിരം',
				},
				'10000' => {
					'one' => '00 ആയിരം',
					'other' => '00 ആയിരം',
				},
				'100000' => {
					'one' => '000 ആയിരം',
					'other' => '000 ആയിരം',
				},
				'1000000' => {
					'one' => '0 ദശലക്ഷം',
					'other' => '0 ദശലക്ഷം',
				},
				'10000000' => {
					'one' => '00 ദശലക്ഷം',
					'other' => '00 ദശലക്ഷം',
				},
				'100000000' => {
					'one' => '000 ദശലക്ഷം',
					'other' => '000 ദശലക്ഷം',
				},
				'1000000000' => {
					'one' => '0 ലക്ഷം കോടി',
					'other' => '0 ലക്ഷം കോടി',
				},
				'10000000000' => {
					'one' => '00 ലക്ഷം കോടി',
					'other' => '00 ലക്ഷം കോടി',
				},
				'100000000000' => {
					'one' => '000 ലക്ഷം കോടി',
					'other' => '000 ലക്ഷം കോടി',
				},
				'1000000000000' => {
					'one' => '0 ട്രില്യൺ',
					'other' => '0 ട്രില്യൺ',
				},
				'10000000000000' => {
					'one' => '00 ട്രില്യൺ',
					'other' => '00 ട്രില്യൺ',
				},
				'100000000000000' => {
					'one' => '000 ട്രില്യൺ',
					'other' => '000 ട്രില്യൺ',
				},
			},
			'short' => {
				'1000000000' => {
					'one' => '0B',
					'other' => '0B',
				},
				'10000000000' => {
					'one' => '00B',
					'other' => '00B',
				},
				'100000000000' => {
					'one' => '000B',
					'other' => '000B',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(അൻഡോറൻ പെസെയ്റ്റ),
				'one' => q(അൻഡോറൻ പെസെയ്റ്റ),
				'other' => q(അൻഡോറൻ പെസെയ്റ്റാസ്),
			},
		},
		'AED' => {
			display_name => {
				'currency' => q(യുണൈറ്റഡ് അറബ് എമിറേറ്റ്സ് ദിർഹം),
				'one' => q(യു.എ.ഇ. ദിർഹം),
				'other' => q(യു.എ.ഇ. ദിർഹം),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(അഫ്ഘാനി \(1927–2002\)),
				'one' => q(അഫ്ഘാനി \(AFA\)),
				'other' => q(അഫ്ഘാനിസ് \(AFA\)),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(അഫ്‌ഗാൻ അഫ്‌‌ഗാനി),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(അൽബേനിയൻ ലെക്),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(അർമേനിയൻ ഡ്രാം),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(നെതർലാൻഡ്‌സ് ആന്റിലൻ ഗിൽഡർ),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(അംഗോളൻ ‍ക്വാൻസ),
				'one' => q(അംഗോളൻ ക്വാൻസ),
				'other' => q(അംഗോളൻ ക്വാൻസ),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(അംഗോളൻ ‍ക്വാൻസ \(1977–1990\)),
				'one' => q(അംഗോളൻ ക്വാൻസാ \(AOK\)),
				'other' => q(അംഗോളൻ ക്വാൻസാസ് \(AOK),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(അംഗോളൻ ‍ന്യൂ ക്വാൻസ \(1990–2000\)),
				'one' => q(അംഗോളൻ ന്യൂ ക്വാൻസാ \(AON\)),
				'other' => q(അംഗോളൻ ന്യൂ ക്വാൻസാസ് \(AON\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(അംഗോളൻ ‍ക്വാൻസ റിയാജസ്റ്റാഡോ \(1995–1999\)),
				'one' => q(അംഗോളൻ ക്വാൻസ റീഅഡ്ജസ്റ്റാഡോ \(AOR\)),
				'other' => q(അംഗോളൻ ക്വാൻസാസ് റീഅഡ്ജസ്റ്റാഡോ \(AOR\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(അർജൻറീൻ ഓസ്ട്രൽ),
				'one' => q(അർജൻറീൻ ഓസ്ട്രൽ),
				'other' => q(അർജൻറീൻ ഓസ്ട്രൽസ്),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(അർജൻറീൻ പെയ്സോ \(1983–1985\)),
				'one' => q(അർജൻറീൻ പെയ്സോ \(ARP\)),
				'other' => q(അർജൻറീൻ പെയ്സോസ് \(ARP\)),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(അർജൻറീൻ പെസോ),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(ഓസ്ട്രേലിയൻ ഷില്ലിംഗ്),
				'one' => q(ഓസ്ട്രിയൻ ഷില്ലിംഗ്),
				'other' => q(ഓസ്ട്രിയൻ ഷില്ലിംഗ്സ്),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(ഓസ്ട്രേലിയൻ ഡോളർ),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(അറൂബൻ ഫ്ലോറിൻ),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(അസർബയ്ജാനിയൻ മനത് \(1993–2006\)),
				'one' => q(അസർബയ്ജാൻ മനത്‌ \(AZM\)),
				'other' => q(അസർബയ്ജാൻ മനത്‌സ് \(AZM\)),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(അസർബൈജാനി മനത്),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(ബോസ്നിയ-ഹെർസഗോവിന ദിനാർ),
				'one' => q(ബോസ്നിയ ഹെർസഗോവിന ദിനാർ),
				'other' => q(ബോസ്നിയ ഹെർസഗോവിന ദിനാർസ്),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(ബോസ്‌നിയ-ഹെർസഗോവിന കൺവേർട്ടബിൾ മാർക്ക്),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(ബാർബേഡിയൻ ഡോളർ),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(ബംഗ്ലാദേശി ടാക്ക),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(ബെൽജിയൻ ഫ്രാങ്ക് \(കൈമാറ്റം ചെയ്യാവുന്നത്\)),
				'one' => q(ബെൽജിയൻ ഫ്രാങ്ക് \(കൈമാറ്റം ചെയ്യാവുന്നത്\)),
				'other' => q(ബെൽജിയൻ ഫ്രാങ്ക്സ് \(കൈമാറ്റം ചെയ്യാവുന്നത്\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(ബെൽജിയൻ ഫ്രാങ്ക്),
				'one' => q(ബെൽജിയൻ ഫ്രാങ്ക്),
				'other' => q(ബെൽജിയൻ ഫ്രാങ്ക്സ്),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(ബൽജിയൻ ഫ്രാങ്ക്),
				'one' => q(ബെൽജിയൻ ഫ്രാങ്ക് \(ഫിനാൻഷ്യൽ\)),
				'other' => q(ബെൽജിയൻ ഫ്രാങ്ക്സ്\(ഫിനാൻഷ്യൽ\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(ബൾഗേറിയൻ ഹാർഡ് ലെവ്),
				'one' => q(ബൾഗേറിയൻ ഹാർഡ് ലെവ്),
				'other' => q(ബൾഗേറിയൻ ഹാർഡ് ലെവ്സ്),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(ബൾഗേറിയൻ ലെവ്),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(ബഹ്റൈനി ദിനാർ),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(ബറുണ്ടിയൻ ഫ്രാങ്ക്),
				'one' => q(ബുറുണ്ടിയൻ ഫ്രാങ്ക്),
				'other' => q(ബറുണ്ടിയൻ ഫ്രാങ്ക്),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(ബെർമുഡൻ ഡോളർ),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ബ്രൂണൈ ഡോളർ),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(ബൊളീവിയൻ ബൊളിവിയാനോ),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(ബൊളീവിയൻ പെയ്സോ),
				'one' => q(ബൊളീവിയൻ പെയ്സോ),
				'other' => q(ബൊളീവിയൻ പെയ്സോസ്),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(ബൊളീവിയൻ എംവിഡോൾ),
				'one' => q(ബൊളീവിയൻ എംവിഡോ),
				'other' => q(ബൊളീവിയൻ എംവിഡോസ്),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ നോവോ \(1967–1986\)),
				'one' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ നോവോ \(BRB\)),
				'other' => q(ബ്രസീലിയൻ ക്രുസെയ്റോസ് നോവോ \(BRB\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ ക്രുസാഡോ),
				'one' => q(ബ്രസീലിയൻ ക്രുസാഡോ),
				'other' => q(ബ്രസീലിയൻ ക്രുസാഡോസ്),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ \(1990–1993\)),
				'one' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ \(BRE\)),
				'other' => q(ബ്രസീലിയൻ ക്രുസെയ്റോസ് \(BRE\)),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ റിയാൽ),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ ക്രുസാഡോ നോവോ),
				'one' => q(ബ്രസീലിയൻ ക്രുസാഡോ നോവോ),
				'other' => q(ബ്രസീലിയൻ ക്രുസാഡോ നോവോസ്),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ),
				'one' => q(ബ്രസീലിയൻ ക്രുസെയ്റോ),
				'other' => q(ബ്രസീലിയൻ ക്രുസെയ്റോസ്),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(ബഹാമിയൻ ഡോളർ),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ഭൂട്ടാനീസ് ഗൾട്രം),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(ബർമീസ് ചാറ്റ്),
				'one' => q(ബർമീസ് ചാറ്റ്),
				'other' => q(ബർമീസ് ചാറ്റ്സ്),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(ബോട്‌സ്വാനൻ പ്യുല),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(ബെലാറഷ്യൻ ന്യൂ റൂബിൾ \(1994–1999\)),
				'one' => q(ബെലാറഷ്യൻ ന്യൂ റൂബിൾ \(BYB\)),
				'other' => q(ബെലാറഷ്യൻ ന്യൂ റൂബിൾസ് \(BYB\)),
			},
		},
		'BYN' => {
			symbol => 'р.',
			display_name => {
				'currency' => q(ബെലാറുഷ്യൻ റൂബിൾ),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(ബെലാറുഷ്യൻ റൂബിൾ \(2000–2016\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(ബെലീസ് ഡോളർ),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(കനേഡിയൻ ഡോളർ),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(കോങ്കളീസ് ഫ്രാങ്ക്),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(WIR യൂറോ),
				'one' => q(WIR യൂറോ),
				'other' => q(WIR യൂറോസ്),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(സ്വിസ് ഫ്രാങ്ക്),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(WIR ഫ്രാങ്ക്),
				'one' => q(WIR ഫ്രാങ്ക്),
				'other' => q(WIR ഫ്രാങ്ക്സ്),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(ചിലിയൻ യൂണിഡാഡ്സ് ഡി ഫോമെൻറോ),
				'one' => q(ചിലിയൻ യൂണിഡാഡ്സ് ഡി ഫോമെൻറോ),
				'other' => q(ചിലിയൻ യൂണിഡാഡ്സ് ഡി ഫോമെൻറോസ്),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(ചിലിയൻ പെസോ),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(ചൈനീസ് യുവാൻ \(ഓഫ്‌ഷോർ\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(ചൈനീസ് യുവാൻ),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(കൊളംബിയൻ പെസോ),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(യൂണിഡാഡ് ഡി വാലർ റിയൽ),
				'one' => q(യൂണിഡാഡ് ഡി വാലർ റിയൽ),
				'other' => q(യൂണിഡാഡ് ഡി വാലർ റിയൽസ്),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(കോസ്റ്റാ റിക്കൻ കോളൻ),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(പ്രാചീന സെർബിയൻ ദിനാർ),
				'one' => q(പ്രാചീന സെർബിയൻ ദിനാർ),
				'other' => q(പ്രാചീന സെർബിയൻ ദിനാർസ്),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(ചെക്കോസ്ലൊവാക്ക് ഹാർഡ് കൊരൂന),
				'one' => q(ചെക്കോസ്ലൊവാക്ക് ഹാർഡ് കൊരൂന),
				'other' => q(ചെക്കോസ്ലൊവാക്ക് ഹാർഡ് കൊരൂനാസ്),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(ക്യൂബൻ കൺവേർട്ടബിൾ പെസോ),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(ക്യൂബൻ പെസോ),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(കേപ് വെർദിയൻ എസ്‌ക്യുഡോ),
				'one' => q(കേപ് വെർദിയൻ എസ്‌ക്യുഡോ),
				'other' => q(കേപ് വെർദിയൻ എസ്‌ക്യുഡോസ്),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(സൈപ്രസ് പൌണ്ട്),
				'one' => q(സൈപ്രസ് പൌണ്ട്),
				'other' => q(സൈപ്രസ് പൌണ്ട്സ്),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(ചെക്ക് റിപ്പബ്ലിക് കൊരുണ),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(കിഴക്കൻ ജർമൻ ഓസ്റ്റ്മാർക്ക്),
				'one' => q(കിഴക്കൻ ജർമൻ ഓസ്റ്റ്മാർക്ക്),
				'other' => q(കിഴക്കൻ ജർമൻ ഓസ്റ്റ്മാർക്ക്സ്),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(ജർമൻ മാർക്ക്),
				'one' => q(ജർമൻ മാർക്ക്),
				'other' => q(ജർമൻ മാർക്ക്സ്),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(ദിജിബൗട്ടിയൻ ഫ്രാങ്ക്),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ഡാനിഷ് ക്രോണെ),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ഡൊമിനിക്കൻ പെസോ),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(അൾജീരിയൻ ദിനാർ),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(ഇക്വഡോർ സൂക്രേ),
				'one' => q(ഇക്വഡോർ സൂക്രേ),
				'other' => q(ഇക്വഡോർ സൂക്രേസ്),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(ഇക്വഡോർ യൂണിഡാഡ് വാലർ കോൺസ്റ്റൻറെ \(UVC\)),
				'one' => q(ഇക്വഡോർ യൂണിഡാഡ് ഡി വാലർ കോൺസ്റ്റൻറെ \(UVC\)),
				'other' => q(ഇക്വഡോർ യൂണിഡാഡ്സ് ഡി വാലർ കോൺസ്റ്റൻറെ \(UVC\)),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(എസ്റ്റൌനിയൻ ക്രൂൺ),
				'one' => q(എസ്റ്റൌനിയൻ ക്രൂൺ),
				'other' => q(എസ്റ്റൌനിയൻ ക്രൂൺസ്),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(ഈജിപ്‌ഷ്യൻ പൗണ്ട്),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(എറിത്രിയൻ നക്ഫ),
				'one' => q(എറിത്രിയൻ നക്ഫ),
				'other' => q(എറിത്രിയൻ നക്‌ഫ),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(സ്പാനിഷ് പസെയ്റ്റ \(A അക്കൌണ്ട്\)),
				'one' => q(സ്പാനിഷ് പസെയ്റ്റ \(A അക്കൌണ്ട്\)),
				'other' => q(സ്പാനിഷ് പസെയ്റ്റാസ് \(A അക്കൌണ്ട്\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(സ്പാനിഷ് പസെയ്റ്റ \(കൈമാറ്റം ചെയ്യാവുന്ന അക്കൌണ്ട്\)),
				'one' => q(സ്പാനിഷ് പസെയ്റ്റ \(കൈമാറ്റം ചെയ്യാവുന്ന അക്കൌണ്ട്\)),
				'other' => q(സ്പാനിഷ് പസെയ്റ്റാസ് \(കൈമാറ്റം ചെയ്യാവുന്ന അക്കൌണ്ട്\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(സ്പാനിഷ് പസെയ്റ്റ),
				'one' => q(സ്പാനിഷ് പസെയ്റ്റ),
				'other' => q(സ്പാനിഷ് പസെയ്റ്റാസ്),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(എത്യോപ്യൻ ബിർ),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(യൂറോ),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(ഫിന്നിഷ് മാർക്ക),
				'one' => q(ഫിന്നിഷ് മാർക്ക),
				'other' => q(ഫിന്നിഷ് മാർക്കാസ്),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(ഫിജിയൻ ഡോളർ),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(ഫാക്ക്‌ലാന്റ് ദ്വീപുകളുടെ പൗണ്ട്),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(ഫ്രാങ്ക്),
				'one' => q(ഫ്രെഞ്ച് ഫ്രാങ്ക്),
				'other' => q(ഫ്രെഞ്ച് ഫ്രാങ്ക്സ്),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(ബ്രിട്ടീഷ് പൗണ്ട്),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(ജോർ‍ജ്ജിയൻ ക്യൂപോൺ ലാരിറ്റ്),
				'one' => q(ജോർ‍ജ്ജിയൻ ക്യൂപോൺ ലാരിറ്റ്),
				'other' => q(ജോർ‍ജ്ജിയൻ ക്യൂപോൺ ലാരിറ്റ്സ്),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(ജോർജ്ജിയൻ ലാറി),
				'one' => q(ജോർജ്ജിയൻ ലാറി),
				'other' => q(ജോർജ്ജിയൻ ലാറിസ്),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(ഘാന കെഡി \(1979–2007\)),
				'one' => q(ഘാന കെഡി \(GHC\)),
				'other' => q(ഘാന കെഡിസ് \(GHC\)),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(ഘാനയൻ കെഡി),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(ജിബ്രാൾട്ടർ പൗണ്ട്),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(ഗാംബിയൻ ദലാസി),
				'one' => q(ഗാംബിയൻ ദലാസി),
				'other' => q(ഗാംബിയൻ ദലാസിസ്),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(ഗിനിയൻ ഫ്രാങ്ക്),
				'one' => q(ഗിനിയൻ ഫ്രാങ്ക്),
				'other' => q(ഗിനിയൻ ഫ്രാങ്ക്സ്),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(ഗിനിയ സൈലി),
				'one' => q(ഗിനിയ സൈലി),
				'other' => q(ഗിനിയ സൈലിസ്),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(ഇക്വിറ്റോറിയൽ ഗിനിയ എക്വീലെ ഗിനിയാന),
				'one' => q(ഇക്വിറ്റോറിയൽ ഗിനി എക്വീലെ),
				'other' => q(ഇക്വിറ്റോറിയൽ ഗിനി എക്വീലെ),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(ഗ്രീക്ക് ഡ്രാക്ക്മ),
				'one' => q(ഗ്രീക്ക് ഡ്രാക്ക്മ),
				'other' => q(ഗ്രീക്ക് ഡ്രാക്ക്മാസ്),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ഗ്വാട്ടിമാലൻ ക്വെറ്റ്‌സൽ),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(പോർച്ചുഗീസ് ഗിനി എസ്ക്യൂഡോ),
				'one' => q(പോർച്ചുഗീസ് ഗിനി എസ്ക്യൂഡോ),
				'other' => q(പോർച്ചുഗീസ് ഗിനി എസ്ക്യൂഡോസ്),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(ഗിനിയ-ബിസാവു പെയ്സോ),
				'one' => q(ഗിനി-ബിസാവു പെയ്സോ),
				'other' => q(ഗിനി-ബിസാവു പെയ്സോസ്),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(ഗയാനീസ് ഡോളർ),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(ഹോങ്കോങ്ങ് ഡോളർ),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(ഹോണ്ടുറൻ ലെംപിറ),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(ക്രൊയേഷ്യൻ ദിനാർ),
				'one' => q(ക്രൊയേഷ്യൻ ദിനാർ),
				'other' => q(ക്രൊയേഷ്യൻ ദിനാർസ്),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(ക്രൊയേഷൻ ക്യുന),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(ഹെയ്‌തിയൻ ഗൂർഡ്),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(ഹംഗേറിയൻ ഫോറിന്റ്),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(ഇന്തോനേഷ്യൻ റുപിയ),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ഐറിഷ് പൌണ്ട്),
				'one' => q(ഐറിഷ് പൌണ്ട്),
				'other' => q(ഐറിഷ് പൌണ്ട്സ്),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(ഇസ്രയേലി പൌണ്ട്),
				'one' => q(ഇസ്രയേലി പൌണ്ട്),
				'other' => q(ഇസ്രയേലി പൌണ്ട്സ്),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(ഇസ്രായേലി ന്യൂ ഷെക്കെൽ),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(ഇന്ത്യൻ രൂപ),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ഇറാഖി ദിനാർ),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ഇറാനിയൻ റിയാൽ),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(ഐസ്‌ലാൻഡിക് ക്രോണ),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(ഇറ്റാലിയൻ ലിറ),
				'one' => q(ഇറ്റാലിയൻ ലിറ),
				'other' => q(ഇറ്റാലിയൻ ലിറാസ്),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(ജമൈക്കൻ ഡോളർ),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(ജോർദ്ദാനിയൻ ദിനാർ),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(ജാപ്പനീസ് യെൻ),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(കെനിയൻ ഷില്ലിംഗ്),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(കിർഗിസ്ഥാനി സോം),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(കംബോഡിയൻ റീൽ),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(കൊമോറിയൻ ഫ്രാങ്ക്),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(ഉത്തര കൊറിയൻ വോൺ),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(ദക്ഷിണ കൊറിയൻ വോൺ),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(കുവൈറ്റി ദിനാർ),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(കേമാൻ ഐലൻഡ്‌സ് ഡോളർ),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(കസാക്കിസ്ഥാനി ടെംഗെ),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(ലാവോഷിയൻ കിപ്),
				'one' => q(ലാവോഷ്യൻ കിപ്‌),
				'other' => q(ലാവോഷിയൻ കിപ്),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(ലെബനീസ് പൗണ്ട്),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(ശ്രീലങ്കൻ റുപ്പീ),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(ലൈബീരിയൻ ഡോളർ),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(ലെസോതോ ലോത്തി),
				'one' => q(ലെസോതോ ലോത്തി),
				'other' => q(ലെസോതോ ലോത്തിസ്‌),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(ലിത്വാനിയൻ ലിറ്റാസ്),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(ലിത്വാനിയൻ തലോനാസ്),
				'one' => q(ലിത്വാനിയൻ തലോനാസ്),
				'other' => q(ലിത്വാനിയൻ തലോനാസെസ്‌),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(ലക്സംബർഗ് കൺവേർട്ടിബിൾ ഫ്രാങ്ക്),
				'one' => q(ലക്സംബർഗ് കൈമാറ്റം ചെയ്യാവുന്ന ഫ്രാങ്ക്‌),
				'other' => q(ലക്സംബർഗ് കൈമാറ്റം ചെയ്യാവുന്ന ഫ്രാങ്ക്‌സ്‌),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(ലക്സംബർഗ് ഫ്രാങ്ക്),
				'one' => q(ലക്സംബർഗ് ഫ്രാങ്ക്),
				'other' => q(ലക്സംബർഗ് ഫ്രാങ്ക്‌സ്‌),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(ലക്സംബർഗ് ഫിനാൻഷ്യൽ ഫ്രാങ്ക്),
				'one' => q(ലക്സംബർഗ് ഫിനാൻഷ്യൽ ഫ്രാങ്ക്),
				'other' => q(ലക്സംബർഗ് ഫിനാൻഷ്യൽ ഫ്രാങ്ക്‌സ്‌),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(ലാറ്റ്വിയൻ ലാറ്റ്സ്),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(ലാറ്റ്വിയൻ റൂബിൾ),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(ലിബിയൻ ദിനാർ),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(മൊറോക്കൻ ദിർഹം),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(മൊറോക്കൻ ഫ്രാങ്ക്),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(മൊൾഡോവൻ ലിയു),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(മഡഗാസി ഏരിയറി),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(മഡഗാസ്കർ ഫ്രാങ്ക്),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(മാസിഡോണിയൻ ദിനാർ),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(മാലി ഫ്രാങ്ക്),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(മ്യാൻമാർ ക്യാട്),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(മംഗോളിയൻ തുഗ്രിക്),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(മകാനീസ് പതാക്ക),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(മൗറിറ്റേനിയൻ ഔഗിയ \(1973–2017\)),
				'one' => q(മൗറിറ്റേനിയൻ ഔഗിയ \(1973–2017\)),
				'other' => q(മൗറിറ്റേനിയൻ ഔഗിയസ് \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(മൗറിറ്റേനിയൻ ഔഗിയ),
				'one' => q(മൗറിറ്റേനിയൻ ഔഗിയ),
				'other' => q(മൗറിറ്റേനിയൻ ഔഗിയസ്),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(മൽത്തീസ് ലിറ),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(മൽത്തീസ് പൌണ്ട്),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(മൗറീഷ്യൻ റുപ്പീ),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(മാൽദീവിയൻ റുഫിയ),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(മലാവിയൻ ക്വച്ചാ),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(മെക്സിക്കൻ പെസോ),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(മെക്സിക്കൻ സിൽവർ പെയ്സോ \(1861–1992\)),
				'one' => q(മെക്സിക്കൻ സിൽവർ പെയ്സോ \(MXP\)),
				'other' => q(മെക്സിക്കൻ സിൽവർ പെയ്സോസ് \(MXP\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(മെക്സിക്കൻ യൂണിഡാഡ് ഡി ഇൻവെർഷൻ \(UDI\)),
				'one' => q(മെക്സിക്കൻ യൂണിഡാഡ് ഡി ഇൻവെർഷൻ \(UDI\)),
				'other' => q(മെക്സിക്കൻ യൂണിഡാഡ്സ് ഡി ഇൻവെർഷൻ \(UDI\)),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(മലേഷ്യൻ റിംഗിറ്റ്),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(മൊസാന്പിക്ക് എസ്ക്യുഡോ),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(ഓൾഡ് മൊസാന്പിക്ക് മെറ്റിക്കൽ),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(മൊസാംബിക്കൻ മെറ്റിക്കൽ),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(നമീബിയൻ ഡോളർ),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(നൈജീരിയൻ നൈറ),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(നികരാഗ്വൻ കൊർഡോബ),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(നിക്കരാഗ്വൻ കോർഡോബ),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(നെതർലൻഡ്സ് ഗിൽഡർ),
				'one' => q(നെതർലൻഡ്സ് ഗിൽഡർ),
				'other' => q(നെതർലൻഡ്സ് ഗിൽഡേഴ്സ്),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(നോർവീജിയൻ ക്രോണെ),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(നേപ്പാളീസ് റുപ്പീ),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(ന്യൂസിലാന്റ് ഡോളർ),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ഒമാനി റിയാൽ),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(പനാമനിയൻ ബാൽബോവ),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(പെറൂവിയൻ ഇൻറി),
				'one' => q(പെറൂവിയൻ ഇൻറി),
				'other' => q(പെറൂവിയൻ ഇൻറിസ്),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(പെറുവിയൻ സോൾ),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(പെറൂവിയൻ സോൾ \(1863–1965\)),
				'one' => q(പെറൂവിയൻ സോൾ \(1863–1965\)),
				'other' => q(പെറൂവിയൻ സോൾസ് \(1863–1965\)),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(പാപ്പുവ ന്യൂ ഗിനിയൻ കിന),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ഫിലിപ്പീനി പെസോ),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(പാക്കിസ്ഥാനി റുപ്പീ),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(പോളിഷ് സ്ലോട്ടി),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(പോളിഷ് സ്ലോട്ടി \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(പോർച്ചുഗീസ് എസ്ക്യുഡോ),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(പരാഗ്വേയൻ ഗ്വരനീ),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(ഖത്തർ റിയാൽ),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(റൊഡേഷ്യൻ ഡോളർ),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(പ്രാചീന റൊമേനിയൻ ലിയു),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(റൊമാനിയൻ ലെയു),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(സെർബിയൻ ദിനാർ),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(റഷ്യൻ റൂബിൾ),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(റഷ്യൻ റൂബിൾ \(1991–1998\)),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(റുവാണ്ടൻ ഫ്രാങ്ക്),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(സൗദി റിയാൽ),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(സോളമൻ ദ്വീപ് ഡോളർ),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(സീഷെലോയിസ് റുപ്പീ),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(പ്രാചീന സുഡാനീസ് ദിനാർ),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(സുഡാനീസ് പൗണ്ട്),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(പ്രാചീന സുഡാനീസ് പൌണ്ട്),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(സ്വീഡിഷ് ക്രോണ),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(സിംഗപ്പൂർ ഡോളർ),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(സെന്റ് ഹെലീന പൗണ്ട്),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(സ്ലൊവേനിയ റ്റോളർ),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(സ്ലോവാക് കൊരൂന),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(സിയെറ ലിയോണിയൻ ലിയോൺ),
				'one' => q(സിയെറ ലിയോണിയൻ ലിയോൺ),
				'other' => q(സിയെറ ലിയോണിയൻ ലിയോണസ്),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(സിയെറ ലിയോണിയൻ ലിയോൺ \(1964—2022\)),
				'one' => q(സിയെറ ലിയോണിയൻ ലിയോൺ \(1964—2022\)),
				'other' => q(സിയെറ ലിയോണിയൻ ലിയോണസ് \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(സോമാലി ഷില്ലിംഗ്),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(സുരിനെയിമിസ് ഡോളർ),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(സൂരിനാം ഗിൽഡർ),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(ദക്ഷിണ സുഡാനീസ് പൗണ്ട്),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(സാവോ ടോമി ആൻഡ് പ്രിൻസിപെ ഡോബ്ര \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(സാവോ ടോമി ആൻഡ് പ്രിൻസിപെ ഡോബ്ര),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(സോവിയറ്റ് റൂബിൾ),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(എൽ സാൽവഡോർ കോളൻ),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(സിറിയൻ പൗണ്ട്),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(സ്വാസി ലിലാംഗനി),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(തായ് ബട്ട്),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(താജിക്കിസ്ഥാൻ റൂബിൾ),
				'one' => q(തജിക്സ്ഥാൻ റൂബിൾ),
				'other' => q(തജിക്സ്ഥാൻ റൂബിൾസ്),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(താജിക്കിസ്ഥാനി സോംനി),
				'one' => q(താജിക്കിസ്ഥാനി സോംനി),
				'other' => q(താജിക്കിസ്ഥാനി സൊമോനി),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(തുർക്മെനിസ്ഥാൻ മനത്),
				'one' => q(തുർക്മെനിസ്ഥാൻ മനത്),
				'other' => q(തുർക്മെനിസ്ഥാൻ മനത്‌സ്),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(തുർക്ക്‌മെനിസ്ഥാനി മനത്),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ടുണീഷ്യൻ ദിനാർ),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ടോംഗൻ പാംഗ),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(തിമോർ എസ്ക്യൂഡോ),
				'one' => q(തിമോർ എസ്ക്യൂഡോ),
				'other' => q(തിമോർ എസ്ക്യൂഡോസ്),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(പ്രാചീന തുർക്കിഷ് ലിറ),
				'one' => q(പ്രാചീന തുർക്കിഷ് ലിറ),
				'other' => q(പ്രാചീന തുർക്കിഷ് ലിറാസ്),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(ടർക്കിഷ് ലിറ),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ട്രിനിഡാഡ് അന്റ് ടുബാഗോ ഡോളർ),
				'one' => q(ട്രിനിഡാഡ് ആന്റ് ടുബാഗോ ഡോളർ),
				'other' => q(ട്രിനിഡാഡ് ആന്റ് ടുബാഗോ ഡോളർ),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ന്യൂ തായ്‌വാൻ ഡോളർ),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(ടാൻസാനിയൻ ഷില്ലിംഗ്),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(ഉക്രേനിയൻ ഹ്രിവ്‌നിയ),
				'one' => q(ഉക്രേനിയൻ ഹ്രിവ്നിയ),
				'other' => q(ഉക്രേനിയൻ ഹ്രിവ്‌നിയ),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(യുക്രേനിയൻ കാർബോവാനെസ്),
				'one' => q(ഉക്രേനിയൻ കാർബോവാനെസ്),
				'other' => q(ഉക്രേനിയൻ കാർബോവാനെസ്),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(ഉഗാണ്ടൻ ഷില്ലിംഗ് \(1966–1987\)),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(ഉഗാണ്ടൻ ഷില്ലിംഗ്),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(യു.എസ്. ഡോളർ),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(യുഎസ് ഡോളർ \(അടുത്ത ദിവസം\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(യുഎസ് ഡോളർ \(അതേ ദിവസം\)),
				'one' => q(യുഎസ് ഡോളർ \(അതേ ദിവസം\)),
				'other' => q(യുഎസ് ഡോളേഴ്സ് \(അതേ ദിവസം\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(ഉറുഗ്വേ പെയ്സോ എൻ യൂണിഡാഡ്സ്),
				'one' => q(ഉറുഗ്വേ പെയ്സോ എൻ യൂണിഡാഡ്സ് ഇൻഡെക്സാഡാസ്),
				'other' => q(ഉറുഗ്വേ പെയ്സോസ് എൻ യൂണിഡാഡ്സ് ഇൻഡെക്സാഡാസ്),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(ഉറുഗ്വേ പെയ്സോ \(1975–1993\)),
				'one' => q(ഉറുഗ്വേ പെയ്സോ \(UYP\)),
				'other' => q(ഉറുഗ്വേ പെയ്സോസ് \(UYP\)),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ഉറുഗ്വേയൻ പെസോ),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ഉസ്‌ബെക്കിസ്ഥാനി സോം),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(വെനസ്വേലൻ ബോലിവർ \(1871–2008\)),
				'one' => q(വെനസ്വേലൻ ബോലിവർ \(1871–2008\)),
				'other' => q(വെനസ്വേലൻ ബോലിവർസ് \(1871–2008\)),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(വെനിസ്വേലൻ ബൊളീവർ \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(വെനിസ്വേലൻ ബൊളീവർ),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(വിയറ്റ്നാമീസ് ഡോങ്),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(വന്വാതു വാതു),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(സമോവൻ താല),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(മദ്ധ്യ ആഫ്രിക്കൻ [CFA] ഫ്രാങ്ക്),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(വെള്ളി),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(സ്വർണ്ണം),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(യൂറോപ്യൻ കോന്പസിറ്റ് യൂണിറ്റ്),
				'one' => q(യൂറോപ്യൻ കോന്പസിറ്റ് യൂണിറ്റ്),
				'other' => q(യൂറോപ്യൻ കോന്പസിറ്റ് യൂണിറ്റ്സ്),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(യൂറോപ്യൻ മോണിറ്ററി യൂണിറ്റ്),
				'one' => q(യൂറോപ്യൻ മോണിറ്ററി യൂണിറ്റ്),
				'other' => q(യൂറോപ്യൻ മോണിറ്ററി യൂണിറ്റ്സ്),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(യൂറോപ്യൻ യൂണിറ്റ് ഓഫ് അക്കൌണ്ട് \(XBC\)),
				'one' => q(യൂറോപ്യൻ യൂണിറ്റ് ഓഫ് അക്കൌണ്ട് \(XBC\)),
				'other' => q(യൂറോപ്യൻ യൂണിറ്റ്സ് ഓഫ് അക്കൌണ്ട് \(XBC\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(യൂറോപ്യൻ യൂണിറ്റ് ഓഫ് അക്കൌണ്ട് \(XBD\)),
				'one' => q(യൂറോപ്യൻ യൂണിറ്റ് ഓഫ് അക്കൌണ്ട് \(XBD\)),
				'other' => q(യൂറോപ്യൻ യൂണിറ്റ്സ് ഓഫ് അക്കൌണ്ട് \(XBD\)),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(കിഴക്കൻ കരീബിയൻ ഡോളർ),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(സ്പെഷ്യൽ ഡ്രോയിംഗ് റൈറ്റ്സ്),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(യൂറോപ്യൻ നാണയ യൂണിറ്റ്),
				'one' => q(യൂറോപ്യൻ നാണയ യൂണിറ്റ്),
				'other' => q(യൂറോപ്യൻ നാണയ യൂണിറ്റ്സ്),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(ഫ്രെഞ്ച് ഗോൾഡ് ഫ്രാങ്ക്),
				'one' => q(ഫ്രെഞ്ച് ഗോൾഡ് ഫ്രാങ്ക്),
				'other' => q(ഫ്രെഞ്ച് ഗോൾഡ് ഫ്രാങ്ക്സ്),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(ഫ്രെഞ്ച് UIC-ഫ്രാങ്ക്),
				'one' => q(ഫ്രെഞ്ച് UIC-ഫ്രാങ്ക്),
				'other' => q(ഫ്രെഞ്ച് UIC-ഫ്രാങ്ക്സ്),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(പശ്ചിമ ആഫ്രിക്കൻ [CFA] ഫ്രാങ്ക്),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(പലാഡിയം),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(CFP ഫ്രാങ്ക്),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(പ്ലാറ്റിനം),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(RINET ഫണ്ട്സ്),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(ടെസ്റ്റിംഗിനുള്ള കറൻസി കോഡ്),
				'one' => q(റ്റെസ്റ്റിംഗ് കറൻസി കോഡ്),
				'other' => q(റ്റെസ്റ്റിംഗ് കറൻസി കോഡ്),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(അജ്ഞാത നാണയം),
				'one' => q(\(അജ്ഞാത നാണയം‌\)),
				'other' => q(\(അജ്ഞാത നാണയം\)),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(യമനി ദിനാർ),
				'one' => q(യമനി ദിനാർ),
				'other' => q(യമനി ദിനാർസ്),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(യെമനി റിയാൽ),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(യൂഗോസ്ലേവിയൻ ഹാർഡ് ദിനാർ),
				'one' => q(യൂഗോസ്ലേവിയൻ ഹാർഡ് ദിനാർ),
				'other' => q(യൂഗോസ്ലേവിയൻ ഹാർഡ് ദിനാർസ്),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(യൂഗോസ്ലേവിയൻ നോവി ദിനാർ),
				'one' => q(യൂഗോസ്ലേവിയൻ നോവി ദിനാർ),
				'other' => q(യൂഗോസ്ലേവിയൻ നോവി ദിനാർസ്),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(യൂഗോസ്ലേവിയൻ കൺവേർട്ടിബിൾ ദിനാർ),
				'one' => q(യൂഗോസ്ലേവിയൻ കൺവേർട്ടിബിൾ ദിനാർ),
				'other' => q(യൂഗോസ്ലേവിയൻ കൺവേർട്ടിബിൾ ദിനാർസ്),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(ദക്ഷിണാഫ്രിക്കൻ റാൻഡ് \(ഫിനാൻഷ്യൽ\)),
				'one' => q(ദക്ഷിണാഫ്രിക്കൻ റാൻഡ് \(ഫിനാൻഷ്യൽ\)),
				'other' => q(ദക്ഷിണാഫ്രിക്കൻ റാൻഡ്സ് \(ഫിനാൻഷ്യൽ\)),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(ദക്ഷിണാഫ്രിക്കൻ റാൻഡ്),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(സാംബിയൻ ക്വാച \(1968–2012\)),
				'one' => q(സാംബിയൻ ക്വാച \(1968–2012\)),
				'other' => q(സാംബിയൻ ക്വാചാസ് \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(സാംബിയൻ ക്വാച്ച),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(സൈറിയൻ ന്യൂ സൈർ),
				'one' => q(സൈറിയൻ ന്യൂ സൈർ),
				'other' => q(സൈറിയൻ ന്യൂ സൈർസ്),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(സൈറിയൻ സൈർ),
				'one' => q(സൈറിയൻ സൈർ),
				'other' => q(സൈറിയൻ സൈർസ്),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(സിംബാബ്‌വെ ഡോളർ),
				'one' => q(സിംബാബ്‌വെ ഡോളർ),
				'other' => q(സിംബാബ്‌വെ ഡോളേഴ്സ്),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					wide => {
						nonleap => [
							'ടൗട്ട്',
							'ബാബ',
							'ഹാറ്റർ',
							'കിയാക്ക്',
							'ടോബ',
							'ആംഷിർ',
							'ബാരംഹാത്ത്',
							'ബാരമൗഡ',
							'ബാഷൻസ്',
							'പവോണ',
							'ഈപെപ്',
							'മെസ്ര',
							'നസീ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ടൗ.',
							'ബാ.',
							'ഹാ.',
							'കി.',
							'ടോ.',
							'ആം.',
							'ബാ.',
							'ബാ.',
							'ബാ.',
							'പ.',
							'ഈ.',
							'മെ.',
							'ന.'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'മെസ്‌കെരെം',
							'ടെക്കെംറ്റ്',
							'ഹേദർ',
							'തഹ്‌സാസ്',
							'ടെർ',
							'യെക്കാറ്റിറ്റ്',
							'മെഗാബിറ്റ്',
							'മിയാസിയ',
							'ഗെൻബോട്ട്',
							'സെനെ',
							'ഹാംലെ',
							'നെഹാസെ',
							'പാഗുമെൻ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'മെ.',
							'ടെ.',
							'ഹേ.',
							'ത.',
							'ടെ.',
							'യെ.',
							'മെ.',
							'മി.',
							'ഗെ.',
							'സെ.',
							'ഹാം',
							'നെ.',
							'പാ.'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ജനു',
							'ഫെബ്രു',
							'മാർ',
							'ഏപ്രി',
							'മേയ്',
							'ജൂൺ',
							'ജൂലൈ',
							'ഓഗ',
							'സെപ്റ്റം',
							'ഒക്ടോ',
							'നവം',
							'ഡിസം'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ജനുവരി',
							'ഫെബ്രുവരി',
							'മാർച്ച്',
							'ഏപ്രിൽ',
							'മേയ്',
							'ജൂൺ',
							'ജൂലൈ',
							'ഓഗസ്റ്റ്',
							'സെപ്റ്റംബർ',
							'ഒക്‌ടോബർ',
							'നവംബർ',
							'ഡിസംബർ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ജ',
							'ഫെ',
							'മാ',
							'ഏ',
							'മെ',
							'ജൂൺ',
							'ജൂ',
							'ഓ',
							'സെ',
							'ഒ',
							'ന',
							'ഡി'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'തിഷ്റി',
							'ഹെഷ്‌വൻ',
							'കിസ്‌ലെവ്',
							'ടിവെറ്റ്',
							'സീബാറ്റ്',
							'അദാർ I',
							'അദാർ',
							'നിസാൻ',
							'ഇയാർ',
							'സിവാൻ',
							'താമൂസ്',
							'അബ്',
							'ഏലുൾ'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'തി.',
							'ഹെ.',
							'കി.',
							'ടി.',
							'സീ.',
							'അ I',
							'അ.',
							'നി.',
							'ഇ.',
							'സി.',
							'താ.',
							'അ.',
							'ഏ.'
						],
						leap => [
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							undef(),
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ചൈത്രം',
							'വൈശാഖം',
							'ജ്യേഷ്ഠം',
							'ആഷാഢം',
							'ശ്രാവണം',
							'ഭാദ്രം',
							'ആശ്വിനം',
							'കാർത്തികം',
							'മാർഗശീർഷം',
							'പൗഷം',
							'മാഘം',
							'ഫൽഗുനം'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ചൈത്രം',
							'വൈശാഖം',
							'ജ്യേഷ്ഠം',
							'ആഷാഢം',
							'ശ്രാവണം',
							'ഭാദ്രം',
							'ആശ്വിനം',
							'കാർത്തികം',
							'മാർഗശീർഷം',
							'പൗഷം',
							'മാഘം',
							'ഫാൽഗുനം'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ചൈ',
							'വൈ',
							'ജ്യേ',
							'ആ',
							'ശ്രാ',
							'ഭാ',
							'ആ',
							'കാ',
							'മാ',
							'പൗ',
							'മാ',
							'ഫ'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'മുഹ.',
							'സഫ.',
							'റബീഹുൽ അവ്വ.',
							'റബീഹുൽ ആഖി.',
							'ജമാദുൽ അവ്വ.',
							'ജമാദുൽ ആഖി.',
							'റജ.',
							'ശഹബാ.',
							'റമദാ.',
							'ശവ്വാ.',
							'ദുൽ ഖഹ.',
							'ദുൽ ഹി.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'മുഹറം',
							'സഫർ',
							'റബീഹുൽ അവ്വൽ',
							'റബീഹുൽ ആഖിർ',
							'ജമാദുൽ അവ്വൽ',
							'ജമാദുൽ ആഖിർ',
							'റജബ്',
							'ശഹബാൻ',
							'റമളാൻ',
							'ശവ്വാൽ',
							'ദുൽ ഖഹദ്',
							'ദുൽ ഹിജ്ജ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'മു',
							'സ',
							'റ',
							'റ',
							'ജ',
							'ജ',
							'റ',
							'ശ',
							'റ',
							'ശ',
							'ദു',
							'ദു'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'മുഹറം',
							'സഫർ',
							'റബീഹുൽ അവ്വൽ',
							'റബീഹുൽ ആഖിർ',
							'ജമാദുൽ അവ്വൽ',
							'ജമാദുൽ ആഖിർ',
							'റജബ്',
							'ശഹബാൻ',
							'റമദാൻ',
							'ശവ്വാൽ',
							'ദുൽ ഖഹദ്',
							'ദുൽ ഹിജ്ജ'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'ഫർവാർദിൻ',
							'ഓർഡിബെഹെഷ്‌റ്റ്',
							'ഖോർദാദ്',
							'ടിർ',
							'മോർദാദ്',
							'ഷഹ്‌രിവാർ',
							'മെഹർ',
							'അബാൻ',
							'അസർ',
							'ഡെയ്',
							'ബഹ്‌മാൻ',
							'എസ്‌ഫാൻഡ്'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ഫ.',
							'ഓ.',
							'ഖോ',
							'ടി.',
							'മോ.',
							'ഷ.',
							'മെ.',
							'അ.',
							'അ.',
							'ഡെ.',
							'ബ.',
							'എ.'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'തിങ്കൾ',
						tue => 'ചൊവ്വ',
						wed => 'ബുധൻ',
						thu => 'വ്യാഴം',
						fri => 'വെള്ളി',
						sat => 'ശനി',
						sun => 'ഞായർ'
					},
					narrow => {
						mon => 'തി',
						tue => 'ചൊ',
						wed => 'ബു',
						thu => 'വ്യാ',
						fri => 'വെ',
						sat => 'ശ',
						sun => 'ഞ'
					},
					short => {
						mon => 'തി',
						tue => 'ചൊ',
						wed => 'ബു',
						thu => 'വ്യാ',
						fri => 'വെ',
						sat => 'ശ',
						sun => 'ഞാ'
					},
					wide => {
						mon => 'തിങ്കളാഴ്‌ച',
						tue => 'ചൊവ്വാഴ്ച',
						wed => 'ബുധനാഴ്‌ച',
						thu => 'വ്യാഴാഴ്‌ച',
						fri => 'വെള്ളിയാഴ്‌ച',
						sat => 'ശനിയാഴ്‌ച',
						sun => 'ഞായറാഴ്‌ച'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'തി',
						tue => 'ചൊ',
						wed => 'ബു',
						thu => 'വ്യാ',
						fri => 'വെ',
						sat => 'ശ',
						sun => 'ഞാ'
					},
					wide => {
						mon => 'തിങ്കളാഴ്‌ച',
						tue => 'ചൊവ്വാഴ്‌ച',
						wed => 'ബുധനാഴ്‌ച',
						thu => 'വ്യാഴാഴ്‌ച',
						fri => 'വെള്ളിയാഴ്‌ച',
						sat => 'ശനിയാഴ്‌ച',
						sun => 'ഞായറാഴ്‌ച'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					wide => {0 => 'ഒന്നാം പാദം',
						1 => 'രണ്ടാം പാദം',
						2 => 'മൂന്നാം പാദം',
						3 => 'നാലാം പാദം'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1400;
					return 'afternoon2' if $time >= 1400
						&& $time < 1500;
					return 'evening1' if $time >= 1500
						&& $time < 1800;
					return 'evening2' if $time >= 1800
						&& $time < 1900;
					return 'morning1' if $time >= 300
						&& $time < 600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 1900;
					return 'night1' if $time < 300;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{ഉച്ചയ്ക്ക്},
					'afternoon2' => q{ഉച്ചതിരിഞ്ഞ്},
					'evening1' => q{വൈകുന്നേരം},
					'evening2' => q{സന്ധ്യ},
					'midnight' => q{അർദ്ധരാത്രി},
					'morning1' => q{പുലർച്ചെ},
					'morning2' => q{രാവിലെ},
					'night1' => q{രാത്രി},
					'noon' => q{ഉച്ച},
				},
				'narrow' => {
					'afternoon1' => q{ഉച്ചയ്ക്ക്},
					'afternoon2' => q{ഉച്ചതിരിഞ്ഞ്},
					'evening1' => q{വൈകുന്നേരം},
					'evening2' => q{സന്ധ്യ},
					'midnight' => q{അ},
					'morning1' => q{പുലർച്ചെ},
					'morning2' => q{രാവിലെ},
					'night1' => q{രാത്രി},
					'noon' => q{ഉച്ച},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
			abbreviated => {
				'0' => 'കാലഘട്ടം0',
				'1' => 'കാലഘട്ടം1'
			},
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'കാലഘട്ടം0',
				'1' => 'കാലഘട്ടം1'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ക്രി.മു.',
				'1' => 'എഡി'
			},
			wide => {
				'0' => 'ക്രിസ്‌തുവിന് മുമ്പ്',
				'1' => 'ആന്നോ ഡൊമിനി'
			},
		},
		'hebrew' => {
		},
		'indian' => {
			abbreviated => {
				'0' => 'ശക'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'ഹിജറ'
			},
		},
		'persian' => {
		},
		'roc' => {
			abbreviated => {
				'0' => 'R.O.C-യ്‌ക്ക് മു.',
				'1' => 'മിംഗ്വോ'
			},
			wide => {
				'0' => 'R.O.C-യ്‌ക്ക് മുമ്പ്'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{G y, MMMM d, EEEE},
			'long' => q{G y, MMMM d},
			'medium' => q{G y, MMM d},
			'short' => q{GGGGG y-MM-dd},
		},
		'gregorian' => {
			'full' => q{y, MMMM d, EEEE},
			'long' => q{y, MMMM d},
			'medium' => q{y, MMM d},
			'short' => q{d/M/yy},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E, B h:mm},
			EBhms => q{E, B h:mm:ss},
			MEd => q{M/d, E},
			MMMMEd => q{MMMM d, E},
			MMdd => q{dd-MM},
			yyyyMEd => q{G d/M/y, E},
			yyyyMM => q{MM-y G},
			yyyyMd => q{G d/M/y},
		},
		'gregorian' => {
			Bh => q{B h},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E, B h:mm},
			EBhms => q{E, B h:mm:ss},
			GyMd => q{M/d/y GGGGG},
			MEd => q{d/M, E},
			MMMMEd => q{MMMM d, E},
			MMMMW => q{MMMM - ആഴ്ച W},
			MMdd => q{dd/MM},
			Md => q{d/M},
			yMEd => q{d-M-y, E},
			yMM => q{y-MM},
			yMd => q{d/M/y},
			yw => q{Y-ലെ ആഴ്ച w},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{M – M},
			},
			MEd => {
				M => q{d/M, E – d/M, E},
				d => q{d/M, E – d/M, E},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMM => {
				M => q{MMMM – MMMM},
			},
			MMMd => {
				d => q{MMM d – d},
			},
			Md => {
				M => q{M/d – M/d},
				d => q{M/d – M/d},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMMMEd => {
				d => q{G y, MMM d, E – d, E},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
		'gregorian' => {
			Bh => {
				B => q{B h – B h},
			},
			Bhm => {
				B => q{B h:mm – B h:mm},
				h => q{B h:mm – h:mm},
				m => q{B h:mm – h:mm},
			},
			H => {
				H => q{HH – HH},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm v},
				m => q{HH:mm – HH:mm v},
			},
			Hv => {
				H => q{HH – HH v},
			},
			MEd => {
				M => q{d/M, E – d/M, E},
				d => q{d/M, E – d/M, E},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMM => {
				M => q{MMMM – MMMM},
			},
			MMMd => {
				d => q{MMM d – d},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} - {1}',
			h => {
				h => q{h – h a},
			},
			hm => {
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				h => q{h – h a v},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{d/M/y, E – d/M/y, E},
				d => q{d/M/y, E – d/M/y, E},
				y => q{d/M/y, E – d/M/y, E},
			},
			yMMM => {
				M => q{y MMM – MMM},
			},
			yMMMd => {
				d => q{y MMM d – d},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		gmtFormat => q(ജിഎംടി {0}),
		gmtZeroFormat => q(ജിഎംടി),
		regionFormat => q({0} സമയം),
		regionFormat => q({0} ഡേലൈറ്റ് സമയം),
		regionFormat => q({0} സ്റ്റാൻഡേർഡ് സമയം),
		'Acre' => {
			long => {
				'daylight' => q#എയ്ക്കർ വേനൽക്കാല സമയം#,
				'generic' => q#എയ്ക്കർ സമയം#,
				'standard' => q#എയ്ക്കർ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#അഫ്‌ഗാനിസ്ഥാൻ സമയം#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#അബിദ്‌ജാൻ‌#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ആക്ര#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#അഡിസ് അബാബ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#അൾജിയേഴ്‌സ്#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#അസ്‍മാര#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ബമാകോ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ബംഗുയി#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ബഞ്ചുൽ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ബിസ്സാവു#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ബ്ലാണ്ടെയർ‌#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ബ്രാസവിൽ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ബുജും‌ബുര#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#കെയ്‌റോ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#കാസബ്ലാങ്ക#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ക്യൂട്ട#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#കൊണാക്രി#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ഡാക്കർ‌#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ദാർ എസ് സലാം#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ദിജിബൗട്ടി#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ഡൗല#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#എൽ‌ ഐയുൻ‌#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ഫ്രീടൗൺ#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ഗാബറോൺ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ഹരാരെ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ജോഹന്നാസ്ബർ‌ഗ്#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ജുബ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#കമ്പാല#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ഖാർ‌തൌം#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#കിഗാലി#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#കിൻഷാസ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ലാഗോസ്#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ലിബ്രെവില്ല#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ലോം#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ലുവാൻഡ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ലൂബുംബാഷി#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ലുസാക#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#മലാബോ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#മാപ്യുട്ടോ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#മസേറു#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#മബാബെയ്‌ൻ‌#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#മൊഗാദിഷു#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#മൺ‌റോവിയ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#നയ്‌റോബി#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ജമെന#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#നിയാമി#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#നൗവാക്‌ഷോട്ട്#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ഔഗാദൗഗൗ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#പോർ‌ട്ടോ-നോവോ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#സാവോ ടോം‌#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ട്രിപൊളി#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ട്യൂണിസ്#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#വിൻഡ്‌ഹോക്#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#മധ്യ ആഫ്രിക്ക സമയം#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#കിഴക്കൻ ആഫ്രിക്ക സമയം#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#ദക്ഷിണാഫ്രിക്ക സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#പടിഞ്ഞാറൻ ആഫ്രിക്ക ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#പടിഞ്ഞാറൻ ആഫ്രിക്ക സമയം#,
				'standard' => q#പടിഞ്ഞാറൻ ആഫ്രിക്ക സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#അലാസ്‌ക ഡേലൈറ്റ് സമയം#,
				'generic' => q#അലാസ്‌ക സമയം#,
				'standard' => q#അലാസ്ക സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#അൽമതി വേനൽക്കാല സമയം#,
				'generic' => q#അൽമതി സമയം#,
				'standard' => q#അൽമതി സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ആമസോൺ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ആമസോൺ സമയം#,
				'standard' => q#ആമസോൺ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#അഡാക്#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ആങ്കറേജ്#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ആൻഗ്വില്ല#,
		},
		'America/Antigua' => {
			exemplarCity => q#ആൻറിഗ്വ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#അറഗ്വൈന#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ലാ റിയോജ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#റിയോ ഗ്യാലഗോസ്#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#സാൽട്ട#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#സാൻ ജുവാൻ#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#സാൻ ലൂയിസ്#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#റ്റുകുമാൻ#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ഉഷിയ#,
		},
		'America/Aruba' => {
			exemplarCity => q#അറൂബ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#അസൻ‌ഷ്യൻ‌#,
		},
		'America/Bahia' => {
			exemplarCity => q#ബഹിയ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ബഹിയ ബൻഡാരസ്#,
		},
		'America/Barbados' => {
			exemplarCity => q#ബാർബഡോസ്#,
		},
		'America/Belem' => {
			exemplarCity => q#ബെലം#,
		},
		'America/Belize' => {
			exemplarCity => q#ബെലീസ്#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ബ്ലാങ്ക് സാബ്ലോൺ#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ബോവ വിസ്റ്റ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ബൊഗോട്ട#,
		},
		'America/Boise' => {
			exemplarCity => q#ബൊയ്സി#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ബ്യൂണസ് ഐറിസ്#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#കേംബ്രിഡ്‌ജ് ബേ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ക്യാമ്പോ ഗ്രാൻഡെ#,
		},
		'America/Cancun' => {
			exemplarCity => q#കാൻകൂൺ#,
		},
		'America/Caracas' => {
			exemplarCity => q#കരാക്കസ്#,
		},
		'America/Catamarca' => {
			exemplarCity => q#‍ക്യാറ്റമാർക്ക#,
		},
		'America/Cayenne' => {
			exemplarCity => q#കയീൻ‌#,
		},
		'America/Cayman' => {
			exemplarCity => q#കേമാൻ#,
		},
		'America/Chicago' => {
			exemplarCity => q#ചിക്കാഗോ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ചിഹ്വാഹ#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#സിയുഡാഡ് ഹുവാരസ്#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ഏറ്റികോക്കൺ#,
		},
		'America/Cordoba' => {
			exemplarCity => q#കോർഡോബ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#കോസ്റ്റ റിക്ക#,
		},
		'America/Creston' => {
			exemplarCity => q#ക്രെസ്റ്റൺ#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#കുയ്‌ബ#,
		},
		'America/Curacao' => {
			exemplarCity => q#കുറാക്കാവോ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ഡാൻമാർക്ക്ഷാവ്ൻ#,
		},
		'America/Dawson' => {
			exemplarCity => q#ഡോവ്സൺ#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ഡോവ്സൺ ക്രീക്ക്#,
		},
		'America/Denver' => {
			exemplarCity => q#ഡെൻ‌വർ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ഡെട്രോയിറ്റ്#,
		},
		'America/Dominica' => {
			exemplarCity => q#ഡൊമിനിക്ക#,
		},
		'America/Edmonton' => {
			exemplarCity => q#എഡ്മോൺടൺ#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#യെറുനീപ്പെ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#എൽ സാൽ‌വദോർ#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ഫോർട്ട് നെൽസൺ#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ഫോർട്ടലീസ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ഗ്ലെയ്സ് ബേ#,
		},
		'America/Godthab' => {
			exemplarCity => q#നൂക്ക്#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ഗൂസ് ബേ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ഗ്രാൻഡ് ടർക്ക്#,
		},
		'America/Grenada' => {
			exemplarCity => q#ഗ്രനേഡ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ഗ്വാഡലൂപ്പ്#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ഗ്വാട്ടിമാല#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ഗുവായക്വിൽ#,
		},
		'America/Guyana' => {
			exemplarCity => q#ഗയാന#,
		},
		'America/Halifax' => {
			exemplarCity => q#ഹാലിഫാക്സ്#,
		},
		'America/Havana' => {
			exemplarCity => q#ഹവാന#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ഹെർമോസില്ലോ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#നോക്സ്, ഇൻഡ്യാന#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#മരെങ്കോ, ഇൻഡ്യാന#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#പീറ്റേഴ്സ്ബർഗ്, ഇൻഡ്യാന#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#റ്റെൽ സിറ്റി, ഇൻഡ്യാന#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#വിവെയ്, ഇൻഡ്യാന#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#വിൻസെൻസ്, ഇൻഡ്യാന#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#വിനാമാക്, ഇൻഡ്യാന#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ഇൻഡ്യാനാപോലീസ്#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ഇനുവിക്#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ഇഖാലിത്#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ജമൈക്ക#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ജുജുയ്#,
		},
		'America/Juneau' => {
			exemplarCity => q#ജൂനോ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#മോണ്ടിസെല്ലോ, കെന്റക്കി#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#കാർലൻഡിജെക്ക്#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ലാ പാസ്#,
		},
		'America/Lima' => {
			exemplarCity => q#ലിമ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ലോസ് എയ്ഞ്ചലസ്#,
		},
		'America/Louisville' => {
			exemplarCity => q#ലൂയിസ്‌വില്ലെ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ലോവർ പ്രിൻസസ് ക്വാർട്ടർ#,
		},
		'America/Maceio' => {
			exemplarCity => q#മാസിയോ#,
		},
		'America/Managua' => {
			exemplarCity => q#മനാഗ്വ#,
		},
		'America/Manaus' => {
			exemplarCity => q#മനൗസ്#,
		},
		'America/Marigot' => {
			exemplarCity => q#മാരിഗോ#,
		},
		'America/Martinique' => {
			exemplarCity => q#മാർട്ടിനിക്#,
		},
		'America/Matamoros' => {
			exemplarCity => q#മറ്റാമൊറോസ്#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#മസറ്റ്‌ലാൻ#,
		},
		'America/Mendoza' => {
			exemplarCity => q#മെൻഡോസ#,
		},
		'America/Menominee' => {
			exemplarCity => q#മെനോമിനീ#,
		},
		'America/Merida' => {
			exemplarCity => q#മെരിഡ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#മെഡ്‌ലകട്‌ലെ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#മെക്സിക്കോ സിറ്റി#,
		},
		'America/Miquelon' => {
			exemplarCity => q#മിക്വലൻ#,
		},
		'America/Moncton' => {
			exemplarCity => q#മോംഗ്‌ടൻ#,
		},
		'America/Monterrey' => {
			exemplarCity => q#മോണ്ടെറി#,
		},
		'America/Montevideo' => {
			exemplarCity => q#മൊണ്ടെ‌വീഡിയോ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#മൊണ്ടെസരത്ത്#,
		},
		'America/Nassau' => {
			exemplarCity => q#നാസൗ#,
		},
		'America/New_York' => {
			exemplarCity => q#ന്യൂയോർക്ക്#,
		},
		'America/Nome' => {
			exemplarCity => q#നോം#,
		},
		'America/Noronha' => {
			exemplarCity => q#നൊറോന#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ബ്യൂല, വടക്കൻ ഡെക്കോട്ട#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#സെന്റർ, വടക്കൻ ഡെക്കോട്ട#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ന്യൂ സെയ്‌ലം, വടക്കൻ ഡെക്കോട്ട#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ഒജിൻഗ#,
		},
		'America/Panama' => {
			exemplarCity => q#പനാമ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#പരാമാരിബോ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ഫീനിക്സ്#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#പോർട്ടോപ്രിൻസ്#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#പോർ‌ട്ട് ഓഫ് സ്‌പെയിൻ‌#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#പോർട്ടോ വെല്ലോ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#പ്യൂർട്ടോ റിക്കോ#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#പുന്റ അരീനസ്#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#റാങ്കിൻ ഇൻലെറ്റ്#,
		},
		'America/Recife' => {
			exemplarCity => q#റെസീഫെ#,
		},
		'America/Regina' => {
			exemplarCity => q#റിജീന#,
		},
		'America/Resolute' => {
			exemplarCity => q#റെസല്യൂട്ട്#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#റിയോ ബ്രാങ്കോ#,
		},
		'America/Santarem' => {
			exemplarCity => q#സാന്ററെം#,
		},
		'America/Santiago' => {
			exemplarCity => q#സാന്റിയാഗോ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#സാന്തോ ഡോമിംഗോ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#സാവോപോളോ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ഇറ്റ്വാഖ്വാർടൂർമിറ്റ്#,
		},
		'America/Sitka' => {
			exemplarCity => q#സിറ്റ്‌കാ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#സെന്റ് ബർത്തലെമി#,
		},
		'America/St_Johns' => {
			exemplarCity => q#സെന്റ് ജോൺസ്#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#സെന്റ് കിറ്റ്സ്#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#സെന്റ് ലൂസിയ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#സെന്റ് തോമസ്#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#സെന്റ് വിൻസെന്റ്#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#സ്വിഫ്‌റ്റ് കറന്റ്#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ടെഗൂസിഗാൽപ#,
		},
		'America/Thule' => {
			exemplarCity => q#തൂളി#,
		},
		'America/Tijuana' => {
			exemplarCity => q#തിയുവാന#,
		},
		'America/Toronto' => {
			exemplarCity => q#ടൊറന്റോ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ടോർ‌ട്ടോള#,
		},
		'America/Vancouver' => {
			exemplarCity => q#വാൻ‌കൂവർ#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#വൈറ്റ്ഹോഴ്സ്#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#വിന്നിപെഗ്#,
		},
		'America/Yakutat' => {
			exemplarCity => q#യാകുറ്റാറ്റ്#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#വടക്കെ അമേരിക്കൻ സെൻട്രൽ ഡേലൈറ്റ് സമയം#,
				'generic' => q#വടക്കെ അമേരിക്കൻ സെൻട്രൽ സമയം#,
				'standard' => q#വടക്കെ അമേരിക്കൻ സെൻട്രൽ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#വടക്കെ അമേരിക്കൻ കിഴക്കൻ ഡേലൈറ്റ് സമയം#,
				'generic' => q#വടക്കെ അമേരിക്കൻ കിഴക്കൻ സമയം#,
				'standard' => q#വടക്കെ അമേരിക്കൻ കിഴക്കൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#വടക്കെ അമേരിക്കൻ മൗണ്ടൻ ഡേലൈറ്റ് സമയം#,
				'generic' => q#വടക്കെ അമേരിക്കൻ മൌണ്ടൻ സമയം#,
				'standard' => q#വടക്കെ അമേരിക്കൻ മൗണ്ടൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#വടക്കെ അമേരിക്കൻ പസഫിക് ഡേലൈറ്റ് സമയം#,
				'generic' => q#വടക്കെ അമേരിക്കൻ പസഫിക് സമയം#,
				'standard' => q#വടക്കെ അമേരിക്കൻ പസഫിക് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#അനാഡിർ വേനൽക്കാല സമയം#,
				'generic' => q#അനാഡിർ സമയം#,
				'standard' => q#അനാഡിർ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#കാസെ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ഡെയ്‌വിസ്#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ഡ്യൂമണ്ട് ഡി യുർവിൽ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#മക്വയറി#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#മാവ്സൺ#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#മാക്മർഡോ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#പാമർ#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#റൊതീറ#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#സ്യോവ#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ട്രോൾ#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#വോസ്റ്റോക്#,
		},
		'Apia' => {
			long => {
				'daylight' => q#അപിയ ഡേലൈറ്റ് സമയം#,
				'generic' => q#അപിയ സമയം#,
				'standard' => q#അപിയ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#അഖ്തൌ വേനൽക്കാല സമയം#,
				'generic' => q#അഖ്തൌ സമയം#,
				'standard' => q#അഖ്തൌ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#അഖ്തോബ് വേനൽക്കാല സമയം#,
				'generic' => q#അഖ്തോബ് സമയം#,
				'standard' => q#അഖ്തോബ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#അറേബ്യൻ ഡേലൈറ്റ് സമയം#,
				'generic' => q#അറേബ്യൻ സമയം#,
				'standard' => q#അറേബ്യൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ലംഗ്‍യെർബിൻ#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#അർജന്റീന ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#അർജന്റീന സമയം#,
				'standard' => q#അർജന്റീന സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#പടിഞ്ഞാറൻ അർജന്റീന ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#പടിഞ്ഞാറൻ അർജന്റീന സമയം#,
				'standard' => q#പടിഞ്ഞാറൻ അർജന്റീന സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#അർമേനിയ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#അർമേനിയ സമയം#,
				'standard' => q#അർമേനിയ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ഏദെൻ#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#അൽമാട്ടി#,
		},
		'Asia/Amman' => {
			exemplarCity => q#അമ്മാൻ‌#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#അനാഡിർ#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#അക്തൗ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#അഖ്‌തോബ്#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#ആഷ്‌ഗാബട്ട്#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#അറ്റിറോ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ബാഗ്‌ദാദ്#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ബഹ്റിൻ#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ബാക്കു#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ബാങ്കോക്ക്#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#ബർണോൽ#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ബെയ്‌റൂട്ട്#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ബിഷ്‌കേക്#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ബ്രൂണൈ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#കൊൽ‌ക്കത്ത#,
		},
		'Asia/Chita' => {
			exemplarCity => q#ചീറ്റ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ചൊയ്ബൽസൻ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#കൊളം‌ബോ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ദമാസ്കസ്#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ധാക്ക#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ദിലി#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ദുബായ്#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ദുഷൻ‌ബെ#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ഫാമഗുസ്‌റ്റ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ഗാസ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ഹെബ്‌റോൺ#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ഹോങ്കോംഗ്#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ഹോഡ്#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ഇർകസ്ക്#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ജക്കാർത്ത#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ജയപുര#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ജെറുസലേം#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#കാബൂൾ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#കാംചട്ക#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#കറാച്ചി#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#കാഠ്‌മണ്ഡു#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#കാൻഡിഗ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ക്രാസ്നോയാസ്ക്#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ക്വാലലം‌പൂർ‌‌#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#കുചിങ്#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#കുവൈത്ത്#,
		},
		'Asia/Macau' => {
			exemplarCity => q#മക്കാവു#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#മഗഡാൻ#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#മകസ്സർ#,
		},
		'Asia/Manila' => {
			exemplarCity => q#മനില#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#മസ്കറ്റ്#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#നിക്കോഷ്യ#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#നോവോകുസെൻസ്‌ക്#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#നൊവോസിബിർസ്ക്#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ഒംസ്ക്#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ഓറൽ#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ഫെനോം പെൻ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#പൊന്റിയാനക്#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#പ്യോംഗ്‌യാംഗ്#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ഖത്തർ#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#കോസ്റ്റനേ#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ഖിസിലോർഡ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#റങ്കൂൺ‌#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#റിയാദ്#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ഹോ ചി മിൻ സിറ്റി#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#സഖാലിൻ#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#സമർക്കന്ദ്#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#സോൾ#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ഷാങ്‌ഹായി#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#സിംഗപ്പൂർ#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#സ്രിഡ്‌നികോളിംസ്ക്#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#തായ്‌പെയ്#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#താഷ്‌ക്കന്റ്#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#തിബിലിസി#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ടെഹ്‌റാൻ‌#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#തിംഫു#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ടോക്കിയോ#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ടോംസ്ക്#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ഉലാൻബാത്തർ#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ഉറുംഖി#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#യുസ്-നേര#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#വെന്റിയാൻ#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#വ്ളാഡിവോസ്റ്റോക്#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#യാക്കറ്റ്സ്‌ക്#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#യാകാറ്റെറിൻബർഗ്#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#യേരവൻ‌#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#അറ്റ്‌ലാന്റിക് ഡേലൈറ്റ് സമയം#,
				'generic' => q#അറ്റ്‌ലാന്റിക് സമയം#,
				'standard' => q#അറ്റ്‌ലാന്റിക് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#അസോറസ്#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ബർമുഡ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ക്യാനറി#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#കേപ് വെർദെ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ഫെറോ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#മഡെയ്റ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#റേയ്‌ജാവിക്#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ദക്ഷിണ ജോർജിയ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#സെന്റ് ഹെലെന#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#സ്റ്റാൻ‌ലി#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#അഡിലെയ്‌ഡ്#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ബ്രിസ്‌ബെയിൻ#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ബ്രോക്കൺ ഹിൽ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ഡാർവിൻ#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#യൂക്ല#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ഹൊബാർട്ട്#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ലിൻഡെമാൻ#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ലോഡ് ഹോവ്#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#മെൽബൺ#,
		},
		'Australia/Perth' => {
			exemplarCity => q#പെർത്ത്#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#സിഡ്നി#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#ഓസ്ട്രേലിയൻ സെൻട്രൽ ഡേലൈറ്റ് സമയം#,
				'generic' => q#സെൻട്രൽ ഓസ്ട്രേലിയ സമയം#,
				'standard' => q#ഓസ്ട്രേലിയൻ സെൻട്രൽ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#ഓസ്ട്രേലിയൻ സെൻട്രൽ പടിഞ്ഞാറൻ ഡേലൈറ്റ് സമയം#,
				'generic' => q#ഓസ്ട്രേലിയൻ സെൻട്രൽ പടിഞ്ഞാറൻ സമയം#,
				'standard' => q#ഓസ്ട്രേലിയൻ സെൻട്രൽ പടിഞ്ഞാറൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#ഓസ്‌ട്രേലിയൻ കിഴക്കൻ ഡേലൈറ്റ് സമയം#,
				'generic' => q#കിഴക്കൻ ഓസ്‌ട്രേലിയ സമയം#,
				'standard' => q#ഓസ്‌ട്രേലിയൻ കിഴക്കൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#ഓസ്‌ട്രേലിയൻ പടിഞ്ഞാറൻ ഡേലൈറ്റ് സമയം#,
				'generic' => q#പടിഞ്ഞാറൻ ഓസ്‌ട്രേലിയ സമയം#,
				'standard' => q#ഓസ്‌ട്രേലിയൻ പടിഞ്ഞാറൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#അസർബൈജാൻ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#അസർബൈജാൻ സമയം#,
				'standard' => q#അസർബൈജാൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#അസോർസ് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#അസോർസ് സമയം#,
				'standard' => q#അസോർസ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#ബംഗ്ലാദേശ് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ബംഗ്ലാദേശ് സമയം#,
				'standard' => q#ബംഗ്ലാദേശ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ഭൂട്ടാൻ സമയം#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#ബൊളീവിയ സമയം#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ബ്രസീലിയ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ബ്രസീലിയ സമയം#,
				'standard' => q#ബ്രസീലിയ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ബ്രൂണൈ ദാറുസ്സലാം സമയം#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#കേപ് വെർദെ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#കേപ് വെർദെ സമയം#,
				'standard' => q#കേപ് വെർദെ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#ചമോറോ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#ചാത്തം ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ചാത്തം സമയം#,
				'standard' => q#ചാത്തം സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#ചിലി ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ചിലി സമയം#,
				'standard' => q#ചിലി സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#ചൈന ഡേലൈറ്റ് സമയം#,
				'generic' => q#ചൈന സമയം#,
				'standard' => q#ചൈന സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#ചോയിബൽസാൻ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ചോയി‍ബൽസാൻ സമയം#,
				'standard' => q#ചോയ്‌ബൽസാൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ക്രിസ്‌മസ് ദ്വീപ് സമയം#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#കൊക്കോസ് ദ്വീപുകൾ സമയം#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#കൊളംബിയ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#കൊളംബിയ സമയം#,
				'standard' => q#കൊളംബിയ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#കുക്ക് ദ്വീപുകൾ അർദ്ധ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#കുക്ക് ദ്വീപുകൾ സമയം#,
				'standard' => q#കുക്ക് ദ്വീപുകൾ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#ക്യൂബ ഡേലൈറ്റ് സമയം#,
				'generic' => q#ക്യൂബ സമയം#,
				'standard' => q#ക്യൂബ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ഡേവിസ് സമയം#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ഡുമോണ്ട് ഡി ഉർവില്ലെ സമയം#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#കിഴക്കൻ തിമോർ സമയം#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ഈസ്റ്റർ ദ്വീപ് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഈസ്റ്റർ ദ്വീപ് സമയം#,
				'standard' => q#ഈസ്റ്റർ ദ്വീപ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ഇക്വഡോർ സമയം#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#കോർഡിനേറ്റഡ് യൂണിവേഴ്‌സൽ സമയം#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#അജ്ഞാത നഗരം#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ആം‌സ്റ്റർ‌ഡാം#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#അണ്ടോറ#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#അസ്‌ട്രഖാൻ#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ഏതൻ‌സ്#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ബെൽഗ്രേഡ്#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ബെർ‌ലിൻ‌#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ബ്രാട്ടിസ്‍ലാവ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ബ്രസ്സൽ‌സ്#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ബുച്ചാറെസ്റ്റ്#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ബുഡാപെസ്റ്റ്#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ബുസിൻജൻ#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ചിസിനാവു#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#കോപ്പൻ‌ഹേഗൻ‌#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ഡബ്ലിൻ#,
			long => {
				'daylight' => q#ഐറിഷ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ജിബ്രാൾട്ടർ#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ഗേൺസേ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ഹെൽ‌സിങ്കി#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ഐൽ‌ ഓഫ് മാൻ‌#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ഇസ്താം‌ബുൾ‌#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ജേഴ്‌സി#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#കലിനിൻഗ്രാഡ്#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#കീവ്#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#കിറോ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ലിസ്‌ബൺ‌#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ലുബ്‍ലിയാന#,
		},
		'Europe/London' => {
			exemplarCity => q#ലണ്ടൻ‌#,
			long => {
				'daylight' => q#ബ്രിട്ടീഷ് ഗ്രീഷ്‌മകാല സമയം#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ലക്‌സംബർഗ്#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#മാഡ്രിഡ്#,
		},
		'Europe/Malta' => {
			exemplarCity => q#മാൾട്ട#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#മരിയാഹാമൻ#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#മിൻ‌സ്ക്#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#മൊണാക്കോ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#മോസ്കോ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ഓസ്ലോ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#പാരീസ്#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#പൊഡ്‍ഗൊറിസ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#പ്രാഗ്#,
		},
		'Europe/Riga' => {
			exemplarCity => q#റിഗ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#റോം#,
		},
		'Europe/Samara' => {
			exemplarCity => q#സമാറ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#സാൻ മാരിനോ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#സരയേവോ#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#സരാറ്റോവ്#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#സിംഫെറോപോൾ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#സ്കോപ്പിയെ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#സോഫിയ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#സ്റ്റോക്ക്ഹോം#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ടാലിൻ‌#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ടിരാനെ#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#ഉല്ല്യാനോവ്‌സ്‌ക്#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#വാദുസ്#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#വത്തിക്കാൻ#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#വിയന്ന#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#വിൽ‌നിയസ്#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#വോൾഗോഗ്രാഡ്#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#വാർസോ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#സാക്രെബ്#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#സൂറിച്ച്#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#സെൻട്രൽ യൂറോപ്യൻ ഗ്രീഷ്മകാല സമയം#,
				'generic' => q#സെൻട്രൽ യൂറോപ്യൻ സമയം#,
				'standard' => q#സെൻട്രൽ യൂറോപ്യൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#കിഴക്കൻ യൂറോപ്യൻ ഗ്രീഷ്മകാല സമയം#,
				'generic' => q#കിഴക്കൻ യൂറോപ്യൻ സമയം#,
				'standard' => q#കിഴക്കൻ യൂറോപ്യൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#കിഴക്കേയറ്റത്തെ യൂറോപ്യൻ സമയം#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#പടിഞ്ഞാറൻ യൂറോപ്യൻ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#പടിഞ്ഞാറൻ യൂറോപ്യൻ സമയം#,
				'standard' => q#പടിഞ്ഞാറൻ യൂറോപ്യൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#ഫാക്ക്‌ലാൻഡ് ദ്വീപുകൾ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഫാക്ക്‌ലാൻഡ് ദ്വീപുകൾ സമയം#,
				'standard' => q#ഫാക്ക്‌ലാൻഡ് ദ്വീപുകൾ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#ഫിജി ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഫിജി സമയം#,
				'standard' => q#ഫിജി സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#ഫ്രഞ്ച് ഗയാന സമയം#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#ഫ്രഞ്ച് സതേൺ, അന്റാർട്ടിക് സമയം#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ഗ്രീൻവിച്ച് മീൻ സമയം#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#ഗാലപ്പഗോസ് സമയം#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#ഗാമ്പിയർ സമയം#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#ജോർജ്ജിയ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ജോർജ്ജിയ സമയം#,
				'standard' => q#ജോർജ്ജിയ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#ഗിൽബേർട്ട് ദ്വീപുകൾ സമയം#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#കിഴക്കൻ ഗ്രീൻലാൻഡ് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#കിഴക്കൻ ഗ്രീൻലാൻഡ് സമയം#,
				'standard' => q#കിഴക്കൻ ഗ്രീൻലാൻഡ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#പടിഞ്ഞാറൻ ഗ്രീൻലാൻഡ് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#പടിഞ്ഞാറൻ ഗ്രീൻലാൻഡ് സമയം#,
				'standard' => q#പടിഞ്ഞാറൻ ഗ്രീൻലാൻഡ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#ഗ്വാം സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#ഗൾഫ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#ഗയാന സമയം#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ഹവായ്-അലൂഷ്യൻ ഡേലൈറ്റ് സമയം#,
				'generic' => q#ഹവായ്-അലൂഷ്യൻ സമയം#,
				'standard' => q#ഹവായ്-അലൂഷ്യൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#ഹോങ്കോങ്ങ് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഹോങ്കോങ്ങ് സമയം#,
				'standard' => q#ഹോങ്കോങ്ങ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#ഹോഡ് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഹോഡ് സമയം#,
				'standard' => q#ഹോഡ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ഇന്ത്യൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
			short => {
				'standard' => q#IST#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#അൻറാനനറിവോ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ചാഗോസ്#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ക്രിസ്തുമസ്#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#കോക്കോസ്#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#കൊമോറോ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#കെർഗുലെൻ#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#മാഹി#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#മാലിദ്വീപ്#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#മൗറീഷ്യസ്#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#മയോട്ടി#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#റീയൂണിയൻ#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ഇന്ത്യൻ മഹാസമുദ്ര സമയം#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ഇൻഡോചൈന സമയം#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#മധ്യ ഇന്തോനേഷ്യ സമയം#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#കിഴക്കൻ ഇന്തോനേഷ്യ സമയം#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#പടിഞ്ഞാറൻ ഇന്തോനേഷ്യ സമയം#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ഇറാൻ ഡേലൈറ്റ് സമയം#,
				'generic' => q#ഇറാൻ സമയം#,
				'standard' => q#ഇറാൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ഇർകസ്‌ക് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഇർകസ്ക് സമയം#,
				'standard' => q#ഇർകസ്ക് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ഇസ്രായേൽ ഡേലൈറ്റ് സമയം#,
				'generic' => q#ഇസ്രായേൽ സമയം#,
				'standard' => q#ഇസ്രായേൽ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#ജപ്പാൻ ഡേലൈറ്റ് സമയം#,
				'generic' => q#ജപ്പാൻ സമയം#,
				'standard' => q#ജപ്പാൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#പെട്രോപാവ്‌ലോസ്ക് കംചാസ്കി വേനൽക്കാല സമയം#,
				'generic' => q#പെട്രോപാവ്‌ലോസ്ക് കംചാസ്കി സമയം#,
				'standard' => q#പെട്രോപാവ്‌ലോസ്ക് കംചാസ്കി സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#കിഴക്കൻ കസാഖിസ്ഥാൻ സമയം#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#പടിഞ്ഞാറൻ കസാഖിസ്ഥാൻ സമയം#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#കൊറിയൻ ഡേലൈറ്റ് സമയം#,
				'generic' => q#കൊറിയൻ സമയം#,
				'standard' => q#കൊറിയൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#കൊസ്ര സമയം#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#ക്രാസ്‌നോയാർസ്‌ക് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ക്രാസ്‌നോയാർസ്‌ക് സമയം#,
				'standard' => q#ക്രാസ്‌നോയാർസ്‌ക് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#കിർഗിസ്ഥാൻ സമയം#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#ലങ്ക സമയം#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#ലൈൻ ദ്വീപുകൾ സമയം#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#ലോർഡ് ഹോവ് ഡേലൈറ്റ് സമയം#,
				'generic' => q#ലോർഡ് ഹോവ് സമയം#,
				'standard' => q#ലോർഡ് ഹോവ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#മകൌ വേനൽക്കാല സമയം#,
				'generic' => q#മകൌ സമയം#,
				'standard' => q#മകൌ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#മഗാദൻ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#മഗാദൻ സമയം#,
				'standard' => q#മഗാദൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#മലേഷ്യ സമയം#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#മാലിദ്വീപ് സമയം#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#മർക്കസസ് സമയം#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#മാർഷൽ ദ്വീപുകൾ സമയം#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#മൗറീഷ്യസ് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#മൗറീഷ്യസ് സമയം#,
				'standard' => q#മൗറീഷ്യസ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#മാസൺ സമയം#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#മെക്സിക്കൻ പസഫിക് ഡേലൈറ്റ് സമയം#,
				'generic' => q#മെക്സിക്കൻ പസഫിക് സമയം#,
				'standard' => q#മെക്‌സിക്കൻ പസഫിക് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#ഉലാൻബാത്തർ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഉലാൻബാത്തർ സമയം#,
				'standard' => q#ഉലാൻബാത്തർ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#മോസ്‌കോ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#മോസ്കോ സമയം#,
				'standard' => q#മോസ്കോ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#മ്യാൻമാർ സമയം#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#നൗറു സമയം#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#നേപ്പാൾ സമയം#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#ന്യൂ കാലിഡോണിയ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ന്യൂ കാലിഡോണിയ സമയം#,
				'standard' => q#ന്യൂ കാലിഡോണിയ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#ന്യൂസിലാൻഡ് ഡേലൈറ്റ് സമയം#,
				'generic' => q#ന്യൂസിലാൻഡ് സമയം#,
				'standard' => q#ന്യൂസിലാൻഡ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#ന്യൂഫൗണ്ട്‌ലാന്റ് ഡേലൈറ്റ് സമയം#,
				'generic' => q#ന്യൂഫൗണ്ട്‌ലാന്റ് സമയം#,
				'standard' => q#ന്യൂഫൗണ്ട്‌ലാന്റ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#ന്യൂയി സമയം#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#നോർ‌ഫോക്ക് ദ്വീപ് ഡേലൈറ്റ് സമയം#,
				'generic' => q#നോർ‌ഫോക്ക് ദ്വീപ് സമയം#,
				'standard' => q#നോർ‌ഫോക്ക് ദ്വീപ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ഫെർണാഡോ ഡി നൊറോൻഹ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഫെർണാഡോ ഡി നൊറോൻഹ സമയം#,
				'standard' => q#ഫെർണാഡോ ഡി നൊറോൻഹ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#നോർത്ത് മറിയാനാ ദ്വീപുകൾ സമയം#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#നോവോസിബിർസ്‌ക് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#നോവോസിബിർസ്‌ക് സമയം#,
				'standard' => q#നോവോസിബിർസ്ക് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ഓംസ്‌ക്ക് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഓംസ്‌ക്ക് സമയം#,
				'standard' => q#ഓംസ്‌ക്ക് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ആപിയ#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ഓക്ക്‌ലാന്റ്#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#ബോഗൺവില്ലെ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ചാത്തം#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ഈസ്റ്റർ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ഇഫാതെ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#എൻഡബറി#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ഫക്കാവോഫോ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ഫിജി#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ഫുണാഫുട്ടി#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ഗാലപ്പാഗോസ്#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ഗാമ്പിയർ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ഗ്വാഡൽകനാൽ#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ഗ്വാം#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ഹോണലൂലു#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#കാൻട്ടൻ#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#കിരിറ്റിമാറ്റി#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#കൊസ്രേ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ക്വാജലെയ്ൻ#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#മജൂറോ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#മാർക്യുസാസ്#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#മിഡ്‌വേ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#നൗറു#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#നിയു#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#നോർ‌ഫോക്ക്#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#നോമിയ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#പാഗോ പാഗോ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#പലാവു#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#പിറ്റ്കയിൻ‌#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#പോൺപെ#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#പോർട്ട് മോഴ്‌സ്ബൈ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#റാരോടോംഗ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#സെയ്‌പ്പാൻ‌#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#താഹിതി#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#തരാവ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ടോംഗാടാപു#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ചക്#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#വെയ്ക്#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#വാല്ലിസ്#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#പാക്കിസ്ഥാൻ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#പാക്കിസ്ഥാൻ സമയം#,
				'standard' => q#പാക്കിസ്ഥാൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#പലാവു സമയം#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#പാപ്പുവ ന്യൂ ഗിനിയ സമയം#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#പരാഗ്വേ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#പരാഗ്വേ സമയം#,
				'standard' => q#പരാഗ്വേ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#പെറു ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#പെറു സമയം#,
				'standard' => q#പെറു സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#ഫിലിപ്പൈൻ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഫിലിപ്പൈൻ സമയം#,
				'standard' => q#ഫിലിപ്പൈൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ഫിനിക്‌സ് ദ്വീപ് സമയം#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#സെന്റ് പിയറി ആൻഡ് മിക്വലൻ ഡേലൈറ്റ് സമയം#,
				'generic' => q#സെന്റ് പിയറി ആൻഡ് മിക്വലൻ സമയം#,
				'standard' => q#സെന്റ് പിയറി ആൻഡ് മിക്വലൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#പിറ്റ്കേൻ സമയം#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#പൊനാപ്പ് സമയം#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#പ്യോംഗ്‌യാംഗ് സമയം#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#ഖിസിലോർഡ വേനൽക്കാല സമയം#,
				'generic' => q#ഖിസിലോർഡ സമയം#,
				'standard' => q#ഖിസിലോർഡ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#റീയൂണിയൻ സമയം#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#റോഥെറ സമയം#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#സഖാലിൻ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#സഖാലിൻ സമയം#,
				'standard' => q#സഖാലിൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#സമാറ വേനൽക്കാല സമയം#,
				'generic' => q#സമാര സമയം#,
				'standard' => q#സമാറ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#സമോവാ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#സമോവ സമയം#,
				'standard' => q#സമോവ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#സീഷെൽസ് സമയം#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#സിംഗപ്പൂർ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#സോളമൻ ദ്വീപുകൾ സമയം#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#ദക്ഷിണ ജോർജ്ജിയൻ സമയം#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#സുരിനെയിം സമയം#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#സയോവ സമയം#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#താഹിതി സമയം#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#തായ്‌പെയ് ഡേലൈറ്റ് സമയം#,
				'generic' => q#തായ്‌പെയ് സമയം#,
				'standard' => q#തായ്‌പെയ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#താജിക്കിസ്ഥാൻ സമയം#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ടോക്കെലൂ സമയം#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ടോംഗ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ടോംഗ സമയം#,
				'standard' => q#ടോംഗ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#ചൂക്ക് സമയം#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#തുർക്ക്‌മെനിസ്ഥാൻ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#തുർക്ക്‌മെനിസ്ഥാൻ സമയം#,
				'standard' => q#തുർക്ക്‌മെനിസ്ഥാൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ടുവാലു സമയം#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ഉറുഗ്വേ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഉറുഗ്വേ സമയം#,
				'standard' => q#ഉറുഗ്വേ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ഉസ്‌ബെക്കിസ്ഥാൻ ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#ഉസ്‌ബെക്കിസ്ഥാൻ സമയം#,
				'standard' => q#ഉസ്‌ബെക്കിസ്ഥാൻ സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#വന്വാതു ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#വന്വാതു സമയം#,
				'standard' => q#വന്വാതു സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#വെനിസ്വേല സമയം#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#വ്ലാഡിവോസ്റ്റോക് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#വ്ലാഡിവോസ്റ്റോക് സമയം#,
				'standard' => q#വ്ലാഡിവോസ്റ്റോക് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#വോൾഗോഗ്രാഡ് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#വോൾഗോഗ്രാഡ് സമയം#,
				'standard' => q#വോൾഗോഗ്രാഡ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#വോസ്റ്റോക് സമയം#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#വേക്ക് ദ്വീപ് സമയം#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#വാലിസ് ആന്റ് ഫ്യൂച്യുന സമയം#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#യാകസ്‌ക്ക് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#യാകസ്‌ക്ക് സമയം#,
				'standard' => q#യാകസ്‌ക്ക് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#യെക്കാറ്റരിൻബർഗ് ഗ്രീഷ്‌മകാല സമയം#,
				'generic' => q#യെക്കാറ്റരിൻബർഗ് സമയം#,
				'standard' => q#യെക്കാറ്റരിൻബർഗ് സ്റ്റാൻഡേർഡ് സമയം#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#യൂക്കോൺ സമയം#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
