use strict;
use Test;

my $tests;

BEGIN {
    $tests = 42;
    plan tests => $tests;
}

use Sjis;

# [1] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END');
ABC
123
END
ok($_, '123DEFGHIJKLMNOPQRSTUVWXYZ', q{trans($_,'ABC\n123')});

# [2] 1 test
# transliteration
my $string = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($string,<<'END');
ABC
123
END
ok($string, '123DEFGHIJKLMNOPQRSTUVWXYZ', q{trans($string,'ABC\n123')});

# [3] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END');
ABCDEF
123
END
ok($_, '123333GHIJKLMNOPQRSTUVWXYZ', q{trans($_,'ABCDEF\n123')});

# [4] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END');
A-Z
N-ZA-M
END
ok($_, 'NOPQRSTUVWXYZABCDEFGHIJKLM', q{trans($_,'A-Z\nN-MA-Z')});

# [5] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END');
N-ZA-M
A-Z
END
ok($_, 'NOPQRSTUVWXYZABCDEFGHIJKLM', q{trans($_,'N-MA-Z\nA-Z')});

# [6] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END');
A-Z

END
ok($_, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', q{trans($_,'A-Z\n')});

# [7] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END');
A-Z
END
ok($_, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', q{trans($_,'A-Z')});

# [8] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END');

END
ok($_, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', q{trans($_,'\n')});

# [9] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END');
END
ok($_, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', q{trans($_,'')});

# [10] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END','d');
ABC

END
ok($_, 'DEFGHIJKLMNOPQRSTUVWXYZ', q{trans($_,'ABC\n','d')});

# [11] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END','d');
ABC
END
ok($_, 'DEFGHIJKLMNOPQRSTUVWXYZ', q{trans($_,'ABC','d')});

# [12] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END','c');
A-W
x
END
ok($_, 'ABCDEFGHIJKLMNOPQRSTUVWxxx', q{trans($_,'A-W\nx','c')});

# [13] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END','cd');
A-W

END
ok($_, 'ABCDEFGHIJKLMNOPQRSTUVW', q{trans($_,'A-W\n','cd')});

# [14] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END','s');
X-Z
x
END
ok($_, 'ABCDEFGHIJKLMNOPQRSTUVWx', q{trans($_,'X-Z\nx','s')});

# [15] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END','cs');
X-Z
x
END
ok($_, 'xXYZ', q{trans($_,'X-Z\nx','cs')});

# [16] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END','ds');
ABCDEF
111
END
ok($_, '1GHIJKLMNOPQRSTUVWXYZ', q{trans($_,'ABCDEF\n111','ds')});

# [17] 1 test
# transliteration
$_ = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
trans($_,<<'END','cds');
ABCDEF
1
END
ok($_, 'ABCDEF1', q{trans($_,'ABCDEF\n1','cds')});

# [18] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END');
ACE
123
END
ok($_, '123GIJLNPRTVXZ\^`ceg', q{trans($_,'ACE\n123')});

# [19] 1 test
# transliteration
$string = 'ACEGIJLNPRTVXZ\^`ceg';
trans($string,<<'END');
ACE
123
END
ok($string, '123GIJLNPRTVXZ\^`ceg', q{trans($string,'ACE\n123')});

# [20] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END');
ACEGIJ
123
END
ok($_, '123333LNPRTVXZ\^`ceg', q{trans($_,'ACEGIJ\n123')});

# [21] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END');
J-RT-\
T-\J-R
END
ok($_, 'ACEGITVXZ\JLNPR^`ceg', q{trans($_,'J-RT-\\nT-\J-R')});

# [22] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END');
T-\J-R
J-RT-\
END
ok($_, 'ACEGITVXZ\JLNPR^`ceg', q{trans($_,'T-\J-R\nJ-RT-\')});

# [23] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END');
A-g

END
ok($_, 'ACEGIJLNPRTVXZ\^`ceg', q{trans($_,'A-g\n')});

# [24] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END');
A-g
END
ok($_, 'ACEGIJLNPRTVXZ\^`ceg', q{trans($_,'A-g')});

# [25] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END');

END
ok($_, 'ACEGIJLNPRTVXZ\^`ceg', q{trans($_,'\n')});

# [26] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END');
END
ok($_, 'ACEGIJLNPRTVXZ\^`ceg', q{trans($_,'')});

# [27] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','d');
ACE

END
ok($_, 'GIJLNPRTVXZ\^`ceg', q{trans($_,'ACE\n','d')});

# [28] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','d');
ACE
END
ok($_, 'GIJLNPRTVXZ\^`ceg', q{trans($_,'ACE','d')});

# [29] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','c');
J-R
x
END
ok($_, 'xxxxxJLNPRxxxxxxxxxx', q{trans($_,'J-R\nx','c')});

# [30] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','cd');
J-R

END
ok($_, 'JLNPR', q{trans($_,J-R\n','cd')});

# [31] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','s');
^-g
x
END
ok($_, 'ACEGIJLNPRTVXZ\x', q{trans($_,'^-g\nx','s')});

# [32] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','cs');
^-g
x
END
ok($_, 'x^`ceg', q{trans($_,'^-g\nx','cs')});

# [33] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','ds');
ACEGIJLNPR
111
END
ok($_, '1TVXZ\^`ceg', q{trans($_,'ACEGIJLNPR\n111','ds')});

# [34] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','cds');
ACEGIJLNPR
1
END
ok($_, 'ACEGIJLNPR1', q{trans($_,'ACEGIJLNPR\n1','cds')});

# [35] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END');
ACE
PQR
END
ok($_, 'PQRGIJLNPRTVXZ\^`ceg', q{trans($_,'ACE\nPQR')});

# [36] 1 test
# transliteration
$string = 'ACEGIJLNPRTVXZ\^`ceg';
trans($string,<<'END');
ACE
PQR
END
ok($string, 'PQRGIJLNPRTVXZ\^`ceg', q{trans($string,'ACE\nPQR')});

# [37] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END');
ACEGIJ
PQR
END
ok($_, 'PQRRRRLNPRTVXZ\^`ceg', q{trans($_,'ACEGIJ\nPQR')});

# [38] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','c');
J-R

END
ok($_, 'JLNPR', q{trans($_,'J-R\n','c')});

# [39] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','s');
^-g

END
ok($_, 'ACEGIJLNPRTVXZ\', q{trans($_,'^-g\n','s')});

# [40] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','cs');
^-g

END
ok($_, '^`ceg', q{trans($_,'^-g\n','cs')});

# [41] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','ds');
ACEGIJLNPR
PPP
END
ok($_, 'PTVXZ\^`ceg', q{trans($_,'ACEGIJLNPR\nPPP','ds')});

# [42] 1 test
# transliteration
$_ = 'ACEGIJLNPRTVXZ\^`ceg';
trans($_,<<'END','cds');
ACEGIJLNPR
P
END
ok($_, 'ACEGIJLNPRP', q{trans($_,'ACEGIJLNPR\nP','cds')});

__END__
