/*
 * This file was generated automatically by xsubpp version 1.9508 from the
 * contents of SFColorRGBA.xs. Do not edit this file, edit SFColorRGBA.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "SFColorRGBA.xs"
#ifndef bool
#include <iostream.h>
#endif
extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "INLINE.h"
}
#ifdef bool
#undef bool
#include <iostream.h>
#endif


#define PI 3.141592653589793238462643383279502884197168
#define _max(a,b)     (a > b ? a : b)
#define _min(a,b)     (a < b ? a : b)
#define _minmax(v,a,b) _min(_max(v, a), b)

class SFColorRGBA {
	public:
		double r;
		double g;
		double b;
		double a;

	public:
		SFColorRGBA (const double r=0, const double g=0, const double b=0, const double a=0) { setValue(r,g,b,a); }

		inline const SFColorRGBA* copy () { return new SFColorRGBA(r,g,b,a); }
		
		inline void setValue (const double r, const double g, const double b, const double a) {
			this->r = _minmax(r, 0,1);
			this->g = _minmax(g, 0,1);
			this->b = _minmax(b, 0,1);
			this->a = _minmax(a, 0,1);
		}
		
		inline void getValue () {
			Inline_Stack_Vars;
			Inline_Stack_Reset;
				Inline_Stack_Push(sv_2mortal(newSVnv(r)));
				Inline_Stack_Push(sv_2mortal(newSVnv(g)));
				Inline_Stack_Push(sv_2mortal(newSVnv(b)));
				Inline_Stack_Push(sv_2mortal(newSVnv(a)));
			Inline_Stack_Done;
		}
		
		inline void setRed   (const double r) { this->r = _minmax(r, 0,1); }
		inline void setGreen (const double g) { this->g = _minmax(g, 0,1); }
		inline void setBlue  (const double b) { this->b = _minmax(b, 0,1); }
		inline void setAlpha (const double b) { this->a = _minmax(a, 0,1); }

		inline const double getRed   () { return r; }
		inline const double getGreen () { return g; }
		inline const double getBlue  () { return b; }
		inline const double getAlpha () { return a; }

		void setHSV (double h, double s, double v) {
			// H is given on [0, 2 * Pi]. S and V are given on [0, 1]. 
			// RGB are each returned on [0, 1]. 
		
			if ( s == 0 ) {
				// achromatic (grey)
				r = g = b = v;
				return;
			}
		
			h *= 180 / PI;
		
			h /= 60;                             // sector 0 to 5
			double i = floor( h );
			double f = h - i;							 // factorial part of h
			double p = v * ( 1 - s );
			double q = v * ( 1 - s * f );
			double t = v * ( 1 - s * ( 1 - f ) );
		
			if (i == 0) return setValue (v, t, p, a);
			if (i == 1) return setValue (q, v, p, a);
			if (i == 2) return setValue (p, v, t, a);
			if (i == 3) return setValue (p, q, v, a);
			if (i == 4) return setValue (t, p, v, a);
			return setValue (v, p, q, a);
		} 
		
		void getHSV () {
			double h, s, v;
		
			double min = _min( r, _min( g, b ) );
			double max = _max( r, _max( g, b ) );
			v = max;                                       // v
		
			double delta = max - min;
		
			if ( max != 0 && delta != 0 ) {
				s = delta / max;                            // s
			} else {
				// r = g = b = 0                            // s = 0, h is undefined
				s = 0;
				h = 0;
				Inline_Stack_Vars;
				Inline_Stack_Reset;
					Inline_Stack_Push(sv_2mortal(newSVnv(h)));
					Inline_Stack_Push(sv_2mortal(newSVnv(s)));
					Inline_Stack_Push(sv_2mortal(newSVnv(v)));
				Inline_Stack_Done;
				return;
			}
		
			if ( r == max ) {
				h = ( g - b ) / delta;                     // between yellow & magenta
			} else if ( g == max ) {
				h = 2 + ( b - r ) / delta;                 // between cyan & yellow
			} else {
				h = 4 + ( r - g ) / delta;                 // between magenta & cyan
			}
		
			h *= PI * 1/3;                                // radiants
			if( h < 0 ) {
				h += 2 * PI;
			}
		
			Inline_Stack_Vars;
			Inline_Stack_Reset;
				Inline_Stack_Push(sv_2mortal(newSVnv(h)));
				Inline_Stack_Push(sv_2mortal(newSVnv(s)));
				Inline_Stack_Push(sv_2mortal(newSVnv(v)));
			Inline_Stack_Done;
			return;
		}
		
		inline const SFColorRGBA* negate (SV* s=0) {
			return new SFColorRGBA(
				-r,
				-g,
				-b,
				a
			);
		}
		
		inline const SFColorRGBA* add (SFColorRGBA* v, SV* s=0) {
			return new SFColorRGBA(
				r + v->r,
				g + v->g,
				b + v->b,
				a
			);
		}
		
		inline const SFColorRGBA* subtract (SFColorRGBA* v, SV* s=0) {
			return new SFColorRGBA(
				r - v->r,
				g - v->g,
				b - v->b,
				a
			);
		}

		inline const SFColorRGBA* multiply (SFColorRGBA* v, SV* s=0) {
			return new SFColorRGBA(
				r * v->r,
				g * v->g,
				b * v->b,
				a
			);
		}

		inline const SFColorRGBA* lighten (const double v, SV* s=0) {
			return new SFColorRGBA(
				r * v,
				g * v,
				b * v,
				a
			);
		}
		
		inline const SFColorRGBA* divide (SFColorRGBA* v, SV* s=0) {
			return new SFColorRGBA(
				r / v->r,
				g / v->g,
				b / v->b,
				a
			);
		}

		inline const SFColorRGBA* darken (const double v, SV* s=0) {
			return new SFColorRGBA(
				r / v,
				g / v,
				b / v,
				a
			);
		}

};


#line 209 "SFColorRGBA.c"
XS(XS_main__SFColorRGBA_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_new)
{
    dXSARGS;
    if (items < 1)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::new(CLASS, ...)");
    {
#line 206 "SFColorRGBA.xs"
	double	r;
	double	g;
	double	b;
	double	a;
#line 222 "SFColorRGBA.c"
	char *	CLASS = (char *)SvPV_nolen(ST(0));
	SFColorRGBA *	RETVAL;
#line 211 "SFColorRGBA.xs"
switch(items-1) {
case 1:
	r = (double)SvNV(ST(1));
	RETVAL = new SFColorRGBA(r);
	break; /* case 1 */
case 2:
	r = (double)SvNV(ST(1));
	g = (double)SvNV(ST(2));
	RETVAL = new SFColorRGBA(r,g);
	break; /* case 2 */
case 3:
	r = (double)SvNV(ST(1));
	g = (double)SvNV(ST(2));
	b = (double)SvNV(ST(3));
	RETVAL = new SFColorRGBA(r,g,b);
	break; /* case 3 */
case 4:
	r = (double)SvNV(ST(1));
	g = (double)SvNV(ST(2));
	b = (double)SvNV(ST(3));
	a = (double)SvNV(ST(4));
	RETVAL = new SFColorRGBA(r,g,b,a);
	break; /* case 4 */
default:
	RETVAL = new SFColorRGBA();
} /* switch(items) */ 
#line 252 "SFColorRGBA.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColorRGBA", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_copy); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_copy)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::copy(THIS)");
    {
	SFColorRGBA *	THIS;
	SFColorRGBA *	RETVAL;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 243 "SFColorRGBA.xs"
	RETVAL = const_cast<SFColorRGBA *>(THIS->copy());
#line 280 "SFColorRGBA.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColorRGBA", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_setValue); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_setValue)
{
    dXSARGS;
    if (items != 5)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::setValue(THIS, r, g, b, a)");
    SP -= items;
    {
	double	r = (double)SvNV(ST(1));
	double	g = (double)SvNV(ST(2));
	double	b = (double)SvNV(ST(3));
	double	a = (double)SvNV(ST(4));
#line 254 "SFColorRGBA.xs"
	I32 *	__temp_markstack_ptr;
#line 303 "SFColorRGBA.c"
	SFColorRGBA *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 256 "SFColorRGBA.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->setValue(r,g,b,a);
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 323 "SFColorRGBA.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColorRGBA_getValue); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_getValue)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::getValue(THIS)");
    SP -= items;
    {
#line 269 "SFColorRGBA.xs"
	I32 *	__temp_markstack_ptr;
#line 339 "SFColorRGBA.c"
	SFColorRGBA *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 271 "SFColorRGBA.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->getValue();
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 359 "SFColorRGBA.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColorRGBA_setRed); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_setRed)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::setRed(THIS, r)");
    SP -= items;
    {
	double	r = (double)SvNV(ST(1));
#line 285 "SFColorRGBA.xs"
	I32 *	__temp_markstack_ptr;
#line 376 "SFColorRGBA.c"
	SFColorRGBA *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 287 "SFColorRGBA.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->setRed(r);
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 396 "SFColorRGBA.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColorRGBA_setGreen); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_setGreen)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::setGreen(THIS, g)");
    SP -= items;
    {
	double	g = (double)SvNV(ST(1));
#line 301 "SFColorRGBA.xs"
	I32 *	__temp_markstack_ptr;
#line 413 "SFColorRGBA.c"
	SFColorRGBA *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 303 "SFColorRGBA.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->setGreen(g);
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 433 "SFColorRGBA.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColorRGBA_setBlue); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_setBlue)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::setBlue(THIS, b)");
    SP -= items;
    {
	double	b = (double)SvNV(ST(1));
#line 317 "SFColorRGBA.xs"
	I32 *	__temp_markstack_ptr;
#line 450 "SFColorRGBA.c"
	SFColorRGBA *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 319 "SFColorRGBA.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->setBlue(b);
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 470 "SFColorRGBA.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColorRGBA_setAlpha); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_setAlpha)
{
    dXSARGS;
    if (items != 2)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::setAlpha(THIS, b)");
    SP -= items;
    {
	double	b = (double)SvNV(ST(1));
#line 333 "SFColorRGBA.xs"
	I32 *	__temp_markstack_ptr;
#line 487 "SFColorRGBA.c"
	SFColorRGBA *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 335 "SFColorRGBA.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->setAlpha(b);
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 507 "SFColorRGBA.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColorRGBA_getRed); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_getRed)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::getRed(THIS)");
    {
	SFColorRGBA *	THIS;
	double	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 348 "SFColorRGBA.xs"
	RETVAL = THIS->getRed();
#line 533 "SFColorRGBA.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_getGreen); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_getGreen)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::getGreen(THIS)");
    {
	SFColorRGBA *	THIS;
	double	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 355 "SFColorRGBA.xs"
	RETVAL = THIS->getGreen();
#line 559 "SFColorRGBA.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_getBlue); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_getBlue)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::getBlue(THIS)");
    {
	SFColorRGBA *	THIS;
	double	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 362 "SFColorRGBA.xs"
	RETVAL = THIS->getBlue();
#line 585 "SFColorRGBA.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_getAlpha); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_getAlpha)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::getAlpha(THIS)");
    {
	SFColorRGBA *	THIS;
	double	RETVAL;
	dXSTARG;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 369 "SFColorRGBA.xs"
	RETVAL = THIS->getAlpha();
#line 611 "SFColorRGBA.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_setHSV); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_setHSV)
{
    dXSARGS;
    if (items != 4)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::setHSV(THIS, h, s, v)");
    SP -= items;
    {
	double	h = (double)SvNV(ST(1));
	double	s = (double)SvNV(ST(2));
	double	v = (double)SvNV(ST(3));
#line 379 "SFColorRGBA.xs"
	I32 *	__temp_markstack_ptr;
#line 630 "SFColorRGBA.c"
	SFColorRGBA *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 381 "SFColorRGBA.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->setHSV(h,s,v);
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 650 "SFColorRGBA.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColorRGBA_getHSV); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_getHSV)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::getHSV(THIS)");
    SP -= items;
    {
#line 394 "SFColorRGBA.xs"
	I32 *	__temp_markstack_ptr;
#line 666 "SFColorRGBA.c"
	SFColorRGBA *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 396 "SFColorRGBA.xs"
	__temp_markstack_ptr = PL_markstack_ptr++;
	THIS->getHSV();
        if (PL_markstack_ptr != __temp_markstack_ptr) {
          /* truly void, because dXSARGS not invoked */
          PL_markstack_ptr = __temp_markstack_ptr;
          XSRETURN_EMPTY; /* return empty stack */
        }
        /* must have used dXSARGS; list context implied */
        return; /* assume stack size is correct */
#line 686 "SFColorRGBA.c"
	PUTBACK;
	return;
    }
}

XS(XS_main__SFColorRGBA_negate); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_negate)
{
    dXSARGS;
    if (items < 1)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::negate(THIS, ...)");
    {
#line 409 "SFColorRGBA.xs"
	SV *	s;
#line 701 "SFColorRGBA.c"
	SFColorRGBA *	THIS;
	SFColorRGBA *	RETVAL;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 411 "SFColorRGBA.xs"
switch(items-1) {
case 1:
	s = ST(1);
	RETVAL = const_cast<SFColorRGBA *>(THIS->negate(s));
	break; /* case 1 */
default:
	RETVAL = const_cast<SFColorRGBA *>(THIS->negate());
} /* switch(items) */ 
#line 721 "SFColorRGBA.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColorRGBA", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_add); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_add)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::add(THIS, v, ...)");
    {
	SFColorRGBA *	v;
#line 426 "SFColorRGBA.xs"
	SV *	s;
#line 740 "SFColorRGBA.c"
	SFColorRGBA *	THIS;
	SFColorRGBA *	RETVAL;

    if (sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG)) {
        v = (SFColorRGBA *)SvIV((SV*)SvRV( ST(1) ));
    }
    else {
        warn ( "SFColorRGBA::() -- v is not a blessed reference" );
        XSRETURN_UNDEF;
    };

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 428 "SFColorRGBA.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColorRGBA *>(THIS->add(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColorRGBA *>(THIS->add(v));
} /* switch(items) */ 
#line 768 "SFColorRGBA.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColorRGBA", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_subtract); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_subtract)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::subtract(THIS, v, ...)");
    {
	SFColorRGBA *	v;
#line 443 "SFColorRGBA.xs"
	SV *	s;
#line 787 "SFColorRGBA.c"
	SFColorRGBA *	THIS;
	SFColorRGBA *	RETVAL;

    if (sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG)) {
        v = (SFColorRGBA *)SvIV((SV*)SvRV( ST(1) ));
    }
    else {
        warn ( "SFColorRGBA::() -- v is not a blessed reference" );
        XSRETURN_UNDEF;
    };

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 445 "SFColorRGBA.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColorRGBA *>(THIS->subtract(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColorRGBA *>(THIS->subtract(v));
} /* switch(items) */ 
#line 815 "SFColorRGBA.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColorRGBA", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_multiply); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_multiply)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::multiply(THIS, v, ...)");
    {
	SFColorRGBA *	v;
#line 460 "SFColorRGBA.xs"
	SV *	s;
#line 834 "SFColorRGBA.c"
	SFColorRGBA *	THIS;
	SFColorRGBA *	RETVAL;

    if (sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG)) {
        v = (SFColorRGBA *)SvIV((SV*)SvRV( ST(1) ));
    }
    else {
        warn ( "SFColorRGBA::() -- v is not a blessed reference" );
        XSRETURN_UNDEF;
    };

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 462 "SFColorRGBA.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColorRGBA *>(THIS->multiply(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColorRGBA *>(THIS->multiply(v));
} /* switch(items) */ 
#line 862 "SFColorRGBA.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColorRGBA", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_lighten); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_lighten)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::lighten(THIS, v, ...)");
    {
	double	v = (double)SvNV(ST(1));
#line 477 "SFColorRGBA.xs"
	SV *	s;
#line 881 "SFColorRGBA.c"
	SFColorRGBA *	THIS;
	SFColorRGBA *	RETVAL;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 479 "SFColorRGBA.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColorRGBA *>(THIS->lighten(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColorRGBA *>(THIS->lighten(v));
} /* switch(items) */ 
#line 901 "SFColorRGBA.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColorRGBA", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_divide); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_divide)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::divide(THIS, v, ...)");
    {
	SFColorRGBA *	v;
#line 494 "SFColorRGBA.xs"
	SV *	s;
#line 920 "SFColorRGBA.c"
	SFColorRGBA *	THIS;
	SFColorRGBA *	RETVAL;

    if (sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG)) {
        v = (SFColorRGBA *)SvIV((SV*)SvRV( ST(1) ));
    }
    else {
        warn ( "SFColorRGBA::() -- v is not a blessed reference" );
        XSRETURN_UNDEF;
    };

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 496 "SFColorRGBA.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColorRGBA *>(THIS->divide(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColorRGBA *>(THIS->divide(v));
} /* switch(items) */ 
#line 948 "SFColorRGBA.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColorRGBA", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_darken); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_darken)
{
    dXSARGS;
    if (items < 2)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::darken(THIS, v, ...)");
    {
	double	v = (double)SvNV(ST(1));
#line 511 "SFColorRGBA.xs"
	SV *	s;
#line 967 "SFColorRGBA.c"
	SFColorRGBA *	THIS;
	SFColorRGBA *	RETVAL;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };
#line 513 "SFColorRGBA.xs"
switch(items-1) {
case 2:
	s = ST(2);
	RETVAL = const_cast<SFColorRGBA *>(THIS->darken(v,s));
	break; /* case 2 */
default:
	RETVAL = const_cast<SFColorRGBA *>(THIS->darken(v));
} /* switch(items) */ 
#line 987 "SFColorRGBA.c"
	ST(0) = sv_newmortal();
    sv_setref_pv( ST(0), "SFColorRGBA", (void*)RETVAL );


    }
    XSRETURN(1);
}

XS(XS_main__SFColorRGBA_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_main__SFColorRGBA_DESTROY)
{
    dXSARGS;
    if (items != 1)
	Perl_croak(aTHX_ "Usage: main::SFColorRGBA::DESTROY(THIS)");
    {
	SFColorRGBA *	THIS;

    if (sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG)) {
        THIS = (SFColorRGBA *)SvIV((SV*)SvRV( ST(0) ));
    }
    else {
        warn ( "SFColorRGBA::() -- THIS is not a blessed reference" );
        XSRETURN_UNDEF;
    };

	delete THIS;
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_SFColorRGBA); /* prototype to pass -Wmissing-prototypes */
XS(boot_SFColorRGBA)
{
    dXSARGS;
    char* file = __FILE__;

    XS_VERSION_BOOTCHECK ;

        newXS("main::SFColorRGBA::new", XS_main__SFColorRGBA_new, file);
        newXS("main::SFColorRGBA::copy", XS_main__SFColorRGBA_copy, file);
        newXS("main::SFColorRGBA::setValue", XS_main__SFColorRGBA_setValue, file);
        newXS("main::SFColorRGBA::getValue", XS_main__SFColorRGBA_getValue, file);
        newXS("main::SFColorRGBA::setRed", XS_main__SFColorRGBA_setRed, file);
        newXS("main::SFColorRGBA::setGreen", XS_main__SFColorRGBA_setGreen, file);
        newXS("main::SFColorRGBA::setBlue", XS_main__SFColorRGBA_setBlue, file);
        newXS("main::SFColorRGBA::setAlpha", XS_main__SFColorRGBA_setAlpha, file);
        newXS("main::SFColorRGBA::getRed", XS_main__SFColorRGBA_getRed, file);
        newXS("main::SFColorRGBA::getGreen", XS_main__SFColorRGBA_getGreen, file);
        newXS("main::SFColorRGBA::getBlue", XS_main__SFColorRGBA_getBlue, file);
        newXS("main::SFColorRGBA::getAlpha", XS_main__SFColorRGBA_getAlpha, file);
        newXS("main::SFColorRGBA::setHSV", XS_main__SFColorRGBA_setHSV, file);
        newXS("main::SFColorRGBA::getHSV", XS_main__SFColorRGBA_getHSV, file);
        newXS("main::SFColorRGBA::negate", XS_main__SFColorRGBA_negate, file);
        newXS("main::SFColorRGBA::add", XS_main__SFColorRGBA_add, file);
        newXS("main::SFColorRGBA::subtract", XS_main__SFColorRGBA_subtract, file);
        newXS("main::SFColorRGBA::multiply", XS_main__SFColorRGBA_multiply, file);
        newXS("main::SFColorRGBA::lighten", XS_main__SFColorRGBA_lighten, file);
        newXS("main::SFColorRGBA::divide", XS_main__SFColorRGBA_divide, file);
        newXS("main::SFColorRGBA::darken", XS_main__SFColorRGBA_darken, file);
        newXS("main::SFColorRGBA::DESTROY", XS_main__SFColorRGBA_DESTROY, file);
    XSRETURN_YES;
}

