use Test;
BEGIN { plan tests => 68 };
use blib;
use Bot::CPAN;

my $bot = Bot::CPAN->new();
ok(ref $bot, 'Bot::CPAN');
ok($bot->phrase('NO_MODULE', {module => 'Foo::Bar'}),
	'No such module: Foo::Bar');
ok($bot->phrase('NO_DISTRIBUTION', {module => 'Foo-Bar'}),
	'No such distribution: Foo-Bar');
ok($bot->phrase('NO_AUTHOR', {author => 'FOO'}),
	'No such author: FOO');
ok($bot->phrase('CPANRATINGS_DOWN'),
	'cpanratings.perl.org is unavailable');
ok($bot->phrase('Bot::CPAN::author', {author => 'Foo'}), 'Foo');
ok($bot->phrase('Bot::CPAN::botsnack'), ':)');
ok($bot->phrase('Bot::CPAN::_check_module(new)', {module => 'Foo'}), "Foo is a brand new distribution. I'll have details shortly.");
ok($bot->phrase('Bot::CPAN::_check_module(readme)', {module => 'Foo'}), 'No such module (or readme): Foo');
ok($bot->phrase('Bot::CPAN::config(adminhost)', {adminhost => 'foo'}), 'Adminhost: foo');
ok($bot->phrase('Bot::CPAN::config(alt_nicks)', {alt_nicks => 'foo'}), 'Alt Nicks: foo');
ok($bot->phrase('Bot::CPAN::config(channels)', {channels => 'foo'}), 'Channels: foo');
ok($bot->phrase('Bot::CPAN::config(ignore_list)', {ignore_list => 'foo'}), 'Ignore List: foo');
ok($bot->phrase('Bot::CPAN::config(debug)', {debug => 'foo'}), 'Debug: foo');
ok($bot->phrase('Bot::CPAN::config(group)', {group => 'foo'}), 'Group: foo');
ok($bot->phrase('Bot::CPAN::config(inform_channel_of_new_uploads)', {inform_channel_of_new_uploads => 'foo'}), 'Inform Channel of New Uploads Interval: foo');
ok($bot->phrase('Bot::CPAN::config(name)', {name => 'foo'}), 'Name: foo');
ok($bot->phrase('Bot::CPAN::config(news_server)', {news_server => 'foo'}), 'News Server: foo');
ok($bot->phrase('Bot::CPAN::config(nick)', {nick => 'foo'}), 'Nick: foo');
ok($bot->phrase('Bot::CPAN::config(port)', {port => 'foo'}), 'Port: foo');
ok($bot->phrase('Bot::CPAN::config(reload_indices_interval)', {reload_indices_interval => 'foo'}), 'Reload Indice Interval: foo');
ok($bot->phrase('Bot::CPAN::config(search_max_results)', {search_max_results => 'foo'}), 'Search Max Results: foo');
ok($bot->phrase('Bot::CPAN::config(servers)', {servers => 'foo'}), 'Servers: foo');
ok($bot->phrase('Bot::CPAN::config(username)', {username => 'foo'}), 'Username: foo');
ok($bot->phrase('Bot::CPAN::config(last_indice_reload)', {last_indice_reload => 'foo'}), 'Last indice reload: foo');
ok($bot->phrase('Bot::CPAN::description', {description => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::details', {label => 'foo', value => 'bar'}), 'foo: bar');
ok($bot->phrase('Bot::CPAN::distributions(no)', {actual_author => 'foo'}), "Author 'foo' has no distributions");
ok($bot->phrase('Bot::CPAN::distributions(yes)', {rpt => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::docurl', {buffer => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::dlurl', {buffer => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::help(by)', {nick => 'nick', pkg => 'pkg', vers => 'vers'}), 'nick is brought to you by pkg version vers');
ok($bot->phrase('Bot::CPAN::help(both)', {commands => 'commands'}), 'Channel and /msg commands: commands');
ok($bot->phrase('Bot::CPAN::help(channel)', {commands => 'commands'}), 'Channel only commands: commands');
ok($bot->phrase('Bot::CPAN::help(msg)', {commands => 'commands'}), '/msg only commands: commands');
ok($bot->phrase('Bot::CPAN::help(help)', {help => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::language', {language => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::modulelist(no)', {module => 'module'}), 'No, module is not in the module list');
ok($bot->phrase('Bot::CPAN::modulelist(yes)', {module => 'module'}), 'Yes, module is in the module list');
ok($bot->phrase('Bot::CPAN::modules(no)', {actual_author => 'actual_author'}), "Author ID 'actual_author' has no modules");
ok($bot->phrase('Bot::CPAN::modules(yes)', {rpt => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::package', {package => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::path', {CPAN => '$CPAN', path => '/path'}), '$CPAN/authors/id/path');
ok($bot->phrase('Bot::CPAN::readme', {actual => 'actual'}), 'Sending readme for actual..');
ok($bot->phrase('Bot::CPAN::recent(just_got_here)'), 'I just got here. Give me a bit to get settled. :)');
ok($bot->phrase('Bot::CPAN::recent(results)', {results => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::ratings(no_ratings)', {module => 'module'}), 'No ratings for: module');
ok($bot->phrase('Bot::CPAN::ratings(ratings)', {ratings => 'ratings', n => 'n', mean => 'mean', median => 'median', min => 'min', max => 'max', stddev => 'stddev', mode => 'mode'}), 'Recent ratings: ratings; Overall (n=n): mean mean, median median, min min, max max, stddev stddev, mode mode');
ok($bot->phrase('Bot::CPAN::reviews(no_reviews)', {module => 'module'}), 'No reviews for: module');
ok($bot->phrase('Bot::CPAN::reviews(review)', {creator => 'creator', description => 'description', rating => 'rating'}), 'creator: description (rating)');
ok($bot->phrase('Bot::CPAN::rt', {actual => 'actual'}), 'Unable to get url for: actual');
ok($bot->phrase('Bot::CPAN::rt(success)', {buffer => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::search(too_many_matches)', {matches => 'matches', search_max_results => 'search_max_results'}), 'Too many matches matches > search_max_results. Be more specific please');
ok($bot->phrase('Bot::CPAN::search(no_matches)'), 'No matches');
ok($bot->phrase('Bot::CPAN::search(success)', {key => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::stage', {stage => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::status', {requests => 'requests', s => '', start_time => 'start_time'}), 'requests request since I started up at start_time');
ok($bot->phrase('Bot::CPAN::style', {style => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::support', {support => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::tests(no_tests)', {actual => 'actual'}), 'No test reports for: actual');
ok($bot->phrase('Bot::CPAN::tests(summary)', {tests => 'tests', s => '', actual => 'actual'}), 'tests test report for actual');
ok($bot->phrase('Bot::CPAN::tests(test)', {grade => 'foo', platform => 'bar'}), 'foo bar');
ok($bot->phrase('Bot::CPAN::url(unable_to_get_url)', {actual => 'actual'}), 'Unable to get url for: actual');
ok($bot->phrase('Bot::CPAN::url(not_dist)', {author => 'author', package => 'package'}), 'http://search.cpan.org/author/author/package/');
ok($bot->phrase('Bot::CPAN::url(dist)', {dist => 'dist'}), 'http://search.cpan.org/dist/dist/');
ok($bot->phrase('Bot::CPAN::version', {version => 'foo'}), 'foo');
ok($bot->phrase('Bot::CPAN::whois', {name => 'foo', email => 'bar'}), 'foo (bar)');
ok($bot->phrase('Bot::CPAN::wikiurl', {module => 'Module'}), 'http://cpan.japh.org/?Module');
