package Bundle::Modules::Unstable;

use 5.005;

our $VERSION = 2006.0520; ## (YYYY.MMDD)

1;

__END__

=head1 NAME

Bundle::Modules::Unstable - All current I<unstable> bundles of modules in CPAN

=head1 SYNOPSIS

perl -MCPAN -e B<'install Bundle::Modules::Unstable'>

cpan B<-i Bundle::Modules::Unstable>

=head1 CONTENTS

##Bundle::Rose
##Bundle::DateTime::Complete
##Bundle::InterchangeKitchenSink
##Bundle::HTMLWikiConverter
##Bundle::Pugs::SmokeKit
##Bundle::WormBase
##Bundle::Maypole
##Bundle::Wizard::LDAP
##Bundle::W3C::Validator
##Bundle::OS2_default
##Bundle::Schwern
##Bundle::Math::Expression
##Bundle::Catalog
##Bundle::OS2_default4
##Bundle::Delivery
##Bundle::Alphamail
##Bundle::OurNet
##Bundle::WING
##Bundle::CPANPLUS::Test::Reporter
##Bundle::Wizard
##Bundle::Math::Numeric
Bundle::WWW::Scraper::Housing
##Bundle::Sledge::I18N
##Bundle::KohaSupport
##Bundle::BricolagePlus
##Bundle::Sledge
##Bundle::Everything
##Bundle::Math::Interface
##Bundle::MyLibrary
##Bundle::Sites::BetterScm
##Bundle::TreeDumper
##Bundle::MP3
##Bundle::Knetrix
##Bundle::MusicBrainz::Client
##Bundle::Minivend
##Bundle::Egrail
##Bundle::OS2_default7
##Bundle::DBD::JDBC
##Bundle::Test
##Bundle::Lingua::PT
##Bundle::MusicBrainz::Server
##Bundle::PlRPC
##Bundle::CpanTestDummies
##Bundle::Math::Base
##Bundle::RT
##Bundle::myxCal
##Bundle::Combust
##Bundle::Wombat
##Bundle::Bugzilla
##Bundle::Business::Shipping
##Bundle::COG
##Bundle::HTML::Mason
##Bundle::Application::Magic
##Bundle::Devel
##Bundle::Expect
##Bundle::Pgreet
##Bundle::Phalanx100
##Bundle::Ovid
##Bundle::Msql
##Bundle::Tree::Simple
##Bundle::ParallelUA
##Bundle::Zoidberg
##Bundle::OpenSRF
##Bundle::Business::Shipping::UPS_Offline
##Bundle::Olive
##Bundle::Latemp
##Bundle::Tie::FormA
##Bundle::OS2_default6
##Bundle::Search::InvertedIndex
##Bundle::Template::Magic
Bundle::Kwiki
##Bundle::Slash
##Bundle::CPAN
##Bundle::LWP
##Bundle::Math::Calculus
##Bundle::Math::Geometry
##Bundle::DataMint
##Bundle::Xmms
##Bundle::CPANPLUS
##Bundle::OS2_default2
##Bundle::Math::Symbolic
##Bundle::OpenILS
##Bundle::ABH
##Bundle::PPT
##Bundle::Markup
##Bundle::DBD::Informix
##Bundle::SDK::COG
Bundle::POE::All
##Bundle::SNMP::MIB::Compiler
##Bundle::CVSMonitor
##Bundle::BioPerl
##Bundle::SQL::Translator
##Bundle::AMBS
##Bundle::Business::Shipping::USPS_Online
##Bundle::Net::LDAP
##Bundle::OS2_default1
##Bundle::CUFTS
##Bundle::Bricolage
##Bundle::Math::Big
##Bundle::DBD::DB2
##Bundle::ePortal
##Bundle::SNMP::Monitor
##Bundle::HTML::EP
##Bundle::Interchange4
##Bundle::Interchange
##Bundle::DBD::mSQL
##Bundle::CGI::Builder::Complete
##Bundle::Combust::Extras
##Bundle::Perl6
##Bundle::OS2_default1_2
##Bundle::SDK::SIMON
##Bundle::Net::SXIP::Homesite
##Bundle::Net::Nessus
##Bundle::Link_Controller
##Bundle::Query
##Bundle::Tie::DB_File::SplitHash
##Bundle::DBD::InterBase
##Bundle::Text::Query::BuildSQL
##Bundle::ebx
##Bundle::Mail::IspMailGate
##Bundle::Posy
##Bundle::Cisco::Conf
##Bundle::Email
##Bundle::Mysql
##Bundle::SSH
##Bundle::IspMailGate
##Bundle::MMS::Mail::Parser
##Bundle::OS2_default3
##Bundle::XML
##Bundle::BDFOY
##Bundle::libservlet
##Bundle::Business::Shipping::UPS_Online
##Bundle::GMOD
##Bundle::Math::Approx
##Bundle::Math::Fractal
##Bundle::Urchin
##Bundle::Gnome2
##Bundle::DBD::Yaswi
##Bundle::Business::Shipping::Basic
##Bundle::Pipe
##Bundle::libnet
##Bundle::Math::Random
##Bundle::OpenInteract2
##Bundle::perlWebSite
##Bundle::OpenInteract
##Bundle::PerlPoint
##Bundle::LawMonkey
##Bundle::Zavitan
##Bundle::Math::Statistics
##Bundle::Math::Matrix
##Bundle::Math::Financial
##Bundle::Tk_OS2src
##Bundle::SPOPS
##Bundle::CPANPLUS::Dependencies
##Bundle::HTTP::WebTest
##Bundle::QuadPres
##Bundle::DBD::mysql
##Bundle::NiceSleep
Bundle::Cobalt
##Bundle::Starlink::Base
##Bundle::Business::Shipping::DataTools
##Bundle::DBD::CSV
##Bundle::Cascade
##Bundle::Math
##Bundle::OS2_default5
##Bundle::DBI
##Bundle::WWW::Mechanize::Shell
##Bundle::Bonsai
Bundle::WWW::Search::Scraper::Housing

=head1 CHANGES

=over

=item 2006.0510 (YYYY.MMDD)

Initial version of: Bundle::Modules::Unstable-2006.0510

This B<L<Bundle::Modules>> component package is in pre-alpha state with hash ordering.

The ordering of listed modules will eventually be prioritized for efficiency and completeness.

Modules commented out of this module list are either I<unstable> or I<stable> in the B<L<Bundle::Modules>> context.

Optimistically, if there are a lot of the modules commented out, then they are I<stable>, and we're listing I<unstable> context.

Optimistically, if there are a few of the modules commented out, then they are I<unstable>, and we're listing I<stable> context.

If you use the command C<B<man Bundle::Modules::Unstable>>, type C<B</#>> to see the commented out modules as they're higlighted for you by B<man>.

=back

=head1 DESCRIPTION

This Bundle package will install all of the modules listed, if they're not commented out of the B<L<Bundle::Modules>> context.

=head1 SEE ALSO

I<L<Bundle::Modules>>, I<L<Bundle::Modules::CPAN>>, I<L<Bundle::Modules::CPAN::Unstable>>, I<L<Bundle::Modules::Apache>>, I<L<Bundle::Modules::Apache::Unstable>>, I<L<Bundle::Modules::Acme::Everything>>, I<L<Bundle::Modules::Acme::Everything::Unstable>>, I<L<Bundle::Modules::Acme::Everything::Unique>>, I<L<Bundle::Modules::Acme::Everything::Unique::Unstable>>

=head1 AUTHORS

Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>

=head1 LICENSE for http://www.cpan.org/authors/id/E/ER/ERMEYERS/Bundle-Modules-2006.0520

perl

This program is free software; you can redistribute it and/or modify it under the same terms as Perl itself.

=head1 COPYRIGHT

Copyright (C) 2006 by Eric R. Meyers E<lt>ermeyers@adelphia.netE<gt>


