package Settlers::Asset::Road;
$Settlers::Asset::Road::VERSION = '0.07';
use strict;
use warnings;
use Settlers::Resource::Brick;
use Settlers::Resource::Lumber;

sub new
{
  my ($class, $path) = @_;
  die "$class new require a path argument"
    unless $path && $path->isa('Settlers::Map::Path');

  return bless {
    location => $path,
    code     => 'R',
  }, $class;
}

sub code     { $_[0]->{code} }
sub location { $_[0]->{location} }

sub cost
{
  return [
    Settlers::Resource::Brick->new(-1),
    Settlers::Resource::Lumber->new(-1),
  ];
}
1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Settlers::Asset::Road

=head1 VERSION

version 0.07

=head1 AUTHOR

David Farrell <dfarrell@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2015 by David Farrell.

This is free software, licensed under:

  The (two-clause) FreeBSD License

=cut
