use strict;
use warnings;
use utf8;

package SDK::SoundCloud::OAuth2Token;

use Moo::Role;
use namespace::clean;

use Params::Validate qw(:all);

requires 'client_id';

has 'path' => (
    is => 'ro',
    default => sub {
        return '/oauth2/token';
    }
);

sub get_token {
    my $self = shift @_;
    my %params = validate(
        @_, {
        client_secret => { type => SCALAR  },
        redirect_uri => { type => SCALAR },
        code => { type => SCALAR },
        grant_type => {
            isa => SCALAR,
            default => 'authorization_code', 
            callbacks => {
                'g type' => sub {
                    return $_[0] if $_[0] =~ /^authorization_code|refresh_token|password|client_credentials|oauth1_token$/;
                }
            }
        }
    });

    $params{client_id} = $self->client_id;

    my $response = 
        $self->req({ 
            method => 'POST', 
            path => $self->path,
            data => \%params,
    });

    $self->token($response->{access_token});

    return $response;
}

1;
