# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..4\n"; }
END {print "not ok 1\n" unless $loaded;}
use Tk ;
use ExtUtils::testlib ; 
use Tk::ObjEditor ;
$loaded = 1;
my $idx = 1;
print "ok ",$idx++,"\n";
my $trace = shift || 0 ;

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

package Toto ;

sub new
  {
    my $type = shift ;
    my $tkstuff = shift ;
    my $scalar = 'dummy scalar ref value';
    my $self = 
      {
       'key1' => 'example of value for key1',
       'array' => [qw/a b sdf/, {'v1' => '1', 'v2' => 2},'dfg'],
       'key2' => {
                  'sub key1' => 'sv1',
                  'sub key2' => 'sv2'
                 },
       'piped|key' => {a => 1 , b => 2},
       'scalar_ref_ref' => \\$scalar,
       'empty string' => '',
       'pseudo hash' => [ { a => 1, b => 2}, 'a value', 'bvalue'],
       'non_empty string' => ' ',
       'long' => 'very long line'.'.' x 80 ,
       'is undef' => undef,
       'some text' => "some \n dummy\n Text\n"
      } ;
    bless $self,$type;
  }


package main;

use strict ;
my $toto ;
my $mw = MainWindow-> new ;

my $w_menu = $mw->Frame(-relief => 'raised', -borderwidth => 2);
$w_menu->pack(-fill => 'x');

my $f = $w_menu->Menubutton(-text => 'File', -underline => 0) 
  -> pack(side => 'left' );
$f->command(-label => 'Quit',  -command => sub{$mw->destroy;} );

print "creating dummy object \n" if $trace ;
my $dummy = new Toto ($mw);

print "ok ",$idx++,"\n";

print "Creating some obj monitors\n" if $trace ;

$mw->Label (text => "use right button to get editor menu")->pack;
my $fm = $mw ->Frame;
$fm -> pack;
$fm -> Label (text => 'Monitoring hash->{key1} value:')
  ->pack(qw/-side left/);
my $mon =
  $fm->Label(textvariable => \$dummy->{key1})->pack(qw/-side left/);

print "Creating obj editor\n" if $trace ;
my $objEd = $mw -> ObjEditor
  (
   'caller' => $dummy,
   direct => 1 ,
   #destroyable => 0,
   title => 'test editor'
  )
  -> pack(expand => 1, fill => 'both') ;

print "ok ",$idx++,"\n";

MainLoop ; # Tk's

print "ok ",$idx++,"\n";

